/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Component, Config } from "@intermesh/goui";
/**
 * Image component
 *
 * Uses the fetch API to fetch the image with an Authorization header and creates an objectURL using URL.createObjectURL()
 */
export declare class Image extends Component {
    blobId: string;
    constructor();
    private static cache;
    private static defaultSrc;
    protected internalRender(): HTMLElement;
    setBlobId(blobId: string): void;
    static replace(html: string): Component;
    /**
     * Replaces all img tags with a blob ID source from group-office with an objectURL
     *
     * @param el
     * @return Promise that resolves when all images are fully loaded
     */
    static replaceImages(el: HTMLElement): Promise<any[]>;
}
/**
 * Shorthand function to create table
 *
 * @param config
 */
export declare const img: (config?: Config<Image>) => Image;
//# sourceMappingURL=Image.d.ts.map