/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Config } from "../Observable";
import { FieldEventMap } from "./Field";
import { TimeField } from "./TimeField";
/**
 * Date field
 *
 * @see Form
 */
export declare class DateField extends TimeField {
    protected baseCls: string;
    private oldTime;
    constructor();
    /**
     * Also render time input
     *
     * @param withTime
     */
    set withTime(withTime: boolean);
    get withTime(): boolean;
}
/**
 * Shorthand function to create {@see DateField}
 *
 * @param config
 */
export declare const datefield: (config?: Config<DateField, FieldEventMap<DateField>>) => DateField;
//# sourceMappingURL=DateField.d.ts.map