/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Michael de Hart <mdhart@intermesh.nl>
 */
import { Field } from "./Field.js";
import { createComponent } from "../Component.js";
export class MapField extends Field {
    constructor(buildField) {
        super('div');
        this.buildField = buildField;
        this.baseCls = "";
        this._nextKey = 0;
        this.cls = "vbox gap";
    }
    renderControl() {
        // empty
    }
    set value(v) {
        super.value = v;
        this.items.clear();
        if (v) {
            for (const key in v) {
                this.internalAdd(v[key], key);
            }
        }
    }
    get value() {
        const v = {};
        this.items.forEach((field) => {
            if (field instanceof Field) {
                const rowValue = field.value;
                let key = field.dataSet.key;
                if (this.keyFieldName && rowValue[this.keyFieldName]) {
                    key = rowValue[this.keyFieldName];
                    delete rowValue[this.keyFieldName];
                }
                v[key] = rowValue;
            }
        });
        return v;
    }
    isEmpty() {
        return this.items.count() === 0;
    }
    /**
     * Add value to the map.
     *
     * Also fires change event
     *
     * @param data
     * @param key
     */
    add(data, key) {
        if (!this.valueOnFocus) {
            this.captureValueForChange();
        }
        this.internalAdd(data, key);
        this.fireChange();
    }
    internalAdd(data, key) {
        if (typeof key === 'number') {
            this._nextKey = Math.max(this._nextKey, key);
        }
        const field = this.buildField(data);
        field.dataSet.key = key || this.nextKey();
        field.value = data;
        this.items.add(field);
    }
    nextKey() {
        // only works if sorted by key
        // todo: maybe use GUID for item with sortOrder?
        return ++this._nextKey;
    }
    reset() {
        super.reset();
        this.items.clear();
    }
}
export const mapfield = (config, ...items) => createComponent(new MapField(config.buildField), config, items);
//# sourceMappingURL=MapField.js.map