/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { createComponent } from "../Component.js";
import { InputField } from "./InputField";
/**
 * TextField component
 *
 * @see Form
 */
export class TextField extends InputField {
    constructor() {
        super();
        this.baseCls = 'goui-form-field text';
        this.type = "text";
    }
    /**
     * The input type
     *
     * @link https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/text
     * @param type
     */
    set type(type) {
        super.type = type;
    }
    get type() {
        return super.type;
    }
    /**
     * Pattern regex for validation
     *
     * @link https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/pattern
     *
     * @param pattern
     */
    set pattern(pattern) {
        this.input.pattern = pattern;
    }
    get pattern() {
        return this.input.pattern;
    }
}
/**
 * Shorthand function to create {@see TextField}
 *
 * @param config
 */
export const textfield = (config) => createComponent(new TextField(), config);
//# sourceMappingURL=TextField.js.map