/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { Config, Observable } from "../Observable.js";
import { Table } from "./Table.js";
import { Component } from "../Component.js";
type TableColumnRenderer = (columnValue: any, record: any, td: HTMLTableCellElement, table: Table, storeIndex: number) => string | Promise<string> | Component | Promise<Component>;
type HeaderRenderer = (col: TableColumn, headerEl: HTMLTableCellElement, table: Table) => string | Component;
export type align = "left" | "right" | "center";
export declare class TableColumn extends Observable {
    id: string;
    parent: Table | undefined;
    /**
     *
     * The column ID. Also used for 'property'
     */
    constructor(id: string);
    /**
     * Path to property. If not given then 'id' is used
     *
     * @see ObjectUtil.path()
     */
    property: string;
    /**
     * Header in the table
     */
    header?: string;
    /**
     * Renderer function for the display
     */
    renderer?: TableColumnRenderer;
    /**
     * Renderer function for the header
     */
    headerRenderer?: HeaderRenderer;
    /**
     * Make the column resizable by the user
     */
    resizable: boolean;
    /**
     * Make it sortable by the user
     */
    sortable: boolean;
    /**
     * Width in pixels
     */
    width?: number;
    /**
     * Text alignment
     */
    align: align;
    /**
     * Hide the column. It can be enabled by the user via the context menu.
     */
    hidden: boolean;
    /**
     * Enable this column in the enabled columns menu
     */
    hidable: boolean;
    /**
     * When rendered this is set to the DOM element.
     * It's used to update the header width
     */
    headerEl?: HTMLTableCellElement;
    /**
     * Add CSS classes
     */
    cls?: string;
}
type TableColumnConfig = Config<TableColumn> & {
    /**
     * The ID of the column which is also the default for the column 'property'
     */
    id: string;
};
/**
 * Create a table column
 *
 * @param config
 */
export declare const column: (config: TableColumnConfig) => TableColumn;
export declare class DateTimeColumn extends TableColumn {
    renderer: (date: string) => string;
    align: align;
    width: number;
}
/**
 * Create a column showing date and time
 * @param config
 */
export declare const datetimecolumn: (config: TableColumnConfig) => DateTimeColumn;
export declare class DateColumn extends TableColumn {
    renderer: (date: string) => string;
    align: align;
    width: number;
}
/**
 * Create a column showing just a date
 *
 * @param config
 */
export declare const datecolumn: (config: TableColumnConfig) => DateColumn;
export declare class CheckboxColumn extends TableColumn {
    constructor(id: string);
    renderer: (val: boolean) => import("../form").CheckboxField;
}
/**
 * Create a checkbox column
 *
 * @param config
 */
export declare const checkboxcolumn: (config: TableColumnConfig) => CheckboxColumn;
export declare class CheckboxSelectColumn extends TableColumn {
    constructor(id?: string);
    headerRenderer: HeaderRenderer;
    renderer: TableColumnRenderer;
}
export declare const checkboxselectcolumn: (config?: TableColumnConfig) => CheckboxSelectColumn;
/**
 * Creates a menu button.
 *
 * All items will have a property dataSet.rowIndex and dataSet.table so you know which record has been clicked on.
 *
 * @param items
 */
export declare const menucolumn: (...items: Component[]) => TableColumn;
export {};
//# sourceMappingURL=TableColumns.d.ts.map