Ext.define('go.modules.business.business.BusinessGrid',{
	extend: go.grid.GridPanel,

	autoExpandColumn: 'name',
	columns:[{
		header: t('ID'),
		width: dp(80),
		dataIndex: 'id',
		hidden:true,
		align: "right"
	},{
		header: t('Name'),
		dataIndex: 'name',
		id: 'name'
	}],

	initComponent: function() {
		const rights = go.User.capabilities['go:business:business'] || {};

		this.store = new go.data.Store({
			fields: ['name','id'],
			sort: [{property: "name"}],
			entityStore: "Business"
		});
		this.tbar = [{
			xtype: 'tbtitle',
			text: t("Businesses")
		},'->',{
			iconCls: "ic-add",
			handler: function() {
				var dlg = new go.modules.business.business.BusinessDialog();
				dlg.show();
			},scope: this
		}];
		this.listeners = {
			rowdblclick: function (grid, rowIndex, e) {

				var record = grid.getStore().getAt(rowIndex);
				var dlg = new go.modules.business.business.BusinessDialog();
				dlg.load(record.id).show();

			},
			scope:this
		};

		this.callParent();



	}
});