go.modules.business.catalog.ArticleGrid = Ext.extend(go.grid.GridPanel, {
	initComponent: function () {
		this.frontendConfig = go.modules.business.catalog.ModuleConfig.frontendOptions;

		this.store = new go.data.Store({
			fields: [
				'id',
				'number',
				'name',
				'description',
				{name: 'cost', type: 'float'},
				{name: 'price', type: 'float'},
				'vatRateId',
				{name: 'supplier', type: "relation"},
				'supplierNumber',
				{name: 'createdAt', type: 'date'},
				{name: 'modifiedAt', type: 'date'},
				{name: 'creator', type: "relation"},
				{name: 'modifier', type: "relation"},
				'permissionLevel'
			],
			entityStore: "Article"
		});

		Ext.apply(this, {
			columns: [{
				id: 'id',
				header: "ID",
				width: dp(80),
				sortable: true,
				hidden: true,
				dataIndex: 'id'
			},{
				id: 'number',
				header: t('Number'),
				width: dp(80),
				sortable: true,
				dataIndex: 'number'
			},{
				id: 'name',
				header: t('Name'),
				width: dp(160),
				sortable: true,
				dataIndex: 'name'
			},{
				id: 'cost',
				header: t('Cost'),
				width: dp(160),
				sortable: true,
				dataIndex: 'cost',
				xtype: "valutacolumn"

			},{
				id: 'price',
				header: t('Price'),
				width: dp(160),
				sortable: true,
				dataIndex: 'price',
				xtype: "valutacolumn"
			},{
				id: 'supplier',
				header: t('Supplier'),
				width: dp(160),
				sortable: true,
				dataIndex: 'supplier',
				renderer: function(v) {
					return v ? v.name : "";
				}
			},{
				id: 'supplierNumber',
				header: t('Supplier number'),
				width: dp(160),
				sortable: true,
				dataIndex: 'supplierNumber'
			},{
				hidden: !this.frontendConfig.showCreator,
				id: 'showCreator',
				header: t('Created by'),
				width: dp(160),
				sortable: true,
				dataIndex: 'creator',
				renderer: function(v) {
					return v ? v.displayName : "-";
				}
			},{
				xtype:"datecolumn",
				id: 'showCreationDate',
				header: t('Created at'),
				width: dp(160),
				sortable: true,
				dataIndex: 'createdAt',
				hidden: !this.frontendConfig.showCreationDate
			},{
				hidden: !this.frontendConfig.showModifier,
				header: t('Modified by'),
				width: dp(160),
				sortable: true,
				id: 'showModifier',
				dataIndex: 'modifier',
				renderer: function(v) {
					return v ? v.displayName : "-";
				}
			},{
				xtype:"datecolumn",
				hidden: !this.frontendConfig.showModificationDate,
				id: 'showModificationDate',
				header: t('Modified at'),
				width: dp(160),
				sortable: false,
				dataIndex: 'modifiedAt'
			}],
			viewConfig: {
				totalDisplay: this.frontendConfig.showTotals,
				emptyText: 	'<i>description</i><p>' +t("No items to display") + '</p>'
			},
			stateful: true,
			stateId: 'Article-grid'
		});

		go.modules.business.catalog.ArticleGrid.superclass.initComponent.call(this);
	}
});

