go.Modules.register("business", "contracts", {
	mainPanel: "go.modules.business.contracts.MainPanel",
	title: t("Contracts"),
	entities: [
		{
			name: "ContractBook",
			relations: {
				business: {store: "Business", fk: "businessId"},
			}
		},

		{
		name: "Contract",
		relations: {
			book: { store: "ContractBook", fk: "bookId" },
			creator: { store: "User", fk: "createdBy" },
			modifier: { store: "User", fk: "createdBy" }
		},
		filters: [{
			name: 'text',
			type: "string",
			multiple: false,
			title: t("Query")
		},{
			title: t("Modified at"),
			name: 'modifiedat',
			multiple: false,
			type: 'date'
		},{
			title: t("Modified by"),
			name: 'modifiedBy',
			multiple: true,
			type: 'string'
		},{
			title: t("Created at"),
			name: 'createdat',
			multiple: false,
			type: 'date'
		},{
			title: t("Created by"),
			name: 'createdby',
			multiple: true,
			type: 'string'
		},{
			title: t("Starts at"),
			name: 'startsAt',
			multiple: false,
			type: 'date'
		},{
			title: t("Ends at"),
			name: 'endsAt',
			multiple: false,
			type: 'date'
		}, {
			title: t("Active"),
			name: 'active',
			multiple: false,
			type: 'select',
			options: [{
				value: null,
				title: t("Not set")
			},{
				value: 1,
				title: t("Yes")
			},{
				value: -1,
				title: t("No")
			}]
		},{
			title: t("Active at"),
			name: 'activeAt',
			multiple: false,
			type: 'date'
		},{
			title: t("Next at"),
			name: 'nextat',
			multiple: false,
			type: 'date'
		},{
			title: t("Customer"),
			name: 'customerid',
			multiple: false,
			type: 'contactcombo',
			typeConfig: {
				isCustomer: true
			}
		}

		// 	{
		// 	title: t("Document type"),
		// 	name: 'documentType',
		// 	multiple: false,
		// 	type: 'select',
		// 	options: [
		// 		{value: 'quote', title: t('Quotes')},
		// 		{value: 'salesorder', title:t('Sales orders')},
		// 		{value: 'purchaseorder', title:t('Purchase orders')},
		// 		{value: 'purchaseinvoice', title:t('Purchase invoices')},
		// 		{value: 'salesinvoice', title:t('Sales invoices')},
		// 		{value: 'payments', title:t('Payments')}
		// 	]
		// }
		],
		links: [{
			iconCls: 'entity ic-note',
			linkWindow: function (entity, entityId) {
				return new go.modules.business.contracts.ContractDialog();
			},
			linkDetail: function () {
				return new go.modules.business.contracts.ContractDetail();
			}
		}]
	}],
	initModule: function () {
		go.Alerts.on("beforeshow", function (alerts, alertConfig) {
			const alert = alertConfig.alert;
			if (alert.entity == "Invoice") {

				switch(alert.tag) {
					case "contractsent":
						//replace panel promise
						alertConfig.panelPromise = alertConfig.panelPromise.then(async (panelCfg) => {

							let assigner;
							try {
								assigner = await go.Db.store("UserDisplay").single(alert.data.assignedBy);
							} catch (e) {
								assigner = {displayName: t("Unknown user")};
							}

							panelCfg.items = [{html: go.util.Format.dateTime(alert.triggerAt) + ": " + t("You were assigned to this task by {assigner}").replace("{assigner}", assigner.displayName)}];
							panelCfg.notificationBody = panelCfg.html;
							return panelCfg;

						});
						break;

					case "contractcreate":

						break;
				}

			}
		});

		async function showBadge() {
			const count = await go.Jmap.request({method: "Contract/countDue"});
			GO.mainLayout.setNotification('contracts', count,'orange');

			GO.mainLayout.getModulePanel("contracts").setDue(count);
		}



		GO.mainLayout.on("authenticated", () => {

			if(go.Modules.isAvailable("business", "contracts")) {
				showBadge();

				go.Db.store("Contract").on("changes", () => {
					showBadge();
				});
			}
		})
	}
});

go.modules.business.contracts.util = {

	humanStatus: function (id) {
		return t(id.ucFirst());
	},

	getStatus : function(doc) {
		const now = new Date();

		if ( doc.endsAt && new Date(doc.endsAt)< now) {
			return "complete";
		}

		if(new Date(doc.startsAt) > now) {
			return "scheduled";
		}

		return "active";

	},

	getStatusBadge: function (doc, cls) {
		if (!cls) {
			cls = "right";
		}
		const id = this.getStatus(doc);
		return '<div class="status business-contract-status-' + id + ' ' + cls + '">' + this.humanStatus(id) + '</div>';
	}
}
