<?php

namespace go\modules\business\fileconverter;

use go\core;
use go\modules\business\fileconverter\model\Settings;
use go\modules\business\fileconverter\service\IService;

/**
 * Class Module
 * @package go\modules\business\onlyoffice
 */
class Module extends core\Module
{
	/**
	 * The development status of this module
	 * @return string
	 */
	public function getStatus() : string{
		return self::STATUS_STABLE;
	}

	public function requiredLicense(): ?string
	{
		return 'groupoffice-pro';
	}

	public function getAuthor(): string
	{
        return 'Michal Charvat <info@michalcharvat.cz>';
    }

    public function depends()
    {
        return array('files');
    }

    public function getSettings()
    {
        return Settings::get();
    }

    /**
     * @return IService
     */
    public static function getAvailableService()
    {
        $serviceType = Settings::get()->serviceType;
        if (empty($serviceType)) {
            throw new \RuntimeException('Missing module configuration - serviceType');
        }

        $serviceClass = __NAMESPACE__ . '\\service\\' . ucfirst($serviceType);
        if (!class_exists($serviceClass)) {
            throw new \RuntimeException('Service class is not available ' . $serviceClass);
        }

        return new $serviceClass;
    }
}