go.modules.business.finance.FinanceDocumentCombo = Ext.extend(go.form.ComboBox, {
	fieldLabel: t("Document"),
	hiddenName: 'documentId',
	anchor: '100%',
	emptyText: t("Please select..."),
	pageSize: 50,
	valueField: 'id',
	displayField: 'number',
	triggerAction: 'all',
	editable: true,
	selectOnFocus: false,
	forceSelection: true,

	initComponent: function () {

		Ext.applyIf(this, {
			store: new go.data.Store({
				fields: [
					'id',
					"number",
					"customer",
					"customerId",
					"businessId",
					"sentAt",
					"completedAt",
					"expiresAt",
					"type",
					"totalPrice",
					"status",
					{name: "book", type: "relation"}
				],
				entityStore: "FinanceDocument",
				sortInfo: {
					field: "number",
					direction: 'DESC'
				}
			})
		});

		this.tpl = new Ext.XTemplate(
			'<tpl for=".">',
			'<div class="x-combo-list-item">',
			'{number} - {customer} - {[go.util.Format.valuta(values.totalPrice)]} {[go.modules.business.finance.util.getStatusBadge(values, "", values.book)]}',
			'</div>',
			'</tpl>'
		);

		go.modules.business.finance.FinanceDocumentCombo.superclass.initComponent.call(this);

	}
});

Ext.reg("financedocumentcombo", go.modules.business.finance.FinanceDocumentCombo);
