go.modules.business.finance.MonthlyReportWindow = Ext.extend(go.Window, {

	title: t("Monthly report"),
	layout: "fit",
	width: dp(1200),
	height: dp(600),
	initComponent: function() {
		this.currency = go.User.currency;

		this.tbar = [
			this.previousYearBtn = new Ext.Button({
				iconCls: 'ic-chevron-left',
				handler: function() {
					this.yearField.setValue(parseInt(this.yearField.getValue()) - 1);
				},
				scope: this
			}),
			this.yearField = new Ext.form.TextField({
				readonly: true,
				width: dp(80),
				style: "text-align: center",
				listeners: {
					setvalue: this.onChange,
					scope: this
				}
			}),
			this.nextYearBtn = new Ext.Button({
				iconCls: 'ic-chevron-right',
				handler: function() {
					this.yearField.setValue(parseInt(this.yearField.getValue()) + 1);
				},
				scope: this
			})

		];

		this.items = [
			this.chart = new go.chart.BarChart({
				width: "auto",
				options: {
					seriesBarDistance: dp(16),
					axisX: {
						offset: dp(48),
					},
					axisY: {
						offset: dp(80),
						labelInterpolationFnc: function(value) {
							return value > 1000 ? (value / 1000) + "k" : value;
						},
						scaleMinSpace: dp(16)
					},
					plugins: [
						Chartist.plugins.tooltip({
							currency: this.currency+" "
						})
					]
				}
			})
		];

		this.bbar = [
			this.totalField = new Ext.form.Label()
		];

		go.modules.business.finance.MonthlyReportWindow.superclass.initComponent.call(this);
	},

	load: async function(bookId, year) {
		this.bookId = bookId;
		const book = await go.Db.store("FinanceBook").single(bookId);
		this.yearField.setValue(year);
		this.setTitle(t("Monthly report") + " - " + book.name);
		this.currency = book.currency;
	},

	onChange: function(field, year) {
		Promise.all([
			go.Jmap.request({
				method: "FinanceDocument/monthlyTotals",
				params: {
					bookId: this.bookId,
					year: year -1,
					documentType: this.documentType
				}
			})
		,
		go.Jmap.request({
			method: "FinanceDocument/monthlyTotals",
			params: {
				bookId: this.bookId,
				year: year,
				documentType: this.documentType
			}
		})
		]).then((totals) => {

			const series = [0,0,0,0,0,0,0,0,0,0,0,0], lastYearSeries = [0,0,0,0,0,0,0,0,0,0,0,0], m = Object.values(t('short_months')), labels = [
				m[0],
				m[1],
				m[2],
				m[3],
				m[4],
				m[5],
				m[6],
				m[7],
				m[8],
				m[9],
				m[10],
				m[11]
			];

			let total = 0, count = 0;

			totals[0].forEach((rec) => {
				lastYearSeries[rec.month - 1] = rec.subtotal;
			});

			totals[1].forEach((rec) => {
				series[rec.month - 1] = rec.subtotal;

				total += rec.subtotal;

				count+= rec.count;

				labels[rec.month - 1] += "\n" + go.util.Format.number(rec.subtotal, 0);
			});

			this.chart.update([lastYearSeries, series], labels);

			this.totalField.setText(t("Total") + ": " + this.currency + " " +go.util.Format.number(total,2) + ", " + t("Invoice count")+ ": " + count, false);

		});
	}
});
