/**
 * Copyright Intermesh
 *
 * This file is part of Group-Office. You should have received a copy of the
 * Group-Office license along with Group-Office. See the file /LICENSE.TXT
 *
 * If you have questions write an e-mail to info@intermesh.nl
 *
 * @version $Id: ResourceDialog.js 23462 2018-03-06 11:37:47Z mschering $
 * @copyright Copyright Intermesh
 * @author Michael de Hart <mdhart@intermesh.nl>
 */
GO.projects2.ResourceDialog = Ext.extend(GO.dialog.TabbedFormDialog, {

    template: false,

	// template model for display options
	templateData: null,

	initComponent: function() {
		this.useExternalFee = true;
		var relatedIdField = this.relatedIdField = this.template?'template_id':'project_id';
		var controllerRoute = this.template?'projects2/defaultResource':'projects2/resource';
		
		Ext.apply(this, {
			closeAction:'close',
			layout: 'fit',
			title: t("Resource", "projects2"),
			width: 630,
			height: this.template?320:620,
			resizable: true,
			formControllerUrl: controllerRoute
		});

		this.supr().initComponent.call(this);

		//this.buttons.unshift(new Ext.Toolbar.Fill(), new Ext.Button({text: 'test'}));
	},
	startBudget: 0,
	afterLoad : function(remoteModelId, config, action){
    	if(action.result.data.user_id) {
    		go.Db.store('User').get([action.result.data.user_id], function(user) {
				this.employee = user[0].employee;
			},this);
		}

		this.setPermissionLevel(action.result.data.permission_level);
		
		if(action.result.data.project_id){
			this.populateExternalRates(action.result.data.externalRates || []);
			this.applyToExistingCheck.setVisible(false);
			this.startBudget = this.budgetedHoursField.getValue() || 0;
			var me = this;
			go.Db.store('Project').single(action.result.data.project_id).then(function(entity){
				// Hackish solution in order to prevent timing issues
				if(entity.max_budgeted_units) {
					me.setMaxBudgetedHours(entity.max_budgeted_units);
				}
				// Not-billable projects should not use external fees.
				if(entity.income_type === 3) { // === PROJECT::INCOME_NOT_BILLABLE
					me.useExternalFee = false;
					me.extFeeComposite.hide();
					me.externalRateGrid.hide();
				}
			});
		} else {
			this.applyToExistingCheck.setVisible(true);
		}
	},

	setMaxBudgetedHours: function(i) {
    	this.showConfig.maxBudgetedHours = i;
	},
	
	setPermissionLevel : function(permissionLevel) {
		var hasFinance = permissionLevel >= GO.projects2.permissionLevelFinance;
		
		this.externalRateGrid.setVisible(hasFinance);
		this.extFeeComposite.setVisible(hasFinance);
		this.intFeeComposite.setVisible(hasFinance);
	},
	
	afterShowAndLoad : function(remoteModelId, config, result){
		if(this.selectTimeUser.store.baseParams[this.relatedIdField] != config.loadParams[this.relatedIdField]){
			this.selectTimeUser.store.baseParams[this.relatedIdField] = config.loadParams[this.relatedIdField];
			delete this.selectTimeUser.lastQuery;
		}
	},
	
	beforeSubmit : function(params){
		rates = [];
		this.externalRateStore.each(function(record){
			rates.push(record.data);
		},this);
		params.externalRates = Ext.encode(rates);
		if (this.showConfig.loadParams.project_id) {
			var projectId = this.showConfig.loadParams.project_id;

			// Get max_budgeted_hours from project, Get total budgeted hours
			var totalBudgetedHours = (this.showConfig.totalBudgetedHours || 0) + (this.budgetedHoursField.getValue() - this.startBudget),
				maxBudgetedHours = this.showConfig.maxBudgetedHours || 0;

			if (maxBudgetedHours > 0 && totalBudgetedHours > maxBudgetedHours) {
				window.alert(t('This change exceeds the maximum budgeted hours ({amount}). Raise the limit first').replace('{amount}',maxBudgetedHours ));
				return false;
			}
		}
		GO.projects2.ResourceDialog.superclass.beforeSubmit.call(this, params);
	},
	
	populateExternalRates : function(items){
		this.externalRateStore.removeAll();
		for(var i=0; i < items.length; i++){
			if(items[i].activity_name) {
				var r = new Ext.data.Record({
					external_rate: this.useExternalFee ? items[i].external_rate : 0,
					activity_id: items[i].activity_id,
					activity_name: items[i].activity_name
				});
			}

			this.externalRateGrid.stopEditing();
			this.externalRateStore.insert(0, r);
		}
		this.filterUnused(this.unusedActivitiesStore);
	},
	
	filterUnused: function(store) {
		store.filterBy(function(record, id) {
			if(record.data.billable === 0){
				return false;
			}
			return this.externalRateStore.find('activity_id', id) === -1;
		},this);
	},
	
	buildForm: function() {
        
		this.externalRateStore = new Ext.data.ArrayStore({
			id: 'activity_id',
			fields: ['activity_name', 'external_rate','activity_id'],
			data : []
		});
		
		var unusedActivitiesStore = this.unusedActivitiesStore = new go.data.Store({
			fields: [
				'id',
				{name: 'code', type: 'string'},
				{name: 'name', type: 'string'},
				{name: 'description', type: 'string'},
				{name: 'units', type: 'float'},
				{name: 'billable', type: 'int'},
				{name: 'disabled', type: 'boolean'}
			],
			sortInfo :{field: "id", direction: "DESC"},
			entityStore: "Activity",
		});


		unusedActivitiesStore.on('load', function(store, records, options){
			store.filterBy(function(record, id) {
				if(record.data.billable === 0){
					return false;
				}
				return this.externalRateStore.find('activity_id', id) === -1;
			},this);
		},this);
		//unusedActivitiesStore.load();
		
		this.externalRateGrid = new Ext.grid.EditorGridPanel({
					title: t('External rate per activity'),
					clicksToEdit: 1,
					hidden: this.template,
					height: 300,
					store: this.externalRateStore,
					viewConfig: {
						forceFit: true,
						emptyText: t('No rate per activity configured')
					},
					cm: new Ext.grid.ColumnModel({
						defaults: {
							sortable: false
						},
						columns: [{
							header: t('Activity'),
							name: 'activity_name'
						},{
							header: t('Rate'),
							align: 'right',
							dataIndex: 'external_rate',
							renderer: GO.util.format.valuta,							
							editor: new GO.form.NumberField({
								serverFormats: false
							})
						}]
					}),
					tbar: [{
						xtype:'gocombo',
						editable: false,
						displayField: 'name',
						valueField: 'id',
						width:dp(180),
						forceSelection: true,
						triggerAction: 'all',
						listWidth: 400,
						store: unusedActivitiesStore,
						//value: t('Add'),
						listeners: {
							afterRender: cb => { cb.setRawValue(t('Add')); },
							blur: function(cb) { cb.setRawValue(t('Add')); return false;},
							expand: function(cb) {
								this.filterUnused(cb.store);
							},
							select: function(cb, record) {
								this.externalRateGrid.stopEditing();
								this.externalRateGrid.store.insert(0, new Ext.data.Record({
									activity_id: record.data.id,
									activity_name: record.data.name,
									external_rate: ''
								}));
								this.externalRateGrid.startEditing(0, 1);
								
								cb.setRawValue(t('Add'));
							},
							scope: this
						},
					},' ',{
						iconCls: 'ic-delete',
						text: t('Delete'),
						handler: function () {
							var sel = this.externalRateGrid.selModel.getSelectedCell();
							if (sel) {
								this.externalRateGrid.store.removeAt(sel[0]);
								this.filterUnused(unusedActivitiesStore);
							}
						},
						scope: this
					}]
				});
		this.budgetedHoursField = new GO.form.NumberField({
			fieldLabel: t("Budgeted", "projects2"),
			name: 'budgeted_units',
			width:dp(160),
			suffix: t('Hours'),
			decimals: 0,
			allowBlank: false
		});
				
		this.applyToExistingCheck = new Ext.ux.form.XCheckbox({
				boxLabel: t("Apply to all existing projects with this template.", "projects2"),
				name: 'apply_to_existing',
				value: false
			});		
				
		this.formPanel = new Ext.Panel({
			autoScroll:true,
			cls: 'go-form-panel',
			layout: 'form',
			labelWidth: 120,
			items: [
				this.selectTimeUser = new go.modules.business.business.EmployeeCombo({
					hiddenName:'user_id',
					listWidth: 300,
					anchor: '-20',
					typeAhead: true,
					editable:true,
					listeners:{
						scope:this,
						select:function(cb, record){
							this.employee = record.json.employee;
							this.employee_internal_fee = this.employee.hourlyCosts;
							if(this.useExternalFee) {
								this.formPanel.form.findField('external_fee').setValue(go.util.Format.number(record.json.employee.hourlyRevenue));
							}
							this.formPanel.form.findField('internal_fee').nextSibling().setValue(go.util.Format.number(record.json.employee.hourlyCosts));
							this.externalRateStore.removeAll();
							var items = record.json.employee.activityRates;
							go.Db.store('Activity').get(items.map(i => i.activityId), function(activities) {
								for(let i = 0; i < activities.length; i++) {
									var r = new Ext.data.Record({
										external_rate: this.useExternalFee ? items[i].externalRate : 0,
										activity_id: items[i].activityId,
										activity_name: activities[i].name
									});
									this.externalRateGrid.stopEditing();
									this.externalRateStore.insert(0, r);
								}
								this.filterUnused(this.unusedActivitiesStore);
							},this);
						}
					},
				}),
				this.extFeeComposite = new Ext.form.CompositeField({
					itemId: 'extFeeCont',
					xtype: 'compositefield',
					fieldLabel: t("External fee", "projects2"),
					items: [
						{
							xtype: 'numberfield',
							width:dp(140),
							name: 'external_fee'
						},{
							xtype:'button',
							tooltip: t('Set default employee rate', 'projects2'),
							iconCls: 'ic-settings-backup-restore',
							handler: function(btn) {
								if(this.employee && this.employee.hourlyRevenue) {
									btn.previousSibling().setValue(go.util.Format.number(this.employee.hourlyRevenue));
								}
							},
							scope:this
						},{
							xtype: 'xcheckbox',
							boxLabel: t("Use overtime rates", "projects2"),
							name: 'apply_external_overtime'
						}
					]
				}),
				this.intFeeComposite = new Ext.form.CompositeField({
					itemId: 'intFeeCont',
					xtype: 'compositefield',
					fieldLabel: t("Internal fee", "projects2"),
					items: [
						{
							xtype:'hidden',
							name: 'internal_fee',
							listeners: {
								setvalue: function(me, value) {
									if(Ext.isEmpty(value)) {
										me.nextSibling().nextSibling().setText(t('Override rate', 'projects2'));
										me.nextSibling().disable();
										me.nextSibling().setValue(go.util.Format.number(this.employee_internal_fee));
									} else {
										me.nextSibling().nextSibling().setText(t('Don\'t override', 'projects2'));
										me.nextSibling().enable();
										me.nextSibling().setValue(value);
									}

								},scope:this
							}
						},{
							xtype: 'numberfield',
							disabled: true,
							listeners: {
								change: function(me, newVal) {
									me.previousSibling().setValue(newVal);
								}
							},
							width:dp(140)
						},{
							xtype:'button',
							text: t('Tarief overschrijven'),
							tooltip: t('Set default employee rate', 'projects2'),
							//iconCls: 'ic-settings-backup-restore',
							handler: function(btn) {
								var internalFeeField = this.formPanel.form.findField('internal_fee');

								if (!internalFeeField.getValue()) {
									internalFeeField.setValue(go.util.Format.number(internalFeeField.nextSibling().getValue()));
								} else {
									internalFeeField.setValue(null);
									internalFeeField.nextSibling().setValue(go.util.Format.number(this.employee_internal_fee || 0));
								}

								btn.ownerCt.doLayout();
							},
							scope:this
						},{
							xtype: 'xcheckbox',
							boxLabel: t("Use overtime rates", "projects2"),
							name: 'apply_internal_overtime'
						}
					]
				}),
			this.budgetedHoursField,
			this.applyToExistingCheck,
			this.externalRateGrid
			]
		});

		this.addPanel(this.formPanel);
	},

	loadRecord: function(record, result) {
		this.employee_internal_fee = record.employee_internal_fee;
		if(record.employee_internal_fee && !result.data.internal_fee) {
			this.formPanel.form.findField('internal_fee').setValue(null);
		}
	}

});
