/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { DateTime, Timezone } from "./DateTime.js";
/**
 * Formatting utilities
 * @category Utility
 */
export declare class Format {
    /**
     * Date format when using date formatting functions
     */
    static dateFormat: string;
    /**
     * Time format when using time formatting functions
     */
    static timeFormat: string;
    /**
     * Timezone when using time format functions
     */
    static timezone: Timezone;
    /**
     * Currency to use
     */
    static currency: string;
    /**
     * Decimal separator when using number formatting functions
     */
    static decimalSeparator: string;
    /**
     * Thousands separator when using number formatting functions
     */
    static thousandsSeparator: string;
    /**
     * Escape a HTML string for safely inserting it in the DOM tree
     * @param str
     */
    static escapeHTML: (str: string) => string;
    /**
     * Format a date to a string
     *
     * @param date
     */
    static date(date: string | DateTime | Date): string;
    /**
     * Format a time to a string
     * @param date
     */
    static time(date: string | DateTime | Date): string;
    /**
     * Formats a date and time to the default format
     *
     * @see Format.dateFormat
     * @see Format.timeFormat
     * @param date
     */
    static dateTime(date: string | DateTime | Date): string;
    /**
     * Format a number to money
     *
     * @param amount
     */
    static money(amount: number): string;
    /**
     * Format a number to a localized string
     *
     * @param value
     * @param decimals
     */
    static number(value: number, decimals?: number): string;
    static duration(value: number, zeroPad?: boolean): string;
    static shortTime(v: string): string;
    static minutes(timeStr: string): number;
}
//# sourceMappingURL=Format.d.ts.map