import { translate } from "@intermesh/goui";
import { client, jmapds } from "./jmap/index.js";
let GouiMainPanel;
if (window.GO) {
    client.uri = BaseHref + "api/";
    // this set's the GOUI client authenticated by using the group-office Extjs session data
    GO.mainLayout.on("authenticated", () => {
        client.session = go.User.session;
        translate.load(GO.lang.core.core, "core", "core");
        client.fireAuth();
        // client.sse(go.Entities.getAll().filter((e:any) => e.package != "legacy").map((e:any) => e.name));
    });
    GouiMainPanel = Ext.extend(go.modules.ModulePanel, {
        callback: undefined,
        cls: "go-module-panel goui-module-panel",
        initComponent: function () {
            GouiMainPanel.superclass.initComponent.call(this);
            this.on("afterrender", async () => {
                const comp = await this.callback();
                comp.render(this.body.dom);
            }, this);
        },
    });
}
class Modules {
    constructor() {
        this.mods = [];
    }
    /**
     * Register a module so it's functionally is added to the GUI
     *
     * @param config
     */
    register(config) {
        this.mods.push(config);
        this.registerInExtjs(config);
        go.Translate.package = config.package;
        go.Translate.module = config.name;
        if (config.init) {
            config.init();
        }
    }
    /**
     * Add a main panel that is accessible through the main menu and tabs
     *
     * @param pkg
     * @param module
     * @param id
     * @param title
     * @param callback
     */
    addMainPanel(pkg, module, id, title, callback) {
        go.Translate.package = go.package = pkg;
        go.Translate.module = go.module = module;
        // @todo, this ugly. core must play with Ext but can also be used out side of group-office like on the website
        // @ts-ignore
        const proto = Ext.extend(GouiMainPanel, {
            id: id,
            title: title,
            callback: callback
        });
        proto.package = pkg;
        proto.module = module;
        go.Modules.addPanel(proto);
    }
    /**
     * Open a main panel
     *
     * @param id
     */
    openMainPanel(id) {
        GO.mainLayout.openModule(id);
    }
    registerInExtjs(config) {
        go.Modules.register(config.package, config.name, {
            entities: config.entities
        });
    }
    /**
     * Get all modules
     */
    async getAll() {
        if (!this.modules) {
            const mods = await jmapds("Module").get();
            this.modules = mods.list;
        }
        return this.modules;
    }
    /**
     * Check if the current user has this module
     *
     * @param pkg
     * @param name
     */
    isAvailable(pkg, name) {
        return go.Modules.isAvailable(pkg, name);
    }
    /**
     * Get a module
     *
     * @param pkg
     * @param name
     */
    get(pkg, name) {
        const mod = go.Modules.get(pkg, name);
        return mod ? mod : undefined;
    }
}
export const modules = new Modules();
//# sourceMappingURL=Modules.js.map