/**
 * @license https://github.com/Intermesh/goui/blob/main/LICENSE MIT License
 * @copyright Copyright 2023 Intermesh BV
 * @author Merijn Schering <mschering@intermesh.nl>
 */
import { AbstractDataSource, CommitResponse, DefaultEntity, QueryParams, QueryResponse, SetRequest } from "@intermesh/goui";
import { Config } from "@intermesh/goui";
declare enum andOrNot {
    AND = 0,
    OR = 1,
    NOT = 2
}
export interface FilterOperator {
    operator: andOrNot;
    conditions: (FilterOperator | FilterCondition)[];
}
export type FilterCondition = Record<string, any>;
export interface JmapQueryParams extends QueryParams {
    filter?: FilterCondition | FilterOperator;
}
export interface JmapDataSource<EntityType extends DefaultEntity = DefaultEntity> extends AbstractDataSource<EntityType> {
    patchFilter(ref: string, filter: FilterCondition | FilterOperator | undefined): void;
    setFilter(ref: string, filter: FilterCondition | FilterOperator | undefined): void;
    getFilter(): FilterCondition | FilterOperator;
}
/**
 * JMAP Data source
 *
 * Single Source Of Truth for JMAP entities
 *
 */
export declare class JmapDataSource<EntityType extends DefaultEntity = DefaultEntity> extends AbstractDataSource<EntityType> {
    /**
     * The controller route
     *
     * By default, the store ID is used as route. Eg. id = "Contact" then get request will be Contact/get
     *
     * If you set this to "SpecialContact" it will be "SpecialContact/get"
     */
    controllerRoute: string | undefined;
    protected internalQuery(params: JmapQueryParams): Promise<QueryResponse>;
    /**
     * The ID to use when committing
     */
    protected _nextCallId: number;
    /**
     * The call ID of the next JMAP method call. Useful for result references.
     */
    get nextCallId(): string;
    private useCallId;
    protected internalCommit(params: SetRequest<EntityType>): Promise<CommitResponse<EntityType>>;
    /**
     * This function makes sure the store is up to date. Should not be necessary but we ran into problems where tasks
     * were out of date when viewed. This should always prevent that.
     * @return {Promise<self>}
     */
    validateState(): Promise<this>;
    protected internalGet(ids: string[]): Promise<any>;
    protected internalRemoteChanges(state: string | undefined): Promise<any>;
}
/**
 * Get a single instance of a store by ID
 *
 * @param storeId
 */
export declare const jmapds: <EntityType extends DefaultEntity = DefaultEntity>(storeId: string, config?: Config<JmapDataSource>) => JmapDataSource<EntityType>;
export {};
//# sourceMappingURL=JmapDataSource.d.ts.map