<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Norsk (Norwegian)
* Version: 3.6.x
*
* ==> CONTRIBUTORS
*
* Jarle Johansen (http://www.marine-regnskap.no)
* Tore Krok Nielsen (http://www.reluxtraining.com)
* Thomas Rindal (https://thomas.rindal.name)
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Norsk';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='Norwegian';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_unicode_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Tilsvar over denne linjen ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Ny supporthenvendelse: %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Henvendelse mottatt: %%SUBJECT%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Henvendelse tilordnet: %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Nytt svar til: %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Nytt svar til: %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Henvendelse flyttet: %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Notat lagt til: %%SUBJECT%%';
$hesklang['new_pm']='Ny privat melding: %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Oversikt over dine supporthenvendelser';

// ERROR MESSAGES
$hesklang['cant_connect_db']='Kan ikke koble til database!';
$hesklang['invalid_action']='Ugyldig handling';
$hesklang['select_username']='Vennligst velg ditt brukernavn';
$hesklang['enter_pass']='Vennligst angi ditt passord';
$hesklang['cant_sql']='Kan ikke utføre SQL';
$hesklang['contact_webmsater']='Vennligst informer webmaster på';
$hesklang['mysql_said']='MySQL sa';
$hesklang['wrong_pass']='Feil passord.';
$hesklang['session_expired']='Din sesjon har utløpt, vennligst logg inn via skjema nedenfor.';
$hesklang['attempt']='Ugyldig forsøk!';
$hesklang['not_authorized_tickets']='Du er ikke autorisert til å se henvendelser i denne kategorien!';
$hesklang['must_be_admin']='Du er ikke autorisert til å se denne siden! For å se denne siden må du være logget inn som administrator.';
$hesklang['no_session']='Kan ikke starte ny sesjon!';
$hesklang['error']='Feil';
$hesklang['int_error']='Intern skriptfeil';
$hesklang['no_trackID']='Ingen sporings-ID';
$hesklang['status_not_valid']='Ugyldig status';
$hesklang['trackID_not_found']='Fant ikke sporings-ID';
$hesklang['enter_message']='Vennligst skriv inn din beskjed';
$hesklang['select_priority']='Vennligst velg prioritet';
$hesklang['ticket_not_found']='Fant ikke henvendelse! Vennligst forsikre deg om at du har angitt korrekt sporings-ID!';
$hesklang['no_selected']='Ingen henvendelse valgt, intet å endre';
$hesklang['id_not_valid']='Dette er ingen gyldig ID';
$hesklang['enter_id']='Vennligst angi sporings-ID';
$hesklang['enter_name']='Vennligst angi kundenavn';
$hesklang['enter_date']='Vennligst angi søkedato';
$hesklang['date_not_valid']='Dette er ingen gyldig dato. Vennligst angi dato i formatet <b>YYYY-MM-DD</b>.';
$hesklang['enter_subject']='Vennligst angi emne for henvendelse';
$hesklang['invalid_search']='Ugyldig søk';
$hesklang['choose_cat_ren']='Vennligst angi kategori hvor navn skal endres';
$hesklang['cat_ren_name']='Vennligst skriv in nytt navn for kategori';
$hesklang['cat_not_found']='Kategori ikke funnet';
$hesklang['enter_cat_name']='Vennligst angi kategorinavn';
$hesklang['no_cat_id']='Ingen kategori-ID';
$hesklang['cant_del_default_cat']='Du kan ikke endre standardkategorien, du kan kun gi den nytt navn';
$hesklang['no_valid_id']='Ingen gyldig bruker-ID';
$hesklang['user_not_found']='Fant ikke bruker';
$hesklang['enter_real_name']='Vennligst angi virkelig navn på bruker';
$hesklang['enter_valid_email']='Vennligst angi en gyldig e-postadresse';
$hesklang['enter_username']='Vennligst angi brukernavn (login)';
$hesklang['asign_one_cat']='Vennligst tilordne bruker til minst en kategori!';
$hesklang['signature_long']='Brukersignaturen er for lang! Vennligst begrens signaturen til 1000 karakterer';
$hesklang['confirm_user_pass']='Vennligst bekreft passord';
$hesklang['passwords_not_same']='De to passordene du har angitt er ulike!';
$hesklang['cant_del_admin']='Du kan ikke slette standardadministrator!';
$hesklang['cant_del_own']='Du kan ikke slette profilen du er innlogget med!';
$hesklang['enter_your_name']='Vennligst skriv inn ditt navn';
$hesklang['sel_app_cat']='Vennligst velg den passende kategorien';
$hesklang['sel_app_priority']='Vennligst velg den passende prioriteten';
$hesklang['enter_ticket_subject']='Vennligst angi emne for henvendelsen';
$hesklang['user_not_found_nothing_edit']='Fant ikke bruker eller intet å endre';

// ADMIN PANEL
$hesklang['administrator']='Administrator';
$hesklang['login']='Logg inn';
$hesklang['user']='Bruker';
$hesklang['username']='Brukernavn';
$hesklang['pass']='Passord';
$hesklang['confirm_pass']='Bekreft passord';
$hesklang['logged_out']='Logget ut';
$hesklang['logout']='Logg ut';
$hesklang['logout_success']='Du har blitt logget ut på korrekt måte!';
$hesklang['click_login']='Klikk her for å logge inn';
$hesklang['back']='Gå tilbake';
$hesklang['displaying_pages']='Viser <b>%d</b> henvendelser. Sider:';
$hesklang['trackID']='Sporings-ID';
$hesklang['timestamp']='Tidsstempel';
$hesklang['name']='Navn';
$hesklang['subject']='Emne';
$hesklang['status']='Status';
$hesklang['priority']='Prioritet';
$hesklang['open']='Ny';
$hesklang['open_action']='Åpne henvendelse'; // Open ACTION
$hesklang['close']='Lukket'; // Closed ticket STATUS
$hesklang['any_status']='Alle statuser';
$hesklang['high']='Høy';
$hesklang['medium']='Middels';
$hesklang['low']='Lav';
$hesklang['del_selected']='Slett valgte henvendelser';
$hesklang['manage_cat']='Behandle kategorier';
$hesklang['profile']='Your profil';
$hesklang['show_tickets']='Vis henvendelser';
$hesklang['sort_by']='Sortering';
$hesklang['date_posted']='Posteringsdato';
$hesklang['category']='Kategori';
$hesklang['any_cat']='Alle kategorier';
$hesklang['order']='Rekkefølge';
$hesklang['ascending']='stigende';
$hesklang['descending']='synkende';
$hesklang['display']='Vis';
$hesklang['tickets_page']='henvendelser per side';
$hesklang['find_ticket']='Finn henvendelse';
$hesklang['yyyy_mm_dd']='YYYY-MM-DD';
$hesklang['results_page']='resultater per side';
$hesklang['opened']='åpnet'; // The ticket has been OPENED
$hesklang['closed']='Løst'; // Ticket has been RESOLVED
$hesklang['ticket']='Henvendelse';
$hesklang['tickets']='Henvendelser';
$hesklang['ticket_been']='Denne henvendelsen har blitt';
$hesklang['view_ticket']='Vis henvendelse';
$hesklang['open_tickets']='Åpne henvendelser';
$hesklang['remove_statement']='Fjern &quot;Powered by&quot; melding';
$hesklang['click_info']='Klikk her for mer informasjon';
$hesklang['reply_added']='Tilsvar lagt til';
$hesklang['reply_submitted']='Tilsvar registrert';
$hesklang['ticket_marked']='Denne henvendelsen har blitt merket';
$hesklang['ticket_status']='Status for din henvendelse';
$hesklang['replies']='Antall svar';
$hesklang['date']='Dato:';
$hesklang['email']='E-postadresse';
$hesklang['ip']='IP';
$hesklang['message']='Melding';
$hesklang['add_reply']='Legg til svar';
$hesklang['close_this_ticket']='Steng denne henvendelsen';
$hesklang['change_priority']='Endre prioritet til';
$hesklang['attach_sign']='Legg til signatur';
$hesklang['profile_settings']='Profilinnstillinger';
$hesklang['submit_reply']='Registrer svar';
$hesklang['support_panel']='Support panel';
$hesklang['ticket_trackID']='Henvendelsens sporings-ID';
$hesklang['c2c']='Klikk for å fortsette';
$hesklang['tickets_deleted']='Henvendelser slettet';
$hesklang['num_tickets_deleted']='<b>%d</b> henvendelser har blitt deleted';
$hesklang['confirm_del_cat']='Er du sikker på at du vil fjerne denne kategorien?';
$hesklang['cat_intro']='Her kan du behandle kategorier. Kategorier er nyttige for å gruppere henvendelser etter relevans (eksempelvis &quot;Salg&quot;,&quot;Maskinvareproblemer&quot;, &quot;PHP/MySQL problemer&quot; etc) og for å tilordne brukere til kategorier (eksempelvis at din selger kun kan se henvendelser postet til &quot;Salg&quot; kategorien)';
$hesklang['cat_name']='Kategorinavn';
$hesklang['remove']='Fjern';
$hesklang['add_cat']='Legg til ny kategori';
$hesklang['max_chars']='maksimalt 40 karakterer';
$hesklang['create_cat']='Opprett kategori';
$hesklang['ren_cat']='Gi kategorien nytt navn';
$hesklang['to']='til';
$hesklang['cat_added']='Kategori lagt til';
$hesklang['cat_name_added']='Kategori %s har blitt lagt til';
$hesklang['cat_renamed']='Kategorinavn endret';
$hesklang['cat_renamed_to']='Valgte kategori har endret navn til';
$hesklang['cat_removed']='Kategorien er fjernet';
$hesklang['cat_removed_db']='Valgte kategori har blitt fjernet fra databasen';
$hesklang['sure_remove_user']='Er du sikker på at du vil fjerne denne brukeren?';
$hesklang['manage_users']='Behandle brukere';
$hesklang['users_intro']='Her kan du behandle brukere som kan logge inn på administrasjonspanelet og besvare henvendelser. Administratorer kan se/redigere henvendelser uansett kategori og har tilgang til alle funksjoner i administrasjonspanelet (brukere, kategorier, ...) mens andre brukere kun kan se og besvare henvendelser innenfor deres egne kategorier.';
$hesklang['yes']='JA';
$hesklang['no']='NEI';
$hesklang['edit']='Rediger';
$hesklang['add_user']='Legg til ny bruker';
$hesklang['req_marked_with']='Obligatoriske felt er merket med';
$hesklang['real_name']='Virkelig navn';
$hesklang['signature_max']='Signatur (max 1000 tegn)';
$hesklang['sign_extra']='HTML kode er ikke tillatt. Lenker vil være klikkbare.';
$hesklang['create_user']='Opprett bruker';
$hesklang['editing_user']='Redigerer bruker';
$hesklang['user_added']='Lagt til bruker';
$hesklang['user_added_success']='Ny bruker %s med passord %s har blitt lagt til';
$hesklang['profile_updated']='Profil oppdatert';
$hesklang['profile_updated_success']='Denne profilen er oppdatert';
$hesklang['user_removed']='Fjernet bruker';
$hesklang['sel_user_removed']='Valgte bruker er fjernet fra databasen';
$hesklang['profile_for']='Profil for';
$hesklang['new_pass']='Nytt passord';
$hesklang['update_profile']='Oppdater profil';
$hesklang['notify_new_posts']='Gi meg beskjed om nye henvendelser og poster innenfor mine kategorier';
$hesklang['view_profile']='Vis profil';
$hesklang['new_ticket_submitted']='Ny supporthenvendelse registrert';
$hesklang['user_profile_updated_success']='Denne brukerprofilen har blitt oppdatert';
$hesklang['printer_friendly']='Skrivervennlig versjon';
$hesklang['end_ticket']='--- Slutt henvendelse ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='Din henvendelse har blitt';
$hesklang['view_your_ticket']='Se din henvendelse';
$hesklang['submit_ticket']='Registrer en henvendelse';
$hesklang['sub_ticket']='Registrer henvendelse';
$hesklang['before_submit']='Vennligst forsikre deg om følgende før registrering:';
$hesklang['all_info_in']='At all obligatorisk informasjon har blitt fylt ut';
$hesklang['all_error_free']='At all informasjon er korrekt og feilfri';
$hesklang['we_have']='Vi har';
$hesklang['recorded_ip']='logget som din IP-adresse';
$hesklang['recorded_time']='logget tidspunktet for din registrering';
$hesklang['save_changes']='Lagre endringer';
$hesklang['reply_submitted_success']='Ditt svar på denne henvendelsen har blitt registrert og er i orden';
$hesklang['ticket_submitted']='Henvendelsen er registrert';
$hesklang['ticket_submitted_success']='Din henvendelse har blitt registrert og er i orden! Sporings-ID';
$hesklang['your_ticket']='Din henvendelse';

// Added in version 0.94
$hesklang['check_updates']='Forsikre deg om at du alltid har installert den siste Hesk-versjonen!';
$hesklang['check4updates']='Se etter oppdateringer';
$hesklang['wait_reply']='Venter på svar';
$hesklang['replied']='Besvart';
$hesklang['last_replier']='Siste svar fra';
$hesklang['staff']='Medarbeider';
$hesklang['customer']='Kunde';
$hesklang['close_selected']='Marker valgte henvendelser Løst';
$hesklang['execute']='Utfør';
$hesklang['saved_replies']='Standardsvar';
$hesklang['manage_saved']='Standardsvar';
$hesklang['manage_intro']='Her kan du legge til og behandle dine standardsvar. Disse er vanlig brukte svar som er mer eller mindre identiske for hver kunde. Du bør benytte standardsvar for å unngå å skrive det samme svaret til mange forskjellige kunder.';
$hesklang['saved_title']='Tittel';
$hesklang['no_saved']='Ingen lagrede standardsvar';
$hesklang['delete_saved']='Er du sikker på at du ønsker å slette dette standardsvaret?';
$hesklang['new_saved']='Legg til eller rediger et standardsvar';
$hesklang['canned_add']='Opprett et nytt standardsvar';
$hesklang['canned_edit']='Rediger valgte standardsvar';
$hesklang['save_reply']='Lagre standardsvar';
$hesklang['saved']='Standardsvar lagret';
$hesklang['your_saved']='Ditt standardsvar har blitt lagret for fremtidig bruk';
$hesklang['ent_saved_title']='Vennligst skriv inn svartittel';
$hesklang['ent_saved_msg']='Vennligst skriv inn svarbeskjed';
$hesklang['saved_removed']='Lagret standardsvar er nå fjernet';
$hesklang['saved_rem_full']='Valgte standardsvar har blitt fjernet fra databasen';
$hesklang['clip_alt']='Denne posten har vedlegg';
$hesklang['attachments']='Vedlegg';
$hesklang['fill_all']='Manglende påkrevet felt';
$hesklang['file_too_large']='Din fil %s er for stor';
$hesklang['cannot_move_tmp']='Kan ikke flytte filen til vedleggsmappen';
$hesklang['created_on']='Registrert';
$hesklang['tickets_closed']='Henvendelser lukket';
$hesklang['num_tickets_closed']='<b>%d</b> henvendelser har blitt lukket';
$hesklang['select_saved']='Velg et standardsvar';
$hesklang['select_empty']='Velg / Tom';
$hesklang['insert_special']='Sett inn spesialkode (vil bli skiftet ut med kundeinformasjon)';
$hesklang['move_to_catgory']='Flytt henvendelse til';
$hesklang['move']='Move';
$hesklang['moved']='Henvendelse flyttet';
$hesklang['moved_to']='Denne henvendelsen har blitt flyttet til ny kategori';
$hesklang['url']='URL';
$hesklang['all_not_closed']='Alle andre enn lukket';
$hesklang['chg_all']='Endre alle';
$hesklang['settings']='Innstillinger';
$hesklang['settings_intro']='Bruk dette verktøyet for å konfigurere din help desk. For mer informasjon om alle innstillinger og muligheter klikk på hjelpetegnet eller se i readme.html filen.';
$hesklang['all_req']='Alle felt (unntatt de som er deaktivert) er påkrevet!';
$hesklang['wbst_title']='Nettstedtittel';
$hesklang['wbst_url']='Nettstedets URL';
$hesklang['email_wm']='Webmaster e-post';
$hesklang['max_listings']='Opplistinger per side';
$hesklang['print_size']='Fontstørrelse for utskrift';
$hesklang['debug_mode']='Feilsøkingsmodus';
$hesklang['on']='PÅ';
$hesklang['off']='AV';
$hesklang['use_secimg']='Bruk anti-SPAM bilde';
$hesklang['secimg_no']='Ikke tilgjengelig';
$hesklang['attach_use']='Bruk vedlegg';
$hesklang['attach_num']='Antall per post';
$hesklang['attach_type']='Tillatte filtyper';
$hesklang['place_after']='Etter melding';
$hesklang['place_before']='Før melding';
$hesklang['custom_f']='Egendefinert felt';
$hesklang['custom_u']='Bruk dette feltet';
$hesklang['custom_n']='Feltnavn';
$hesklang['custom_l']='Maksimal lengde (tegn)';
$hesklang['db_host']='Database vertsnavn';
$hesklang['db_name']='Databasenavn';
$hesklang['db_user']='Database brukernavn';
$hesklang['db_pass']='Database passord';
$hesklang['err_sname']='Vennligst skriv inn din nettsteds tittel';
$hesklang['err_surl']='Vennligst skriv inn ditt nettsteds URL. Kontroller at dette er en gyldig URL (begynn med http:// eller https://)';
$hesklang['err_wmmail']='Vennligst skriv inn en gyldig e-postadresse for webmaster';
$hesklang['err_nomail']='Vennligst skriv inn en gyldig e-postadresse for ikke svar';
$hesklang['err_htitle']='Vennligst skriv inn tittelen på din support desk';
$hesklang['err_hurl']='Vennligst skriv inn din HESK mappe URL. Kontroller at dette er en gyldig URL (begynn med http:// eller https://)';
$hesklang['err_lang']='Vennligst velg HESK språk';
$hesklang['err_nolang']='Den spesifiserte språkfilen eksisterer ikke i språkmappen! Pass på at filen er lastet opp før endring av språkinnstillingen.';
$hesklang['err_max']='Vennligst skriv inn maksimal listestørrelse vist per side';
$hesklang['err_psize']='Vennligst skriv inn fontstørrelse for utskrift';
$hesklang['err_dbhost']='Vennligst skriv inn din MySQL databases vertsnavn';
$hesklang['err_dbname']='Vennligst skriv inn din MySQL databases navn';
$hesklang['err_dbuser']='Vennligst skriv inn din MySQL databases brukernavn';
$hesklang['err_dbpass']='Vennligst skriv inn din MySQL databases passord';
$hesklang['err_dbconn']='Kunne ikke koble til MySQL database ved å benytte oppgitt informasjon!';
$hesklang['err_dbsele']='Kunne ikke velge MySQL database, vennligst kontroller database NAME';
$hesklang['err_custname']='Vennligst skriv inn navn for valgte valgfri(e) felt(er)';
$hesklang['err_openset']='Kan ikke åpne filen <b>hesk_settings.inc.php</b> for skriving. Vennligst CHMOD denne filen til 666 (rw-rw-rw-)';
$hesklang['set_saved']='Innstillinger lagret';
$hesklang['set_were_saved']='Dine innstillinger har blitt korrekt lagret';
$hesklang['sec_img']='Sikkerhetsbilde';
$hesklang['sec_miss']='Vennligst skriv inn sikkerhetsnummeret';
$hesklang['sec_wrng']='Feil sikkerhetsnummer';
$hesklang['submit_problems']='Vennligst gå tilbake og korriger følgende problemer';
$hesklang['cat_order']='Kategorirekkefølge';
$hesklang['reply_order']='Rekkefølge for standardsvar';
$hesklang['move_up']='Flytt opp';
$hesklang['move_dn']='Flytt ned';
$hesklang['cat_move_id']='Manglende kategori-ID';
$hesklang['reply_move_id']='Manglende standardsvar-ID';
$hesklang['forgot_tid']='Glemt sporings-ID?';
$hesklang['tid_send']='Send meg min sporings-ID';
$hesklang['tid_not_found']='Ingen henvendelser med din e-postadresse ble funnet';
$hesklang['tid_sent']='Sporings-ID sendt';
$hesklang['tid_sent2']='En e-post med detaljer vedrørende dine henvendelser har blitt sent til din e-postadresse';
$hesklang['check_spambox']='Vennligst se etter e-post også i din SPAM-/søppelpostmappe!';
$hesklang['reply_not_found']='Fant ikke standardsvar';
$hesklang['exists']='Eksisterer';
$hesklang['no_exists']='Eksisterer ikke';
$hesklang['writable']='Skrivbar';
$hesklang['not_writable']='Ikke skrivbar';
$hesklang['disabled']='deaktivert';
$hesklang['e_settings']='Du vil ikke være i stand til å lagre dine innstillinger med mindre filen kan skrives til av skriptet. Vennligst se i  readmefilen for videre instruksjoner!';
$hesklang['e_attdir']='Du vil ikke være i stand til å benytte filvedlegg med mindre vedleggsmappen eksisterer og kan skrives til av skriptet.';
$hesklang['e_save_settings']='Kan ikke lagre dine innstillinger fordi filen <b>hesk_settings.inc.php</b> ikke kan skrives til av skriptet.';
$hesklang['e_attach']='Deaktivert fordi din <b>vedleggs</b> katalog ikke er skrivbar av skriptet.';
$hesklang['go']='Kjør';

// Added in version 2.0
$hesklang['v']='HESK versjon';
$hesklang['check_status']='Kontrollerer status';
$hesklang['sub_support']='Registrer en henvendelse';
$hesklang['open_ticket']='Registrer en ny henvendelse til supportavdelingen';
$hesklang['view_existing']='Se på en eksisterende henvendelse';
$hesklang['vet']='Se på en tidligere registrert åpen henvendelse';
$hesklang['enter_user']='Vennligst skriv inn ditt brukernavn';
$hesklang['remember_user']='Husk mitt brukernavn';
$hesklang['wrong_user']='Feil brukernavn';
$hesklang['no_permission']='Du har ikke tillatelse til å utføre denne oppgaven, vennligst logg inn med en annen konto.';
$hesklang['tickets_on_pages']='Antall henvendelser: %d | Antall sider: %d'; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']=' | Hopp til side:';
$hesklang['no_tickets_open']='Ingen uløste henvendelser funnet';
$hesklang['no_tickets_crit']='Ingen henvendelser funnet som tilfredsstiller dine kriterier';
$hesklang['confirm_execute']='Er du sikker på at du vil fortsette?';
$hesklang['legend']='Forklaring';
$hesklang['main_page']='Hjem';
$hesklang['menu_users']='Brukere';
$hesklang['menu_cat']='Kategorier';
$hesklang['menu_profile']='Profil';
$hesklang['menu_kb']='Kunnskapsbase'; // Admin MENU item
$hesklang['kb_text']='Kunnskapsbase'; // Item visible to customers
$hesklang['viewkb']='Se hele kunnskapsbasen';
$hesklang['kb']='Rediger kunnskapsbasen';
$hesklang['kb_intro']='Kunnskapsbasen er en samling av svar på ofte stilte spørsmål(FAQ) og artikler som kan bidra til selvhjelp.
En innholdsrik og velskrevet kunnskapsbase kan drastisk redusere antallet supporthenvendelser du mottar og spare tid. Du kan ordne artikler i  kategorier og underkategorier.'; // Description in ADMIN panel
$hesklang['kb_is']='Kunnskapsbasen er en kategorisert samling av tidligere svar på ofte stilte spørsmål (FAQ) og artikler. Du kan lese artikler i denne kategorien eller velge en underkategori du er interessert i.'; // Description for CUSTOMERS
$hesklang['new_kb_art']='Ny artikkel til kunnskapsbasen';
$hesklang['kb_cat']='Kategori';
$hesklang['kb_subject']='Emne';
$hesklang['kb_content']='Innhold';
$hesklang['kb_type']='Type';
$hesklang['kb_published']='Publisert';
$hesklang['kb_published2']='Artikkelen er synlig for alle i kunnskapsbasen.';
$hesklang['kb_private']='Privat';
$hesklang['kb_private2']='Private artikler kan kun leses av medarbeidere.';
$hesklang['kb_draft']='Utkast';
$hesklang['kb_draft2']='Artikkelen er lagret, men er ikke publisert ennå. Den kan kun leses av medarbeidere<br /> som har rettigheter til å behandle kunnskapsbaseartikler.';
$hesklang['kb_links']='<i><span class="notice"><b>Advarsel!</b></span><br />Skriv inngyldig kode uten &lt;head&gt; og &lt;body&gt; tags, kun innhold!</i>';
$hesklang['kb_ehtml']='Dette er HTML kode (Jeg vil oppgi gyldig (X)HTML kode)';
$hesklang['kb_dhtml']='Dette er ren tekst (lenker vil være klikkbare)';
$hesklang['kb_save']='Lagre artikkel';
$hesklang['kb_e_subj']='Skriv inn artikkelemne!';
$hesklang['kb_e_cont']='Skriv artikkelinnhold!';
$hesklang['kb_art_added']='Artikkel lagt til';
$hesklang['your_kb_added']='En ny kunnskapsbaseartikkel har blitt lagt til';
$hesklang['kb_art_deleted']='Artikkel slettet';
$hesklang['your_kb_deleted']='Valgte kunnskapsbaseartikkel har blitt slettet';
$hesklang['kb_art_mod']='Artikkel modifisert';
$hesklang['your_kb_mod']='Dine endringer i valgte artikkel har blitt lagret';
$hesklang['kb_cat_new']='Ny kunnskapsbasekategori';
$hesklang['kb_cat_parent']='Overordnet kategori';
$hesklang['kb_cat_sub']='Underkategorier';
$hesklang['kb_cat_title']='Kategoritittel';
$hesklang['kb_cat_published']='Kategorien er synlig for alle i kunnskapsbasen.';
$hesklang['kb_cat_private']='Kategorien kan kun leses av medarbeidere.';
$hesklang['kb_cat_add']='Legg til kategori';
$hesklang['kb_cat_e_title']='Skriv inn kategoritittel!';
$hesklang['kb_cat_added']='Kategori lagt til';
$hesklang['kb_cat_added2']='En ny kategori har blitt lagt til i kunnskapsbasen';
$hesklang['kb_cat_man']='Behandle kunnskapsbasekategori';
$hesklang['kb_cat_edit']='Rediger kategoridetaljer';
$hesklang['kb_cat_inv']='Ugyldig kategori';
$hesklang['kb_cat_art']='Artikler i denne kategorien';
$hesklang['kb_p_art']='+ Artikkel';
$hesklang['kb_p_art2']='legg til en ny artikkel i den valgte kategorien.';
$hesklang['kb_add_art']='Legg til Artikkel';
$hesklang['kb_p_cat']='+ Kategori';
$hesklang['kb_p_cat2']='opprett en ny underkategori i den valgte kategorien.';
$hesklang['kb_add_cat']='Legg til kategori';
$hesklang['kb_p_man']='Behandle';
$hesklang['kb_p_man2']='behandle valgt kategori (rediger, slett, behandle artikler).';
$hesklang['kb_main']='Hovedkategorien i kunnskapsbasen kan ikke slettes eller flyttes.';
$hesklang['kb_no_art']='Det er ingen artikler in denne kategorien.';
$hesklang['author']='Forfatter';
$hesklang['views']='Antall visninger';
$hesklang['delete']='Slett';
$hesklang['rating']='Vurdering';
$hesklang['votes']='Stemmer';
$hesklang['kb_rated']='Artikkel vurdert til %s/5.0';
$hesklang['kb_not_rated']='Artikkel ikke vurdert ennå';
$hesklang['del_art']='Er du sikker på at du vil slette valgt artikkel?';
$hesklang['kb_art_id']='Manglende eller ugyldig artikkel-ID!';
$hesklang['kb_art_edit']='Rediger artikkel';
$hesklang['revhist']='Revisjonshistorikk';
$hesklang['revision1']='<li class="smaller">%s | registrert av %s</li>'; // %s = date, user making change
$hesklang['revision2']='<li class="smaller">%s | modifisert av %s</li>'; // %s = date, user making change
$hesklang['kb_order']='Rekkefølge';
$hesklang['kb_delcat']='Er du sikker på at du vil slette denne kategorien?';
$hesklang['kb_cat_mod']='Kategorien er modifisert';
$hesklang['your_cat_mod']='Dine endringer for den valgte kategorien har blitt lagret';
$hesklang['kb_cat_del']='Kunnskapsbasekategori slettet';
$hesklang['kb_cat_dlt']='Den valgte kunnskapsbasekategorien har blitt slettet.';
$hesklang['allowed_cat']='Kategorier';
$hesklang['allow_feat']='Elementer';
$hesklang['can_view_tickets']='Vis henvendelser';
$hesklang['can_reply_tickets']='Svar på henvendelser';
$hesklang['can_assign_tickets']='Tilordne henvendelser';
$hesklang['can_del_tickets']='Slett henvendelser';
$hesklang['can_edit_tickets']='Rediger svar på henvendelse';
$hesklang['can_change_cat']='Endre henvendelseskategori';
$hesklang['can_man_kb']='Behandle kunnskapsbase';
$hesklang['can_man_users']='Behandle brukere';
$hesklang['can_man_cat']='Behandle kategorier';
$hesklang['can_man_canned']='Behandle standardsvar';
$hesklang['can_man_settings']='Behandle innstillinger for help desk';
$hesklang['can_del_notes']='Slette alle henvendelsesnotater';
$hesklang['dan']='brukere kan slette egne henvendelsesnotater, velg dette kun hvis du ønsker at denne brukeren også skal kunne slette notater fra andre brukere';
$hesklang['in_all_cat']='kun i tillatte kategorier';
$hesklang['admin_can']='(tilgang til alle elementer og kategorier)';
$hesklang['staff_can']='(du kan begrense elementer og kategorier)';
$hesklang['asign_one_feat']='Vennligst tilordne minst et element til denne brukeren!';
$hesklang['na_view_tickets']='Du har ikke rettigheter til å se henvendelser';
$hesklang['support_notice']='Beklager, denne delen kan kun være skjult dersom du kjøper en HESK-lisens!';
$hesklang['rart']='Var denne artikkelen nyttig?';
$hesklang['r']='Var dette svaret nyttig?';
$hesklang['tyr']='Takk for din vurdering';
$hesklang['cw']='Lukk vindu';
$hesklang['cw2']='Lukk vindu og registrer henvendelse';
$hesklang['rh']='Vurdert som <i>nyttig</i>';
$hesklang['rnh']='Vurdert som <i>unyttig</i>';
$hesklang['ar']='Allerede vurdert';
$hesklang['rated']='Brukeren vurderte %s/5.0 (%s vurderinger)';
$hesklang['not_rated']='Brukeren har ikke vurdert ennå';
$hesklang['rdis']='Vurdering har blitt deaktivert';
$hesklang['kbdis']='Kunnskapsbasen er deaktivert';
$hesklang['kbpart']='Beklager, du har ikke rettigheter til å lese denne artikkelen';
$hesklang['popart']='Mest leste artikler i kunnskapsbasen:';
$hesklang['latart']='Siste artikler i kunnskapsbasen:';
$hesklang['m']='Flere emner';
$hesklang['ac']='Artikler i denne kategorien:';
$hesklang['noa']='Ingen artikler ennå';
$hesklang['noac']='Ingen artikler ennå i denne kategorien';
$hesklang['dta']='Dato lagt til';
$hesklang['ad']='Artikkeldetaljer';
$hesklang['aid']='Artikkel-ID';
$hesklang['as']='Løsning';
$hesklang['search']='Søk';
$hesklang['sr']='Søkeresultater';
$hesklang['nosr']='Ingen tilsvarende artikler funnet. Forsøk å gå igjennom kunnskapsbasen eller registrer en ny supporthenvendelse.';
$hesklang['rv']='Tilbakestill visninger';
$hesklang['rr']='Tilbakestill stemmer (vurderinger)';
$hesklang['opt']='Valg';
$hesklang['delcat']='Slett kategori';
$hesklang['move1']='Flytt artikler til parent kategori';
$hesklang['move2']='Slett artikler i denne kategorien';
$hesklang['sc']='Foreslåtte artikler i kunnskapsbasen';
$hesklang['not']='Henvendelser'; // Number of all tickets in category
$hesklang['graph']='Fordelingsgrafikk';
$hesklang['lu']='List opp brukernavn';
$hesklang['aclose']='Lukk henvendelser automatisk';
$hesklang['aclose2']='dager etter svar fra medarbeider';
$hesklang['s_ucrt']='Gjenåpne henvendelser';
$hesklang['urate']='Vurderinger av svar';
$hesklang['hesk_url']='Help desk URL';
$hesklang['hesk_title']='Help desk tittel';
$hesklang['cid']='Sak med sporings-ID';
$hesklang['tfor']='Tidsformat';
$hesklang['prefix']='Tabellprefiks';
$hesklang['s_ekb']='Aktiver kunnskapsbase';
$hesklang['s_kbs']='Aktiver kunnskapsbasesøk';
$hesklang['s_kbr']='Aktiver vurdering av kunnskapsbaseartikler';
$hesklang['s_maxsr']='Maks antall søkeresultater';
$hesklang['s_suggest']='Foreslå kunnskapsbaseartikler';
$hesklang['s_spop']='Vis populære artikler';
$hesklang['s_slat']='Vis siste artikler';
$hesklang['s_onin']='på <a href="../" target="_blank">Help desk forside</a>';
$hesklang['s_onkb']='på <a href="../knowledgebase.php" target="_blank">Kunnskapsbasens oversiktsside</a>';
$hesklang['s_scol']='Kategorier i rekke';
$hesklang['s_ptxt']='Lengde på forhåndsvisning';
$hesklang['s_psubart']='Artikler i underkategorier';
$hesklang['enable']='Aktiver';
$hesklang['s_type']='Type';
$hesklang['custom_r']='Påkrevet';
$hesklang['custom_place']='Plassering';
$hesklang['custom_use']='Egendefinerte felt';
$hesklang['stf']='Tekstfelt';
$hesklang['stb']='Stor tekstboks';
$hesklang['srb']='Radioknapp';
$hesklang['ssb']='Velg boks';
$hesklang['db']='Database';
$hesklang['hd']='Innstillinger for help desk';
$hesklang['gs']='Generelle innstillinger';
$hesklang['cwin']='Lukk vindu';
$hesklang['defw']='Standardverdi';
$hesklang['ok']='OK';
$hesklang['ns']='Disse er tilgjengelige opsjoner for dette egendefinerte feltet. For å lagre endringer klikk <b>OK</b> og <b> knappen "Lagre endringer"</b> på instillingssiden for administratorer!';
$hesklang['rows']='Rader (høyde)';
$hesklang['cols']='Kolonner (bredde)';
$hesklang['opt2']='Valg for denne radioknappen, legg inn ett valg per linje (hver linje vil opprette en ny radioknappverdi å velge blant). Du må opprette minst to valgmuligheter!';
$hesklang['opt3']='Valg for denne valgboksen, legg inn ett valg per linje (hver linje vil bli et valg dine kunder velge blant). Du må opprette minst to valgmuligheter!';
$hesklang['atl2']='Legg inn minst to valgmuligheter (en per linje)!';
$hesklang['notes']='Notater';
$hesklang['addnote']='+ Legg til notat';
$hesklang['noteby']='Notat fra';
$hesklang['delnote']='Slett notat';
$hesklang['noteerr']='Notatet er allerede slettet eller feil parametere';
$hesklang['s']='Registrer';
$hesklang['nhid']='Notater er skjult for kunder!';
$hesklang['delt']='Slett denne henvendelsen';
$hesklang['edtt']='Rediger henvendelsen';
$hesklang['edt1']='henvendelsen er modifisert';
$hesklang['edt2']='Endringer i henvendelsen er lagret';
$hesklang['dele']='Slett denne henvendelsen';
$hesklang['repd']='Henvendelsen er slettet';
$hesklang['repl']='Valgte henvendelse er slettet';
$hesklang['tickets_found']='Søkeresultater';
$hesklang['al']='Administratorlenke';
$hesklang['ap']='Gå til administrasjonspanel';
$hesklang['dap']='Vis en lenke til adminpanelet fra <a href="../" target="_blank">help desk index</a>';
$hesklang['q_miss']='Vennligst besvar anti-SPAM spørsmålet';
$hesklang['use_q']='Bruk anti-SPAM spørsmål';
$hesklang['q_q']='-&gt; Spørsmål (HTML-kode er <font class="success">tillatt</font>)';
$hesklang['q_a']='-&gt; Svar';
$hesklang['err_qask']='Skriv inn anti-SPAM spørsmål';
$hesklang['err_qans']='Skriv inn svar på anti-SPAM spørsmålet';
$hesklang['genq']='Generer et tilfeldig spørsmål';

// Added in version 2.1
$hesklang['amo']='Legg til mer';
$hesklang['delatt']='Slett valgt vedlegg?';
$hesklang['kb_att_rem']='Det valgte vedlegget har blitt fjernet';
$hesklang['inv_att_id']='Ugyldig vedleggs-ID!';
$hesklang['scb']='Avkryssningsboks';
$hesklang['opt4']='Valg for denne avkryssingsboksen, skriv inn ett valg per linje. Hver linje blir et valg dine kunder kan benytte, flere valg er mulige. Du må opprette minst to valgmuligheter!';
$hesklang['autologin']='Logg meg automatisk på når jeg besøker siden';
$hesklang['just_user']='Husk kun brukernavn';
$hesklang['nothx']='Nei takk';
$hesklang['pinfo']='Profilinformasjon';
$hesklang['sig']='Signatur';
$hesklang['pref']='Preferanser';
$hesklang['aftrep']='Etter svar på en henvendelse';
$hesklang['showtic']='Vis henvendelsen jeg nettopp besvarte';
$hesklang['gomain']='Returner til hovedsiden for administrasjon';
$hesklang['shownext']='Åpne neste henvendelse som trenger mitt svar';
$hesklang['rssn']='Viser neste henvendelse som du må behandle';
$hesklang['mrep']='Skift melding';
$hesklang['madd']='Legg til i bunn';
$hesklang['priv']='Private kategorier og artikler synlige kun for medarbeidere er merket med *';
$hesklang['inve']='Ugyldig e-post fil';
$hesklang['emfm']='Manglende e-post fil';
$hesklang['hesk_lang']='Standardspråk';
$hesklang['s_mlang']='Flere språk';
$hesklang['s_mlange']='Aktiver kun hvis du tilbyr support på alle installerte språk!';
$hesklang['s_inl']='Test språkmappe';
$hesklang['s_inle']='Tester språkmappen for gyldige språk. Kun språk som klarer alle tester er korrekt installert.';
$hesklang['ta']='Test igjen';
$hesklang['alo']='Tillat automatisk innlogging';
$hesklang['chol']='Foretrukket språk';
$hesklang['mmdl']='Gjør dette til mitt foretrukne språk';
$hesklang['warn']='ADVARSEL';
$hesklang['dmod']='Feilsøkingsmodus er aktivert. Pass på at du deaktiverer feilsøkingsmodus under innstillinger når HESK er installert og fungerer korrekt.';
$hesklang['kb_spar']='Kategorien kan ikke være sin egen overordnede kategori!';
$hesklang['mysql_root']='Ditt MySQL-passord er tomt, er du sikker på at du vil logge inn med root-bruker? Dette innebærer en betydelig sikkerhetsrisiko!';
$hesklang['chg']='Endre';
$hesklang['chpri']='Prioritet endret';
$hesklang['chpri2']='Henvendelsens prioritet har blitt endret til %s';
$hesklang['selcan']='Velg hvilket lagret svar du ønsker å redigere';
$hesklang['q_wrng']='Feil anti-SPAM svar';
$hesklang['cndupl']='Du har allerede en kategori med det navnet. Velg et unikt navn for hver kategori.';
$hesklang['wsel']='Velg feltet du vil søke i';

// Added in version 2.2
$hesklang['eto']='Ugyldig forespørsel';
$hesklang['id']='ID';
$hesklang['geco']='Generer direktelenke';
$hesklang['genl']='Direkte kategorilenke';
$hesklang['genl2']='Bruk denne lenken til å forhåndsvelge kategori i &quot;Registrer en henvendelse&quot;-skjema.';
$hesklang['ask']='Søk hjelp:';
$hesklang['exa']='Eksempler';
$hesklang['small']='Liten boks';
$hesklang['large']='Stor boks';
$hesklang['cpri']='Kundeprioritet';
$hesklang['owner']='Eier';
$hesklang['unas']='Ikke tilordnet';
$hesklang['assi']='Tilordne';
$hesklang['asst']='Tilordne';
$hesklang['asst2']='Tilordne denne henvendelsen';
$hesklang['asss']='Tilordne meg selv';
$hesklang['asss2']='Tilordne denne henvendelsen til meg selv';
$hesklang['can_assign_self']='Kan tilordne henvendelser til seg selv';
$hesklang['can_assign_others']='Kan tilordne henvendelser til andre';
$hesklang['can_run_reports']='Kan kjøre rapporter (egne)';
$hesklang['can_view_ass_others']='Kan se henvendelser tilordnet andre';
$hesklang['unoa']='Valgt bruker har ikke tilgang til denne kategorien';
$hesklang['tasi']='Eier tilordnet';
$hesklang['tasy']='Denne henvendelsen har blitt tilordnet til deg';
$hesklang['taso']='Denne henvendelsen har blitt tilordnet til valgt bruker';
$hesklang['tasy2']='Tilordnet meg';
$hesklang['taso2']='Tilordnet annen medarbeider';
$hesklang['nose']='Velg den nye eieren';
$hesklang['onasc']='Denne eieren har ikke tilgang til den valgte kategorien.';
$hesklang['tunasi']='Henvendelse er ikke tilordnet';
$hesklang['tunasi2']='Henvendelsen er uten eier og er klar til å tilordnes på nytt';
$hesklang['note']='Notat';
$hesklang['success']='Vellykket';
$hesklang['nyt']='Denne henvendelsen er tilordnet';
$hesklang['noch']='Ingen endringer utført';
$hesklang['orch']='Visningsrekkefølgen er endret';
$hesklang['rfm']='Nødvendig informasjon mangler:';
$hesklang['repl0']='Utilstrekkelige rettigheter for å utføre denne oppgaven';
$hesklang['repl1']='Denne posten eksisterer ikke';
$hesklang['reports']='Rapporter';
$hesklang['reports_intro']='Rapportseksjonen lar deg kjøre flere rapporter og se henvendelsesstatistikker innenfor et valgt dataområde.';
$hesklang['refi']='Tilbakestill skjemadata';
$hesklang['dich']='Forkast endringer';
$hesklang['dire']='Vis rapport';
$hesklang['m1']='Januar';
$hesklang['m2']='Februar';
$hesklang['m3']='Mars';
$hesklang['m4']='April';
$hesklang['m5']='Mai';
$hesklang['m6']='Juni';
$hesklang['m7']='Juli';
$hesklang['m8']='August';
$hesklang['m9']='September';
$hesklang['m10']='Oktober';
$hesklang['m11']='November';
$hesklang['m12']='Desember';
$hesklang['d1']='Mandag';
$hesklang['d2']='Tirsdag';
$hesklang['d3']='Onsdag';
$hesklang['d4']='Torsdag';
$hesklang['d5']='Fredag';
$hesklang['d6']='Lørdag';
$hesklang['d0']='Søndag';
$hesklang['mo']='Ma';
$hesklang['tu']='Ti';
$hesklang['we']='On';
$hesklang['th']='To';
$hesklang['fr']='Fr';
$hesklang['sa']='Lø';
$hesklang['su']='Sø';
$hesklang['from']='Fra';
$hesklang['cinv']='Ugyldig dato';
$hesklang['cinv2']='Tillatt format er mm/dd/yyyy';
$hesklang['cinm']='Ugyldig månedsverdi';
$hesklang['cinm2']='Tillatt område er';
$hesklang['cind']='Ugyldig dag i månedsverdi';
$hesklang['cind2']='Tillatt område for valgt måned er';
$hesklang['month']='Måned';
$hesklang['ocal']='Åpne kalender';
$hesklang['ca01']='Forrige år';
$hesklang['ca02']='Forrige måned';
$hesklang['ca03']='Neste måned';
$hesklang['ca04']='Neste år';
$hesklang['ca05']='Lukk kalender';
$hesklang['cdr']='Velg datoomåde:';
$hesklang['crt']='Rapporttype';
$hesklang['r1']='I dag';
$hesklang['r2']='I går';
$hesklang['r3']='Denne måned';
$hesklang['r4']='Forrige måned';
$hesklang['r5']='Siste 30 dager';
$hesklang['r6']='Denne uken (Man-Søn)';
$hesklang['r7']='Forrige uke (Man-Søn)';
$hesklang['r8']='Denne arbeidsuken (Man-Fre)';
$hesklang['r9']='Forrige arbeidsuke (Man-Fre)';
$hesklang['r10']='I år';
$hesklang['r11']='I fjor';
$hesklang['r12']='Alltid';
$hesklang['datetofrom']='&quot;Dato Fra&quot; kan ikke være senere enn &quot;Dato til&quot;. Datoene er byttet om.';
$hesklang['t1']='Henvendelser per dag';
$hesklang['t2']='Henvendelser per måned';
$hesklang['t3']='Henvendelser per bruker';
$hesklang['t4']='Henvendelser per kategori';
$hesklang['ticass']='Tilordnede henvendelser';
$hesklang['ticall']='Svarte på henvendelser';
$hesklang['totals']='Samlet';
$hesklang['all']='Alt';
$hesklang['atik']='Nye henvendelser';
$hesklang['kbca']='Du har allerede en kunnskapsbasekategori med dette navnet.';
$hesklang['menu_msg']='E-post';
$hesklang['menu_can']='Standardsvar';
$hesklang['m_from']='Fra:'; // Mail "from" address
$hesklang['m_to']='Til:'; // Mail "to" address
$hesklang['m_sub']='Emne:'; // Mail subject
$hesklang['m_re']='SV:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='VS:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Private meldinger';
$hesklang['m_intro']='Bruk private meldinger for å sende raske meldinger til andre supportmedarbeidere innenfor HESK.';
$hesklang['e_udel']='(Brukeren er slettet)';
$hesklang['new_mail']='Ny privat melding';
$hesklang['m_send']='Send melding';
$hesklang['m_rec']='Velg meldingsmottaker';
$hesklang['m_inr']='Ugyldig meldingsmottaker';
$hesklang['m_esu']='Skriv emne for privat melding';
$hesklang['m_pms']='Din private melding er sendt';
$hesklang['inbox']='INNBOKS';
$hesklang['outbox']='UTBOKS';
$hesklang['m_new']='NY MELDING';
$hesklang['pg']='Vis side';
$hesklang['npm']='Ingen private meldinger i denne mappen.';
$hesklang['m_ena']='Du har ikke tillatelse til å lese denne meldingen.';
$hesklang['mau']='Marker som ulest';
$hesklang['mo1']='Marker valgte meldinger som lest';
$hesklang['mo2']='Marker valgte meldinger som ulest';
$hesklang['mo3']='Slett valgte meldinger';
$hesklang['delm']='Slett denne meldinge';
$hesklang['e_tid']='Feil ved generering av en unik sporings-ID, vennligst prøv å registrere skjemaet igjen senere.';
$hesklang['smmr']='Valgte meldinger har blitt merket som lest';
$hesklang['smmu']='Valgte meldinger har blitt merket som ulest';
$hesklang['smdl']='Valgte meldinger har blitt slettet';
$hesklang['show']='Vis';
$hesklang['s_my']='Tilordnet til meg';
$hesklang['s_ot']='Tilordnet andre';
$hesklang['s_un']='Ikke tilordnede henvendelser';
$hesklang['s_for']='Søk etter';
$hesklang['s_in']='Søk i';
$hesklang['s_incl']='Søk innenfor';
$hesklang['find_ticket_by']='Finn en henvendelse';
$hesklang['e_nose']='Ingen tilordningsstatus valgt, viser alle henvendelser.';
$hesklang['fsq']='Skriv inn din søkestreng';
$hesklang['topen']='Åpne';
$hesklang['nms']='Ingen meldinger valgt, intet å endre';
$hesklang['tlo']='Lås henvendelse';
$hesklang['tul']='Lås opp henvendelse';
$hesklang['loc']='Låst';
$hesklang['isloc']='Kunder kan ikke svare på eller gjenåpne låste henvendelser. Når låst henvendelse er merket som løst.';
$hesklang['tlock']='Henvendelsen har blitt låst';
$hesklang['tunlock']='Henvendelsen har blitt låst opp';
$hesklang['tislock']='Denne henvendelsen har blitt låst, kunden kan ikke poste tilsvar.';
$hesklang['tislock2']='Denne henvendelsen har blitt låst, du kan ikke poste tilsvar.';
$hesklang['nsfo']='Ingen relevante artikler funnet.';
$hesklang['thist1']='<li class="smaller">%s | flyttet til kategori %s av %s</li>'; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller">%s | tilordnet %s av %s</li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class="smaller">%s | lukket av %s</li>'; // %s = date, user making change
$hesklang['thist4']='<li class="smaller">%s | åpnet av %s</li>'; // %s = date, user making change
$hesklang['thist5']='<li class="smaller">%s | låst av %s</li>'; // %s = date, user making change
$hesklang['thist6']='<li class="smaller">%s | låst opp av %s</li>'; // %s = date, user making change
$hesklang['thist7']='<li class="smaller">%s | henvendelse opprettet av %s</li>'; // %s = date, user making change
$hesklang['elocked']='Denne henvendelsen har blitt låst eller slettet.';
$hesklang['nti2']='Sett inn en ny henvendelse';
$hesklang['nti3']='Bruk dette skjemaet for å opprette en ny henvendelse i en kundes navn. Skriv inn <i>KUNDE-</i> informasjon i skjemaet (kundenavn, kundens e-post, ...) og IKKE ditt navn! Henvendelsen vil bli opprettet som om det var kunden som opprettet den.';
$hesklang['addop']='Valg';
$hesklang['seno']='Send e-postmelding til kunden';
$hesklang['otas']='Vis henvendelsen etter registrering';
$hesklang['notn']='Meldinger';
$hesklang['nomw']='Help Desk vil automatisk sende en e-postmelding når:';
$hesklang['nwts']='En ny henvendelse er registrert med eier:';
$hesklang['ncrt']='Kunden svarer på en henvendelse registrert med eier:';
$hesklang['ntam']='En henvendelse tilordnet meg';
$hesklang['npms']='En privat melding er sendt til meg';
$hesklang['support_remove']='Mye tid og arbeid er gått med til å utvikle HESK. Gi din støtte til HESK, Kjøp en lisens som også vil fjerne lenken med raklame <i>Powered by Help Desk Software HESK</i> fra din helpdesk';
$hesklang['ycvtao']='Du har ikke lov til å view henvendelser tilordnet others';
$hesklang['password_not_valid']='Passordet må være på minst 5 tegn';
$hesklang['lkbs']='Laster forslag fra kunnskapsbasen...';
$hesklang['auto']='(automatisk)';

// Added in version 2.3
$hesklang['unknown']='Ukjent';
$hesklang['pcer']='Vennligst korriger følgende feil:';
$hesklang['seqid']='Henvendelsesnummer';
$hesklang['close_action']='Merk som løst'; // Close ACTION
$hesklang['archived']='Merket';
$hesklang['archived2']='Merket henvendelse';
$hesklang['add_archive']='Merk this henvendelsen';
$hesklang['add_archive_quick']='Merk valgte henvendelser';
$hesklang['remove_archive']='Avmerk this henvendelsen';
$hesklang['remove_archive_quick']='Avmerk valgte henvendelser';
$hesklang['added_archive']='Henvendelse merket';
$hesklang['removed_archive']='Henvendelse avmerket';
$hesklang['added2archive']='Henvendelsen har blitt merket';
$hesklang['removedfromarchive']='Henvendelsen har blitt avmerket';
$hesklang['num_tickets_tag']='<b>%d</b> henvendelser har blitt merket';
$hesklang['num_tickets_untag']='<b>%d</b> henvendelser har blitt avmerket';
$hesklang['can_add_archive']='Kan merke henvendelser';
$hesklang['disp_only_archived']='Kun merkede henvendelser';
$hesklang['search_only_archived']='Kun merkede henvendelser';
$hesklang['critical']=' * Kritisk * ';
$hesklang['thist8']='<li class="smaller">%s | prioritet endret til %s av %s</li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class="smaller">%s | status endret til %s av %s</li>'; // %s = date, new status, user making change
$hesklang['thist10']='<li class="smaller">%s | automatisk tilordnet %s</li>'; // %s = date, user making change
$hesklang['thist11']='<li class="smaller">%s | sendt inn via e-post piping</li>'; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']='år';
$hesklang['abbr']['month']='mnd';
$hesklang['abbr']['week']='uke';
$hesklang['abbr']['day']='d';
$hesklang['abbr']['hour']='t';
$hesklang['abbr']['minute']='m';
$hesklang['abbr']['second']='s';
// END abberviations
$hesklang['cnsm']='Kunne ikke sende meldingen til:';
$hesklang['yhbb']='Du har blitt blokkert fra systemet i %s minutter på grunn av for mange innloggingsfeil.';
$hesklang['pwdst']='Passordstyrke';
$hesklang['tid_mail']='Ingen problemer! Legg inn din <b>E-postadresse</b> og vi vil sende deg din sporings-ID omgående:';
$hesklang['rem_email']='Husk min e-postadresse';
$hesklang['eytid']='Skriv inn din henvendelses sporings-ID.';
$hesklang['enmdb']='E-postadressen du oppga stemmer ikke overens med adressen i databasen for denne sporings-IDen.';
$hesklang['confemail']='Bekreft e-post';
$hesklang['confemail2']='Vennligst bekreft din e-postadresse';
$hesklang['confemaile']='De to e-postadressene er ikke identiske';
$hesklang['taso3']='Tilordnet:';
$hesklang['sec_enter']='Skriv inn sifrene du ser i bildet nedenfor.';
$hesklang['reload']='Last bilde på nytt';
$hesklang['verify_q']='SPAM-beskyttelse:'; // For anti-spam question
$hesklang['verify_i']='SPAM-beskyttelse:'; // For anti-spam image (captcha)
$hesklang['admin_login']='Inlogging for supportmedarbeidere';
$hesklang['vrfy']='Test bestått';
$hesklang['last_update']='Oppdatert';
$hesklang['cot']='Ikke tving kritiske henvendelser til visning øverst';
$hesklang['def']='Gjør dette til min standardvisning';
$hesklang['gbou']='Disse henvendelsene er <b>Ikke tilordnet</b>:';
$hesklang['gbom']='Henvendelser tilordnet <b>me</b>:';
$hesklang['gboo']='Henvendelser tilordnet <b>%s</b>:';
$hesklang['select']=' - - Klikk for å velge - - ';
$hesklang['chngstatus']='Endre status til';
$hesklang['perat']='%s av alle henvendelser'; // Will change to "23% of all tickets"
$hesklang['viewart']='Se denne artikkelen';
$hesklang['chdp']='Vennligst endre standardpassordet for din <a href="profile.php">profil</a> side!';
$hesklang['chdp2']='Endre ditt passord, du benytter standardpassordet!';
$hesklang['security']='Sikkerhet';
$hesklang['kb_i_art']='Ny artikkel';
$hesklang['kb_i_art2']='Sett inn en artikkel';
$hesklang['kb_i_cat']='Ny kategori';
$hesklang['kb_i_cat2']='Sett inn en kategori';
$hesklang['gopr']='Se kunnskapsbasen';
$hesklang['kbstruct']='Kunnskapsbasens struktur';
$hesklang['cancel']='Avbryt';
$hesklang['sh']='Skjul melding';
$hesklang['goodkb']='Hvordan skrive gode artikler til kunnskapsbasen?';
$hesklang['catset']='Kategoriinnstillinger';
$hesklang['inpr']='Velg ny prioritet';
$hesklang['incat']='Velg den nye kategorien';
$hesklang['instat']='Velg ny status';
$hesklang['tsst']='Henvendelsestatus har blitt satt til %s';
$hesklang['aass']='Tilordne automatisk';
$hesklang['aaon']='Automatisk tilordning av henvendelser aktivert (klikk for å deaktivere)';
$hesklang['aaoff']='Automatisk tilordning av henvendelser deaktivert (klikk for å aktivere)';
$hesklang['uaaon']='Automatisk tilordning har blitt aktivert for valgt bruker';
$hesklang['uaaoff']='Automatisk tilordning har blitt deaktivert for valgt bruker';
$hesklang['taasy']='Denne henvendelsen har blitt automatisk tilordnet deg';
$hesklang['can_view_unassigned']='Kan se henvendelser uten tilordning';
$hesklang['ycovtay']='Du kan kun se henvendelser tilordnet deg';
$hesklang['in_progress']='Under arbeid';
$hesklang['on_hold']='På hold';
$hesklang['import_kb']='Importer denne henvendelsen til en kunnskapsbaseartikkel';
$hesklang['import']='Du er i ferd med å importere en <i>private henvendelse</i> inn i en <i>offentlig artikkel</i>.<br /><br />Påse at du sletter all privat eller sensitiv informasjon fra artikkelen, emne og melding!';
$hesklang['tab_1']='Generelt';
$hesklang['tab_2']='Help Desk';
$hesklang['tab_3']='Kunnskapsbase';
$hesklang['tab_4']='Egendefinerte felt';
$hesklang['tab_5']='Div.';
$hesklang['disable']='Deaktiver';
$hesklang['dat']='Dato &amp; Tid';
$hesklang['lgs']='Språk';
$hesklang['onc']='PÅ - Kunder';
$hesklang['ons']='PÅ - Alle';
$hesklang['viewvtic']='Se henvendelser';
$hesklang['reqetv']='Krev e-post for å se en henvendelse';
$hesklang['banlim']='Grense for innloggingsforsøk';
$hesklang['banmin']='Blokkeringstid (minutter)';
$hesklang['subnot']='Registrer varsel';
$hesklang['subnot2']='Vis varsel til kunder som registrerer henvendelser';
$hesklang['eseqid']='Sekvensielle ID-er';
$hesklang['sconfe']='Bekreft e-post';
$hesklang['saass']='Tilordne henvendelser automatisk';
$hesklang['swyse']='WYSIWYG Editor';
$hesklang['hrts']='Vurder HESK';
$hesklang['hrts2']='Vis Vurder dette skriptet-lenke i adminpanelet';
$hesklang['emlpipe']='E-post Piping';
$hesklang['emlsend2']='Send e-poster med';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='SMTP Tjener';
$hesklang['smtph']='SMTP Vert';
$hesklang['smtpp']='SMTP Port';
$hesklang['smtpu']='SMTP Brukernavn';
$hesklang['smtpw']='SMTP Passord';
$hesklang['smtpt']='SMTP Tidsavbrudd';
$hesklang['other']='Annet';
$hesklang['features']='Egenskaper';
$hesklang['can_view_online']='Kan se supportmedarbeidere som er online';
$hesklang['online']='Online';
$hesklang['offline']='Offline';
$hesklang['onlinep']='Brukere Online'; // For display in footer
$hesklang['sonline']='Brukere Online'; // For settings page
$hesklang['sonline2']='Vis online brukere. Begrens (minutter):'; // For settings page
$hesklang['gb']='Grupper etter';
$hesklang['dg']='Ikke grupper';
$hesklang['err_dpi']='Databasen %s inneholder ikke alle HESK-tabeller med prefix %s, ingen endringer lagret.';
$hesklang['err_dpi2']='Fant ikke tabeller:';
$hesklang['sme']='SMTP-feil';
$hesklang['scl']='SMTP tilkoblingslogg';
$hesklang['dnl']='Last ned';
$hesklang['dela']='Slett dette vedlegget';
$hesklang['pda']='Vil du slette dette vedlegget permanent?';
$hesklang['thist12']='<li class="smaller">%s | vedlegg %s slettet av %s</li>'; // %s = date, deleted attachment, user making change
$hesklang['mopt']='Flere valg';
$hesklang['lopt']='Færre valg';
$hesklang['meml']='Flere e-poster';
$hesklang['meml2']='Tillate kunder å legge inn flere e-postadresser';

// Added in version 2.4
$hesklang['catd']='(kategori slettet)';
$hesklang['noopen']='Ingen åpne henvendelser funnet for denne e-postadressen.';
$hesklang['maxopen']='Du har nådd maksimalt antall åpne henvendelser (%d of %d). Vennligst vent til dine eksisterende henvendelser er løst før du åpner nye henvendelser.';
$hesklang['ntnote']='Noen legger til et notat i en henvendelse tilordnet meg';
$hesklang['cat_public']='Denne kategorien er OFFENTLIG (klikk for å endre til privat)';
$hesklang['cat_private']='Denne kategorien er PRIVAT (klikk for å endre til offentlig)';
$hesklang['cat_aa']='Automatisk tilordne henvendelser i denne kategorien.';
$hesklang['cat_type']='Gjør denne kategorien privat (kun medarbeidere kan velge den).';
$hesklang['caaon']='Automatisk tilordning har blitt aktivert for valgt kategori';
$hesklang['caaoff']='Automatisk tilordning har blitt deaktivert for valgt kategori';
$hesklang['cpub']='Kategoritypen er endret til OFFENTLIG';
$hesklang['cpriv']='Kategoritypen er endret til PRIVAT';
$hesklang['cpric']='Kunder kan ikke velge private kategorier, kun medarbeidere kan!';
$hesklang['user_aa']='Automatisk tilordne henvendelser til denne brukeren.';
$hesklang['attach_size']='Maksimal filstørrelse';
$hesklang['B']='B';
$hesklang['kB']='kB';
$hesklang['MB']='MB';
$hesklang['GB']='GB';
$hesklang['bytes']='bytes';
$hesklang['kilobytes']='kilobytes';
$hesklang['megabytes']='megabytes';
$hesklang['gigabytes']='gigabytes';
$hesklang['smtpssl']='SSL Protokoll';
$hesklang['smtptls']='TLS Protokoll';
$hesklang['oo']='Kun åpne';
$hesklang['ool']='List opp kun åpne henvendelser i e-post for &quot;Glemt sporings-ID&quot; ';
$hesklang['mop']='Maks antall åpne henvendelser';
$hesklang['rord']='Tilsvarsrekkefølge';
$hesklang['newbot']='Nyeste svar nederst';
$hesklang['newtop']='Nyeste svar øverst';
$hesklang['ford']='Svarskjema';
$hesklang['formbot']='Vis skjema nederst';
$hesklang['formtop']='Vis skjema øverst';
$hesklang['mysqlv']='MySQL versjon';
$hesklang['phpv']='PHP versjon';
$hesklang['csrt']='Nåværende HESK tid:';
$hesklang['listp']='List opp private artikler';
$hesklang['listd']='List opp artikkelutkast';
$hesklang['artp']='Private artikler';
$hesklang['artd']='Artikkelutkast';
$hesklang['kb_no_part']='Ingen private artikler i kunnskapsbasen.';
$hesklang['kb_no_dart']='Ingen artikkelutkast i kunnskapsbasen.';
$hesklang['attpri']='Du har ikke tilgang til dette vedlegget.';
$hesklang['can_merge_tickets']='Slå sammen henvendelser';
$hesklang['mer_selected']='Slå sammen valgte henvendelser';
$hesklang['merged']='Valgte henvendelser har blitt slått sammen til én.';
$hesklang['merge_err']='Det oppsto et problem med å slå sammen henvendelser:';
$hesklang['merr1']='velg minst to henvendelser.';
$hesklang['merr2']='målhenvendelse ikke funnet.';
$hesklang['merr3']='henvendelse i en kategori du ikke har tilgang til.';
$hesklang['tme']='Henvendelse %s har blitt slått sammen med denne henvendelsen (%s).';
$hesklang['tme1']='Henvendelse %s har blitt slått sammen med henvendelse %s';
$hesklang['tme2']='For å se en henvendelse %s skriv inn tilhørende e-postadresse.';
$hesklang['eyou']='Bruk profilsiden for å redigere dine innstillinger.';
$hesklang['npea']='Du har ikke tilgang til å redigere denne brukeren.';
$hesklang['duplicate_user']='En bruker med dette brukernavnet eksisterer allerede, velg et annet brukernavn.';
$hesklang['kw']='Nøkkelord';
$hesklang['kw1']='(valgfritt - separer ved hjelp av mellomrom, komma eller ny linje)';
$hesklang['type_not_allowed']='Filer som ender på <b>%s</b> aksepteres ikke (%s)'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='Kunden har ikke lest dette svaret ennå.';
$hesklang['sticky']='Gjør denne artikkelen &quot;sticky&quot;';
$hesklang['stickyon']='Endre artikkelen til &quot;sticky&quot;';
$hesklang['stickyoff']='Endre artikkelen til &quot;normal&quot;';
$hesklang['ason']='Artikkel merket som &quot;sticky&quot;';
$hesklang['asoff']='Artikkel merket som &quot;normal&quot;';
$hesklang['ts']='Arbeidstid';
$hesklang['start']='Start / Stopp';
$hesklang['reset']='Reset';
$hesklang['save']='Lagre';
$hesklang['hh']='Timer';
$hesklang['mm']='Minutter';
$hesklang['ss']='Sekunder';
$hesklang['thist']='Henvendelseshistorikk';
$hesklang['thist13']='<li class="smaller">%s | slått sammen med henvendelse %s av %s</li>'; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class="smaller">%s | arbeidstid oppdatert til %s av %s</li>'; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class="smaller">%s | sendt inn av %s</li>'; // %s = date, user making change
$hesklang['thist16']='<li class="smaller">%s | sendt inn av POP3-henting</li>';
$hesklang['twu']='Arbeidstiden på henvendelsen har blitt oppdatert.';
$hesklang['autoss']='Start tidslogging automatisk når jeg åpner en henvendelse';
$hesklang['ful']='Begrensninger for opplasting av filer';
$hesklang['ufl']='Du kan laste opp filer med etternavn:';
$hesklang['nat']='Maks antall vedlegg:';
$hesklang['mfs']='Maks filstørrelse per vedlegg:';
$hesklang['lps']='Ditt språkvalg er lagret';
$hesklang['sav']='Vis artikkelvisninger';
$hesklang['sad']='Vis artikkeldato';
$hesklang['emp']='Din PHP har ikke MySQL-support aktivert (mysqli utvidelse er påkrevet)';
$hesklang['epd']='[HESK] EMAIL PIPING ER DEAKTIVERT I INNSTILLINGER';
$hesklang['pfd']='[HESK] POP3 HENTING ER DEAKTIVERT I INNSTILLINGER';
$hesklang['pem']='[Piped email]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Kunde]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='E-post';
$hesklang['pop3']='POP3-henting';
$hesklang['pop3h']='POP3 Vert';
$hesklang['pop3p']='POP3 Port';
$hesklang['pop3tls']='TLS Protokoll';
$hesklang['pop3u']='POP3 Brukernavn';
$hesklang['pop3w']='POP3 Passord';
$hesklang['pop3e']='POP3 feil';
$hesklang['pop3log']='POP3 tilkoblingslogg';
$hesklang['mysqltest']='Test MySQL-tilkobling';
$hesklang['smtptest']='Test SMTP-tilkobling';
$hesklang['pop3test']='Test POP3-tilkobling';
$hesklang['contest']='Tester tilkobling, dette kan ta en stund...';
$hesklang['conok']='Tilkoblingen var vellykket!';
$hesklang['conokn']='Men, hvis din server forlanger brukernavn og passord, vil ike e-poster bli sendt!';
$hesklang['saving']='Lagrer innstillinger, vennligst vent...';
$hesklang['sns']='Innstillingene ble lagret, men noen funksjoner ble beaktivert på grunn av feil under test.';
$hesklang['looph']='Maks treff';
$hesklang['loopt']='Tidsrom';
$hesklang['didum']='Mente du %s?'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Ja  fiks det';
$hesklang['nole']='Nei, la det være';
$hesklang['sconfe2']='Vis a &quot;Bekreft e-post&quot; felt på "Registrer en henvendelse" -skjema';
$hesklang['oln']='Gammelt navn:';
$hesklang['nen']='Nytt navn:';
$hesklang['use_form_below']='<i>Bruk dette skjemaet for å registrere en supporthenvendelse. Obligatoriske felt er merket med</i>';
$hesklang['esf']='Kunne ikke sende e-postvarsel.';
$hesklang['qrr']='(fjernet sitert svar)';
$hesklang['remqr']='Fjern siterte svar';
$hesklang['remqr2']='Slett sitert svar i e-post fra kunde';
$hesklang['suge']='Detekter e-posttjenester';
$hesklang['epro']='E-postleverandører';
$hesklang['email_noreply']='&quot;Fra:&quot; e-post';
$hesklang['email_name']='&quot;Fra:&quot; navn';
$hesklang['vscl']='Konfigurasjonsbegrensninger for server';
$hesklang['fnuscphp']='Filopplasting feilet, forsøk med mindre, færre eller ingen filvedlegg.';
$hesklang['redv']='returner til standardvisning';
$hesklang['fatte1']='Din innstilling for vedlegg &quot;Antall per post&quot; er større enn hva din server tillater!';
$hesklang['fatte2']='Din maksimale filstørrelse er større enn hva din server tillater!';
$hesklang['fatte3']='Din server tillater ikke store nok posteringer, forsøk å redusere antall vedlegg eller tillatt filstørrelse!';
$hesklang['embed']='Innebygde filer';
$hesklang['embed2']='Lagre innebygde filer som vedlegg';
$hesklang['emrem']='(bilde fjernet)';
$hesklang['hdemo']='(SKJULT I DEMO)';
$hesklang['ddemo']='Beklager, denne funksjonen er deaktivert i DEMO-modus!';
$hesklang['sdemo']='Lagre endringer er deaktivert in DEMO-modus';
$hesklang['hud']='HESK er oppdatert';
$hesklang['hnw']='Oppdatering er tilgjengelig';
$hesklang['getup']='Oppdater HESK';
$hesklang['updates']='Oppdateringer';
$hesklang['updates2']='Sjekk automatisk etter HESK oppdateringer.';

// Added in version 2.5.0
$hesklang['attdel']='Denne filen har blitt slettet fra serveren og er ikke lenger tilgjengelig for nedlasting';
$hesklang['dsen']='Ikke send e-postmelding for dette svaret til kunden';
$hesklang['attrem']='* Noen vedlagte filer har blitt fjernet *';
$hesklang['attnum']='Maksimalt antall er nådd: %s'; // %s will show attachment name
$hesklang['attsiz']='For stor file: %s'; // %s will show attachment name
$hesklang['atttyp']='Filtypen er ikke tillatt: %s'; // %s will show attachment name
$hesklang['adf']='Administratormappe';
$hesklang['atf']='Mappe for vedlegg';
$hesklang['err_adf']='Den valgte adminmappen (%s) eksisterer ikke!'; // %s will show folder name
$hesklang['err_atf']='Den valgte vedleggsmappen (%s) eksisterer ikke!'; // %s will show folder name
$hesklang['err_atr']='Den valgte vedleggsmappen (%s) er ikke skrivbar!'; // %s will show folder name
$hesklang['fatt']='Filer vedlagt denne meldingen:';
$hesklang['wrepo']='Vennligst skriv et svar etter gjenåpning av henvendelsen.';
$hesklang['ktool']='&raquo; Kunnskapsbaseverktøy';
$hesklang['uac']='Verifiser og oppdater antall kategoriartikler';
$hesklang['acv']='Artikkelantall er verifisert';
$hesklang['xyz']='antall offentlige, private og artikkelutkast i kategori.';
$hesklang['reports_tab']='Kjør rapporter'; // Tab title
$hesklang['can_run_reports_full']='Kan kjøre rapporter (alle)';
$hesklang['can_export']='Kan eksportere henvendelser';
$hesklang['roo']='<i>(kun henvendelser tilordnet deg er inkludert i rapporten)</i>';
$hesklang['shu']='Korte lenker';
$hesklang['export']='Eksporter henvendelser'; // Tab title
$hesklang['export_btn']='Eksporter henvendelser'; // Button title
$hesklang['export_intro']='Dette verktøyet gir deg muligheten til å eksportere henvendelser til et XML regneark som kan åpnes i Excel.';
$hesklang['stte']='Velg henvendelser som skal eksporteres';
$hesklang['dtrg']='Datointervall';
$hesklang['sequentially']='Sekvensielt'; // Order tickets: Sequentially
$hesklang['ede']='Kan ikke opprette katalog for eksport, vennligst lag en mappe kalt <b>export</b> inne i din vedleggsmappe, og forsikre deg om at denne kan skrives til av PHP (i Linux CHMOD den til 777 - rwxrwxrwx).';
$hesklang['eef']='Kan ikke opprette eksportfil, ingen skriverettigheter i eksportmappen.';
$hesklang['inite']='Initialiserer eksport';
$hesklang['gXML']='Genererer XML fil';
$hesklang['nrow']='Antall rader eksportert: %d'; // %d will show number of rows exported
$hesklang['cZIP']='Komprimerer filen til et Zip-arkiv';
$hesklang['eZIP']='Feil under oppretting av Zip-arkiv';
$hesklang['fZIP']='Ferdig med filkomprimering';
$hesklang['pmem']='Topp minnebruk: %.2f Mb'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo; KLIKK HER FOR Å LASTE NED EKSPORTFILEN &laquo;';
$hesklang['n2ex']='Ingen henvendelser funnet som matcher dine kriterier, intet å eksportere!';
$hesklang['sp']='SPAM-beskyttelse'; // For settings page
$hesklang['sit']='-&gt; Bildetype';
$hesklang['sis']='Enkelt bilde';
$hesklang['rcpb']='Site key (Offentlig nøkkel)';
$hesklang['rcpv']='Secret key (Privat nøkkel)';
$hesklang['pop3keep']='Behold en kopi';
$hesklang['beta']='(TESTVERSJON)';
$hesklang['maxpost']='Du forsøkte sannsynligvis å sende mer data enn hva denne serveren aksepterer.<br /><br />Vennligst forsøk å sende inn skjemaet på nytt med mindre, færre eller ingen vedlegg.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='Feil SPAM beskyttelsessvar, vennligst forsøk på nytt.';

// Added in version 2.6.0
$hesklang['ticket_closed']='[#%%TRACK_ID%%] Henvendelse lukket/løst';
$hesklang['ms01']='Jan';
$hesklang['ms02']='Feb';
$hesklang['ms03']='Mar';
$hesklang['ms04']='Apr';
$hesklang['ms05']='Mai';
$hesklang['ms06']='Jun';
$hesklang['ms07']='Jul';
$hesklang['ms08']='Aug';
$hesklang['ms09']='Sep';
$hesklang['ms10']='Okt';
$hesklang['ms11']='Nov';
$hesklang['ms12']='Des';
$hesklang['sdf']='Registrert datoformat';
$hesklang['lcf']='Oppdatert datoformat';
$hesklang['lcf0']='Kort beskrivelse';
$hesklang['lcf1']='Dato og tid';
$hesklang['lcf2']='HESK style';
$hesklang['ticket_tpl']='Henvendelsesmaler';
$hesklang['can_man_ticket_tpl']='Behandle henvendelsesmaler'; // Permission title
$hesklang['ticket_tpl_man']='Behandle henvendelsesmaler'; // Page and link title
$hesklang['ticket_tpl_intro']='Lag og behandle henvendelsesmaler som du kan bruke for å hurtig kunne registrere nye henvendelser fra administratorgrensesnittet.';
$hesklang['no_ticket_tpl']='Ingen henvendelsesmaler';
$hesklang['ticket_tpl_title']='Tittel';
$hesklang['delete_tpl']='Er du sikker på at du vil slette denne malen?';
$hesklang['new_ticket_tpl']='Legg til eller rediger mal';
$hesklang['ticket_tpl_add']='Lag en ny henvendelsesmal';
$hesklang['ticket_tpl_edit']='Rediger valgt henvendelsesmal';
$hesklang['save_ticket_tpl']='Lagre henvendelsesmal';
$hesklang['ticket_tpl_saved']='Din henvendelsesmal har blitt lagret for fremtidig bruk';
$hesklang['ticket_tpl_removed']='Valgte henvendelsesmal har blitt fjernet fra databasen';
$hesklang['ticket_tpl_not_found']='Fant ikke henvendelsesmal';
$hesklang['sel_ticket_tpl']='Velg henvendelsesmalen du ønsker å redigere';
$hesklang['ent_ticket_tpl_title']='Vennligst legg inn maltittel';
$hesklang['ent_ticket_tpl_msg']='Vennligst legg inn malmelding';
$hesklang['ticket_tpl_id']='Manglende ID for henvendelsesmal';
$hesklang['select_ticket_tpl']='Velg en henvendelsesmal';
$hesklang['list_tickets_cat']='List opp alle henvendelser i denne kategorien';
$hesklang['def_msg']='[Ingen melding]';
$hesklang['emlreqmsg']='Krev melding';
$hesklang['emlreqmsg2']='Ignorer piped/hentede e-poster uten melding';
$hesklang['relart']='Relaterte artikler'; // Title of related articles box
$hesklang['s_relart']='Relaterte artikler'; // On settings page
$hesklang['tab_7']='Henvendelsesliste';
$hesklang['fitl']='Felter i henvendelsesliste';
$hesklang['submitted']='Registrerte';
$hesklang['clickemail']='Vis';
$hesklang['set_pri_to']='Sett prioritet til:'; // Action below the ticket list
$hesklang['pri_set_to']='Prioritet har blitt satt til:';
$hesklang['cat_pri']='Kategoriprioriteten vil bli benyttet hvis kunder ikke tillates å velge prioritet og en henvendelse er registrert fra kundegrensesnittet.';
$hesklang['cat_pri_info']='Dine kunder tillates å sette prioritet, så kategoriprioritet vil bli ignorert.<br /><br />For å benytte kategoriprioritet i stedet, slå AV følgende funksjon i innstillingene for HESK:';
$hesklang['def_pri']='Kategoriprioritet:';
$hesklang['ch_cat_pri']='Sett kategoriprioritet';
$hesklang['cat_pri_ch']='Kategoriprioriteten har blitt satt til:';
$hesklang['err_dbversion']='For gammel MySQL versjon:';
$hesklang['ip_whois']='IP whois';
$hesklang['ednote']='Rediger notatmelding';
$hesklang['ednote2']='Notatmeldingen er lagret';
$hesklang['perm_deny']='Tillatelse er avslått';
$hesklang['mis_note']='Manglende notat-ID';
$hesklang['no_note']='Kunne ikke finne notat med denne ID';
$hesklang['sacl']='Lagre og fortsett senere';
$hesklang['reply_saved']='Din svarmelding har blitt lagret for senere bruk.';
$hesklang['submit_as']='Registrer som:';
$hesklang['sasc']='Registrer som tilsvar fra kunde';
$hesklang['creb']='Tilsvar fra kunde lagt inn av:';
$hesklang['show_select']='Vis &quot;Klikk for å velge&quot; som standardvalg';
// Settings
$hesklang['mms']='Vedlikeholdsmodus';
$hesklang['mmd']='Aktiviser vedlikeholdsmodus';
// Customer notice
$hesklang['mm1']='Vedlikehold pågår';
$hesklang['mm2']='For å kunne utføre planlagt vedlikehold, er vår supporttjeneste midlertidig stengt.';
$hesklang['mm3']='Vi beklager ulempene dette måtte medføre, og ber om at du prøver igjen senere.';
// Staff notice
$hesklang['mma1']='Vedlikeholdsmodus er aktiv!';
$hesklang['mma2']='Kunder kan ikke benytte supporttjenesten.';
$hesklang['tools']='Verktøy';
$hesklang['banemail']='Utestengt e-post';
$hesklang['banemail_intro']='Hindre enkelte e-postadresser fra å kunne registrere supporthenvendelser.';
$hesklang['no_banemails']='<i>Ingen e-poster er utestengt.</i>';
$hesklang['eperm']='Permanente ee-postutestengelser:';
$hesklang['bananemail']='E-postadresse for utestengelse';
$hesklang['savebanemail']='Steng ute denne e-posten';
$hesklang['enterbanemail']='Registrer e-postadressen du ønsker å utestenge.';
$hesklang['validbanemail']='Registrer en gyldig e-postadresse (<i>john.doe@domain.com</i>) eller e-postdomene (<i>@domain.com</i>)';
$hesklang['email_banned']='Denne e-postadressen <i>%s</i> ble utestengt og HESK vil ikke lenger akseptere henvendelser fra denne adressen.'; // %s will be replaced with email
$hesklang['emailbanexists']='E-postadressen <i>%s</i> er allerede utestengt.'; // %s will be replaced with email
$hesklang['email_unbanned']='E-postutestengelse er slettet';
$hesklang['banby']='Utestengt av';
$hesklang['delban']='Slett utestengelse';
$hesklang['delban_confirm']='Slett denne utestengelsen?';
$hesklang['baned_e']='Du har blitt utestengt fra å kunne registrere nye supporthenvendelser.';
$hesklang['baned_ip']='Du har blitt utestengt fra denne supporttjenesten';
$hesklang['can_ban_emails']='Kan utestenge e-poster';
$hesklang['can_unban_emails']='Kan oppheve utestengelse av e-post (aktiviserer Kan utestenge e-poster)';
$hesklang['eisban']='Denne e-postadressen er utestengt.';
$hesklang['click_unban']='Klikk her for å oppheve utestengelse.';
$hesklang['banip']='Utestengte IP-adresser';
$hesklang['banip_intro']='Besøkende fra itestengte IP-adresser vil ikke kunne se på eller registrere henvendelser eller logge inn på supporttjenestenk.';
$hesklang['ipperm']='Permanente IP-utestengelser:';
$hesklang['iptemp']='Utestengelser grunnet innloggingsfeil:';
$hesklang['savebanip']='Steng ute denne IP-adressen';
$hesklang['no_banips']='<i>Ingen IP-adresser er utestengt.</i>';
$hesklang['bananip']='IP-adresse som skal utestenges';
$hesklang['banex']='Eksempler:';
$hesklang['iprange']='IP-område';
$hesklang['ippermban']='Steng ute denne IP-adressen permanent';
$hesklang['enterbanip']='Legg inn IP-adressen eller området du ønsker å stenge ute.';
$hesklang['validbanip']='Legg inn en gyldig IP-adresse eller IP-område';
$hesklang['ip_banned']='IP-addressen <i>%s</i> ble utestengt, og HESK vil ikke lenger akseptere henvendelser fra denne IP-adressen.'; // %s will be replaced with IP
$hesklang['ip_rbanned']='IP-området <i>%s</i> ble utestengt, og HESK vil ikke lenger akseptere henvendelser fra dette IP-området.'; // %s will be replaced with IP
$hesklang['ipbanexists']='IP-addressen <i>%s</i> er allerede utestengt.'; // %s will be replaced with IP
$hesklang['iprbanexists']='IP-området <i>%s</i> er allerede utestengt.'; // %s will be replaced with IP
$hesklang['ip_unbanned']='Utestengelse av IP-adresse er slettet';
$hesklang['ip_tempun']='Midlertidig utestengelse av IP-adresse er slettet';
$hesklang['can_ban_ips']='Kan stenge IP-adresser ute';
$hesklang['can_unban_ips']='Kan oppheve utestengelse av IP-adresser (aktiviserer Kan stenge ute IP-adresser)';
$hesklang['ipisban']='Denne IP-adressen er utestengt.';
$hesklang['m2e']='Utgår om (minutter)';
$hesklang['info']='Info';
$hesklang['sm_title']='Servicemeldinger';
$hesklang['sm_intro']='Vis en servicemelding i kundområdet, eksempelvis for å informere om kjente problemer og viktige nyheter.';
$hesklang['can_service_msg']='Rediger servicemeldinger';
$hesklang['new_sm']='Ny servicemelding';
$hesklang['edit_sm']='Rediger servicemelding';
$hesklang['ex_sm']='Eksisterende servicemeldinger';
$hesklang['sm_author']='Forfatter';
$hesklang['sm_type']='Type';
$hesklang['sm_published']='Publisert';
$hesklang['sm_draft']='Kladd';
$hesklang['sm_style']='Stil';
$hesklang['sm_none']='Ingen';
$hesklang['sm_success']='Suksess';
$hesklang['sm_info']='Info';
$hesklang['sm_notice']='Notis';
$hesklang['sm_error']='Feil';
$hesklang['sm_save']='Lagre servicemelding';
$hesklang['sm_preview']='Forhåndsvis servicemelding';
$hesklang['sm_mtitle']='Tittel';
$hesklang['sm_msg']='Melding';
$hesklang['sm_e_title']='Legg inn tittel for servicemelding';
$hesklang['sm_e_msg']='Legg inn servicemelding';
$hesklang['sm_e_id']='Manglende meldings-ID';
$hesklang['sm_added']='En ny servicemelding har blitt lagt til';
$hesklang['sm_deleted']='Servicemelding er slettet';
$hesklang['sm_not_found']='Denne servicemeldingen eksisterer ikke';
$hesklang['no_sm']='Ingen servicemeldinger';
$hesklang['del_sm']='Slett denne servicemldingen?';
$hesklang['sm_mdf']='Servicemelding har blitt lagret';
$hesklang['sska']='Vis foreslåtte artikler';
$hesklang['taws']='Disse artiklene ble foreslått:';
$hesklang['defaults']='Standarder';
$hesklang['pncn']='Velg å gi beskjed til kunden i det nye henvendelsesskjemaet';
$hesklang['pncr']='Velg å gi beskjed til kunden i det nye henvendelsessvarskjemaet';
$hesklang['pssy']='Vis hvilke kunnskapsbaseartikler som ble foreslått til kunder';
$hesklang['ccct']='Kundeløsning';
$hesklang['custnot']='Gi beskjed til kunder når';
$hesklang['notnew']='En ny supporthenvendelse er registrert';
$hesklang['notclo']='En supporthenvendelse er merket som løst';
$hesklang['enn']='Unntak for Email piping/POP3-henting hvis e-postemne inneholder:';
$hesklang['spamn']='SPAM-melding';
$hesklang['spam_inbox']='<span style="color:red"><b>Ingen e-postbekreftelse?</b><br />Vi sendte en e-postbekreftelse til din e-postadresse. Hvis du ikke mottar denne e-posten innen noen få minutter, vennligst kontroller mapper for søppelpost eller SPAM. Merk meldingen som <b>Ikke SPAM</b> for å unngå problemer med å motta fremtidig korrespondanse fra oss.</span>';
$hesklang['ekb_n']='<b>NEI</b>, Deaktiver kunnskapsbase';
$hesklang['ekb_y']='<b>JA</b>, Aktiver kunnskapsbase';
$hesklang['ekb_o']='<b>JA</b>, Bruk HESK kun som kunnskapsbase (<i>deaktiver help desk</i>)';
$hesklang['kb_set']='Innstillinger for kunnskapsbase';
$hesklang['kbo1']='Modus for kunnskapsbase alene';
$hesklang['kbo2']='<br /><br />Besøkende kan ikke registrere supporthenvendelser og blir dirigert direkte til kunnskapsbasen.';
$hesklang['fpass']='Har du glemt ditt passord?';
$hesklang['passr']='Tilbakestilling av passord';
$hesklang['passa']='Tillat brukere å tilbakestille et glemt passord via e-post';
$hesklang['passe']='Legg inn din e-postadresse';
$hesklang['passs']='Send meg en lenke for tilbakestilling av passordet';
$hesklang['noace']='Ingen brukerkonto med denne e-postadressen ble funnet';
$hesklang['pemls']='Vi sendte deg en e-post med instruksjoner for hvordan du kan tilbakestille ditt passord';
$hesklang['reset_password']='Tilbakestilling av ditt passord til supporttjenesten'; // Email subject
$hesklang['ehash']='Ugyldig eller utgått lenke for tilbakestilling av passord';
$hesklang['ehaip']='Feil IP-adresse. Passord kan kun tilbakestilles fra den IP-adressen som anmodet om tilbakestilling av passordet.';
$hesklang['resim']='<b>Sett opp ditt nye passord i skjemaet nedenfor!</b>';
$hesklang['permissions']='Tillatelser';
$hesklang['atype']='Kontotype';
$hesklang['astaff']='Medarbeidere';
$hesklang['oon1']='Send meg kun åpne henvendelser';
$hesklang['oon2']='Send meg alle mine henvendelser';
$hesklang['anyown']='Vilkårlig eier';
$hesklang['pfr']='En annen POP3-hentejobb pågår fremdeles.';
$hesklang['pjt']='Tidsavbrudd for oppgave';
$hesklang['pjt2']='minutter etter start';
$hesklang['nkba']='Søk i kunnskapsbasen krever et tilstrekkelig antall unike artikler for å fungere som tiltenkt.<br /><br />Vurder å legge til flere artikler i kunnskapsbasen for å bedre søkeresultater og artikkelforslag.';
$hesklang['saa']='Klebrige artikler vises på toppen av artikkellisten';
$hesklang['yhbr']='Du har blitt stengt ute fra systemet for en periode på %s minutter grunnet for mange tilsvar på en henvendelse.';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='no';

// Added in version 2.7.0
$hesklang['imap']='IMAP-henting';
$hesklang['imaph']='IMAP Host';
$hesklang['imapp']='IMAP Port';
$hesklang['enc']='Kryptering';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='None';
$hesklang['imapu']='IMAP Brukernavn';
$hesklang['imapw']='IMAP Passord';
$hesklang['imaptest']='Test IMAP-forbindelse';
$hesklang['ifd']='[HESK] IMAP-HENTING ER DEAKTIVERT I INNSTILLINGER';
$hesklang['iei']='[HESK] PHP IMAP-utvidelse er ikke installert.';
$hesklang['ifr']='En annen IMAP-hentejobb pågår.';
$hesklang['arp']='Oppdater siden automatisk';
$hesklang['arpp']='Oppdater automatisk siden med oppdragsliste hver:';
$hesklang['seconds']='sekunder';
$hesklang['minutes']='minutter';
$hesklang['atbr']='Denne henvendelsen må tildeles noen før den kan besvares.';
$hesklang['attm']='Tildel denne henvendelsen til meg';
$hesklang['owneed']='Eier er nødvendig';
$hesklang['taat']='Denne henvendelsen er allerede tildelt <b>%s</b>.';
$hesklang['scoy']='Er du sikker på at du vil tildele til deg selv?';
$hesklang['scot']='Er du sikker på at du vil tildele den til %s?';
$hesklang['ycto']='JA, endre eier';
$hesklang['ncto']='NEI, behold nåværende eier';
$hesklang['fass']='Eier kreves';
$hesklang['req_sub']='Emne kreves';
$hesklang['req_msg']='Melding kreves';
$hesklang['req_email']='Krev e-postadresse';
$hesklang['default_subject']='Henvendelse fra %s';
$hesklang['off-hide']='Skjul i kundeskjema';
$hesklang['not_valid_email']='Skriv inn en gyldig e-post adresse eller la dette feltet være tomt';
$hesklang['write_down']='<span style="color:red">Vi anbehfaler at du skriver ned din sporings-ID for senere referanse.</span>';
$hesklang['re_confirm1']='Deaktivering dette vl også deaktivere "Krev e-postadresse for å se henvendelser" under "Sikkerhet". Fortsette?';
$hesklang['re_confirm2']='Aktivering vil også aktivere "Krev e-post" under "Egenskaper". Fortsette?';
$hesklang['can_email_tpl']='Redigere e-postmaler';
$hesklang['et_title']='E-postmaler';
$hesklang['et_intro']='Endre e-poster som sendes til ansatte og kunder';
$hesklang['file']='Fil';
$hesklang['efile']='Rediger fil';
$hesklang['rdesc']='(Mottaker) Beskrivelse';
$hesklang['desc_forgot_ticket_id']='(Kunde) Glemt sporings-ID for henvendelse';
$hesklang['desc_new_reply_by_staff']='(Kunde) Nytt svar fra medarbeider';
$hesklang['desc_new_ticket']='(Kunde) Henvendelse mottatt';
$hesklang['desc_ticket_closed']='(Kunde) Henvendelse lukket/løst';
$hesklang['desc_category_moved']='(Medarbeider) Henvendelse flyttet til annen kategori';
$hesklang['desc_new_reply_by_customer']='(Medarbeider) Nytt kundesvar';
$hesklang['desc_new_ticket_staff']='(Medarbeider) Ny henvendelse innsendt';
$hesklang['desc_ticket_assigned_to_you']='(Medarbeider) En henvendelse ble tildelt deg';
$hesklang['desc_new_pm']='(Medarbeider) Ny privat melding';
$hesklang['desc_new_note']='(Medarbeider) Ny kommentar på en henvendelse som er tildelt deg';
$hesklang['desc_reset_password']='(Medarbeider) Tilbakestill passordet ditt';
$hesklang['etfm']='En eller flere e-postmaler mangler.<br /><br />Forsikre deg om at du har lastet opp e-postmalfilene til din <i>/language/%s/emails</i>-mappe.';
$hesklang['etfw']='Noen e-postmaler er ikke skrivbare.<br /><br />
                    Forsikre deg at PHP har rettigheter til å skrive til alle filene i din <i>/language/%s/emails</i>-mappe.<br /><br />
                    På Unix-servere kan det hende du må bruke CHMOD på e-postmaler til 666 (rw-rw-rw-)';
$hesklang['et_e_id']='Manglende mal ID';
$hesklang['et_fm']='Denne e-postmalfilen mangler';
$hesklang['et_fw']='Denne e-postmalfilen er ikke skrivbar';
$hesklang['et_save']='Lagre e-postmal';
$hesklang['updated_on']='Oppdatert';
$hesklang['ticket_url']='URL for henvendelse';
$hesklang['pm_url']='URL for privat melding';
$hesklang['et_num']='Antall henvendelser';
$hesklang['et_list']='Liste av henvendelser';
$hesklang['et_empty']='E-postmal kan ikke være uten innhold';
$hesklang['et_saved']='E-postmal lagret';
$hesklang['source']='Kilde';
$hesklang['select_category']='Velg en kategori';
$hesklang['select_category_text']='Hva kan vi hjelpe deg med?';
$hesklang['select_category_staff']='Velg henvendelseskategori';
$hesklang['scat']='Grense for kategorivalg';
$hesklang['scat2']='(en rullegardinboks vil vises hvis kategoriantall er høyere)';
$hesklang['new_cf']='Nytt egentilpasset felt';
$hesklang['cf_intro']='Bruk denne funksjonaliteten til å legge til egentilpassede felter til henvendelsesskjmaet så du kan innhente ekstra data fra kunder.';
$hesklang['cf_public']='Offentlig';
$hesklang['cf_private']='Kun for medarbeidere';
$hesklang['cf_cust']='For kunder';
$hesklang['cf_all']='Alle';
$hesklang['cf_cat']='Valgt';
$hesklang['cf_ctrl']='Tips: hold nede CTRL-tasten for å velge flere kategorier';
$hesklang['visibility']='Synlighet';
$hesklang['cf_save']='Lagre egentilpasset felt';
$hesklang['ex_cf']='Aktive egentilpassede felter';
$hesklang['no_cf']='ingen aktive egentilpassede felter';
$hesklang['del_cf']='Slette dette egnetilpassede feltet? Dette vil også slette lagrede data i egentilpassede felter fra databasen!';
$hesklang['cf_e_id']='Ugyldig ID';
$hesklang['edit_cf']='Redigere egentilpasset felt';
$hesklang['cf_deleted']='Egentilpasset felt er slettet';
$hesklang['cf_not_found']='Dette egentilpassede feltet finnes ikke';
$hesklang['cf_added']='Et nytt egentilpasset felt er lagret';
$hesklang['cf_nocat']='Velg minst en kategori for dette egnetilpassede feltet';
$hesklang['cf_mdf']='Egentilpasset felt er lagret';
$hesklang['atl1']='Skriv inn minst ett valg.';
$hesklang['sch']='Skjult';
$hesklang['meml3']='Tillat flere e-postadresser';
$hesklang['dmin']='Tidligste tillatte dato';
$hesklang['dmax']='Seneste tillatte dato';
$hesklang['d_day']='dag(er)';
$hesklang['d_week']='uker(r)';
$hesklang['d_month']='måned(er)';
$hesklang['d_year']='år';
$hesklang['d_any']='Hvilken som helst dato';
$hesklang['d_fixed']='Fast dato';
$hesklang['d_relative']='Relativ dato';
$hesklang['d_mm']='Tidligste dato kan ikke være senere enn seneste dat';
$hesklang['d_emin']='Tidligste dato for <i>%s</i> er %s';
$hesklang['d_emax']='Seneste dato for <i>%s</i> er %s';
$hesklang['d_format']='Datovisningsformat';
$hesklang['d_custom']='Egendefinert format';
$hesklang['d_ci']='KUN FOR AVANSERTE BRUKERE: et gyldig PHP datoformat, se PHP-manualen.';
$hesklang['cf_noe']='Skriv inn en gyldig e-postadresse <i>%s</i>';
$hesklang['cf_noem']='Skriv en eller flere gyldige e-postadresser <i>%s</i>';
$hesklang['can_resolve']='Kan sette henvendelser til løst';
$hesklang['can_change_own_cat']='Endre henvendelseskategori (til tillatt)';
$hesklang['can_submit_any_cat']='Kan sende inn henvendelse til enhveer kategori';
$hesklang['noauth_submit']='Du er ikke autorisert til å sende henvendelser på denne kategorien!';
$hesklang['noauth_move']='Du er ikke autorisert til å flytte henvendelser til denne kategorien!';
$hesklang['noauth_resolve']='Du er ikke autorisert til å sette henvendelser til løst!';
$hesklang['force_ssl']='Krev SSL-tilkobling';
$hesklang['d_ssl']='<i>deaktivert</i> - åpne denne siden med https:// for å  håndtere dette valget';
$hesklang['scno']='Denne statusen kan ikke endres';
$hesklang['statuses']='Statuser';
$hesklang['statuses_intro']='Bruk dette verktøyet for å legge til egendefinerte statuser for din help desk';
$hesklang['color']='Farge';
$hesklang['csscl']='CSS-klasse eller farge';
$hesklang['clr_view']='Forhpndsvisning av farge på tekst';
$hesklang['cbc']='Kan endres av kunde';
$hesklang['ccc']='Kan kunder endre denne statusen?';
$hesklang['del_status']='Slette denne status?';
$hesklang['ex_status']='Eksisterende statuser';
$hesklang['status_hesk']='Forhåndsdefinerte Statuser (kan ikke redigeres her)';
$hesklang['status_custom']='Egendefinerte Statuser';
$hesklang['status_custom_none']='Ingen egendefinerte statuser. Du kan legge dem til i skjemaet over.';
$hesklang['status_save']='Lagre status';
$hesklang['list_tkt_status']='List alle henvendelser med denne status';
$hesklang['new_status']='Ny egendefinert status';
$hesklang['edit_status']='Rediger egendefinert status';
$hesklang['err_status']='Skriv inn navn på status';
$hesklang['status_added']='En ny egendefinert status er lagt til';
$hesklang['status_e_id']='Ugyldig ID';
$hesklang['status_mdf']='Egendefinert status er lagret';
$hesklang['status_deleted']='Egendefinert status er slettet';
$hesklang['status_not_found']='Denne egendefinerte statusen finnes ikke';
$hesklang['status_not_empty']='Denne status kan ikke slettes fordi det finnes henvendelser med denne status';
$hesklang['status_limit']='Du har 100 egendefinerte statuser, ingen nye kan opprettes.';
$hesklang['public_link']='Offentlig lenke';
$hesklang['frames']='Rammer';
$hesklang['frames2']='Forhindre lasting av HESK i rammer på tredjepartsdomener';
$hesklang['numsub']='Innsendte henvendelser';
$hesklang['hidf']='Skjulte felter er ikke synlig for kunder på innsendelsesskjemaet (verdien vil være synlig på henvendelsens detaljside hvis de er satt til å være offentlig). De oppfører seg som normale tekstfelter for medarbeidere.';
$hesklang['rcheck']='Ikke velg et standard alternativ';
$hesklang['refresh_page']='Oppfrisk denne siden';
$hesklang['del_kba']='Slette denne artikkelen';
$hesklang['del_kbaa']='Slett denne artikkelen permanent';
$hesklang['hni1']='HESK ikke installert enda?';
$hesklang['hni2']='Det ser ut til at denne help desk ikke er skikkelig installert og konfigurert enda.';
$hesklang['hni3']='For å installere HESK, følg <a href="docs/">Instruksjonene i dokumentasjonen</a>';
$hesklang['cf']='Cache-mappe';
$hesklang['e_cdir']='Hesk vil ikke kunne analysere e-poster eller cache resultater med mindre cache-mappen eksisterer og er skrivbar.';
$hesklang['step1']='Trinn 1';
$hesklang['step2']='Trinn 2';
$hesklang['dffs']='Når nedlastingen er ferdig,slett filen fra tjeneren';
$hesklang['fd']='Eksportfil slettet fra tjeneren';

// Added in version 2.8.0
$hesklang['TZ']='Tidssone';
$hesklang['thist17']='<li class="smaller">%s | innsendt fra IMAP-henting</li>';
$hesklang['sir3']='Usynlig reCAPTCHA';
$hesklang['invisible']='usynlig';
$hesklang['imap_not']='PHP er ikke kompilert med støtte for IMAP';
$hesklang['imap_warning']='bruker %1$s har samme e-postadresse som din IMAP-hente e-postadresse: %2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='bruker %1$s har samme e-postadresse som din POP3-hente e-postadresse: %2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='Dette kan resultere i en uendelig e-postsløyfe hvor nye henvendelser blir opprettet fra e-postvarslinger. E-postadresse for henting bør være unik og ikke i bruk av noen andre.';
$hesklang['can_view_ass_by']='Kan se henvendelser han/hun tilordnet til andre';
$hesklang['can_privacy']='Kan anonymisere henvendelser';
$hesklang['confirm_anony']='Anonymiser denne henvendelsen';
$hesklang['anon_selected']='Anonymiser valgte henvendelser';
$hesklang['privacy_anon_info']='Fjern all person-identifiserbare data og innhold fra henvendelser (kundenavn, e-postadresse, melding, vedlegg, IP...), men behold henvendelsen i database for statistikk (retten til å blir glemt).';
$hesklang['success_anon']='Henvendelse vellykket anonymisert';
$hesklang['num_tickets_anon']='Antall henvendelser anonymisert: <b>%d</b>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Kunde]'; // Customer name in anonymized tickets
$hesklang['anon_email']=''; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Emne]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Melding]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class="smaller">%s | anonymisert av %s</li>';
$hesklang['print_selected']='Skriv ut valgte henvendelser';
$hesklang['with_selected']='Med valgte:';
$hesklang['assign_selected']='Tilordne valgte til:';
$hesklang['assign_no']='Ingen eier valgt, ingen endringer utført';
$hesklang['assign_1']='Valgte henvendelser er satt til Ikke tilordnet.';
$hesklang['assign_2']='Sporings-ID %1$s satt til Ikke tilordnet'; // %1$s = ticket numerical ID
$hesklang['assign_3']='%1$s feil: allerede tilegnet %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s tildelt %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='%1$s feil: %2$s har ikke tilgnag til henvendelseskategori'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='Resultat av samtidig tildeling av henvendelser:<br /><br />Tilegnet: %1$s<br />Feil: %2$s<br /><br />Log:<br /><pre>%3$s</pre>'; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='IP adresse';
$hesklang['moret']='Flere valg'; // More options button title
$hesklang['btn_more']='Mer'; // More options button text
$hesklang['btn_print']='Skriv ut';
$hesklang['btn_edit']='Rediger';
$hesklang['btn_lock']='Lås henvendelse';
$hesklang['btn_unlock']='Lås opp henvendelse';
$hesklang['btn_tag']='Merk henvendelse';
$hesklang['btn_resend']='Send e-postvarsling på nytt';
$hesklang['btn_untag']='Fjern merke fra henvendelse';
$hesklang['btn_import_kb']='Importer til Kunnskapsbasen';
$hesklang['btn_anony']='Anonymiser henvendelse';
$hesklang['btn_delt']='Slett henvendelse';
$hesklang['btn_delr']='Slett svar';
$hesklang['ernf']='Svar ikke funnet';
$hesklang['tns']='Henvendelsvarsling ble sendt på nytt';
$hesklang['rns']='Svarvarsling ble sendt på nytt';
$hesklang['fname']='Fornavn';
$hesklang['export_selected']='Eksporter valgte henvendelser';
$hesklang['btn_export']='Eksporter til XML for Excel';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='Responses';
$hesklang['team']='Team';
$hesklang['sm_content']='Content';
$hesklang['sm_settings']='Settings';
$hesklang['wizard_back']='Back'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Next'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Go to Settings';
$hesklang['sm_return_to_editing']='Return to Editing';
$hesklang['email_tpl_title']='Title';
$hesklang['edit_email_template']='Edit email template';
$hesklang['err_no_settings_section']='No settings section was provided.';
$hesklang['this_field_is_required']='This field is required';
$hesklang['reset_your_password']='Reset your password';
$hesklang['reset_password_instructions']='Please enter your email address below. We will send you a link to where you can reset your password.';
$hesklang['enter_email']='Enter email';
$hesklang['password_reset_check_your_email']='Check your email';
$hesklang['password_reset_link_sent']='We sent you a link to reset your password.';
$hesklang['back_to_login']='Back to login';
$hesklang['pager_first']='First';
$hesklang['pager_previous']='Prev';
$hesklang['pager_next']='Next';
$hesklang['pager_last']='Last';
$hesklang['new_team_member']='New Team Member';
$hesklang['role']='Role';
$hesklang['optional']='Optional';
$hesklang['edit_profile']='Edit Profile';
$hesklang['assigned_to']='Assigned to';
$hesklang['contact']='Contact';
$hesklang['unban_email']='Unban this email';
$hesklang['unban_ip']='Unban this IP';
$hesklang['show_previous_replies']='Show previous replies';
$hesklang['type_your_message']='Type your message'; // Used when there are no canned responses
$hesklang['close_button_text']='Close';
$hesklang['create_new_ticket']='Create New Ticket';
$hesklang['delete_article']='Delete article';
$hesklang['view_existing_tickets']='View existing tickets';
$hesklang['how_can_we_help']='Hello, how can we help?';
$hesklang['search_for_articles']='Search for articles';
$hesklang['submit_a_support_request']='Submit a Support Request';
$hesklang['verify_header']='SPAM Prevention';
$hesklang['ticket_details']='Ticket Details';
$hesklang['yes_title_case']='Yes';
$hesklang['no_title_case']='No';
$hesklang['no_results_found']='No Results Found';
$hesklang['site_theme']='Site theme';
$hesklang['test_theme_folder']='Test theme folder';
$hesklang['test_theme_folder_description']='Testing the theme folder for valid themes. Only themes that pass all tests are properly installed.';
$hesklang['err_site_theme']='Please select Hesk theme';
$hesklang['confirm']='Confirm';
$hesklang['confirm_deletion']='Confirm Deletion';
$hesklang['confirm_delete_status']='Are you sure you want to delete this custom status?';
$hesklang['help_desk']='Help Desk'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.en.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Time display';
$hesklang['tdisd']='Date and time';
$hesklang['tdisa']='Time ago (example: 5 hours ago)';
$hesklang['nav_templates']='Templates'; // Admin panel navigation item
$hesklang['hide_replies']='Hide ticket replies';
$hesklang['hide_replies_no']='Do not hide, always show all replies';
$hesklang['hide_replies_yes']='Hide all replies except the last:';
$hesklang['hide_replies_def']='Show the last staff reply and any subsequent customer replies';
$hesklang['reply_by']='Reply by'; // Reply by NAME
$hesklang['btt']='Back to Top';
$hesklang['lwidth']='Limit ticket width';
$hesklang['lwidtall']='Use the full available width';
$hesklang['lwidtpx']='Maximum width in pixels:';
// 3-letter days of the week
$hesklang['mon']='Mon';
$hesklang['tue']='Tue';
$hesklang['wed']='Wed';
$hesklang['thu']='Thu';
$hesklang['fri']='Fri';
$hesklang['sat']='Sat';
$hesklang['sun']='Sun';
$hesklang['clear']='Clear'; // delete field value
$hesklang['first_day_of_week']='0'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='At least one SPAM prevention measure must be enabled!';
$hesklang['modules']='Modules';
$hesklang['modules_demo']='This module is currently available only in %s'; // %s = Hesk cloud link
$hesklang['see_demo']='Try the live demo here: %s'; // %s = Hesk demo link
$hesklang['statistics']['tab']='Statistics';
$hesklang['statistics']['intro']='This report will give you insight into your help desk usage and staff performance.';
$hesklang['statistics']['ntsp']='No tickets in the selected time period.';
$hesklang['statistics']['pie_title_ro']='Open vs Resolved tickets';
$hesklang['statistics']['open']='Open';
$hesklang['statistics']['resolved']='Resolved';
$hesklang['statistics']['pie_title_as']='Open tickets: Assigned vs Unassigned';
$hesklang['statistics']['ass']='Assigned';
$hesklang['statistics']['unas']='Unassigned';
$hesklang['statistics']['pie_title_au']='Open tickets: Answered vs Unanswered';
$hesklang['statistics']['answered']='Answered';
$hesklang['statistics']['unanswered']='Unanswered';
$hesklang['statistics']['pie_title_so']='Status of open tickets';
$hesklang['statistics']['retic']='Tickets:';
$hesklang['statistics']['chart_title_md']='Tickets per day of month';
$hesklang['statistics']['chart_title_wd']='Tickets per weekday';
$hesklang['statistics']['chart_title_hd']='Tickets per day hour';
$hesklang['statistics']['chart_title_tfr']='Time to first staff reply';
$hesklang['statistics']['chart_title_tfrc']='Tickets replied to within a time frame';
$hesklang['statistics']['chart_title_ttr']='Time from submitting to resolving a ticket';
$hesklang['statistics']['chart_title_ttrc']='Tickets resolved within a time frame';
$hesklang['statistics']['chart_title_sr']='Staff replies';
$hesklang['statistics']['chart_title_srt']='Staff replies per ticket';
$hesklang['statistics']['chart_title_srtr']='Staff replies per ticket (resolved tickets only)';
$hesklang['statistics']['chart_title_srt1']='Staff replies per ticket (tickets with at least 1 reply)';
$hesklang['statistics']['ct_30']='30 minutes';
$hesklang['statistics']['ct_1h']='1 hour';
$hesklang['statistics']['ct_2h']='2 hours';
$hesklang['statistics']['ct_4h']='4 hours';
$hesklang['statistics']['ct_1d']='1 day';
$hesklang['statistics']['ct_2d']='2 days';
$hesklang['statistics']['ct_3d']='3 days';
$hesklang['statistics']['ct_1w']='1 week';
$hesklang['statistics']['ct_wp']='> 1 week';
$hesklang['statistics']['ct_1m']='1 month';
$hesklang['statistics']['ct_mp']='> 1 month';
$hesklang['statistics']['axis1']='% of tickets replied';
$hesklang['statistics']['axis2']='% of tickets resolved';
$hesklang['statistics']['axis3']='% of tickets';
$hesklang['statistics']['axis4']='Time to first reply';
$hesklang['statistics']['axis5']='Time to resolved';
$hesklang['statistics']['axis6']='Number of replies';
$hesklang['statistics']['axis7']='Number of tickets';
$hesklang['statistics']['axis8']='Weekday';
$hesklang['statistics']['axis9']='Hour';
$hesklang['statistics']['axis10']='Day of month';
$hesklang['statistics']['tr_0']='No reply';
$hesklang['statistics']['tr_1']='1 reply';
$hesklang['statistics']['tr_2']='2 replies';
$hesklang['statistics']['tr_5']='3-5 replies';
$hesklang['statistics']['tr_10']='6-10 replies';
$hesklang['statistics']['tr_99']='> 10 replies';
$hesklang['statistics']['average']='Average';
$hesklang['statistics']['atfr']='Average hours and minutes to first staff reply:';
$hesklang['statistics']['attr']='Average hours and minutes to resolve a ticket:';
$hesklang['statistics']['about']='about %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='N/A';
$hesklang['statistics']['trept']='Total tickets staff replied to:';
$hesklang['statistics']['trnr']='Total tickets resolved without a staff reply:';
$hesklang['statistics']['tsr']='Total staff replies:';
$hesklang['statistics']['tsrt']='Average staff replies per ticket:';
$hesklang['statistics']['tsro']='Average staff replies per ticket (tickets with at least 1 staff reply):';
$hesklang['statistics']['tsrc']='Average staff replies required to resolve a ticket:';
$hesklang['statistics']['tsrr']='Average staff replies required to resolve a ticket (tickets with at least 1 staff reply):';
$hesklang['sep_1000']=','; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']='.'; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='and much more...'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] Ticket overdue';
$hesklang['ticket_escalated']='[#%%TRACK_ID%%] ESCALATED: %%SUBJECT%%';
$hesklang['escalate']['tab']='Escalate'; // Menu link
$hesklang['escalate']['page_title']='Escalate Tickets'; // Page H2 title
$hesklang['escalate']['intro']='This module will help you escalate tickets that are not attended to on time.';
$hesklang['escalate']['feat1']='Tickets not assigned, replied to, or resolved within a timeframe';
$hesklang['escalate']['feat2']='tickets approaching due date and overdue tickets';
$hesklang['escalate']['feat3']='automatically change ticket priority, re-assign a ticket, send an email notification';
$hesklang['escalate']['feat4']='apply rules based on ticket category, owner, status';
$hesklang['escalate']['prefix']='Escalated:'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Active rules';
$hesklang['escalate']['new']='New escalation rule';
$hesklang['escalate']['no_rules']='You do not have any escalation rules. Create one by clicking the &quot;New escalation rule&quot; button above.';
$hesklang['escalate']['title']='Rule title';
$hesklang['escalate']['titlet']='A descriptive title, for example: Re-assign tickets not replied to within a day';
$hesklang['escalate']['default_title']='Rule by %1$s'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Rule trigger';
$hesklang['escalate']['trigt']='Set the condition that will trigger (run) this rule.';
$hesklang['escalate']['hits']='Hits'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Condition'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Action'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='Apply to'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']='Delete this rule?';
$hesklang['escalate']['edit']='Editing escalation rule ID %1$s'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='A support ticket is:'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='not replied to by staff';
$hesklang['escalate']['nrepc']='not replied to by customer';
$hesklang['escalate']['nass']='not assigned';
$hesklang['escalate']['nres']='not resolved';
$hesklang['escalate']['ndue']='approaching due date';
$hesklang['escalate']['odue']='overdue';
$hesklang['escalate']['within']='Within:';
$hesklang['escalate']['minutes']='minutes';
$hesklang['escalate']['hours']='hours';
$hesklang['escalate']['days']='days';
$hesklang['escalate']['weeks']='weeks';
$hesklang['escalate']['months']='months';
$hesklang['escalate']['years']='years';
$hesklang['escalate']['ofs']='of being submitted';
$hesklang['escalate']['resend']='Re-send email notifications:';
$hesklang['escalate']['force']='Always send, disregard staff settings';
$hesklang['escalate']['noforce']='Respect staff notifications settings';
$hesklang['escalate']['setpri']='Set priority to:';
$hesklang['escalate']['setsta']='Set status to:';
$hesklang['escalate']['assto']='Assign ticket to:';
$hesklang['escalate']['asm']='Another staff member';
$hesklang['escalate']['notify']='Notify staff members...';
$hesklang['escalate']['ato']='Apply to:';
$hesklang['escalate']['tic']='Tickets in category:';
$hesklang['escalate']['tat']='Tickets assigned to:';
$hesklang['escalate']['tws']='Tickets with status:';
$hesklang['escalate']['tall']='Apply this rule to existing and future tickets';
$hesklang['escalate']['tfn']='Apply this rule to future tickets only, ignore existing tickets';
$hesklang['escalate']['tfi']='Apply this rule only to tickets with ID higher than:';
$hesklang['escalate']['save']='Save rule';
$hesklang['escalate']['e_tt']='Time should be between 1 and 10000';
$hesklang['escalate']['e_a']='Select at least one action to perform on matching tickets';
$hesklang['escalate']['nocat']='Select at least one category';
$hesklang['escalate']['nouser']='Select at least one user';
$hesklang['escalate']['nostatus']='Select at least one status';
$hesklang['escalate']['nocata']='%1$s doesn\'t have access to these categories:'; // %1$s = user name
$hesklang['escalate']['rule_added']='New rule has been created';
$hesklang['escalate']['mdf']='Rule settings have been saved';
$hesklang['escalate']['e_id']='No rule with this ID found';
$hesklang['escalate']['deleted']='Selected rule has been deleted';
$hesklang['escalate']['edit_notice']='changing the rule trigger will have no effect on any ticket already escalated by this rule (unless you reset the rule).';
$hesklang['escalate']['reset']='Reset this rule';
$hesklang['escalate']['reset2']='Are you sure you want to reset this rule?<br><br>Rule hits will go to 0 and any ticket that matches this rule will be escalated again.';
$hesklang['escalate']['reset3']='Selected rule has been reset';
$hesklang['escalate']['log_title']='Rule #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class="smaller">%1$s | escalated by %2$s:</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class="smaller">%1$s | - set priority to %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class="smaller">%1$s | - assign to %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class="smaller">%1$s | - send staff notification</li>';
$hesklang['escalate']['thist5']='<li class="smaller">%1$s | - send staff notification (forced)</li>';
$hesklang['escalate']['thist6']='<li class="smaller">%1$s | - error: %2$s doesn\'t have access to ticket category</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class="smaller">%1$s | - error: %2$s doesn\'t have permission to view tickets</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class="smaller">%1$s | - error: no other user who can view this ticket</li>'; // %1$s = date
$hesklang['escalate']['thist9']='<li class="smaller">%1$s | - notice: priority already set to %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class="smaller">%1$s | - notice: already assigned to %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class="smaller">%1$s | - notify: %2$s</li>'; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class="smaller">%1$s | - set status to %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class="smaller">%1$s | - notice: status already set to %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Active'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Activate this rule (start using it)';
$hesklang['escalate']['activated']='Selected rule has been activated'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='Deactivate this rule (stop using it)';
$hesklang['escalate']['deactivated']='Selected rule has been deactivated'; // %1$s = rule log title
$hesklang['escalate']['no_active']='No active escalation rules';
$hesklang['escalate']['matched']='Number of matching tickets found: %1$s '; // %1$s = number of tickets
$hesklang['escalate']['tools']='Tools';
$hesklang['escalate']['test']='Simulate this rule';
$hesklang['escalate']['testa']='Simulate all rules';
$hesklang['escalate']['testaa']='Simulate all active rules';
$hesklang['escalate']['testr']='Simulation results';
$hesklang['escalate']['rsim']='Repeat simulation';
$hesklang['escalate']['tbef']='Before a rule is live, you need to activate it by clicking the checkbox in the &quot;ACTIVE&quot; column.<br><br>
                               We strongly recommend that you <strong>simulate</strong> each rule by clicking the %1$s (Simulate this rule) icon in the rules table
                               to see how it will affect your existing tickets before activating it.<br><br>
                               <strong>Active rules are processed every %2$s minutes. A ticket can only be escalated once by each rule</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='SIMULATION MODE, no changes to the database';
$hesklang['escalate']['sic']='SIMULATION COMPLETE';
$hesklang['escalate']['r']='[RULE]';
$hesklang['escalate']['i']='[INFO]';
$hesklang['multopt']='Tip: hold down CTRL key to select multiple options';
$hesklang['desc_ticket_escalated']='(Staff) Ticket has been escalated'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Ticket Formatting (Staff)';
$hesklang['ticket_formatting_plaintext']='Plain Text';
$hesklang['ticket_formatting_rich_text']='Rich Text (HTML)';
$hesklang['due_date']='Due date';
$hesklang['invalid_due_date']='An invalid due date was entered.';
$hesklang['thist19']='<li class="smaller">%s | due date updated to %s by %s</li>'; // %s = date, new due date, user making change
$hesklang['thist20']='<li class="smaller">%s | due date removed by %s</li>'; // %s = date, user making change
$hesklang['due_date_updated']='Ticket due date has been updated.';
$hesklang['menu_kb_manage']='Manage'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='View'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Select all';
$hesklang['a_deselect']='Deselect all';
$hesklang['a_toggle']='Toggle all';
$hesklang['ql_all']='All tickets';
$hesklang['ql_alo']='All open tickets';
$hesklang['ql_fit']='Filtered tickets';
$hesklang['ql_a2m']='Assigned to me';
$hesklang['ql_a2o']='Assigned to others';
$hesklang['ql_una']='Unassigned';
$hesklang['ql_due']='Due soon';
$hesklang['ql_ovr']='Overdue';
$hesklang['set_ds']='Show as &quot;due soon&quot;'; // Settings page (title of setting)
$hesklang['set_ds2']='days before due date';
$hesklang['not_aos']='Some open tickets you have access to are not shown due to your filters.';
$hesklang['ntoverdue']='A ticket is overdue with owner:';
$hesklang['ovdcron']='for overdue notifications to work, your administrator must enable a cron job.';
$hesklang['instructions']='Instructions';
$hesklang['desc_overdue_ticket']='(Staff) Ticket overdue';
$hesklang['overdue_starting']='Starting overdue tickets notification process';
$hesklang['overdue_sim']='Sending emails and updating tickets is disabled in SIMULATION mode.';
$hesklang['overdue_ticket_count']='Found %s tickets that are overdue.'; // %s = Number of tickets
$hesklang['overdue_finished']='Finished Overdue Tickets. %s emails sent. %s emails failed to send.'; // %s = Successful emails, failed emails
$hesklang['admin_css']='Admin CSS';
$hesklang['admin_css2']='Load an extra custom style file for the admin panel';
$hesklang['noval_cert']='Do not validate server certificates';
$hesklang['chg_cat']='Click to change ticket category';
$hesklang['tlan']='Ticket language';
$hesklang['uue']='Two or more staff members have the same email address. We recommend setting a unique email address for each user.';
$hesklang['flood']='Flood limit';
$hesklang['e_flood']='Ooops, you already submitted a reply just recently. We stopped this request to prevent reply flooding.';
$hesklang['cookies']='Cookies';
$hesklang['ukey']='URL Access Key'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='Generate a random URL Access Key';
$hesklang['ukeym']='Error: to run this file via HTTP you must include your URL Access Key in the request. Example:';
$hesklang['ukeyw']='Error: wrong URL Access Key';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Ticket received: %%SUBJECT%%';
$hesklang['mfa_verification']='%%VERIFICATION_CODE%% is your verification code';
$hesklang['follow_up_email']='Be honest - how did we do?';
$hesklang['mfa']='Multi-Factor Authentication (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='MFA Enabled?';
$hesklang['mfa_required']='Require Multi-Factor Authentication';
$hesklang['mfa_manage_profile']='Manage MFA';
$hesklang['mfa_disabled']='Multi-Factor Authentication is disabled';
$hesklang['mfa_enabled']='Multi-Factor Authentication is Enabled (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='None';
$hesklang['mfa_method_none_subtext']='Remove multi-factor authentication on your account.';
$hesklang['mfa_method_email']='Email';
$hesklang['mfa_method_email_subtext']='The helpdesk will send an email with a random login code to <strong>%s</strong> when logging in.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='Authenticator App';
$hesklang['mfa_method_auth_app_short']='App';
$hesklang['mfa_method_auth_app_subtext']='Use a smartphone application, such as Authy or Google Authenticator, to generate a random login code when logging in.';
$hesklang['mfa_step_method']='Method';
$hesklang['mfa_step_verification']='Verification';
$hesklang['mfa_step_complete']='Complete';
$hesklang['mfa_introduction']='Multi-factor authentication improves account security by requiring you to verify your login using an additional verification method, such as email or an authenticator app (such as Authy or Google Authenticator).';
$hesklang['mfa_reset_warning']='You already have multi-factor authentication enabled. Completing this again will reset your multi-factor authentication device (if enabled).';
$hesklang['mfa_select_method_colon']='Select an authentication method:';
$hesklang['mfa_verification_header']='Verification - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='An email has been sent to <strong>%s</strong> containing a six-digit verification code. Enter the code you received via email below to continue.'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; Step 1: Scan the image below with the multi-factor authentication app on your mobile device.';
$hesklang['mfa_verification_auth_app_cant_scan']='Not able to scan the image? Manually enter this code on your device: <b>%s</b>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; Step 2: Enter the 6-digit code displayed on your application to verify your device.';
$hesklang['mfa_verify']='Verify';
$hesklang['mfa_invalid_method']='Invalid multi-factor authentication method was received.';
$hesklang['mfa_invalid_verification_code']='The code that was entered is incorrect or expired.';
$hesklang['mfa_configured']='Multi-factor authentication has been enabled for your account!';
$hesklang['mfa_removed']='Multi-factor authentication has been disabled for your account!';
$hesklang['mfa_verification_needed']='Multi-factor authentication is enabled for this account.';
$hesklang['mfa_verification_needed_email']='Please enter the verification code that was sent to your email address.';
$hesklang['mfa_verification_needed_auth_app']='Please enter the code that is displayed on your authentication app.';
$hesklang['mfa_verification_code']='Verification code';
$hesklang['mfa_server_time_issue']='Your server time seems to be inaccurate: %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Reset multi-factor authentication';
$hesklang['mfa_reset_confirm']='Are you sure you wish to reset MFA for this user?';
$hesklang['mfa_reset_yes']='Reset';
$hesklang['mfa_reset']='Multi-Factor Authentication has been reset for the user';
$hesklang['desc_mfa_verification']='(Staff) Multi-Factor Authentication Code';
$hesklang['mfa_code']='Code:';
$hesklang['mfa_backup_codes_header']='SAVE YOUR BACKUP CODES!';
$hesklang['mfa_backup_codes_description']='Keep these backup codes somewhere safe but accessible. In case you lose access to your MFA device or email, you can enter one of the following backup codes to log in.<br><br><strong>Be sure to treat these backup codes like passwords. You will not be able to see these codes again!</strong>';
$hesklang['mfa_verify_another_way']='Verify your account another way'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Get a verification code at %s';
$hesklang['mfa_verify_another_way_code']='Enter one of your 8-character backup codes';
$hesklang['mfa_verify_another_way_admin']='Contact your helpdesk administrator for help';
$hesklang['mfa_verify_another_way_reset']='Reset your multi-factor authentication by uploading a file to the server';
$hesklang['mfa_send_another_email']='Send another email';
$hesklang['mfa_sent']='An email with a new verification code was sent to your email address';
$hesklang['mfa_backup_code']='Backup Code';
$hesklang['mfa_backup_codes']='Backup Codes';
$hesklang['mfa_backup_codes_info']='Single-use codes to pass multi-factor verification when unable to access your email or authenticator app. Once you use a backup code to sign in, that code becomes inactive.';
$hesklang['mfa_backup_codes_num']='You can get a new set of 10 backup codes whenever you want. When you create a new set of codes, the old set automatically becomes inactive.';
$hesklang['mfa_backup_codes_num2']='Number of your active codes: %s';
$hesklang['mfa_invalid_backup_code']='The backup code that was entered is incorrect or has already been used.';
$hesklang['mfa_del_codes']='Delete my backup codes';
$hesklang['mfa_del_codes2']='All your backup codes have been deleted.';
$hesklang['mfa_new_codes']='Generate new backup codes';
$hesklang['mfa_new_codes2']='New backup codes have been generated';
$hesklang['old_php_version']='Error: Unsupported PHP version';
$hesklang['category_default_due_date']='Default Due Date';
$hesklang['category_change_default_due_date']='Set Default Due Date';
$hesklang['category_leave_blank_for_no_default_due_date']='(leave blank for no default due date)';
$hesklang['category_default_due_date_updated']='Default due date has been updated.';
$hesklang['email_formatting']='Email formatting';
$hesklang['email_formatting_html_and_plaintext']='HTML with plain text alternative from plain text template (default)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML with plain text alternative generated from HTML template';
$hesklang['email_formatting_html']='HTML only';
$hesklang['email_formatting_plaintext']='Plain text only';
$hesklang['email_formatting_note']='Your selection in %1$s &gt; %2$s &gt; %3$s is set to: <i>%4$s</i>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='This means Hesk will ignore the HTML templates here.';
$hesklang['email_formatting_note1']='This means Hesk will ignore the plain text templates here.';
$hesklang['email_formatting_note2']='This means Hesk will generate plain text version of emails from your HTML templates and ignore the plain text templates here.';
$hesklang['etnu']='This email template is currently not used by Hesk based on your selection in %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='Edit Category';
$hesklang['create_category']='Create Category';
$hesklang['one_user_included']='1 user included';
$hesklang['one_user_excluded']='1 user excluded';
$hesklang['x_users_included']='%s users included'; // %s = Number of users
$hesklang['x_users_excluded']='%s users excluded'; // %s = Number of users
$hesklang['aa_cat']='Auto-assign tickets in this category';
$hesklang['modify_autoassign_settings']='Modify auto-assign settings';
$hesklang['autoassign_on_all_users']='Yes, to any user with access to this category';
$hesklang['autoassign_on_select_users']='Yes, to specific users';
$hesklang['autoassign_off']='No, submit tickets as unassigned';
$hesklang['autoassign_users']='Users to include/exclude in auto-assignment';
$hesklang['autoassign_selected_include']='Selected users should be <strong>included</strong> when auto-assigning tickets in this category';
$hesklang['autoassign_selected_exclude']='Selected users should be <strong>excluded</strong> when auto-assigning tickets in this category';
$hesklang['cat_edited']='Category %s has been successfully edited';
$hesklang['search_for_user']='Search for user';
$hesklang['email_sending']='Sending emails';
$hesklang['email_to_ticket']='Email to ticket';
$hesklang['email_to_ticket_info']='Converting emails to tickets requires some server-side setup. For details, please see <a href="%s" target="_blank">this knowledgebase guide</a>.'; // %s = link to article
$hesklang['from_warning2']='Hesk is using a SMTP server to send email notifications. Your <strong>%1$s</strong> should be set to <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Missing file extension';
$hesklang['block_ignore']='Email to ticket - Ignore emails and prevent loops';
$hesklang['block_noreply']='Do not reply';
$hesklang['block_noreply2']='Ignore emails sent from &quot;do not reply&quot; email addresses';
$hesklang['block_returned']='Returned';
$hesklang['block_returned2']='Ignore returned emails, such as delivery status notifications and automated replies';
$hesklang['block_duplicate']='Duplicates';
$hesklang['block_duplicate2']='Ignore emails with the same message sent within &quot;%s&quot; seconds'; // %s = "Timeframe"
$hesklang['loop_info']='emails received from the same email address within &quot;%s&quot; seconds';
$hesklang['thist21']='<li class="smaller">%s | overdue email notification sent</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | follow-up email sent</li>'; // %s = date
$hesklang['elevator_header']='Entering Secure Area';
$hesklang['elevator_intro']='You are about to enter a secure area.';
$hesklang['elevator_enter_password']='Please enter your password to continue.';
$hesklang['elevator_duration_setting_title']='Secure area duration';
$hesklang['desc_survey']='(Customer) Follow-up (survey) email'; // Email description
$hesklang['satisfaction']['tab']='Satisfaction';
$hesklang['satisfaction']['title']='Customer Satisfaction Survey';
$hesklang['satisfaction']['intro']='Send your customers a follow-up satisfaction survey to gather feedback about their experience with your help desk.';
$hesklang['satisfaction']['tab1']='Settings';
$hesklang['satisfaction']['tab2']='Opt-out';
$hesklang['satisfaction']['enable']='Enable follow-up emails:';
$hesklang['satisfaction']['enabled']='Customer Satisfaction Surveys are enabled.';
$hesklang['satisfaction']['disabled']='Customer Satisfaction Surveys are currently disabled.';
$hesklang['satisfaction']['url']='Survey URL address:';
$hesklang['satisfaction']['send']='Follow-up email delay:';
$hesklang['satisfaction']['at_least']='Wait at least';
$hesklang['satisfaction']['after']='after the ticket is resolved before sending the email';
$hesklang['satisfaction']['h1']='How to use this tool?';
$hesklang['satisfaction']['h2']='First, create a customer satisfaction survey in your favorite survey tool. If you are unsure what tool to use or what questions to ask, we have a <a href="%s" target="_blank">guide available here</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='When your survey is ready, enable follow-up emails using the form below. Hesk will process resolved tickets with at least one staff reply once per hour and send your survey link to your customers.';
$hesklang['satisfaction']['e_url']='Enter a valid survey URL address. This is the URL your customers will be sent to.';
$hesklang['satisfaction']['as']='Enter a valid survey URL address. This is the URL your customers will be sent to.';
$hesklang['satisfaction']['oo1']='This page lists email addresses that follow-up emails will <b>not</b> be sent to.';
$hesklang['satisfaction']['oo2']='Your customers are able to opt-out from receiving survey emails by clicking a link in the email. Alternatively, you can manually add email addresses on this page.';
$hesklang['satisfaction']['ooe']='Email address to opt-out';
$hesklang['satisfaction']['ooe2']='Enter the email address you wish to opt-out from receiving survey emails.';
$hesklang['satisfaction']['ooe3']='This email address <i>%s</i> is already opted out from receiving survey emails.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Opt-out this email';
$hesklang['satisfaction']['oob']='Opted out by';
$hesklang['satisfaction']['no_oo']='No customer has opted out of receiving survey emails.';
$hesklang['satisfaction']['oor']='Remove';
$hesklang['satisfaction']['oor2']='Email removed from opt-out';
$hesklang['satisfaction']['oor3']='Confirm removal';
$hesklang['satisfaction']['oor4']='When removed from opt-out, this user will again receive follow-up emails.';
$hesklang['satisfaction']['optedout']='The email address <i>%s</i> was opted out of receiving survey emails.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='Missing or invalid survey ID';
$hesklang['satisfaction']['starting']='Starting customer satisfaction survey notification process';
$hesklang['satisfaction']['tc']='Found %s closed tickets that did not have satisfaction survey sent.'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Finished Customer Satisfaction Survey. Emails sent: %1$s. Emails failed to send: %2$s. Tickets without an email: %3$s. Tickets with opt-out email: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='Ignoring, this customer does not wish to receive survey emails.';
$hesklang['satisfaction']['ne']='Ignoring, this ticket is without an email address';
$hesklang['satisfaction']['feat1']='Create your survey using any third-party tool, such as Google Forms';
$hesklang['satisfaction']['feat2']='set up your survey URL, preferences, and limitations inside this module';
$hesklang['satisfaction']['feat3']='when you resolve a ticket, Hesk will email your customer the link to the survey';
$hesklang['dfor']='Date format';
$hesklang['dtfor']='Date and Time';
$hesklang['cdfor']='Date select format';
$hesklang['custom']='Custom';
$hesklang['jsc_notice']='The date selection doesn\'t support PHP-style date formatting. Select one of the pre-configured options or click the %s icon below to see available display options.'; // %s = replaced by icon
$hesklang['lcf3']='Date only'; // Display: "Date only"
$hesklang['epdd']='Error parsing due_date parameter:';
$hesklang['edit_pass']='Edit password';
$hesklang['save_pass']='Save password';
$hesklang['cur_pass']='Current password';
$hesklang['cur_pass2']='You must provide your current password in order to change it.';
$hesklang['cur_pass3']='After a successful password update, you will be redirected to the login page, where you can log in with your new password.';
$hesklang['e_new_pass']='Please enter your new password';
$hesklang['pass_len']='The password must not exceed 64 characters';
$hesklang['pass_login']='Please log in again after changing your password';
$hesklang['bf_int']='You have been logged out due to too many failed verification attempts';
$hesklang['tst_cnt']='Number of emails your mail server will send to Hesk: %s'; // %s = number of emails
$hesklang['wrn_imap']='You have many unread emails in your mailbox (%1$s). Hesk will turn all these emails into tickets.<br><br>You may want to mark existing emails as read before enabling %2$s or use a new email account for Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='You have many emails in your mailbox (%1$s). Hesk will turn all these emails into tickets.<br><br>You may want to delete existing emails before enabling %2$s or use a new email account for Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='Due on'; // Due on (date)
$hesklang['search_due_date_range']='Due in'; // Due in (X days)
$hesklang['attachment_add_files']='Add file';
$hesklang['attachment_max_exceeded']='This file will not be uploaded becuase you have already uploaded the maximum number of files allowed.';
$hesklang['attachment_viewer_message']='Drag files here or click the \'Add File\' button below to select files to upload.';
$hesklang['attachment_invalid_type_message']='Sorry, but the file type you tried to upload is not allowed.';
$hesklang['attachment_upload_error']='An error occurred when trying to upload. Please try again later.';
$hesklang['attachment_too_large']='This attachment is larger than the max filesize permitted.';
$hesklang['attachment_cancel']='Cancel';
$hesklang['attachment_confirm_cancel']='Are you sure you want to cancel this upload?';
$hesklang['attachment_remove']='Remove attachment';
$hesklang['attachment_too_many_uploads']='Too many attachments have been uploaded from your location in a short period of time. Please try your request again later.';
$hesklang['sub_note']='Submit note';
$hesklang['can_view_users']='View all users (but not manage them)';
$hesklang['welcome1']='Hey there, you seem to be new here. Welcome!';
$hesklang['welcome2']='To help you get started, check out the %s.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Hesk online Quick Start Guide';
$hesklang['tmce1']='Use Ctrl+Right click to access spellchecker';
$hesklang['tmce2']='Hold the Control (Ctrl) key and right-click on the misspelled word to access the spellchecker.';
$hesklang['desc_new_ticket_by_staff']='(Customer) New staff-submitted ticket';
$hesklang['mod_et_h']='You can modify email templates under %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Set language to';
$hesklang['ouwa']='Only users with access to this category are listed below. To add staff members to this category, edit their permissions on the %s page'; // %s = Team
$hesklang['previous_tickets']='Previous tickets';
$hesklang['no_previous']='No previous tickets by %s'; // %s = email address
$hesklang['all_previous']='List all previous tickets';
$hesklang['confirm_delete_ticket']='Are you sure you want to permanently delete this ticket?';
$hesklang['confirm_delete_reply']='Are you sure you want to permanently delete this reply?';
$hesklang['select_new_category']='Number of tickets in this category: %s<br><br>Please select a new category to transfer these tickets to:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='Number of tickets assigned to this user: %1$s<br>Number of <b>open</b> tickets assigned to this user: %2$s<br><br><b>Open</b> tickets will be <b>unassigned</b> after deleting this user.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='HESK license';
$hesklang['hlic_free']='FREE';
$hesklang['hlic_buyl']='Buy a License';
$hesklang['hlic_paid']='Licensed';
$hesklang['antdemo']='Submitting tickets from the admin panel has been disabled in the demo mode.<br><br>Please use the <a href="%s" target="_blank">public side</a> to submit a test ticket.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Authentication method';
$hesklang['email_authentication_method_username_password']='Basic (Username / Password)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - No verified OAuth providers configured.';
$hesklang['email_authentication_method_oauth_link']='Manage OAuth providers'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='Authorization Endpoint URL';
$hesklang['email_oauth_token_url']='Token Endpoint URL';
$hesklang['email_oauth_client_id']='Client ID';
$hesklang['email_oauth_client_secret']='Client Secret';
$hesklang['email_oauth_scope']='Scope';
$hesklang['oauth_error_invalid_state']='OAuth state does not match the state sent to OAuth provider.';
$hesklang['oauth_error_unknown']='An unknown error occurred when attempting to save OAuth tokens.';
$hesklang['oauth_error_no_token']='Access token missing in the JSON response.';
$hesklang['oauth_error_retrieve']='Unable to retrieve an access token. Please confirm your OAuth Provider settings and re-save them to acquire a new token.';
$hesklang['email_oauth_provider']='OAuth Provider';
$hesklang['email_oauth_providers']='OAuth Providers';
$hesklang['email_oauth_provider_guide']='Before using OAuth, you must register an OAuth Provider. For details, please see <a href="%s" target="_blank">this knowledgebase guide</a>.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='Your OAuth Redirect URI for Hesk is:<br><i>%s</i>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Use this tool to add OAuth providers to your help desk';
$hesklang['email_oauth_provider_name']='Name'; // OAuth provider name
$hesklang['email_oauth_new_provider']='New Provider';
$hesklang['email_oauth_edit_provider']='Edit Provider';
$hesklang['email_oauth_provider_being_used_for']='Being Used For';
$hesklang['email_oauth_providers_none']='No OAuth providers saved. You can add them by clicking "New Provider" above.';
$hesklang['email_oauth_provider_cannot_be_deleted']='This provider cannot be removed because it is being used by the help desk.';
$hesklang['email_oauth_confirm_delete_provider']='Are you sure you want to delete this OAuth provider?';
$hesklang['oauth_provider_saved']='OAuth provider has been saved';
$hesklang['oauth_provider_use']='You can now select this provider in %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Enter the provider name';
$hesklang['oauth_provider_err_auth_url']='Enter a valid authorization URL';
$hesklang['oauth_provider_err_token_url']='Enter a valid token URL';
$hesklang['oauth_provider_err_client_id']='Enter the client ID';
$hesklang['oauth_provider_err_client_secret']='Enter the client secret';
$hesklang['oauth_provider_err_scope']='Enter the scope';
$hesklang['oauth_provider_deleted']='OAuth provider deleted';
$hesklang['oauth_provider_not_found']='This OAuth provider does not exist';
$hesklang['oauth_provider_verified']='Verified';
$hesklang['oauth_provider_click_to_verify']='Click to verify';
$hesklang['can_due_date']='Can set due date'; // Permission to set and modify due date
$hesklang['can_due_date_e']='You do not have permission to set due dates';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Verify Your Registration';
$hesklang['customer_verify_new_email']='Verify Your New Email Address';
$hesklang['customer_reset_password']='Reset your help desk password';
$hesklang['customer_approved']='Account Approved';
$hesklang['customer_rejected']='Account Rejected';
$hesklang['email_rejected']='Account required to submit support tickets';
$hesklang['require_curl']='This functionality requires <strong>cURL</strong> support for PHP enabled on your server. Please ask your web host to enable cURL for PHP.';
$hesklang['customer_accounts_heading']='Customer Accounts';
$hesklang['customer_accounts']='Customer accounts';
$hesklang['customer_accounts_off']='<strong>Disabled</strong>';
$hesklang['customer_accounts_allowed']='<strong>Enabled - Optional</strong> (customers can submit support tickets without registering or logging in)';
$hesklang['customer_accounts_required_to_submit']='<strong>Enabled - Required for tickets</strong> (only logged-in customers can submit support tickets)';
$hesklang['customer_accounts_required']='<strong>Enabled - Required to access</strong> (only logged-in customers can access the help desk and knowledgebase)';
$hesklang['customer_accounts_reg']='Account registration';
$hesklang['customer_accounts_reg_customer']='Customers can register accounts';
$hesklang['customer_accounts_reg_approve']='Customers can register account, staff must approve new registrations';
$hesklang['customer_accounts_reg_staff']='Only staff can register customer accounts';
$hesklang['customer_accounts_allow_email_changes']='Allow customers to change their email address';
$hesklang['customer_accounts_allow_email_resends']='Time until customers can request new verification email';
$hesklang['customer_login']='Login';
$hesklang['customer_logout']='Logout';
$hesklang['customer_register']='Register';
$hesklang['customer_accounts_disabled']='Customer logins and registrations are disabled.';
$hesklang['customer_accounts_registration_disabled']='Customer registrations are disabled.';
$hesklang['customer_forgot_password']='Forgot password?';
$hesklang['customer_email']='Email Address';
$hesklang['customer_accounts_email_banned']='You have been banned from using this helpdesk.';
$hesklang['customer_registration_successful']='Registration Successful!';
$hesklang['customer_registration_email_exists_no_reset_link']='An account with email %s already exists.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='An account with email %s already exists. <a href="login.php">Do you wish to log in instead</a>?'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='An account with email %s already exists and is pending email verification.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='An account with email %s already exists and is pending staff approval.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='Check Your Email!';
$hesklang['customer_registration_check_your_email_content']='You must verify your email address before being able to log in.<br><br>If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_login_not_verified']='You must verify your email address before being able to log in.';
$hesklang['customer_login_not_verified2']='If you did not receive the verification email from us, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_login_resend_verification_email']='Re-send verification email';
$hesklang['customer_login_resend_verification_email_none']='There are no pending email verifications to send.';
$hesklang['customer_login_resend_verification_email_too_early']='You cannot request a new verification email at this time, please try again later.';
$hesklang['customer_login_not_approved']='A member of staff must approve your account before being able to log in. Once approved, you will be notified via email.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Verify Registration';
$hesklang['customer_registration_verify_success']='Your email has been verified and you may now log in using the form below.';
$hesklang['customer_registration_verify_approval_needed']='Your email has been verified. However, a member of staff must approve your account before being able to log in. Once approved, you will be notified via email.';
$hesklang['customer_registration_verify_failure']='Your email could not be verified. Either the link has already been used or has expired.';
$hesklang['emails_to_customers']='&raquo; Emails sent to customers';
$hesklang['emails_to_staff']='&raquo; Emails sent to staff';
$hesklang['emails_to_everyone']='&raquo; Emails sent to staff or customers';
$hesklang['new_customer_approval']='You have customer accounts pending approval'; // Email subject
$hesklang['desc_new_customer_approval']='(Staff) Customer accounts pending approval';
$hesklang['n_cust_app']='There are pending customer approvals'; // Notify me when...
$hesklang['et_num_customers']='Number of pending approvals';
$hesklang['et_link_customers']='Link to the Manage customers page';
$hesklang['et_link_verify']='Verification link';
$hesklang['et_cust_login']='Customer login URL';
$hesklang['submit_ticket_customer_email_exists']='A customer with this email already exists. Please <a href="login.php?email=%s">log in</a> to submit a ticket.'; // %s - User's email
$hesklang['customer_login_email_required']='Please enter a valid email address.';
$hesklang['customer_login_password_required']='Please enter your password.';
$hesklang['customer_login_remember_just_email']='Remember just my email';
$hesklang['customer_login_remember_email']='Remember my email';
$hesklang['customer_wrong_user']='Your email address %s is not registered with us.<br><br>Do you wish to <a href="register.php">create an account</a>?'; // %s - Entered email address
$hesklang['customer_wrong_pass']='Your email address and password do not match our records.<br><br>Do you wish to <a href="login.php?submittedForgot=1">reset your password</a>?';
$hesklang['customer_must_be_logged_in_to_view']='Please log in to continue.';
$hesklang['customer_register_here']='If you don\'t have an account with us, you can <a href="register.php">register here</a>.';
$hesklang['create_account']='Create an account';
$hesklang['customer_my_tickets_heading']='My tickets';
$hesklang['customer_my_tickets_description']='View all of your previous tickets';
$hesklang['customer_my_tickets_search_for_tickets']='Search for tickets';
$hesklang['customer_password_reset_successful']='Your new password has been saved. You may now log in.';
$hesklang['customer_profile']='Profile';
$hesklang['customer_edit_profile']='Edit Profile';
$hesklang['customer_edit_pass']='Edit Password';
$hesklang['customer_edit_pass_same']='Your new password must not be the same as your current one.';
$hesklang['customer_change_email']='Change Email';
$hesklang['customer_change_email_banned']='The email you entered is banned.';
$hesklang['customer_change_email_pending']='There is a current request to change your email address to: <b>%s</b><br><br>We have sent an email to this address. Please click the link inside the email to confirm the change.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Re-send confirmation email</a>';
$hesklang['customer_change_email_submitted']='Please click the verification link that was sent to <b>%s</b> to verify your new email.'; // %s - new email
$hesklang['customer_change_email_verify_success']='Your new email address has been verified and your profile updated.';
$hesklang['customer_change_email_disabled']='The ability to update your email is disabled. Contact us if you wish to change your email address.';
$hesklang['customer_profile_saved']='Your profile has been saved.';
$hesklang['customers']='Customers';
$hesklang['customers_intro']='Customer accounts allow customers to view all of their tickets in a central location.';
$hesklang['sure_remove_customer']='Are you sure you want to remove this customer?';
$hesklang['sure_remove_customer_additional_note']='Deleting a customer is final.  Once deleted, they cannot be recovered!';
$hesklang['new_customer']='New Customer';
$hesklang['new_follower']='New Follower';
$hesklang['add_customer']='+ Add Customer'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Add Follower'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='The provided customer does not yet exist. Click "Save" if you would like to create this customer.';
$hesklang['followers']='Followers';
$hesklang['no_customers']='There are currently no customers in the database.';
$hesklang['no_customers_disabled']='You will start seeing customers here when they submit support tickets.';
$hesklang['no_customers_enabled']='You will start seeing customers here when they register or submit support tickets.';
$hesklang['no_customers_enabled2']='Alternatively, the buttons above this message allow you to manually create customer accounts or import existing customers into the help desk.';
$hesklang['import_customers']='Import Customers';
$hesklang['import_customers_tip']='Use a CSV file to import multiple customers at once.';
$hesklang['customer_not_found']='Customer not found for ticket!';
$hesklang['search_by_name_or_email']='Search by name or email...';
$hesklang['search_by_pattern']='Search by pattern...';
$hesklang['is_searchable']='Searchable';
$hesklang['custom_is_searchable']='Searchable';
$hesklang['yes_via_autocomplete']='YES (search via autocomplete)';
$hesklang['customer_required']='You must select a customer';
$hesklang['customer_email_exists']='A customer with this email already exists.';
$hesklang['customer_name_with_no_email_exists']='A customer with this name and no email already exists.';
$hesklang['an_error_occurred_validating_email']='An error occurred when attempting to verify the entered email address.';
$hesklang['customer_count_x_more']='+%s more'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Registered';
$hesklang['customer_account_verified']='Verified';
$hesklang['customer_account_verified_help']='Customers must verify their account via an activation link sent to their email address before being able to log into their account.';
$hesklang['customer_account_setting_password_will_verify_user']='Setting a password for this customer will automatically verify their account.';
$hesklang['deleting_customer_with_tickets']='This customer has %1$s ticket(s) <b>(%2$s open)</b> that also have other customers associated with them.<br>What should be done with these tickets?'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='A valid email address is needed to re-send a verification email.';
$hesklang['customer_resend_verification_email_not_found']='No account exists with this email address, or the account has already been verified.';
$hesklang['customer_resend_verification_email_sent']='A verification email has been sent to your email address.<br><br>If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_permission_denied']='You do not have permission to modify customers.';
$hesklang['customer_manage_approvals']='Customer accounts pending approval: <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Approve customer';
$hesklang['customer_manage_bulk_approve']='Approve Selected Customers';
$hesklang['customer_manage_bulk_approve_complete']='Customers approved: %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Reject customer';
$hesklang['customer_manage_bulk_reject']='Reject Selected Customers';
$hesklang['customer_manage_bulk_reject_complete']='Customers rejected: %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Delete customer';
$hesklang['customer_manage_bulk_delete']='Delete Selected Customers';
$hesklang['customer_manage_bulk_delete_complete']='Customers deleted: %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Edit customer';
$hesklang['customer_manage_verification_email_sent']='Verification email has been sent to %s'; // %s = customer's email
$hesklang['can_man_customers']='Manage customers';
$hesklang['can_view_customers']='View all customers (but not manage them)';
$hesklang['import_customer_select_file']='Select File';
$hesklang['import_customer_step1_instructions']='To import customers, prepare a CSV (Comma-Separated Values) file.';
$hesklang['import_customer_step1_note']='Select Your CSV File';
$hesklang['import_customer_step1_separator']='Columns in my CSV file are separated by';
$hesklang['import_customer_sample']='&raquo; Sample CSV files';
$hesklang['import_customer_sample_1']='US-style CSV file with columns separated by ,';
$hesklang['import_customer_sample_2']='EU-style CSV file with columns separated by ;';
$hesklang['import_customer_upload_requirements_1']='Your CSV file must include at least a name or an email address column. The password column is optional.';
$hesklang['import_customer_upload_requirements_2']='The first row of your file must contain column headers.';
$hesklang['import_customer_upload_requirements_3']='Your file must be encoded in UTF-8.';
$hesklang['import_customer_select_columns']='Select Columns';
$hesklang['import_customer_upload_customers']='Upload Customers';
$hesklang['import_customer_column_name']='Name Column';
$hesklang['import_customer_column_email']='Email Column';
$hesklang['import_customer_column_pass']='Password Column';
$hesklang['import_customer_step2_note']='Select the correct column name from your CSV file in the dropdowns, and then click "Next".';
$hesklang['import_customer_name_or_email_required']='Name or email is required';
$hesklang['import_customer_step3_note']='Your customers are being imported. Do not leave this page!';
$hesklang['import_customer_step3_pending']='Pending';
$hesklang['import_customer_step3_successful_imports']='Successful Imports';
$hesklang['import_customer_step3_failed_imports']='Failed Imports';
$hesklang['import_customer_step3_progress']='Progress';
$hesklang['import_customer_step3_complete_some_failed']='The import process is complete, however <b>%s</b> customers failed to import. Check the table below for more information.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='The import process is complete!';
$hesklang['import_customer_step3_importing']='Importing';
$hesklang['staff_deleted']='[Staff Deleted]';
$hesklang['customer_account_approved']='Customer registration approved';
$hesklang['customer_account_rejected']='Customer registration rejected';
$hesklang['customer_account_deleted']='Customer registration deleted';
$hesklang['ticket_followers']='Ticket followers';
$hesklang['ticket_followers2']='Allow tickets to have multiple customers';
$hesklang['add_cc']='Add Cc';
$hesklang['cc']='Cc';
$hesklang['cc_help']='Separate each email with a comma.';
$hesklang['search_customers']='Search Customers';
$hesklang['page_size']='Page Size';
$hesklang['customers_on_pages']='Number of customers: %d | Number of pages: %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Customer) Reset your password';
$hesklang['desc_customer_verify_registration']='(Customer) Verify your registration';
$hesklang['desc_customer_verify_new_email']='(Customer) Verify your new e-mail';
$hesklang['desc_customer_approved']='(Customer) Account approved';
$hesklang['desc_customer_rejected']='(Customer) Account rejected';
$hesklang['desc_email_rejected_can_self_register']='(Customer) Ticket via email rejected; customer can self-register';
$hesklang['desc_email_rejected_cannot_self_register']='(Customer) Ticket via email rejected; customer cannot self-register';
$hesklang['user_added_success_no_pass']='New user %s has been successfully added';
$hesklang['email_tag_requester']='Requester (From)';
$hesklang['email_tag_requester_name']='Requester (From) Name';
$hesklang['email_tag_requester_first_name']='Requester (From) First Name';
$hesklang['email_tag_requester_email']='Requester (From) Email';
$hesklang['email_tag_followers']='Followers (Cc)';
$hesklang['email_tag_follower_names']='Follower (Cc) Names';
$hesklang['email_tag_follower_emails']='Follower (Cc) Emails';
$hesklang['barcode']='Barcode';
$hesklang['barcode_use']='Display a barcode on printed tickets';
$hesklang['barcode_staff_only']='Hide the barcode from customers';
$hesklang['barcode_type']='Barcode type';
$hesklang['barcode_format']='Format';
$hesklang['barcode_width']='Width';
$hesklang['barcode_height']='Height';
$hesklang['barcode_color']='Color';
$hesklang['barcode_bg']='Background';
$hesklang['copy_link']='Copy ticket link';
$hesklang['copy_link_title']='Copy public link to this ticket';
$hesklang['copy_link_exp']='The copied link is the direct link for the customer to view this ticket';
$hesklang['copy_value']='Copy this value';
$hesklang['download_class']='This function requires the ZipArchive class. Ask your host to compile PHP with zip support.';
$hesklang['download_all']='Download all';
$hesklang['download_prep']='Preparing download...';
$hesklang['download_tma']='Too many attachments';
$hesklang['download_nva']='No valid attachments';
$hesklang['download_ntd']='Nothing to download';
$hesklang['resolved_at']='Resolved at';
$hesklang['disable_GSSAPI']='Disable GSSAPI authenticator (Kerberos error work-around)';
$hesklang['ex_history']='Include ticket history log in export';
$hesklang['sm_location']='Location'; // Location (page) of a service message
$hesklang['loc_sm']='Show this service message on:';
$hesklang['loc_all']='Every customer page';
$hesklang['loc_norec']='(not recommended)';
$hesklang['loc_home']='Help desk homepage';
$hesklang['loc_selected']='On selected pages';
$hesklang['loc_selerr']='Select at least one page to show the message on';
$hesklang['loc_t_cat']='Submit a ticket - select a category';
$hesklang['loc_t_add']='Submit a ticket - submit a ticket form';
$hesklang['loc_t_ok']='Submit a ticket - ticket confirmation';
$hesklang['loc_t_view']='View a ticket';
$hesklang['loc_t_form']='View a ticket form';
$hesklang['loc_kb_main']='Knowledgebase homepage';
$hesklang['loc_kb_sub']='Knowledgebase sub-category pages';
$hesklang['loc_kb_art']='Knowledgebase articles';
$hesklang['loc_login']='Customer login page';
$hesklang['loc_register']='Customer registration page';
$hesklang['loc_register_ok']='Customer registration successful';
$hesklang['loc_acc']='Customer &quot;My tickets&quot; page';
$hesklang['loc_profile']='Customer &quot;Profile&quot; page';
$hesklang['sending_show']='Show &quot;Submitting&quot; notification';
$hesklang['sending_wait']='Submitting, please wait...';
$hesklang['e_c_email']='Enter the correct email address to view this ticket';
$hesklang['only_verified_cc']='Followers without a verified account will be ignored.';
$hesklang['followers_removed']='These email addresses have been removed from the ticket because they do not have a verified account:';
$hesklang['novace']='We did not find any registered and verified accounts with this email address.';
$hesklang['max_recipients']='Max recipients';
$hesklang['max_recipients2']='in a single email';
$hesklang['admin_js']='Admin JS';
$hesklang['admin_js2']='Load an extra custom Javascript file for the admin panel';
$hesklang['cf_limit_all']='You have reached the custom fields limit and cannot create new custom fields.';
$hesklang['remind_assigned']='Remind assigned staff';
$hesklang['remind_sent']='Email reminder to the assigned staff member sent';
$hesklang['thist23']='<li class="smaller">%s | reminder sent to %s by %s</li>';
$hesklang['ql_bookmarks']='Bookmarks';
$hesklang['bookmark']='My Bookmark';
$hesklang['bookmarks_add']='Add to Bookmarks';
$hesklang['bookmarks_added']='This ticket has been added to your Bookmarks';
$hesklang['bookmarks_remove']='Remove from Bookmarks';
$hesklang['bookmarks_removed']='This ticket has been removed from your Bookmarks';
$hesklang['genl_not_copied']='Error: Copying to clipboard not supported on this device/browser.';
$hesklang['profile_duplicate_email']='User with email <b>%s</b> already exists.'; // %s: new email
$hesklang['seq_id_numeric']='Ticket number search must contain numbers only';
$hesklang['confirm_new_pass']='Confirm new password';
$hesklang['piping_notify_rejected_customers1']='Customer rejection emails';
$hesklang['piping_notify_rejected_customers2']='Send a rejection email to customers when their ticket is rejected';
$hesklang['piping_notify_rejected_customers3']='Time between rejection emails';
$hesklang['register_url']='Registration URL';
$hesklang['email_subject']='Email subject';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Collaborating on ticket: %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] Staff replied to: %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] Note added to: %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Ticket overdue: %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Ticket resolved: %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Follow-up email cutoff date:'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='Do not email tickets resolved more than'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='ago (must be longer time period than "%s")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='The email cutoff date period must be longer than the follow-up email delay';
$hesklang['available_language']='Available Languages';
$hesklang['click_to_show_available_language']='Click to show available languages';
$hesklang['install_lan']='Install';
$hesklang['remove_lan']='Remove';
$hesklang['title_lan']='Title';
$hesklang['description_lan']='Description';
$hesklang['completed_lan']='Completed';
$hesklang['no_language_availble']='No languages are available';
$hesklang['success_install_lan_txt']='language has been successfully added';
$hesklang['error_install_lan_txt']='language has not been added';
$hesklang['success_remove_lan_txt']='language has been successfully removed';
$hesklang['error_remove_lan_txt']='language has not been removed';
$hesklang['remove_default_language_error']='The default language must remain active and cannot be removed';
$hesklang['click_for_manual_step']='Click for Manual installation';
$hesklang['upgrade_lan']='Update';
$hesklang['success_upgrade_lan_txt']='language has been successfully Updated';
$hesklang['error_upgrade_lan_txt']='language has not been Updated';
$hesklang['please_wait']='Please wait...';
$hesklang['add_a_note']='Add a note';
$hesklang['add_a_reply']='Add a reply';
$hesklang['customer_id']='Customer ID';
$hesklang['deleting_customer_tickets']='Tickets opened by customer: <b>%1$s</b><br>What should we do with these tickets?'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Tickets where customer is copied: <b>%1$s</b><br>These will lose this customer as a follower; tickets remain unchanged.'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Permanently delete tickets';
$hesklang['deleting_customer_anonymize_tickets2']='Anonymize tickets (remove messages and personal data)';
$hesklang['deleting_customer_retain_tickets2']='Keep tickets (leave all data intact)';
$hesklang['for_staff']='for help desk staff'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='for customers'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='IMAP Mailbox';
$hesklang['file_attachment_options']='Email Attachment Options';
$hesklang['link_to_attachments_in_emails']='Link to attachments in emails';
$hesklang['add_attachments_directly_to_emails']='Add attachments directly to emails';
$hesklang['directly_attach_file_smaller_than']='Directly attach only files smaller than';
$hesklang['directly_attach_file_of_any_size']='Directly attach files of any size';
$hesklang['directly_attach_only_first_x_attachments']='Directly attach only first';
$hesklang['directly_attach_all_attachments']='Directly attach all attachments';
$hesklang['directly_attach_size']='Attachment size';
$hesklang['directly_attach_no_of_files']='Number of files';
$hesklang['notice_about_directly_attach_files']='Attaching many or large files to emails may case delays when communicating with your SMTP server';
$hesklang['fatt_2']='Additional files attached to this message:';
$hesklang['no_collaborators']='None';
$hesklang['collaborate']='Collaborate on this ticket';
$hesklang['collaborators']='Collaborators';
$hesklang['ql_cbm']='Collaborator';
$hesklang['collaborating']='You are now collaborating on this ticket';
$hesklang['not_collaborating']='You are not collaborating on this ticket anymore';
$hesklang['add_collaborator']='Add a collaborator';
$hesklang['user_collaborator_added']='User added as a collaborator on this ticket';
$hesklang['remove_collaborator']='Remove collaborator';
$hesklang['staff_name']='Staff name';
$hesklang['user_collaborator_removed']='User removed as a collaborator on this ticket';
$hesklang['desc_collaborator_added']='(Staff) You are collaborating on a new ticket';
$hesklang['desc_collaborator_staff_reply']='(Staff) A staff member responded to a collaborated ticket';
$hesklang['desc_collaborator_note']='(Staff) New note added to a collaborated ticket';
$hesklang['desc_collaborator_resolved']='(Staff) A collaborated ticket has been resolved';
$hesklang['desc_collaborator_overdue']='(Staff) A collaborated ticket is overdue';
$hesklang['notify_collaborator_added']='I am added as a ticket collaborator';
$hesklang['notify_collaborator_customer_reply']='Customer responds to a collaborated ticket';
$hesklang['notify_collaborator_staff_reply']='Staff responds to a collaborated ticket';
$hesklang['notify_collaborator_note']='Staff adds a note to a collaborated ticket';
$hesklang['notify_collaborator_resolved']='Staff resolves a collaborated ticket';
$hesklang['notify_collaborator_overdue']='Collaborated ticket is overdue';
$hesklang['recurring_tickets']['tab']='Recurring Tickets'; // Menu link
$hesklang['recurring_tickets']['page_title']='Recurring Tickets'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Automate the busywork; let Hesk raise routine tickets for you, exactly when you need them.';
$hesklang['recurring_tickets']['active_rules']='Active rules';
$hesklang['recurring_tickets']['new']='New recurring ticket rule';
$hesklang['recurring_tickets']['no_rules']='You do not have any recurring ticket rules. Create one by clicking the &quot;New recurring ticket rule&quot; button above.';
$hesklang['recurring_tickets']['title']='Rule title';
$hesklang['recurring_tickets']['titlet']='A descriptive title, for example: Re-assign tickets not replied to within a day';
$hesklang['recurring_tickets']['default_title']='Rule by %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Rule trigger';
$hesklang['recurring_tickets']['trigt']='Set the condition that will trigger (run) this rule.';
$hesklang['recurring_tickets']['hits']='Hits'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Creation Time'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='General Settings'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Custom Fields'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Content'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='Delete this rule?';
$hesklang['recurring_tickets']['edit']='Editing recurring ticket rule ID %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='Within:';
$hesklang['recurring_tickets']['minutes']='minutes';
$hesklang['recurring_tickets']['hours']='hours';
$hesklang['recurring_tickets']['days']='days';
$hesklang['recurring_tickets']['weeks']='weeks';
$hesklang['recurring_tickets']['months']='months';
$hesklang['recurring_tickets']['years']='years';
$hesklang['recurring_tickets']['setpri']='Set priority to:';
$hesklang['recurring_tickets']['setsta']='Set status to:';
$hesklang['recurring_tickets']['assto']='Assign ticket to:';
$hesklang['recurring_tickets']['asm']='Another staff member';
$hesklang['recurring_tickets']['notify']='Notify staff members...';
$hesklang['recurring_tickets']['ato']='Apply to:';
$hesklang['recurring_tickets']['save']='Save rule';
$hesklang['recurring_tickets']['e_tt']='Time should be between 1 and 10000';
$hesklang['recurring_tickets']['nocat']='Select at least one category';
$hesklang['recurring_tickets']['nouser']='Select at least one user';
$hesklang['recurring_tickets']['nostatus']='Select at least one status';
$hesklang['recurring_tickets']['nocata']='%1$s doesn\'t have access to these categories:'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='New rule has been created';
$hesklang['recurring_tickets']['mdf']='Rule settings have been saved';
$hesklang['recurring_tickets']['e_id']='No rule with this ID found';
$hesklang['recurring_tickets']['deleted']='Selected rule has been deleted';
$hesklang['recurring_tickets']['log_title']='Rule #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Active'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Activate this rule (start using it)';
$hesklang['recurring_tickets']['activated']='Selected rule has been activated'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='Deactivate this rule (stop using it)';
$hesklang['recurring_tickets']['deactivated']='Selected rule has been deactivated'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='No active recurring ticket rules';
$hesklang['recurring_tickets']['tools']='Tools';
$hesklang['recurring_tickets']['tbef']='Before a rule is live, you need to activate it by clicking the checkbox in the &quot;ACTIVE&quot; column.<br><br>
                               <strong>Active rules are processed every %2$s minutes.</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[RULE]';
$hesklang['recurring_tickets']['r2']='[RULE] Rule #%s';
$hesklang['recurring_tickets']['r3']='Rule #%s';
$hesklang['recurring_tickets']['i']='[INFO]';
$hesklang['recurring_tickets']['matched']='Number of tickets already created today: %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Reset this rule';
$hesklang['recurring_tickets']['reset2']='Are you sure you want to reset this rule?<br><br>Rule hits will go to 0 and any tickets already generated for it today, might be re-generated on next cron run.';
$hesklang['recurring_tickets']['reset3']='Selected rule has been reset';
$hesklang['recurring_tickets']['test']='Simulate this rule';
$hesklang['recurring_tickets']['testa']='Simulate all rules';
$hesklang['recurring_tickets']['testaa']='Simulate all active rules';
$hesklang['recurring_tickets']['testr']='Simulation results';
$hesklang['recurring_tickets']['rsim']='Repeat simulation';
$hesklang['recurring_tickets']['sim']='SIMULATION MODE, no changes to the database';
$hesklang['recurring_tickets']['sic']='SIMULATION COMPLETE';
$hesklang['recurring_tickets']['rrule_type_required']='Please select a valid recurring rule trigger.';
$hesklang['recurring_tickets']['rrule_string_required']='Please select all required recurring rule trigger options.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Please enter an interval value of 1 or bigger for "Every".';
$hesklang['recurring_tickets']['disable_note']='*If any critical hesk settings are changed after creation of a rule, it will be disabled on next run attempt and needs to be edited to pass new validation requirements.';
$hesklang['recurring_tickets']['thist1']='<li class="smaller">%1$s | submitted by Recurring Tickets Rule "%2$s"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class="smaller">%1$s | assigned to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class="smaller">%1$s | closed automatically by Recurring Tickets Rule "%2$s"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class="smaller">%1$s | status changed to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class="smaller">%1$s | automatically assigned to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='Rule was disabled due to validation errors. Check below for details.';
$hesklang['recurring_tickets']['errors_title']='One or more of your rules have produced errors when they attempted to be ran and were disabled.';
$hesklang['recurring_tickets']['rule_errors']='<hr>Rule #%s errors:';
$hesklang['recurring_tickets']['create_customers']='There are no existing customers - please create them <a href="%s" target="_blank">here</a>.';
$hesklang['recurring_tickets']['exec_dates']='Rule execution dates';
$hesklang['recurring_tickets']['show_exec_dates']='[Show current rule execution dates]';
$hesklang['recurring_tickets']['no_exec_dates']='Please select valid rule triggers to see execution dates.';
$hesklang['recurring_tickets']['invalid_disabled']='invalid Rrule settings - rule disabled.';
$hesklang['recurring_tickets']['next_occ']='Next %s rule occurrences:';
$hesklang['recurring_tickets']['occ_on']='on %s';
$hesklang['recurring_tickets']['not_firing_today']='does not need firing today.';
$hesklang['recurring_tickets']['rules_fulfilled']='recurring rules fulfilled - ticket created today!';
$hesklang['recurring_tickets']['validation_failed']='validation failed - rule disabled. Details below:';
$hesklang['recurring_tickets']['validation_error']='Validation error:';
$hesklang['recurring_tickets']['processed']='processed.';
$hesklang['recurring_tickets']['created_ticket']='created ticket id: %1$s, trackid: %2$s';
$hesklang['recurring_tickets']['due_date_note']='relative to ticket creation date';
$hesklang['priorities']='Priorities';
$hesklang['priority_intro']='Use this tool to manage ticket priorities for your help desk';
$hesklang['new_priority']='New priority';
$hesklang['edit_priority']='Edit priority';
$hesklang['priority_title']='Title';
$hesklang['can_customers_select_it']='Can customers select this priority?';
$hesklang['selected_by_customer']='Selectable by customers';
$hesklang['err_priority']='Enter the priority title';
$hesklang['priority_added']='A new priority has been added';
$hesklang['priority_e_id']='Invalid priority ID';
$hesklang['priority_mdf']='Priority has been saved';
$hesklang['priority_deleted']='Priority deleted';
$hesklang['priority_not_found']='This priority does not exist';
$hesklang['priority_not_empty']='This priority cannot be deleted because tickets with this priority exist';
$hesklang['click_to_enable_drag_drop']='Click to enable drag-and-drop for the row, then drag the row up or down to re-arrange priorities.';
$hesklang['confirm_delete_priority']='Are you sure you want to delete this priority?';
$hesklang['reordered_message']='Your priority list order has been saved.';
$hesklang['list_tkt_priority']='List all tickets with this priority';
$hesklang['deletion_priority_restricted']='This is a special priortiy and cannot be deleted';
$hesklang['priority_limit']='You cannot create any new priorities';
$hesklang['skip_to_main_content']='Skip to Main Content';
$hesklang['opens_dialog']='Opens a dialog';
$hesklang['create_a_ticket']='Create a ticket';
$hesklang['toggle_navigation']='Toggle navigation';
$hesklang['add_a_ticket_reply']='Add a ticket reply';
$hesklang['linked_tickets']='Linked tickets';
$hesklang['no_linked_tickets']='No linked tickets';
$hesklang['link_ticket']='Link ticket';
$hesklang['can_link_tickets_e']='You are not authorized to link/unlink this ticket';
$hesklang['link_ticket_success']='The ticket has been linked successfully';
$hesklang['link_ticket_required_error']='To link a ticket, please provide a valid Tracking ID';
$hesklang['link_ticket_itself_error']='A ticket cannot be linked to itself. Please enter a different Tracking ID';
$hesklang['already_linked_error']='The ticket has already been linked';
$hesklang['unlink_success']='The ticket has been successfully unlinked';
$hesklang['unlink_error']='No linked record exists';
$hesklang['link_history']='<li class="smaller">%s | %s ticket linked by %s</li>';
$hesklang['unlink_history']='<li class="smaller">%s | %s ticket unlinked by %s</li>';
$hesklang['can_link_tickets']='Can link ticket';
$hesklang['link_a_ticket']='Link a ticket';
$hesklang['mfa_curl']='Unable to generate a QR image to scan because <strong>cURL</strong> support is not enabled on your server.';
$hesklang['require_xml']='PHP-XML must be enabled for Rich Text (HTML) messages. Please ask your web host to enable XML for PHP.';
$hesklang['thist24']='<li class="smaller">%1$s | %2$s added as a collaborator by %3$s</li>';
$hesklang['thist25']='<li class="smaller">%1$s | %2$s removed as a collaborator by %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Perfect for preventive-maintenance jobs, monthly access reviews, recurring customer check-ins, and more.';
$hesklang['recurring_tickets']['feat1']='<strong>Set and forget schedules.</strong> Daily, every Monday, every March, the 15th of each month, or any future date';
$hesklang['recurring_tickets']['feat2']='<strong>Arrive pre-filled and assigned.</strong> Choose category, priority, agent, and up to 100 custom field values';
$hesklang['recurring_tickets']['feat3']='<strong>Preview dates and Simulate.</strong> See every ticket Hesk will generate before activating a rule, so there are no surprises.';
$hesklang['unlink_btn']='Unlink';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');