<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Nederlands (Dutch)
* Version: 3.6.x
*
* ==> CONTRIBUTORS
*
* Stephan Bogaert (http://bogaert.org)
* Arno Leerentveld (http://www.aajleerentveld.com)
* Frank Hoek (http://www.frankma.nl)
* Harm Hofstede (http://www.harmhofstede.nl)
* Martijn Blokzijl (http://www.ultracenter.nl)
* Tim De Meyer
* Jan Teunis (https://www.teunis.be)
* Jeffrey Driesen
* John Mulder
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Nederlands';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='Dutch';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_unicode_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Reageer boven deze lijn ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Nieuw ticket: %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Ticket ontvangen: %%SUBJECT%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Ticket toegewezen: %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Nieuwe reactie op: %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Nieuwe reactie op: %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Ticket verplaatst: %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Opmerking toegevoegd aan: %%SUBJECT%%';
$hesklang['new_pm']='Nieuw privébericht: %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Lijst van tickets';

// ERROR MESSAGES
$hesklang['cant_connect_db']='Kan geen verbinding maken met database!';
$hesklang['invalid_action']='Ongeldige handeling';
$hesklang['select_username']='Selecteer je gebruikersnaam';
$hesklang['enter_pass']='Vul je wachtwoord in';
$hesklang['cant_sql']='Het lukt niet SQL te draaien';
$hesklang['contact_webmsater']='Neem contact op met de webmaster';
$hesklang['mysql_said']='MySQL zegt';
$hesklang['wrong_pass']='Verkeerd wachtwoord.';
$hesklang['session_expired']='Meld je aan als beheerder';
$hesklang['attempt']='Ongeldige poging!';
$hesklang['not_authorized_tickets']='Je hebt geen toegang tot de tickets in deze categorie!';
$hesklang['must_be_admin']='Je hebt geen toegang tot deze pagina! Om deze pagina te bekijken dien je ingelogd te zijn als beheerder.';
$hesklang['no_session']='Nieuwe sessie niet gestart - sluit alle vensters en probeer het opnieuw';
$hesklang['error']='Fout';
$hesklang['int_error']='Interne programmeerfout';
$hesklang['no_trackID']='Geen tracking-ID';
$hesklang['status_not_valid']='Status niet geldig';
$hesklang['trackID_not_found']='Tracking-ID niet gevonden';
$hesklang['enter_message']='Vul je bericht in';
$hesklang['select_priority']='Selecteer prioriteit';
$hesklang['ticket_not_found']='Ticket niet gevonden! Tracking-ID klopt niet of ticket is verwijderd!';
$hesklang['no_selected']='Geen tickets geselecteerd, niets te verwijderen';
$hesklang['id_not_valid']='Dit is geen geldig tracking-ID';
$hesklang['enter_id']='Vul het tracking-ID in';
$hesklang['enter_name']='Vul de gebruikersnaam in';
$hesklang['enter_date']='Geef de datum op waarop je wilt zoeken';
$hesklang['date_not_valid']='Dit is geen geldige datum. Gebruik deze indeling <strong>jjjj-mm-dd</strong>.';
$hesklang['enter_subject']='Vul ticketonderwerp in';
$hesklang['invalid_search']='Ongeldige zoekbewerking';
$hesklang['choose_cat_ren']='Selecteer een categorie om te hernoemen';
$hesklang['cat_ren_name']='Geef een nieuwe categorienaam op';
$hesklang['cat_not_found']='Categorie niet gevonden';
$hesklang['enter_cat_name']='Vul de categorienaam in';
$hesklang['no_cat_id']='Geen categoriekenmerk';
$hesklang['cant_del_default_cat']='Je kunt de basiscategorie niet verwijderen, alleen hernoemen';
$hesklang['no_valid_id']='Ongeldige gebruikersnaam';
$hesklang['user_not_found']='Gebruiker is niet gevonden';
$hesklang['enter_real_name']='Vul je eigen naam in';
$hesklang['enter_valid_email']='Vul een geldig e-mailadres in';
$hesklang['enter_username']='Vul een gebruikersnaam in (voor inloggen)';
$hesklang['asign_one_cat']='Voeg de gebruiker toe aan tenminste één categorie!';
$hesklang['signature_long']='Uw handtekening is te lang! Je kunt maximaal 1000 karakters te gebruiken';
$hesklang['confirm_user_pass']='Bevestig het opgegeven wachtwoord';
$hesklang['passwords_not_same']='De opgegeven wachtwoorden zijn niet gelijk!';
$hesklang['cant_del_admin']='De basisbeheerder kan niet verwijderd worden!';
$hesklang['cant_del_own']='De gebruikersaccount waaronder je ingelogd bent, kun je niet verwijderen!';
$hesklang['enter_your_name']='Vul je naam in';
$hesklang['sel_app_cat']='Selecteer de juiste categorie';
$hesklang['sel_app_priority']='Selecteer de juist prioriteit';
$hesklang['enter_ticket_subject']='Vul het onderwerp voor je ticket in';
$hesklang['user_not_found_nothing_edit']='Gebruiker niet gevonden of niets te wijzigen';

// ADMIN PANEL
$hesklang['administrator']='Beheerder';
$hesklang['login']='Log in';
$hesklang['user']='Gebruiker';
$hesklang['username']='Gebruikersnaam';
$hesklang['pass']='Wachtwoord';
$hesklang['confirm_pass']='Bevestig wachtwoord';
$hesklang['logged_out']='Uitgelogd';
$hesklang['logout']='Log uit';
$hesklang['logout_success']='Je bent succesvol uitgelogd!';
$hesklang['click_login']='Klik hier om in te loggen';
$hesklang['back']='Vorige pagina';
$hesklang['displaying_pages']='<strong>%d</strong> ticketpagina\'s:';
$hesklang['trackID']='Tracking-ID';
$hesklang['timestamp']='Geplaatst';
$hesklang['name']='Naam';
$hesklang['subject']='Onderwerp';
$hesklang['status']='Status';
$hesklang['priority']='Prioriteit';
$hesklang['open']='Nieuw';
$hesklang['open_action']='Open'; // Open ACTION
$hesklang['close']='Gesloten'; // Closed ticket STATUS
$hesklang['any_status']='Elke status';
$hesklang['high']='Hoog';
$hesklang['medium']='Normaal';
$hesklang['low']='Laag';
$hesklang['del_selected']='Verwijder geselecteerde tickets';
$hesklang['manage_cat']='Beheer categorieën';
$hesklang['profile']='Je profiel';
$hesklang['show_tickets']='Bekijk tickets';
$hesklang['sort_by']='Sorteer op';
$hesklang['date_posted']='Datum';
$hesklang['category']='Categorie';
$hesklang['any_cat']='Elke categorie';
$hesklang['order']='Sorteer';
$hesklang['ascending']='Oudste boven';
$hesklang['descending']='Nieuwste boven';
$hesklang['display']='Weergave';
$hesklang['tickets_page']='tickets per pagina';
$hesklang['find_ticket']='Zoek ticket';
$hesklang['yyyy_mm_dd']='jjjj-mm-dd';
$hesklang['results_page']='resultaten per pagina';
$hesklang['opened']='Geopend'; // The ticket has been OPENED
$hesklang['closed']='Gesloten'; // Ticket has been RESOLVED
$hesklang['ticket']='ticket';
$hesklang['tickets']='Tickets';
$hesklang['ticket_been']='Dit ticket is';
$hesklang['view_ticket']='Bekijk ticket';
$hesklang['open_tickets']='Open tickets';
$hesklang['remove_statement']='Verwijder \'Powered by\' verklaring';
$hesklang['click_info']='klik voor meer informatie';
$hesklang['reply_added']='Reactie toegevoegd';
$hesklang['reply_submitted']='Reactie verzonden';
$hesklang['ticket_marked']='Ticket is gemarkeerd als';
$hesklang['ticket_status']='status ticket';
$hesklang['replies']='Reacties';
$hesklang['date']='Datum';
$hesklang['email']='E-mail';
$hesklang['ip']='IP';
$hesklang['message']='Stel hier je vraag';
$hesklang['add_reply']='Reageer';
$hesklang['close_this_ticket']='Markeer dit ticket als opgelost';
$hesklang['change_priority']='Wijzig prioriteit in';
$hesklang['attach_sign']='Voeg handtekening toe';
$hesklang['profile_settings']='Profielinstellingen';
$hesklang['submit_reply']='Verstuur reactie';
$hesklang['support_panel']='Ondersteuningspaneel';
$hesklang['ticket_trackID']='Het ID van het ticket<br />(te vinden in bevestigingsmail)';
$hesklang['c2c']='Klik hier om verder te gaan';
$hesklang['tickets_deleted']='Aanvragen verwijderd';
$hesklang['num_tickets_deleted']='<strong>%d</strong> tickets zijn verwijderd';
$hesklang['confirm_del_cat']='Weet je zeker dat je deze categorie wilt verwijderen?';
$hesklang['cat_intro']='Hier kun je categorieën beheren. Categorieën zijn erg makkelijk om tickets op type te groeperen (zoals bijvoorbeeld \'verkoop\',\'administratie\', \'PHP/MySQL problemen\' enz) en om gebruikers aan categorieën toe te wijzen, zodat bijvoorbeeld verkoopmedewerkers tickets geplaatst in de categorie \'verkoop\' kunnen behandelen.';
$hesklang['cat_name']='Naam categorie';
$hesklang['remove']='Verwijder';
$hesklang['add_cat']='Categorie toevoegen';
$hesklang['max_chars']='maximaal 20 karakters';
$hesklang['create_cat']='Bewaar wijzigingen';
$hesklang['ren_cat']='Hernoem categorie';
$hesklang['to']='naar';
$hesklang['cat_added']='Categorie toegevoegd';
$hesklang['cat_name_added']='Categorie %s is succesvol toegevoegd';
$hesklang['cat_renamed']='Categorie hernoemd';
$hesklang['cat_renamed_to']='Geselecteerde categorie is succesvol hernoemd naar';
$hesklang['cat_removed']='Categorie verwijderd';
$hesklang['cat_removed_db']='Geselecteerde categorie is succesvol verwijderd uit de database';
$hesklang['sure_remove_user']='Weet je zeker dat je deze gebruiker wilt verwijderen?';
$hesklang['manage_users']='Beheer gebruikers';
$hesklang['users_intro']='Hier kun je beheren welke gebruikers in kunnen loggen als beheerder en tickets kunnen beantwoorden. Beheerders kunnen tickets bekijken en aanpassen in elke categorie en hebben toegang tot alle beheerderfuncties (beheren van gebruikers, categorieën, ...) terwijl andere gebruikers alleen tickets in hun eigen categorie kunnen bekijken.';
$hesklang['yes']='JA';
$hesklang['no']='NEE';
$hesklang['edit']='Bewerk';
$hesklang['add_user']='Voeg nieuwe gebruiker toe';
$hesklang['req_marked_with']='Verplichte velden zijn gemarkeerd met';
$hesklang['real_name']='Echte naam';
$hesklang['signature_max']='Handtekening (max 1000 chars)';
$hesklang['sign_extra']='HTML is niet toegestaan. Links kunnen aangeklikt worden.';
$hesklang['create_user']='Maak gebruiker';
$hesklang['editing_user']='Bewerk gebruiker';
$hesklang['user_added']='Gebruiker is toegevoegd';
$hesklang['user_added_success']='Gebruiker %s met wachtwoord %s is succesvol toegevoegd';
$hesklang['profile_updated']='Profiel aangepast';
$hesklang['profile_updated_success']='Je profiel is succesvol aangepast';
$hesklang['user_removed']='Gebruiker is verwijderd';
$hesklang['sel_user_removed']='De geselecteerde gebruiker is succesvol verwijderd uit de database';
$hesklang['profile_for']='Profiel van';
$hesklang['new_pass']='Nieuw wachtwoord';
$hesklang['update_profile']='Bewerk profiel';
$hesklang['notify_new_posts']='Breng me op de hoogte van nieuwe tickets en reacties in mijn categorie';
$hesklang['view_profile']='Bekijk profiel';
$hesklang['new_ticket_submitted']='Nieuw ticket verzonden';
$hesklang['user_profile_updated_success']='Dit gebruikersprofiel is succesvol aangepast';
$hesklang['printer_friendly']='Printvriendelijke versie';
$hesklang['end_ticket']='--- einde ticket ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='Het tracking-ID is';
$hesklang['view_your_ticket']='Bekijk je ticket';
$hesklang['submit_ticket']='Maak een nieuw ticket';
$hesklang['sub_ticket']='Verzend ticket';
$hesklang['before_submit']='Zorg voor verzending dat ...';
$hesklang['all_info_in']='Alle noodzakelijke informatie is opgegeven';
$hesklang['all_error_free']='Alle informatie correct is opgegeven';
$hesklang['we_have']='We hebben';
$hesklang['recorded_ip']='genoteerd als je ip-adres';
$hesklang['recorded_time']='de tijd van je ticket genoteerd';
$hesklang['save_changes']='Wijzigingen opslaan';
$hesklang['reply_submitted_success']='Je reactie op dit ticket is succesvol verzonden';
$hesklang['ticket_submitted']='Ticket verzonden';
$hesklang['ticket_submitted_success']='Je ticket is verzonden met tracking-ID';
$hesklang['your_ticket']='Je ticket';

// Added in version 0.94
$hesklang['check_updates']='Zorg dat je steeds de laatste versie van Hesk hebt!';
$hesklang['check4updates']='Controleer op updates';
$hesklang['wait_reply']='Antwoord verwacht';
$hesklang['replied']='Beantwoord';
$hesklang['last_replier']='Laatste reactie';
$hesklang['staff']='Helpdesk';
$hesklang['customer']='Klant';
$hesklang['close_selected']='Markeer geselecteerde als gesloten/opgelost';
$hesklang['execute']='Voer uit';
$hesklang['saved_replies']='Vaste antwoorden';
$hesklang['manage_saved']='Vaste antwoorden';
$hesklang['manage_intro']='Hier kan je je vaste antwoorden beheren. Dit zijn regelmatig gebruikte antwoorden, zodanig dat je deze niet telkens opnieuw hoeft te typen.';
$hesklang['saved_title']='Titel (max 50 tekens)';
$hesklang['no_saved']='Geen vaste antwoorden';
$hesklang['delete_saved']='Weet je zeker dat dit vaste antwoord mag verwijderd worden?';
$hesklang['new_saved']='Voeg toe of bewerk een vast antwoord';
$hesklang['canned_add']='Maak een nieuw vast antwoord';
$hesklang['canned_edit']='Bewerk geselecteerd vast antwoord';
$hesklang['save_reply']='Bewaar antwoord';
$hesklang['saved']='Antwoord bewaard';
$hesklang['your_saved']='Je vaste antwoord is bewaard voor later gebruik';
$hesklang['ent_saved_title']='Voer de titel in';
$hesklang['ent_saved_msg']='Voer het bericht in';
$hesklang['saved_removed']='Vast antwoord verwijderd';
$hesklang['saved_rem_full']='Geselecteerde vaste antwoord is verwijderd uit de database';
$hesklang['clip_alt']='Dit bericht heeft bijlagen';
$hesklang['attachments']='Bijlagen';
$hesklang['fill_all']='Een vereist veld i=ontbreekt';
$hesklang['file_too_large']='Je bestand %s is te groot';
$hesklang['cannot_move_tmp']='Bestand kan niet worden verplaatst naar map voor bijlagen';
$hesklang['created_on']='Gemaakt op';
$hesklang['tickets_closed']='Het ticket is gesloten';
$hesklang['num_tickets_closed']='<strong>%d</strong> tickets zijn gesloten';
$hesklang['select_saved']='Selecteer een vast antwoord';
$hesklang['select_empty']='Selecteer / Leeg';
$hesklang['insert_special']='Voeg speciale code toe (wordt vervangen door klantinfo)';
$hesklang['move_to_catgory']='Verplaats ticket naar';
$hesklang['move']='Verplaats';
$hesklang['moved']='Het ticket is verplaatst';
$hesklang['moved_to']='Dit ticket is verplaatst naar een nieuwe categorie';
$hesklang['url']='URL';
$hesklang['all_not_closed']='Alle behalve gesloten';
$hesklang['chg_all']='Wijzig allemaal';
$hesklang['settings']='Instellingen';
$hesklang['settings_intro']='Gebruik dit om je helpdesk te configureren. Voor meer informatie over alle instellingen en opties klik op het helpteken of lees readme.htm.';
$hesklang['all_req']='Alle velden (behalve uitgeschakelde) zijn verplicht!';
$hesklang['wbst_title']='Naam website';
$hesklang['wbst_url']='URL website';
$hesklang['email_wm']='E-mail webmaster';
$hesklang['max_listings']='Tickets per pagina';
$hesklang['print_size']='Lettergrootte print';
$hesklang['debug_mode']='Debug modus';
$hesklang['on']='AAN';
$hesklang['off']='UIT';
$hesklang['use_secimg']='Gebruik anti-spam afbeelding';
$hesklang['secimg_no']='Niet beschikbaar';
$hesklang['attach_use']='Bijlagen toegestaan';
$hesklang['attach_num']='Aantal per ticket';
$hesklang['attach_type']='Toegelaten bestandstypes';
$hesklang['place_after']='Na het bericht';
$hesklang['place_before']='Voor het bericht';
$hesklang['custom_f']='Bijkomend veld';
$hesklang['custom_u']='Gebruik dit veld';
$hesklang['custom_n']='Veldnaam';
$hesklang['custom_l']='Maximum lengte (tekens)';
$hesklang['db_host']='Database host';
$hesklang['db_name']='Database naam';
$hesklang['db_user']='Database gebruikersnaam';
$hesklang['db_pass']='Database wachtwoord';
$hesklang['err_sname']='Geef de titel van je website';
$hesklang['err_surl']='Geef de titel van je website. Zorg voor een geldige URL (start met http:// of https://)';
$hesklang['err_wmmail']='Geef een geldig e-mailadres op voor de webmaster';
$hesklang['err_nomail']='Geef een geldig noreply e-mailadres';
$hesklang['err_htitle']='Geef de titel van je helpdesk';
$hesklang['err_hurl']='Geef je Hesk-url. Zorg voor een geldige URL (start met http:// of https://)';
$hesklang['err_lang']='Selecteer Hesk taal';
$hesklang['err_nolang']='Het taalbestand bestaat niet in de language-map! Gelieve dit eerst up te loaden vooraleer een andere taal te kiezen.';
$hesklang['err_max']='Geef het maximum aantal getoond per pagina';
$hesklang['err_psize']='Geef de juiste grootte van het lettertype';
$hesklang['err_dbhost']='Voer MySQL database host in';
$hesklang['err_dbname']='Voer MySQL database naam in';
$hesklang['err_dbuser']='Voer MySQL database gebruikersnaam in';
$hesklang['err_dbpass']='Voer MySQL database wachtwoord in';
$hesklang['err_dbconn']='Kan niet verbinden met database met deze gegevens';
$hesklang['err_dbsele']='Kan geen connectie maken naar de MySQL database, controleer goed je databasenaam';
$hesklang['err_custname']='Geef de namen voor de geselecteerde optionele velden';
$hesklang['err_openset']='Kan in <strong>hesk_settings.inc.php</strong> niet schrijven. CHMOD dit bestand naar 666 (rw-rw-rw-)';
$hesklang['set_saved']='Instellingen bewaard';
$hesklang['set_were_saved']='Je instellingen zijn goed bewaard';
$hesklang['sec_img']='Anti-spam tekening';
$hesklang['sec_miss']='Geef het juiste nummer op';
$hesklang['sec_wrng']='Verkeerd nummer';
$hesklang['submit_problems']='Ga terug en corrigeer volgende problemen';
$hesklang['cat_order']='Volgorde categorie';
$hesklang['reply_order']='Volgorde vaste antwoorden';
$hesklang['move_up']='Naar omhoog';
$hesklang['move_dn']='Naar omlaag';
$hesklang['cat_move_id']='Gemist categorie ID';
$hesklang['reply_move_id']='Gemist vast antwoord ID';
$hesklang['forgot_tid']='Tracking-ID onbekend?';
$hesklang['tid_send']='Ontvang tickets';
$hesklang['tid_not_found']='Er zijn geen tickets met dit e-mailadres gevonden';
$hesklang['tid_sent']='Tracking-ID verzonden';
$hesklang['tid_sent2']='Je tickets zijn verzonden per e-mail';
$hesklang['check_spambox']='Als je geen e-mail ontvangt, controleer dan de map met ongewenste items/de spammap in je mailbox!';
$hesklang['reply_not_found']='Vast antwoord niet gevonden';
$hesklang['exists']='Bestaat';
$hesklang['no_exists']='Bestaat niet';
$hesklang['writable']='Schrijfbaar';
$hesklang['not_writable']='Niet schrijfbaar';
$hesklang['disabled']='uitgeschakeld';
$hesklang['e_settings']='Je instellingen zullen niet bewaard worden tenzij je dit bestand schrijfbaar maakt. Lees de handleiding voor verdere instructies!';
$hesklang['e_attdir']='Je zal geen bijlagen kunnen gebruiken als de map attachments niet bestaat of niet schrijfbaar is. Lees de handleiding voor verdere instructies!';
$hesklang['e_save_settings']='Niet mogelijk om je instellingen te  bewaren omdat <strong>hesk_settings.inc.php</strong> niet schrijfbaar is.';
$hesklang['e_attach']='Uitgeschakeld om dat de map <strong>attachments</strong> niet schrijfbaar is.';
$hesklang['go']='Ga';

// Added in version 2.0
$hesklang['v']='HESK versie';
$hesklang['check_status']='Controleren status';
$hesklang['sub_support']='Maak een nieuw ticket aan';
$hesklang['open_ticket']='';
$hesklang['view_existing']='Bekijk een eerder ticket';
$hesklang['vet']='';
$hesklang['enter_user']='Vul een gebruikersnaam in';
$hesklang['remember_user']='Onthoud mijn gebruikersnaam';
$hesklang['wrong_user']='Verkeerde gebruikersnaam';
$hesklang['no_permission']='Je hebt geen rechten om deze taak uit te voeren. Log in met een gebruiker die wel rechten heeft.';
$hesklang['tickets_on_pages']='Er zijn %d tickets in %d pagina\'s'; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']='Ga naar pagina:';
$hesklang['no_tickets_open']='Geen open tickets gevonden';
$hesklang['no_tickets_crit']='Geen tickets gevonden die voldoen aan je criteria';
$hesklang['confirm_execute']='Weet je zeker dat je door wilt gaan?';
$hesklang['legend']='Legenda';
$hesklang['main_page']='Hoofdpagina';
$hesklang['menu_users']='Gebruikers';
$hesklang['menu_cat']='Categorieën';
$hesklang['menu_profile']='Profiel';
$hesklang['menu_kb']='Kennisbank'; // Admin MENU item
$hesklang['kb_text']='Kennisbank'; // Item visible to customers
$hesklang['viewkb']='Bekijk gehele kennisbank';
$hesklang['kb']='Beheer Kennisbank';
$hesklang['kb_intro']='De Kennisbank is een collectie van antwoorden op vaak gestelde vragen'; // Description in ADMIN panel
$hesklang['kb_is']='De Kennisbank is een collectie van antwoorden op vaak gestelde vragen'; // Description for CUSTOMERS
$hesklang['new_kb_art']='Nieuw artikel';
$hesklang['kb_cat']='Categorie';
$hesklang['kb_subject']='Onderwerp';
$hesklang['kb_content']='Inhoud';
$hesklang['kb_type']='Type';
$hesklang['kb_published']='Geplaatst';
$hesklang['kb_published2']='Dit artikel is voor iedereen zichtbaar.';
$hesklang['kb_private']='Privé';
$hesklang['kb_private2']='Privé-artikelen kunnen alleen gelezen worden door beheerders.';
$hesklang['kb_draft']='Concept';
$hesklang['kb_draft2']='Het artikel is opgeslagen, maar nog niet gepubliceerd. Het kan alleen gelezen worden door beheerders<br /> die toegang hebben tot het beheer van de Kennisbank ';
$hesklang['kb_links']='<em><span class="notice"><strong>Waarschuwing!</strong></span><br />Voeg juiste code toe zonder &lt;head&gt; en &lt;body&gt; codes, alleen inhoud!</em>';
$hesklang['kb_ehtml']='Dit is HTML-code (ik voeg juiste (X)HTML-code toe)';
$hesklang['kb_dhtml']='Dit is platte tekst (links zullen klikbaar zijn)';
$hesklang['kb_save']='Sla artikel op';
$hesklang['kb_e_subj']='Vul onderwerp artikel in!';
$hesklang['kb_e_cont']='Vul artikel inhoud in!';
$hesklang['kb_art_added']='Artikel toegevoegd';
$hesklang['your_kb_added']='Artikel succesvol toegevoegd';
$hesklang['kb_art_deleted']='Artikel verwijderd';
$hesklang['your_kb_deleted']='Geselecteerde artikel is succesvol verwijderd';
$hesklang['kb_art_mod']='Artikel aangepast';
$hesklang['your_kb_mod']='Je aanpassingen aan het geselecteerde artikel is succesvol opgeslagen';
$hesklang['kb_cat_new']='Nieuwe (sub)categorie';
$hesklang['kb_cat_parent']='Hoofdcategorie';
$hesklang['kb_cat_sub']='Subcategorieën';
$hesklang['kb_cat_title']='Titel categorie';
$hesklang['kb_cat_published']='De categorie is voor iedereen zichtbaar in de Kennisbank.';
$hesklang['kb_cat_private']='De categorie is alleen zichtbaar voor beheerders.';
$hesklang['kb_cat_add']='Voeg categorie toe';
$hesklang['kb_cat_e_title']='Vul de titel van de categorie titel!';
$hesklang['kb_cat_added']='Categorie toegevoegd';
$hesklang['kb_cat_added2']='Een nieuwe categorie is succesvol toegevoegd aan de Kennisbank';
$hesklang['kb_cat_man']='Beheer Kennisbank categorieën';
$hesklang['kb_cat_edit']='Bewerk categorie-details';
$hesklang['kb_cat_inv']='Foute categorie';
$hesklang['kb_cat_art']='Artikelen in deze categorie';
$hesklang['kb_p_art']='+ Artikel';
$hesklang['kb_p_art2']='voeg een nieuw artikel toe aan de geselecteerde categorie.';
$hesklang['kb_add_art']='Voeg artikel toe';
$hesklang['kb_p_cat']='+ Categorie';
$hesklang['kb_p_cat2']='maak een nieuwe subcategorie in de geselecteerde categorie.';
$hesklang['kb_add_cat']='Voeg categorie toe';
$hesklang['kb_p_man']='Beheer';
$hesklang['kb_p_man2']='beheer geselecteerde categorie (bewerken, verwijderen, beheer artikelen).';
$hesklang['kb_main']='De hoofdcategorie kan niet verwijderd of verplaatst worden.';
$hesklang['kb_no_art']='Er zijn geen artikelen in deze categorie.';
$hesklang['author']='Auteur';
$hesklang['views']='Aantal bekeken';
$hesklang['delete']='Verwijder';
$hesklang['rating']='Beoordeling';
$hesklang['votes']='Stemmen';
$hesklang['kb_rated']='Artikel beoordeeld %s/5.0';
$hesklang['kb_not_rated']='Artikel nog niet beoordeeld';
$hesklang['del_art']='Weet je zeker dat je het geselecteerde artikel wilt verwijderen?';
$hesklang['kb_art_id']='Geen of verkeerde artikel-ID!';
$hesklang['kb_art_edit']='Wijzig artikel';
$hesklang['revhist']='Herziening historie';
$hesklang['revision1']='<li class="smaller">%s | verzonden door %s</li>'; // %s = date, user making change
$hesklang['revision2']='<li class="smaller">%s | aangepast door %s</li>'; // %s = date, user making change
$hesklang['kb_order']='Sorteer';
$hesklang['kb_delcat']='Weet je zeker dat je deze categorie wilt verwijderen?';
$hesklang['kb_cat_mod']='Categorie gewijzigd';
$hesklang['your_cat_mod']='Je veranderingen aan de geselecteerde categorie zijn succesvol opgeslagen';
$hesklang['kb_cat_del']='Categorie verwijderd';
$hesklang['kb_cat_dlt']='De geselecteerde categorie is verwijderd.';
$hesklang['allowed_cat']='Categorieën';
$hesklang['allow_feat']='Functionaliteiten';
$hesklang['can_view_tickets']='Kan tickets bekijken';
$hesklang['can_reply_tickets']='Kan tickets beantwoorden';
$hesklang['can_assign_tickets']='Kan tickets toewijzen';
$hesklang['can_del_tickets']='Kan tickets verwijderen';
$hesklang['can_edit_tickets']='Kan antwoorden wijzigen';
$hesklang['can_change_cat']='Kan tickets verplaatsen naar andere categorie';
$hesklang['can_man_kb']='Kan kennisbank beheren';
$hesklang['can_man_users']='Kan gebruikers beheren';
$hesklang['can_man_cat']='Kan categorieën beheren';
$hesklang['can_man_canned']='Kan vaste antwoorden beheren';
$hesklang['can_man_settings']='Kan instellingen beheren';
$hesklang['can_del_notes']='Kan opmerkingen verwijderen';
$hesklang['dan']='gebruikers kunnen hun eigen ticket verwijderen, selecteer dit alleen als je wilt dat de gebruiker ook tickets van andere gebruikers mag verwijderen';
$hesklang['in_all_cat']='alleen in toegestane categorieën';
$hesklang['admin_can']='(toegang tot alle functionaliteiten en categorieën)';
$hesklang['staff_can']='(toegang tot bepaalde functionaliteiten en categorieën)';
$hesklang['asign_one_feat']='Wijs tenminste één functionaliteit toe aan deze gebruiker!';
$hesklang['na_view_tickets']='Je hebt geen rechten om tickets te bekijken';
$hesklang['support_notice']='Sorry, deze sectie kan alleen worden verborgen als je een HESK-licentie aanschaft!';
$hesklang['rart']='Was dit artikel bruikbaar?';
$hesklang['r']='Was dit antwoord bruikbaar?';
$hesklang['tyr']='Bedankt voor je beoordeling';
$hesklang['cw']='Sluit scherm';
$hesklang['cw2']='Sluit scherm en voeg ticket toe';
$hesklang['rh']='Beoordeel als <em>bruikbaar</em>';
$hesklang['rnh']='Beoordeel als <em>niet bruikbaar</em>';
$hesklang['ar']='Is al beoordeeld';
$hesklang['rated']='Gebruiker beoordeeld %s/5.0 (%s stemmen)';
$hesklang['not_rated']='Gebruiker nog niet beoordeeld';
$hesklang['rdis']='Beoordeling is uitgeschakeld';
$hesklang['kbdis']='Kennisbank is uitgeschakeld';
$hesklang['kbpart']='Sorry, je hebt geen toegang tot dit artikel';
$hesklang['popart']='Meestgelezen artikelen';
$hesklang['latart']='Nieuwe artikelen:';
$hesklang['m']='Meer onderwerpen';
$hesklang['ac']='Artikelen in deze categorie:';
$hesklang['noa']='Nog geen artikelen';
$hesklang['noac']='Nog geen artikelen in deze categorie';
$hesklang['dta']='Datum toegevoegd';
$hesklang['ad']='Artikeldetails';
$hesklang['aid']='Artikel-ID';
$hesklang['as']='Oplossing';
$hesklang['search']='Zoeken';
$hesklang['sr']='Zoek resultaten';
$hesklang['nosr']='Geen artikelen gevonden. Raadpleeg de Kennisbank of stuur een <a href=index.php?a=add>nieuw ticket</a>.';
$hesklang['rv']='Reset aantal bekeken';
$hesklang['rr']='Reset stemmen (beoordelingen)';
$hesklang['opt']='Opties';
$hesklang['delcat']='Verwijder categorie';
$hesklang['move1']='Verplaats artikelen naar hoofdcategorie';
$hesklang['move2']='Verwijder artikelen in deze categorie';
$hesklang['sc']='Aanbevolen artikelen';
$hesklang['not']='Aanvragen'; // Number of all tickets in category
$hesklang['graph']='Grafiek';
$hesklang['lu']='Lijst gebruikersnamen';
$hesklang['aclose']='Tickets sluiten';
$hesklang['aclose2']='dagen na laatste antwoord beheerder';
$hesklang['s_ucrt']='Ticket heropenen door klant';
$hesklang['urate']='Beoordeling antwoord';
$hesklang['hesk_url']='URL helpdesk';
$hesklang['hesk_title']='Naam helpdesk';
$hesklang['cid']='Tracking-ID ticket';
$hesklang['tfor']='Tijdnotatie';
$hesklang['prefix']='Prefix tabellen';
$hesklang['s_ekb']='Kennisbank inschakelen';
$hesklang['s_kbs']='Zoekfunctie inschakelen';
$hesklang['s_kbr']='Activeer beoordelingen kennisbank';
$hesklang['s_maxsr']='Maximum zoekresultaten';
$hesklang['s_suggest']='Kennisbankartikelen voorstellen';
$hesklang['s_spop']='Toon populaire artikelen';
$hesklang['s_slat']='Toon recente artikelen';
$hesklang['s_onin']='op <a href="../" target="_blank">helpdesk</a>';
$hesklang['s_onkb']='op <a href="../knowledgebase.php" target="_blank">kennisbank</a>';
$hesklang['s_scol']='Categorieën in rij';
$hesklang['s_ptxt']='Lengte voorvertoning artikel';
$hesklang['s_psubart']='Subcategorie artikelen';
$hesklang['enable']='Activeer';
$hesklang['s_type']='Type';
$hesklang['custom_r']='Verplicht';
$hesklang['custom_place']='Locatie';
$hesklang['custom_use']='Eigen velden';
$hesklang['stf']='Standaard tekstveld';
$hesklang['stb']='Tekstveld (grootte aanpasbaar)';
$hesklang['srb']='Keuzeknoppen';
$hesklang['ssb']='Selectiemenu';
$hesklang['db']='Database';
$hesklang['hd']='Instellingen helpdesk';
$hesklang['gs']='Algemene instellingen';
$hesklang['cwin']='Sluit venster';
$hesklang['defw']='Standaardwaarde';
$hesklang['ok']='OK';
$hesklang['ns']='Dit zijn de beschikbare opties voor dit aanpasbaar veld. Om wijzigingen op te slaan klik je op <strong>OK</strong> en dan op de knop <strong>Sla wijzigingen op</strong> op de pagina Instellingen!';
$hesklang['rows']='Rijen (hoogte)';
$hesklang['cols']='Kolommen (breedte)';
$hesklang['opt2']='Opties voor keuzeknoppen. Voer een optie in per regel. Elke regel voegt een keuzemogelijkheid toe. Voeg op zijn minst twee opties toe.';
$hesklang['opt3']='Opties voor keuzeknoppen. Voer een optie in per regel. Elke regel voegt een keuzemogelijkheid toe. Voeg op zijn minst twee opties toe.';
$hesklang['atl2']='Voeg op zijn minst twee opties toe (één per regel).';
$hesklang['notes']='Opmerkingen';
$hesklang['addnote']='+ Plaats opmerking';
$hesklang['noteby']='Opmerking geplaatst door';
$hesklang['delnote']='Verwijder opmerking';
$hesklang['noteerr']='Opmerking al verwijderd of verkeerde parameters';
$hesklang['s']='Plaats opmerking';
$hesklang['nhid']='Opmerkingen zijn verborgen voor klanten!';
$hesklang['delt']='Verwijder dit bericht';
$hesklang['edtt']='Bewerk bericht';
$hesklang['edt1']='Bericht bewerkt';
$hesklang['edt2']='Veranderingen aan de geselecteerde bericht zijn opgeslagen';
$hesklang['dele']='Ticket verwijderen';
$hesklang['repd']='Bericht verwijderd';
$hesklang['repl']='Geselecteerde bericht is verwijderd';
$hesklang['tickets_found']='Zoekresulaten';
$hesklang['al']='Beheerderslink';
$hesklang['ap']='BEHEER';
$hesklang['dap']='Toon link naar het beheerdersgedeelte op de <a href="../" target="_blank">helpdesk homepage</a>';
$hesklang['q_miss']='Beantwoord aub de anti-spam vraag';
$hesklang['use_q']='Gebruik anti-spam vraag';
$hesklang['q_q']='Vraag (HTML-code is <font class="success">toegestaan</font>)';
$hesklang['q_a']='Antwoord';
$hesklang['err_qask']='Typ een anti-spam vraag';
$hesklang['err_qans']='Typ een antwoord op de anti-spam vraag';
$hesklang['genq']='Genereer een willekeurige vraag';

// Added in version 2.1
$hesklang['amo']='Voeg meer toe';
$hesklang['delatt']='Geselecteerde bijlage verwijderen?';
$hesklang['kb_att_rem']='Geselecteerde bijlage is verwijderd';
$hesklang['inv_att_id']='Ongeldige bijlage-ID!';
$hesklang['scb']='Checkbox';
$hesklang['opt4']='Opties voor deze checkbox, een per regel. Elke regel resulteert in een keuzemogelijkheid, multiple choice is toegestaan. Geef tenminste twee opties op!';
$hesklang['autologin']='Log mij altijd automatisch in';
$hesklang['just_user']='Sla alleen mijn gebruikersnaam op';
$hesklang['nothx']='Nee, bedankt';
$hesklang['pinfo']='Profielinformatie';
$hesklang['sig']='Handtekening';
$hesklang['pref']='Voorkeuren';
$hesklang['aftrep']='Na het beantwoorden van een ticket';
$hesklang['showtic']='Toon het ticket die ik zojuist heb beantwoord';
$hesklang['gomain']='Terug naar hoofdadministratiepagina';
$hesklang['shownext']='Open het volgende ticket dat open staat (indien geen open tickets: ga naar de administratiepagina)';
$hesklang['rssn']='Volgende ticket dat op antwoord wacht';
$hesklang['mrep']='Vervang bestaande boodschap';
$hesklang['madd']='Voeg onderaan toe';
$hesklang['priv']='Privécategorieën en artikelen - alleen zichtbaar voor beheerders - zijn gemerkt met een *';
$hesklang['inve']='Ongeldig e-mailbestand';
$hesklang['emfm']='Ontbrekend e-mailbestand';
$hesklang['hesk_lang']='Standaardtaal';
$hesklang['s_mlang']='Meerdere talen';
$hesklang['s_mlange']='Indien AAN, dan kunnen gebruikers de helpdesk in elk van de geïnstalleerde talen benaderen. Zet alleen AAN als alle geïnstalleerde talen worden ondersteund!';
$hesklang['s_inl']='Test taalmap';
$hesklang['s_inle']='Bezig met testen van taalbestanden';
$hesklang['ta']='Test opnieuw';
$hesklang['alo']='Automatisch inloggen toestaan';
$hesklang['chol']='Voorkeurstaal';
$hesklang['mmdl']='Stel deze taal in als voorkeurstaal';
$hesklang['warn']='WAARSCHUWING';
$hesklang['dmod']='Debug mode staat aan. Overtuig jezelf ervan dat <em>debug mode</em> uit staat wanneer je HESK helemaal geïnstalleerd hebt en in gebruik neemt.';
$hesklang['kb_spar']='Categorie kan niet zijn eigen <em>parent</em>-categorie zijn!';
$hesklang['mysql_root']='Je MySQL-wachtwoord is leeg. Weet je zeker dat je wilt inloggen met <em>root user</em>? Dit is een ernstig veiligheidsrisico!';
$hesklang['chg']='Wijzig';
$hesklang['chpri']='Prioriteit gewijzigd';
$hesklang['chpri2']='Prioriteit van ticket is gewijzigd naar %s';
$hesklang['selcan']='Selecteer het vaste antwoord dat je wilt aanpassen';
$hesklang['q_wrng']='Verkeerd anti-spamantwoord';
$hesklang['cndupl']='Je hebt al een categorie met die naam. Kies een unieke naam voor elke categorie.';
$hesklang['wsel']='Selecteer het veld waarop je wilt zoeken';

// Added in version 2.2
$hesklang['eto']='Ongeldig verzoek';
$hesklang['id']='ID';
$hesklang['geco']='Genereer directe link';
$hesklang['genl']='Categorielink';
$hesklang['genl2']='Gebruik deze link om de categorie te selecteren in het formulier';
$hesklang['ask']='Zoeken:';
$hesklang['exa']='Voorbeelden';
$hesklang['small']='Klein venster';
$hesklang['large']='Groot venster';
$hesklang['cpri']='Prioriteit';
$hesklang['owner']='Eigenaar';
$hesklang['unas']='Niet toegewezen';
$hesklang['assi']='Toewijzen';
$hesklang['asst']='Toewijzen aan';
$hesklang['asst2']='Ticket toewijzen aan';
$hesklang['asss']='Toewijzen aan jezelf';
$hesklang['asss2']='Toewijzen aan mezelf';
$hesklang['can_assign_self']='Kan toewijzen aan zichzelf';
$hesklang['can_assign_others']='Kan toewijzen aan anderen';
$hesklang['can_run_reports']='Kan rapportages maken (eigen)';
$hesklang['can_view_ass_others']='Kan tickets zien die zijn toegewezen aan anderen';
$hesklang['unoa']='De geselecteerde gebruiker heeft geen toegang tot deze categorie';
$hesklang['tasi']='Toegewezen eigenaar';
$hesklang['tasy']='Ticket toegewezen aan jou';
$hesklang['taso']='Ticket toegewezen aan geselecteerde gebruiker';
$hesklang['tasy2']='Toegewezen aan jou';
$hesklang['taso2']='Toegewezen aan een ander';
$hesklang['nose']='Geen eigenaar geselecteerd';
$hesklang['onasc']='De geselecteerde eigenaar heeft geen toegang tot deze categorie.';
$hesklang['tunasi']='Ticket niet toegewezen';
$hesklang['tunasi2']='Ticket zonder eigenaar, klaar om toe te wijzen';
$hesklang['note']='Notitie';
$hesklang['success']='Succes';
$hesklang['nyt']='Toegewezen aan';
$hesklang['noch']='Geen wijzigingen';
$hesklang['orch']='Vertoning aangepast';
$hesklang['rfm']='Verplichte informatie ontbreekt:';
$hesklang['repl0']='Onvoldoende rechten';
$hesklang['repl1']='Dit item bestaat niet';
$hesklang['reports']='Rapporten';
$hesklang['reports_intro']='Deze sectie toont rapporten en statistieken';
$hesklang['refi']='Reset data';
$hesklang['dich']='Negeer wijzigingen';
$hesklang['dire']='Rapport tonen';
$hesklang['m1']='januari';
$hesklang['m2']='februari';
$hesklang['m3']='maart';
$hesklang['m4']='april';
$hesklang['m5']='mei';
$hesklang['m6']='juni';
$hesklang['m7']='juli';
$hesklang['m8']='augustus';
$hesklang['m9']='september';
$hesklang['m10']='oktober';
$hesklang['m11']='november';
$hesklang['m12']='december';
$hesklang['d1']='maandag';
$hesklang['d2']='dinsdag';
$hesklang['d3']='woensdag';
$hesklang['d4']='donderdag';
$hesklang['d5']='vrijdag';
$hesklang['d6']='zaterdag';
$hesklang['d0']='zondag';
$hesklang['mo']='ma';
$hesklang['tu']='di';
$hesklang['we']='wo';
$hesklang['th']='do';
$hesklang['fr']='vr';
$hesklang['sa']='za';
$hesklang['su']='zo';
$hesklang['from']='Vanaf';
$hesklang['cinv']='Ongeldige datum';
$hesklang['cinv2']='Datuminvoer: mm/dd/yyyy';
$hesklang['cinm']='Ongeldige maand';
$hesklang['cinm2']='Geldig bereik is';
$hesklang['cind']='Ongeldige dag';
$hesklang['cind2']='Geldig bereik voor de geselecteerde maand is';
$hesklang['month']='Maand';
$hesklang['ocal']='Open kalendar';
$hesklang['ca01']='Vorig jaar';
$hesklang['ca02']='Vorige maand';
$hesklang['ca03']='Volgende maand';
$hesklang['ca04']='Volgend jaar';
$hesklang['ca05']='Sluit kalender';
$hesklang['cdr']='Kies bereik:';
$hesklang['crt']='Rapporttype';
$hesklang['r1']='Vandaag';
$hesklang['r2']='Gisteren';
$hesklang['r3']='Deze maand';
$hesklang['r4']='Vorige maand';
$hesklang['r5']='Laatste 30 dagen';
$hesklang['r6']='Deze week (ma-zo)';
$hesklang['r7']='Vorige week (ma-zo)';
$hesklang['r8']='Deze werkweek (ma-zo)';
$hesklang['r9']='Vorige werkweek (ma-zo)';
$hesklang['r10']='Dit jaar';
$hesklang['r11']='Vorig jaar';
$hesklang['r12']='Ooit';
$hesklang['datetofrom']='Ongeldige datums, datums zijn omgekeerd';
$hesklang['t1']='Aanvragen per dag';
$hesklang['t2']='Aanvragen per maand';
$hesklang['t3']='Aanvragen per gebruiker';
$hesklang['t4']='Aanvragen per categorie';
$hesklang['ticass']='Toegewezen tickets';
$hesklang['ticall']='Beantwoorde tickets';
$hesklang['totals']='Totalen';
$hesklang['all']='Alle';
$hesklang['atik']='Nieuwe tickets';
$hesklang['kbca']='Categorie bestaat reeds';
$hesklang['menu_msg']='Berichten';
$hesklang['menu_can']='Standaard-antwoorden';
$hesklang['m_from']='Van:'; // Mail "from" address
$hesklang['m_to']='Aan:'; // Mail "to" address
$hesklang['m_sub']='Onderwerp:'; // Mail subject
$hesklang['m_re']='Re:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='Fwd:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Berichten';
$hesklang['m_intro']='Stuur berichten naar andere helpdeskmedewerkers';
$hesklang['e_udel']='(gebruiker verwijderd)';
$hesklang['new_mail']='Nieuw bericht';
$hesklang['m_send']='Verzend bericht';
$hesklang['m_rec']='Selecteer ontvanger';
$hesklang['m_inr']='Ongeldige ontvanger';
$hesklang['m_esu']='Voer onderwerp in';
$hesklang['m_pms']='Bericht verzonden';
$hesklang['inbox']='POSTVAK IN';
$hesklang['outbox']='POSTVAK UIT';
$hesklang['m_new']='NIEUW BERICHT';
$hesklang['pg']='Toon pagina';
$hesklang['npm']='Geen berichten in deze map';
$hesklang['m_ena']='Geen toegang tot bericht';
$hesklang['mau']='Markeer als ongelezen';
$hesklang['mo1']='Markeer geselecteerde berichten als gelezen';
$hesklang['mo2']='Markeer geselecteerde berichten als ongelezen';
$hesklang['mo3']='Verwijder geselecteerde berichten ';
$hesklang['delm']='Verwijder bericht';
$hesklang['e_tid']='Geen ID toegewezen. Probeer het later nog eens';
$hesklang['smmr']='Gemarkeerd als gelezen';
$hesklang['smmu']='Gemarkeerd als ongelezen';
$hesklang['smdl']='Verwijderd';
$hesklang['show']='Toon';
$hesklang['s_my']='Toegewezen aan mij';
$hesklang['s_ot']='Toegewezen aan anderen';
$hesklang['s_un']='Niet toegewezen';
$hesklang['s_for']='Zoek naar';
$hesklang['s_in']='Zoek in';
$hesklang['s_incl']='Zoek binnen';
$hesklang['find_ticket_by']='Zoek een ticket';
$hesklang['e_nose']='Alle ticket worden getoond';
$hesklang['fsq']='Voer zoekopdracht in';
$hesklang['topen']='Open';
$hesklang['nms']='Geen bericht geselecteerd';
$hesklang['tlo']='Blokkeer ticket';
$hesklang['tul']='Deblokkeer ticket';
$hesklang['loc']='Geblokkeerd';
$hesklang['isloc']='Klanten kunnen niet reageren op geblokkeerde tickets';
$hesklang['tlock']='Ticket geblokkeerd';
$hesklang['tunlock']='Ticket gedeblokkeerd';
$hesklang['tislock']='Klanten kunnen niet reageren op geblokkeerde tickets';
$hesklang['tislock2']='Dit ticket is geblokkeerd, je kan er nu niet op reageren';
$hesklang['nsfo']='Niets gevonden';
$hesklang['thist1']='<li class="smaller">%s | verplaatst naar categorie %s door %s</li>'; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller">%s | toegewezen aan %s door %s</li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class="smaller">%s | gesloten door %s</li>'; // %s = date, user making change
$hesklang['thist4']='<li class="smaller">%s | geopend door %s</li>'; // %s = date, user making change
$hesklang['thist5']='<li class="smaller">%s | geblokkeerd door %s</li>'; // %s = date, user making change
$hesklang['thist6']='<li class="smaller">%s | gedeblokkeerd door %s</li>'; // %s = date, user making change
$hesklang['thist7']='<li class="smaller">%s | ticket aangemaakt door %s</li>'; // %s = date, user making change
$hesklang['elocked']='Ticket geblokkeerd of verwijderd';
$hesklang['nti2']='Nieuw ticket toevoegen';
$hesklang['nti3']='Maak een nieuw ticket namens een klant.';
$hesklang['addop']='Optie';
$hesklang['seno']='Informeer de klant per e-mail';
$hesklang['otas']='Toon het ticket na verzending';
$hesklang['notn']='Notificaties';
$hesklang['nomw']='De helpdesk verstuurt een notificatie als:';
$hesklang['nwts']='Een nieuw ticket is verzonden met eigenaar:';
$hesklang['ncrt']='Een klant reageert op een ticket met eigenaar:';
$hesklang['ntam']='Een ticket aan mij is toegewezen';
$hesklang['npms']='Een bericht aan mij is verzonden';
$hesklang['support_remove']='<em>Mogelijk gemaakt door helpdesk Software HESK&trade;</em>';
$hesklang['ycvtao']='Geen toegang tot tickets toegewezen aan anderen';
$hesklang['password_not_valid']='Wachtwoordlengte is minimaal 5 karakters';
$hesklang['lkbs']='Bezig met laden van kennisbank...';
$hesklang['auto']='(automatisch)';

// Added in version 2.3
$hesklang['unknown']='Onbekend';
$hesklang['pcer']='De volgende fouten zijn opgetreden:';
$hesklang['seqid']='Ticketnummer';
$hesklang['close_action']='Markeer als opgelost'; // Close ACTION
$hesklang['archived']='Attentie';
$hesklang['archived2']='Gemarkeerd';
$hesklang['add_archive']='Ticket markeren';
$hesklang['add_archive_quick']='Geselecteerde tickets markeren';
$hesklang['remove_archive']='Markering ongedaan maken';
$hesklang['remove_archive_quick']='Markering ongedaan maken';
$hesklang['added_archive']='Ticket gemarkeerd';
$hesklang['removed_archive']='Ticket niet gemarkeerd';
$hesklang['added2archive']='Ticket is gemarkeerd';
$hesklang['removedfromarchive']='Ticket is niet meer gemarkeerd';
$hesklang['num_tickets_tag']='<strong>%d</strong> tickets zijn gemarkeerd';
$hesklang['num_tickets_untag']='<strong>%d</strong> tickets zijn niet meer gemarkeerd';
$hesklang['can_add_archive']='Kan gemarkeerde tickets verwijderen';
$hesklang['disp_only_archived']='Alleen gemarkeerde tickets';
$hesklang['search_only_archived']='Alleen gemarkeerde tickets';
$hesklang['critical']=' * Kritiek * ';
$hesklang['thist8']='<li class="smaller">%s | prioriteit gewijzigd naar %s door %s</li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class="smaller">%s | status gewijzigd naar %s door %s</li>'; // %s = date, new status, user making change
$hesklang['thist10']='<li class="smaller">%s | automatisch toegewezen aan %s</li>'; // %s = date, user making change
$hesklang['thist11']='<li class="smaller">%s | verzonden via e-mail piping</li>'; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']=' jr ';
$hesklang['abbr']['month']=' mnd ';
$hesklang['abbr']['week']=' wk ';
$hesklang['abbr']['day']=' dag ';
$hesklang['abbr']['hour']=' uur ';
$hesklang['abbr']['minute']=' min';
$hesklang['abbr']['second']=' sec';
// END abberviations
$hesklang['cnsm']='Bericht kan niet worden verzonden aan:';
$hesklang['yhbb']='Geen toegang gedurende %s minuten in verband met teveel foutieve aanmeldpogingen';
$hesklang['pwdst']='Wachtwoordsterkte';
$hesklang['tid_mail']='Voer je <strong>e-mailadres</strong> in en je ontvangt het tracking-ID';
$hesklang['rem_email']='E-mailadres onthouden';
$hesklang['eytid']='Voer tracking-ID in';
$hesklang['enmdb']='Dit e-mailadres hoort niet bij dit tracking-ID';
$hesklang['confemail']='E-mailadres bevestigen';
$hesklang['confemail2']='Vriendelijk verzoek het e-mailadres te bevestigen';
$hesklang['confemaile']='De ingevoerde e-mailadressen komen niet overeen';
$hesklang['taso3']='Toegewezen aan:';
$hesklang['sec_enter']='Type het nummer in de afbeelding hieronder';
$hesklang['reload']='Opnieuw laden';
$hesklang['verify_q']='Spampreventie:'; // For anti-spam question
$hesklang['verify_i']='Spampreventie:'; // For anti-spam image (captcha)
$hesklang['admin_login']='Administratiegedeelte';
$hesklang['vrfy']='Test geslaagd';
$hesklang['last_update']='Bijgewerkt';
$hesklang['cot']='Zet kritieke tickets niet bovenaan';
$hesklang['def']='Als standaardweergave instellen';
$hesklang['gbou']='Deze tickets zijn <strong>niet toegewezen</strong>:';
$hesklang['gbom']='Tickets toegewezen aan <strong>mij</strong>:';
$hesklang['gboo']='Tickets toegewezen aan <strong>%s</strong>:';
$hesklang['select']=' - Maak een keuze - ';
$hesklang['chngstatus']='Wijzig status naar';
$hesklang['perat']='%s van alle tickets'; // Will change to "23% of all tickets"
$hesklang['viewart']='Artikel tonen';
$hesklang['chdp']='Wijzig het standaardwachtwoord op de <a href="profile.php">profielpagina</a>';
$hesklang['chdp2']='Standaardwachtwoord wijzigen';
$hesklang['security']='Beveiliging';
$hesklang['kb_i_art']='Nieuw artikel';
$hesklang['kb_i_art2']='Artikel invoegen';
$hesklang['kb_i_cat']='Nieuwe categorie';
$hesklang['kb_i_cat2']='Categorie invoegen';
$hesklang['gopr']='Kennisbank bezoeken';
$hesklang['kbstruct']='Structuur';
$hesklang['cancel']='Annuleren';
$hesklang['sh']='Verbergen';
$hesklang['goodkb']='Hoe schrijf je een goed artikel?';
$hesklang['catset']='Instellingen categorie';
$hesklang['inpr']='Nieuwe prioriteit';
$hesklang['incat']='Nieuwe categorie';
$hesklang['instat']='Nieuwe status';
$hesklang['tsst']='Status is gewijzigd naar %s';
$hesklang['aass']='Automatisch toewijzen';
$hesklang['aaon']='Automatisch toewijzen ingeschakeld (klik om uit te schakelen)';
$hesklang['aaoff']='Automatisch toewijzen uitgeschakeld (klik om in te schakelen)';
$hesklang['uaaon']='Automatisch toewijzen ingeschakeld voor geselecteerde gebruiker';
$hesklang['uaaoff']='Automatisch toewijzen uitgeschakeld voor geselecteerde gebruiker';
$hesklang['taasy']='Dit ticket is automatisch toegewezen aan jou';
$hesklang['can_view_unassigned']='Kan tickets die niet zijn toegewezen zien';
$hesklang['ycovtay']='Je ziet alleen tickets die aan jou zijn toegewezen';
$hesklang['in_progress']='In behandeling';
$hesklang['on_hold']='In de wacht';
$hesklang['import_kb']='Importeren in Kennisbank';
$hesklang['import']='Je importeert een <em>privéticket</em> in een <em>openbaar artikel</em>.<br /><br /> Zorg dat geen vertrouwelijke informatie wordt opgeslagen!';
$hesklang['tab_1']='Algemeen';
$hesklang['tab_2']='Helpdesk';
$hesklang['tab_3']='Kennisbank';
$hesklang['tab_4']='Eigen velden';
$hesklang['tab_5']='Overige';
$hesklang['disable']='Uitschakelen';
$hesklang['dat']='Datum- en tijdinstellingen';
$hesklang['lgs']='Taal';
$hesklang['onc']='AAN - Klanten';
$hesklang['ons']='AAN - Allen';
$hesklang['viewvtic']='Voorwaarde inzien ticket(s)';
$hesklang['reqetv']='E-mail verplicht om ticket te zien';
$hesklang['banlim']='Max aantal inlogpogingen';
$hesklang['banmin']='Blokkeertijd inloggen';
$hesklang['subnot']='Melding bij verzenden';
$hesklang['subnot2']='Toon melding aan klanten die tickets verzenden';
$hesklang['eseqid']='Opeenvolgende ID\'s';
$hesklang['sconfe']='E-mailadres bevestigen';
$hesklang['saass']='Tickets automatisch toewijzen';
$hesklang['swyse']='WYSIWYG editor';
$hesklang['hrts']='Beoordeel helpdesk';
$hesklang['hrts2']='Toon beoordeel-link in administratiegedeelte';
$hesklang['emlpipe']='E-mail piping';
$hesklang['emlsend2']='Verzendwijze e-mail';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='SMTP Server';
$hesklang['smtph']='SMTP Host';
$hesklang['smtpp']='SMTP Poort';
$hesklang['smtpu']='SMTP Gebruikersnaam';
$hesklang['smtpw']='SMTP Wachtwoord';
$hesklang['smtpt']='SMTP Timeout';
$hesklang['other']='Overige instellingen';
$hesklang['features']='Opties';
$hesklang['can_view_online']='Kan online beheerders zien';
$hesklang['online']='Online';
$hesklang['offline']='Offline';
$hesklang['onlinep']='Gebruikers online'; // For display in footer
$hesklang['sonline']='Gebruikers online'; // For settings page
$hesklang['sonline2']='Gebruikers online limiet (in minuten):'; // For settings page
$hesklang['gb']='Groeperen bij';
$hesklang['dg']='Niet groeperen';
$hesklang['err_dpi']='De database %s dbevat niet alle tabellen met voorvoegsel %s - wijzigingen niet opgeslagen';
$hesklang['err_dpi2']='Tabellen niet gevonden in database';
$hesklang['sme']='SMTP-fout';
$hesklang['scl']='Log SMTP-verbinding';
$hesklang['dnl']='Download';
$hesklang['dela']='Bijlage verwijderen';
$hesklang['pda']='Deze bijlage definitief en onherroepelijk verwijderen?';
$hesklang['thist12']='<li class="smaller">%s | bijlage %s verwijderd door %s</li>'; // %s = date, deleted attachment, user making change
$hesklang['mopt']='Meer opties';
$hesklang['lopt']='Minder opties';
$hesklang['meml']='Meer e-mailadressen';
$hesklang['meml2']='Meer e-mailadressen toestaan';

// Added in version 2.4
$hesklang['catd']='(categorie verwijderd)';
$hesklang['noopen']='Geen openstaande tickets voor dit adres';
$hesklang['maxopen']='Maximum aantal open tickets bereikt (%d van %d). Zorg dat tickets worden afgehandeld voordat nieuwe tickets worden geopend.';
$hesklang['ntnote']='Er is een notitie toegevoegd aan een toegewezen ticket.';
$hesklang['cat_public']='Deze categorie is openbaar (klik om af te schermen).';
$hesklang['cat_private']='Deze categorie is afgeschermd (klik om openbaar te maken).';
$hesklang['cat_aa']='Tickets in deze categorie automatisch toewijzen.';
$hesklang['cat_type']='Categorie afschermen (alleen zichtbaar voor beheerders)';
$hesklang['caaon']='Automatisch toewijzen geactiveerd voor deze categorie.';
$hesklang['caaoff']='Automatisch toewijzen gedeactiveerd voor deze categorie.';
$hesklang['cpub']='Categorie gewijzigd naar openbaar.';
$hesklang['cpriv']='Categorie gewijzigd naar afgeschermd.';
$hesklang['cpric']='Gebruikers kunnen afgeschermde categorieën niet selecteren, alleen beheerders.';
$hesklang['user_aa']='Automatisch toewijzen aan deze gebruiker.';
$hesklang['attach_size']='Maximale bestandsgrootte';
$hesklang['B']='B';
$hesklang['kB']='kB';
$hesklang['MB']='MB';
$hesklang['GB']='GB';
$hesklang['bytes']='bytes';
$hesklang['kilobytes']='kilobytes';
$hesklang['megabytes']='megabytes';
$hesklang['gigabytes']='gigabytes';
$hesklang['smtpssl']='SSL-Protocol';
$hesklang['smtptls']='TLS-Protocol';
$hesklang['oo']='Alleen status \'open\'';
$hesklang['ool']='Alleen tickets met status \'open\' tonen in e-mail';
$hesklang['mop']='Maximum open tickets';
$hesklang['rord']='Volgorde reacties';
$hesklang['newbot']='Nieuwste reactie onderaan';
$hesklang['newtop']='Nieuwste reactie bovenaan';
$hesklang['ford']='Reactieformulier';
$hesklang['formbot']='Formulier onderaan tonen';
$hesklang['formtop']='Formulier bovenaan tonen';
$hesklang['mysqlv']='MySQL-versie';
$hesklang['phpv']='PHP-versie';
$hesklang['csrt']='Servertijd:';
$hesklang['listp']='Toon afgeschermde artikelen';
$hesklang['listd']='Toon ongepubliceerde artikelen';
$hesklang['artp']='Afgeschermde artikelen';
$hesklang['artd']='Ongepubliceerde artikelen';
$hesklang['kb_no_part']='Geen afgeschermde artikelen in kennisbank';
$hesklang['kb_no_dart']='Geen ongepubliceerde artikelen in kennisbank';
$hesklang['attpri']='Geen toegang tot deze bijlage';
$hesklang['can_merge_tickets']='Tickets samenvoegen';
$hesklang['mer_selected']='Geselecteerde tickets samenvoegen';
$hesklang['merged']='Geselecteerde tickets zijn samengevoegd';
$hesklang['merge_err']='Fout bij samenvoegen:';
$hesklang['merr1']='selecteer minimaal twee tickets';
$hesklang['merr2']='ticket niet gevonden';
$hesklang['merr3']='ticket in ontoegankelijke categorie';
$hesklang['tme']='Ticket %s is samengevoegd met dit ticket (%s)';
$hesklang['tme1']='Ticket %s is samengevoegd met ticket %s';
$hesklang['tme2']='Voer het e-mailadres in dat hoort bij ticket %s';
$hesklang['eyou']='Wijzig instellingen bij Profiel';
$hesklang['npea']='Geen rechten om deze gebruiker te bewerken';
$hesklang['duplicate_user']='Deze gebruikersnaam bestaat reeds, kies een andere';
$hesklang['kw']='Trefwoorden';
$hesklang['kw1']='(optioneel - gescheiden door spatie, komma of nieuwe regel)';
$hesklang['type_not_allowed']='Bestanden eindigend op <strong>%s</strong> zijn niet toegestaan (%s)'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='Gebruiker heeft deze reactie nog niet gelezen';
$hesklang['sticky']='Zet dit artikel op \'Speciaal\'';
$hesklang['stickyon']='Wijzig artikel naar \'Speciaal\'';
$hesklang['stickyoff']='Wijzig artikel naar \'Normaal\'';
$hesklang['ason']='Artikel gemarkeerd als \'Speciaal\'';
$hesklang['asoff']='Artikel gemarkeerd als \'Normaal\'';
$hesklang['ts']='Werktijd bijhouden';
$hesklang['start']='Start / Stop';
$hesklang['reset']='Herstellen';
$hesklang['save']='Opslaan';
$hesklang['hh']='Uren';
$hesklang['mm']='Minuten';
$hesklang['ss']='Seconden';
$hesklang['thist']='Ticketgeschiedenis';
$hesklang['thist13']='<li class="smaller">%s | samengevoegd met ticket %s door %s</li>'; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class="smaller">%s | bestede tijd ingesteld op %s door %s</li>'; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class="smaller">%s | verzonden door %s</li>'; // %s = date, user making change
$hesklang['thist16']='<li class="smaller">%s | verzonden door POP3 fetching</li>';
$hesklang['twu']='Werktijd aangepast';
$hesklang['autoss']='Start een timer bij het openen van een ticket';
$hesklang['ful']='Bestandupload beperkingen';
$hesklang['ufl']='Toegestane bestandstypen: ';
$hesklang['nat']='Maximaal aantal bijlagen:';
$hesklang['mfs']='Maximale bestandsgrootte per bijlage:';
$hesklang['lps']='Taalinstellingen opgeslagen';
$hesklang['sav']='Toon artikelweergaven';
$hesklang['sad']='Toon datum bij artikelen';
$hesklang['emp']='De PHP-installatie ondersteunt geen MySQL (mysqli-extensie vereist)';
$hesklang['epd']='[HESK] EMAIL PIPING is gedeactiveerd bij Instellingen';
$hesklang['pfd']='[HESK] POP3 FETCHING is gedeactiveerd bij Instellingen';
$hesklang['pem']='[Piped email helpdesk]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Klant]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='E-mailadres';
$hesklang['pop3']='POP3 Fetching';
$hesklang['pop3h']='POP3 Host';
$hesklang['pop3p']='POP3 Port';
$hesklang['pop3tls']='TLS Protocol';
$hesklang['pop3u']='POP3 gebruikersnaam';
$hesklang['pop3w']='POP3 wachtwoord';
$hesklang['pop3e']='POP3 error';
$hesklang['pop3log']='POP3 log';
$hesklang['mysqltest']='Test MySQL connectie';
$hesklang['smtptest']='Test SMTP connectie';
$hesklang['pop3test']='Test POP3 connectie';
$hesklang['contest']='Connectie testen... Even geduld...';
$hesklang['conok']='Connectie succesvol';
$hesklang['conokn']='Indien gebruikersnaam/wachtwoordcombinatie verplicht zijn, wordt geen e-mail verzonden';
$hesklang['saving']='Bezig met opslaan...';
$hesklang['sns']='Instellingen opgeslagen, niet alle functies geactiveerd';
$hesklang['looph']='Max aantal e-mails';
$hesklang['loopt']='Tijdsbestek';
$hesklang['didum']='Suggestie: %s?'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Ja, aanpassen';
$hesklang['nole']='Nee, niet aanpassen';
$hesklang['sconfe2']='Veld \'e-mailadres bevestigen\' tonen bij verzenden van een ticket';
$hesklang['oln']='Oude naam:';
$hesklang['nen']='Nieuwe naam:';
$hesklang['use_form_below']='<em>Gebruik dit formulier voor het verzenden van een ticket. Verplichte velden zijn gemarkeerd met</em> ';
$hesklang['esf']='E-mailnotificatie kan niet verzonden worden';
$hesklang['qrr']='(aangehaalde reactie verwijderd)';
$hesklang['remqr']='Geciteerde reacties verwijderen';
$hesklang['remqr2']='Aangehaalde reacties verwijderen uit e-mail van gebruiker';
$hesklang['suge']='Typfouten in e-mailadressen detecteren';
$hesklang['epro']='E-mailproviders';
$hesklang['email_noreply']='\'Van:\' e-mail';
$hesklang['email_name']='\'Van:\' naam';
$hesklang['vscl']='Limieten serverconfiguratie';
$hesklang['fnuscphp']='Bestand uploaden mislukt, probeer kleinere of geen bijlage';
$hesklang['redv']='standaardweergave herstellen';
$hesklang['fatte1']='De instelling \'Aantal bijlagen\' is groter dan de server toestaat';
$hesklang['fatte2']='De maximale bestandsgrootte is groter dan de server toestaat';
$hesklang['fatte3']='De server staat zoveel bestanden of zulke grote bestanden niet toe';
$hesklang['embed']='Ingevoegde bestanden';
$hesklang['embed2']='Sla ingevoegde bestanden op als bijlagen';
$hesklang['emrem']='(afbeelding verwijderd)';
$hesklang['hdemo']='(VERBORGEN IN DEMO)';
$hesklang['ddemo']='Deze functie is verborgen in de demo';
$hesklang['sdemo']='Opslaan is uitgeschakeld in de demo';
$hesklang['hud']='up-to-date';
$hesklang['hnw']='Update beschikbaar';
$hesklang['getup']='Update HESK';
$hesklang['updates']='Updates';
$hesklang['updates2']='Automatisch controleren op updates';

// Added in version 2.5.0
$hesklang['attdel']='Dit bestand is verwijderd van de server en niet meer beschikbaar';
$hesklang['dsen']='Stuur geen e-mailnotificatie over deze reactie naar de gebruiker';
$hesklang['attrem']='* Enkele bijlagen zijn verwijderd *';
$hesklang['attnum']='Maximum aantal bereikt:  %s'; // %s will show attachment name
$hesklang['attsiz']='Bestand te groot: %s'; // %s will show attachment name
$hesklang['atttyp']='Bestandstype niet toegestaan: %s'; // %s will show attachment name
$hesklang['adf']='Map beheer';
$hesklang['atf']='Map bijlagen';
$hesklang['err_adf']='De geselecteerde map (%s) bestaat niet'; // %s will show folder name
$hesklang['err_atf']='De map voor bijlagen (%s) bestaat niet'; // %s will show folder name
$hesklang['err_atr']='De map voor bijlagen (%s) is niet schrijfbaar'; // %s will show folder name
$hesklang['fatt']='Bestanden bij dit bericht:';
$hesklang['wrepo']='Voer een reactie in na heropenen van het ticket';
$hesklang['ktool']='&raquo; Kennisbankgereedschappen';
$hesklang['uac']='Controleer het aantal artikelen in de categorie';
$hesklang['acv']='Aantal artikelen is gecontroleerd';
$hesklang['xyz']='aantal openbare, afgeschermde en concept artikelen in de categorie';
$hesklang['reports_tab']='Rapportage'; // Tab title
$hesklang['can_run_reports_full']='Kan rapportages maken (alle)';
$hesklang['can_export']='Kan tickets exporteren';
$hesklang['roo']='<em>(alleen aan jou toegewezen tickets worden gerapporteerd)</em>';
$hesklang['shu']='Korte links';
$hesklang['export']='Exporteer tickets'; // Tab title
$hesklang['export_btn']='Exporteer tickets'; // Button title
$hesklang['export_intro']='Hiermee kunnen tickets worden geëxporteerd naar een XML-spreadsheet en kunnen bijvoorbeeld in Excel worden geopend.';
$hesklang['stte']='Selecteer te exporteren tickets';
$hesklang['dtrg']='Datumbereik';
$hesklang['sequentially']='Op volgorde'; // Order tickets: Sequentially
$hesklang['ede']='Kan exportmap niet maken, maak handmatig een schrijfbare map <strong>"export"</strong> in de map voor bijlagen';
$hesklang['eef']='Kan exportbestand niet maken, geen schrijfrechten op betreffende map';
$hesklang['inite']='Bezig met voorbereiden...';
$hesklang['gXML']='Bezig met genereren van XML-bestand...';
$hesklang['nrow']='Aantal rijen: %d'; // %d will show number of rows exported
$hesklang['cZIP']='Bezig met comprimeren in ZIP-bestand...';
$hesklang['eZIP']='Fout bij maken van ZIP-bestand';
$hesklang['fZIP']='Gereed met maken van ZIP-bestand';
$hesklang['pmem']='Piek geheugengebruik: %.2f Mb'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo; Klik hier om het bestand te downloaden &laquo;';
$hesklang['n2ex']='Geen tickets gevonden, niets om te exporteren';
$hesklang['sp']='SPAM-preventie'; // For settings page
$hesklang['sit']='Type afbeelding';
$hesklang['sis']='Simpele afbeelding';
$hesklang['rcpb']='Site key (Public key)';
$hesklang['rcpv']='Secret key (Private key)';
$hesklang['pop3keep']='Bewaar een kopie';
$hesklang['beta']='(TESTVERSIE)';
$hesklang['maxpost']='Mogelijk meer data verzonden dan de server kan verwerken.<br /><br />Verzend opnieuw met minder of kleinere bijlagen.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='Fout! Probeer het nogmaals';

// Added in version 2.6.0
$hesklang['ticket_closed']='Ticket [#%%TRACK_ID%%] is gesloten/opgelost';
$hesklang['ms01']='jan';
$hesklang['ms02']='feb';
$hesklang['ms03']='ma';
$hesklang['ms04']='apr';
$hesklang['ms05']='mei';
$hesklang['ms06']='jun';
$hesklang['ms07']='jul';
$hesklang['ms08']='aug';
$hesklang['ms09']='sep';
$hesklang['ms10']='okt';
$hesklang['ms11']='nov';
$hesklang['ms12']='dec';
$hesklang['sdf']='Verstuurd datumformaat';
$hesklang['lcf']='Aangepast datumformaat';
$hesklang['lcf0']='Korte omschrijving';
$hesklang['lcf1']='Datum en tijd';
$hesklang['lcf2']='HESK style';
$hesklang['ticket_tpl']='tickettemplates';
$hesklang['can_man_ticket_tpl']='Tickettemplates aanpassen'; // Permission title
$hesklang['ticket_tpl_man']='Tickettemplates aanpassen'; // Page and link title
$hesklang['ticket_tpl_intro']='Maak en bewerk tickettemplates die je kunt gebruiken voor snelle beantwoording van nieuwe tickets in het admingedeelte.';
$hesklang['no_ticket_tpl']='Geen tickettemplates';
$hesklang['ticket_tpl_title']='Titel';
$hesklang['delete_tpl']='Weer je zeker dat je dit template wilt verwijderen?';
$hesklang['new_ticket_tpl']='Maak of bewerk een tickettemplate';
$hesklang['ticket_tpl_add']='Maak een tickettemplate';
$hesklang['ticket_tpl_edit']='Bewerk de geselecteerde tickettemplate';
$hesklang['save_ticket_tpl']='tickettemplate opslaan';
$hesklang['ticket_tpl_saved']='Je tickettemplate in opgeslagen voor later gebruik';
$hesklang['ticket_tpl_removed']='De geselecteerde tickettemplate is verwijderd uit de database';
$hesklang['ticket_tpl_not_found']='De tickettemplate is niet gevonden';
$hesklang['sel_ticket_tpl']='Selecteer de tickettemplate die je wilt verwijderen';
$hesklang['ent_ticket_tpl_title']='Vul een templatetitel in';
$hesklang['ent_ticket_tpl_msg']='Vul een templatetekst in';
$hesklang['ticket_tpl_id']='tickettemplate ID is niet gevonden';
$hesklang['select_ticket_tpl']='Selecteer een tickettemplate';
$hesklang['list_tickets_cat']='Toon alle tickets in deze categorie';
$hesklang['def_msg']='[No message]';
$hesklang['emlreqmsg']='Berichtinhoud vereist';
$hesklang['emlreqmsg2']='Negeer piped/fetched e-mailberichten zonder tekst';
$hesklang['relart']='Gerelateerde artikelen'; // Title of related articles box
$hesklang['s_relart']='Gerelateerde artikelen'; // On settings page
$hesklang['tab_7']='Ticketlijst';
$hesklang['fitl']='Velden in ticketlijst';
$hesklang['submitted']='Verstuurd';
$hesklang['clickemail']='Bekijken';
$hesklang['set_pri_to']='Zet prioriteit op:'; // Action below the ticket list
$hesklang['pri_set_to']='Prioriteit is aangepast naar:';
$hesklang['cat_pri']='Deze categorie wordt gebruikt als klanten geen rechten hebben om een prioriteit te kiezen.';
$hesklang['cat_pri_info']='Je klanten mogen een prioriteit kiezen. De categorieprioriteit wordt dus genegeerd.<br /><br />Als je de categorieprioriteit wilt gebruiken, schakel dan de volgende optie uit bij instellingen';
$hesklang['def_pri']='Categorieprioriteit:';
$hesklang['ch_cat_pri']='Categorieprioriteit instellen';
$hesklang['cat_pri_ch']='Categorieprioriteit in ingesteld op:';
$hesklang['err_dbversion']='Te oude MySQL versie:';
$hesklang['ip_whois']='IP whois';
$hesklang['ednote']='Bewerk je opmerking';
$hesklang['ednote2']='Opmerking is opgeslagen';
$hesklang['perm_deny']='Toegang geweigerd';
$hesklang['mis_note']='Ontbrekende opmerking ID';
$hesklang['no_note']='Opmerking met dit ID is niet gevonden';
$hesklang['sacl']='Opslaan en later verder gaan';
$hesklang['reply_saved']='Je reactie is opgeslagen voor later.';
$hesklang['submit_as']='Verstuur als:';
$hesklang['sasc']='Verstuur een klantreactie';
$hesklang['creb']='Klantreactie door:';
$hesklang['show_select']='\'Selecteer\' als default optie';
// Settings
$hesklang['mms']='Onderhoudsmodus';
$hesklang['mmd']='Onderhoudsmodus inschakelen';
// Customer notice
$hesklang['mm1']='Tijdelijk onderhoud';
$hesklang['mm2']='Onze helpdesk is wegens onderhoud tijdelijk gesloten.';
$hesklang['mm3']='Excuus voor het ongemak, probeer het later opnieuw.';
// Staff notice
$hesklang['mma1']='Onderhoudsmodus is actief!';
$hesklang['mma2']='Klanten kunnen de helpdesk niet gebruiken.';
$hesklang['tools']='Tools';
$hesklang['banemail']='Geblokkeerde e-mailadressen';
$hesklang['banemail_intro']='E-mailadressen blokkeren.';
$hesklang['no_banemails']='<em>Er zijn geen e-mailadressen geblokkeerd.</em>';
$hesklang['eperm']='Permanente e-mail blokkeringen:';
$hesklang['bananemail']='Te blokkeren e-mailadres';
$hesklang['savebanemail']='Blokkeer dit e-mailadres';
$hesklang['enterbanemail']='Vul het e-mailadres in dat je wenst te blokkeren.';
$hesklang['validbanemail']='Vul een geldig e-mailadres in (<em>naam@domein.nl</em>) of e-maildomeinnaam (<em>@domein.nl</em>)';
$hesklang['email_banned']='Het e-mailadres <em>%s</em> is geblokkeerd.'; // %s will be replaced with email
$hesklang['emailbanexists']='Het e-mailadres <em>%s</em> was reeds geblokkeerd.'; // %s will be replaced with email
$hesklang['email_unbanned']='Geblokkeerde e-mailadres is verwijderd';
$hesklang['banby']='Geblokkeerd door';
$hesklang['delban']='Verwijder blokkade';
$hesklang['delban_confirm']='Wil je deze blokkade verwijderen?';
$hesklang['baned_e']='Je bent geblokkeerd en kunt geen meldingen indienen.';
$hesklang['baned_ip']='Je bent geblokeerd en hebt geen toegang tot onze helpdesk';
$hesklang['can_ban_emails']='Kan e-mailadressen blokkeren';
$hesklang['can_unban_emails']='Kan e-mailadressen deblokkeren';
$hesklang['eisban']='Dit e-mailadres is geblokkeerd.';
$hesklang['click_unban']='Klik hier om te deblokkeren.';
$hesklang['banip']='Geblokkeerde IP-adressen';
$hesklang['banip_intro']='Bezoekers met een geblokkeerd IP-adres kunnen geen tickets zien.';
$hesklang['ipperm']='Permanente IP-blokkeringen:';
$hesklang['iptemp']='Geblokkeerd na verkeerd inloggen:';
$hesklang['savebanip']='Blokkeer dit IP-adres';
$hesklang['no_banips']='<em>Er zijn geen IP-adressen geblokkeerd.</em>';
$hesklang['bananip']='Te blokkeren IP-adressen';
$hesklang['banex']='Voorbeelden:';
$hesklang['iprange']='IP-reeks';
$hesklang['ippermban']='Blokkeer dit IP-adres permanent';
$hesklang['enterbanip']='Geef het IP-adres of de range op die je wilt blokkeren.';
$hesklang['validbanip']='Geef een geldig IP-adres og IP-reeks op';
$hesklang['ip_banned']='Het IP-adres <em>%s</em> is geblokeerd en HESK zal geen tickets meer accepteren van dit IP-adres.'; // %s will be replaced with IP
$hesklang['ip_rbanned']='Het IP-adres <em>%s</em> is geblokeerd en HESK zal geen tickets meer accepteren van deze IP-reeks.'; // %s will be replaced with IP
$hesklang['ipbanexists']='Het IP-adres <em>%s</em> is reeds geblokkeerd.'; // %s will be replaced with IP
$hesklang['iprbanexists']='De IP-reeks <em>%s</em> is reeds geblokkeerd.'; // %s will be replaced with IP
$hesklang['ip_unbanned']='IP-blokkade verwijderd';
$hesklang['ip_tempun']='Tijdelijke IP-blokkade verwijderd';
$hesklang['can_ban_ips']='Kan IP-adressen blokkeren';
$hesklang['can_unban_ips']='Kan IP-adressen deblokkeren';
$hesklang['ipisban']='Dit IP-adres is geblokkeerd.';
$hesklang['m2e']='Verloopt over (minutes)';
$hesklang['info']='Info';
$hesklang['sm_title']='Serviceberichten';
$hesklang['sm_intro']='Toon een servicebericht in het klantengedeelte voor bijvoorbeeld het doorgeven van een belangrijke mededeling.';
$hesklang['can_service_msg']='Servicebericht bewerken';
$hesklang['new_sm']='Nieuw servicebericht';
$hesklang['edit_sm']='Servicebericht bewerken';
$hesklang['ex_sm']='Bestaande serviceberichten';
$hesklang['sm_author']='Auteur';
$hesklang['sm_type']='Type';
$hesklang['sm_published']='Gepubliceerd';
$hesklang['sm_draft']='Ontwerp';
$hesklang['sm_style']='Style';
$hesklang['sm_none']='None';
$hesklang['sm_success']='Succes';
$hesklang['sm_info']='Info';
$hesklang['sm_notice']='Bericht';
$hesklang['sm_error']='Fout';
$hesklang['sm_save']='Servicebericht opslaan';
$hesklang['sm_preview']='Voorvertoning servicebericht';
$hesklang['sm_mtitle']='Titel';
$hesklang['sm_msg']='Bericht';
$hesklang['sm_e_title']='Vul een titel in voor het servicebericht';
$hesklang['sm_e_msg']='Vul een servicebericht in';
$hesklang['sm_e_id']='Servicebericht-ID bestaat niet';
$hesklang['sm_added']='Er is een nieuw servicebericht toegevoegd';
$hesklang['sm_deleted']='Servicebericht verwijderd';
$hesklang['sm_not_found']='Dit servicebericht bestaat niet';
$hesklang['no_sm']='Geen serviceberichten';
$hesklang['del_sm']='Wil je dit servicebericht verwijderen?';
$hesklang['sm_mdf']='Servicebericht is opgeslagen';
$hesklang['sska']='Toon aanbevolen artikelen';
$hesklang['taws']='Deze artikelen zijn aanbevolen:';
$hesklang['defaults']='Standaardwaarden';
$hesklang['pncn']='Toon de optie "Stuur een bericht aan de klant" bij een nieuwe ticket';
$hesklang['pncr']='Toon de optie "Stuur een bericht aan de kant" bij het antwoordformulier';
$hesklang['pssy']='Toon de aanbevolen kennisbank-artikelen aan de klanten';
$hesklang['ccct']='Klantoplossing toestaan';
$hesklang['custnot']='E-mailnotificaties versturen';
$hesklang['notnew']='Als er een nieuwe supportticket is ingediend';
$hesklang['notclo']='Als er een supportticket is opgelost';
$hesklang['enn']='Accepteer e-mail piping/POP3 fetching als het onderwerp deze tekst bevat:';
$hesklang['spamn']='SPAM-melding';
$hesklang['spam_inbox']='<span style=""><strong>Geen bevestigingse-mail ontvangen?</strong><br />We hebben een bevestigingsmail naar je e-mailadres gestuurd. Als je deze niet binnen 10 minuten ontvangen hebt, controleer dan je spammap (ongewenste e-mail).</span>';
$hesklang['ekb_n']='<strong>NEE</strong>, kennisbank uitschakelen';
$hesklang['ekb_y']='<strong>JA</strong>, kennisbank inschakelen';
$hesklang['ekb_o']='<strong>JA</strong>, gebruik alleen de kennisbank (<em>schakelt helpdesk uit</em>)';
$hesklang['kb_set']='Instellingen kennisbank';
$hesklang['kbo1']='Alleen kennisbank-modes';
$hesklang['kbo2']='<br /><br />Bezoekers kunnen geen melding aanmaken en gaan direct naar de kennisbank-pagina.';
$hesklang['fpass']='Wachtwoord vergeten?';
$hesklang['passr']='Wachtwoord resetten';
$hesklang['passa']='Gebruikers mogen hun wachtwoord resetten';
$hesklang['passe']='Vul je e-mailadres in';
$hesklang['passs']='Stuur mij een link om mijn wachtwoord aan te passen';
$hesklang['noace']='Er is geen account gevonden met het opgegeven e-mailadres';
$hesklang['pemls']='Wij sturen je een e-mail met instructies over hoe je je wachtwoord kunt aanpassen';
$hesklang['reset_password']='Wijzig je wachtwoord voor de helpdesk'; // Email subject
$hesklang['ehash']='Ongeldige of verlopen wachtwoordresetlink';
$hesklang['ehaip']='Verkeerd IP-adres. Het wachtwoord mag alleen aangepast worden vanaf het IP-adres waarvan de aanvraag is gedaan.';
$hesklang['resim']='<strong>Pas je wachtwoord aan!</strong>';
$hesklang['permissions']='Rechten';
$hesklang['atype']='Account type';
$hesklang['astaff']='Medewerkers';
$hesklang['oon1']='Stuur mij alleen tickets met de status \'open\'';
$hesklang['oon2']='Stuur mij alle tickets';
$hesklang['anyown']='Alle eigenaars';
$hesklang['pfr']='Een andere POP3 fetching taak is bezig.';
$hesklang['pjt']='Taak timeout';
$hesklang['pjt2']='minuten na het starten';
$hesklang['nkba']='De kennisbank moet voldoende artikelen bevatten om goed te functioneren.';
$hesklang['saa']='Sticky atikelen worden bovenaan de resultaten getoond';
$hesklang['yhbr']='Je bent voor %s minuten geblokkeerd omdat je te veel reacties hebt gegeven binnen een bepaalde tijd.';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='nl';

// Added in version 2.7.0
$hesklang['imap']='IMAP-mail ophalen';
$hesklang['imaph']='IMAP-host';
$hesklang['imapp']='IMAP-poort';
$hesklang['enc']='Encryptie';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='Geen';
$hesklang['imapu']='IMAP gebruikersnaam';
$hesklang['imapw']='IMAP wachtwoord';
$hesklang['imaptest']='Test IMAP-verbinding';
$hesklang['ifd']='IMAP MAIL OPHALEN IS GEDEACTIVEERD BIJ INSTELLINGEN';
$hesklang['iei']='[HESK] PHP IMAP-extensie is niet geïnstalleerd.';
$hesklang['ifr']='Een andere IMAP-ophaaltaak is nog in behandeling.';
$hesklang['arp']='Ticketlijst automatisch herladen';
$hesklang['arpp']='Tijdsinterval om ticketlijst automatisch te herladen:';
$hesklang['seconds']='seconden';
$hesklang['minutes']='minuten';
$hesklang['atbr']='Dit ticket moet worden toegewezen voordat het kan worden beantwoord.';
$hesklang['attm']='Ticket aan mijzelf toewijzen';
$hesklang['owneed']='Eigenaar noodzakelijk';
$hesklang['taat']='Dit ticket is reeds toegewezen aan <strong>%s</strong>.';
$hesklang['scoy']='Ticket toewijzen aan jezelf?';
$hesklang['scot']='Ticket toewijzen aan %s?';
$hesklang['ycto']='JA, eigenaar wijzigen';
$hesklang['ncto']='NEE, eigenaar niet wijzigen';
$hesklang['fass']='Ticketeigenaar vereist';
$hesklang['req_sub']='Onderwerp verplicht';
$hesklang['req_msg']='Verplicht bericht';
$hesklang['req_email']='E-mail vereist';
$hesklang['default_subject']='Ticket van %s';
$hesklang['off-hide']='Verbergen in klantenformulier';
$hesklang['not_valid_email']='Voer een geldig e-mailadres in of laat het veld leeg';
$hesklang['write_down']='<span style="color:red">Bewaar het ticket-ID voor toekomstig gebruik.</span>';
$hesklang['re_confirm1']='Deactiveren deactiveert ook "Verplicht e-mailadres om tickets in te zien" onder "Beveiliging" - Doorgaan?';
$hesklang['re_confirm2']='Activeren activeert ook "Verplicht e-mailadres om tickets in te zien" onder "Beveiliging" - Doorgaan?';
$hesklang['can_email_tpl']='E-mailsjablonen wijzigen';
$hesklang['et_title']='E-mailsjablonen';
$hesklang['et_intro']='Wijzig e-mailberichten die worden verzonden naar beheerders en klanten';
$hesklang['file']='Bestand';
$hesklang['efile']='Bestand bewerken';
$hesklang['rdesc']='(Ontvanger) Omschrijving';
$hesklang['desc_forgot_ticket_id']='(Klant) Ticket-ID vergeten';
$hesklang['desc_new_reply_by_staff']='(Klant) Nieuwe reactie door beheerder';
$hesklang['desc_new_ticket']='(Klant) Ticket ontvangen';
$hesklang['desc_ticket_closed']='(Klant) Ticket opgelost/gesloten';
$hesklang['desc_category_moved']='(Beheerder) Ticket verplaatst naar andere categorie';
$hesklang['desc_new_reply_by_customer']='(Beheerder) Nieuwe reactie klant';
$hesklang['desc_new_ticket_staff']='(Beheerder) Nieuw ticket ontvangen';
$hesklang['desc_ticket_assigned_to_you']='(Beheerder) Een ticket is toegewezen';
$hesklang['desc_new_pm']='(Beheerder) Nieuw privébericht';
$hesklang['desc_new_note']='(Beheerder) Een nieuwe notitie bij een ticket is toegewezen';
$hesklang['desc_reset_password']='(Beheerder) Wachtwoord wijzigen';
$hesklang['etfm']='Een of meer e-mailsjablonen ontbreken.<br /><br />Zorg dat alle bestanden zijn geüpload naar de map <em>/language/%s/emails</em>.';
$hesklang['etfw']='Een of meer e-mailsjablonen zijn niet schrijfbaar.<br /><br />Wijzig de rechten naar 666 (rw-rw-rw) op alle bestanden in de map <em>/language/%s/emails</em>.';
$hesklang['et_e_id']='Ontbrekende sjabloon-ID';
$hesklang['et_fm']='Het bestand voor dit e-mailsjabloon ontbreekt';
$hesklang['et_fw']='Het bestand voor dit e-mailsjabloon in niet schrijfbaar';
$hesklang['et_save']='E-mailsjabloon opslaan';
$hesklang['updated_on']='Bijgewerkt op';
$hesklang['ticket_url']='URL van het ticket';
$hesklang['pm_url']='URL van het privébericht';
$hesklang['et_num']='Aantal tickets';
$hesklang['et_list']='Ticketlijst';
$hesklang['et_empty']='E-mailsjabloon kan niet leeg zijn';
$hesklang['et_saved']='E-mailsjabloon opgeslagen';
$hesklang['source']='Bron';
$hesklang['select_category']='Selecteer een categorie';
$hesklang['select_category_text']='Hulp nodig?';
$hesklang['select_category_staff']='Selecteer een ticketcategorie';
$hesklang['scat']='Limiet categorieselectie';
$hesklang['scat2']='(een selectiebox wordt getoond wanneer het aantal categorieën hoger is)';
$hesklang['new_cf']='Nieuw aangepast veld';
$hesklang['cf_intro']='Gebruik deze functionaliteit om aangepaste velden aan het formulier toe te voegen om extra informatie van gebruikers te ontvangen.';
$hesklang['cf_public']='Openbaar';
$hesklang['cf_private']='Alleen beheerders';
$hesklang['cf_cust']='Voor gebruikers';
$hesklang['cf_all']='Alle';
$hesklang['cf_cat']='Geselecteerd';
$hesklang['cf_ctrl']='Tip: gebruik de CTRL-toets om meerdere categorieën te selecteren';
$hesklang['visibility']='Zichtbaarheid';
$hesklang['cf_save']='Aangepast veld opslaan';
$hesklang['ex_cf']='Aangepaste velden activeren';
$hesklang['no_cf']='Geen actieve aangepaste velden';
$hesklang['del_cf']='Aangepast veld verwijderen? Hiermee worden de gegevens van dit veld verwijderd uit de database!';
$hesklang['cf_e_id']='Ongeldige ID';
$hesklang['edit_cf']='Aangepast veld wijzigen';
$hesklang['cf_deleted']='Aangepast veld verwijderd';
$hesklang['cf_not_found']='Dit aangepaste veld bestaat niet';
$hesklang['cf_added']='Nieuw aangepast veld toegevoegd';
$hesklang['cf_nocat']='Selecteer minimaal één categorie voor het aangepaste veld';
$hesklang['cf_mdf']='Aangepast veld opgeslagen';
$hesklang['atl1']='Selecteer minimaal één optie';
$hesklang['sch']='Verborgen';
$hesklang['meml3']='Meerdere e-mailadressen toestaan';
$hesklang['dmin']='Minimaal geaccepteerde datum';
$hesklang['dmax']='Maximaal geaccepteerde datum';
$hesklang['d_day']='dag(en)';
$hesklang['d_week']='we(e)k(en)';
$hesklang['d_month']='maand(en)';
$hesklang['d_year']='ja(a)r(en)';
$hesklang['d_any']='Elke datum';
$hesklang['d_fixed']='Vaste datum';
$hesklang['d_relative']='Relatieve datum';
$hesklang['d_mm']='Minimale datum kan niet hoger zijn dan maximale datum';
$hesklang['d_emin']='Minimale datum voor <em>%s</em> is %s';
$hesklang['d_emax']='Maximale datum voor <em>%s</em> is %s';
$hesklang['d_format']='Datumweergave';
$hesklang['d_custom']='Aangepaste weergave';
$hesklang['d_ci']='ALLEEN VOOR EXPERTS: een geldig PHP-datumformaat, zie PHP handleiding.';
$hesklang['cf_noe']='Voer een e-mailadres in in <em>%s</em>';
$hesklang['cf_noem']='Voer één of meer e-mailadressen in in <em>%s</em>';
$hesklang['can_resolve']='Kan ticket oplossen';
$hesklang['can_change_own_cat']='Kan ticketcategorie aanpassen';
$hesklang['can_submit_any_cat']='Kan tickets toevoegen aan elke categorie';
$hesklang['noauth_submit']='Onvoldoende rechten voor het toevoegen van tickets aan deze categorie!';
$hesklang['noauth_move']='Verplaatsen van tickets naar deze categorie is niet toegestaan!';
$hesklang['noauth_resolve']='Onvoldoende rechten voor het oplossen van tickets!';
$hesklang['force_ssl']='Forceer SSL-verbindingen';
$hesklang['d_ssl']='<em>gedeactiveerd</em> - open deze pagina met https:// om deze instelling te beheren';
$hesklang['scno']='De status kan niet worden aangepast';
$hesklang['statuses']='Statussen';
$hesklang['statuses_intro']='Voeg aangepaste statussen toe aan de helpdesk';
$hesklang['color']='Kleur';
$hesklang['csscl']='CSS-klasse of kleur';
$hesklang['clr_view']='Kleur voorvertoning op tekst';
$hesklang['cbc']='Te wijzigen door gebruikers';
$hesklang['ccc']='Kunnen gebruikers deze status wijzigen?';
$hesklang['del_status']='Status verwijderen?';
$hesklang['ex_status']='Bestaande statussen';
$hesklang['status_hesk']='Ingebouwde statussen (kunnen hier niet worden aangepast)';
$hesklang['status_custom']='Aangepaste statussen';
$hesklang['status_custom_none']='Geen aangepaste statussen - deze kunnen hierboven worden toegevoegd.';
$hesklang['status_save']='Status opslaan';
$hesklang['list_tkt_status']='Toon alle tickets met deze status';
$hesklang['new_status']='Nieuwe aangepaste status';
$hesklang['edit_status']='Wijzig aangepaste status';
$hesklang['err_status']='Voer de naam voor de status in';
$hesklang['status_added']='Nieuwe aangepaste status toegevoegd';
$hesklang['status_e_id']='Ongeldige ID';
$hesklang['status_mdf']='Aangepaste status opgeslagen';
$hesklang['status_deleted']='Aangepaste status verwijderd';
$hesklang['status_not_found']='Deze aangepaste status bestaat niet';
$hesklang['status_not_empty']='Deze status kan niet worden verwijderd zolang er tickets zijn met deze status';
$hesklang['status_limit']='Het maximale aantal van 100 aangepaste statussen is bereikt.';
$hesklang['public_link']='Openbare link';
$hesklang['frames']='Frames';
$hesklang['frames2']='Voorkom dat andere domeinen dit systeem in een frame laden.';
$hesklang['numsub']='Verzonden tickets';
$hesklang['hidf']='Verborgen velden zijn niet zichtbaar voor gebruikers bij het invoeren van een ticket. De waarde is wel zichtbaar op de ticketpagina wanneer deze openbaar is. Voor beheerders zijn het standaard tekstvelden.';
$hesklang['rcheck']='Selecteer geen standaardwaarde';
$hesklang['refresh_page']='Pagina vernieuwen';
$hesklang['del_kba']='Artikel verwijderen';
$hesklang['del_kbaa']='Artikel definitief verwijderen';
$hesklang['hni1']='Script nog niet geïnstalleerd?';
$hesklang['hni2']='Het lijkt erop dat het script niet is geïnstalleerd en geconfigureerd';
$hesklang['hni3']='Lees de <a href="docs/">documentatie</a> over de installatie van het script';
$hesklang['cf']='Cachemap';
$hesklang['e_cdir']='Het systeem verstuurt geen e-mailberichten als deze map niet bestaat of niet schrijfbaar is.';
$hesklang['step1']='Stap 1';
$hesklang['step2']='Stap 2';
$hesklang['dffs']='Wanneer de download compleet is, verwijder dan het bestand van de server';
$hesklang['fd']='Exportbestand verwijderd van de server';

// Added in version 2.8.0
$hesklang['TZ']='Tijdzone';
$hesklang['thist17']='<li class="smaller">%s | toegevoegd via IMAP-ophalen</li>';
$hesklang['sir3']='Onzichtbare reCAPTCHA';
$hesklang['invisible']='onzichtbaar';
$hesklang['imap_not']='PHP is niet gecompileerd met IMAP-ondersteuning';
$hesklang['imap_warning']='gebruiker %1$s heeft hetzelfde e-mailadres als het adres dat wordt gebruikt voor IMAP-mail ophalen: %2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='gebruiker %1$s heeft hetzelfde e-mailadres als het adres dat wordt gebruikt voor POP fetching: %2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='Dit kan een e-mailloop veroorzaken: notificaties genereren weer een nieuw ticket. Het fetching e-mailadres moet uniek zijn en mag door niemand anders worden gebruikt.';
$hesklang['can_view_ass_by']='Kan tickets zien die hij/zij aan een ander heeft toegewezen';
$hesklang['can_privacy']='Kan tickets anonimiseren';
$hesklang['confirm_anony']='Anonimiseer dit ticket';
$hesklang['anon_selected']='Anonimiseer geselecteerde tickets';
$hesklang['privacy_anon_info']='Verwijder alle gegevens die naar een persoon kunnen herleiden uit tickets (naam, e-mail, bericht, bijlagen, IP...), maar bewaar de tikets wel voor statistische doeleinden (right to be forgotten).';
$hesklang['success_anon']='Ticket geanonimiseerd';
$hesklang['num_tickets_anon']='Aantal geanonimiseerde tickets: <strong>%d</strong>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Klant]'; // Customer name in anonymized tickets
$hesklang['anon_email']=''; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Onderwerp]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Bericht]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class="smaller">%s | geanonimiseerd door %s</li>';
$hesklang['print_selected']='Print geselecteerde tickets';
$hesklang['with_selected']='Selectie:';
$hesklang['assign_selected']='Wijs selectie toe aan:';
$hesklang['assign_no']='Geen eigenaar geselecteerd, geen wijzigingen doorgevoerd';
$hesklang['assign_1']='Geselecteerde tickets zijn op <em>niet toegewezen,</em> gezet.';
$hesklang['assign_2']='Ticket-ID %1$s op <em>niet toegewezen</em> gezet'; // %1$s = ticket numerical ID
$hesklang['assign_3']='%1$s fout: reeds toegewezen aan %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s toegewezen aan %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='%1$s fout: %2$s heeft geen toegang tot ticketcategorie'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='Resultaat bulktoewijzing:<br /><br />Toegewezen: %1$s<br />Fouten: %2$s<br /><br />Log:<br /><pre>%3$s</pre>'; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='IP-adres';
$hesklang['moret']='Meer opties'; // More options button title
$hesklang['btn_more']='Meer'; // More options button text
$hesklang['btn_print']='Print';
$hesklang['btn_edit']='Bewerk';
$hesklang['btn_lock']='Vergrendel ticket';
$hesklang['btn_unlock']='Ontgrendel ticket';
$hesklang['btn_tag']='Geef ticket een tag';
$hesklang['btn_resend']='E-mailnotificatie opnieuw verzenden';
$hesklang['btn_untag']='Verwijder tag van ticket';
$hesklang['btn_import_kb']='Importeer naar kennisbank';
$hesklang['btn_anony']='Anonimiseer ticket';
$hesklang['btn_delt']='Verwijder ticket';
$hesklang['btn_delr']='Verwijder antwoord';
$hesklang['ernf']='Antwoord niet gevonden';
$hesklang['tns']='Ticketnotificaties opnieuw verzonden';
$hesklang['rns']='Antwoordnotificaties opnieuw verzonden';
$hesklang['fname']='Voornaam';
$hesklang['export_selected']='Exporteer geselecteerde tickets';
$hesklang['btn_export']='Exporteer naar XML voor Excel';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='Antwoorden';
$hesklang['team']='Team';
$hesklang['sm_content']='Inhoud';
$hesklang['sm_settings']='Instellingen';
$hesklang['wizard_back']='Terug'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Volgende'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Ga naar instellingen';
$hesklang['sm_return_to_editing']='Terug naar editor';
$hesklang['email_tpl_title']='Titel';
$hesklang['edit_email_template']='Bewerk e-mail template';
$hesklang['err_no_settings_section']='Er was geen instellingensectie voorzien.';
$hesklang['this_field_is_required']='Dit veld is verplicht';
$hesklang['reset_your_password']='Reset je wachtwoord';
$hesklang['reset_password_instructions']='Gelieve gegevens hieronder in te vullen. Er wordt een e-mail gestuurd met instructies om je wachtwoord te wijzigen.';
$hesklang['enter_email']='Geef je e-mailadres in';
$hesklang['password_reset_check_your_email']='Controleer je e-mailbox';
$hesklang['password_reset_link_sent']='Er zijn instructies gestuurd om je wachtwoord te wijzigen.';
$hesklang['back_to_login']='Terug naar het aanmeldscherm';
$hesklang['pager_first']='Eerste';
$hesklang['pager_previous']='Vorige';
$hesklang['pager_next']='Volgende';
$hesklang['pager_last']='Laatste';
$hesklang['new_team_member']='Nieuw teamlid';
$hesklang['role']='Rol';
$hesklang['optional']='Optioneel';
$hesklang['edit_profile']='Bewerk profiel';
$hesklang['assigned_to']='Toegewezen aan';
$hesklang['contact']='Contact';
$hesklang['unban_email']='Deblokkeer dit e-mailadres';
$hesklang['unban_ip']='Deblokkeer dit IP-adres';
$hesklang['show_previous_replies']='Toon vorige reactie';
$hesklang['type_your_message']='Geef je bericht in'; // Used when there are no canned responses
$hesklang['close_button_text']='Sluiten';
$hesklang['create_new_ticket']='Nieuw ticket aanmaken';
$hesklang['delete_article']='Verwijder artikel';
$hesklang['view_existing_tickets']='Toon bestaande tickets';
$hesklang['how_can_we_help']='Hallo, hoe kunnen we helpen?';
$hesklang['search_for_articles']='Zoek naar artikel';
$hesklang['submit_a_support_request']='Stel je vraag via dit formulier';
$hesklang['verify_header']='SPAM-bescherming';
$hesklang['ticket_details']='Ticketdetails';
$hesklang['yes_title_case']='Ja';
$hesklang['no_title_case']='Nee';
$hesklang['no_results_found']='Geen resultaten gevonden';
$hesklang['site_theme']='Thema website';
$hesklang['test_theme_folder']='Test themamap';
$hesklang['test_theme_folder_description']='De themamap wordt gevalideerd. Alleen thema\'s die correct worden gevalideerd worden juist geïnstalleerd.';
$hesklang['err_site_theme']='Selecteer het thema';
$hesklang['confirm']='Bevestig';
$hesklang['confirm_deletion']='Bevestig verwijdering';
$hesklang['confirm_delete_status']='Weet je zeker dat je deze aangepaste status wil verwijderen?';
$hesklang['help_desk']='Helpdesk'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.nl.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Tijdweergave';
$hesklang['tdisd']='Datum en tijd';
$hesklang['tdisa']='Verstreken tijd (voorbeeld: 5 uur geleden)';
$hesklang['nav_templates']='Templates'; // Admin panel navigation item
$hesklang['hide_replies']='Reacties verbergen';
$hesklang['hide_replies_no']='Nooit, toon altijd alle antwoorden';
$hesklang['hide_replies_yes']='Verberg alle antwoorden, behalve het laatste:';
$hesklang['hide_replies_def']='Toon het laatste antwoord van de helpdeskmedewerker en alle volgende klantenreacties';
$hesklang['reply_by']='Antwoord door'; // Reply by NAME
$hesklang['btt']='Terug naar boven';
$hesklang['lwidth']='Beperk ticketbreedte';
$hesklang['lwidtall']='Gebruik de maximale breedte';
$hesklang['lwidtpx']='Maximum breedte in pixels:';
// 3-letter days of the week
$hesklang['mon']='maa';
$hesklang['tue']='din';
$hesklang['wed']='woe';
$hesklang['thu']='don';
$hesklang['fri']='vri';
$hesklang['sat']='zat';
$hesklang['sun']='zon';
$hesklang['clear']='Wissen'; // delete field value
$hesklang['first_day_of_week']='1'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='Tenminste één anti-SPAM-maatregele moet zijn geactiveerd!';
$hesklang['modules']='Modules';
$hesklang['modules_demo']='Deze module is momenteel alleen beschikbaar in %s'; // %s = Hesk cloud link
$hesklang['see_demo']='Test de livedemo hier: %s'; // %s = Hesk demo link
$hesklang['statistics']['tab']='Statistieken';
$hesklang['statistics']['intro']='Dit rapport geeft je inzage in je helpdeskgebruik en in de prestaties van medewerkers.';
$hesklang['statistics']['ntsp']='Geen ticket gevonden in de geslecteerde tijdsperiode.';
$hesklang['statistics']['pie_title_ro']='Open vs opgeloste tickets';
$hesklang['statistics']['open']='Open';
$hesklang['statistics']['resolved']='Opgelost';
$hesklang['statistics']['pie_title_as']='Open tickets: toegewezen vs niet-toegewezen';
$hesklang['statistics']['ass']='Toegewezen';
$hesklang['statistics']['unas']='Niet-toegewezen';
$hesklang['statistics']['pie_title_au']='Open tickets: beantwoord vs niet-beantwoord';
$hesklang['statistics']['answered']='Beantwoord';
$hesklang['statistics']['unanswered']='Niet beantwoord';
$hesklang['statistics']['pie_title_so']='Status van open tickets';
$hesklang['statistics']['retic']='Tickets:';
$hesklang['statistics']['chart_title_md']='Tickets per dag van de maand';
$hesklang['statistics']['chart_title_wd']='Tickets per weekdag';
$hesklang['statistics']['chart_title_hd']='Tickets per uur';
$hesklang['statistics']['chart_title_tfr']='Tijd tot eerste antwoord';
$hesklang['statistics']['chart_title_tfrc']='Tickets beantwoord binnen tijdsblok';
$hesklang['statistics']['chart_title_ttr']='Tijd verlopen tussen ingave en afsluiten van een ticket';
$hesklang['statistics']['chart_title_ttrc']='Tickets opgelost binnen tijdsblok';
$hesklang['statistics']['chart_title_sr']='Medewerkers antwoorden';
$hesklang['statistics']['chart_title_srt']='Aantal medewerkers antwoorden per ticket';
$hesklang['statistics']['chart_title_srtr']='Aantal medewerkers antwoorden per ticket (enkel afgesloten tickets)';
$hesklang['statistics']['chart_title_srt1']='Aantal medewerkers antwoorden per ticket (tickets met minstens 1 reactie)';
$hesklang['statistics']['ct_30']='30 minuten';
$hesklang['statistics']['ct_1h']='1 uur';
$hesklang['statistics']['ct_2h']='2 uren';
$hesklang['statistics']['ct_4h']='4 uren';
$hesklang['statistics']['ct_1d']='1 dag';
$hesklang['statistics']['ct_2d']='2 dagen';
$hesklang['statistics']['ct_3d']='3 dagen';
$hesklang['statistics']['ct_1w']='1 week';
$hesklang['statistics']['ct_wp']='> 1 week';
$hesklang['statistics']['ct_1m']='1 maand';
$hesklang['statistics']['ct_mp']='> 1 maand';
$hesklang['statistics']['axis1']='% tickets beantwoord';
$hesklang['statistics']['axis2']='% tickets opgelost';
$hesklang['statistics']['axis3']='% tickets';
$hesklang['statistics']['axis4']='Tijd tot eerste antwoord';
$hesklang['statistics']['axis5']='Tijd tot oplossing';
$hesklang['statistics']['axis6']='Aantal antwoorden';
$hesklang['statistics']['axis7']='Aantal tickets';
$hesklang['statistics']['axis8']='Weekdag';
$hesklang['statistics']['axis9']='Uur';
$hesklang['statistics']['axis10']='Dag van de maand';
$hesklang['statistics']['tr_0']='Geen antwoord';
$hesklang['statistics']['tr_1']='1 antwoord';
$hesklang['statistics']['tr_2']='2 antwoorden';
$hesklang['statistics']['tr_5']='3-5 antwoorden';
$hesklang['statistics']['tr_10']='6-10 antwoorden';
$hesklang['statistics']['tr_99']='> 10 antwoorden';
$hesklang['statistics']['average']='Gemiddelde';
$hesklang['statistics']['atfr']='Gemiddeld aantal uren en minuten tot eerste antwoord van medewerker:';
$hesklang['statistics']['attr']='Gemiddeld aantal uren en minuten om een ticket op te lossen:';
$hesklang['statistics']['about']='ongeveer %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='N/A';
$hesklang['statistics']['trept']='Totaal aantal tickets dat medewerkers hebben beantwoord:';
$hesklang['statistics']['trnr']='Totaal aantal tickets opgelost zonder antwoord van een medewerker:';
$hesklang['statistics']['tsr']='Totaal aantal antwoorden van medewerkers:';
$hesklang['statistics']['tsrt']='Gemiddeld aantal medewerkersantwoorden per ticket:';
$hesklang['statistics']['tsro']='Gemiddeld aantal medewerkersantwoorden per ticket (tickets met minstens één antwoord):';
$hesklang['statistics']['tsrc']='Gemiddeld aantal medewerkersantwoorden nodig om een ticket op te lossen:';
$hesklang['statistics']['tsrr']='Gemiddeld aantal medewerkersantwoorden nodig om een ticket op te lossen (tickets met minstens 1 antwoord):';
$hesklang['sep_1000']=','; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']='.'; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='meer ...'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] Ticket achterstallig';
$hesklang['ticket_escalated']='[#%%TRACK_ID%%] GEËSCALEERD: %%SUBJECT%%';
$hesklang['escalate']['tab']='Escaleer'; // Menu link
$hesklang['escalate']['page_title']='Escaleer Tickets'; // Page H2 title
$hesklang['escalate']['intro']='Deze module helpt je om tickets te escaleren die niet op tijd verwerkt worden.';
$hesklang['escalate']['feat1']='Tickets niet toegewezen, beantwoord of opgelost binnen de tijd';
$hesklang['escalate']['feat2']='Tickets die de einddatum naderen of die overschreden hebben';
$hesklang['escalate']['feat3']='Verander automatisch de prioriteit van het ticket, wijs het opnieuw toe, stuur een e-mail notificatie';
$hesklang['escalate']['feat4']='Pas regels toe op basis van categorie, eigenaar, status';
$hesklang['escalate']['prefix']='Geëscaleerd:'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Actieve regels';
$hesklang['escalate']['new']='Nieuwe escalatieregel';
$hesklang['escalate']['no_rules']='Je hebt nog geen escalatieregels. Maak er een aan door hier boven op \'Nieuwe escalatieregel\' te klikken.';
$hesklang['escalate']['title']='Regelnaam';
$hesklang['escalate']['titlet']='Korte omschrijving, bijvoorbeeld: Wijs tickets opnieuw toe indien niet beantwoord binnen één dag';
$hesklang['escalate']['default_title']='Regel door %1$s'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Regelactivatie';
$hesklang['escalate']['trigt']='Stel de voorwaarden in die deze regels activeerd.';
$hesklang['escalate']['hits']='Treffers'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Voorwaarde'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Activatie'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='Van toepassing op'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']='Deze regel verwijderen?';
$hesklang['escalate']['edit']='Bezig met bewerken escalatieregel ID %1$s'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='Een helpdeskticket is:'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='niet beantwoord door medewerker';
$hesklang['escalate']['nrepc']='niet beantwoord door klant';
$hesklang['escalate']['nass']='niet toegewezen';
$hesklang['escalate']['nres']='niet afgehandeld';
$hesklang['escalate']['ndue']='dicht bij einddatum';
$hesklang['escalate']['odue']='overschreden';
$hesklang['escalate']['within']='Bereik:';
$hesklang['escalate']['minutes']='minuten';
$hesklang['escalate']['hours']='uren';
$hesklang['escalate']['days']='dagen';
$hesklang['escalate']['weeks']='weken';
$hesklang['escalate']['months']='maanden';
$hesklang['escalate']['years']='jaren';
$hesklang['escalate']['ofs']='sinds doorgegeven';
$hesklang['escalate']['resend']='E-mailnotificaties opnieuw verzenden:';
$hesklang['escalate']['force']='Altijd versturen, los van medewerkersinstellingen';
$hesklang['escalate']['noforce']='Respecteer notificatie-instellingen van medewerkers';
$hesklang['escalate']['setpri']='Verander prioriteit naar:';
$hesklang['escalate']['setsta']='Verander status naar:';
$hesklang['escalate']['assto']='Wijs ticket toe aan:';
$hesklang['escalate']['asm']='Een andere medewerker';
$hesklang['escalate']['notify']='Licht medewerkers in...';
$hesklang['escalate']['ato']='Toepassen op:';
$hesklang['escalate']['tic']='Tickets in categorie:';
$hesklang['escalate']['tat']='Tickets toewijzen aan:';
$hesklang['escalate']['tws']='Tickets met status:';
$hesklang['escalate']['tall']='Pas deze regel toe op huidige en toekomstige tickets';
$hesklang['escalate']['tfn']='Pas deze regel enkel toe op toekomstige tickets. Huidige tickets blijven ongewijzigd';
$hesklang['escalate']['tfi']='Pas deze regel toe op tickets met een ID hoger dan:';
$hesklang['escalate']['save']='Regel opslaan';
$hesklang['escalate']['e_tt']='Tijd moet tussen 1 en 10000 liggen';
$hesklang['escalate']['e_a']='Selecteer minstens één actie om op de geseleceerde tickets toe te passen';
$hesklang['escalate']['nocat']='Selecteer minstens één categorie';
$hesklang['escalate']['nouser']='Selecteer minstens één gebruiker';
$hesklang['escalate']['nostatus']='Selecteer minstens één status';
$hesklang['escalate']['nocata']='%1$s heeft geen toegang tot deze categorieën:'; // %1$s = user name
$hesklang['escalate']['rule_added']='De nieuwe regel is aangemaakt';
$hesklang['escalate']['mdf']='De regelinstellingen zijn opgeslagen';
$hesklang['escalate']['e_id']='Geen regel met deze ID gevonden';
$hesklang['escalate']['deleted']='De geselecteerde regel is verwijderd';
$hesklang['escalate']['edit_notice']='het wijzigen van de regeltrigger heeft geen invloed op tickets die reeds geëscaleerd zijn door deze regel (enkel indien de regel gereset wordt).';
$hesklang['escalate']['reset']='Deze regel resetten';
$hesklang['escalate']['reset2']='Ben je zeker dat je deze regel wil resetten?<br><br>Regelhits worden op 0 gezet en elk ticket dat aan deze regel voldeed wordt opnieuw geëscaleerd.';
$hesklang['escalate']['reset3']='De geselecteerde regel is gereset';
$hesklang['escalate']['log_title']='Regel #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class="smaller">%1$s | geëscaleerd door %2$s:</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class="smaller">%1$s | - zet prioriteit op %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class="smaller">%1$s | - toewijzen aan %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class="smaller">%1$s | - stuur medewerker notificaties</li>';
$hesklang['escalate']['thist5']='<li class="smaller">%1$s | - stuur medewerker notificaties (geforceerd)</li>';
$hesklang['escalate']['thist6']='<li class="smaller">%1$s | - fout: %2$s heeft geen toegang tot de categorie van dit ticket</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class="smaller">%1$s | - fout: %2$s heeft geen toestemming om tickets te bekijken</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class="smaller">%1$s | - fout: geen andere gebruiker die dit ticket kan bekijken</li>'; // %1$s = date
$hesklang['escalate']['thist9']='<li class="smaller">%1$s | - opmerking: prioriteit staat reeds op %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class="smaller">%1$s | - opmerking: reeds toegewezen aan %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class="smaller">%1$s | - notificatie: %2$s</li>'; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class="smaller">%1$s | - zet status op %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class="smaller">%1$s | - opmerking: status staat reeds op %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Actief'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Activeer deze regel (begin met gebruik)';
$hesklang['escalate']['activated']='De geselecteerde regel is geactiveerd'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='Deactiveer deze regel (stop het gebruik)';
$hesklang['escalate']['deactivated']='De regel is gedeactiveerd'; // %1$s = rule log title
$hesklang['escalate']['no_active']='Geen actieve escalatieregels';
$hesklang['escalate']['matched']='Aantal tickets dat aan deze voorwaarden voldoet: %1$s '; // %1$s = number of tickets
$hesklang['escalate']['tools']='Gereedschap';
$hesklang['escalate']['test']='Simuleer deze regel';
$hesklang['escalate']['testa']='Simuleer alle regels';
$hesklang['escalate']['testaa']='Simuleer alle actieve regels';
$hesklang['escalate']['testr']='Simulatieresultaat';
$hesklang['escalate']['rsim']='Simuleer herhalen';
$hesklang['escalate']['tbef']='Voor deze regel werkt, dien je deze te activeren door deze aan te vinken in de \'ACTIEF\' kolom.<br><br>
                               We raden sterk aan om elke regel te <strong>simuleren</strong> door op het %1$s (Simulate this rule) icoon in de regeltabel te klikken om te controleren welke invloed dit heeft op bestaande tickets alvorens deze te activeren.<br><br><strong>Active regels worden elke %2$s minuten verwerkt. Een ticket kan slechts eenmalig worden geëscaleerd per regel</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='SIMULATIEMODUS, geen wijzigingen in de database';
$hesklang['escalate']['sic']='SIMULATIE COMPLEET';
$hesklang['escalate']['r']='[REGEL]';
$hesklang['escalate']['i']='[INFO]';
$hesklang['multopt']='Tip: houd de CTRL toets ingedrukt om meerdere opties te selecteren';
$hesklang['desc_ticket_escalated']='(Medewerkers) Ticket is geëscaleerd'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Ticketopmaak (medewerkers)';
$hesklang['ticket_formatting_plaintext']='Gewone tekst';
$hesklang['ticket_formatting_rich_text']='Rich text (HTML)';
$hesklang['due_date']='Einddatum';
$hesklang['invalid_due_date']='Een ongeldige einddatum ingevoerd.';
$hesklang['thist19']='<li class="smaller">%s | einddatum bijgewerkt naar %s door %s</li>'; // %s = date, new due date, user making change
$hesklang['thist20']='<li class="smaller">%s | einddatum verwijderd door %s</li>'; // %s = date, user making change
$hesklang['due_date_updated']='Einddatum ticket is bijgewerkt.';
$hesklang['menu_kb_manage']='Beheren'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='Bekijken'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Alles selecteren';
$hesklang['a_deselect']='Alles deselecteren';
$hesklang['a_toggle']='Alles wisselen';
$hesklang['ql_all']='Alle tickets';
$hesklang['ql_alo']='Alle open tickets';
$hesklang['ql_fit']='Gefilterde tickets';
$hesklang['ql_a2m']='Aan mij toegewezen';
$hesklang['ql_a2o']='Aan anderen toegewezen';
$hesklang['ql_una']='Niet toegewezen';
$hesklang['ql_due']='Dicht bij einddatum';
$hesklang['ql_ovr']='Achterstallig';
$hesklang['set_ds']='Toon als \'dicht bij einddatum\''; // Settings page (title of setting)
$hesklang['set_ds2']='dagen tot einddatum';
$hesklang['not_aos']='Enkele open tickets worden niet getoond vanwege de filters.';
$hesklang['ntoverdue']='Een ticket is over de einddatum met eigenaar:';
$hesklang['ovdcron']='om einddatumnotificaties te ontvangen, moet je administrator een cron job activeren.';
$hesklang['instructions']='Instructies';
$hesklang['desc_overdue_ticket']='(Medewerkers) Ticket over tijd';
$hesklang['overdue_starting']='Opstarten van notificaties voor tickets die achterstallig zijn';
$hesklang['overdue_sim']='Het verzenden van e-mails en updaten van tickets is uitgeschakeld in SIMULATIE-modus.';
$hesklang['overdue_ticket_count']='%s tickets gevonden die achterstallig zijn.'; // %s = Number of tickets
$hesklang['overdue_finished']='Achterstallige tickets verwerkt. %s e-mails verzonden. %s e-mails met foutmeldingen.'; // %s = Successful emails, failed emails
$hesklang['admin_css']='Admin CSS';
$hesklang['admin_css2']='Laad een extra aangepast stylesheetbestand voor het admingedeelte';
$hesklang['noval_cert']='Servercertificaten niet valideren';
$hesklang['chg_cat']='Klik om de ticketcategorie te wijzigen';
$hesklang['tlan']='Tickettaal';
$hesklang['uue']='Twee of meerdere medewerkers hebben hetzelfde e-mailadres. We raden aan een uniek e-mailadres te gebruiken voor elke gebruiker.';
$hesklang['flood']='Overstrominglimiet';
$hesklang['e_flood']='Oeps, je hebt recent al een antwoord verstuurd. We hebben je nieuwe verzoek tegengehouden om het systeem niet te overbelasten.';
$hesklang['cookies']='Cookies';
$hesklang['ukey']='Toegangssleutel URL'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='genereer een willekeurige URL-toegangssleutel';
$hesklang['ukeym']='Error: om dit bestand via HTTP uit te voeren moet je de URL-toegangssleutel toevoegen. Voorbeeld:';
$hesklang['ukeyw']='Error: foutieve URL-toegangssleutel';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Ticket ontvangen: %%SUBJECT%%';
$hesklang['mfa_verification']='%%VERIFICATION_CODE%% is je verificatiecode';
$hesklang['follow_up_email']='Hoe hebben we het gedaan?';
$hesklang['mfa']='Multi-Factor Authenticatie (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='MFA ingeschakeld ?';
$hesklang['mfa_required']='Multi-Factor Authenticatie vereist';
$hesklang['mfa_manage_profile']='Manage MFA';
$hesklang['mfa_disabled']='Multi-Factor Authenticatie is uitgeschakeld';
$hesklang['mfa_enabled']='Multi-Factor Authenticatie is ingeschakeld (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='Geen';
$hesklang['mfa_method_none_subtext']='Verwijder Multi-Factor Authenticatie van je account.';
$hesklang['mfa_method_email']='Eemail';
$hesklang['mfa_method_email_subtext']='De helpdesk zal een e-mail met een random inlogcode sturen naar <strong>%s</strong> bij het inloggen.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='Authenticator App';
$hesklang['mfa_method_auth_app_short']='App';
$hesklang['mfa_method_auth_app_subtext']='Gebruik een smartphone app - zoals Authy or Google Authenticator - een een random logincode te genereren bij het inloggen.';
$hesklang['mfa_step_method']='Methode';
$hesklang['mfa_step_verification']='Verificatie';
$hesklang['mfa_step_complete']='Afgerond';
$hesklang['mfa_introduction']='Multi-Factor Authenticatie draagt bij aan de veiligheid van je account door extra verificatie te vragen bij het inloggen via een extra verificatiemethode zoals e-mail of een authentiocatie app zoals such as Authy or Google Authenticator.';
$hesklang['mfa_reset_warning']='Je hebt Multi-Factor Authenticatie reeds ingeschakeld. Wanneer je dit nog eens doet dat zal dit het de huidige Multi-Factor Authenticatie-app resetten wanneer deze is ingeschakeld.';
$hesklang['mfa_select_method_colon']='Kies een authenticatiemethode:';
$hesklang['mfa_verification_header']='Verificatie - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='Er is een e-mail met een zestallige verificatiecode gestuurd naar <strong>%s</strong>. Voer hieronder de via e-mail ontvangen code in om verder te gaan.'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; Step 1: Scan de afbeelding hieronder met de Muti-Factor Authenticatie-app op je mobiele apparaat.';
$hesklang['mfa_verification_auth_app_cant_scan']='Kun je de afbeelding niet scannen? Voer dan deze code handmatig in op je apparaat: <strong>%s</strong>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; Step 2: Voer de 6-cijferige code in die in uw applicatie wordt weergegeven om uw apparaat te verifiëren.';
$hesklang['mfa_verify']='Verifiëren';
$hesklang['mfa_invalid_method']='Er is een ongeldige Multi-Factor Authenticatiemethode ontvangen';
$hesklang['mfa_invalid_verification_code']='De code die werd ingevoerd is onjuist of verlopen.';
$hesklang['mfa_configured']='Multi-Factor Authenticatie is uitgeschakeld voor je account!';
$hesklang['mfa_removed']='Multi-Factor Authenticatie is uitgeschakeld voor je account!';
$hesklang['mfa_verification_needed']='Multi-Factor Authenticatie is ingeschakeld voor dit account!';
$hesklang['mfa_verification_needed_email']='Vul de verificatiecode in die naar je e-mailadres is gestuurd.';
$hesklang['mfa_verification_needed_auth_app']='Vul de code in die in je authenticatie-app wordt getoond.';
$hesklang['mfa_verification_code']='Verificatiecode';
$hesklang['mfa_server_time_issue']='De servertijd lijkt onjuist te zijn: %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Reset Multi-Factor Authenticatie';
$hesklang['mfa_reset_confirm']='Weet je zeker dat je Multi-Factor Authenticatie voor deze gebruiker wilt resetten?';
$hesklang['mfa_reset_yes']='Reset';
$hesklang['mfa_reset']='Multi-Factor Authenticatie is gereset voor deze gebruiker.';
$hesklang['desc_mfa_verification']='(Staf) Multi-Factor Authenticatie Code';
$hesklang['mfa_code']='Code:';
$hesklang['mfa_backup_codes_header']='BEWAAR JE BACK-UPCODES!';
$hesklang['mfa_backup_codes_description']='Bewaar deze back-upcodes ergens veilig maar toegankelijk. Als je de toegang tot je MFA-apparaat of e-mail verliest, kun je een van de volgende back-upcodes invoeren om je aan te melden.<br><br><strong>Zorg ervoor dat je deze back-upcodes als wachtwoorden behandelt. Je kunt deze codes niet meer zien!</strong>';
$hesklang['mfa_verify_another_way']='Verifieer je account op een andere manier.'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Ontvang een verificatiecode bij %s';
$hesklang['mfa_verify_another_way_code']='Vul een van je 8-cijferige back-upcodes in.';
$hesklang['mfa_verify_another_way_admin']='Neem contact op met de administrator van de helpdesk voor hulp.';
$hesklang['mfa_verify_another_way_reset']='Reset je Multi-Factor authenticatie door een bestand naar de server te uploaden.';
$hesklang['mfa_send_another_email']='Stuur opnieuw een e-mail.';
$hesklang['mfa_sent']='Een e-mail met een nieuwe verificatiecode is naar je e-mailadres verzonden.';
$hesklang['mfa_backup_code']='Back-upcode';
$hesklang['mfa_backup_codes']='Back-upcodes';
$hesklang['mfa_backup_codes_info']='Codes voor eenmalig gebruik om Multi-Factor Authenticatie door te geven wanneer je geen toegang kunt krijgen tot je e-mail of authenticatie-app. Zodra je een back-upcode gebruikt om in te loggen, wordt die code inactief.';
$hesklang['mfa_backup_codes_num']='Je kunt een nieuwe set van 10 back-upcodes krijgen wanneer je maar wilt. Wanneer je een nieuwe set codes maakt, wordt de oude set automatisch inactief.';
$hesklang['mfa_backup_codes_num2']='Jouw aantal actieve codes is: %s';
$hesklang['mfa_invalid_backup_code']='De back-upcode die is ingevoerd is onjuist of al ee keer gebruikt.';
$hesklang['mfa_del_codes']='Verwijder mijn back-upcodes';
$hesklang['mfa_del_codes2']='Al je back-upcodes zijn verwijderd.';
$hesklang['mfa_new_codes']='Genereer nieuwe back-upcodes';
$hesklang['mfa_new_codes2']='Nieuwe back-upcodes zijn gegenereerd.';
$hesklang['old_php_version']='Fout: niet-ondersteunde PHP-versie';
$hesklang['category_default_due_date']='Standaard vervaldatum';
$hesklang['category_change_default_due_date']='Stel standaard vervaldatum in';
$hesklang['category_leave_blank_for_no_default_due_date']='(laat leeg wanneer er geen standaard vervaldatum is)';
$hesklang['category_default_due_date_updated']='Standaard vervaldatum is bijgewerkt..';
$hesklang['email_formatting']='E-mail formaat';
$hesklang['email_formatting_html_and_plaintext']='HTML met alternatief voor platte tekst van template voor platte tekst (standaard)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML met plattetekstalternatief gegenereerd uit het HTML-template';
$hesklang['email_formatting_html']='Alleen HTML';
$hesklang['email_formatting_plaintext']='Alleen platte tekst';
$hesklang['email_formatting_note']='Je selectie in %1$s &gt; %2$s &gt; %3$s is ingesteld op: <em>%4$s</em>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='Dit betekent dat Hesk hier HTML-templates zal negeren.';
$hesklang['email_formatting_note1']='Dit betekent dat Hesk hier platteteksttemplates zal negeren.';
$hesklang['email_formatting_note2']='Dit betekent dat Hesk een plattetekstversie van e-mails van je HTML-sjablonen genereert en de platte tekstsjablonen hier negeert.';
$hesklang['etnu']='Dit e-mailtemplate wordt momenteel niet gebruikt door Hesk op basis van je selectie in %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='Categorie bewerken';
$hesklang['create_category']='Categorie toevoegen of wijzigen';
$hesklang['one_user_included']='1 gebruiker inbegrepen';
$hesklang['one_user_excluded']='1 gebruiker uitgesloten';
$hesklang['x_users_included']='%s gebruikers inbegrepen'; // %s = Number of users
$hesklang['x_users_excluded']='%s gebruiker uitgesloten'; // %s = Number of users
$hesklang['aa_cat']='Ken tickets in deze categroei automatisch toe';
$hesklang['modify_autoassign_settings']='Wijzig de instellngen voor automatisch toekennen';
$hesklang['autoassign_on_all_users']='Ja, aan elke gebruiker met toegang tot deze categorie';
$hesklang['autoassign_on_select_users']='Ja, aan specifieke gebuikers';
$hesklang['autoassign_off']='Nee, verzend tickets als niet-toegewezen';
$hesklang['autoassign_users']='Gebruikers die moeten worden opgenomen/uitgesloten in/van automatische toewijzing';
$hesklang['autoassign_selected_include']='Geselecteerde gebruikers moeten <strong>opgenomen</strong> zijn bij het automatisch toewijzen van tickets in deze categorie';
$hesklang['autoassign_selected_exclude']='Geselecteerde gebruikers moeten worden <strong>uitgesloten</strong> bij het automatisch toewijzen van tickets in deze categorie';
$hesklang['cat_edited']='Categorie %s is succesvol bewerkt';
$hesklang['search_for_user']='Zoek gebruiker';
$hesklang['email_sending']='E-mails aan het versturen';
$hesklang['email_to_ticket']='E-mail naar ticket';
$hesklang['email_to_ticket_info']='Het converteren van e-mails naar tickets vereist enige aanpassingen op de server. Zie <a href="%s" target="_blank">deze kennisbankgids</a> voor details.'; // %s = link to article
$hesklang['from_warning2']='Hesk gebruikt een SMTP-server om e-mailmeldingen te verzenden. Je <strong>%1$s</strong> moet worden ingesteld op <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Ontbrekende bestandsextensie';
$hesklang['block_ignore']='E-mail negeren en loops voorkomen';
$hesklang['block_noreply']='No-reply-adressen';
$hesklang['block_noreply2']='Negeer e-mail die zijn verzonden van een \'do not reply/no reply\' e-mailadres';
$hesklang['block_returned']='Geretourneerde e-mails';
$hesklang['block_returned2']='Negeer teruggestuurde e-mails zoals leveringsstatusmeldingen en geautomatiseerde antwoorden';
$hesklang['block_duplicate']='Duplicaat e-mails';
$hesklang['block_duplicate2']='Negeer e-mails met hetzelfde bericht verzonden binnen \'%s\' seconden'; // %s = "Timeframe"
$hesklang['loop_info']='e-mails ontvangen van hetzelfde e-mailadres binnen \'%s\' seconden';
$hesklang['thist21']='<li class="smaller">%s | e-mailmelding achterstalligheid verzonden</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | vervolge-mail verstuurd</li>'; // %s = date
$hesklang['elevator_header']='Beveiligd gedeelte betreden';
$hesklang['elevator_intro']='Je staat op het punt een beveiligd gedeelte binnen te gaan.';
$hesklang['elevator_enter_password']='Voor je wachtwoord in om verder te gaan.';
$hesklang['elevator_duration_setting_title']='Tijdsduur beveiligd gedeelte';
$hesklang['desc_survey']='(Klant) Follow-up (enquête) e-mail'; // Email description
$hesklang['satisfaction']['tab']='Tevredenheid';
$hesklang['satisfaction']['title']='Klanttevredenheidsonderzoek';
$hesklang['satisfaction']['intro']='Stuur uw klanten een tevredenheidsonderzoek om feedback te verzamelen over hun ervaring met je helpdesk.';
$hesklang['satisfaction']['tab1']='Instellingen';
$hesklang['satisfaction']['tab2']='Afmelden';
$hesklang['satisfaction']['enable']='Schakel vervolge-mails in:';
$hesklang['satisfaction']['enabled']='Klanttevredenheidsonderzoeken zijn ingeschakeld.';
$hesklang['satisfaction']['disabled']='Klanttevredenheidsonderzoeken zijn onlangs uitgeschakeld.';
$hesklang['satisfaction']['url']='URL klanttevredenheidsonderzoek:';
$hesklang['satisfaction']['send']='Vertraging vervolge-mail:';
$hesklang['satisfaction']['at_least']='Wacht ten minste';
$hesklang['satisfaction']['after']='nadat het ticket is opgelost voor een e-mail wordt gestuurd.';
$hesklang['satisfaction']['h1']='Hoe gebruik je deze tool?';
$hesklang['satisfaction']['h2']='Maak eerst een klanttevredenheidsonderzoek in je favoriete enquêtetool. Als je niet zeker weet welke tool je moet gebruiken of welke vragen je moet stellen, hebben we hier een <a href="%s" target="_blank">gids beschikbaar</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='Wanneer je enquête gereed is, kun je vervolge-mails inschakelen met behulp van onderstaand formulier. Hesk verwerkt opgeloste tickets met minimaal één antwoord van een staflid eenmaal per uur en stuurt de enquêtelink naar j klanten.';
$hesklang['satisfaction']['e_url']='Voer een geldige URL in van de enquête. Dit is het internetadres waar je klanten heen worden gestuurd.';
$hesklang['satisfaction']['as']='Voer een geldige URL in van de enquête. Dit is het internetadres waar je klanten heen worden gestuurd.';
$hesklang['satisfaction']['oo1']='Op deze pagina staan e-mailadressen waarnaar <strong>geen</strong> vervolge-mails worden verzonden.';
$hesklang['satisfaction']['oo2']='Je klanten kunnen zich afmelden voor het ontvangen van enquête-e-mails door op een link in de e-mail te klikken. Je kunt ook handmatig e-mailadressen toevoegen op deze pagina.';
$hesklang['satisfaction']['ooe']='E-mailadres om af te melden';
$hesklang['satisfaction']['ooe2']='Voer het e-mailadres in dat je wilt afmelden voor het ontvangen van enquête-e-mails.';
$hesklang['satisfaction']['ooe3']='Dit e-mailadres <em>%s</em> is al afgemeld voor het ontvangen van enquête-e-mails.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Meld dit e-mailadres af';
$hesklang['satisfaction']['oob']='Afgemeld door';
$hesklang['satisfaction']['no_oo']='Geen enkele klant heeft zich afgemeld voor het ontvangen van enquête-e-mails.';
$hesklang['satisfaction']['oor']='Verwijder';
$hesklang['satisfaction']['oor2']='E-mail verwijderd voor afmelding';
$hesklang['satisfaction']['oor3']='Bevestig verwijdering';
$hesklang['satisfaction']['oor4']='Wanneer deze e-mail is verwijderd uit afmelden, dan zal de gebruiker weer vervolg-e-mails ontvangen.';
$hesklang['satisfaction']['optedout']='Het e-mailadres <em>%s</em> is afgemeld voor het ontvangen van onderzoekse-mails.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='Ontbrekende of ongeldige onderzoeks-ID';
$hesklang['satisfaction']['starting']='Meldingsproces voor klanttevredenheidsonderzoek wordt gestart';
$hesklang['satisfaction']['tc']='%s gesloten tickets gevonden waarvoor geen tevredenheidsenquête is verzonden.'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Klanttevredenheidsonderzoek afgerond. Verzonden e-mails: %1$s. E-mails die niet konden worden verzonden: %2$s. Tickets zonder e-mail: %3$s. Tickets met afgemeld e-mailadres: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='Negeren, deze klant wil geen enquête-e-mails ontvangen.';
$hesklang['satisfaction']['ne']='Negeren, dit ticket heeft geen e-mailadres.';
$hesklang['satisfaction']['feat1']='Maak je enquête met een tool van derden, zoals Google Forms.';
$hesklang['satisfaction']['feat2']='Stel je enquête-URL, voorkeuren en beperkingen in binnen deze module.';
$hesklang['satisfaction']['feat3']='Wanneer je een ticket oplost, e-mailt Hesk je klant de link naar de enquête.';
$hesklang['dfor']='Datumnotatie';
$hesklang['dtfor']='Datum en tijd';
$hesklang['cdfor']='Selectieformaat datum';
$hesklang['custom']='Aangepast';
$hesklang['jsc_notice']='De datumselectie ondersteunt geen datumnotatie in PHP-stijl. Selecteer een van de vooraf geconfigureerde opties of klik op het %s-pictogram hieronder om de beschikbare weergave-opties te zien.'; // %s = replaced by icon
$hesklang['lcf3']='Alleen datum'; // Display: "Date only"
$hesklang['epdd']='Fout bij het verwerken van de due_date-parameter:';
$hesklang['edit_pass']='Bewerk wachtwoord';
$hesklang['save_pass']='Bewaar wachtwoord';
$hesklang['cur_pass']='Huidig wachtwoord';
$hesklang['cur_pass2']='Je dienst je huidige wachtwoord in te voeren om het te kunnen wijzigen.';
$hesklang['cur_pass3']='Na een succesvolle wijziging van je wachtwoord, word je doorgestuurd naar de inlogpagina waar je kunt inloggen met je nieuwe wachtwoord.';
$hesklang['e_new_pass']='Voer je nieuwe wachtwoord in.';
$hesklang['pass_len']='Het wachtwoord mag niet langer zijn van 64 tekens.';
$hesklang['pass_login']='Log opnieuw in nadat je je wachtwoord hebt gewijzigd.';
$hesklang['bf_int']='Je bent uitgelogd na teveel mislukte verificatiepogingen.';
$hesklang['tst_cnt']='Aantal e-mails dat je mailserver naar Hesk zal sturen: %s'; // %s = number of emails
$hesklang['wrn_imap']='Je hebt veel ongelezen e-mails in je mailbox (%1$s). Hesk zet al deze e-mails om in tickets.<br><br>Misschien wil je bestaande e-mails als gelezen markeren voordat je %2$s inschakelt of een nieuw e-mailaccount voor Hesk gebruiken.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='Je hebt veel e-mails in je mailbox (%1$s). Hesk zet al deze e-mails om in tickets.<br><br>Misschien wil je bestaande e-mails verwijderen voordat je %2$s inschakelt of een nieuw e-mailaccount voor Hesk gebruiken.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='Vervalt op'; // Due on (date)
$hesklang['search_due_date_range']='Vervalt binnen'; // Due in (X days)
$hesklang['attachment_add_files']='Bestand toevoegen';
$hesklang['attachment_max_exceeded']='Dit bestand wordt niet geüpload, omdat je al het maximale aantal toegestane bestanden hebt geüpload.';
$hesklang['attachment_viewer_message']='Sleep bestanden hierheen of klik op de knop \'Bestand toevoegen\' hieronder om bestanden te selecteren om te uploaden.';
$hesklang['attachment_invalid_type_message']='Sorry, maar het bestandstype dat je probeerde te uploaden is niet toegestaan.';
$hesklang['attachment_upload_error']='Er is een fout opgetreden bij het uploaden. Probeer het later opnieuw.';
$hesklang['attachment_too_large']='Deze bijlage is groter dan de maximaal toegestane bestandsgrootte.';
$hesklang['attachment_cancel']='Annuleren';
$hesklang['attachment_confirm_cancel']='Weet je zeker dat je deze upload wilt annuleren?';
$hesklang['attachment_remove']='Verwijder bijlage';
$hesklang['attachment_too_many_uploads']='Er zijn in korte tijd teveel bijlagen geüpload vanaf jouw locatie. Probeer het later opnieuw.';
$hesklang['sub_note']='Notitie insturen';
$hesklang['can_view_users']='Alle gebruikers bekijken (maar niet beheren)';
$hesklang['welcome1']='Hey daar, je lijkt nieuw te zijn hier. Welkom!';
$hesklang['welcome2']='Bekijk de %s om je op weg te helpen.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Hesk online Quick Start Guide';
$hesklang['tmce1']='Houd de Control-toets (Ctrl) ingedrukt en klik met de rechtermuisknop op het verkeerd gespelde woord om de spellingcontrole te openen.';
$hesklang['tmce2']='Houd de Control-toets (Ctrl) ingedrukt en klik met de rechtermuisknop op het verkeerd gespelde woord om de spellingcontrole te openen.';
$hesklang['desc_new_ticket_by_staff']='(Klant) Nieuw door personeel ingediend ticket';
$hesklang['mod_et_h']='Je kunt e-mailtemplates wijzigen onder: %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Stel de taal in op';
$hesklang['ouwa']='Alleen gebruikers met toegang tot deze categorie worden hieronder vermeld. Om medewerkers aan deze categorie toe te voegen, bewerk je hun rechten op de %s pagina'; // %s = Team
$hesklang['previous_tickets']='Voorgaande tickets';
$hesklang['no_previous']='Geen voorgaande tickets van %s'; // %s = email address
$hesklang['all_previous']='Toon alle voorgaande tickets';
$hesklang['confirm_delete_ticket']='Weet je zeker dat je dit ticket definitief wilt verwijderen?';
$hesklang['confirm_delete_reply']='Weet je zeker dat je dit antwoord definitief wilt verwijderen?';
$hesklang['select_new_category']='Aantal tickets in deze categorie: %s<br><br>Selecteer een nieuwe categorie om deze tickets over te zetten naar:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='Aantal tickets toegewezen aan deze gebruiker: %1$s<br>Aantal <strong>open</strong> tickets toegewezen aan deze gebruiker: %2$s<br><br><strong>Open</strong> tickets wordt <strong>\'niet toegwezen\'</strong> na het verwijderen van deze gebruiker.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='HESK licentie';
$hesklang['hlic_free']='GRATIS';
$hesklang['hlic_buyl']='Koop een licentie';
$hesklang['hlic_paid']='Gelicenseerd';
$hesklang['antdemo']='Het indienen van tickets via het beheerdersdashboard is uitgeschakeld in de demomodus.<br><br>Gebruik de <a href="%s" target="_blank">publieke kant</a> om een testticket in te dienen.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Authenticatiemethode';
$hesklang['email_authentication_method_username_password']='Basis (gebruikersnaam/wachtwoord)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - Geen geverifieerde OAuth-providers geconfigureerd.';
$hesklang['email_authentication_method_oauth_link']='Beheer OAuth-providers'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='URL eindpunt autorisatie';
$hesklang['email_oauth_token_url']='URL eindpunt token';
$hesklang['email_oauth_client_id']='Klant-ID';
$hesklang['email_oauth_client_secret']='Klantgeheim';
$hesklang['email_oauth_scope']='Bereik';
$hesklang['oauth_error_invalid_state']='OAuth-status komt niet overeen met de status die naar de OAuth-provider is verzonden.';
$hesklang['oauth_error_unknown']='Er is een onbekende fout opgetreden bij het opslaan van OAuth-tokens.';
$hesklang['oauth_error_no_token']='Toegangstoken ontbreekt in het JSON-antwoord.';
$hesklang['oauth_error_retrieve']='Kan geen toegangstoken ophalen. Bevestig je OAuth-providerinstellingen en sla ze opnieuw op om een nieuwe token te verkrijgen.';
$hesklang['email_oauth_provider']='OAuth-provider';
$hesklang['email_oauth_providers']='OAuth-providers';
$hesklang['email_oauth_provider_guide']='Voordat je OAuth gebruikt, moet je een OAuth-provider registreren. Zie <a href="%s" target="_blank">deze kennisbankgids</a> voor details.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='Je OAuth Redirect URI voor Hesk is:<br><em>%s</em>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Gebruik deze tool om OAuth-providers toe te voegen aan je helpdesk';
$hesklang['email_oauth_provider_name']='Naam'; // OAuth provider name
$hesklang['email_oauth_new_provider']='Nieuwe provider';
$hesklang['email_oauth_edit_provider']='Aanbieder bewerken';
$hesklang['email_oauth_provider_being_used_for']='Wordt gebruikt voor';
$hesklang['email_oauth_providers_none']='Geen OAuth-providers opgeslagen. Je kunt ze toevoegen door hierboven op "Nieuwe provider" te klikken.';
$hesklang['email_oauth_provider_cannot_be_deleted']='Deze provider kan niet worden verwijderd, omdat deze wordt gebruikt door de helpdesk.';
$hesklang['email_oauth_confirm_delete_provider']='Weet je zeker dat je deze OAuth-provider wilt verwijderen?';
$hesklang['oauth_provider_saved']='OAuth-provider is opgeslagen.';
$hesklang['oauth_provider_use']='Je kunt deze provider nu selecteren in %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Vul de providernaam in';
$hesklang['oauth_provider_err_auth_url']='Vul een geldige autorisatie-URL in';
$hesklang['oauth_provider_err_token_url']='Vul een geldige token-URL in.';
$hesklang['oauth_provider_err_client_id']='Vul de klant-ID in.';
$hesklang['oauth_provider_err_client_secret']='Vul het klantgeheim in.';
$hesklang['oauth_provider_err_scope']='Vul het bereik in.';
$hesklang['oauth_provider_deleted']='OAuth-provider verwijderd.';
$hesklang['oauth_provider_not_found']='Deze OAuth-provider bestaat niet.';
$hesklang['oauth_provider_verified']='Geverifieerd.';
$hesklang['oauth_provider_click_to_verify']='Klik om te verifiëren';
$hesklang['can_due_date']='Kan de vervaldatum instellen'; // Permission to set and modify due date
$hesklang['can_due_date_e']='Je hebt geen toestemming om vervaldatums in te stellen.';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Verify Your Registration';
$hesklang['customer_verify_new_email']='Verify Your New Email Address';
$hesklang['customer_reset_password']='Reset your help desk password';
$hesklang['customer_approved']='Account Approved';
$hesklang['customer_rejected']='Account Rejected';
$hesklang['email_rejected']='Account required to submit support tickets';
$hesklang['require_curl']='This functionality requires <strong>cURL</strong> support for PHP enabled on your server. Please ask your web host to enable cURL for PHP.';
$hesklang['customer_accounts_heading']='Customer Accounts';
$hesklang['customer_accounts']='Customer accounts';
$hesklang['customer_accounts_off']='<strong>Disabled</strong>';
$hesklang['customer_accounts_allowed']='<strong>Enabled - Optional</strong> (customers can submit support tickets without registering or logging in)';
$hesklang['customer_accounts_required_to_submit']='<strong>Enabled - Required for tickets</strong> (only logged-in customers can submit support tickets)';
$hesklang['customer_accounts_required']='<strong>Enabled - Required to access</strong> (only logged-in customers can access the help desk and knowledgebase)';
$hesklang['customer_accounts_reg']='Account registration';
$hesklang['customer_accounts_reg_customer']='Customers can register accounts';
$hesklang['customer_accounts_reg_approve']='Customers can register account, staff must approve new registrations';
$hesklang['customer_accounts_reg_staff']='Only staff can register customer accounts';
$hesklang['customer_accounts_allow_email_changes']='Allow customers to change their email address';
$hesklang['customer_accounts_allow_email_resends']='Time until customers can request new verification email';
$hesklang['customer_login']='Login';
$hesklang['customer_logout']='Logout';
$hesklang['customer_register']='Register';
$hesklang['customer_accounts_disabled']='Customer logins and registrations are disabled.';
$hesklang['customer_accounts_registration_disabled']='Customer registrations are disabled.';
$hesklang['customer_forgot_password']='Forgot password?';
$hesklang['customer_email']='Email Address';
$hesklang['customer_accounts_email_banned']='You have been banned from using this helpdesk.';
$hesklang['customer_registration_successful']='Registration Successful!';
$hesklang['customer_registration_email_exists_no_reset_link']='An account with email %s already exists.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='An account with email %s already exists. <a href="login.php">Do you wish to log in instead</a>?'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='An account with email %s already exists and is pending email verification.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='An account with email %s already exists and is pending staff approval.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='Check Your Email!';
$hesklang['customer_registration_check_your_email_content']='You must verify your email address before being able to log in.<br><br>If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_login_not_verified']='You must verify your email address before being able to log in.';
$hesklang['customer_login_not_verified2']='If you did not receive the verification email from us, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_login_resend_verification_email']='Re-send verification email';
$hesklang['customer_login_resend_verification_email_none']='There are no pending email verifications to send.';
$hesklang['customer_login_resend_verification_email_too_early']='You cannot request a new verification email at this time, please try again later.';
$hesklang['customer_login_not_approved']='A member of staff must approve your account before being able to log in. Once approved, you will be notified via email.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Verify Registration';
$hesklang['customer_registration_verify_success']='Your email has been verified and you may now log in using the form below.';
$hesklang['customer_registration_verify_approval_needed']='Your email has been verified. However, a member of staff must approve your account before being able to log in. Once approved, you will be notified via email.';
$hesklang['customer_registration_verify_failure']='Your email could not be verified. Either the link has already been used or has expired.';
$hesklang['emails_to_customers']='&raquo; Emails sent to customers';
$hesklang['emails_to_staff']='&raquo; Emails sent to staff';
$hesklang['emails_to_everyone']='&raquo; Emails sent to staff or customers';
$hesklang['new_customer_approval']='You have customer accounts pending approval'; // Email subject
$hesklang['desc_new_customer_approval']='(Staff) Customer accounts pending approval';
$hesklang['n_cust_app']='There are pending customer approvals'; // Notify me when...
$hesklang['et_num_customers']='Number of pending approvals';
$hesklang['et_link_customers']='Link to the Manage customers page';
$hesklang['et_link_verify']='Verification link';
$hesklang['et_cust_login']='Customer login URL';
$hesklang['submit_ticket_customer_email_exists']='A customer with this email already exists. Please <a href="login.php?email=%s">log in</a> to submit a ticket.'; // %s - User's email
$hesklang['customer_login_email_required']='Please enter a valid email address.';
$hesklang['customer_login_password_required']='Please enter your password.';
$hesklang['customer_login_remember_just_email']='Remember just my email';
$hesklang['customer_login_remember_email']='Remember my email';
$hesklang['customer_wrong_user']='Your email address %s is not registered with us.<br><br>Do you wish to <a href="register.php">create an account</a>?'; // %s - Entered email address
$hesklang['customer_wrong_pass']='Your email address and password do not match our records.<br><br>Do you wish to <a href="login.php?submittedForgot=1">reset your password</a>?';
$hesklang['customer_must_be_logged_in_to_view']='Please log in to continue.';
$hesklang['customer_register_here']='If you don\'t have an account with us, you can <a href="register.php">register here</a>.';
$hesklang['create_account']='Create an account';
$hesklang['customer_my_tickets_heading']='My tickets';
$hesklang['customer_my_tickets_description']='View all of your previous tickets';
$hesklang['customer_my_tickets_search_for_tickets']='Search for tickets';
$hesklang['customer_password_reset_successful']='Your new password has been saved. You may now log in.';
$hesklang['customer_profile']='Profile';
$hesklang['customer_edit_profile']='Edit Profile';
$hesklang['customer_edit_pass']='Edit Password';
$hesklang['customer_edit_pass_same']='Your new password must not be the same as your current one.';
$hesklang['customer_change_email']='Change Email';
$hesklang['customer_change_email_banned']='The email you entered is banned.';
$hesklang['customer_change_email_pending']='There is a current request to change your email address to: <b>%s</b><br><br>We have sent an email to this address. Please click the link inside the email to confirm the change.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Re-send confirmation email</a>';
$hesklang['customer_change_email_submitted']='Please click the verification link that was sent to <b>%s</b> to verify your new email.'; // %s - new email
$hesklang['customer_change_email_verify_success']='Your new email address has been verified and your profile updated.';
$hesklang['customer_change_email_disabled']='The ability to update your email is disabled. Contact us if you wish to change your email address.';
$hesklang['customer_profile_saved']='Your profile has been saved.';
$hesklang['customers']='Customers';
$hesklang['customers_intro']='Customer accounts allow customers to view all of their tickets in a central location.';
$hesklang['sure_remove_customer']='Are you sure you want to remove this customer?';
$hesklang['sure_remove_customer_additional_note']='Deleting a customer is final.  Once deleted, they cannot be recovered!';
$hesklang['new_customer']='New Customer';
$hesklang['new_follower']='New Follower';
$hesklang['add_customer']='+ Add Customer'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Add Follower'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='The provided customer does not yet exist. Click "Save" if you would like to create this customer.';
$hesklang['followers']='Followers';
$hesklang['no_customers']='There are currently no customers in the database.';
$hesklang['no_customers_disabled']='You will start seeing customers here when they submit support tickets.';
$hesklang['no_customers_enabled']='You will start seeing customers here when they register or submit support tickets.';
$hesklang['no_customers_enabled2']='Alternatively, the buttons above this message allow you to manually create customer accounts or import existing customers into the help desk.';
$hesklang['import_customers']='Import Customers';
$hesklang['import_customers_tip']='Use a CSV file to import multiple customers at once.';
$hesklang['customer_not_found']='Customer not found for ticket!';
$hesklang['search_by_name_or_email']='Search by name or email...';
$hesklang['search_by_pattern']='Search by pattern...';
$hesklang['is_searchable']='Searchable';
$hesklang['custom_is_searchable']='Searchable';
$hesklang['yes_via_autocomplete']='YES (search via autocomplete)';
$hesklang['customer_required']='You must select a customer';
$hesklang['customer_email_exists']='A customer with this email already exists.';
$hesklang['customer_name_with_no_email_exists']='A customer with this name and no email already exists.';
$hesklang['an_error_occurred_validating_email']='An error occurred when attempting to verify the entered email address.';
$hesklang['customer_count_x_more']='+%s more'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Registered';
$hesklang['customer_account_verified']='Verified';
$hesklang['customer_account_verified_help']='Customers must verify their account via an activation link sent to their email address before being able to log into their account.';
$hesklang['customer_account_setting_password_will_verify_user']='Setting a password for this customer will automatically verify their account.';
$hesklang['deleting_customer_with_tickets']='This customer has %1$s ticket(s) <b>(%2$s open)</b> that also have other customers associated with them.<br>What should be done with these tickets?'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='A valid email address is needed to re-send a verification email.';
$hesklang['customer_resend_verification_email_not_found']='No account exists with this email address, or the account has already been verified.';
$hesklang['customer_resend_verification_email_sent']='A verification email has been sent to your email address.<br><br>If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_permission_denied']='You do not have permission to modify customers.';
$hesklang['customer_manage_approvals']='Customer accounts pending approval: <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Approve customer';
$hesklang['customer_manage_bulk_approve']='Approve Selected Customers';
$hesklang['customer_manage_bulk_approve_complete']='Customers approved: %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Reject customer';
$hesklang['customer_manage_bulk_reject']='Reject Selected Customers';
$hesklang['customer_manage_bulk_reject_complete']='Customers rejected: %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Delete customer';
$hesklang['customer_manage_bulk_delete']='Delete Selected Customers';
$hesklang['customer_manage_bulk_delete_complete']='Customers deleted: %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Edit customer';
$hesklang['customer_manage_verification_email_sent']='Verification email has been sent to %s'; // %s = customer's email
$hesklang['can_man_customers']='Manage customers';
$hesklang['can_view_customers']='View all customers (but not manage them)';
$hesklang['import_customer_select_file']='Select File';
$hesklang['import_customer_step1_instructions']='To import customers, prepare a CSV (Comma-Separated Values) file.';
$hesklang['import_customer_step1_note']='Select Your CSV File';
$hesklang['import_customer_step1_separator']='Columns in my CSV file are separated by';
$hesklang['import_customer_sample']='&raquo; Sample CSV files';
$hesklang['import_customer_sample_1']='US-style CSV file with columns separated by ,';
$hesklang['import_customer_sample_2']='EU-style CSV file with columns separated by ;';
$hesklang['import_customer_upload_requirements_1']='Your CSV file must include at least a name or an email address column. The password column is optional.';
$hesklang['import_customer_upload_requirements_2']='The first row of your file must contain column headers.';
$hesklang['import_customer_upload_requirements_3']='Your file must be encoded in UTF-8.';
$hesklang['import_customer_select_columns']='Select Columns';
$hesklang['import_customer_upload_customers']='Upload Customers';
$hesklang['import_customer_column_name']='Name Column';
$hesklang['import_customer_column_email']='Email Column';
$hesklang['import_customer_column_pass']='Password Column';
$hesklang['import_customer_step2_note']='Select the correct column name from your CSV file in the dropdowns, and then click "Next".';
$hesklang['import_customer_name_or_email_required']='Name or email is required';
$hesklang['import_customer_step3_note']='Your customers are being imported. Do not leave this page!';
$hesklang['import_customer_step3_pending']='Pending';
$hesklang['import_customer_step3_successful_imports']='Successful Imports';
$hesklang['import_customer_step3_failed_imports']='Failed Imports';
$hesklang['import_customer_step3_progress']='Progress';
$hesklang['import_customer_step3_complete_some_failed']='The import process is complete, however <b>%s</b> customers failed to import. Check the table below for more information.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='The import process is complete!';
$hesklang['import_customer_step3_importing']='Importing';
$hesklang['staff_deleted']='[Staff Deleted]';
$hesklang['customer_account_approved']='Customer registration approved';
$hesklang['customer_account_rejected']='Customer registration rejected';
$hesklang['customer_account_deleted']='Customer registration deleted';
$hesklang['ticket_followers']='Ticket followers';
$hesklang['ticket_followers2']='Allow tickets to have multiple customers';
$hesklang['add_cc']='Add Cc';
$hesklang['cc']='Cc';
$hesklang['cc_help']='Separate each email with a comma.';
$hesklang['search_customers']='Search Customers';
$hesklang['page_size']='Page Size';
$hesklang['customers_on_pages']='Number of customers: %d | Number of pages: %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Customer) Reset your password';
$hesklang['desc_customer_verify_registration']='(Customer) Verify your registration';
$hesklang['desc_customer_verify_new_email']='(Customer) Verify your new e-mail';
$hesklang['desc_customer_approved']='(Customer) Account approved';
$hesklang['desc_customer_rejected']='(Customer) Account rejected';
$hesklang['desc_email_rejected_can_self_register']='(Customer) Ticket via email rejected; customer can self-register';
$hesklang['desc_email_rejected_cannot_self_register']='(Customer) Ticket via email rejected; customer cannot self-register';
$hesklang['user_added_success_no_pass']='New user %s has been successfully added';
$hesklang['email_tag_requester']='Requester (From)';
$hesklang['email_tag_requester_name']='Requester (From) Name';
$hesklang['email_tag_requester_first_name']='Requester (From) First Name';
$hesklang['email_tag_requester_email']='Requester (From) Email';
$hesklang['email_tag_followers']='Followers (Cc)';
$hesklang['email_tag_follower_names']='Follower (Cc) Names';
$hesklang['email_tag_follower_emails']='Follower (Cc) Emails';
$hesklang['barcode']='Barcode';
$hesklang['barcode_use']='Display a barcode on printed tickets';
$hesklang['barcode_staff_only']='Hide the barcode from customers';
$hesklang['barcode_type']='Barcode type';
$hesklang['barcode_format']='Format';
$hesklang['barcode_width']='Width';
$hesklang['barcode_height']='Height';
$hesklang['barcode_color']='Color';
$hesklang['barcode_bg']='Background';
$hesklang['copy_link']='Copy ticket link';
$hesklang['copy_link_title']='Copy public link to this ticket';
$hesklang['copy_link_exp']='The copied link is the direct link for the customer to view this ticket';
$hesklang['copy_value']='Copy this value';
$hesklang['download_class']='This function requires the ZipArchive class. Ask your host to compile PHP with zip support.';
$hesklang['download_all']='Download all';
$hesklang['download_prep']='Preparing download...';
$hesklang['download_tma']='Too many attachments';
$hesklang['download_nva']='No valid attachments';
$hesklang['download_ntd']='Nothing to download';
$hesklang['resolved_at']='Resolved at';
$hesklang['disable_GSSAPI']='Disable GSSAPI authenticator (Kerberos error work-around)';
$hesklang['ex_history']='Include ticket history log in export';
$hesklang['sm_location']='Location'; // Location (page) of a service message
$hesklang['loc_sm']='Show this service message on:';
$hesklang['loc_all']='Every customer page';
$hesklang['loc_norec']='(not recommended)';
$hesklang['loc_home']='Help desk homepage';
$hesklang['loc_selected']='On selected pages';
$hesklang['loc_selerr']='Select at least one page to show the message on';
$hesklang['loc_t_cat']='Submit a ticket - select a category';
$hesklang['loc_t_add']='Submit a ticket - submit a ticket form';
$hesklang['loc_t_ok']='Submit a ticket - ticket confirmation';
$hesklang['loc_t_view']='View a ticket';
$hesklang['loc_t_form']='View a ticket form';
$hesklang['loc_kb_main']='Knowledgebase homepage';
$hesklang['loc_kb_sub']='Knowledgebase sub-category pages';
$hesklang['loc_kb_art']='Knowledgebase articles';
$hesklang['loc_login']='Customer login page';
$hesklang['loc_register']='Customer registration page';
$hesklang['loc_register_ok']='Customer registration successful';
$hesklang['loc_acc']='Customer &quot;My tickets&quot; page';
$hesklang['loc_profile']='Customer &quot;Profile&quot; page';
$hesklang['sending_show']='Show &quot;Submitting&quot; notification';
$hesklang['sending_wait']='Submitting, please wait...';
$hesklang['e_c_email']='Enter the correct email address to view this ticket';
$hesklang['only_verified_cc']='Followers without a verified account will be ignored.';
$hesklang['followers_removed']='These email addresses have been removed from the ticket because they do not have a verified account:';
$hesklang['novace']='We did not find any registered and verified accounts with this email address.';
$hesklang['max_recipients']='Max recipients';
$hesklang['max_recipients2']='in a single email';
$hesklang['admin_js']='Admin JS';
$hesklang['admin_js2']='Load an extra custom Javascript file for the admin panel';
$hesklang['cf_limit_all']='You have reached the custom fields limit and cannot create new custom fields.';
$hesklang['remind_assigned']='Remind assigned staff';
$hesklang['remind_sent']='Email reminder to the assigned staff member sent';
$hesklang['thist23']='<li class="smaller">%s | reminder sent to %s by %s</li>';
$hesklang['ql_bookmarks']='Bookmarks';
$hesklang['bookmark']='My Bookmark';
$hesklang['bookmarks_add']='Add to Bookmarks';
$hesklang['bookmarks_added']='This ticket has been added to your Bookmarks';
$hesklang['bookmarks_remove']='Remove from Bookmarks';
$hesklang['bookmarks_removed']='This ticket has been removed from your Bookmarks';
$hesklang['genl_not_copied']='Error: Copying to clipboard not supported on this device/browser.';
$hesklang['profile_duplicate_email']='User with email <b>%s</b> already exists.'; // %s: new email
$hesklang['seq_id_numeric']='Ticket number search must contain numbers only';
$hesklang['confirm_new_pass']='Confirm new password';
$hesklang['piping_notify_rejected_customers1']='Customer rejection emails';
$hesklang['piping_notify_rejected_customers2']='Send a rejection email to customers when their ticket is rejected';
$hesklang['piping_notify_rejected_customers3']='Time between rejection emails';
$hesklang['register_url']='Registration URL';
$hesklang['email_subject']='Email subject';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Collaborating on ticket: %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] Staff replied to: %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] Note added to: %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Ticket overdue: %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Ticket resolved: %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Follow-up email cutoff date:'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='Do not email tickets resolved more than'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='ago (must be longer time period than "%s")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='The email cutoff date period must be longer than the follow-up email delay';
$hesklang['available_language']='Available Languages';
$hesklang['click_to_show_available_language']='Click to show available languages';
$hesklang['install_lan']='Install';
$hesklang['remove_lan']='Remove';
$hesklang['title_lan']='Title';
$hesklang['description_lan']='Description';
$hesklang['completed_lan']='Completed';
$hesklang['no_language_availble']='No languages are available';
$hesklang['success_install_lan_txt']='language has been successfully added';
$hesklang['error_install_lan_txt']='language has not been added';
$hesklang['success_remove_lan_txt']='language has been successfully removed';
$hesklang['error_remove_lan_txt']='language has not been removed';
$hesklang['remove_default_language_error']='The default language must remain active and cannot be removed';
$hesklang['click_for_manual_step']='Click for Manual installation';
$hesklang['upgrade_lan']='Update';
$hesklang['success_upgrade_lan_txt']='language has been successfully Updated';
$hesklang['error_upgrade_lan_txt']='language has not been Updated';
$hesklang['please_wait']='Please wait...';
$hesklang['add_a_note']='Add a note';
$hesklang['add_a_reply']='Add a reply';
$hesklang['customer_id']='Customer ID';
$hesklang['deleting_customer_tickets']='Tickets opened by customer: <b>%1$s</b><br>What should we do with these tickets?'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Tickets where customer is copied: <b>%1$s</b><br>These will lose this customer as a follower; tickets remain unchanged.'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Permanently delete tickets';
$hesklang['deleting_customer_anonymize_tickets2']='Anonymize tickets (remove messages and personal data)';
$hesklang['deleting_customer_retain_tickets2']='Keep tickets (leave all data intact)';
$hesklang['for_staff']='for help desk staff'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='for customers'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='IMAP Mailbox';
$hesklang['file_attachment_options']='Email Attachment Options';
$hesklang['link_to_attachments_in_emails']='Link to attachments in emails';
$hesklang['add_attachments_directly_to_emails']='Add attachments directly to emails';
$hesklang['directly_attach_file_smaller_than']='Directly attach only files smaller than';
$hesklang['directly_attach_file_of_any_size']='Directly attach files of any size';
$hesklang['directly_attach_only_first_x_attachments']='Directly attach only first';
$hesklang['directly_attach_all_attachments']='Directly attach all attachments';
$hesklang['directly_attach_size']='Attachment size';
$hesklang['directly_attach_no_of_files']='Number of files';
$hesklang['notice_about_directly_attach_files']='Attaching many or large files to emails may case delays when communicating with your SMTP server';
$hesklang['fatt_2']='Additional files attached to this message:';
$hesklang['no_collaborators']='None';
$hesklang['collaborate']='Collaborate on this ticket';
$hesklang['collaborators']='Collaborators';
$hesklang['ql_cbm']='Collaborator';
$hesklang['collaborating']='You are now collaborating on this ticket';
$hesklang['not_collaborating']='You are not collaborating on this ticket anymore';
$hesklang['add_collaborator']='Add a collaborator';
$hesklang['user_collaborator_added']='User added as a collaborator on this ticket';
$hesklang['remove_collaborator']='Remove collaborator';
$hesklang['staff_name']='Staff name';
$hesklang['user_collaborator_removed']='User removed as a collaborator on this ticket';
$hesklang['desc_collaborator_added']='(Staff) You are collaborating on a new ticket';
$hesklang['desc_collaborator_staff_reply']='(Staff) A staff member responded to a collaborated ticket';
$hesklang['desc_collaborator_note']='(Staff) New note added to a collaborated ticket';
$hesklang['desc_collaborator_resolved']='(Staff) A collaborated ticket has been resolved';
$hesklang['desc_collaborator_overdue']='(Staff) A collaborated ticket is overdue';
$hesklang['notify_collaborator_added']='I am added as a ticket collaborator';
$hesklang['notify_collaborator_customer_reply']='Customer responds to a collaborated ticket';
$hesklang['notify_collaborator_staff_reply']='Staff responds to a collaborated ticket';
$hesklang['notify_collaborator_note']='Staff adds a note to a collaborated ticket';
$hesklang['notify_collaborator_resolved']='Staff resolves a collaborated ticket';
$hesklang['notify_collaborator_overdue']='Collaborated ticket is overdue';
$hesklang['recurring_tickets']['tab']='Recurring Tickets'; // Menu link
$hesklang['recurring_tickets']['page_title']='Recurring Tickets'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Automate the busywork; let Hesk raise routine tickets for you, exactly when you need them.';
$hesklang['recurring_tickets']['active_rules']='Active rules';
$hesklang['recurring_tickets']['new']='New recurring ticket rule';
$hesklang['recurring_tickets']['no_rules']='You do not have any recurring ticket rules. Create one by clicking the &quot;New recurring ticket rule&quot; button above.';
$hesklang['recurring_tickets']['title']='Rule title';
$hesklang['recurring_tickets']['titlet']='A descriptive title, for example: Re-assign tickets not replied to within a day';
$hesklang['recurring_tickets']['default_title']='Rule by %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Rule trigger';
$hesklang['recurring_tickets']['trigt']='Set the condition that will trigger (run) this rule.';
$hesklang['recurring_tickets']['hits']='Hits'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Creation Time'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='General Settings'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Custom Fields'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Content'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='Delete this rule?';
$hesklang['recurring_tickets']['edit']='Editing recurring ticket rule ID %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='Within:';
$hesklang['recurring_tickets']['minutes']='minutes';
$hesklang['recurring_tickets']['hours']='hours';
$hesklang['recurring_tickets']['days']='days';
$hesklang['recurring_tickets']['weeks']='weeks';
$hesklang['recurring_tickets']['months']='months';
$hesklang['recurring_tickets']['years']='years';
$hesklang['recurring_tickets']['setpri']='Set priority to:';
$hesklang['recurring_tickets']['setsta']='Set status to:';
$hesklang['recurring_tickets']['assto']='Assign ticket to:';
$hesklang['recurring_tickets']['asm']='Another staff member';
$hesklang['recurring_tickets']['notify']='Notify staff members...';
$hesklang['recurring_tickets']['ato']='Apply to:';
$hesklang['recurring_tickets']['save']='Save rule';
$hesklang['recurring_tickets']['e_tt']='Time should be between 1 and 10000';
$hesklang['recurring_tickets']['nocat']='Select at least one category';
$hesklang['recurring_tickets']['nouser']='Select at least one user';
$hesklang['recurring_tickets']['nostatus']='Select at least one status';
$hesklang['recurring_tickets']['nocata']='%1$s doesn\'t have access to these categories:'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='New rule has been created';
$hesklang['recurring_tickets']['mdf']='Rule settings have been saved';
$hesklang['recurring_tickets']['e_id']='No rule with this ID found';
$hesklang['recurring_tickets']['deleted']='Selected rule has been deleted';
$hesklang['recurring_tickets']['log_title']='Rule #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Active'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Activate this rule (start using it)';
$hesklang['recurring_tickets']['activated']='Selected rule has been activated'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='Deactivate this rule (stop using it)';
$hesklang['recurring_tickets']['deactivated']='Selected rule has been deactivated'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='No active recurring ticket rules';
$hesklang['recurring_tickets']['tools']='Tools';
$hesklang['recurring_tickets']['tbef']='Before a rule is live, you need to activate it by clicking the checkbox in the &quot;ACTIVE&quot; column.<br><br>
                               <strong>Active rules are processed every %2$s minutes.</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[RULE]';
$hesklang['recurring_tickets']['r2']='[RULE] Rule #%s';
$hesklang['recurring_tickets']['r3']='Rule #%s';
$hesklang['recurring_tickets']['i']='[INFO]';
$hesklang['recurring_tickets']['matched']='Number of tickets already created today: %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Reset this rule';
$hesklang['recurring_tickets']['reset2']='Are you sure you want to reset this rule?<br><br>Rule hits will go to 0 and any tickets already generated for it today, might be re-generated on next cron run.';
$hesklang['recurring_tickets']['reset3']='Selected rule has been reset';
$hesklang['recurring_tickets']['test']='Simulate this rule';
$hesklang['recurring_tickets']['testa']='Simulate all rules';
$hesklang['recurring_tickets']['testaa']='Simulate all active rules';
$hesklang['recurring_tickets']['testr']='Simulation results';
$hesklang['recurring_tickets']['rsim']='Repeat simulation';
$hesklang['recurring_tickets']['sim']='SIMULATION MODE, no changes to the database';
$hesklang['recurring_tickets']['sic']='SIMULATION COMPLETE';
$hesklang['recurring_tickets']['rrule_type_required']='Please select a valid recurring rule trigger.';
$hesklang['recurring_tickets']['rrule_string_required']='Please select all required recurring rule trigger options.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Please enter an interval value of 1 or bigger for "Every".';
$hesklang['recurring_tickets']['disable_note']='*If any critical hesk settings are changed after creation of a rule, it will be disabled on next run attempt and needs to be edited to pass new validation requirements.';
$hesklang['recurring_tickets']['thist1']='<li class="smaller">%1$s | submitted by Recurring Tickets Rule "%2$s"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class="smaller">%1$s | assigned to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class="smaller">%1$s | closed automatically by Recurring Tickets Rule "%2$s"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class="smaller">%1$s | status changed to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class="smaller">%1$s | automatically assigned to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='Rule was disabled due to validation errors. Check below for details.';
$hesklang['recurring_tickets']['errors_title']='One or more of your rules have produced errors when they attempted to be ran and were disabled.';
$hesklang['recurring_tickets']['rule_errors']='<hr>Rule #%s errors:';
$hesklang['recurring_tickets']['create_customers']='There are no existing customers - please create them <a href="%s" target="_blank">here</a>.';
$hesklang['recurring_tickets']['exec_dates']='Rule execution dates';
$hesklang['recurring_tickets']['show_exec_dates']='[Show current rule execution dates]';
$hesklang['recurring_tickets']['no_exec_dates']='Please select valid rule triggers to see execution dates.';
$hesklang['recurring_tickets']['invalid_disabled']='invalid Rrule settings - rule disabled.';
$hesklang['recurring_tickets']['next_occ']='Next %s rule occurrences:';
$hesklang['recurring_tickets']['occ_on']='on %s';
$hesklang['recurring_tickets']['not_firing_today']='does not need firing today.';
$hesklang['recurring_tickets']['rules_fulfilled']='recurring rules fulfilled - ticket created today!';
$hesklang['recurring_tickets']['validation_failed']='validation failed - rule disabled. Details below:';
$hesklang['recurring_tickets']['validation_error']='Validation error:';
$hesklang['recurring_tickets']['processed']='processed.';
$hesklang['recurring_tickets']['created_ticket']='created ticket id: %1$s, trackid: %2$s';
$hesklang['recurring_tickets']['due_date_note']='relative to ticket creation date';
$hesklang['priorities']='Priorities';
$hesklang['priority_intro']='Use this tool to manage ticket priorities for your help desk';
$hesklang['new_priority']='New priority';
$hesklang['edit_priority']='Edit priority';
$hesklang['priority_title']='Title';
$hesklang['can_customers_select_it']='Can customers select this priority?';
$hesklang['selected_by_customer']='Selectable by customers';
$hesklang['err_priority']='Enter the priority title';
$hesklang['priority_added']='A new priority has been added';
$hesklang['priority_e_id']='Invalid priority ID';
$hesklang['priority_mdf']='Priority has been saved';
$hesklang['priority_deleted']='Priority deleted';
$hesklang['priority_not_found']='This priority does not exist';
$hesklang['priority_not_empty']='This priority cannot be deleted because tickets with this priority exist';
$hesklang['click_to_enable_drag_drop']='Click to enable drag-and-drop for the row, then drag the row up or down to re-arrange priorities.';
$hesklang['confirm_delete_priority']='Are you sure you want to delete this priority?';
$hesklang['reordered_message']='Your priority list order has been saved.';
$hesklang['list_tkt_priority']='List all tickets with this priority';
$hesklang['deletion_priority_restricted']='This is a special priortiy and cannot be deleted';
$hesklang['priority_limit']='You cannot create any new priorities';
$hesklang['skip_to_main_content']='Skip to Main Content';
$hesklang['opens_dialog']='Opens a dialog';
$hesklang['create_a_ticket']='Create a ticket';
$hesklang['toggle_navigation']='Toggle navigation';
$hesklang['add_a_ticket_reply']='Add a ticket reply';
$hesklang['linked_tickets']='Linked tickets';
$hesklang['no_linked_tickets']='No linked tickets';
$hesklang['link_ticket']='Link ticket';
$hesklang['can_link_tickets_e']='You are not authorized to link/unlink this ticket';
$hesklang['link_ticket_success']='The ticket has been linked successfully';
$hesklang['link_ticket_required_error']='To link a ticket, please provide a valid Tracking ID';
$hesklang['link_ticket_itself_error']='A ticket cannot be linked to itself. Please enter a different Tracking ID';
$hesklang['already_linked_error']='The ticket has already been linked';
$hesklang['unlink_success']='The ticket has been successfully unlinked';
$hesklang['unlink_error']='No linked record exists';
$hesklang['link_history']='<li class="smaller">%s | %s ticket linked by %s</li>';
$hesklang['unlink_history']='<li class="smaller">%s | %s ticket unlinked by %s</li>';
$hesklang['can_link_tickets']='Can link ticket';
$hesklang['link_a_ticket']='Link a ticket';
$hesklang['mfa_curl']='Unable to generate a QR image to scan because <strong>cURL</strong> support is not enabled on your server.';
$hesklang['require_xml']='PHP-XML must be enabled for Rich Text (HTML) messages. Please ask your web host to enable XML for PHP.';
$hesklang['thist24']='<li class="smaller">%1$s | %2$s added as a collaborator by %3$s</li>';
$hesklang['thist25']='<li class="smaller">%1$s | %2$s removed as a collaborator by %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Perfect for preventive-maintenance jobs, monthly access reviews, recurring customer check-ins, and more.';
$hesklang['recurring_tickets']['feat1']='<strong>Set and forget schedules.</strong> Daily, every Monday, every March, the 15th of each month, or any future date';
$hesklang['recurring_tickets']['feat2']='<strong>Arrive pre-filled and assigned.</strong> Choose category, priority, agent, and up to 100 custom field values';
$hesklang['recurring_tickets']['feat3']='<strong>Preview dates and Simulate.</strong> See every ticket Hesk will generate before activating a rule, so there are no surprises.';
$hesklang['unlink_btn']='Unlink';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');