<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Suomi (Finnish)
* Version: 3.6.x
*
* ==> CONTRIBUTORS
*
* Pia Kontiainen
* Hermanni Piirainen
* Tapio Nurminen
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Suomi';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='Finnish';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_unicode_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Vastaa tämän viivan yläpuolelle ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Uusi tiketti: %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Tiketti vastaanotettu: %%SUBJECT%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Tiketti osoitettu: %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Uusi vastaus: %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Uusi vastaus: %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Tiketti siirretty: %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Merkintä lisätty: %%SUBJECT%%';
$hesklang['new_pm']='Uusi yksityisviesti: %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Lista tiketeistäsi';

// ERROR MESSAGES
$hesklang['cant_connect_db']='Tietokantaan ei saatu yhteyttä!';
$hesklang['invalid_action']='Virheellinen toiminto';
$hesklang['select_username']='Ole hyvä ja valitse käyttäjätunnuksesi';
$hesklang['enter_pass']='Ole hyvä ja anna salasanasi';
$hesklang['cant_sql']='SQL:ää ei voitu suorittaa';
$hesklang['contact_webmsater']='Ota yhteyttä webmasteriin:';
$hesklang['mysql_said']='MySQL ilmoitti';
$hesklang['wrong_pass']='Väärä salasana.';
$hesklang['session_expired']='Istuntosi on vanhentunut, kirjaudu sisään alla olevalla lomakkeella.';
$hesklang['attempt']='Virheellinen yritys!';
$hesklang['not_authorized_tickets']='Sinulla ei ole oikeuksia tarkastella tämän kategorian tikettejä!';
$hesklang['must_be_admin']='Sinulla ei ole oikeuksia tarkastella tätä sivua! Tarkastellaksesi tätä sivua sinun on oltava kirjautuneena sisään ylläpitäjänä.';
$hesklang['no_session']='Ei voitu aloittaa uutta sessiota!';
$hesklang['error']='Virhe';
$hesklang['int_error']='Sisäinen komentosarjavirhe';
$hesklang['no_trackID']='Ei seurantatunnusta';
$hesklang['status_not_valid']='Virheellinen tila';
$hesklang['trackID_not_found']='Seurantatunnusta ei löytynyt';
$hesklang['enter_message']='Ole hyvä ja kirjoita viestisi';
$hesklang['select_priority']='Ole hyvä ja valitse prioriteetti';
$hesklang['ticket_not_found']='Tikettiä ei löytynyt! Varmista, että annoit oikean seurantatunnuksen!';
$hesklang['no_selected']='Ei yhtään tikettiä valittuna, ei muutettavaa.';
$hesklang['id_not_valid']='ID ei kelpaa';
$hesklang['enter_id']='Ole hyvä ja anna seurantatunnus';
$hesklang['enter_name']='Ole hyvä ja anna asiakkaan nimi';
$hesklang['enter_date']='Ole hyvä ja anna päivämäärä, jonka haluat etsiä';
$hesklang['date_not_valid']='Päivämäärä ei kelpaa. Anna päivämäärä muodossa <b>VVVV-KK-PP</b>.';
$hesklang['enter_subject']='Ole hyvä ja kirjoita tiketin aihe';
$hesklang['invalid_search']='Virheellinen hakutoiminto';
$hesklang['choose_cat_ren']='Valitse kategoria uudelleen nimettäväksi';
$hesklang['cat_ren_name']='Ole hyvä ja kirjoita uuden kategorian nimi';
$hesklang['cat_not_found']='Kategoriaa ei löytynyt';
$hesklang['enter_cat_name']='Ole hyvä ja anna kategorian nimi';
$hesklang['no_cat_id']='Ei kategoriatunnusta';
$hesklang['cant_del_default_cat']='Et voi poistaa oletuskategoriaa, voit vain nimetä sen uudelleen';
$hesklang['no_valid_id']='Virheellinen käyttäjätunnus';
$hesklang['user_not_found']='Käyttäjää ei löytynyt';
$hesklang['enter_real_name']='Ole hyvä ja anna käyttäjän oikea nimi';
$hesklang['enter_valid_email']='Ole hyvä ja anna voimassaoleva sähköpostiosoite';
$hesklang['enter_username']='Ole hyvä ja anna käyttäjätunnus';
$hesklang['asign_one_cat']='Ole hyvä ja aseta käyttäjä vähintään yhteen kategoriaan!';
$hesklang['signature_long']='Käyttäjän allekirjoitus on liian pitkä! Rajoita allekirjoitus 1000 merkkiin';
$hesklang['confirm_user_pass']='Ole hyvä ja vahvista salasana';
$hesklang['passwords_not_same']='Syötetyt salasanat eivät täsmää!';
$hesklang['cant_del_admin']='Et voi poistaa oletusylläpitäjää!';
$hesklang['cant_del_own']='Et voi poistaa profiilia, jolla olet kirjautuneena!';
$hesklang['enter_your_name']='Ole hyvä ja anna nimesi';
$hesklang['sel_app_cat']='Ole hyvä ja valitse sopiva kategoria';
$hesklang['sel_app_priority']='Ole hyvä ja valitse sopiva prioriteetti';
$hesklang['enter_ticket_subject']='Ole hyvä ja anna tiketin aihe';
$hesklang['user_not_found_nothing_edit']='Käyttäjää ei löytynyt tai ei mitään muutettavaa';

// ADMIN PANEL
$hesklang['administrator']='Ylläpitäjä';
$hesklang['login']='Kirjaudu';
$hesklang['user']='Käyttäjä';
$hesklang['username']='Käyttäjätunnus';
$hesklang['pass']='Salasana';
$hesklang['confirm_pass']='Vahvista salasana';
$hesklang['logged_out']='Kirjautunut ulos';
$hesklang['logout']='Kirjaudu ulos';
$hesklang['logout_success']='Sinut on onnistuneesti kirjattu ulos!';
$hesklang['click_login']='Klikkaa tästä kirjautuaksesi';
$hesklang['back']='Palaa';
$hesklang['displaying_pages']='Näytetään <b>%d</b> tikettiä. Sivut:';
$hesklang['trackID']='Seurantatunnus';
$hesklang['timestamp']='Aikaleima';
$hesklang['name']='Nimi';
$hesklang['subject']='Aihe';
$hesklang['status']='Tila';
$hesklang['priority']='Prioriteetti';
$hesklang['open']='Uusi';
$hesklang['open_action']='Avaa tiketti'; // Open ACTION
$hesklang['close']='Suljettu'; // Closed ticket STATUS
$hesklang['any_status']='Mikä tahansa tila';
$hesklang['high']='Korkea';
$hesklang['medium']='Keskinkertainen';
$hesklang['low']='Matala';
$hesklang['del_selected']='Poista valitut tiketit';
$hesklang['manage_cat']='Ylläpidä kategorioita';
$hesklang['profile']='Profiilisi';
$hesklang['show_tickets']='Näytä tiketit';
$hesklang['sort_by']='Järjestä';
$hesklang['date_posted']='Lähetyspäivämäärä';
$hesklang['category']='Kategoria';
$hesklang['any_cat']='Mikä tahansa kategoria';
$hesklang['order']='Järjestys';
$hesklang['ascending']='nouseva';
$hesklang['descending']='laskeva';
$hesklang['display']='Näytä';
$hesklang['tickets_page']='tikettiä sivulla';
$hesklang['find_ticket']='Etsi tiketti';
$hesklang['yyyy_mm_dd']='VVVV-KK-PP';
$hesklang['results_page']='tulosta sivulla';
$hesklang['opened']='avattu'; // The ticket has been OPENED
$hesklang['closed']='suljettu'; // Ticket has been RESOLVED
$hesklang['ticket']='Tiketti';
$hesklang['tickets']='Tiketit';
$hesklang['ticket_been']='Tämä tiketti on';
$hesklang['view_ticket']='Näytä tiketit';
$hesklang['open_tickets']='Avoimet tiketit';
$hesklang['remove_statement']='Poista &quot;Powered by&quot;-lauseke';
$hesklang['click_info']='Klikkaa tästä lisätietoja varten';
$hesklang['reply_added']='Vastaus lisätty';
$hesklang['reply_submitted']='Vastaus lähetetty';
$hesklang['ticket_marked']='Tämä tiketti on merkitty';
$hesklang['ticket_status']='Tiketin tila';
$hesklang['replies']='Vastaukset';
$hesklang['date']='Päivämäärä';
$hesklang['email']='Sähköposti';
$hesklang['ip']='IP';
$hesklang['message']='Viesti';
$hesklang['add_reply']='Lisää vastaus';
$hesklang['close_this_ticket']='Sulje tämä tiketti';
$hesklang['change_priority']='Vaihda prioriteetti';
$hesklang['attach_sign']='Liitä allekirjoitus';
$hesklang['profile_settings']='Profiilin asetukset';
$hesklang['submit_reply']='Lähetä vastaus';
$hesklang['support_panel']='Tukipaneeli';
$hesklang['ticket_trackID']='Tiketin seurantatunnus';
$hesklang['c2c']='Klikkaa jatkaaksesi';
$hesklang['tickets_deleted']='Tiketit poistettu';
$hesklang['num_tickets_deleted']='<b>%d</b> tikettiä poistettu';
$hesklang['confirm_del_cat']='Oletko varma, että haluat poistaa tämän kategorian?';
$hesklang['cat_intro']='Täällä voit muokata kategorioita. Kategoriat ovat hyödyllisiä tikettien luokitteluun (esimerkiksi &quot;Myynti&quot;,
&quot;Huolto&quot;, &quot;PHP/MySQL-ongelmat&quot; jne.) ja asettaessa käyttäjiä tiettyihin kategorioihin (esimerkiksi myyntihenkilö voi tarkastella vain tikettejä, jotka on osoitettu kategoriaan &quot;Myynti&quot;)';
$hesklang['cat_name']='Kategorian nimi';
$hesklang['remove']='Poista';
$hesklang['add_cat']='Lisää uusi kategoria';
$hesklang['max_chars']='max 40 merkkiä';
$hesklang['create_cat']='Luo kategoria';
$hesklang['ren_cat']='Uudelleennimeä kategoria';
$hesklang['to']='asti';
$hesklang['cat_added']='Kategoria lisätty';
$hesklang['cat_name_added']='Kategoria %s on lisätty onnistuneesti';
$hesklang['cat_renamed']='Kategoria uudelleennimetty';
$hesklang['cat_renamed_to']='Valittu kategoria on uudelleennimetty onnistuneesti nimellä';
$hesklang['cat_removed']='Kategoria poistettu';
$hesklang['cat_removed_db']='Valittu kategoria on poistettu tietokannasta onnistuneesti';
$hesklang['sure_remove_user']='Oletko varma, että haluat poistaa tämän käyttäjän?';
$hesklang['manage_users']='Ylläpidä käyttäjiä';
$hesklang['users_intro']='Täällä voit ylläpitää käyttäjiä, jotka voivat kirjautua ylläpitopaneeliin ja 
vastata tiketteihin. Ylläpitäjät voivat tarkastella/muokata minkä tahansa kategorian tikettejä ja heillä on oikeudet kaikkiin ylläpitopaneelin toimintoihin (ylläpidä käyttäjiä, kategorioita jne.),
kun taas muut käyttäjät voivat tarkastella ja vastata vain omien kategorioidensa tiketteihin.';
$hesklang['yes']='KYLLÄ';
$hesklang['no']='EI';
$hesklang['edit']='Muokkaa';
$hesklang['add_user']='Lisää uusi käyttäjä';
$hesklang['req_marked_with']='Pakolliset kentät on merkitty';
$hesklang['real_name']='Oikea nimi';
$hesklang['signature_max']='Allekirjoitus (max 1000 merkkiä)';
$hesklang['sign_extra']='HTML-koodi ei ole sallittu. Linkeistä tulee klikattavia.';
$hesklang['create_user']='Luo käyttäjä';
$hesklang['editing_user']='Muokataan käyttäjää';
$hesklang['user_added']='Käyttäjä lisätty';
$hesklang['user_added_success']='Uusi käyttäjä %s salasanalla %s on lisätty onnistuneesti';
$hesklang['profile_updated']='Profiili päivitetty';
$hesklang['profile_updated_success']='Tämä profiili on päivitetty onnistuneesti';
$hesklang['user_removed']='Käyttäjä poistettu';
$hesklang['sel_user_removed']='Valittu käyttäjä on onnistuneesti poistettu tietokannasta';
$hesklang['profile_for']='Profiili:';
$hesklang['new_pass']='Uusi salasana';
$hesklang['update_profile']='Päivitä profiili';
$hesklang['notify_new_posts']='Ilmoita minulle uusista tiketeistä ja viesteistä omissa kategorioissani';
$hesklang['view_profile']='Näytä profiili';
$hesklang['new_ticket_submitted']='Uusi tiketti jätetty';
$hesklang['user_profile_updated_success']='Tämän käyttäjän profiili on päivitetty onnistuneesti';
$hesklang['printer_friendly']='Tulostusversio';
$hesklang['end_ticket']='--- Tukipyynnön loppu ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='Tikettisi on';
$hesklang['view_your_ticket']='Näytä tikettisi';
$hesklang['submit_ticket']='Lähetä tiketti';
$hesklang['sub_ticket']='Lähetä tiketti';
$hesklang['before_submit']='Ennen lähettämistä varmista seuraavat seikat';
$hesklang['all_info_in']='Kaikki tarpeelliset tiedot on täytetty';
$hesklang['all_error_free']='Kaikki tiedot ovat oikein';
$hesklang['we_have']='Olemme';
$hesklang['recorded_ip']='tallentaneet IP-osoitteeksesi';
$hesklang['recorded_time']='tallentaneet lähetyksesi ajankohdan';
$hesklang['save_changes']='Tallenna muutokset';
$hesklang['reply_submitted_success']='Vastauksesi tikettiin on lähetetty onnistuneesti';
$hesklang['ticket_submitted']='Tiketti lähetetty';
$hesklang['ticket_submitted_success']='Tikettisi on lähetetty onnistuneesti! Seurantatunnus';
$hesklang['your_ticket']='Tikettisi';

// Added in version 0.94
$hesklang['check_updates']='Varmista aina, että uusin versio Hesk:stä on asennettuna!';
$hesklang['check4updates']='Tarkista päivitykset';
$hesklang['wait_reply']='Odottaa vastausta';
$hesklang['replied']='Vastattu';
$hesklang['last_replier']='Viimeisin vastaaja';
$hesklang['staff']='Henkilökunta';
$hesklang['customer']='Asiakas';
$hesklang['close_selected']='Merkitse valitut tiketit ratkaistuiksi';
$hesklang['execute']='Suorita';
$hesklang['saved_replies']='Tallennetut vastaukset';
$hesklang['manage_saved']='Ylläpidä tallennettuja vastauksia';
$hesklang['manage_intro']='Täällä voit lisätä ja ylläpitää tallennettuja vastauksia. Ne ovat yleisimmin käytettyjä vastauksia useimmille asiakkaille. Voit käyttää tallennettuja vastauksia välttyäksesi kirjoittamasta saman asian aina uudelleen.';
$hesklang['saved_title']='Otsikko';
$hesklang['no_saved']='Ei tallennettuja vastauksia';
$hesklang['delete_saved']='Oletko varma, että haluat poistaa tämän tallennetun vastauksen?';
$hesklang['new_saved']='Lisää tai Muokkaa tallennettua vastausta';
$hesklang['canned_add']='Luo uusi tallennettu vastaus';
$hesklang['canned_edit']='Muokkaa valittua tallennettua vastausta';
$hesklang['save_reply']='Tallenna vastaus';
$hesklang['saved']='Vastaus tallennettu';
$hesklang['your_saved']='Vastauksesi on tallennettu myöhempää käyttöä varten';
$hesklang['ent_saved_title']='Ole hyvä ja kirjoita vastauksen otsikko';
$hesklang['ent_saved_msg']='Ole hyvä ja kirjoita vastauksen viesti';
$hesklang['saved_removed']='Tallennettu vastaus poistettu ';
$hesklang['saved_rem_full']='Valittu tallennettu vastaus on poistettu tietokannasta';
$hesklang['clip_alt']='Tällä viestillä on liitteitä';
$hesklang['attachments']='Liitteet';
$hesklang['fill_all']='Puuttuva pakollinen kenttä';
$hesklang['file_too_large']='Tiedostosi %s on liian iso';
$hesklang['cannot_move_tmp']='Ei voi siirtää tiedostoa liitteet-kansioon';
$hesklang['created_on']='Luotu';
$hesklang['tickets_closed']='Tiketit suljettu';
$hesklang['num_tickets_closed']='<b>%d</b> tikettiä on suljettu';
$hesklang['select_saved']='Valitse tallennettu vastaus';
$hesklang['select_empty']='Valitse / Tyhjennä';
$hesklang['insert_special']='Lisää erikoismerkki (korvataan asiakkaan tiedoilla)';
$hesklang['move_to_catgory']='Siirrä tiketti';
$hesklang['move']='Siirrä';
$hesklang['moved']='Tiketti siirretty';
$hesklang['moved_to']='Tämä tiketti on siirretty uuteen kategoriaan';
$hesklang['url']='URL';
$hesklang['all_not_closed']='Kaikki paitsi suljetut';
$hesklang['chg_all']='Vaihda kaikki';
$hesklang['settings']='Asetukset';
$hesklang['settings_intro']='Käytä tätä työkalua muokataksesi tukipalveluasi. Saadaksesi lisätietoja kaikista asetuksista ja vaihtoehdoista, klikkaa apua-kuvaketta tai lue readme.html-tiedosto.';
$hesklang['all_req']='Kaikki kentät (paitsi disabloidut) vaaditaan!';
$hesklang['wbst_title']='Verkkosivuston otsikko';
$hesklang['wbst_url']='Verkkosivuston URL';
$hesklang['email_wm']='Webmasterin sähköposti';
$hesklang['max_listings']='Tuloksia sivulla';
$hesklang['print_size']='Tulostuksen fonttikoko';
$hesklang['debug_mode']='Virheenetsintätila';
$hesklang['on']='PÄÄLLÄ';
$hesklang['off']='POIS';
$hesklang['use_secimg']='Käytä anti-SPAM-kuvaa';
$hesklang['secimg_no']='Ei saatavilla';
$hesklang['attach_use']='Käytä liitteitä';
$hesklang['attach_num']='Lukumäärä viestiä kohden';
$hesklang['attach_type']='Sallitut tiedostotyypit';
$hesklang['place_after']='Viestin jälkeen';
$hesklang['place_before']='Ennen viestiä';
$hesklang['custom_f']='Räätälöity kenttä';
$hesklang['custom_u']='Käytä tätä kenttää';
$hesklang['custom_n']='Kentän nimi';
$hesklang['custom_l']='Enimmäispituus (merkkiä)';
$hesklang['db_host']='Tietokannan isäntä';
$hesklang['db_name']='Tietokannan nimi';
$hesklang['db_user']='Tietokannan käyttäjätunnus';
$hesklang['db_pass']='Tietokannan salasana';
$hesklang['err_sname']='Anna verkkosivustosi nimi';
$hesklang['err_surl']='Anna verkkosivustosi URL-osoite. Varmista, että URL on validi (alkaa http:// tai https://)';
$hesklang['err_wmmail']='Anna voimassaoleva webmasterin sähköposti';
$hesklang['err_nomail']='Anna voimassaoleva "Älä vastaa"-sähköposti';
$hesklang['err_htitle']='Anna tukipalvelusi otsikko';
$hesklang['err_hurl']='Anna Hesk-kansiosi URL. Varmista, että URL on validi (alkaa http:// tai https://)';
$hesklang['err_lang']='Valitse Heskin kieli';
$hesklang['err_nolang']='Valittua kielitiedostoa ei löytynyt language-kansiosta! Varmista, että olet ladannut tiedoston ennen kielen valitsemista.';
$hesklang['err_max']='Anna listauksen maksimimäärä sivua kohti';
$hesklang['err_psize']='Anna tulostusfontin koko';
$hesklang['err_dbhost']='Anna MySQL-tietokannan isäntä';
$hesklang['err_dbname']='Anna MySQL-tietokannan nimi';
$hesklang['err_dbuser']='Anna MySQL-tietokannan käyttäjätunnus';
$hesklang['err_dbpass']='Anna MySQL-tietokannan salasana';
$hesklang['err_dbconn']='Ei voitu yhdistää MySQL-tietokantaan annetuilla tiedoilla!';
$hesklang['err_dbsele']='MySQL-tietokantaa ei voitu valita, varmista tietokannan NIMI';
$hesklang['err_custname']='Anna nimi/nimet valitulle/valituille valinnaisille kentille';
$hesklang['err_openset']='Ei voitu avata tiedostoa <b>hesk_settings.inc.php</b> kirjoittamista varten. Aseta CHMOD tälle tiedostolle muotoon 666 (rw-rw-rw-)';
$hesklang['set_saved']='Asetukset tallennettu';
$hesklang['set_were_saved']='Asetuksesi on tallennettu onnistuneesti';
$hesklang['sec_img']='Varmistuskuva';
$hesklang['sec_miss']='Anna varmistusnumero';
$hesklang['sec_wrng']='Väärä varmistusnumero';
$hesklang['submit_problems']='Palaa takaisin ja korjaa seuraavat ongelmat';
$hesklang['cat_order']='Kategoriajärjestys';
$hesklang['reply_order']='Tallennetun vastauksen järjestys';
$hesklang['move_up']='Siirrä ylös';
$hesklang['move_dn']='Siirrä alas';
$hesklang['cat_move_id']='Puuttuva kategorian tunnus';
$hesklang['reply_move_id']='Puuttuva tallennetun vastauksen tunnus';
$hesklang['forgot_tid']='Oletko unohtanut seurantatunnuksen?';
$hesklang['tid_send']='Lähetä minulle seurantatunnukseni';
$hesklang['tid_not_found']='Sähköpostiosoitteellasi ei löytynyt yhtään tikettiä';
$hesklang['tid_sent']='Seurantatunnus lähetetty';
$hesklang['tid_sent2']='Sähköposti tikettisi tiedoilla on lähetetty osoitteeseesi';
$hesklang['check_spambox']='Muista tarkistaa myös roskapostikansiosi!';
$hesklang['reply_not_found']='Tallennettua vastausta ei löytynyt';
$hesklang['exists']='On olemassa';
$hesklang['no_exists']='Ei ole olemassa';
$hesklang['writable']='Kirjoitusoikeudet';
$hesklang['not_writable']='Ei kirjoitusoikeuksia';
$hesklang['disabled']='disabloitu';
$hesklang['e_settings']='Et voi tallentaa asetuksia, jollei skriptillä ole tähän tiedostoon kirjoitusoikeuksia. Lisätietoja readme-tiedostosta!';
$hesklang['e_attdir']='Et voi tallentaa liitteitä, ellei attachments-kansiota ole olemassa ja skriptillä siihen kirjoitusoikeuksia.';
$hesklang['e_save_settings']='Ei voitu tallentaa asetuksia, koska skriptillä ei ole kirjoitusoikeuksia tiedostoon <b>hesk_settings.inc.php</b>.';
$hesklang['e_attach']='Disabloitu, koska skripti ei voi kirjoittaa <b>attachments</b>-hakemistoon.';
$hesklang['go']='Mene';

// Added in version 2.0
$hesklang['v']='HESK-versio';
$hesklang['check_status']='Tarkistetaan tilaa';
$hesklang['sub_support']='Lähetä uusi tiketti';
$hesklang['open_ticket']='Lähetä uusi tiketti tukiosastolle';
$hesklang['view_existing']='Näytä olemassa oleva tiketti';
$hesklang['vet']='Tarkastele aiemmin lähettämiäsi tukipyyntöjä';
$hesklang['enter_user']='Anna käyttäjätunnuksesi';
$hesklang['remember_user']='Muista käyttäjätunnukseni';
$hesklang['wrong_user']='Väärä käyttäjätunnus';
$hesklang['no_permission']='Sinulla ei ole oikeuksia suorittaa tätä toimintoa. Kirjaudu sisään käyttäjätunnuksella, jolla on riittävät oikeudet.';
$hesklang['tickets_on_pages']='Tikettejä: %d kappaletta | Sivuja: %d kappaletta'; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']=' | Siirry sivulle:';
$hesklang['no_tickets_open']='Ratkaisemattomia tikettejä ei löytynyt';
$hesklang['no_tickets_crit']='Hakuehtojasi vastaavia tikettejä ei löytynyt';
$hesklang['confirm_execute']='Haluatko varmasti jatkaa?';
$hesklang['legend']='Merkin selitys';
$hesklang['main_page']='Koti';
$hesklang['menu_users']='Käyttäjät';
$hesklang['menu_cat']='Kategoriat';
$hesklang['menu_profile']='Profiili';
$hesklang['menu_kb']='Tukitietokanta'; // Admin MENU item
$hesklang['kb_text']='Tukitietokanta'; // Item visible to customers
$hesklang['viewkb']='Näytä koko tukitietokanta';
$hesklang['kb']='Ylläpidä tukitietokantaa';
$hesklang['kb_intro']='Tukitietokanta on kokoelma vastauksia usein kysyttyihin kysymyksiin (UKK) ja artikkeleita, jotka voivat auttaa asiakkaita itse ratkaisemaan ongelmia. Kattava ja hyvin rakennettu tukitietokanta voi merkittävästi vähentää tikettien määrää ja näin ollen säästää aikaasi. Voit järjestää artikkeleita kategorioihin ja alikategorioihin'; // Description in ADMIN panel
$hesklang['kb_is']='Tukitietokanta on kokoelma vastauksia usein kysyttyihin kysymyksiin (UKK) ja artikkeleita. Voit lukea artikkeleita tässä kategoriassa tai valita sinua kiinnostavan alikategorian.'; // Description for CUSTOMERS
$hesklang['new_kb_art']='Uusi tukitietokanta-artikkeli';
$hesklang['kb_cat']='Kategoria';
$hesklang['kb_subject']='Aihe';
$hesklang['kb_content']='Sisältö';
$hesklang['kb_type']='Tyyppi';
$hesklang['kb_published']='Julkaistu';
$hesklang['kb_published2']='Tämä artikkeli on kaikkien luettavissa.';
$hesklang['kb_private']='Yksityinen';
$hesklang['kb_private2']='Ainoastaan henkilökunta voi lukea yksityisiä artikkeleita.';
$hesklang['kb_draft']='Luonnos';
$hesklang['kb_draft2']='Artikkeli on tallennettu, mutta ei vielä julkaistu. Ainoastaan henkilökunta tai oikeudet omaava käyttäjä voi lukea sen.';
$hesklang['kb_links']='<i><span class="notice"><b>Varoitus!</b></span><br />Kirjoita validia koodia ilman &lt;head&gt; and &lt;body&gt; tagejä, vain sisältö!</i>';
$hesklang['kb_ehtml']='Tämä on HTML-koodia (tulen kirjoittamaan validia (X)HTML-koodia)';
$hesklang['kb_dhtml']='Tämä on muotoilematonta tekstiä (linkeistä tulee klikattavia)';
$hesklang['kb_save']='Tallenna artikkeli';
$hesklang['kb_e_subj']='Anna uuden artikkelin aihe!';
$hesklang['kb_e_cont']='Kirjoita artikkelin sisältö!';
$hesklang['kb_art_added']='Artikkeli lisätty';
$hesklang['your_kb_added']='Uusi tukitietokanta-artikkeli on lisätty onnistuneesti';
$hesklang['kb_art_deleted']='Artikkeli poistettu';
$hesklang['your_kb_deleted']='Valittu tukitietokanta-artikkeli on poistettu onnistuneesti';
$hesklang['kb_art_mod']='Artikkelia muokattu';
$hesklang['your_kb_mod']='Muutoksesi valittuun artikkeliin on tallennettu onnistuneesti.';
$hesklang['kb_cat_new']='Uusi tukitietokanta-artikkeli';
$hesklang['kb_cat_parent']='Yläkategoria';
$hesklang['kb_cat_sub']='Alikategoriat';
$hesklang['kb_cat_title']='Kategorian otsikko';
$hesklang['kb_cat_published']='Tämä kategoria on kaikkien nähtävissä.';
$hesklang['kb_cat_private']='Kategoria on ainoastaan henkilökunnan nähtävissä.';
$hesklang['kb_cat_add']='Lisää kategoria';
$hesklang['kb_cat_e_title']='Anna kategorian otsikko!';
$hesklang['kb_cat_added']='Kategoria lisätty';
$hesklang['kb_cat_added2']='Uusi kategoria on lisätty onnistuneesti tukitietokantaan';
$hesklang['kb_cat_man']='Ylläpidä kategoriaa';
$hesklang['kb_cat_edit']='Muokkaa kategorian tietoja';
$hesklang['kb_cat_inv']='Virheellinen kategoria';
$hesklang['kb_cat_art']='Tämän kategorian artikkelit';
$hesklang['kb_p_art']='+ Artikkeli';
$hesklang['kb_p_art2']='lisää uusi artikkeli valittuun kategoriaan.';
$hesklang['kb_add_art']='Lisää artikkeli';
$hesklang['kb_p_cat']='+ Kategoria';
$hesklang['kb_p_cat2']='lisää uusi alikategoria valittuun kategoriaan.';
$hesklang['kb_add_cat']='Lisää kategoria';
$hesklang['kb_p_man']='Ylläpidä';
$hesklang['kb_p_man2']='ylläpidä valittua kategoriaa (muokkaa, poista, ylläpidä artikkeleja).';
$hesklang['kb_main']='Tukitietokannan pääartikkelia ei voi poistaa tai siirtää.';
$hesklang['kb_no_art']='Tässä kategoriassa ei ole artikkeleita.';
$hesklang['author']='Kirjoittaja';
$hesklang['views']='Näyttöjä';
$hesklang['delete']='Poista';
$hesklang['rating']='Arvostelu';
$hesklang['votes']='Ääniä';
$hesklang['kb_rated']='Artikkeli arvosteltu %s/5.0';
$hesklang['kb_not_rated']='Artikkelia ei ole vielä arvosteltu';
$hesklang['del_art']='Oletko varma, että haluat poistaa kyseisen artikkelin?';
$hesklang['kb_art_id']='Puuttuva tai virheellinen artikkelin tunnus!';
$hesklang['kb_art_edit']='Muokkaa artikkelia';
$hesklang['revhist']='Versiohistoria';
$hesklang['revision1']='<li class="smaller">%s | lähetetty  käyttäjän %s toimesta</li>'; // %s = date, user making change
$hesklang['revision2']='<li class="smaller">%s | muokattu käyttäjän %s toimesta</li>'; // %s = date, user making change
$hesklang['kb_order']='Järjestä';
$hesklang['kb_delcat']='Oletko varma, että haluat poistaa kyseisen kategorian?';
$hesklang['kb_cat_mod']='Kategoriaa muokattu';
$hesklang['your_cat_mod']='Muutokset valittuun kategoriaan on tallennettu onnistuneesti.';
$hesklang['kb_cat_del']='Tukitietokannan kategoria poistettu';
$hesklang['kb_cat_dlt']='Valittu tukitietokannan kategoria on poistettu.';
$hesklang['allowed_cat']='Kategoriat';
$hesklang['allow_feat']='Ominaisuudet';
$hesklang['can_view_tickets']='Voi nähdä tikettejä';
$hesklang['can_reply_tickets']='Voi vastata tiketteihin';
$hesklang['can_assign_tickets']='Voi osoittaa tikettejä';
$hesklang['can_del_tickets']='Voi poistaa tikettejä';
$hesklang['can_edit_tickets']='Voi muokata tikettien vastauksia';
$hesklang['can_change_cat']='Voi vaihtaa tiketin kategoriaa';
$hesklang['can_man_kb']='Voi ylläpitää tukitietokantaa';
$hesklang['can_man_users']='Voi ylläpitää käyttäjiä';
$hesklang['can_man_cat']='Voi ylläpitää kategorioita';
$hesklang['can_man_canned']='Voi ylläpitää tallennettuja vastauksia';
$hesklang['can_man_settings']='Voi ylläpitää tukijärjestelmän asetuksia';
$hesklang['can_del_notes']='Voi poistaa minkä tahansa tiketin merkintöjä';
$hesklang['dan']='käyttäjät voivat poistaa omia tikettimerkintöjään. Valitse tämä vain, jos haluat sallia tämän käyttäjän poistaa toisten käyttäjien merkintöjä';
$hesklang['in_all_cat']='vain sallituissa kategorioissa';
$hesklang['admin_can']='(pääsy kaikkiin ominaisuuksiin ja kategorioihin)';
$hesklang['staff_can']='(voit rajoittaa ominaisuuksia ja kategorioita)';
$hesklang['asign_one_feat']='Osoita vähintään yksi ominaisuus tälle käyttäjälle!';
$hesklang['na_view_tickets']='Sinulla ei ole oikeuksia nähdä tikettejä';
$hesklang['support_notice']='Valitettavasti tämän osion voit poistaa ainoastaan ostamalla HESK-lisenssin!';
$hesklang['rart']='Oliko tästä artikkelista hyötyä?';
$hesklang['r']='Oliko tästä vastauksesta hyötyä?';
$hesklang['tyr']='Kiitos arvostelustasi';
$hesklang['cw']='Sulje ikkuna';
$hesklang['cw2']='Sulje ikkuna ja lähetä tiketti';
$hesklang['rh']='Arvosteltu<i>hyödylliseksi</i>';
$hesklang['rnh']='Arvosteltu <i>ei hyödylliseksi</i>';
$hesklang['ar']='On jo arvosteltu';
$hesklang['rated']='Käyttäjäarviot %s/5.0 (%s ääntä)';
$hesklang['not_rated']='Käyttäjä ei ole vielä arvostellut';
$hesklang['rdis']='Arvostelu on poistettu käytöstä';
$hesklang['kbdis']='Tukitietokanta on poistettu käytöstä';
$hesklang['kbpart']='Valitettavasti sinulla ei ole oikeuksia tähän artikkeliin';
$hesklang['popart']='Suosituimmat tukitietokannan artikkelit:';
$hesklang['latart']='Viimeisimmät tukitietokannan artikkelit:';
$hesklang['m']='Lisää aiheita';
$hesklang['ac']='Tämän kategorian artikkelit:';
$hesklang['noa']='Ei vielä artikkeleita';
$hesklang['noac']='Tässä kategoriassa ei ole vielä artikkeleita';
$hesklang['dta']='Päivämäärä lisätty';
$hesklang['ad']='Artikkelin tiedot';
$hesklang['aid']='Artikkelin tunnus';
$hesklang['as']='Ratkaisu';
$hesklang['search']='Haku';
$hesklang['sr']='Hakutulokset';
$hesklang['nosr']='Hakua vastaavia artikkeleita ei löytynyt. Voit selailla tukitietokantaa tai lähettää uuden tiketin.';
$hesklang['rv']='Tyhjää katsomiskerrat';
$hesklang['rr']='Tyhjää äänet (arvostelut)';
$hesklang['opt']='Asetukset';
$hesklang['delcat']='Poista kategoria';
$hesklang['move1']='Siirrä artikkelit yläkategoriaan';
$hesklang['move2']='Poista tämän kategorian artikkelit';
$hesklang['sc']='Ehdotetut tukitietokannan artikkelit';
$hesklang['not']='Tiketit'; // Number of all tickets in category
$hesklang['graph']='Graafi';
$hesklang['lu']='Listaa käyttäjänimet';
$hesklang['aclose']='Sulje tiketit automaattisesti';
$hesklang['aclose2']='päivää viimeisestä henkilökunnan vastauksesta';
$hesklang['s_ucrt']='Avaa tiketit uudelleen';
$hesklang['urate']='Vastaa arvosteluihin';
$hesklang['hesk_url']='Tukipalvelun URL';
$hesklang['hesk_title']='Tukipalvelun otsikko';
$hesklang['cid']='Tapauksen seurantatunnus';
$hesklang['tfor']='Ajan muoto';
$hesklang['prefix']='Taulujen etuliite';
$hesklang['s_ekb']='Ota tukitietokanta käyttöön';
$hesklang['s_kbs']='Ota tukitietokannan haku käyttöön';
$hesklang['s_kbr']='Ota tukitietokannan arvostelu käyttöön';
$hesklang['s_maxsr']='Hakutulosten enimmäismäärä';
$hesklang['s_suggest']='Ehdota tukitietokannan artikkeleita';
$hesklang['s_spop']='Näytä suositut artikkelit';
$hesklang['s_slat']='Näytä uusimmat artikkelit';
$hesklang['s_onin']='<a href="../" target="_blank">tukipalvelun etusivulla</a>';
$hesklang['s_onkb']='<a href="../knowledgebase.php" target="_blank">tukitietokannan etusivulla</a>';
$hesklang['s_scol']='Kategorioita per rivi';
$hesklang['s_ptxt']='Artikkelin esikatselun pituus';
$hesklang['s_psubart']='Alikategorian artikkelit';
$hesklang['enable']='Ota käyttöön';
$hesklang['s_type']='Tyyppi';
$hesklang['custom_r']='Pakollinen';
$hesklang['custom_place']='Sijanti';
$hesklang['custom_use']='Räätälöidyt kentät';
$hesklang['stf']='Tekstikenttä';
$hesklang['stb']='Suuri tekstilaatikko';
$hesklang['srb']='Radionappi';
$hesklang['ssb']='Valintalaatikko';
$hesklang['db']='Tietokanta';
$hesklang['hd']='Tukipalvelun asetukset';
$hesklang['gs']='Yleiset asetukset';
$hesklang['cwin']='Sulje ikkuna';
$hesklang['defw']='Oletusarvo';
$hesklang['ok']='OK';
$hesklang['ns']='Nämä ovat saatavilla olevat vaihtoehdot tälle kustomoidulle kentälle. Tallentaaksesi muutokset klikkaa <b>OK</b> ja <b>Tallenna muutokset</b>-nappia ylläpitäjän asetukset-sivulla!';
$hesklang['rows']='Rivit (korkeus)';
$hesklang['cols']='Sarakkeet (leveys)';
$hesklang['opt2']='Vaihtoehdot tälle radionapille, syötä yksi vaihtoehto per rivi (jokainen rivi luo uuden asiakkaan valittavissa olevan radionapin arvon.) Sinun täytyy syöttää vähintään kaksi vaihtoehtoa!';
$hesklang['opt3']='Vaihtoehdot tälle valintalaatikolle, syötä yksi vaihtoehto per rivi (jokainen rivi on asiakkaan valittavissa oleva vaihtoehto.) Sinun täytyy syöttää vähintään kaksi vaihtoehtoa!';
$hesklang['atl2']='Anna vähintään kaksi vaihtoehtoa (yksi per rivi)!';
$hesklang['notes']='Merkinnät';
$hesklang['addnote']='+ Lisää merkintä';
$hesklang['noteby']='Merkinnän on kirjoittanut';
$hesklang['delnote']='Poista merkintä';
$hesklang['noteerr']='Merkintä on jo poistettu tai väärät parametrit';
$hesklang['s']='Lähetä';
$hesklang['nhid']='Asiakkaat eivät näe merkintöjä!';
$hesklang['delt']='Poista tämä viesti';
$hesklang['edtt']='Muokkaa viestiä';
$hesklang['edt1']='Viestiä muokattu';
$hesklang['edt2']='Muutokset valittuun viestiin on tallennettu';
$hesklang['dele']='Poista tämä tiketti';
$hesklang['repd']='Viesti poistettu';
$hesklang['repl']='Valittu viesti on poistettu';
$hesklang['tickets_found']='Hakutulokset';
$hesklang['al']='Ylläpitolinkki';
$hesklang['ap']='Siirry ylläpitopaneeliin';
$hesklang['dap']='Näytä linkki ylläpitopaneeliin <a href="../" target="_blank">tukipalvelun etusivulla</a>';
$hesklang['q_miss']='Vastaa roskapostinestokysymykseen';
$hesklang['use_q']='Käytä roskapostinestokysymystä';
$hesklang['q_q']='-&gt; Kysymys (HTML-koodi on <font class="success">sallittu</font>)';
$hesklang['q_a']='-&gt; Vastaus';
$hesklang['err_qask']='Syötä roskapostinestokysymys';
$hesklang['err_qans']='Syötä vastaus roskapostinestokysymykseen';
$hesklang['genq']='Luo satunnainen kysymys';

// Added in version 2.1
$hesklang['amo']='Lisää enemmän';
$hesklang['delatt']='Poista valittu liite';
$hesklang['kb_att_rem']='Valittu liite on poistettu';
$hesklang['inv_att_id']='Virheellinen liitteen tunnus!';
$hesklang['scb']='Valintaruutu';
$hesklang['opt4']='Vaihtoehdot tälle valintruudulle, syötä yksi vaihtoehto per rivi. Jokainen rivi on vaihtoehto, jonka asiakkaat voivat valita, useamman vaihtoehdon valinta on mahdollista. Sinun täytyy antaa vähintään kaksi vaihtoehtoa!';
$hesklang['autologin']='Kirjaa minut sisään automaattisesti joka vierailulla';
$hesklang['just_user']='Muista vain käyttäjätunnukseni';
$hesklang['nothx']='Ei kiitos!';
$hesklang['pinfo']='Profiilin tiedot';
$hesklang['sig']='Allekirjoitus';
$hesklang['pref']='Asetukset';
$hesklang['aftrep']='Tikettiin vastaamisen jälkeen';
$hesklang['showtic']='Näytä tiketti, johon juuri vastasin';
$hesklang['gomain']='Palaa ylläpidon pääsivulle';
$hesklang['shownext']='Avaa seuraava tiketti, joka tarvitsee vastaustani';
$hesklang['rssn']='Näytetään seuraavan tiketti, joka tarvitsee huomiotasi';
$hesklang['mrep']='Korvaa viesti';
$hesklang['madd']='Lisää loppuun';
$hesklang['priv']='Yksityiset kategoriat ja artikkelit, jotka on merkitty *:llä ovat vain henkilökunnan katsottavissa';
$hesklang['inve']='Virheellinen sähköpostitiedosto';
$hesklang['emfm']='Puuttuva sähköpostitiedosto';
$hesklang['hesk_lang']='Oletuskieli';
$hesklang['s_mlang']='Useita kieliä';
$hesklang['s_mlange']='Ota käyttöön vain, jos tarjoat tukea kaikilla asennetuilla kielillä!';
$hesklang['s_inl']='Testaa language-kansio';
$hesklang['s_inle']='Testataan language-kansiota kielten oikeellisuuden varmistamiseksi. Asennetaan vain kielet, jotka läpäisevät kaikki testit.';
$hesklang['ta']='Testaa uudestaan';
$hesklang['alo']='Salli automaattinen kirjautuminen';
$hesklang['chol']='Oletuskieli';
$hesklang['mmdl']='Tee tästä oletuskieleni';
$hesklang['warn']='VAROITUS';
$hesklang['dmod']='Virheenkorjaustila on otettu käyttöön. Varmista, että poistat tämän tilan käytöstä, kun HESK on asennettu ja toiminnassa.';
$hesklang['kb_spar']='Kategoria ei voi olla itsensä yläkategoria!';
$hesklang['mysql_root']='MySQL-salasanasi on tyhjä, oletko varma, että haluat kirjautua root-käyttäjänä? Tämä on merkittävä turvallisuusriski!';
$hesklang['chg']='Vaihda';
$hesklang['chpri']='Prioriteetti vaihdettu';
$hesklang['chpri2']='Tiketin prioriteetti on vaihdettu luokkaan %s';
$hesklang['selcan']='Valitse tallennettu vastaus, jota haluat muokata';
$hesklang['q_wrng']='Väärä roskapostinestovastaus';
$hesklang['cndupl']='Sinulla on jo tämän niminen kategoria. Valitse yksilöllinen nimi kullekin kategorialle.';
$hesklang['wsel']='Valitse kenttä, jolla haluat hakea';

// Added in version 2.2
$hesklang['eto']='Virheellinen pyyntö';
$hesklang['id']='Tunnus';
$hesklang['geco']='Luo suora linkki';
$hesklang['genl']='Suora kategorialinkki';
$hesklang['genl2']='Käytä tätä linkkiä esivalitaksesi kategorian &quot;Lähetä tiketti quot;-lomakkeella.';
$hesklang['ask']='Etsi apua:';
$hesklang['exa']='Esimerkkejä';
$hesklang['small']='Pieni laatikko';
$hesklang['large']='Suuri laatikko';
$hesklang['cpri']='Asiakkaan prioriteetti';
$hesklang['owner']='Omistaja';
$hesklang['unas']='Ei osoitettu';
$hesklang['assi']='Osoita';
$hesklang['asst']='Osoita henkilölle';
$hesklang['asst2']='Osoita tämä tiketti henkilölle';
$hesklang['asss']='Osoita itsellesi';
$hesklang['asss2']='Osoita tämä tiketti minulle';
$hesklang['can_assign_self']='Voi osoittaa tikettejä itselleen';
$hesklang['can_assign_others']='Voi osoittaa tikettejä muille';
$hesklang['can_run_reports']='Voi luoda raportteja (omat)';
$hesklang['can_view_ass_others']='Voi tarkastella muille osoitettuja tikettejä';
$hesklang['unoa']='Valitulla käyttäjällä ei ole pääsyä pääsyoikeuksia tähän kategoriaan';
$hesklang['tasi']='Omistaja asetettu';
$hesklang['tasy']='Tämä tiketti on osoitettu sinulle';
$hesklang['taso']='Tämä tiketti on osoitettu valitulle käyttäjälle';
$hesklang['tasy2']='Osoitettu minulle';
$hesklang['taso2']='Osoitettu muulle henkilökunnalle';
$hesklang['nose']='Valitse uusi omistaja';
$hesklang['onasc']='Omistajalla ei ole pääsyoikeuksia valittuun kategoriaan.';
$hesklang['tunasi']='Tikettiä ei ole osoitettu';
$hesklang['tunasi2']='Tiketti on vailla omistajaa ja on valmis osoitettavaksi uudelleen';
$hesklang['note']='Huom';
$hesklang['success']='Onnistui';
$hesklang['nyt']='Tämä tiketti on osoitettu henkilölle';
$hesklang['noch']='Muutoksia ei ole tehty';
$hesklang['orch']='Näyttöjärjestys on muutettu';
$hesklang['rfm']='Vaadittu tieto puuttuu:';
$hesklang['repl0']='Ei oikeuksia suorittaa tätä tehtävää';
$hesklang['repl1']='Tätä viestiä ei ole olemassa';
$hesklang['reports']='Raportit';
$hesklang['reports_intro']='Raportit-alue antaa sinun luoda useita raportteja ja tarkastella tilastoja valitulla ajanjaksolla.';
$hesklang['refi']='Tyhjennä lomakkeen tiedot';
$hesklang['dich']='Hylkää muutokset';
$hesklang['dire']='Näytä raportti';
$hesklang['m1']='Tammikuu';
$hesklang['m2']='Helmikuu';
$hesklang['m3']='Maaliskuu';
$hesklang['m4']='Huhtikuu';
$hesklang['m5']='Toukokuu';
$hesklang['m6']='Kesäkuu';
$hesklang['m7']='Heinäkuu';
$hesklang['m8']='Elokuu';
$hesklang['m9']='Syyskuu';
$hesklang['m10']='Lokakuu';
$hesklang['m11']='Marraskuu';
$hesklang['m12']='Joulukuu';
$hesklang['d1']='Maanantai';
$hesklang['d2']='Tiistai';
$hesklang['d3']='Keskiviikko';
$hesklang['d4']='Torstai';
$hesklang['d5']='Perjantai';
$hesklang['d6']='Lauantai';
$hesklang['d0']='Sunnuntai';
$hesklang['mo']='Ma';
$hesklang['tu']='Ti';
$hesklang['we']='Ke';
$hesklang['th']='To';
$hesklang['fr']='Pe';
$hesklang['sa']='La';
$hesklang['su']='Su';
$hesklang['from']='Alkaen';
$hesklang['cinv']='Virheellinen päivämäärä';
$hesklang['cinv2']='Hyväksytty aikamuoto on kk/pp/vvvv';
$hesklang['cinm']='Virheellinen kuukausi';
$hesklang['cinm2']='Sallittu väli on';
$hesklang['cind']='Virheellinen kuukauden päivä';
$hesklang['cind2']='Sallittu väli valitulle kuukaudelle on';
$hesklang['month']='Kuukausi';
$hesklang['ocal']='Avaa kalenteri';
$hesklang['ca01']='Edellinen vuosi';
$hesklang['ca02']='Edellinen kuukausi';
$hesklang['ca03']='Seuraava kuukausi';
$hesklang['ca04']='Seuraava vuosi';
$hesklang['ca05']='Sulje kalenteri';
$hesklang['cdr']='Valitse ajanjakso:';
$hesklang['crt']='Valitse raportin tyyppi';
$hesklang['r1']='Tänään';
$hesklang['r2']='Eilen';
$hesklang['r3']='Tämä kuukausi';
$hesklang['r4']='Edellinen kuukausi';
$hesklang['r5']='Viimeiset 30 päivää';
$hesklang['r6']='Tämä viikko (Ma-Su)';
$hesklang['r7']='Edellinen viikko (Ma-Su)';
$hesklang['r8']='Tämän viikon arkipäivät (Ma-Pe)';
$hesklang['r9']='Edellisen viikon arkipäivät (Ma-Pe)';
$hesklang['r10']='Tänä vuonna';
$hesklang['r11']='Viime vuonna';
$hesklang['r12']='Kaikki ajat';
$hesklang['datetofrom']='&quot;Alkaen päivästä&quot; ei voi olla suurempi kuin &quot;päivään asti&quot;. Päivämäärät on vaihdettu.';
$hesklang['t1']='Tikettejä per päivä';
$hesklang['t2']='Tikettejä per kuukausi';
$hesklang['t3']='Tikettejä per käyttäjä';
$hesklang['t4']='Tikettejä per kategoria';
$hesklang['ticass']='Osoitettuja tikettejä';
$hesklang['ticall']='Vastattuja tikettejä';
$hesklang['totals']='Yhteensä';
$hesklang['all']='Kaikki';
$hesklang['atik']='Uudet tiketit';
$hesklang['kbca']='Tämän niminen tukitietokannan kategoria on jo olemassa.';
$hesklang['menu_msg']='Viestit';
$hesklang['menu_can']='Tallennetut vastaukset';
$hesklang['m_from']='Lähettäjä:'; // Mail "from" address
$hesklang['m_to']='Vastaanottaja:'; // Mail "to" address
$hesklang['m_sub']='Aihe:'; // Mail subject
$hesklang['m_re']='Re:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='Fwd:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Yksityisviestit';
$hesklang['m_intro']='Käytä yksityisviestejä lähettääksesi pikaviestejä toisille henkilökunnan jäsenille.';
$hesklang['e_udel']='(Käyttäjä poistettu)';
$hesklang['new_mail']='Uusi yksityisviesti';
$hesklang['m_send']='Lähetä viesti';
$hesklang['m_rec']='Valitse viestin vastaanottaja';
$hesklang['m_inr']='Virheellinen viestin vastaanottaja';
$hesklang['m_esu']='Anna yksityisviestin aihe';
$hesklang['m_pms']='Yksityisviestisi on lähetetty';
$hesklang['inbox']='SAAPUNEET';
$hesklang['outbox']='LÄHETETYT';
$hesklang['m_new']='UUSI VIESTI';
$hesklang['pg']='Näytä sivu';
$hesklang['npm']='Ei yksityisviestejä tässä kansiossa.';
$hesklang['m_ena']='Sinulla ei ole oikeuksia lukea tätä viestiä.';
$hesklang['mau']='Merkitse ei-luetuksi';
$hesklang['mo1']='Merkitse valitut viestit luetuksi';
$hesklang['mo2']='Merkitse valitut viestit ei-luetuiksi';
$hesklang['mo3']='Poista valitut viestit';
$hesklang['delm']='Poista tämä viesti';
$hesklang['e_tid']='Virhe luotaessa yksilöllistä tiketin tunnusta, yritä lähettää lomake uudelleen myöhemmin.';
$hesklang['smmr']='Valitut viestit on merkitty luetuiksi';
$hesklang['smmu']='Valitut viestit on merkitty ei-luetuiksi';
$hesklang['smdl']='Valitut viestit on poistettu';
$hesklang['show']='Näytä';
$hesklang['s_my']='Minulle osoitetut';
$hesklang['s_ot']='Muille osoitetut';
$hesklang['s_un']='Tiketit, joita ei ole osoitettu';
$hesklang['s_for']='Etsi termiä';
$hesklang['s_in']='Kohdista haku';
$hesklang['s_incl']='Kohdista';
$hesklang['find_ticket_by']='Etsi tiketti';
$hesklang['e_nose']='Tukipyynnön tilaa ei ole valittu, näyttää kaikki tiketit.';
$hesklang['fsq']='Anna hakusanat';
$hesklang['topen']='Avoin';
$hesklang['nms']='Ei yhtääv viestiä valittuna, ei mitään muutettavaa';
$hesklang['tlo']='Lukitse tiketti';
$hesklang['tul']='Poista tiketin lukitus';
$hesklang['loc']='Lukittu';
$hesklang['isloc']='Asiakkaat eivät voi vastata tai avata uudelleen lukittuja tikettejä, kun lukittu tiketti on merkitty ratkaistuksi.';
$hesklang['tlock']='Tiketti on lukittu';
$hesklang['tunlock']='Tiketin lukitus on poistettu';
$hesklang['tislock']='Tämä tiketti on lukittu, asiakas ei voi lähettää vastausta.';
$hesklang['tislock2']='Tämä tiketti on lukittu, et voi lähettää vastausta.';
$hesklang['nsfo']='Vastaavia artikkeleita ei löytynyt.';
$hesklang['thist1']='<li class="smaller">%s | siirretty kategoriaan %s käyttäjän %s toimesta</li>'; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller">%s | osoitettu käyttäjälle %s käyttäjän %s toimesta</li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class="smaller">%s | suljettu käyttäjän %s toimesta</li>'; // %s = date, user making change
$hesklang['thist4']='<li class="smaller">%s | avattu käyttäjän %s toimesta</li>'; // %s = date, user making change
$hesklang['thist5']='<li class="smaller">%s | lukittu käyttäjän %s toimesta</li>'; // %s = date, user making change
$hesklang['thist6']='<li class="smaller">%s | lukitus poistetu käyttäjän %s toimesta</li>'; // %s = date, user making change
$hesklang['thist7']='<li class="smaller">%s | tiketti luotu käyttäjän %s toimesta</li>'; // %s = date, user making change
$hesklang['elocked']='Tämä tiketti on lukittu tai poistettu.';
$hesklang['nti2']='Syötä uusi tiketti';
$hesklang['nti3']='Käytä tätä lomaketta luodaksesi uuden tiketin asiakkaan nimellä. Syötä <i>asiakkaan</i> tiedot lomakkeelle (asiakkaan nimi, sähköposti, ...), ÄLÄ sinun omiasi! Tiketti luodaan siten kuin asiakas olisi sen lähettänyt.';
$hesklang['addop']='Vaihtoehdot';
$hesklang['seno']='Lähetä sähköposti-ilmoitus asiakkaalle';
$hesklang['otas']='Näytä tiketti lähetyksen jälkeen';
$hesklang['notn']='Ilmoitukset';
$hesklang['nomw']='Tukipalvelu lähettää sähköposti-ilmoituksen, kun:';
$hesklang['nwts']='Uusi tiketti on luotu, omistaja:';
$hesklang['ncrt']='Asiakas vastaa tikettiin, jonka omistaa:';
$hesklang['ntam']='Tiketti on osoitettu minulle';
$hesklang['npms']='Yksityisviesti on lähetetty minulle';
$hesklang['support_remove']='HESKin kehittämiseen on käytetty paljon aikaa ja vaivaa. Tue HESKiä ostamalla lisenssi, joka poistaa <i>Powered by Help Desk Software HESK</i>-merkinnät tukipalvelustasi';
$hesklang['ycvtao']='Sinulla ei ole oikeuksia tarkastella muille osoitettuja tikettejä';
$hesklang['password_not_valid']='Salasanan on oltava vähintään viisi merkkiä pitkä';
$hesklang['lkbs']='Ladataan tukitietokannan ehdotuksia...';
$hesklang['auto']='(automaattisesti)';

// Added in version 2.3
$hesklang['unknown']='Tuntematon';
$hesklang['pcer']='Ole hyvä ja korjaa seuraavat virheet:';
$hesklang['seqid']='Tiketin numero';
$hesklang['close_action']='Merkitse ratkaistuksi'; // Close ACTION
$hesklang['archived']='Merkitty';
$hesklang['archived2']='Merkitty tiketti';
$hesklang['add_archive']='Merkitse tämä tiketti';
$hesklang['add_archive_quick']='Merkitse valitut tiketit';
$hesklang['remove_archive']='Poista tämän tiketin merkintä';
$hesklang['remove_archive_quick']='Poista valittujen tikettien merkinnät';
$hesklang['added_archive']='Tiketti on merkitty';
$hesklang['removed_archive']='Tiketin merkintä on poistettu';
$hesklang['added2archive']='Tiketti on merkattu';
$hesklang['removedfromarchive']='Tiketin merkintä on poistettu';
$hesklang['num_tickets_tag']='<b>%d</b> tikettiä merkitty';
$hesklang['num_tickets_untag']='<b>%d</b> tiketin merkintä on poistettu';
$hesklang['can_add_archive']='Voi merkitä tikettejä';
$hesklang['disp_only_archived']='Vain merkityt tiketit';
$hesklang['search_only_archived']='Vain merkityt tiketit';
$hesklang['critical']=' * Kriittinen * ';
$hesklang['thist8']='<li class="smaller">%s | prioriteetti vaihdettu luokkaan %s käyttäjän %s toimesta</li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class="smaller">%s | tilaksi vaihdettu %s käyttäjän %s toimesta</li>'; // %s = date, new status, user making change
$hesklang['thist10']='<li class="smaller">%s | automaattisesti osoitettu käyttäjälle %s</li>'; // %s = date, user making change
$hesklang['thist11']='<li class="smaller">%s | lähetetty sähköposti ketjuttamalla</li>'; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']='v';
$hesklang['abbr']['month']='kk';
$hesklang['abbr']['week']='vko';
$hesklang['abbr']['day']='p';
$hesklang['abbr']['hour']='t';
$hesklang['abbr']['minute']='min';
$hesklang['abbr']['second']='s';
// END abberviations
$hesklang['cnsm']='Ei voitu lähettää viestiä käyttäjille:';
$hesklang['yhbb']='Sinut on lukittu ulos järjestelmästä %s minuutiksi liian monen epäonnistuneen kirjautumisyrityksen vuoksi.';
$hesklang['pwdst']='Salasanan vahvuus';
$hesklang['tid_mail']='Ei hätää! Anna <b>sähköpostiosoitteesi</b> ja lähetämme sinulle uuden seurantatunnuksen välittömästi:';
$hesklang['rem_email']='Muista sähköpostiosoitteeni';
$hesklang['eytid']='Anna tiketin seurantatunnus.';
$hesklang['enmdb']='Antamaasi sähköpostiosoitetta tälle tiketin tunnukselle ei löydy tietokannastamme.';
$hesklang['confemail']='Vahvista sähköposti';
$hesklang['confemail2']='Ole hyvä ja vahvista sähköpostiosoitteesi';
$hesklang['confemaile']='Syötetyt sähköpostiosoitteet eivät ole identtiset';
$hesklang['taso3']='Osoitettu käyttäjälle:';
$hesklang['sec_enter']='Syötä numero, jonka näet alla olevassa kuvassa.';
$hesklang['reload']='Lataa kuva uudelleen';
$hesklang['verify_q']='Roskapostin esto:'; // For anti-spam question
$hesklang['verify_i']='Roskapostin esto:'; // For anti-spam image (captcha)
$hesklang['admin_login']='Henkilökunnan kirjautuminen';
$hesklang['vrfy']='Testi läpäisty';
$hesklang['last_update']='Päivitetty';
$hesklang['cot']='Älä pakota kriittisiä tikettejä ylimmäisiksi';
$hesklang['def']='Tee tästä oletusnäkymäni';
$hesklang['gbou']='Näitä tikettejä <b>ei ole osoitettu</b>:';
$hesklang['gbom']='<b>Minulle</b> osoitetut tiketit:';
$hesklang['gboo']='Käyttäjälle <b>%s</b> osoitetut tiketit:';
$hesklang['select']=' - - Klikkaa valitaksesi - - ';
$hesklang['chngstatus']='Muuta tilaksi';
$hesklang['perat']='%s kaikista tiketeistä'; // Will change to "23% of all tickets"
$hesklang['viewart']='Näytä tämä artikkeli';
$hesklang['chdp']='Vaihda oletussalasana <a href="profile.php">Profiili</a>-sivullasi!';
$hesklang['chdp2']='Vaihda salasanasi, käytät oletussalasanaa!';
$hesklang['security']='Turvallisuus';
$hesklang['kb_i_art']='Uusi artikkeli';
$hesklang['kb_i_art2']='Lisää artikkeli';
$hesklang['kb_i_cat']='Uusi kategoria';
$hesklang['kb_i_cat2']='Lisää kategoria';
$hesklang['gopr']='Näytä tukitietokanta';
$hesklang['kbstruct']='Tukitietokannan rakenne';
$hesklang['cancel']='Hylkää';
$hesklang['sh']='Piilota viesti';
$hesklang['goodkb']='Kuinka kirjoittaa hyviä tukitietokanta-artikkeleita?';
$hesklang['catset']='Kategorian asetukset';
$hesklang['inpr']='Valitse uusi prioriteetti';
$hesklang['incat']='Valitse uusi kategoria';
$hesklang['instat']='Valitse uusi tila';
$hesklang['tsst']='Tiketin tilaksi on asetettu %s';
$hesklang['aass']='Osoita automaattisesti';
$hesklang['aaon']='Tikettien automaattinen osoitus on käytössä (klikkaa poistaaksesi käytöstä)';
$hesklang['aaoff']='Tikettien automaattinen osoitus on pois käytöstä (klikkaa ottaaksesi käyttöön)';
$hesklang['uaaon']='Tikettien automaattinen osoitus on käytössä valittulla käyttäjällä';
$hesklang['uaaoff']='Tikettien automaattinen osoitus on poistettu käytöstä valitulta käyttäjältä';
$hesklang['taasy']='Tämä tiketti on osoitettu automaattisesti sinulle';
$hesklang['can_view_unassigned']='Voi tarkastella osoittamattomia tikettejä';
$hesklang['ycovtay']='Voit katsoa ainoastaan sinulle osoitettuja tikettejä';
$hesklang['in_progress']='Työn alla';
$hesklang['on_hold']='Odottaa';
$hesklang['import_kb']='Vie tämä tiketti tukitietokanta-artikkeliksi';
$hesklang['import']='Olet viemässä <i>yksityistä tikettiä</i> <i>julkiseksi artikkeliksi</i>.<br /><br />Varmista, että poistat kaikki yksityiset tiedot otsikosta ja viestikentästä!';
$hesklang['tab_1']='Yleiset';
$hesklang['tab_2']='Tukipalvelu';
$hesklang['tab_3']='Tukitietokanta';
$hesklang['tab_4']='Räätälöidyt kentät';
$hesklang['tab_5']='Sekalaiset';
$hesklang['disable']='Ota pois käytöstä';
$hesklang['dat']='Päivämäärä &amp; Aika';
$hesklang['lgs']='Kieli';
$hesklang['onc']='PÄÄLLÄ - Asiakkaat';
$hesklang['ons']='PÄÄLLÄ - Kaikki';
$hesklang['viewvtic']='Näytä tiketit';
$hesklang['reqetv']='Vaadi sähköposti tiketin tarkasteluun';
$hesklang['banlim']='Kirjautumisyritysten raja';
$hesklang['banmin']='Estoaika (minuuttia)';
$hesklang['subnot']='Lähetä huomautus';
$hesklang['subnot2']='Näytä huomautus asiakkaille, jotka lähettävät tikettejä';
$hesklang['eseqid']='Peräkkäiset tunnukset';
$hesklang['sconfe']='Vahvista sähköposti';
$hesklang['saass']='Osoita tiketit automaattisesti';
$hesklang['swyse']='WYSIWYG-editori';
$hesklang['hrts']='Arvostele HESK';
$hesklang['hrts2']='Näytä "Arvostele tämä"-skriptin linkki ylläpitopaneelissa';
$hesklang['emlpipe']='Sähköpostin ketjutus';
$hesklang['emlsend2']='Lähetä sähköposti käyttäen';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='SMTP-palvelin';
$hesklang['smtph']='SMTP-isäntä';
$hesklang['smtpp']='SMTP-portti';
$hesklang['smtpu']='SMTP-käyttäjätunnus';
$hesklang['smtpw']='SMTP-salasana';
$hesklang['smtpt']='SMTP-timeout';
$hesklang['other']='Muu';
$hesklang['features']='Ominaisuudet';
$hesklang['can_view_online']='Voi nähdä henkilökunnan jäsenet, jotka ovat online-tilassa';
$hesklang['online']='Online';
$hesklang['offline']='Offline';
$hesklang['onlinep']='käyttäjät online-tilassa'; // For display in footer
$hesklang['sonline']='käyttäjät online-tilassa'; // For settings page
$hesklang['sonline2']='Näytä online-tilassa olevat käyttäjät. Raja (minuuttia):'; // For settings page
$hesklang['gb']='Ryhmittele';
$hesklang['dg']='Älä ryhmittele';
$hesklang['err_dpi']='Tietokanta %s ei sisällä kaikkia HESK-tauluja etuliitteellä %s, muutoksia ei tallennettu.';
$hesklang['err_dpi2']='Tauluja ei löytynyt:';
$hesklang['sme']='SMTP-virhe';
$hesklang['scl']='SMTP-yhteysloki';
$hesklang['dnl']='Lataa';
$hesklang['dela']='Poista tämä liite';
$hesklang['pda']='Haluatko poistaa tämän liitteen pysyvästi?';
$hesklang['thist12']='<li class="smaller">%s | liite %s poistettu käyttäjän %s toimesta</li>'; // %s = date, deleted attachment, user making change
$hesklang['mopt']='Lisää vaihtoehtoja';
$hesklang['lopt']='Vähemmän vaihtoehtoja';
$hesklang['meml']='Useita sähköposteja';
$hesklang['meml2']='Salli asiakkaiden syöttää useita sähköpostiosoitteita';

// Added in version 2.4
$hesklang['catd']='(kategoria poistettu)';
$hesklang['noopen']='Ei löytynyt avoimia tikettejä tällä sähköpostiosoitteella.';
$hesklang['maxopen']='Olet saavuttanut avoimien tikettien enimmäismäärän (%d / %d). Odota, että aikaisemmat tikettisi ratkaistaan ennen kuin taas avaat uuden tiketin.';
$hesklang['ntnote']='Joku lisää merkinnän minulle osoitettuun tikettiin.';
$hesklang['cat_public']='Tämä kategoria on JULKINEN (klikkaa tästä muuttaaksesi yksityiseksi)';
$hesklang['cat_private']='Tämä kategoria on YKSITYINEN (klikkaa tästä muuttaaksesi julkiseksi)';
$hesklang['cat_aa']='Osoita tämän kategorian tiketit automaattisesti.';
$hesklang['cat_type']='Tee tästä kategoriasta yksityinen (vain henkilökunta voi valita sen).';
$hesklang['caaon']='Automaattinen osoittaminen on otettu käyttöön valittussa kategoriassa';
$hesklang['caaoff']='Automaattinen osoittaminen on poistettu käytöstä valittussa kategoriassa';
$hesklang['cpub']='Kategorian tyyppi vaihdettu JULKISEKSI';
$hesklang['cpriv']='Kategorian tyyppi vaihdettu YKSITYISEKSI';
$hesklang['cpric']='Asiakkaat eivät voi valita yksityisiä kategorioita, vain henkilökunta voi!';
$hesklang['user_aa']='Osoita tiketit automaattisesti tälle käyttäjälle.';
$hesklang['attach_size']='Tiedoston maksimikoko';
$hesklang['B']='B';
$hesklang['kB']='kB';
$hesklang['MB']='MB';
$hesklang['GB']='GB';
$hesklang['bytes']='tavua';
$hesklang['kilobytes']='kilotavua';
$hesklang['megabytes']='megatavua';
$hesklang['gigabytes']='gigatavua';
$hesklang['smtpssl']='SSL-protokolla';
$hesklang['smtptls']='TLS-protokolla';
$hesklang['oo']='Avaa vain';
$hesklang['ool']='Listaa vain avoimet tiketit &quot;Unohtunut seurantatunnus&quot;-sähköpostissa';
$hesklang['mop']='Avoimien tikettien enimmäismäärä';
$hesklang['rord']='Vastausjärjestys';
$hesklang['newbot']='Uusin vastaus alimmaisena';
$hesklang['newtop']='Uusin vastaus ylimmäisenä';
$hesklang['ford']='Vastauslomake';
$hesklang['formbot']='Näytä lomake alimmaisena';
$hesklang['formtop']='Näytä lomake ylimmäisenä';
$hesklang['mysqlv']='MySQL-versio';
$hesklang['phpv']='PHP-versio';
$hesklang['csrt']='Nykyinen HESK aika:';
$hesklang['listp']='Listaa yksityiset artikkelit';
$hesklang['listd']='Listaa artikkelien luonnokset';
$hesklang['artp']='Yksityiset artikkelit';
$hesklang['artd']='Artikkelien luonnokset';
$hesklang['kb_no_part']='Ei yksityisiä artikkeleja tukitietokannassa.';
$hesklang['kb_no_dart']='Ei artikkelejen luonnoksia tukitietokannassa.';
$hesklang['attpri']='Sinulla ei ole pääsyoikeuksia tähän liitteseen';
$hesklang['can_merge_tickets']='Voi yhdistää tikettejä';
$hesklang['mer_selected']='Yhdistä valitut tiketit';
$hesklang['merged']='Valitut tiketit on yhdistetty.';
$hesklang['merge_err']='Tikettejä yhdistettäessä tapahtui virhe:';
$hesklang['merr1']='valitse vähintään kaksi tikettiä.';
$hesklang['merr2']='kohdetikettiä ei löytynyt.';
$hesklang['merr3']='tiketti on kategoriassa, johon sinulla ei ole pääsyoikeuksia.';
$hesklang['tme']='Tiketti %s on yhdistetty tämän tiketin (%s) kanssa .';
$hesklang['tme1']='Tiketti %s on yhdistetty tiketin %s kanssa';
$hesklang['tme2']='Saadaksesi pääsyn tikettiin %s anna siihen merkitty sähköpostiosoite.';
$hesklang['eyou']='Käytä profiilisivua muokataksesi asetuksiasi.';
$hesklang['npea']='Sinulla ei ole oikeuksia muokata tätä käyttäjää.';
$hesklang['duplicate_user']='Käyttäjä tällä nimellä on jo olemassa, valitse toinen nimi.';
$hesklang['kw']='Avainsanat';
$hesklang['kw1']='(valinnainen - erota välilyönnillä, pilkulla tai uudella rivillä)';
$hesklang['type_not_allowed']='Tiedostot, jotka päättyvät <b>%s</b> eivät ole sallittuja (%s)'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='Asiakas ei ole vielä lukenut tätä vastausta.';
$hesklang['sticky']='&quot;Kiinnitä&quot; tämä artikkeli';
$hesklang['stickyon']='Vaihda artikkeli &quot;Kiinnitetyksi&quot;';
$hesklang['stickyoff']='Vaihda artikkeli &quot;Normaaliksi&quot;';
$hesklang['ason']='Artikkeli on merkattu &quot;Kiinnitetyksi&quot;';
$hesklang['asoff']='Artikkeli on merkattu &quot;Normaaliksi&quot;';
$hesklang['ts']='Käytetty aika';
$hesklang['start']='Aloita / Pysäytä';
$hesklang['reset']='Tyhjennä';
$hesklang['save']='Tallenna';
$hesklang['hh']='Tunnit';
$hesklang['mm']='Minuutit';
$hesklang['ss']='Sekunnit';
$hesklang['thist']='Tiketin historia';
$hesklang['thist13']='<li class="smaller">%s | yhdistetty tiketin %s kanssa käyttäjän %s toimesta</li>'; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class="smaller">%s | työskennelty aika päivitetty %s:ksi käyttäjän %s toimesta</li>'; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class="smaller">%s | lähetetty käyttäjän %s toimesta</li>'; // %s = date, user making change
$hesklang['thist16']='<li class="smaller">%s | lähetetty POP3-haulla</li>';
$hesklang['twu']='Tikettiin käytetty aika on päivitetty.';
$hesklang['autoss']='Käynnistä ajastin automaattisesti, kun avaan tiketin';
$hesklang['ful']='Tiedostolatauksen raja';
$hesklang['ufl']='Voit ladata seuraavia tiedostomuotoja:';
$hesklang['nat']='Liitteiden enimmäismäärä:';
$hesklang['mfs']='Liitteen enimmäiskoko:';
$hesklang['lps']='Kielivalintasi on tallennettu';
$hesklang['sav']='Näytä artikkelin näyttökerrat';
$hesklang['sad']='Näytä artikkelin päiväys';
$hesklang['emp']='Sinun PHP:lla ei ole otettu käyttöön MySQL-tukea (mysqli -laajennus vaaditaan)';
$hesklang['epd']='[HESK] Sähköpostin ketjutus on otettu pois käytöstä asetuksissa';
$hesklang['pfd']='[HESK] POP3 on otettu pois käytöstä asetuksissa';
$hesklang['pem']='[Ketjutettu sähköposti]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Asiakas]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='Sähköposti';
$hesklang['pop3']='POP3 haku';
$hesklang['pop3h']='POP3 Isäntä';
$hesklang['pop3p']='POP3 Portti';
$hesklang['pop3tls']='TLS Protokolla';
$hesklang['pop3u']='POP3 Käyttäjänimi';
$hesklang['pop3w']='POP3 salasana';
$hesklang['pop3e']='POP3 Virhe';
$hesklang['pop3log']='POP3 yhteyden loki';
$hesklang['mysqltest']='Testaa MySQL-yhteys';
$hesklang['smtptest']='Testaa SMTP-yhteys';
$hesklang['pop3test']='Testaa POP3-yhteys';
$hesklang['contest']='Testataan yhteyttä, tämä voi kestää hetken...';
$hesklang['conok']='Yhteys onnistui!';
$hesklang['conokn']='Kuitenkin, jos palvelimesi vaatii käyttäjänimen ja salasanan, sähköpostia ei lähetetä!';
$hesklang['saving']='Tallennetaan asetuksia, odota hetki...';
$hesklang['sns']='Asetukset tallennettu, mutta jotkin toiminnot otettiin pois käytöstä epäonistuneiden testien takia.';
$hesklang['looph']='Enimmäismäärä osumia';
$hesklang['loopt']='Ajanjakso';
$hesklang['didum']='Tarkoititko %s?'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Kyllä, korjaa se';
$hesklang['nole']='En, jätä huomiotta';
$hesklang['sconfe2']='Näytä &quot;Vahvista sähköposti&quot; -kenttä tiketin lähetyslomakkeella';
$hesklang['oln']='Vanha nimi:';
$hesklang['nen']='Uusi nimi:';
$hesklang['use_form_below']='<i>Käytä tätä lomaketta lähettääksesi tiketin. Pakolliset kentät on merkitty</i>';
$hesklang['esf']='Ei voitu lähettää sähköposti-ilmoituksia.';
$hesklang['qrr']='(lainattu vastaus poistettu)';
$hesklang['remqr']='Poista lainattu vastaus';
$hesklang['remqr2']='Poista lainattu vastaus asiakkaan sähköpostista';
$hesklang['suge']='Tarkista sähköpostin kirjoitusvirheet';
$hesklang['epro']='Sähköpostipalveluntarjoajat';
$hesklang['email_noreply']='&quot;From:&quot; sähköposti';
$hesklang['email_name']='&quot;From:&quot; nimi';
$hesklang['vscl']='Palvelimen konfiguraation rajat';
$hesklang['fnuscphp']='Tiedoston lataus epäonnistui, kokeile uudestaan pienemmällä tiedostolla tai ilman liitetiedostoa.';
$hesklang['redv']='resetoi oletusnäkymä';
$hesklang['fatte1']='Liitteidesi asetus &quot;Kappaletta per viesti&quot; on suurempi kuin mitä palvelin sallii!';
$hesklang['fatte2']='Liitteidesi enimmäiskoko on suurempi kuin mitä palvelin sallii!';
$hesklang['fatte3']='Palvelin ei salli tarpeeksi isoja viestejä, yritä vähentää liitteiden määrää tai sallittua tiedostokokoa!';
$hesklang['embed']='Upotetut tiedostot';
$hesklang['embed2']='Tallenna upotetut tiedostot liitteiksi';
$hesklang['emrem']='(kuva poistettu)';
$hesklang['hdemo']='(PIILOTETTU DEMOSSA)';
$hesklang['ddemo']='Valitettavasti tämä ominaisuus on pois käytöstä demossa!';
$hesklang['sdemo']='Muutoksien tallentaminen on pois käytöstä demossa';
$hesklang['hud']='HESK on ajan tasalla';
$hesklang['hnw']='Päivitys saatavilla';
$hesklang['getup']='Päivitä HESK';
$hesklang['updates']='Päivitykset';
$hesklang['updates2']='Tarkista HESK-päivitykset automaattisesti.';

// Added in version 2.5.0
$hesklang['attdel']='tämä tiedosto on poistettu palvelimelta eikä sitä voi enää ladata';
$hesklang['dsen']='Älä lähetä tästä vastauksesta sähköposti-ilmoitusta asiakkaalle';
$hesklang['attrem']='* Joitakin liitettyjä tiedostoja poistettiin *';
$hesklang['attnum']='Enimmäismäärä saavutettu: %s'; // %s will show attachment name
$hesklang['attsiz']='Tiedosto on liian suuri: %s'; // %s will show attachment name
$hesklang['atttyp']='Typpi ei ole sallittu: %s'; // %s will show attachment name
$hesklang['adf']='Ylläpitäjän kansio';
$hesklang['atf']='Liitteet-kansio';
$hesklang['err_adf']='Valittua ylläpitäjän kansiota (%s) ei ole olemassa!'; // %s will show folder name
$hesklang['err_atf']='Valittua liitteet-kansiota (%s) ei ole olemassa!'; // %s will show folder name
$hesklang['err_atr']='Valittu liitteet-kansio (%s) on kirjoitussuojattu!'; // %s will show folder name
$hesklang['fatt']='Tähän viestiin liitetyt tiedostot:';
$hesklang['wrepo']='Kirjoita vastaus, kun olet avannut tiketin uudelleen.';
$hesklang['ktool']='&raquo; Tukitietokannan työkalut';
$hesklang['uac']='Varmista ja päivitä kategorian artikkelien lukumäärä';
$hesklang['acv']='Artikkelien lukumäärä on varmistettu';
$hesklang['xyz']='Julkisten, yksityisten ja artikkeliluonnosten lukumäärä tässä kategoriassa.';
$hesklang['reports_tab']='Tee raportteja'; // Tab title
$hesklang['can_run_reports_full']='Voi tehdä raportteja (kaikki)';
$hesklang['can_export']='Voi viedä tikettejä';
$hesklang['roo']='<i>(vain sinulle osoitetut tiketit sisältyvät tähän raporttiin)</i>';
$hesklang['shu']='Lyhyet linkit';
$hesklang['export']='Vie tikettejä'; // Tab title
$hesklang['export_btn']='Vie tiketit'; // Button title
$hesklang['export_intro']='Tämä työkalu sallii sinun viedä tiketit XML-muotoon, joka on avattavissa Excelillä.';
$hesklang['stte']='Valitse vietävät tiketit';
$hesklang['dtrg']='Ajanjakso';
$hesklang['sequentially']='Peräkkäin'; // Order tickets: Sequentially
$hesklang['ede']='Ei voi luoda vientikansiota, luo itse kansio <b>export</b> liitteet-kansion alle ja varmista, että PHP:lla on siihen kirjoitusoikeudet (Linuxissa CHMOD 777 - rwxrwxrwx).';
$hesklang['eef']='Ei voi luoda vientikansiota, kansioon ei ole kirjoitusoikeuksia.';
$hesklang['inite']='Aloitetaan vienti';
$hesklang['gXML']='Luodaan XML-tiedostoa';
$hesklang['nrow']='Vietyjen rivien määrä: %d'; // %d will show number of rows exported
$hesklang['cZIP']='Pakataan tiedostoa zip-muotoon';
$hesklang['eZIP']='Virhe luotaessa zip-tiedostoa';
$hesklang['fZIP']='Tiedoston pakkaaminen valmis';
$hesklang['pmem']='Muistin käytön huippu: %.2f Mb'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo; KLIKKAA TÄSTÄ LADATAKSESI VIEDYN TIEDOSTON &raquo;';
$hesklang['n2ex']='Ei löytynyt tikettejä, jotka vastaisivat hakuasi, ei mitään vietävää!';
$hesklang['sp']='SPAMin esto'; // For settings page
$hesklang['sit']='-&gt; Kuvan tyyppi';
$hesklang['sis']='Yksinkertainen kuva';
$hesklang['rcpb']='Verkkosivuston avain (Yleinen avain)';
$hesklang['rcpv']='Salainen avain (Yksityinen avain)';
$hesklang['pop3keep']='Tallenna kopio';
$hesklang['beta']='(TESTIVERSIO)';
$hesklang['maxpost']='Luultavasti yritit antaa enemmän tietoa kuin tämä palvelin sallii.<br /><br />Yritä lähettää lomake uudelleen pienemmillä liitteillä tai ilman niitä.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='Virheellinen roskapostinestovastaus, kokeile uudestaan.';

// Added in version 2.6.0
$hesklang['ticket_closed']='[#%%TRACK_ID%%] Tiketti suljettu/ratkaistu';
$hesklang['ms01']='Tam';
$hesklang['ms02']='Hel';
$hesklang['ms03']='Maa';
$hesklang['ms04']='Huh';
$hesklang['ms05']='Tou';
$hesklang['ms06']='Kes';
$hesklang['ms07']='Hei';
$hesklang['ms08']='Elo';
$hesklang['ms09']='Syy';
$hesklang['ms10']='Lok';
$hesklang['ms11']='Mar';
$hesklang['ms12']='Jou';
$hesklang['sdf']='Lähetetyn päivämäärän muoto';
$hesklang['lcf']='Päivitetyn päivämäärä muoto';
$hesklang['lcf0']='Lyhyt kuvaus';
$hesklang['lcf1']='päivämäärä ja aika';
$hesklang['lcf2']='HESK-tyyli';
$hesklang['ticket_tpl']='Tikettien mallit';
$hesklang['can_man_ticket_tpl']='Voi ylläpitää tikettien malleja'; // Permission title
$hesklang['ticket_tpl_man']='Ylläpidä tikettien malleja'; // Page and link title
$hesklang['ticket_tpl_intro']='Luo ja muokkaa tikettien malleja, jotta voit nopeasti lähettää uuden tiketin ylläpitäjän käyttöliittymästä.';
$hesklang['no_ticket_tpl']='Ei tikettien malleja';
$hesklang['ticket_tpl_title']='Otsikko';
$hesklang['delete_tpl']='Oletko varma, että haluat poistaa tämän mallin?';
$hesklang['new_ticket_tpl']='Lisää tai muokkaa tiketin mallia';
$hesklang['ticket_tpl_add']='Luo uusi tiketin malli';
$hesklang['ticket_tpl_edit']='Muokkaa valittua tiketin mallia';
$hesklang['save_ticket_tpl']='Tallenna tiketin malli';
$hesklang['ticket_tpl_saved']='Tiketin mallisi on tallennettu myöhempää käyttöä varten';
$hesklang['ticket_tpl_removed']='valittu tiketin malli on poistettu tietokannasta';
$hesklang['ticket_tpl_not_found']='tiketin mallia ei löydetty';
$hesklang['sel_ticket_tpl']='Valitse tiketin malli, jota haluat muokata';
$hesklang['ent_ticket_tpl_title']='Anna mallin otsikko';
$hesklang['ent_ticket_tpl_msg']='Anna mallin viesti';
$hesklang['ticket_tpl_id']='Puuttuva tiketin mallin tunnus';
$hesklang['select_ticket_tpl']='Valitse tiketin malli';
$hesklang['list_tickets_cat']='Listaa kaikki tiketit tässä kategoriassa';
$hesklang['def_msg']='[Ei viestiä]';
$hesklang['emlreqmsg']='Vaadi viesti';
$hesklang['emlreqmsg2']='Hylkää ketjutetut/haetut sähköpostit, joissa ei ole viestiä';
$hesklang['relart']='Vastaavat artikkelit'; // Title of related articles box
$hesklang['s_relart']='Vastaavat artikkelit'; // On settings page
$hesklang['tab_7']='Tikettien lista';
$hesklang['fitl']='Kenttiä tikettien listassa';
$hesklang['submitted']='Lähettänyt';
$hesklang['clickemail']='View';
$hesklang['set_pri_to']='Aseta prioriteetiksi:'; // Action below the ticket list
$hesklang['pri_set_to']='prioriteetiksi on asetettu:';
$hesklang['cat_pri']='Kategorian prioriteettia käytetään, kun asiakkaat eivät voi valita prioriteettia ja tiketti on lähetetty käyttäjän liittymästä.';
$hesklang['cat_pri_info']='Asiakkaittesi on sallittu valita prioriteetti, joten kategorian prioriteetti jätetään huomiotta.<br /><br />Käyttääksesi kategorian prioriteettia sen sijaan, ota pois käytöstä seuraava ominaisuus HESKin asetuksista:';
$hesklang['def_pri']='Kategorian prioriteetti:';
$hesklang['ch_cat_pri']='Aseta kategorian prioriteetti';
$hesklang['cat_pri_ch']='Kategorian prioriteetiksi on asetettu:';
$hesklang['err_dbversion']='Liian vanha MySQL versio:';
$hesklang['ip_whois']='IP whois';
$hesklang['ednote']='Muokkaa viestin merkintää';
$hesklang['ednote2']='Merkintä viestiin tallennettu';
$hesklang['perm_deny']='Lupa evätty';
$hesklang['mis_note']='Puuttuva merkinnän tunnus';
$hesklang['no_note']='Merkintää tällä tunnuksella ei löydetty';
$hesklang['sacl']='Tallenna ja jatka myöhemmin';
$hesklang['reply_saved']='Vastausviestisi on tallennettu myöhempää käyttöä varten.';
$hesklang['submit_as']='Lähetä seuraavana:';
$hesklang['sasc']='Lähetä asiakkaan vastauksena';
$hesklang['creb']='Asiakkaan vastauksen on antanut:';
$hesklang['show_select']='Näytä &quot;Klikkaa valitaksesi&quot; oletustoimintona';
// Settings
$hesklang['mms']='Ylläpitotila';
$hesklang['mmd']='Ota ylläpitotila käyttöön';
// Customer notice
$hesklang['mm1']='Ylläpito käynnissä';
$hesklang['mm2']='Ajastettujen huoltotoimenpiteiden vuoksi tukipalvelumme on tilapäisesti suljettu.';
$hesklang['mm3']='Pahoittelemme häiriötä ja pyydämme palaamaan uudestaan hetken kuluttua.';
// Staff notice
$hesklang['mma1']='Huoltotila on aktiivinen!';
$hesklang['mma2']='Asiakkaat eivät voi käyttää tukipalvelua.';
$hesklang['tools']='Työkalut';
$hesklang['banemail']='Estä sähköposteja';
$hesklang['banemail_intro']='Estä tikettien lähetys tietyistä sähköpostiosoitteista';
$hesklang['no_banemails']='<i>Ei estettyjä sähköposteja.</i>';
$hesklang['eperm']='Pysyvät sähköpostiestot:';
$hesklang['bananemail']='Estettävä sähköposti';
$hesklang['savebanemail']='Estä tämä sähköposti';
$hesklang['enterbanemail']='Syötä sähköposti, jonka haluat estää.';
$hesklang['validbanemail']='Syltä validi sähköposti (<i>john.doe@example.com</i>) tai sähköpostidomain (<i>@example.com</i>)';
$hesklang['email_banned']='Sähköpostiosoite <i>%s</i> estettiin ja HESK ei enää vastaanota tikettejä tästä osoitteesta.'; // %s will be replaced with email
$hesklang['emailbanexists']='Sähköpostiosoite <i>%s</i> on jo estetty.'; // %s will be replaced with email
$hesklang['email_unbanned']='Sähköpostiesto poistettu';
$hesklang['banby']='Bannattu käyttäjän toimesta';
$hesklang['delban']='Poista esto';
$hesklang['delban_confirm']='Poista tämä esto?';
$hesklang['baned_e']='Uusien tikettien lähettäminen on estetty sinulta.';
$hesklang['baned_ip']='Sinut on estetty tästä tukipalvelusta';
$hesklang['can_ban_emails']='Voi estää sähköposteja';
$hesklang['can_unban_emails']='Voi poistaa sähköpostiestoja (ottaa käyttöön Voi estää sähköposteja)';
$hesklang['eisban']='Tämä sähköpostiosoite on estetty.';
$hesklang['click_unban']='Klikkaa tästä poistaaksesi eston.';
$hesklang['banip']='Estetyt IP:t';
$hesklang['banip_intro']='Vierailijat tästä IP-osoiteeeesta on estetty, eivätkä he voi nähdä tai lähettää tikettejä eivätkä kirjautua tukipalveluun.';
$hesklang['ipperm']='Pysyvät IP-estot:';
$hesklang['iptemp']='epäonnistuneiden kirjautumisyritysten estot:';
$hesklang['savebanip']='estä tämä IP';
$hesklang['no_banips']='<i>Ei yhtään IP:tä estetty.</i>';
$hesklang['bananip']='Estettävä IP-osoite';
$hesklang['banex']='Esimerkkejä:';
$hesklang['iprange']='IP-väli';
$hesklang['ippermban']='Estä tämä IP pysyvästi';
$hesklang['enterbanip']='Anna IP-osoite tai -väli, jonka haluat estää.';
$hesklang['validbanip']='Anna voimassaoleva IP-osoite tai IP-väli';
$hesklang['ip_banned']='IP-osoite <i>%s</i> on estetty eikä HESK enää vastaanota tikettejä tästä IP-osoiteeeesta.'; // %s will be replaced with IP
$hesklang['ip_rbanned']='IP-väli <i>%s</i> on estetty eikä HESK enää vastaanota tikettejä tältä IP-väliltä.'; // %s will be replaced with IP
$hesklang['ipbanexists']='IP-osoite <i>%s</i> on jo estetty.'; // %s will be replaced with IP
$hesklang['iprbanexists']='IP-väli <i>%s</i> on jo estetty.'; // %s will be replaced with IP
$hesklang['ip_unbanned']='IP-esto poistettu';
$hesklang['ip_tempun']='Tilapäinen IP-esto poistettu';
$hesklang['can_ban_ips']='Voi estää IP:tä';
$hesklang['can_unban_ips']='Voi poistaa eston IP:ltä (ottaa käyttöön Voi estää IP:tä)';
$hesklang['ipisban']='Tämä IP-osoite on estetty.';
$hesklang['m2e']='Umpeutuu (minuutissa)';
$hesklang['info']='Info';
$hesklang['sm_title']='Palveluviestit';
$hesklang['sm_intro']='Näytä palveluviesti asiakasalueella, esimerkikiksi tiedottaaksesi tunnetuista ongelmista tai tärkeistä uutisista.';
$hesklang['can_service_msg']='Voi muokata palveluviestejä';
$hesklang['new_sm']='Uusi palveluviesti';
$hesklang['edit_sm']='Muokkaa palveluviestiä';
$hesklang['ex_sm']='Olemassa olevat palveluviestit';
$hesklang['sm_author']='Kirjoittaja';
$hesklang['sm_type']='Tyyppi';
$hesklang['sm_published']='Julkaistu';
$hesklang['sm_draft']='Luonnos';
$hesklang['sm_style']='Tyyli';
$hesklang['sm_none']='Ei yhtään';
$hesklang['sm_success']='Success';
$hesklang['sm_info']='Info';
$hesklang['sm_notice']='Notice';
$hesklang['sm_error']='Error';
$hesklang['sm_save']='Tallenna palveluviesti';
$hesklang['sm_preview']='Esikatsele palveluviestiä';
$hesklang['sm_mtitle']='Otsikko';
$hesklang['sm_msg']='Viesti';
$hesklang['sm_e_title']='Anna palveluviestin otsikko';
$hesklang['sm_e_msg']='Annan palvelun viesti';
$hesklang['sm_e_id']='Puuttuva viestin tunnus';
$hesklang['sm_added']='Uusi huoltoviesti on lisätty';
$hesklang['sm_deleted']='Huoltoviesti poistettu';
$hesklang['sm_not_found']='Tätä huoltoviestiä ei ole olemassa';
$hesklang['no_sm']='Ei huoltoviestejä';
$hesklang['del_sm']='Poista tämä huoltoviesti?';
$hesklang['sm_mdf']='Huoltoviesti tallennettu';
$hesklang['sska']='Näytä ehdotetut artikkelit';
$hesklang['taws']='Näitä artikkeleita ehdotettiin:';
$hesklang['defaults']='Oletukset';
$hesklang['pncn']='Valitse "ilmoita asiakkaalle"-vaihtoehto uuden tiketin lomakkeella';
$hesklang['pncr']='Valitse "ilmoita asiakkaalle"-vaihtoehto tiketin vastauslomakkeella';
$hesklang['pssy']='Näytä, mitä tukitietokannan artikkeleja ehdotettiin asiakkaille';
$hesklang['ccct']='Asiakkaan ratkaisu';
$hesklang['custnot']='Ilmoita asiakkaille, kun';
$hesklang['notnew']='Uusi tiketti on lähetetty';
$hesklang['notclo']='Tiketti on merkitty Ratkaistuksi';
$hesklang['enn']='Paitsi sähköpostin ketjutuksessa/POP3 haussa, jos sähköpostin otsikko sisältää:';
$hesklang['spamn']='SPAM huomautus';
$hesklang['spam_inbox']='<span style="color:red"><b>Ei vahvistussähköpostia?</b><br />Olemme lähettäneet vahvitusviestin sähköpostiisi. Jos et saa sitä muutaman minuutin kuluessa, tarkista roskapostikansiosi. Merkitse viesti <b>Ei SPAM</b> vastaanottaaksesi viestimme jatkossa.</span>';
$hesklang['ekb_n']='<b>EI</b>, ota tukitietokanta pois käytöstä';
$hesklang['ekb_y']='<b>KYLLÄ</b>, ota tukitietokanta käyttöön';
$hesklang['ekb_o']='<b>KYLLÄ</b>, käytä HESKiä vain tukitietokantana (<i>ota tukipalvelu pois käytöstä</i>)';
$hesklang['kb_set']='tukitietokannan asetukset';
$hesklang['kbo1']='Vain tukitietokanta-tila';
$hesklang['kbo2']='<br /><br />Vierailijat eivät voi lähettää tikettejä vaan heidät ohjataan automaattisesti tukitietokantaan.';
$hesklang['fpass']='Unohditko salasanasi?';
$hesklang['passr']='Salasanan palautus';
$hesklang['passa']='Salli käyttäjien palauttaa unohtunut salasana sähköpostin avulla';
$hesklang['passe']='Anna sähköpostiosoitteesi';
$hesklang['passs']='Lähetä minulle linkki salasanan palauttamiseen';
$hesklang['noace']='Tällä sähköpostiosoitteella ei löytynyt asiakastiliä';
$hesklang['pemls']='Lähetimme sinulle sähköpostin, jossa on ohjeet salasanan palauttamiseen';
$hesklang['reset_password']='Palauta tukipisteen salasanasi'; // Email subject
$hesklang['ehash']='virheellinen tai erääntynyt sähköpostin palautuslinkki';
$hesklang['ehaip']='väärä IP-osoite. Salasanan voi palauttaa vain samasta IP-osoitteesta, mistä pyyntö lähetettiin.';
$hesklang['resim']='<b>Aseta uusi salasana alla olevassa lomakkeessa!</b>';
$hesklang['permissions']='Oikeudet';
$hesklang['atype']='Tilin tyyppi';
$hesklang['astaff']='Henkilökunta';
$hesklang['oon1']='Lähetä minulle vain avoimet tiketit';
$hesklang['oon2']='Lähetä minulle kaikki tikettini';
$hesklang['anyown']='Kuka tahansa omistaja';
$hesklang['pfr']='Toinen POP3 hakutehtävä on vielä meneillään.';
$hesklang['pjt']='Tehtävän aika umpeutunut';
$hesklang['pjt2']='minuuttia alkamisen jälkeen';
$hesklang['nkba']='Tukitietokannan haku vaatii riittävästi yksilöllisiä artikkeleita toimiakseen kunnolla.<br /><br />Harkitse lisääväsi lisää artikkeleita tukitietokantaan parantaaksesi hakutuloksia ja artikkelien ehdotuksia.';
$hesklang['saa']='Lukitut artikkelit näytetään artikkelilistan ylimmäisinä';
$hesklang['yhbr']='Sinut on lukittu ulos systeemistä %s minuutiksi liian monen tikettivastauksen vuoksi.';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='fi';

// Added in version 2.7.0
$hesklang['imap']='IMAP Fetching';
$hesklang['imaph']='IMAP Host';
$hesklang['imapp']='IMAP Port';
$hesklang['enc']='Salaus';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='Ei mitään';
$hesklang['imapu']='IMAP Käyttäjätunnus';
$hesklang['imapw']='IMAP Salasana';
$hesklang['imaptest']='Testaa IMAP-yhteys';
$hesklang['ifd']='[HESK] IMAP FETCHING IS DISABLED IN SETTINGS';
$hesklang['iei']='[HESK] PHP IMAP extension is not installed.';
$hesklang['ifr']='Another IMAP fetching task is still in progress.';
$hesklang['arp']='Uudelleenlataa sivu automaattisesti';
$hesklang['arpp']='Uudelleenlataa tikettilistasivu automaattisesti jälkeen:';
$hesklang['seconds']='sekuntia';
$hesklang['minutes']='minuuttia';
$hesklang['atbr']='Tämä tiketti tulee osoittaa, ennen kuin siihen voi vastata.';
$hesklang['attm']='Osoita tämä tiketti minulle';
$hesklang['owneed']='Omistaja vaaditaan';
$hesklang['taat']='Tämä tiketti on jo osoitettu käyttäjälle <b>%s</b>.';
$hesklang['scoy']='Haluatko varmasti osoittaa tämän itsellesi?';
$hesklang['scot']='Haluatko varmasti osoittaa tämän käyttäjälle %s?';
$hesklang['ycto']='KYLLÄ, vaihda omistaja';
$hesklang['ncto']='EI, säilytä nykyinen omistaja';
$hesklang['fass']='Omistaja vaaditaan';
$hesklang['req_sub']='Aihe vaaditaan';
$hesklang['req_msg']='Viesti vaaditaan';
$hesklang['req_email']='Sähköposti vaaditaan';
$hesklang['default_subject']='Tiketti käyttäjältä %s';
$hesklang['off-hide']='Piilota asiakkaan lomakkeesta';
$hesklang['not_valid_email']='Syötä validi sähköpostiosoite tai jätä tämä kenttä tyhjäksi';
$hesklang['write_down']='<span style="color:red">Suosittelemme, että kirjoitat tiketin seurantatunnuksen ylös tulevaisuuden varalle.</span>';
$hesklang['re_confirm1']='Tämän ottaminen pois käytöstä ottaa myös "Sähköposti vaaditaan tikettien tarkasteluun" pois käytöstä kohdan "Turvallisuus" alta. Jatketaanko?';
$hesklang['re_confirm2']='Tämän ottaminen käyttöön ottaa myös "Sähköposti vaaditaan" käyttöön kohdan "Ominaisuudet" alta. Jatketaanko?';
$hesklang['can_email_tpl']='Voi muokata sähköpostimalleja';
$hesklang['et_title']='Muokkaa malleja';
$hesklang['et_intro']='Muokkaa henkilökunnalle ja asiakkaille lähetettäviä sähköposteja';
$hesklang['file']='Tiedosto';
$hesklang['efile']='Muokataan tiedostoa';
$hesklang['rdesc']='(Vastaanottaja) Kuvaus';
$hesklang['desc_forgot_ticket_id']='(Asiakas) Unohti tiketin seurantatunnuksen';
$hesklang['desc_new_reply_by_staff']='(Asiakas) Uusi henkilökunnan vastaus';
$hesklang['desc_new_ticket']='(Asiakas) Tiketti vastaanotettu';
$hesklang['desc_ticket_closed']='(Asiakas) Tiketti suljettu/ratkaistu';
$hesklang['desc_category_moved']='(Henkilökunta) Tiketti siirretty uuteen kategoriaan';
$hesklang['desc_new_reply_by_customer']='(Henkilökunta) Uusi asiakkaan vastaus';
$hesklang['desc_new_ticket_staff']='(Henkilökunta) Uusi tiketti lähetetty';
$hesklang['desc_ticket_assigned_to_you']='(Henkilökunta) Tiketti osoitettiin sinulle';
$hesklang['desc_new_pm']='(Henkilökunta) Uusi yksityisviesti';
$hesklang['desc_new_note']='(Henkilökunta) Uusi merkintä sinulle osoitettuun tikettiin';
$hesklang['desc_reset_password']='(Henkilökunta) Palauta salasanasi';
$hesklang['etfm']='Yksi tai useampi sähköpostimalli puuttuu.<br /><br />Varmista, että lataat kaikki sähköpostimallitiedostot <i>/language/%s/emails</i>-kansioon.';
$hesklang['etfw']='Jotkin sähköpostimallit eivät ole kirjotettavissa.<br /><br />
                    Varmista, että PHP:lla on kirjoitusoikeudet kaikkiin <i>/language/%s/emails</i>-kansion tiedostoihin.<br /><br />
                    Unix-palvelimilla sinun saattaa täytyä muuttaa tiedostojen oikeudet CHMOD:n avulla muotoon 666 (rw-rw-rw-)';
$hesklang['et_e_id']='Puuttuva mallin tunnus';
$hesklang['et_fm']='Tämän sähköpostimallin tiedosto puuttuu';
$hesklang['et_fw']='Tämän sähköpostimallin tiedosto ei ole kirjoitettavissa';
$hesklang['et_save']='Tallenna sähköpostimalli';
$hesklang['updated_on']='Päivitetty';
$hesklang['ticket_url']='Tiketin URL';
$hesklang['pm_url']='Yksityisviestin URL';
$hesklang['et_num']='Tikettien lukumäärä';
$hesklang['et_list']='Tukitikettien lista';
$hesklang['et_empty']='Sähköpostimalli ei voi olla tyhjä';
$hesklang['et_saved']='Sähköpostimalli tallennettu';
$hesklang['source']='Lähde';
$hesklang['select_category']='Valitse kategoria';
$hesklang['select_category_text']='Kuinka voimme auttaa?';
$hesklang['select_category_staff']='Valitse tiketin kategoria';
$hesklang['scat']='Kategorian valinnan raja';
$hesklang['scat2']='(valintalaatikko näytetään, jos kategorioiden määrä on korkeampi)';
$hesklang['new_cf']='Uusi räätälöity kenttä';
$hesklang['cf_intro']='Käytä tätä ominaisuutta lisätäksesi räätälöityjä kenttiä Lähetä tiketti -lomakkeelle kerätäksesi ylimääräisiä tietoja asiakkailta.';
$hesklang['cf_public']='Julkinen';
$hesklang['cf_private']='Vain henkilökunta';
$hesklang['cf_cust']='Asiakkaille';
$hesklang['cf_all']='Kaikki';
$hesklang['cf_cat']='Valittu';
$hesklang['cf_ctrl']='Vinkki: Paina pohjassa CTRL valitaksesi useampia kategorioita';
$hesklang['visibility']='Näkyvyys';
$hesklang['cf_save']='Tallenna räätälöity kenttä';
$hesklang['ex_cf']='Aktiiviset räätälöidyt kentät';
$hesklang['no_cf']='Ei aktiivisia räätälöityjä kenttiä';
$hesklang['del_cf']='Poistetaanko tämä räätälöity kenttä? Tämä poistaa myös kaikki kentän tallennetut tiedot tietokannasta!';
$hesklang['cf_e_id']='Virheellinen tunnus';
$hesklang['edit_cf']='Muokkaa räätälöityä kenttää';
$hesklang['cf_deleted']='Räätälöity kenttä poistettu';
$hesklang['cf_not_found']='Tätä räätälöityä kenttää ei ole olemassa';
$hesklang['cf_added']='Uusi räätälöity kenttä lisätty';
$hesklang['cf_nocat']='Valitse vähintään yksi kategoria tälle räätälöidylle kentälle';
$hesklang['cf_mdf']='Räätälöity kenttä tallennettu';
$hesklang['atl1']='Syötä vähintään yksi vaihtoehto.';
$hesklang['sch']='Piilotettu';
$hesklang['meml3']='Salli usean sähköpostiosoitteen syöttäminen';
$hesklang['dmin']='Pienin sallittu päivämäärä';
$hesklang['dmax']='Suurin sallittu päivämäärä';
$hesklang['d_day']='päivä()';
$hesklang['d_week']='viikko(a)';
$hesklang['d_month']='kuukausi(a)';
$hesklang['d_year']='vuosi(a)';
$hesklang['d_any']='Mikä tahansa päivämäärä';
$hesklang['d_fixed']='Kiinteä päivämäärä';
$hesklang['d_relative']='Suhteellinen päivämäärä';
$hesklang['d_mm']='Pienin päivämäärä ei voi olla suurempi kuin suurin päivämäärä';
$hesklang['d_emin']='Pienin päivämäärä <i>%s</i> on %s';
$hesklang['d_emax']='Suurin päivämäärä <i>%s</i> on %s';
$hesklang['d_format']='Päivämäärän muoto';
$hesklang['d_custom']='Räätälöity muoto';
$hesklang['d_ci']='VAIN EDISTYNEILLE KÄYTTÄJILLE: validi PHP-päivämäärämuoto, tarkista PHP-manuaalista.';
$hesklang['cf_noe']='Syötä validi sähköpostiosoite <i>%s</i>';
$hesklang['cf_noem']='Syötä yksi tai useampi validi sähköpostiosoite <i>%s</i>';
$hesklang['can_resolve']='Voi merkitä tikettejä ratkaistuksi';
$hesklang['can_change_own_cat']='Voi vaihtaa tiketin kategorian (sallittuun)';
$hesklang['can_submit_any_cat']='Voi lähettää tikettejä mihin tahansa kategoriaan';
$hesklang['noauth_submit']='Sinulla ei ole oikeuksia lähettää tikettejä tähän kategoriaan!';
$hesklang['noauth_move']='Sinulla ei ole oikeuksia siirtää tikettejä tähän kategoriaan!';
$hesklang['noauth_resolve']='Sinulla ei ole oikeuksia merkitä tikettejä ratkaistuksi!';
$hesklang['force_ssl']='Pakota SSL-yhteydet';
$hesklang['d_ssl']='<i>estetty</i> - avaa tämä sivu käyttäen https:// ylläpitääksesi tätä asetusta';
$hesklang['scno']='Tätä tilaa ei voida vaihtaa';
$hesklang['statuses']='Tilat';
$hesklang['statuses_intro']='Käytä tätä työkalua lisätäksesi räätälöityjä tikettien tiloja tukipalveluusi';
$hesklang['color']='Väri';
$hesklang['csscl']='CSS-luokka tai väri';
$hesklang['clr_view']='Värin esikatselu';
$hesklang['cbc']='Asiakkaan muokattavissa';
$hesklang['ccc']='Voivatko asiakkaat vaihtaa tätä tilaa?';
$hesklang['del_status']='Poistetaanko tämä tila?';
$hesklang['ex_status']='Olemassa olevat tilat';
$hesklang['status_hesk']='Sisäänrakennetut tilat (ei voi muokata tätä kautta)';
$hesklang['status_custom']='Räätälöidyt tilat';
$hesklang['status_custom_none']='Ei räätälöityjä tiloja. Voit lisätä niitä käyttämällä yllä olevaa lomaketta.';
$hesklang['status_save']='Tallenna tila';
$hesklang['list_tkt_status']='Listaa kaikki tiketit, jotka ovat tässä tilassa';
$hesklang['new_status']='Uusi räätälöity tila';
$hesklang['edit_status']='Muokkaa räätälöityä tilaa';
$hesklang['err_status']='Syötä tilan nimi';
$hesklang['status_added']='Uusi räätälöity tila lisätty';
$hesklang['status_e_id']='Virheellinen tunnus';
$hesklang['status_mdf']='Räätälöity tila tallennettu';
$hesklang['status_deleted']='Räätälöity tila poistettu';
$hesklang['status_not_found']='Tätä räätälöityä tilaa ei ole olemassa';
$hesklang['status_not_empty']='Tätä tilaa ei voi poistaa koska tässä tilassa on tikettejä';
$hesklang['status_limit']='Olet luonut 100 räätälöityä tilaa, et voi luoda uusia.';
$hesklang['public_link']='Julkinen linkki';
$hesklang['frames']='Kehykset';
$hesklang['frames2']='Estä HESKin lataaminen kehykseen kolmannen osapuolten domaineissa';
$hesklang['numsub']='Lähetetyt tiketit';
$hesklang['hidf']='Piilotetut kentät eivät ole näkyvissä asiakkaalle Lähetä tiketti -lomakkeella (arvo on silti näkyvissä tiketin tiedoissa jos ne on merkitty julkisiksi). Ne käyttäytyvät normaalien tekstikenttien lailla henkilökunnalle.';
$hesklang['rcheck']='Älä valitse oletusvaihtoehtoa';
$hesklang['refresh_page']='Päivitä tämä sivu';
$hesklang['del_kba']='Poista tämä artikkeli';
$hesklang['del_kbaa']='Poista tämä artikkeli pysyvästi';
$hesklang['hni1']='HESKiä ei ole vielä asennettu?';
$hesklang['hni2']='Vaikuttaa siltä, että tätä tukipalvelua ei ole vielä asennettu ja konfiguroitu oikein.';
$hesklang['hni3']='Asentaaksesi HESKin, seuraa <a href="docs/">dokumentaation ohjeita</a>';
$hesklang['cf']='Välimuistin kansio';
$hesklang['e_cdir']='HESK ei voi jäsennellä sähköposteja tai välimuistin tuloksia, ellei välimuistikansiota ole olemassa ja kirjoitettavissa.';
$hesklang['step1']='Vaihe 1';
$hesklang['step2']='Vaihe 2';
$hesklang['dffs']='Kun lataus on valmis, poista tiedosto palvelimelta';
$hesklang['fd']='Vientitiedosto poistettu palvelimelta';

// Added in version 2.8.0
$hesklang['TZ']='Aikavyöhyke';
$hesklang['thist17']='<li class="smaller">%s | lähetetty IMAP-haun kautta</li>';
$hesklang['sir3']='Näkymätön reCAPTCHA';
$hesklang['invisible']='näkymätön';
$hesklang['imap_not']='PHP ei sisällä IMAP-tukea';
$hesklang['imap_warning']='käyttäjällä %1$s on sama sähköpostiosoite kuin IMAP-haussa käyttämäsi osoite: %2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='käyttäjällä %1$s on sama sähköpostiosoite kuin POP3-haussa käyttämäsi osoite: %2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='Tämä voi johtaa sähköpostiluuppiin, jossa uusia tikettejä luodaan käyttäjän sähköposti-ilmoituksista. Haussa käyttämäsi sähköpostiosoitteen tulisi olla uniikki ja muiden ei tulisi käyttää sitä.';
$hesklang['can_view_ass_by']='Voi tarkastella muille osoittamiaan tikettejä';
$hesklang['can_privacy']='Voi anonymisoida tikettejä';
$hesklang['confirm_anony']='Anonymisoi tämä tiketti';
$hesklang['anon_selected']='Anonymisoi valitut tiketit';
$hesklang['privacy_anon_info']='Poistaa kaikki tunnistetiedot ja sisällön tiketeistä (asiakkaan nimi, sähköpostiosoite, viesti, liitteet, IP-osoite...), mutta säilyttää tiketit tietokannassa tilastoja varten (oikeus tulla unohdetuksi).';
$hesklang['success_anon']='Tiketti anonymisoitu onnistuneesti';
$hesklang['num_tickets_anon']='Anonymisoitujen tikettien lukumäärä: <b>%d</b>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Asiakas]'; // Customer name in anonymized tickets
$hesklang['anon_email']=''; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Aihe]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Viesti]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class="smaller">%s | anonymisoitu henkilön %s toimesta</li>';
$hesklang['print_selected']='Tulosta valitut tiketit';
$hesklang['with_selected']='Valituille:';
$hesklang['assign_selected']='Osoita valitut käyttäjälle:';
$hesklang['assign_no']='Omistajaa ei valittu, muutoksia ei tehty';
$hesklang['assign_1']='Valitut tiketit on asetettu osoittamattomiksi.';
$hesklang['assign_2']='Tiketti ID:llä %1$s asetettu osoittamattomaksi'; // %1$s = ticket numerical ID
$hesklang['assign_3']='%1$s virhe: on jo osoitettu henkilölle %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s osoitettu henkilölle %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='%1$s virhe: käyttäjällä %2$s ei ole oikeuksia tiketin kategoriaan'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='Tikettien massaosoituksen tulos:<br /><br />Osoitettu: %1$s<br />Virhe: %2$s<br /><br />Loki:<br /><pre>%3$s</pre>'; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='IP-osoite';
$hesklang['moret']='Lisää vaihtoehtoja'; // More options button title
$hesklang['btn_more']='Lisää'; // More options button text
$hesklang['btn_print']='Tulosta';
$hesklang['btn_edit']='Muokkaa';
$hesklang['btn_lock']='Lukitse tiketti';
$hesklang['btn_unlock']='Poista tiketin lukitus';
$hesklang['btn_tag']='Merkitse tiketti';
$hesklang['btn_resend']='Lähetä sähköposti-ilmoitus uudestaan';
$hesklang['btn_untag']='Poista merkintä tiketistä';
$hesklang['btn_import_kb']='Vie tukitietokantaan';
$hesklang['btn_anony']='Anonymisoi tiketti';
$hesklang['btn_delt']='Poista tiketti';
$hesklang['btn_delr']='Poista vastaus';
$hesklang['ernf']='Vastausta ei löytynyt';
$hesklang['tns']='Tiketin ilmoitukset lähetettiin uudestaan';
$hesklang['rns']='Vastauksen ilmoitukset lähetettiin uudestaan';
$hesklang['fname']='Etunimi';
$hesklang['export_selected']='Vie valitut tiketit';
$hesklang['btn_export']='Vie XML:ksi Exceliä varten';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='Vastaukset';
$hesklang['team']='Tiimi';
$hesklang['sm_content']='Sisältö';
$hesklang['sm_settings']='Asetukset';
$hesklang['wizard_back']='Edellinen'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Seuraava'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Siirry asetuksiin';
$hesklang['sm_return_to_editing']='Palaa muokkaamaan';
$hesklang['email_tpl_title']='Otsikko';
$hesklang['edit_email_template']='Muokkaa sähköpostimallia';
$hesklang['err_no_settings_section']='Asetusosiota ei määritelty.';
$hesklang['this_field_is_required']='Tämä kenttä on pakollinen';
$hesklang['reset_your_password']='Palauta salasanasi';
$hesklang['reset_password_instructions']='Ole hyvä ja täytä alla oleva lomake. Lähetämme sinulle linkin, jonka avulla voit palauttaa salasanasi.';
$hesklang['enter_email']='Syötä sähköpostiosoite';
$hesklang['password_reset_check_your_email']='Tarkista sähköpostisi';
$hesklang['password_reset_link_sent']='Lähetimme sinulle linkin salasanan palautusta varten.';
$hesklang['back_to_login']='Takaisin kirjautumiseen';
$hesklang['pager_first']='Ensimmäinen';
$hesklang['pager_previous']='Edellinen';
$hesklang['pager_next']='Seuraava';
$hesklang['pager_last']='Viimeinen';
$hesklang['new_team_member']='Uusi tiimin jäsen';
$hesklang['role']='Rooli';
$hesklang['optional']='Valinnainen';
$hesklang['edit_profile']='Muokkaa profiilia';
$hesklang['assigned_to']='Osoitettu henkilölle';
$hesklang['contact']='Yhteystiedot';
$hesklang['unban_email']='Uudelleensalli tämä sähköpostisoite';
$hesklang['unban_ip']='Uudelleensalli tämä IP-osoite';
$hesklang['show_previous_replies']='Näytä aiemmat vastaukset';
$hesklang['type_your_message']='Kirjoita viestisi'; // Used when there are no canned responses
$hesklang['close_button_text']='Sulje';
$hesklang['create_new_ticket']='Luo uusi tiketti';
$hesklang['delete_article']='Poista artikkeli';
$hesklang['view_existing_tickets']='Näytä olemassaolevat tiketit';
$hesklang['how_can_we_help']='Hei, kuinka voimme auttaa?';
$hesklang['search_for_articles']='Etsi artikkeleita';
$hesklang['submit_a_support_request']='Lähetä tukipyyntö';
$hesklang['verify_header']='Roskapostin esto';
$hesklang['ticket_details']='Tiketin yksityiskohdat';
$hesklang['yes_title_case']='Kyllä';
$hesklang['no_title_case']='Ei';
$hesklang['no_results_found']='Tuloksia ei löytynyt';
$hesklang['site_theme']='Sivuston teema';
$hesklang['test_theme_folder']='Testaa teemakansio';
$hesklang['test_theme_folder_description']='Etsitään teemakansiosta valideja teemoja. Vain kaikki testit läpäisevät teemat on asennettu oikein.';
$hesklang['err_site_theme']='Ole hyvä ja valitse Hesk-teema';
$hesklang['confirm']='Hyväksy';
$hesklang['confirm_deletion']='Hyväksy poisto';
$hesklang['confirm_delete_status']='Oletko varma, että haluat poistaa tämän räätälöidyn tilan?';
$hesklang['help_desk']='Help Desk'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.fi.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Ajan näyttäminen';
$hesklang['tdisd']='Päivämäärä ja aika';
$hesklang['tdisa']='Aikaa sitten (esim. 5 tuntia sitten)';
$hesklang['nav_templates']='Mallit'; // Admin panel navigation item
$hesklang['hide_replies']='Piilota tiketin vastaukset';
$hesklang['hide_replies_no']='Ei koskaan, näytä aina kaikki vastaukset';
$hesklang['hide_replies_yes']='Piilota kaikki vastaukset paitsi viimeisimmät:';
$hesklang['hide_replies_def']='Näytä viimeisin henkilökunnan vastaus ja sen jälkeiset asiakkaan vastaukset';
$hesklang['reply_by']='Vastannut'; // Reply by NAME
$hesklang['btt']='Takaisin ylös';
$hesklang['lwidth']='Rajoita tiketin leveyttä';
$hesklang['lwidtall']='Käytä suurinta mahdollista leveyttä';
$hesklang['lwidtpx']='Maksimileveys pikseleinä:';
// 3-letter days of the week
$hesklang['mon']='Maa';
$hesklang['tue']='Tii';
$hesklang['wed']='Kes';
$hesklang['thu']='Tor';
$hesklang['fri']='Per';
$hesklang['sat']='Lau';
$hesklang['sun']='Sun';
$hesklang['clear']='Tyhjennä'; // delete field value
$hesklang['first_day_of_week']='1'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='Vähintään yksi roskapostinestotoimenpide tulee olla valittuna!';
$hesklang['modules']='Moduulit';
$hesklang['modules_demo']='Tämä moduuli on saatavilla vain %s'; // %s = Hesk cloud link
$hesklang['see_demo']='Kokeile live-demoa täällä: %s'; // %s = Hesk demo link
$hesklang['statistics']['tab']='Statistiikka';
$hesklang['statistics']['intro']='Tämä raportti antaa lisätietoa help desk -käytöstäsi sekä henkilökunnan suorituksista.';
$hesklang['statistics']['ntsp']='Ei tikettejä valitulla aikavälillä.';
$hesklang['statistics']['pie_title_ro']='Avoimet vs Ratkaistut tiketit';
$hesklang['statistics']['open']='Avoin';
$hesklang['statistics']['resolved']='Ratkaistu';
$hesklang['statistics']['pie_title_as']='Avoimet tiketit: Osoitetut vs Osoittamattomat';
$hesklang['statistics']['ass']='Osoitettu';
$hesklang['statistics']['unas']='Osoittamaton';
$hesklang['statistics']['pie_title_au']='Avoimet tiketit: Vastatut vs Vastaamattomat';
$hesklang['statistics']['answered']='Vastatus';
$hesklang['statistics']['unanswered']='Vastaamattomat';
$hesklang['statistics']['pie_title_so']='Avoimien tikettien status';
$hesklang['statistics']['retic']='Tikettejä:';
$hesklang['statistics']['chart_title_md']='Tikettejä per kuukaudenpäivä';
$hesklang['statistics']['chart_title_wd']='Tikettejä per viikonpäivä';
$hesklang['statistics']['chart_title_hd']='Tikettejä per tunti';
$hesklang['statistics']['chart_title_tfr']='Aika ensimmäiseen henkilökunnan vastaukseen';
$hesklang['statistics']['chart_title_tfrc']='Tiketit joihin on vastattu ajan sisällä';
$hesklang['statistics']['chart_title_ttr']='Aika tiketin lähetyksestä ratkaisuun';
$hesklang['statistics']['chart_title_ttrc']='Tiketit jotka on ratkaistu ajan sisällä';
$hesklang['statistics']['chart_title_sr']='Henkilökunnan vastaukset';
$hesklang['statistics']['chart_title_srt']='Henkilökunnan vastaukset per tiketti';
$hesklang['statistics']['chart_title_srtr']='Henkilökunnan vastaukset per tiketti (vain ratkaistut)';
$hesklang['statistics']['chart_title_srt1']='Henkilökunnan vastaukset per tiketti (väh. 1 vastaus)';
$hesklang['statistics']['ct_30']='30 minuuttia';
$hesklang['statistics']['ct_1h']='1 tunti';
$hesklang['statistics']['ct_2h']='2 tuntia';
$hesklang['statistics']['ct_4h']='4 tuntia';
$hesklang['statistics']['ct_1d']='1 päivä';
$hesklang['statistics']['ct_2d']='2 päivää';
$hesklang['statistics']['ct_3d']='3 päivää';
$hesklang['statistics']['ct_1w']='1 viikko';
$hesklang['statistics']['ct_wp']='> 1 viikko';
$hesklang['statistics']['ct_1m']='1 kuukausi';
$hesklang['statistics']['ct_mp']='> 1 kuukausi';
$hesklang['statistics']['axis1']='% tiketeistä vastattu';
$hesklang['statistics']['axis2']='% tiketeistä ratkaistu';
$hesklang['statistics']['axis3']='% tiketeistä';
$hesklang['statistics']['axis4']='Aika ensimmäiseen vastaukseen';
$hesklang['statistics']['axis5']='Aika ratkaisuun';
$hesklang['statistics']['axis6']='Vastausten määrä';
$hesklang['statistics']['axis7']='Tikettien määrä';
$hesklang['statistics']['axis8']='Viikonpäivä';
$hesklang['statistics']['axis9']='Tunti';
$hesklang['statistics']['axis10']='Kuukaudenpäivä';
$hesklang['statistics']['tr_0']='Ei vastausta';
$hesklang['statistics']['tr_1']='1 vastaus';
$hesklang['statistics']['tr_2']='2 vastausta';
$hesklang['statistics']['tr_5']='3-5 vastausta';
$hesklang['statistics']['tr_10']='6-10 vastausta';
$hesklang['statistics']['tr_99']='> 10 vastausta';
$hesklang['statistics']['average']='Keskiarvo';
$hesklang['statistics']['atfr']='Keskimääräiset tunnit ja minuutit ensimmäiseen henkilökunnan vastaukseen:';
$hesklang['statistics']['attr']='Keskimääräiset tunnit ja minuutit tiketin ratkaisuun:';
$hesklang['statistics']['about']='noin %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='N/A';
$hesklang['statistics']['trept']='Tiketit, joihin henkilökunta on vastannut:';
$hesklang['statistics']['trnr']='Ratkaistut tiketit, joihin henkilökunta ei ole vastannut:';
$hesklang['statistics']['tsr']='Henkilökunnan vastaukset yhteensä:';
$hesklang['statistics']['tsrt']='Henkilökunnan vastauksia per tiketti keskimäärin:';
$hesklang['statistics']['tsro']='Henkilökunnan vastauksia per tiketti keskimäärin (väh. 1 henkilökunnan vastaus):';
$hesklang['statistics']['tsrc']='Henkilökunnan vastauksia per tiketti keskimäärin, jotta tiketti on ratkaistu:';
$hesklang['statistics']['tsrr']='Henkilökunnan vastauksia per tiketti keskimäärin, jotta tiketti on ratkaistu (väh. 1 henkilökunnan vastaus):';
$hesklang['sep_1000']=' '; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']=','; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='ja paljon muita...'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] Tukipyyntö myöhässä';
$hesklang['ticket_escalated']='[#%%TRACK_ID%%] ESKALOITU: %%SUBJECT%%';
$hesklang['escalate']['tab']='Eskaloi'; // Menu link
$hesklang['escalate']['page_title']='Eskaloi tukipyyntöjä'; // Page H2 title
$hesklang['escalate']['intro']='Tämä moduuli auttaa sinua eskaloimaan tukipyynnöt, joita ei hoideta ajoissa.';
$hesklang['escalate']['feat1']='Tukipyynnöt, joita ei ole osoitettu, joihin ei ole vastattu tai joita ei ole ratkaistu määräajassa';
$hesklang['escalate']['feat2']='eräpäivää lähestyvät ja myöhässä olevat tukipyynnöt';
$hesklang['escalate']['feat3']='muuttaa automaattisesti tukipyynnön prioriteettia, osoita tukipyyntö uudelleen, lähetä sähköposti-ilmoitus.';
$hesklang['escalate']['feat4']='sovella sääntöjä, jotka perustuvat tukipyynnön kategoriaan, omistajaan, tilaan';
$hesklang['escalate']['prefix']='Eskaloitu:'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Aktiiviset säännöt';
$hesklang['escalate']['new']='Uusi eskalaatiosääntö';
$hesklang['escalate']['no_rules']='Sinulla ei ole eskalaatiosääntöjä. Luo sellainen napsauttamalla yllä olevaa &quot;Uusi eskalaatiosääntö&quot; -painiketta.';
$hesklang['escalate']['title']='Säännön nimi';
$hesklang['escalate']['titlet']='Kuvaava otsikko, esimerkiksi: Uudelleenosoita tukipyynnöt, joihin ei ole vastattu vuorokauden kuluessa';
$hesklang['escalate']['default_title']='Sääntö käyttäjältä %1$s'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Säännön laukaisu';
$hesklang['escalate']['trigt']='Aseta ehto, joka laukaisee (suorittaa) tämän säännön.';
$hesklang['escalate']['hits']='Osumia'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Ehto'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Toimenpide'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='Sovella kohteeseen'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']='Poistetaanko tämä sääntö?';
$hesklang['escalate']['edit']='Muokataan eskalaatiosääntöä ID %1$s'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='Tukipyyntö on:'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='henkilökunta ei ole vastannut';
$hesklang['escalate']['nrepc']='asiakas ei ole vastannut';
$hesklang['escalate']['nass']='ei osoitettu';
$hesklang['escalate']['nres']='ei ratkaistu';
$hesklang['escalate']['ndue']='lähestyy eräpäivää';
$hesklang['escalate']['odue']='myöhässä';
$hesklang['escalate']['within']='Kuluessa:';
$hesklang['escalate']['minutes']='minuuttia';
$hesklang['escalate']['hours']='tuntia';
$hesklang['escalate']['days']='päivää';
$hesklang['escalate']['weeks']='viikkoa';
$hesklang['escalate']['months']='kuukautta';
$hesklang['escalate']['years']='vuotta';
$hesklang['escalate']['ofs']='lähetyksestä';
$hesklang['escalate']['resend']='Lähetä sähköposti-ilmoitukset uudelleen:';
$hesklang['escalate']['force']='Lähetä aina, älä ota huomioon henkilöstön asetuksia';
$hesklang['escalate']['noforce']='Kunnioita henkilöstön ilmoitusasetuksia';
$hesklang['escalate']['setpri']='Aseta prioriteetiksi:';
$hesklang['escalate']['setsta']='Aseta tilaksi:';
$hesklang['escalate']['assto']='Osoita tukipyyntö henkilölle:';
$hesklang['escalate']['asm']='Toinen työntekijä';
$hesklang['escalate']['notify']='Ilmoita henkilökunnalle...';
$hesklang['escalate']['ato']='Sovella:';
$hesklang['escalate']['tic']='Tukipyyntöjä kategoriassa:';
$hesklang['escalate']['tat']='Tukipyynnöt osoitettu henkilölle:';
$hesklang['escalate']['tws']='Liput, joilla on status:';
$hesklang['escalate']['tall']='Sovella tätä sääntöä olemassa oleviin ja tuleviin tukipyyntöihin';
$hesklang['escalate']['tfn']='Sovella tätä sääntöä vain tuleviin tukipyyntöihin, jätä olemassa olevat tukipyynnöt huomioimatta.';
$hesklang['escalate']['tfi']='Sovella tätä sääntöä vain tukipyyntöihin, joiden ID on suurempi kuin:';
$hesklang['escalate']['save']='Tallenna sääntö';
$hesklang['escalate']['e_tt']='Ajan tulisi olla välillä 1 ja 10000';
$hesklang['escalate']['e_a']='Valitse vähintään yksi toiminto, joka suoritetaan vastaaville tukipyynnöille';
$hesklang['escalate']['nocat']='Valitse ainakin yksi kategoria';
$hesklang['escalate']['nouser']='Valitse ainakin yksi käyttäjä';
$hesklang['escalate']['nostatus']='Valitse ainakin yksi tila';
$hesklang['escalate']['nocata']='%1$s ei pääse näihin luokkiin:'; // %1$s = user name
$hesklang['escalate']['rule_added']='Uusi sääntö on luotu';
$hesklang['escalate']['mdf']='Sääntöasetukset on tallennettu';
$hesklang['escalate']['e_id']='Tällä tunnuksella ei löytynyt sääntöä';
$hesklang['escalate']['deleted']='Valittu sääntö on poistettu';
$hesklang['escalate']['edit_notice']='säännön käynnistysehdon muuttaminen ei vaikuta mihinkään tikettiin, joka on jo eskaloitu tämän säännön perusteella (ellet aseta sääntöä uudelleen).';
$hesklang['escalate']['reset']='Aseta tämä sääntö uudelleen';
$hesklang['escalate']['reset2']='Oletko varma, että haluat uudelleenasettaa tämän säännön?<br><br>Säännön osumat muuttuvat 0:ksi, ja kaikki tätä sääntöä vastaavat tiketit eskaloidaan uudelleen.';
$hesklang['escalate']['reset3']='Valittu sääntö on nollattu';
$hesklang['escalate']['log_title']='Sääntö #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class="smaller">%1$s | eskaloinut sääntö %2$s:</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class="smaller">%1$s | - aseta prioriteetiksi %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class="smaller">%1$s | - osoita henkilölle %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class="smaller">%1$s | - lähetä henkilöstölle ilmoitus</li>';
$hesklang['escalate']['thist5']='<li class="smaller">%1$s | - lähettää henkilöstölle ilmoitus (pakotettu)</li>';
$hesklang['escalate']['thist6']='<li class="smaller">%1$s | - virhe: henkilöllä %2$s ei ole pääsyä tukipyyntöluokkaan</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class="smaller">%1$s | - virhe: henkilöllä %2$s ei ole oikeutta tarkastella tukipyyntöjä</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class="smaller">%1$s | - virhe: ei muita käyttäjiä, jotka voivat tarkastella tätä tukipyyntöä</li>'; // %1$s = date
$hesklang['escalate']['thist9']='<li class="smaller">%1$s | - huomaa: prioriteetiksi on jo asetettu %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class="smaller">%1$s | - huomaa: on jo osoitettu henkilölle %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class="smaller">%1$s | - ilmoita: %2$s</li>'; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class="smaller">%1$s | - aseta tilaksi %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class="smaller">%1$s | - huomaa: tilaksi on jo asetettu %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Aktiivinen'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Aktivoi tämä sääntö (aloita sen käyttö)';
$hesklang['escalate']['activated']='Valittu sääntö on aktivoitu'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='Deaktivoi tämä sääntö (lopeta sen käyttö).';
$hesklang['escalate']['deactivated']='Valittu sääntö on poistettu käytöstä'; // %1$s = rule log title
$hesklang['escalate']['no_active']='Ei aktiivisia eskalointisääntöjä';
$hesklang['escalate']['matched']='Löydettyjen vastaavien tukipyyntöjen määrä: %1$s '; // %1$s = number of tickets
$hesklang['escalate']['tools']='Työkalut';
$hesklang['escalate']['test']='Simuloi tämä sääntö';
$hesklang['escalate']['testa']='Simuloi kaikki säännöt';
$hesklang['escalate']['testaa']='Simuloi kaikki aktiiviset säännöt';
$hesklang['escalate']['testr']='Simulaation tulokset';
$hesklang['escalate']['rsim']='Toista simulaatio';
$hesklang['escalate']['tbef']='Ennen kuin sääntö on käytössä, se on aktivoitava napsauttamalla &quot;AKTIIVINEN&quot; -sarakkeessa olevaa valintaruutua.<br><br>
                               Suosittelemme, että <strong>simuloit</strong> kunkin säännön klikkaamalla sääntötaulukossa olevaa %1$s (Simuloi tämä sääntö) -kuvaketta nähdäksesi,
                               miten se vaikuttaa olemassa oleviin tukipyyntöihisi ennen sen aktivoimista.<br><br>
                               <strong>Aktiiviset säännöt suoritetaan %2$s minuutin välein. Tukipyyntö voidaan eskaloida vain kerran kunkin säännön avulla</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='SIMULAATIOTILA, ei muutoksia tietokantaan';
$hesklang['escalate']['sic']='SIMULAATIO VALMIS';
$hesklang['escalate']['r']='[SÄÄNTÖ]';
$hesklang['escalate']['i']='[INFO]';
$hesklang['multopt']='Vihje: pidä CTRL-näppäintä painettuna valitaksesi useita vaihtoehtoja';
$hesklang['desc_ticket_escalated']='(Henkilökunta) Tukipyyntö on eskaloitu'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Tukipyynnön formaatti (Henkilökunta)';
$hesklang['ticket_formatting_plaintext']='Pelkkä teksti';
$hesklang['ticket_formatting_rich_text']='Rikastettu teksti (HTML)';
$hesklang['due_date']='Eräpäivä';
$hesklang['invalid_due_date']='Eräpäivä on virheellinen.';
$hesklang['thist19']='<li class="smaller">%s | eräpäiväksi vaihdettu %s (%s)</li>'; // %s = date, new due date, user making change
$hesklang['thist20']='<li class="smaller">%s | eräpäivä poistettu (%s)</li>'; // %s = date, user making change
$hesklang['due_date_updated']='Tukipyynnön eräpäivä päivitettiin.';
$hesklang['menu_kb_manage']='Hallinnoi'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='Katso'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Valitse kaikki';
$hesklang['a_deselect']='Poista kaikki valinnat';
$hesklang['a_toggle']='Vaihda kaikki';
$hesklang['ql_all']='Kaikki tukipyynnöt';
$hesklang['ql_alo']='Kaikki avoimet tukipyynnöt';
$hesklang['ql_fit']='Suodatetut tukipyynnöt';
$hesklang['ql_a2m']='Minulle osoitetut';
$hesklang['ql_a2o']='Muille osoitetut';
$hesklang['ql_una']='Osoittamatta';
$hesklang['ql_due']='Erääntyvät pian';
$hesklang['ql_ovr']='Myöhässä';
$hesklang['set_ds']='Näytä merkinnällä &quot;erääntyy pian&quot;'; // Settings page (title of setting)
$hesklang['set_ds2']='päivää ennen eräpäivää';
$hesklang['not_aos']='Jotain avoimia tukipyyntöjä, joihin sinulla on pääsy, ei näytetä suodattimiesi vuoksi.';
$hesklang['ntoverdue']='Tukipyyntö on myöhässä omistajalla:';
$hesklang['ovdcron']='jotta myöhässä olevien ilmoitukset toimisivat, järjestelmänvalvojan on aktivoitava ajastettu tehtävä.';
$hesklang['instructions']='Ohjeet';
$hesklang['desc_overdue_ticket']='(Henkilökunta) Tukipyyntö myöhässä';
$hesklang['overdue_starting']='Aloitetaan erääntyneiden tukipyyntöjen ilmoitusprosessi';
$hesklang['overdue_sim']='Sähköpostien lähettäminen ja tukipyyntöjen päivittäminen ei ole käytössä SIMULAATIO-tilassa.';
$hesklang['overdue_ticket_count']='Löydettiin %s tukipyyntöä, jotka ovat myöhässä.'; // %s = Number of tickets
$hesklang['overdue_finished']='Saatiin valmiiksi erääntyneet tukipyynnöt. %s sähköpostia lähetettiin. %s sähköpostia ei voitu lähettää.'; // %s = Successful emails, failed emails
$hesklang['admin_css']='Admin CSS';
$hesklang['admin_css2']='Lataa ylimääräinen mukautettu tyylitiedosto hallintapaneelia varten';
$hesklang['noval_cert']='Älä validoi palvelinvarmenteita';
$hesklang['chg_cat']='Napsauta vaihtaaksesi tukipyynnön luokkaa';
$hesklang['tlan']='Tukipyynnön kieli';
$hesklang['uue']='Kahdella tai useammalla henkilökunnan jäsenellä on sama sähköpostiosoite. Suosittelemme, että jokaiselle käyttäjälle määritetään uniikki sähköpostiosoite.';
$hesklang['flood']='Tulvaraja';
$hesklang['e_flood']='Hups, lähetit jo vastauksen äskettäin. Pysäytimme tämän pyynnön vastaustulvan estämiseksi.';
$hesklang['cookies']='Evästeet';
$hesklang['ukey']='URL-avain'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='Luo satunnainen URL-avain';
$hesklang['ukeym']='Virhe: Jos haluat suorittaa tämän tiedoston HTTP:n kautta, sinun on sisällytettävä URL-avain pyyntöön. Esimerkki:';
$hesklang['ukeyw']='Virhe: väärä URL-avain';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Ticket received: %%SUBJECT%%';
$hesklang['mfa_verification']='%%VERIFICATION_CODE%% is your verification code';
$hesklang['follow_up_email']='Be honest - how did we do?';
$hesklang['mfa']='Multi-Factor Authentication (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='MFA Enabled?';
$hesklang['mfa_required']='Require Multi-Factor Authentication';
$hesklang['mfa_manage_profile']='Manage MFA';
$hesklang['mfa_disabled']='Multi-Factor Authentication is disabled';
$hesklang['mfa_enabled']='Multi-Factor Authentication is Enabled (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='None';
$hesklang['mfa_method_none_subtext']='Remove multi-factor authentication on your account.';
$hesklang['mfa_method_email']='Email';
$hesklang['mfa_method_email_subtext']='The helpdesk will send an email with a random login code to <strong>%s</strong> when logging in.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='Authenticator App';
$hesklang['mfa_method_auth_app_short']='App';
$hesklang['mfa_method_auth_app_subtext']='Use a smartphone application, such as Authy or Google Authenticator, to generate a random login code when logging in.';
$hesklang['mfa_step_method']='Method';
$hesklang['mfa_step_verification']='Verification';
$hesklang['mfa_step_complete']='Complete';
$hesklang['mfa_introduction']='Multi-factor authentication improves account security by requiring you to verify your login using an additional verification method, such as email or an authenticator app (such as Authy or Google Authenticator).';
$hesklang['mfa_reset_warning']='You already have multi-factor authentication enabled. Completing this again will reset your multi-factor authentication device (if enabled).';
$hesklang['mfa_select_method_colon']='Select an authentication method:';
$hesklang['mfa_verification_header']='Verification - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='An email has been sent to <strong>%s</strong> containing a six-digit verification code. Enter the code you received via email below to continue.'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; Step 1: Scan the image below with the multi-factor authentication app on your mobile device.';
$hesklang['mfa_verification_auth_app_cant_scan']='Not able to scan the image? Manually enter this code on your device: <b>%s</b>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; Step 2: Enter the 6-digit code displayed on your application to verify your device.';
$hesklang['mfa_verify']='Verify';
$hesklang['mfa_invalid_method']='Invalid multi-factor authentication method was received.';
$hesklang['mfa_invalid_verification_code']='The code that was entered is incorrect or expired.';
$hesklang['mfa_configured']='Multi-factor authentication has been enabled for your account!';
$hesklang['mfa_removed']='Multi-factor authentication has been disabled for your account!';
$hesklang['mfa_verification_needed']='Multi-factor authentication is enabled for this account.';
$hesklang['mfa_verification_needed_email']='Please enter the verification code that was sent to your email address.';
$hesklang['mfa_verification_needed_auth_app']='Please enter the code that is displayed on your authentication app.';
$hesklang['mfa_verification_code']='Verification code';
$hesklang['mfa_server_time_issue']='Your server time seems to be inaccurate: %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Reset multi-factor authentication';
$hesklang['mfa_reset_confirm']='Are you sure you wish to reset MFA for this user?';
$hesklang['mfa_reset_yes']='Reset';
$hesklang['mfa_reset']='Multi-Factor Authentication has been reset for the user';
$hesklang['desc_mfa_verification']='(Staff) Multi-Factor Authentication Code';
$hesklang['mfa_code']='Code:';
$hesklang['mfa_backup_codes_header']='SAVE YOUR BACKUP CODES!';
$hesklang['mfa_backup_codes_description']='Keep these backup codes somewhere safe but accessible. In case you lose access to your MFA device or email, you can enter one of the following backup codes to log in.<br><br><strong>Be sure to treat these backup codes like passwords. You will not be able to see these codes again!</strong>';
$hesklang['mfa_verify_another_way']='Verify your account another way'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Get a verification code at %s';
$hesklang['mfa_verify_another_way_code']='Enter one of your 8-character backup codes';
$hesklang['mfa_verify_another_way_admin']='Contact your helpdesk administrator for help';
$hesklang['mfa_verify_another_way_reset']='Reset your multi-factor authentication by uploading a file to the server';
$hesklang['mfa_send_another_email']='Send another email';
$hesklang['mfa_sent']='An email with a new verification code was sent to your email address';
$hesklang['mfa_backup_code']='Backup Code';
$hesklang['mfa_backup_codes']='Backup Codes';
$hesklang['mfa_backup_codes_info']='Single-use codes to pass multi-factor verification when unable to access your email or authenticator app. Once you use a backup code to sign in, that code becomes inactive.';
$hesklang['mfa_backup_codes_num']='You can get a new set of 10 backup codes whenever you want. When you create a new set of codes, the old set automatically becomes inactive.';
$hesklang['mfa_backup_codes_num2']='Number of your active codes: %s';
$hesklang['mfa_invalid_backup_code']='The backup code that was entered is incorrect or has already been used.';
$hesklang['mfa_del_codes']='Delete my backup codes';
$hesklang['mfa_del_codes2']='All your backup codes have been deleted.';
$hesklang['mfa_new_codes']='Generate new backup codes';
$hesklang['mfa_new_codes2']='New backup codes have been generated';
$hesklang['old_php_version']='Error: Unsupported PHP version';
$hesklang['category_default_due_date']='Default Due Date';
$hesklang['category_change_default_due_date']='Set Default Due Date';
$hesklang['category_leave_blank_for_no_default_due_date']='(leave blank for no default due date)';
$hesklang['category_default_due_date_updated']='Default due date has been updated.';
$hesklang['email_formatting']='Email formatting';
$hesklang['email_formatting_html_and_plaintext']='HTML with plain text alternative from plain text template (default)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML with plain text alternative generated from HTML template';
$hesklang['email_formatting_html']='HTML only';
$hesklang['email_formatting_plaintext']='Plain text only';
$hesklang['email_formatting_note']='Your selection in %1$s &gt; %2$s &gt; %3$s is set to: <i>%4$s</i>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='This means Hesk will ignore the HTML templates here.';
$hesklang['email_formatting_note1']='This means Hesk will ignore the plain text templates here.';
$hesklang['email_formatting_note2']='This means Hesk will generate plain text version of emails from your HTML templates and ignore the plain text templates here.';
$hesklang['etnu']='This email template is currently not used by Hesk based on your selection in %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='Edit Category';
$hesklang['create_category']='Create Category';
$hesklang['one_user_included']='1 user included';
$hesklang['one_user_excluded']='1 user excluded';
$hesklang['x_users_included']='%s users included'; // %s = Number of users
$hesklang['x_users_excluded']='%s users excluded'; // %s = Number of users
$hesklang['aa_cat']='Auto-assign tickets in this category';
$hesklang['modify_autoassign_settings']='Modify auto-assign settings';
$hesklang['autoassign_on_all_users']='Yes, to any user with access to this category';
$hesklang['autoassign_on_select_users']='Yes, to specific users';
$hesklang['autoassign_off']='No, submit tickets as unassigned';
$hesklang['autoassign_users']='Users to include/exclude in auto-assignment';
$hesklang['autoassign_selected_include']='Selected users should be <strong>included</strong> when auto-assigning tickets in this category';
$hesklang['autoassign_selected_exclude']='Selected users should be <strong>excluded</strong> when auto-assigning tickets in this category';
$hesklang['cat_edited']='Category %s has been successfully edited';
$hesklang['search_for_user']='Search for user';
$hesklang['email_sending']='Sending emails';
$hesklang['email_to_ticket']='Email to ticket';
$hesklang['email_to_ticket_info']='Converting emails to tickets requires some server-side setup. For details, please see <a href="%s" target="_blank">this knowledgebase guide</a>.'; // %s = link to article
$hesklang['from_warning2']='Hesk is using a SMTP server to send email notifications. Your <strong>%1$s</strong> should be set to <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Missing file extension';
$hesklang['block_ignore']='Email to ticket - Ignore emails and prevent loops';
$hesklang['block_noreply']='Do not reply';
$hesklang['block_noreply2']='Ignore emails sent from &quot;do not reply&quot; email addresses';
$hesklang['block_returned']='Returned';
$hesklang['block_returned2']='Ignore returned emails, such as delivery status notifications and automated replies';
$hesklang['block_duplicate']='Duplicates';
$hesklang['block_duplicate2']='Ignore emails with the same message sent within &quot;%s&quot; seconds'; // %s = "Timeframe"
$hesklang['loop_info']='emails received from the same email address within &quot;%s&quot; seconds';
$hesklang['thist21']='<li class="smaller">%s | overdue email notification sent</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | follow-up email sent</li>'; // %s = date
$hesklang['elevator_header']='Entering Secure Area';
$hesklang['elevator_intro']='You are about to enter a secure area.';
$hesklang['elevator_enter_password']='Please enter your password to continue.';
$hesklang['elevator_duration_setting_title']='Secure area duration';
$hesklang['desc_survey']='(Customer) Follow-up (survey) email'; // Email description
$hesklang['satisfaction']['tab']='Satisfaction';
$hesklang['satisfaction']['title']='Customer Satisfaction Survey';
$hesklang['satisfaction']['intro']='Send your customers a follow-up satisfaction survey to gather feedback about their experience with your help desk.';
$hesklang['satisfaction']['tab1']='Settings';
$hesklang['satisfaction']['tab2']='Opt-out';
$hesklang['satisfaction']['enable']='Enable follow-up emails:';
$hesklang['satisfaction']['enabled']='Customer Satisfaction Surveys are enabled.';
$hesklang['satisfaction']['disabled']='Customer Satisfaction Surveys are currently disabled.';
$hesklang['satisfaction']['url']='Survey URL address:';
$hesklang['satisfaction']['send']='Follow-up email delay:';
$hesklang['satisfaction']['at_least']='Wait at least';
$hesklang['satisfaction']['after']='after the ticket is resolved before sending the email';
$hesklang['satisfaction']['h1']='How to use this tool?';
$hesklang['satisfaction']['h2']='First, create a customer satisfaction survey in your favorite survey tool. If you are unsure what tool to use or what questions to ask, we have a <a href="%s" target="_blank">guide available here</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='When your survey is ready, enable follow-up emails using the form below. Hesk will process resolved tickets with at least one staff reply once per hour and send your survey link to your customers.';
$hesklang['satisfaction']['e_url']='Enter a valid survey URL address. This is the URL your customers will be sent to.';
$hesklang['satisfaction']['as']='Enter a valid survey URL address. This is the URL your customers will be sent to.';
$hesklang['satisfaction']['oo1']='This page lists email addresses that follow-up emails will <b>not</b> be sent to.';
$hesklang['satisfaction']['oo2']='Your customers are able to opt-out from receiving survey emails by clicking a link in the email. Alternatively, you can manually add email addresses on this page.';
$hesklang['satisfaction']['ooe']='Email address to opt-out';
$hesklang['satisfaction']['ooe2']='Enter the email address you wish to opt-out from receiving survey emails.';
$hesklang['satisfaction']['ooe3']='This email address <i>%s</i> is already opted out from receiving survey emails.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Opt-out this email';
$hesklang['satisfaction']['oob']='Opted out by';
$hesklang['satisfaction']['no_oo']='No customer has opted out of receiving survey emails.';
$hesklang['satisfaction']['oor']='Remove';
$hesklang['satisfaction']['oor2']='Email removed from opt-out';
$hesklang['satisfaction']['oor3']='Confirm removal';
$hesklang['satisfaction']['oor4']='When removed from opt-out, this user will again receive follow-up emails.';
$hesklang['satisfaction']['optedout']='The email address <i>%s</i> was opted out of receiving survey emails.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='Missing or invalid survey ID';
$hesklang['satisfaction']['starting']='Starting customer satisfaction survey notification process';
$hesklang['satisfaction']['tc']='Found %s closed tickets that did not have satisfaction survey sent.'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Finished Customer Satisfaction Survey. Emails sent: %1$s. Emails failed to send: %2$s. Tickets without an email: %3$s. Tickets with opt-out email: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='Ignoring, this customer does not wish to receive survey emails.';
$hesklang['satisfaction']['ne']='Ignoring, this ticket is without an email address';
$hesklang['satisfaction']['feat1']='Create your survey using any third-party tool, such as Google Forms';
$hesklang['satisfaction']['feat2']='set up your survey URL, preferences, and limitations inside this module';
$hesklang['satisfaction']['feat3']='when you resolve a ticket, Hesk will email your customer the link to the survey';
$hesklang['dfor']='Date format';
$hesklang['dtfor']='Date and Time';
$hesklang['cdfor']='Date select format';
$hesklang['custom']='Custom';
$hesklang['jsc_notice']='The date selection doesn\'t support PHP-style date formatting. Select one of the pre-configured options or click the %s icon below to see available display options.'; // %s = replaced by icon
$hesklang['lcf3']='Date only'; // Display: "Date only"
$hesklang['epdd']='Error parsing due_date parameter:';
$hesklang['edit_pass']='Edit password';
$hesklang['save_pass']='Save password';
$hesklang['cur_pass']='Current password';
$hesklang['cur_pass2']='You must provide your current password in order to change it.';
$hesklang['cur_pass3']='After a successful password update, you will be redirected to the login page, where you can log in with your new password.';
$hesklang['e_new_pass']='Please enter your new password';
$hesklang['pass_len']='The password must not exceed 64 characters';
$hesklang['pass_login']='Please log in again after changing your password';
$hesklang['bf_int']='You have been logged out due to too many failed verification attempts';
$hesklang['tst_cnt']='Number of emails your mail server will send to Hesk: %s'; // %s = number of emails
$hesklang['wrn_imap']='You have many unread emails in your mailbox (%1$s). Hesk will turn all these emails into tickets.<br><br>You may want to mark existing emails as read before enabling %2$s or use a new email account for Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='You have many emails in your mailbox (%1$s). Hesk will turn all these emails into tickets.<br><br>You may want to delete existing emails before enabling %2$s or use a new email account for Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='Due on'; // Due on (date)
$hesklang['search_due_date_range']='Due in'; // Due in (X days)
$hesklang['attachment_add_files']='Add file';
$hesklang['attachment_max_exceeded']='This file will not be uploaded becuase you have already uploaded the maximum number of files allowed.';
$hesklang['attachment_viewer_message']='Drag files here or click the \'Add File\' button below to select files to upload.';
$hesklang['attachment_invalid_type_message']='Sorry, but the file type you tried to upload is not allowed.';
$hesklang['attachment_upload_error']='An error occurred when trying to upload. Please try again later.';
$hesklang['attachment_too_large']='This attachment is larger than the max filesize permitted.';
$hesklang['attachment_cancel']='Cancel';
$hesklang['attachment_confirm_cancel']='Are you sure you want to cancel this upload?';
$hesklang['attachment_remove']='Remove attachment';
$hesklang['attachment_too_many_uploads']='Too many attachments have been uploaded from your location in a short period of time. Please try your request again later.';
$hesklang['sub_note']='Submit note';
$hesklang['can_view_users']='View all users (but not manage them)';
$hesklang['welcome1']='Hey there, you seem to be new here. Welcome!';
$hesklang['welcome2']='To help you get started, check out the %s.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Hesk online Quick Start Guide';
$hesklang['tmce1']='Use Ctrl+Right click to access spellchecker';
$hesklang['tmce2']='Hold the Control (Ctrl) key and right-click on the misspelled word to access the spellchecker.';
$hesklang['desc_new_ticket_by_staff']='(Customer) New staff-submitted ticket';
$hesklang['mod_et_h']='You can modify email templates under %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Set language to';
$hesklang['ouwa']='Only users with access to this category are listed below. To add staff members to this category, edit their permissions on the %s page'; // %s = Team
$hesklang['previous_tickets']='Previous tickets';
$hesklang['no_previous']='No previous tickets by %s'; // %s = email address
$hesklang['all_previous']='List all previous tickets';
$hesklang['confirm_delete_ticket']='Are you sure you want to permanently delete this ticket?';
$hesklang['confirm_delete_reply']='Are you sure you want to permanently delete this reply?';
$hesklang['select_new_category']='Number of tickets in this category: %s<br><br>Please select a new category to transfer these tickets to:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='Number of tickets assigned to this user: %1$s<br>Number of <b>open</b> tickets assigned to this user: %2$s<br><br><b>Open</b> tickets will be <b>unassigned</b> after deleting this user.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='HESK license';
$hesklang['hlic_free']='FREE';
$hesklang['hlic_buyl']='Buy a License';
$hesklang['hlic_paid']='Licensed';
$hesklang['antdemo']='Submitting tickets from the admin panel has been disabled in the demo mode.<br><br>Please use the <a href="%s" target="_blank">public side</a> to submit a test ticket.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Authentication method';
$hesklang['email_authentication_method_username_password']='Basic (Username / Password)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - No verified OAuth providers configured.';
$hesklang['email_authentication_method_oauth_link']='Manage OAuth providers'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='Authorization Endpoint URL';
$hesklang['email_oauth_token_url']='Token Endpoint URL';
$hesklang['email_oauth_client_id']='Client ID';
$hesklang['email_oauth_client_secret']='Client Secret';
$hesklang['email_oauth_scope']='Scope';
$hesklang['oauth_error_invalid_state']='OAuth state does not match the state sent to OAuth provider.';
$hesklang['oauth_error_unknown']='An unknown error occurred when attempting to save OAuth tokens.';
$hesklang['oauth_error_no_token']='Access token missing in the JSON response.';
$hesklang['oauth_error_retrieve']='Unable to retrieve an access token. Please confirm your OAuth Provider settings and re-save them to acquire a new token.';
$hesklang['email_oauth_provider']='OAuth Provider';
$hesklang['email_oauth_providers']='OAuth Providers';
$hesklang['email_oauth_provider_guide']='Before using OAuth, you must register an OAuth Provider. For details, please see <a href="%s" target="_blank">this knowledgebase guide</a>.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='Your OAuth Redirect URI for Hesk is:<br><i>%s</i>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Use this tool to add OAuth providers to your help desk';
$hesklang['email_oauth_provider_name']='Name'; // OAuth provider name
$hesklang['email_oauth_new_provider']='New Provider';
$hesklang['email_oauth_edit_provider']='Edit Provider';
$hesklang['email_oauth_provider_being_used_for']='Being Used For';
$hesklang['email_oauth_providers_none']='No OAuth providers saved. You can add them by clicking "New Provider" above.';
$hesklang['email_oauth_provider_cannot_be_deleted']='This provider cannot be removed because it is being used by the help desk.';
$hesklang['email_oauth_confirm_delete_provider']='Are you sure you want to delete this OAuth provider?';
$hesklang['oauth_provider_saved']='OAuth provider has been saved';
$hesklang['oauth_provider_use']='You can now select this provider in %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Enter the provider name';
$hesklang['oauth_provider_err_auth_url']='Enter a valid authorization URL';
$hesklang['oauth_provider_err_token_url']='Enter a valid token URL';
$hesklang['oauth_provider_err_client_id']='Enter the client ID';
$hesklang['oauth_provider_err_client_secret']='Enter the client secret';
$hesklang['oauth_provider_err_scope']='Enter the scope';
$hesklang['oauth_provider_deleted']='OAuth provider deleted';
$hesklang['oauth_provider_not_found']='This OAuth provider does not exist';
$hesklang['oauth_provider_verified']='Verified';
$hesklang['oauth_provider_click_to_verify']='Click to verify';
$hesklang['can_due_date']='Can set due date'; // Permission to set and modify due date
$hesklang['can_due_date_e']='You do not have permission to set due dates';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Verify Your Registration';
$hesklang['customer_verify_new_email']='Verify Your New Email Address';
$hesklang['customer_reset_password']='Reset your help desk password';
$hesklang['customer_approved']='Account Approved';
$hesklang['customer_rejected']='Account Rejected';
$hesklang['email_rejected']='Account required to submit support tickets';
$hesklang['require_curl']='This functionality requires <strong>cURL</strong> support for PHP enabled on your server. Please ask your web host to enable cURL for PHP.';
$hesklang['customer_accounts_heading']='Customer Accounts';
$hesklang['customer_accounts']='Customer accounts';
$hesklang['customer_accounts_off']='<strong>Disabled</strong>';
$hesklang['customer_accounts_allowed']='<strong>Enabled - Optional</strong> (customers can submit support tickets without registering or logging in)';
$hesklang['customer_accounts_required_to_submit']='<strong>Enabled - Required for tickets</strong> (only logged-in customers can submit support tickets)';
$hesklang['customer_accounts_required']='<strong>Enabled - Required to access</strong> (only logged-in customers can access the help desk and knowledgebase)';
$hesklang['customer_accounts_reg']='Account registration';
$hesklang['customer_accounts_reg_customer']='Customers can register accounts';
$hesklang['customer_accounts_reg_approve']='Customers can register account, staff must approve new registrations';
$hesklang['customer_accounts_reg_staff']='Only staff can register customer accounts';
$hesklang['customer_accounts_allow_email_changes']='Allow customers to change their email address';
$hesklang['customer_accounts_allow_email_resends']='Time until customers can request new verification email';
$hesklang['customer_login']='Login';
$hesklang['customer_logout']='Logout';
$hesklang['customer_register']='Register';
$hesklang['customer_accounts_disabled']='Customer logins and registrations are disabled.';
$hesklang['customer_accounts_registration_disabled']='Customer registrations are disabled.';
$hesklang['customer_forgot_password']='Forgot password?';
$hesklang['customer_email']='Email Address';
$hesklang['customer_accounts_email_banned']='You have been banned from using this helpdesk.';
$hesklang['customer_registration_successful']='Registration Successful!';
$hesklang['customer_registration_email_exists_no_reset_link']='An account with email %s already exists.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='An account with email %s already exists. <a href="login.php">Do you wish to log in instead</a>?'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='An account with email %s already exists and is pending email verification.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='An account with email %s already exists and is pending staff approval.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='Check Your Email!';
$hesklang['customer_registration_check_your_email_content']='You must verify your email address before being able to log in.<br><br>If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_login_not_verified']='You must verify your email address before being able to log in.';
$hesklang['customer_login_not_verified2']='If you did not receive the verification email from us, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_login_resend_verification_email']='Re-send verification email';
$hesklang['customer_login_resend_verification_email_none']='There are no pending email verifications to send.';
$hesklang['customer_login_resend_verification_email_too_early']='You cannot request a new verification email at this time, please try again later.';
$hesklang['customer_login_not_approved']='A member of staff must approve your account before being able to log in. Once approved, you will be notified via email.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Verify Registration';
$hesklang['customer_registration_verify_success']='Your email has been verified and you may now log in using the form below.';
$hesklang['customer_registration_verify_approval_needed']='Your email has been verified. However, a member of staff must approve your account before being able to log in. Once approved, you will be notified via email.';
$hesklang['customer_registration_verify_failure']='Your email could not be verified. Either the link has already been used or has expired.';
$hesklang['emails_to_customers']='&raquo; Emails sent to customers';
$hesklang['emails_to_staff']='&raquo; Emails sent to staff';
$hesklang['emails_to_everyone']='&raquo; Emails sent to staff or customers';
$hesklang['new_customer_approval']='You have customer accounts pending approval'; // Email subject
$hesklang['desc_new_customer_approval']='(Staff) Customer accounts pending approval';
$hesklang['n_cust_app']='There are pending customer approvals'; // Notify me when...
$hesklang['et_num_customers']='Number of pending approvals';
$hesklang['et_link_customers']='Link to the Manage customers page';
$hesklang['et_link_verify']='Verification link';
$hesklang['et_cust_login']='Customer login URL';
$hesklang['submit_ticket_customer_email_exists']='A customer with this email already exists. Please <a href="login.php?email=%s">log in</a> to submit a ticket.'; // %s - User's email
$hesklang['customer_login_email_required']='Please enter a valid email address.';
$hesklang['customer_login_password_required']='Please enter your password.';
$hesklang['customer_login_remember_just_email']='Remember just my email';
$hesklang['customer_login_remember_email']='Remember my email';
$hesklang['customer_wrong_user']='Your email address %s is not registered with us.<br><br>Do you wish to <a href="register.php">create an account</a>?'; // %s - Entered email address
$hesklang['customer_wrong_pass']='Your email address and password do not match our records.<br><br>Do you wish to <a href="login.php?submittedForgot=1">reset your password</a>?';
$hesklang['customer_must_be_logged_in_to_view']='Please log in to continue.';
$hesklang['customer_register_here']='If you don\'t have an account with us, you can <a href="register.php">register here</a>.';
$hesklang['create_account']='Create an account';
$hesklang['customer_my_tickets_heading']='My tickets';
$hesklang['customer_my_tickets_description']='View all of your previous tickets';
$hesklang['customer_my_tickets_search_for_tickets']='Search for tickets';
$hesklang['customer_password_reset_successful']='Your new password has been saved. You may now log in.';
$hesklang['customer_profile']='Profile';
$hesklang['customer_edit_profile']='Edit Profile';
$hesklang['customer_edit_pass']='Edit Password';
$hesklang['customer_edit_pass_same']='Your new password must not be the same as your current one.';
$hesklang['customer_change_email']='Change Email';
$hesklang['customer_change_email_banned']='The email you entered is banned.';
$hesklang['customer_change_email_pending']='There is a current request to change your email address to: <b>%s</b><br><br>We have sent an email to this address. Please click the link inside the email to confirm the change.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Re-send confirmation email</a>';
$hesklang['customer_change_email_submitted']='Please click the verification link that was sent to <b>%s</b> to verify your new email.'; // %s - new email
$hesklang['customer_change_email_verify_success']='Your new email address has been verified and your profile updated.';
$hesklang['customer_change_email_disabled']='The ability to update your email is disabled. Contact us if you wish to change your email address.';
$hesklang['customer_profile_saved']='Your profile has been saved.';
$hesklang['customers']='Customers';
$hesklang['customers_intro']='Customer accounts allow customers to view all of their tickets in a central location.';
$hesklang['sure_remove_customer']='Are you sure you want to remove this customer?';
$hesklang['sure_remove_customer_additional_note']='Deleting a customer is final.  Once deleted, they cannot be recovered!';
$hesklang['new_customer']='New Customer';
$hesklang['new_follower']='New Follower';
$hesklang['add_customer']='+ Add Customer'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Add Follower'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='The provided customer does not yet exist. Click "Save" if you would like to create this customer.';
$hesklang['followers']='Followers';
$hesklang['no_customers']='There are currently no customers in the database.';
$hesklang['no_customers_disabled']='You will start seeing customers here when they submit support tickets.';
$hesklang['no_customers_enabled']='You will start seeing customers here when they register or submit support tickets.';
$hesklang['no_customers_enabled2']='Alternatively, the buttons above this message allow you to manually create customer accounts or import existing customers into the help desk.';
$hesklang['import_customers']='Import Customers';
$hesklang['import_customers_tip']='Use a CSV file to import multiple customers at once.';
$hesklang['customer_not_found']='Customer not found for ticket!';
$hesklang['search_by_name_or_email']='Search by name or email...';
$hesklang['search_by_pattern']='Search by pattern...';
$hesklang['is_searchable']='Searchable';
$hesklang['custom_is_searchable']='Searchable';
$hesklang['yes_via_autocomplete']='YES (search via autocomplete)';
$hesklang['customer_required']='You must select a customer';
$hesklang['customer_email_exists']='A customer with this email already exists.';
$hesklang['customer_name_with_no_email_exists']='A customer with this name and no email already exists.';
$hesklang['an_error_occurred_validating_email']='An error occurred when attempting to verify the entered email address.';
$hesklang['customer_count_x_more']='+%s more'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Registered';
$hesklang['customer_account_verified']='Verified';
$hesklang['customer_account_verified_help']='Customers must verify their account via an activation link sent to their email address before being able to log into their account.';
$hesklang['customer_account_setting_password_will_verify_user']='Setting a password for this customer will automatically verify their account.';
$hesklang['deleting_customer_with_tickets']='This customer has %1$s ticket(s) <b>(%2$s open)</b> that also have other customers associated with them.<br>What should be done with these tickets?'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='A valid email address is needed to re-send a verification email.';
$hesklang['customer_resend_verification_email_not_found']='No account exists with this email address, or the account has already been verified.';
$hesklang['customer_resend_verification_email_sent']='A verification email has been sent to your email address.<br><br>If you do not receive it within a few minutes, please check your Junk, Bulk or Spam folders. Mark the message as <b>Not SPAM</b> to avoid problems receiving our correspondence in the future.';
$hesklang['customer_permission_denied']='You do not have permission to modify customers.';
$hesklang['customer_manage_approvals']='Customer accounts pending approval: <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Approve customer';
$hesklang['customer_manage_bulk_approve']='Approve Selected Customers';
$hesklang['customer_manage_bulk_approve_complete']='Customers approved: %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Reject customer';
$hesklang['customer_manage_bulk_reject']='Reject Selected Customers';
$hesklang['customer_manage_bulk_reject_complete']='Customers rejected: %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Delete customer';
$hesklang['customer_manage_bulk_delete']='Delete Selected Customers';
$hesklang['customer_manage_bulk_delete_complete']='Customers deleted: %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Edit customer';
$hesklang['customer_manage_verification_email_sent']='Verification email has been sent to %s'; // %s = customer's email
$hesklang['can_man_customers']='Manage customers';
$hesklang['can_view_customers']='View all customers (but not manage them)';
$hesklang['import_customer_select_file']='Select File';
$hesklang['import_customer_step1_instructions']='To import customers, prepare a CSV (Comma-Separated Values) file.';
$hesklang['import_customer_step1_note']='Select Your CSV File';
$hesklang['import_customer_step1_separator']='Columns in my CSV file are separated by';
$hesklang['import_customer_sample']='&raquo; Sample CSV files';
$hesklang['import_customer_sample_1']='US-style CSV file with columns separated by ,';
$hesklang['import_customer_sample_2']='EU-style CSV file with columns separated by ;';
$hesklang['import_customer_upload_requirements_1']='Your CSV file must include at least a name or an email address column. The password column is optional.';
$hesklang['import_customer_upload_requirements_2']='The first row of your file must contain column headers.';
$hesklang['import_customer_upload_requirements_3']='Your file must be encoded in UTF-8.';
$hesklang['import_customer_select_columns']='Select Columns';
$hesklang['import_customer_upload_customers']='Upload Customers';
$hesklang['import_customer_column_name']='Name Column';
$hesklang['import_customer_column_email']='Email Column';
$hesklang['import_customer_column_pass']='Password Column';
$hesklang['import_customer_step2_note']='Select the correct column name from your CSV file in the dropdowns, and then click "Next".';
$hesklang['import_customer_name_or_email_required']='Name or email is required';
$hesklang['import_customer_step3_note']='Your customers are being imported. Do not leave this page!';
$hesklang['import_customer_step3_pending']='Pending';
$hesklang['import_customer_step3_successful_imports']='Successful Imports';
$hesklang['import_customer_step3_failed_imports']='Failed Imports';
$hesklang['import_customer_step3_progress']='Progress';
$hesklang['import_customer_step3_complete_some_failed']='The import process is complete, however <b>%s</b> customers failed to import. Check the table below for more information.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='The import process is complete!';
$hesklang['import_customer_step3_importing']='Importing';
$hesklang['staff_deleted']='[Staff Deleted]';
$hesklang['customer_account_approved']='Customer registration approved';
$hesklang['customer_account_rejected']='Customer registration rejected';
$hesklang['customer_account_deleted']='Customer registration deleted';
$hesklang['ticket_followers']='Ticket followers';
$hesklang['ticket_followers2']='Allow tickets to have multiple customers';
$hesklang['add_cc']='Add Cc';
$hesklang['cc']='Cc';
$hesklang['cc_help']='Separate each email with a comma.';
$hesklang['search_customers']='Search Customers';
$hesklang['page_size']='Page Size';
$hesklang['customers_on_pages']='Number of customers: %d | Number of pages: %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Customer) Reset your password';
$hesklang['desc_customer_verify_registration']='(Customer) Verify your registration';
$hesklang['desc_customer_verify_new_email']='(Customer) Verify your new e-mail';
$hesklang['desc_customer_approved']='(Customer) Account approved';
$hesklang['desc_customer_rejected']='(Customer) Account rejected';
$hesklang['desc_email_rejected_can_self_register']='(Customer) Ticket via email rejected; customer can self-register';
$hesklang['desc_email_rejected_cannot_self_register']='(Customer) Ticket via email rejected; customer cannot self-register';
$hesklang['user_added_success_no_pass']='New user %s has been successfully added';
$hesklang['email_tag_requester']='Requester (From)';
$hesklang['email_tag_requester_name']='Requester (From) Name';
$hesklang['email_tag_requester_first_name']='Requester (From) First Name';
$hesklang['email_tag_requester_email']='Requester (From) Email';
$hesklang['email_tag_followers']='Followers (Cc)';
$hesklang['email_tag_follower_names']='Follower (Cc) Names';
$hesklang['email_tag_follower_emails']='Follower (Cc) Emails';
$hesklang['barcode']='Barcode';
$hesklang['barcode_use']='Display a barcode on printed tickets';
$hesklang['barcode_staff_only']='Hide the barcode from customers';
$hesklang['barcode_type']='Barcode type';
$hesklang['barcode_format']='Format';
$hesklang['barcode_width']='Width';
$hesklang['barcode_height']='Height';
$hesklang['barcode_color']='Color';
$hesklang['barcode_bg']='Background';
$hesklang['copy_link']='Copy ticket link';
$hesklang['copy_link_title']='Copy public link to this ticket';
$hesklang['copy_link_exp']='The copied link is the direct link for the customer to view this ticket';
$hesklang['copy_value']='Copy this value';
$hesklang['download_class']='This function requires the ZipArchive class. Ask your host to compile PHP with zip support.';
$hesklang['download_all']='Download all';
$hesklang['download_prep']='Preparing download...';
$hesklang['download_tma']='Too many attachments';
$hesklang['download_nva']='No valid attachments';
$hesklang['download_ntd']='Nothing to download';
$hesklang['resolved_at']='Resolved at';
$hesklang['disable_GSSAPI']='Disable GSSAPI authenticator (Kerberos error work-around)';
$hesklang['ex_history']='Include ticket history log in export';
$hesklang['sm_location']='Location'; // Location (page) of a service message
$hesklang['loc_sm']='Show this service message on:';
$hesklang['loc_all']='Every customer page';
$hesklang['loc_norec']='(not recommended)';
$hesklang['loc_home']='Help desk homepage';
$hesklang['loc_selected']='On selected pages';
$hesklang['loc_selerr']='Select at least one page to show the message on';
$hesklang['loc_t_cat']='Submit a ticket - select a category';
$hesklang['loc_t_add']='Submit a ticket - submit a ticket form';
$hesklang['loc_t_ok']='Submit a ticket - ticket confirmation';
$hesklang['loc_t_view']='View a ticket';
$hesklang['loc_t_form']='View a ticket form';
$hesklang['loc_kb_main']='Knowledgebase homepage';
$hesklang['loc_kb_sub']='Knowledgebase sub-category pages';
$hesklang['loc_kb_art']='Knowledgebase articles';
$hesklang['loc_login']='Customer login page';
$hesklang['loc_register']='Customer registration page';
$hesklang['loc_register_ok']='Customer registration successful';
$hesklang['loc_acc']='Customer &quot;My tickets&quot; page';
$hesklang['loc_profile']='Customer &quot;Profile&quot; page';
$hesklang['sending_show']='Show &quot;Submitting&quot; notification';
$hesklang['sending_wait']='Submitting, please wait...';
$hesklang['e_c_email']='Enter the correct email address to view this ticket';
$hesklang['only_verified_cc']='Followers without a verified account will be ignored.';
$hesklang['followers_removed']='These email addresses have been removed from the ticket because they do not have a verified account:';
$hesklang['novace']='We did not find any registered and verified accounts with this email address.';
$hesklang['max_recipients']='Max recipients';
$hesklang['max_recipients2']='in a single email';
$hesklang['admin_js']='Admin JS';
$hesklang['admin_js2']='Load an extra custom Javascript file for the admin panel';
$hesklang['cf_limit_all']='You have reached the custom fields limit and cannot create new custom fields.';
$hesklang['remind_assigned']='Remind assigned staff';
$hesklang['remind_sent']='Email reminder to the assigned staff member sent';
$hesklang['thist23']='<li class="smaller">%s | reminder sent to %s by %s</li>';
$hesklang['ql_bookmarks']='Bookmarks';
$hesklang['bookmark']='My Bookmark';
$hesklang['bookmarks_add']='Add to Bookmarks';
$hesklang['bookmarks_added']='This ticket has been added to your Bookmarks';
$hesklang['bookmarks_remove']='Remove from Bookmarks';
$hesklang['bookmarks_removed']='This ticket has been removed from your Bookmarks';
$hesklang['genl_not_copied']='Error: Copying to clipboard not supported on this device/browser.';
$hesklang['profile_duplicate_email']='User with email <b>%s</b> already exists.'; // %s: new email
$hesklang['seq_id_numeric']='Ticket number search must contain numbers only';
$hesklang['confirm_new_pass']='Confirm new password';
$hesklang['piping_notify_rejected_customers1']='Customer rejection emails';
$hesklang['piping_notify_rejected_customers2']='Send a rejection email to customers when their ticket is rejected';
$hesklang['piping_notify_rejected_customers3']='Time between rejection emails';
$hesklang['register_url']='Registration URL';
$hesklang['email_subject']='Email subject';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Collaborating on ticket: %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] Staff replied to: %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] Note added to: %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Ticket overdue: %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Ticket resolved: %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Follow-up email cutoff date:'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='Do not email tickets resolved more than'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='ago (must be longer time period than "%s")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='The email cutoff date period must be longer than the follow-up email delay';
$hesklang['available_language']='Available Languages';
$hesklang['click_to_show_available_language']='Click to show available languages';
$hesklang['install_lan']='Install';
$hesklang['remove_lan']='Remove';
$hesklang['title_lan']='Title';
$hesklang['description_lan']='Description';
$hesklang['completed_lan']='Completed';
$hesklang['no_language_availble']='No languages are available';
$hesklang['success_install_lan_txt']='language has been successfully added';
$hesklang['error_install_lan_txt']='language has not been added';
$hesklang['success_remove_lan_txt']='language has been successfully removed';
$hesklang['error_remove_lan_txt']='language has not been removed';
$hesklang['remove_default_language_error']='The default language must remain active and cannot be removed';
$hesklang['click_for_manual_step']='Click for Manual installation';
$hesklang['upgrade_lan']='Update';
$hesklang['success_upgrade_lan_txt']='language has been successfully Updated';
$hesklang['error_upgrade_lan_txt']='language has not been Updated';
$hesklang['please_wait']='Please wait...';
$hesklang['add_a_note']='Add a note';
$hesklang['add_a_reply']='Add a reply';
$hesklang['customer_id']='Customer ID';
$hesklang['deleting_customer_tickets']='Tickets opened by customer: <b>%1$s</b><br>What should we do with these tickets?'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Tickets where customer is copied: <b>%1$s</b><br>These will lose this customer as a follower; tickets remain unchanged.'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Permanently delete tickets';
$hesklang['deleting_customer_anonymize_tickets2']='Anonymize tickets (remove messages and personal data)';
$hesklang['deleting_customer_retain_tickets2']='Keep tickets (leave all data intact)';
$hesklang['for_staff']='for help desk staff'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='for customers'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='IMAP Mailbox';
$hesklang['file_attachment_options']='Email Attachment Options';
$hesklang['link_to_attachments_in_emails']='Link to attachments in emails';
$hesklang['add_attachments_directly_to_emails']='Add attachments directly to emails';
$hesklang['directly_attach_file_smaller_than']='Directly attach only files smaller than';
$hesklang['directly_attach_file_of_any_size']='Directly attach files of any size';
$hesklang['directly_attach_only_first_x_attachments']='Directly attach only first';
$hesklang['directly_attach_all_attachments']='Directly attach all attachments';
$hesklang['directly_attach_size']='Attachment size';
$hesklang['directly_attach_no_of_files']='Number of files';
$hesklang['notice_about_directly_attach_files']='Attaching many or large files to emails may case delays when communicating with your SMTP server';
$hesklang['fatt_2']='Additional files attached to this message:';
$hesklang['no_collaborators']='None';
$hesklang['collaborate']='Collaborate on this ticket';
$hesklang['collaborators']='Collaborators';
$hesklang['ql_cbm']='Collaborator';
$hesklang['collaborating']='You are now collaborating on this ticket';
$hesklang['not_collaborating']='You are not collaborating on this ticket anymore';
$hesklang['add_collaborator']='Add a collaborator';
$hesklang['user_collaborator_added']='User added as a collaborator on this ticket';
$hesklang['remove_collaborator']='Remove collaborator';
$hesklang['staff_name']='Staff name';
$hesklang['user_collaborator_removed']='User removed as a collaborator on this ticket';
$hesklang['desc_collaborator_added']='(Staff) You are collaborating on a new ticket';
$hesklang['desc_collaborator_staff_reply']='(Staff) A staff member responded to a collaborated ticket';
$hesklang['desc_collaborator_note']='(Staff) New note added to a collaborated ticket';
$hesklang['desc_collaborator_resolved']='(Staff) A collaborated ticket has been resolved';
$hesklang['desc_collaborator_overdue']='(Staff) A collaborated ticket is overdue';
$hesklang['notify_collaborator_added']='I am added as a ticket collaborator';
$hesklang['notify_collaborator_customer_reply']='Customer responds to a collaborated ticket';
$hesklang['notify_collaborator_staff_reply']='Staff responds to a collaborated ticket';
$hesklang['notify_collaborator_note']='Staff adds a note to a collaborated ticket';
$hesklang['notify_collaborator_resolved']='Staff resolves a collaborated ticket';
$hesklang['notify_collaborator_overdue']='Collaborated ticket is overdue';
$hesklang['recurring_tickets']['tab']='Recurring Tickets'; // Menu link
$hesklang['recurring_tickets']['page_title']='Recurring Tickets'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Automate the busywork; let Hesk raise routine tickets for you, exactly when you need them.';
$hesklang['recurring_tickets']['active_rules']='Active rules';
$hesklang['recurring_tickets']['new']='New recurring ticket rule';
$hesklang['recurring_tickets']['no_rules']='You do not have any recurring ticket rules. Create one by clicking the &quot;New recurring ticket rule&quot; button above.';
$hesklang['recurring_tickets']['title']='Rule title';
$hesklang['recurring_tickets']['titlet']='A descriptive title, for example: Re-assign tickets not replied to within a day';
$hesklang['recurring_tickets']['default_title']='Rule by %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Rule trigger';
$hesklang['recurring_tickets']['trigt']='Set the condition that will trigger (run) this rule.';
$hesklang['recurring_tickets']['hits']='Hits'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Creation Time'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='General Settings'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Custom Fields'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Content'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='Delete this rule?';
$hesklang['recurring_tickets']['edit']='Editing recurring ticket rule ID %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='Within:';
$hesklang['recurring_tickets']['minutes']='minutes';
$hesklang['recurring_tickets']['hours']='hours';
$hesklang['recurring_tickets']['days']='days';
$hesklang['recurring_tickets']['weeks']='weeks';
$hesklang['recurring_tickets']['months']='months';
$hesklang['recurring_tickets']['years']='years';
$hesklang['recurring_tickets']['setpri']='Set priority to:';
$hesklang['recurring_tickets']['setsta']='Set status to:';
$hesklang['recurring_tickets']['assto']='Assign ticket to:';
$hesklang['recurring_tickets']['asm']='Another staff member';
$hesklang['recurring_tickets']['notify']='Notify staff members...';
$hesklang['recurring_tickets']['ato']='Apply to:';
$hesklang['recurring_tickets']['save']='Save rule';
$hesklang['recurring_tickets']['e_tt']='Time should be between 1 and 10000';
$hesklang['recurring_tickets']['nocat']='Select at least one category';
$hesklang['recurring_tickets']['nouser']='Select at least one user';
$hesklang['recurring_tickets']['nostatus']='Select at least one status';
$hesklang['recurring_tickets']['nocata']='%1$s doesn\'t have access to these categories:'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='New rule has been created';
$hesklang['recurring_tickets']['mdf']='Rule settings have been saved';
$hesklang['recurring_tickets']['e_id']='No rule with this ID found';
$hesklang['recurring_tickets']['deleted']='Selected rule has been deleted';
$hesklang['recurring_tickets']['log_title']='Rule #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Active'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Activate this rule (start using it)';
$hesklang['recurring_tickets']['activated']='Selected rule has been activated'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='Deactivate this rule (stop using it)';
$hesklang['recurring_tickets']['deactivated']='Selected rule has been deactivated'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='No active recurring ticket rules';
$hesklang['recurring_tickets']['tools']='Tools';
$hesklang['recurring_tickets']['tbef']='Before a rule is live, you need to activate it by clicking the checkbox in the &quot;ACTIVE&quot; column.<br><br>
                               <strong>Active rules are processed every %2$s minutes.</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[RULE]';
$hesklang['recurring_tickets']['r2']='[RULE] Rule #%s';
$hesklang['recurring_tickets']['r3']='Rule #%s';
$hesklang['recurring_tickets']['i']='[INFO]';
$hesklang['recurring_tickets']['matched']='Number of tickets already created today: %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Reset this rule';
$hesklang['recurring_tickets']['reset2']='Are you sure you want to reset this rule?<br><br>Rule hits will go to 0 and any tickets already generated for it today, might be re-generated on next cron run.';
$hesklang['recurring_tickets']['reset3']='Selected rule has been reset';
$hesklang['recurring_tickets']['test']='Simulate this rule';
$hesklang['recurring_tickets']['testa']='Simulate all rules';
$hesklang['recurring_tickets']['testaa']='Simulate all active rules';
$hesklang['recurring_tickets']['testr']='Simulation results';
$hesklang['recurring_tickets']['rsim']='Repeat simulation';
$hesklang['recurring_tickets']['sim']='SIMULATION MODE, no changes to the database';
$hesklang['recurring_tickets']['sic']='SIMULATION COMPLETE';
$hesklang['recurring_tickets']['rrule_type_required']='Please select a valid recurring rule trigger.';
$hesklang['recurring_tickets']['rrule_string_required']='Please select all required recurring rule trigger options.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Please enter an interval value of 1 or bigger for "Every".';
$hesklang['recurring_tickets']['disable_note']='*If any critical hesk settings are changed after creation of a rule, it will be disabled on next run attempt and needs to be edited to pass new validation requirements.';
$hesklang['recurring_tickets']['thist1']='<li class="smaller">%1$s | submitted by Recurring Tickets Rule "%2$s"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class="smaller">%1$s | assigned to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class="smaller">%1$s | closed automatically by Recurring Tickets Rule "%2$s"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class="smaller">%1$s | status changed to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class="smaller">%1$s | automatically assigned to %2$s by Recurring Tickets Rule "%3$s"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='Rule was disabled due to validation errors. Check below for details.';
$hesklang['recurring_tickets']['errors_title']='One or more of your rules have produced errors when they attempted to be ran and were disabled.';
$hesklang['recurring_tickets']['rule_errors']='<hr>Rule #%s errors:';
$hesklang['recurring_tickets']['create_customers']='There are no existing customers - please create them <a href="%s" target="_blank">here</a>.';
$hesklang['recurring_tickets']['exec_dates']='Rule execution dates';
$hesklang['recurring_tickets']['show_exec_dates']='[Show current rule execution dates]';
$hesklang['recurring_tickets']['no_exec_dates']='Please select valid rule triggers to see execution dates.';
$hesklang['recurring_tickets']['invalid_disabled']='invalid Rrule settings - rule disabled.';
$hesklang['recurring_tickets']['next_occ']='Next %s rule occurrences:';
$hesklang['recurring_tickets']['occ_on']='on %s';
$hesklang['recurring_tickets']['not_firing_today']='does not need firing today.';
$hesklang['recurring_tickets']['rules_fulfilled']='recurring rules fulfilled - ticket created today!';
$hesklang['recurring_tickets']['validation_failed']='validation failed - rule disabled. Details below:';
$hesklang['recurring_tickets']['validation_error']='Validation error:';
$hesklang['recurring_tickets']['processed']='processed.';
$hesklang['recurring_tickets']['created_ticket']='created ticket id: %1$s, trackid: %2$s';
$hesklang['recurring_tickets']['due_date_note']='relative to ticket creation date';
$hesklang['priorities']='Priorities';
$hesklang['priority_intro']='Use this tool to manage ticket priorities for your help desk';
$hesklang['new_priority']='New priority';
$hesklang['edit_priority']='Edit priority';
$hesklang['priority_title']='Title';
$hesklang['can_customers_select_it']='Can customers select this priority?';
$hesklang['selected_by_customer']='Selectable by customers';
$hesklang['err_priority']='Enter the priority title';
$hesklang['priority_added']='A new priority has been added';
$hesklang['priority_e_id']='Invalid priority ID';
$hesklang['priority_mdf']='Priority has been saved';
$hesklang['priority_deleted']='Priority deleted';
$hesklang['priority_not_found']='This priority does not exist';
$hesklang['priority_not_empty']='This priority cannot be deleted because tickets with this priority exist';
$hesklang['click_to_enable_drag_drop']='Click to enable drag-and-drop for the row, then drag the row up or down to re-arrange priorities.';
$hesklang['confirm_delete_priority']='Are you sure you want to delete this priority?';
$hesklang['reordered_message']='Your priority list order has been saved.';
$hesklang['list_tkt_priority']='List all tickets with this priority';
$hesklang['deletion_priority_restricted']='This is a special priortiy and cannot be deleted';
$hesklang['priority_limit']='You cannot create any new priorities';
$hesklang['skip_to_main_content']='Skip to Main Content';
$hesklang['opens_dialog']='Opens a dialog';
$hesklang['create_a_ticket']='Create a ticket';
$hesklang['toggle_navigation']='Toggle navigation';
$hesklang['add_a_ticket_reply']='Add a ticket reply';
$hesklang['linked_tickets']='Linked tickets';
$hesklang['no_linked_tickets']='No linked tickets';
$hesklang['link_ticket']='Link ticket';
$hesklang['can_link_tickets_e']='You are not authorized to link/unlink this ticket';
$hesklang['link_ticket_success']='The ticket has been linked successfully';
$hesklang['link_ticket_required_error']='To link a ticket, please provide a valid Tracking ID';
$hesklang['link_ticket_itself_error']='A ticket cannot be linked to itself. Please enter a different Tracking ID';
$hesklang['already_linked_error']='The ticket has already been linked';
$hesklang['unlink_success']='The ticket has been successfully unlinked';
$hesklang['unlink_error']='No linked record exists';
$hesklang['link_history']='<li class="smaller">%s | %s ticket linked by %s</li>';
$hesklang['unlink_history']='<li class="smaller">%s | %s ticket unlinked by %s</li>';
$hesklang['can_link_tickets']='Can link ticket';
$hesklang['link_a_ticket']='Link a ticket';
$hesklang['mfa_curl']='Unable to generate a QR image to scan because <strong>cURL</strong> support is not enabled on your server.';
$hesklang['require_xml']='PHP-XML must be enabled for Rich Text (HTML) messages. Please ask your web host to enable XML for PHP.';
$hesklang['thist24']='<li class="smaller">%1$s | %2$s added as a collaborator by %3$s</li>';
$hesklang['thist25']='<li class="smaller">%1$s | %2$s removed as a collaborator by %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Perfect for preventive-maintenance jobs, monthly access reviews, recurring customer check-ins, and more.';
$hesklang['recurring_tickets']['feat1']='<strong>Set and forget schedules.</strong> Daily, every Monday, every March, the 15th of each month, or any future date';
$hesklang['recurring_tickets']['feat2']='<strong>Arrive pre-filled and assigned.</strong> Choose category, priority, agent, and up to 100 custom field values';
$hesklang['recurring_tickets']['feat3']='<strong>Preview dates and Simulate.</strong> See every ticket Hesk will generate before activating a rule, so there are no surprises.';
$hesklang['unlink_btn']='Unlink';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');