<?php
/*
*
* Language file for Help Desk Software HESK (https://www.hesk.com)
* Language: Português (Portuguese)
* Version: 3.6.x
*
* ==> CONTRIBUTORS
*
* Pedro Jesus (http://www.pos.pt)
* Pedro Augusto Marques
* José Rui Valoura (https://www.4infor.pt)
*
* ==> HOW TO TRANSLATE THIS FILE
*
* https://www.hesk.com/knowledgebase/?article=34
*
* ==> HOW TO CUSTOMIZE TEXT
*
* Do NOT customize text inside here, it will be overwritten by updates!
*
* Follow this guide instead:
* https://www.hesk.com/knowledgebase/?article=88
*
* ==> IMPORTANT: FILE ENCODING
*
* This file *must* be saved in UTF-8 encoding without byte order mark (BOM)
* Test chars: àáâãäåæ
*
* https://www.hesk.com/knowledgebase/?article=87
*
*/

// Native name of language, for example: Deutsch
$hesklang['LANGUAGE']='Português';

// English name of language, for example: German
$hesklang['LANGUAGE_EN']='Portuguese';

// Language encoding. It MUST be set to UTF-8 for all languages!
$hesklang['ENCODING']='UTF-8';

// MySQL utf8 collation. Do not change if not sure what to use.
$hesklang['_COLLATE']='utf8_unicode_ci';

// This is the email break line that will be used in email piping
$hesklang['EMAIL_HR']='------ Responder acima desta linha ------';

// EMAIL SUBJECTS
$hesklang['new_ticket_staff']='[#%%TRACK_ID%%] Novo pedido: %%SUBJECT%%';
$hesklang['ticket_received']='[#%%TRACK_ID%%] Pedido recebido: %%SUBJECT%%';
$hesklang['ticket_assigned_to_you']='[#%%TRACK_ID%%] Pedido atribuído: %%SUBJECT%%';
$hesklang['new_reply_by_customer']='[#%%TRACK_ID%%] Nova resposta para: %%SUBJECT%%';
$hesklang['new_reply_by_staff']='[#%%TRACK_ID%%] Nova resposta para: %%SUBJECT%%';
$hesklang['category_moved']='[#%%TRACK_ID%%] Pedido movido: %%SUBJECT%%';
$hesklang['new_note']='[#%%TRACK_ID%%] Nota adicionada a: %%SUBJECT%%';
$hesklang['new_pm']='Nova mensagem privada: %%SUBJECT%%';
$hesklang['forgot_ticket_id']='Lista dos seus pedidos de suporte';

// ERROR MESSAGES
$hesklang['cant_connect_db']='Não foi possível conectar à base de dados!';
$hesklang['invalid_action']='Ação Inválida';
$hesklang['select_username']='Por favor, digite o seu nome de utilizador';
$hesklang['enter_pass']='Por favor, digite a sua senha';
$hesklang['cant_sql']='Não foi possível executar este comando SQL';
$hesklang['contact_webmsater']='Por favor, contacte o webmaster:';
$hesklang['mysql_said']='MySQL retornou';
$hesklang['wrong_pass']='Senha Incorreta.';
$hesklang['session_expired']='Sessão expirada, por favor, insira o seu login nos campos abaixo.';
$hesklang['attempt']='Tentativa Inválida!';
$hesklang['not_authorized_tickets']='Você não está autorizado a visualizar os tickets desta categoria!';
$hesklang['must_be_admin']='Você não está autorizado a visualizar esta página! Faça login como administrador.';
$hesklang['no_session']='Impossível iniciar nova sessão!';
$hesklang['error']='Erro';
$hesklang['int_error']='Erro interno de script';
$hesklang['no_trackID']='Sem ID rastreador';
$hesklang['status_not_valid']='Status inválido';
$hesklang['trackID_not_found']='ID rastreador não encontrado';
$hesklang['enter_message']='Por favor, insira sua mensagem';
$hesklang['select_priority']='Por favor, selecione a prioridade';
$hesklang['ticket_not_found']='Ticket não encontrado! Por favor, verifique se o ID rastreador foi digitado corretamente!';
$hesklang['no_selected']='Nenhum ticket selecionado, nada para mudar';
$hesklang['id_not_valid']='Este não é um ID válido';
$hesklang['enter_id']='Por favor, digite o ID rastreador';
$hesklang['enter_name']='Por favor, digite o nome do cliente';
$hesklang['enter_date']='Por favor, digite a data que deseja procurar';
$hesklang['date_not_valid']='Esta não é uma data válida. Por favor, digite a data neste formato <b>DD-MM-AAAA</b>';
$hesklang['enter_subject']='Por favor, digite um assunto para o ticket';
$hesklang['invalid_search']='Ação de busca inválida';
$hesklang['choose_cat_ren']='Por favor, selecione uma categoria para ser renomeada';
$hesklang['cat_ren_name']='Por favor, digite o nome da nova categoria';
$hesklang['cat_not_found']='Categoria não encontrada';
$hesklang['enter_cat_name']='Por favor, digite o nome da categoria';
$hesklang['no_cat_id']='Sem ID de categoria';
$hesklang['cant_del_default_cat']='Você não pode eliminar a categoria default, você pode apenas renomeá-la';
$hesklang['no_valid_id']='ID de utilizador inválido';
$hesklang['user_not_found']='Utilizador não encontrado';
$hesklang['enter_real_name']='Por favor, digite um nome real';
$hesklang['enter_valid_email']='Por favor, digite um e-mail válido';
$hesklang['enter_username']='Por favor, digite o nome de utilizador (login)';
$hesklang['asign_one_cat']='Por favor associe o utilizador a pelo menos uma categoria!';
$hesklang['signature_long']='Assinatura muito longa! Limite da assinatura é de 1000 caracteres';
$hesklang['confirm_user_pass']='Por favor, confirme senha';
$hesklang['passwords_not_same']='As senhas inseridas não conferem!';
$hesklang['cant_del_admin']='Você não pode eliminar o administrador padrão!';
$hesklang['cant_del_own']='Você não pode eliminar o perfil no qual está ligado!';
$hesklang['enter_your_name']='Por favor, insira seu nome';
$hesklang['sel_app_cat']='Por favor, selecione a categoria apropriada';
$hesklang['sel_app_priority']='Por favor, selecione a prioridade apropriada';
$hesklang['enter_ticket_subject']='Por favor, digite o assunto do seu ticket';
$hesklang['user_not_found_nothing_edit']='Utilizaor não encontrado ou nada a mudar';

// ADMIN PANEL
$hesklang['administrator']='Administrador';
$hesklang['login']='Login';
$hesklang['user']='Utilizador';
$hesklang['username']='Username';
$hesklang['pass']='Password';
$hesklang['confirm_pass']='Confirme senha';
$hesklang['logged_out']='Desconectado';
$hesklang['logout']='Sair';
$hesklang['logout_success']='Você saiu do sistema com sucesso!';
$hesklang['click_login']='Clique aqui para efetuar login';
$hesklang['back']='Voltar';
$hesklang['displaying_pages']='Mostrando <b>%d</b> tickets. Páginas:';
$hesklang['trackID']='ID rastreador';
$hesklang['timestamp']='Timestamp';
$hesklang['name']='Nome / Empresa';
$hesklang['subject']='Assunto';
$hesklang['status']='Status';
$hesklang['priority']='Prioridade';
$hesklang['open']='Novo';
$hesklang['open_action']='Abrir'; // Open ACTION
$hesklang['close']='Closed'; // Closed ticket STATUS
$hesklang['any_status']='qualquer status';
$hesklang['high']='Alta';
$hesklang['medium']='Média';
$hesklang['low']='Baixa';
$hesklang['del_selected']='Deletar tickets selecionados';
$hesklang['manage_cat']='Gerir Categorias';
$hesklang['profile']='Seu Perfil';
$hesklang['show_tickets']='Mostrar tickets';
$hesklang['sort_by']='Ordenar por';
$hesklang['date_posted']='Data de Postagem';
$hesklang['category']='Categoria';
$hesklang['any_cat']='Qualquer categoria';
$hesklang['order']='Ordem';
$hesklang['ascending']='Ascendente';
$hesklang['descending']='Descendente';
$hesklang['display']='Exibir';
$hesklang['tickets_page']='tickets por página';
$hesklang['find_ticket']='Procurar ticket';
$hesklang['yyyy_mm_dd']='DD-MM-AAAA';
$hesklang['results_page']='resultados por página';
$hesklang['opened']='aberto'; // The ticket has been OPENED
$hesklang['closed']='Resolvido'; // Ticket has been RESOLVED
$hesklang['ticket']='Ticket';
$hesklang['tickets']='Tickets';
$hesklang['ticket_been']='Este ticket foi';
$hesklang['view_ticket']='Visualizar ticket';
$hesklang['open_tickets']='Tickets abertos';
$hesklang['remove_statement']='Remover informação &quot;Powered by&quot;...';
$hesklang['click_info']='Clique aqui para mais infomações';
$hesklang['reply_added']='Reply added';
$hesklang['reply_submitted']='Resposta enviada';
$hesklang['ticket_marked']='Este ticket foi marcado';
$hesklang['ticket_status']='Status do ticket';
$hesklang['replies']='Respostas';
$hesklang['date']='Data';
$hesklang['email']='E-mail';
$hesklang['ip']='IP';
$hesklang['message']='Mensagem';
$hesklang['add_reply']='Adicionar resposta';
$hesklang['close_this_ticket']='Marque este ticket Resolvido';
$hesklang['change_priority']='Mudar prioridade para';
$hesklang['attach_sign']='Anexar assinatura';
$hesklang['profile_settings']='Preferências do perfil';
$hesklang['submit_reply']='Enviar resposta';
$hesklang['support_panel']='Painel de suporte';
$hesklang['ticket_trackID']='ID do ticket rastreador';
$hesklang['c2c']='Cique aqui para continuar';
$hesklang['tickets_deleted']='Tickets apagados';
$hesklang['num_tickets_deleted']='<b>%d</b> tickets foram apagados';
$hesklang['confirm_del_cat']='Tem a certeza que deseja remover esta categoria?';
$hesklang['cat_intro']='Aqui você pode gerir as categorias, que são úteis para classificar tickets por relevância (por exemplo &quot;Vendas&quot;, &quot;Problemas de Hardware&quot;, &quot;Problemas de PHP/MySQL&quot; etc) e para designar utilizadores ás categorias (por exemplo, seu pessoal de vendas pode apenas ver tickets enviados para &quot;Vendas&quot; categoria)';
$hesklang['cat_name']='Nome da categoria';
$hesklang['remove']='Remover';
$hesklang['add_cat']='Adicionar nova categoria';
$hesklang['max_chars']='max de 40 caracteres';
$hesklang['create_cat']='Criar categoria';
$hesklang['ren_cat']='Renomear categoria';
$hesklang['to']='Até';
$hesklang['cat_added']='Categoria adicionada';
$hesklang['cat_name_added']='Categoria %s foi adicionada com sucesso';
$hesklang['cat_renamed']='Categoria renomeada';
$hesklang['cat_renamed_to']='Categoria selecionada foi renomeada com sucesso para';
$hesklang['cat_removed']='Categoria removida';
$hesklang['cat_removed_db']='Categoria selecionada foi removida com sucesso do base de dados';
$hesklang['sure_remove_user']='Tem a certeza de deseja remover este utilizador?';
$hesklang['manage_users']='Gerir utilizadores';
$hesklang['users_intro']='Aqui você gerencia os utilizadores que podem fazer login no painel do administrador e responder tickets. Administradores podem visualizar/editar tickets em qualquer categoria e ter acesso a todas funções do painel do administrador (Gerir utilizadores, Gerir categorias etc) enquanto outros utilizadores poderão apenas visualizar e responder a tickets da sua categoria.';
$hesklang['yes']='SIM';
$hesklang['no']='NãO';
$hesklang['edit']='Editar';
$hesklang['add_user']='Adicionar novo utilizador';
$hesklang['req_marked_with']='Campos obrigatórios estão marcados com';
$hesklang['real_name']='Nome real';
$hesklang['signature_max']='Assinatura (max 1000 caracteres)';
$hesklang['sign_extra']='Código HTML não é permitido. Links ainda serão clicáveis.';
$hesklang['create_user']='Criar utilizador';
$hesklang['editing_user']='Editando utilizador';
$hesklang['user_added']='Utilizador adicionado';
$hesklang['user_added_success']='Novo utilizador %s com senha %s foi adicionado com sucesso';
$hesklang['profile_updated']='Perfil atualizado';
$hesklang['profile_updated_success']='Seu perfil foi atualizado com sucesso';
$hesklang['user_removed']='Utilizador removido';
$hesklang['sel_user_removed']='Utilizador selecionado foi removido com sucesso do base de dados.';
$hesklang['profile_for']='Perfil para';
$hesklang['new_pass']='Nova senha';
$hesklang['update_profile']='Atualizar Perfil';
$hesklang['notify_new_posts']='Notifique-me de novos tickets e postagens dentro da minha categoria';
$hesklang['view_profile']='Ver Perfil';
$hesklang['new_ticket_submitted']='Novo ticket de suporte enviado';
$hesklang['user_profile_updated_success']='Este perfil de utilizador foi atualizado com sucesso';
$hesklang['printer_friendly']='Versão para imprimir';
$hesklang['end_ticket']='--- Fim do ticket ---';

// CUSTOMER INTERFACE
$hesklang['your_ticket_been']='Seu ticket foi';
$hesklang['view_your_ticket']='Visualizar seu ticket';
$hesklang['submit_ticket']='Enviar um ticket';
$hesklang['sub_ticket']='Enviar ticket';
$hesklang['before_submit']='Antes de enviar, por favor, certifique-se do seguinte:';
$hesklang['all_info_in']='Todas as informações necessárias foram preenchidas corretamente';
$hesklang['all_error_free']='Todas as informações estão corretas e livres de erros';
$hesklang['we_have']='Nós registaremos';
$hesklang['recorded_ip']='como seu IP.';
$hesklang['recorded_time']='o horário de envio.';
$hesklang['save_changes']='Gravar alterações';
$hesklang['reply_submitted_success']='A sua resposta para esse ticket foi enviada com sucesso';
$hesklang['ticket_submitted']='Ticket enviado';
$hesklang['ticket_submitted_success']='O seu ticket foi enviado com sucesso! ID do Ticket';
$hesklang['your_ticket']='Seu ticket';

// Added in version 0.94
$hesklang['check_updates']='Certifique-se de que possui sempre a última versão do HESK instalada!';
$hesklang['check4updates']='Verificar atualizações';
$hesklang['wait_reply']='Sem Resposta';
$hesklang['replied']='Respondido';
$hesklang['last_replier']='Último remetente';
$hesklang['staff']='Equipa';
$hesklang['customer']='Utilizador';
$hesklang['close_selected']='Marcar tickets selecionados como resolvido';
$hesklang['execute']='Executar';
$hesklang['saved_replies']='Mensagem modelo';
$hesklang['manage_saved']='Mensagem modelo';
$hesklang['manage_intro']='Aqui você pode adicionar e gerir as suas mensagens modelo. Estas são constantemente utilizadas para respostas padrões que são mais ou menos as mesmas  para todos clientes. Você poderá utilizá-las para evitar escrever várias vezes a mesma mensagem a cada novo ticket ou resposta.';
$hesklang['saved_title']='Título (max 50 caracteres)';
$hesklang['no_saved']='Sem mensagens modelo';
$hesklang['delete_saved']='Tem certeza de deseja eliminar esta mensagem modelo?';
$hesklang['new_saved']='Adicionar ou editar uma mensagem modelo';
$hesklang['canned_add']='Criar uma nova mensagem modelo';
$hesklang['canned_edit']='Editar mensagens modelo selecionadas';
$hesklang['save_reply']='Gravar resposta';
$hesklang['saved']='Resposta gravada';
$hesklang['your_saved']='A sua mensagen modelo foi gravada para uso futuro';
$hesklang['ent_saved_title']='Por favor, digite o título da resposta';
$hesklang['ent_saved_msg']='Por favor, digite uma mensagem de resposta';
$hesklang['saved_removed']='Mensagem modelo removida';
$hesklang['saved_rem_full']='As mensagens modelo selecionadas foram removidas do base de dados';
$hesklang['clip_alt']='Esta mensagem contém anexo';
$hesklang['attachments']='Anexos';
$hesklang['fill_all']='Campo não preenchido';
$hesklang['file_too_large']='Seu icheiromuito grande';
$hesklang['cannot_move_tmp']='Não foi possível mover o ficheiro para a pasta de anexos';
$hesklang['created_on']='Criado em';
$hesklang['tickets_closed']='Tickets fechados';
$hesklang['num_tickets_closed']='<b>%d</b> tickets have been closed';
$hesklang['select_saved']='Selecionar uma mensagem modelo';
$hesklang['select_empty']='Seleção / Vazia';
$hesklang['insert_special']='Inserir TAG especial (será substituída pelas informações do cliente)';
$hesklang['move_to_catgory']='Mover ticket para';
$hesklang['move']='Mover';
$hesklang['moved']='Ticket movido';
$hesklang['moved_to']='Este ticket foi movido para uma nova categoria';
$hesklang['url']='URL';
$hesklang['all_not_closed']='Todos não fechados';
$hesklang['chg_all']='Mudar todos';
$hesklang['settings']='Definições';
$hesklang['settings_intro']='Use esta ferramenta para configurar o seu help desk. Para mais informações sobre todos ajustestodas as definições e opções, clique no sinal de ajuda ou leia o arquivo readme.html.';
$hesklang['all_req']='Todos os campos (exceto os desabilitados) são necessários!';
$hesklang['wbst_title']='Título do Website';
$hesklang['wbst_url']='URL do website';
$hesklang['email_wm']='E-mail do webmaster';
$hesklang['max_listings']='Listas por página';
$hesklang['print_size']='Tamanho da fonte de impressão';
$hesklang['debug_mode']='Modo debug';
$hesklang['on']='Ligado';
$hesklang['off']='Desligado';
$hesklang['use_secimg']='Use imagem Anti-SPAM';
$hesklang['secimg_no']='Não disponível';
$hesklang['attach_use']='Use anexos';
$hesklang['attach_num']='Número por post';
$hesklang['attach_type']='Tipos de arquivos permitidos';
$hesklang['place_after']='Após mensagem';
$hesklang['place_before']='Antes da mensagem';
$hesklang['custom_f']='campo personalizavel';
$hesklang['custom_u']='Use este campo';
$hesklang['custom_n']='Nome do campo';
$hesklang['custom_l']='Tamanho máximo (caracteres)';
$hesklang['db_host']='Host da base de dados';
$hesklang['db_name']='Nome do base de dados';
$hesklang['db_user']='Nome de utilizador do base de dados';
$hesklang['db_pass']='Senha do base de dados';
$hesklang['err_sname']='Por favor, digite o título do seu website';
$hesklang['err_surl']='Por favor, digite a URL do seu website.';
$hesklang['err_wmmail']='Por favor, digite um email de webmaster válido';
$hesklang['err_nomail']='Por favor, digite um email de não-resposta válido';
$hesklang['err_htitle']='Por favor, digite um título do seu Help Desk de suporte';
$hesklang['err_hurl']='Por favor, digite a URL da sua pasta de Help Desk. Certifique-se que é uma URL válida (Começa com http:// ou https://)';
$hesklang['err_lang']='Por favor, selecione um idioma para o HESK';
$hesklang['err_nolang']='O ficheiro de linguagem especificado não existe na pasta de idiomas. Certifique-se que faz o upload do ficheiro apropriado antes de mudar as opções de idioma.';
$hesklang['err_max']='Por favor, digite a quantidade máxima de itens por página';
$hesklang['err_psize']='Por favor, digite o tamanho da fonte de impressão';
$hesklang['err_dbhost']='Por favor, digite o nome do Host da sua base de dados MySQL';
$hesklang['err_dbname']='Por favor, digite o nome da sua base de dados MySQL';
$hesklang['err_dbuser']='Por favor, digite o Nome de utilizador da sua base de dados MySQL';
$hesklang['err_dbpass']='Por favor, digite a Senha da sua base de dados MySQL';
$hesklang['err_dbconn']='Não foi possível conectar ao base de dados MySQL usando informações fornecidas!';
$hesklang['err_dbsele']='Não foi possível conectar à base de dados MySQL, por favor, verifique o NOME da base de dados';
$hesklang['err_custname']='Por favor, digite o nome do campo opcional selecionado';
$hesklang['err_openset']='Não foi possível abrir o ficheiro <b>hesk_settings.inc.php</b> para gravação. Por favor, CHMOD este ficheiro para 666 (rw-rw-rw-)';
$hesklang['set_saved']='Definições gravadas';
$hesklang['set_were_saved']='As suas definições foram gravadas com sucesso';
$hesklang['sec_img']='Imagem de segurança';
$hesklang['sec_miss']='Por favor, digite o número de segurança';
$hesklang['sec_wrng']='Número de segurança inválido';
$hesklang['submit_problems']='Por favor, volte e corrija os seguintes problemas';
$hesklang['cat_order']='Ordem de categoria';
$hesklang['reply_order']='Ordem de mensagem modelo';
$hesklang['move_up']='Mover para cima';
$hesklang['move_dn']='Mover para baixo';
$hesklang['cat_move_id']='ID de categoria faltando';
$hesklang['reply_move_id']='ID de mensagem modelo faltando';
$hesklang['forgot_tid']='Esqueceu ou quer receber todos os IDs de rastreamento dos tickets?';
$hesklang['tid_send']='Envie-me o ID rastreador';
$hesklang['tid_not_found']='Nenhum ticket com seu endereço do e-mail foi encontrado';
$hesklang['tid_sent']='ID rastreador enviado';
$hesklang['tid_sent2']='Um e-mail com os detalhes sobre seu ticket foi enviado para o seu endereço';
$hesklang['check_spambox']='Certifique-se de que o e-mail não esteja na sua caixa de SPAM ou Lixo!';
$hesklang['reply_not_found']='Mensagem modelo não encontrada';
$hesklang['exists']='Existe';
$hesklang['no_exists']='Não existe';
$hesklang['writable']='Gravável';
$hesklang['not_writable']='Não gravável';
$hesklang['disabled']='desabilitado';
$hesklang['e_settings']='Você não poderá gravar as definições ao menos que este ficheiro seja gravável pelo script. Por favor, leia o README para mais informações!';
$hesklang['e_attdir']='Você não poderá anexar arquivos ao menos que este exista e seja gravável pelo script. Por favor, leia o README para mais informações!';
$hesklang['e_save_settings']='Impossível gravar seus ajustes porque o arquivo <b>hesk_settings.inc.php</b> não está gravável pelo script.';
$hesklang['e_attach']='Desabilitado porque seu diretório de <b>anexos</b> não está gravável pelo script.';
$hesklang['go']='Ir';

// Added in version 2.0
$hesklang['v']='Versão do HESK';
$hesklang['check_status']='Verificando status';
$hesklang['sub_support']='Enviar um ticket';
$hesklang['open_ticket']='Enviar um novo pedido de suporte';
$hesklang['view_existing']='Visualizar ticket existente';
$hesklang['vet']='Visualizar tickets que realizou anteriormente';
$hesklang['enter_user']='Por favor, digite seu nome de utilizador';
$hesklang['remember_user']='Relembrar meu nome de utilizador';
$hesklang['wrong_user']='Nome de utilizador Inválido';
$hesklang['no_permission']='Você não tem permissão para executar esta tarefa, por favor, faça login com um utilizador com este acesso.';
$hesklang['tickets_on_pages']='Número de tickets: %d Número de páginas: %d'; // First %d is replaced with number of tickets, second %d with number of pages
$hesklang['jump_page']='Ir para página:';
$hesklang['no_tickets_open']='Ticket sem solução não encontrado';
$hesklang['no_tickets_crit']='Ticket não encontrado com os critérios informados';
$hesklang['confirm_execute']='Tem certeza que deseja continuar?';
$hesklang['legend']='Legenda';
$hesklang['main_page']='Início';
$hesklang['menu_users']='Utilizadores';
$hesklang['menu_cat']='Categorias';
$hesklang['menu_profile']='Perfil';
$hesklang['menu_kb']='Base de conhecimento'; // Admin MENU item
$hesklang['kb_text']='Base de conhecimento'; // Item visible to customers
$hesklang['viewkb']='Visualizar conteúdo da base de conhecimento';
$hesklang['kb']='Gerir base de conhecimento';
$hesklang['kb_intro']='Base de conhecimento é uma coleção de respostas para as questões mais frequentes (FAQ) e também de artigos que provém recursos de uma auto ajuda para os clientes. Uma base de conhecimento bem elaborada pode reduzir drasticamente o número de tickets de suporte recebidos e registrados no HESK, economizando muito tempo. Você pode organizar os artigos em categorias e sub categorias.'; // Description in ADMIN panel
$hesklang['kb_is']='Base de conhecimento é uma coleção de respostas para as questões mais frequentes (FAQ) e também de artigos que provém recursos de auto ajuda para os utilizadores. Você pode ler os artigos e também pesquisá-los.'; // Description for CUSTOMERS
$hesklang['new_kb_art']='Novo artigo da base de conhecimento';
$hesklang['kb_cat']='Categoria';
$hesklang['kb_subject']='Assunto';
$hesklang['kb_content']='Conteúdo';
$hesklang['kb_type']='Tipo';
$hesklang['kb_published']='Publicado';
$hesklang['kb_published2']='O artigo está visível para todos na base de conhecimento.';
$hesklang['kb_private']='Privado';
$hesklang['kb_private2']='Artigos privados só podem ser lidos pela equipe de suporte.';
$hesklang['kb_draft']='Rascunho';
$hesklang['kb_draft2']='O artigo está gravado, mas ainda não foi publicado. Este só pode ser visto pela equipe de suporte<br /> que tem permissão para Gerir os artigos da base de conhecimento.';
$hesklang['kb_links']='<i><span class="notice"><b>Atenção!</b></span><br />Digite um codigo válido sem tags &lt;head&gt; e &lt;body&gt; , apenas o conteúdo!</i>';
$hesklang['kb_ehtml']='Este é um código HTML (Eu vou digitar um código (x)HTML válido)';
$hesklang['kb_dhtml']='Este é um texto sem formatação (links ainda serão clicáveis)';
$hesklang['kb_save']='Gravar artigo';
$hesklang['kb_e_subj']='Digite o assunto do artigo!';
$hesklang['kb_e_cont']='Digite o conteúdo do artigo!';
$hesklang['kb_art_added']='Artigo adicionado';
$hesklang['your_kb_added']='Um novo artigo de base de conhecimento foi adicionado com sucesso';
$hesklang['kb_art_deleted']='Artigo apagado';
$hesklang['your_kb_deleted']='Artigo da base de conhecimento selecionado foi apagado com sucesso';
$hesklang['kb_art_mod']='Artigo modificado';
$hesklang['your_kb_mod']='Suas modificações do artigo selecionado foram salvas com sucesso';
$hesklang['kb_cat_new']='Nova sub categoria da base de conhecimento';
$hesklang['kb_cat_parent']='Categoria pai';
$hesklang['kb_cat_sub']='Subcategorias';
$hesklang['kb_cat_title']='Título da categoria';
$hesklang['kb_cat_published']='A categoria está viísivel para todos na base de conhecimento.';
$hesklang['kb_cat_private']='A categoria pode apenas ser vista pela equipe de suporte.';
$hesklang['kb_cat_add']='Adicionar categoria';
$hesklang['kb_cat_e_title']='Digitar título da categoria!';
$hesklang['kb_cat_added']='Categoria adicionada';
$hesklang['kb_cat_added2']='Uma nova categoria foi adicionada com sucesso a base de conhecimento';
$hesklang['kb_cat_man']='Gerir categorias da base de conhecimento';
$hesklang['kb_cat_edit']='Editar detalhes da categoria';
$hesklang['kb_cat_inv']='Categoria inválida';
$hesklang['kb_cat_art']='Artigos nesta categoria';
$hesklang['kb_p_art']='+ Artigo';
$hesklang['kb_p_art2']='adicionar um novo artigo a esta categoria.';
$hesklang['kb_add_art']='Adicionar artigo';
$hesklang['kb_p_cat']='+ Categoria';
$hesklang['kb_p_cat2']='criar uma nova sub categoria dentro da categoria selecionada.';
$hesklang['kb_add_cat']='Adicionar categoria';
$hesklang['kb_p_man']='Gerir';
$hesklang['kb_p_man2']='gerir categoria selecionada (editar, apagar, gerir artigos).';
$hesklang['kb_main']='A categoria principal da base de conhecimento não pode ser apagada ou movida.';
$hesklang['kb_no_art']='Não há artigos nesta categoria.';
$hesklang['author']='Autor';
$hesklang['views']='Visualizações';
$hesklang['delete']='Apagar';
$hesklang['rating']='Classificação';
$hesklang['votes']='Votos';
$hesklang['kb_rated']='Classificações de artigo %s/5.0';
$hesklang['kb_not_rated']='Artigo ainda não classificado';
$hesklang['del_art']='Você tem certeza de que deseja apagar o artigo selecionado?';
$hesklang['kb_art_id']='ID do artigo inválido ou perdido!';
$hesklang['kb_art_edit']='Editar artigo';
$hesklang['revhist']='Histórico de Revisão';
$hesklang['revision1']='<li class="smaller">%s | enviado por %s</li>'; // %s = date, user making change
$hesklang['revision2']='<li class="smaller">%s | modificado por %s</li>'; // %s = date, user making change
$hesklang['kb_order']='Ordem';
$hesklang['kb_delcat']='Tem certeza que deseja apagar esta categoria?';
$hesklang['kb_cat_mod']='Categoria modificada';
$hesklang['your_cat_mod']='Suas mudanças para a categoria selecionada foram salvas com sucesso';
$hesklang['kb_cat_del']='Categoria da base de conhecimento apagada';
$hesklang['kb_cat_dlt']='A categoria da base de conhecimento selecionada foi apagada.';
$hesklang['allowed_cat']='Categorias';
$hesklang['allow_feat']='Benefícios';
$hesklang['can_view_tickets']='Visualizar tickets';
$hesklang['can_reply_tickets']='Responder aos tickets';
$hesklang['can_assign_tickets']='Assinar tickets';
$hesklang['can_del_tickets']='Apagar tickets';
$hesklang['can_edit_tickets']='Editar respostas de ticket';
$hesklang['can_change_cat']='Mudar Categoria do ticket';
$hesklang['can_man_kb']='Gerir base de conhecimento';
$hesklang['can_man_users']='Gerir utilizadores';
$hesklang['can_man_cat']='Gerir Categorias';
$hesklang['can_man_canned']='Gerir respostas modelo';
$hesklang['can_man_settings']='Gerir definições do Help Desk';
$hesklang['can_del_notes']='Apagar qualquer nota de ticket';
$hesklang['dan']='utilizadores podem apagar suas próprias notas dos tickets, selecione apenas se deseja permitir que utilizadores apaguem também, notas de outros utilizadores.';
$hesklang['in_all_cat']='apenas nas categorias permitidas';
$hesklang['admin_can']='(acesso a todos benefícios e categorias)';
$hesklang['staff_can']='(você pode limitar benefícios e categorias)';
$hesklang['asign_one_feat']='Por favor, atribua pelo menos um benefício a este utilizador!';
$hesklang['na_view_tickets']='Você não está autorizado a visualizar estes tickets';
$hesklang['support_notice']='Sinto Muito, esta seção só poderá ser escondida quando você comprar uma licença do HESK!';
$hesklang['rart']='Este artigo ajudou?';
$hesklang['r']='Esta resposta ajudou?';
$hesklang['tyr']='Obrigado pela ajuda';
$hesklang['cw']='Fechar janela';
$hesklang['cw2']='Fechar janela e enviar ticket';
$hesklang['rh']='Classificado como <i>ofereceu ajuda</i>';
$hesklang['rnh']='Classificado como <i>não ofereceu ajuda</i>';
$hesklang['ar']='Já classificado';
$hesklang['rated']='utilizador classificou %s/5.0 (%s votes)';
$hesklang['not_rated']='Ainda não foi classificado';
$hesklang['rdis']='Clasificação foi desabilitada';
$hesklang['kbdis']='Base de conhecimento está desabilitada';
$hesklang['kbpart']='Sinto muito, mas você não tem permissão para acessar este artigo';
$hesklang['popart']='Artigos TOP da base de conhecimento:';
$hesklang['latart']='Últimos artigos publicados na base de conhecimento:';
$hesklang['m']='Mais tópicos';
$hesklang['ac']='Artigos nesta categoria:';
$hesklang['noa']='Ainda sem artigos';
$hesklang['noac']='Ainda sem artigos nesta categoria';
$hesklang['dta']='Data de publicação';
$hesklang['ad']='Detalhes do artigo';
$hesklang['aid']='ID do Artigo';
$hesklang['as']='Solução';
$hesklang['search']='Busca';
$hesklang['sr']='Resultados da busca';
$hesklang['nosr']='Nenhum artigo foi encontrado. Tente navegar na base de conhecimento ou nos envie um novo ticket de suporte.';
$hesklang['rv']='Resetar visualizações';
$hesklang['rr']='Resetar votos (classificações)';
$hesklang['opt']='Opções';
$hesklang['delcat']='Apagar categoria';
$hesklang['move1']='Mover artigo para categoria pai';
$hesklang['move2']='Apagar artigo nesta categoria';
$hesklang['sc']='Sugerimos os seguintes artigos';
$hesklang['not']='Tickets'; // Number of all tickets in category
$hesklang['graph']='Gráfico';
$hesklang['lu']='Listar Nome de utilizadores';
$hesklang['aclose']='Fechar tickets automaticamente';
$hesklang['aclose2']='dias depois da última resposta da equipe';
$hesklang['s_ucrt']='Reabrir tickets';
$hesklang['urate']='Responder classificações';
$hesklang['hesk_url']='URL do Help desk';
$hesklang['hesk_title']='Título do Help desk';
$hesklang['cid']='Caso do ID rastreador';
$hesklang['tfor']='Formato da Hora';
$hesklang['prefix']='Prefixo da tabela';
$hesklang['s_ekb']='Activar Base de Conhecimento';
$hesklang['s_kbs']='Habilitar busca na BC';
$hesklang['s_kbr']='Habilitar classificação na BC';
$hesklang['s_maxsr']='Máximo de resultados na busca';
$hesklang['s_suggest']='Sugestão de artigos na BC';
$hesklang['s_spop']='Mostrar artigos populares';
$hesklang['s_slat']='Mostrar últimos artigos';
$hesklang['s_onin']='na página do <a href="../" target="_blank">índice do help desk</a>';
$hesklang['s_onkb']='na página do <a href="../knowledgebase.php" target="_blank">índice da base de conhecimento</a>';
$hesklang['s_scol']='Categorias na linha';
$hesklang['s_ptxt']='Tamanho do preview do artigo';
$hesklang['s_psubart']='Subcategoria de artigos';
$hesklang['enable']='Habilitado';
$hesklang['s_type']='Tipo';
$hesklang['custom_r']='Requerido';
$hesklang['custom_place']='Localização';
$hesklang['custom_use']='Campos do utilizador';
$hesklang['stf']='Text field';
$hesklang['stb']='Text área';
$hesklang['srb']='Radio button';
$hesklang['ssb']='Select box';
$hesklang['db']='base de dados';
$hesklang['hd']='Ajustes do Help desk';
$hesklang['gs']='Ajustes Gerais';
$hesklang['cwin']='Fechar janela';
$hesklang['defw']='Valor padrão';
$hesklang['ok']='OK';
$hesklang['ns']='Estas são as opções disponíveis para estes campos do utilizador. Para salvar as alterações clique em <b>OK</b> e no botão <b>Salvar mudanças</b> na página de ajustes do administrador!';
$hesklang['rows']='Linhas (altura)';
$hesklang['cols']='Colunas (largura)';
$hesklang['opt2']='Opções para este radio button, entre com uma opção por linha (cada linha criará um novo valor de radio button para escolher). Você precisa digitar ao menos duas opções!';
$hesklang['opt3']='Opções para esta select box, digite uma opção por linha (cada linha será uma opção delecionável pelo cliente). Você precisa digitar ao menos duas opções!';
$hesklang['atl2']='Você precisa digitar ao menos duas opções! (uma por linha)!';
$hesklang['notes']='Notas';
$hesklang['addnote']='+ Adicionar nota';
$hesklang['noteby']='Nota de';
$hesklang['delnote']='Apagar nota';
$hesklang['noteerr']='Nota já apagada ou parâmetros errados';
$hesklang['s']='Enviar';
$hesklang['nhid']='Notas não são mostradas aos clientes!';
$hesklang['delt']='Eliminar este post';
$hesklang['edtt']='Editar postagem';
$hesklang['edt1']='Postagem modificada';
$hesklang['edt2']='Alterações ao post selecionado foi gravada';
$hesklang['dele']='Apagar este ticket';
$hesklang['repd']='Post Eliminado';
$hesklang['repl']='Post selecionado foi eliminado';
$hesklang['tickets_found']='Resultados da busca';
$hesklang['al']='Link de administrador';
$hesklang['ap']='Ir para o painel de administrador';
$hesklang['dap']='Exibir um link para o painel de administrador na <a href="../" target="_blank">Página de Entrada</a>';
$hesklang['q_miss']='Por favor, responda a pergunta Anti-SPAM';
$hesklang['use_q']='Usar pergunta anti-SPAM';
$hesklang['q_q']='-&gt; Pergunta (Código HTML é <font class="success">permitido</font>)';
$hesklang['q_a']='-&gt; Resposta';
$hesklang['err_qask']='Digite uma pergunta anti-SPAM';
$hesklang['err_qans']='Digite uma resposta a pergunta anti-SPAM';
$hesklang['genq']='Gerar pergunta aleatória';

// Added in version 2.1
$hesklang['amo']='Adicionar mais';
$hesklang['delatt']='Apagar anexos selecionados?';
$hesklang['kb_att_rem']='Anexos selecionados foram apagados';
$hesklang['inv_att_id']='ID de anexo inválido!';
$hesklang['scb']='Checkbox';
$hesklang['opt4']='Opções para este checkbox, digite uma opção por linha. Cada linha será uma escolha diferente feita pelo seu cliente que poderá fazer múltiplas seleções. Você precisa digitar ao menos duas opções!';
$hesklang['autologin']='Permanecer conectado a cada visita';
$hesklang['just_user']='Apenas lembrar o meu Username';
$hesklang['nothx']='Não, obrigado';
$hesklang['pinfo']='Informação do perfil';
$hesklang['sig']='Assinatura';
$hesklang['pref']='Preferências';
$hesklang['aftrep']='Depois de responder um ticket';
$hesklang['showtic']='Mostrar o ticket que acabei de enviar';
$hesklang['gomain']='Retornar a página principal do administrador';
$hesklang['shownext']='Abrir próximo ticket que precisa de resposta (se nenhum, ir para página principal do administrador)';
$hesklang['rssn']='Mostrar próximo ticket que precisa de sua atenção';
$hesklang['mrep']='Substituir mensagem atual';
$hesklang['madd']='Adicionar ao fim';
$hesklang['priv']='Categorias privadas e artigos visualizáveis a equipe são marcados com um *';
$hesklang['inve']='arquivo de e-mail inválido';
$hesklang['emfm']='Missing email file';
$hesklang['hesk_lang']='Idioma padrão';
$hesklang['s_mlang']='Múltiplos idiomas';
$hesklang['s_mlange']='Se habilitado, os seus utilizadores poderão aceder ao help desk em qualquer idioma instalado. Habilite apenas se você tem suporte em diversos idiomas!';
$hesklang['s_inl']='Testar pasta de idiomas';
$hesklang['s_inle']='Testando a pasta do idioma para os idiomas válidos. Somente os idiomas que passam todos os testes estão instalados corretamente.';
$hesklang['ta']='Procurando novamente';
$hesklang['alo']='Permitir entrada automática';
$hesklang['chol']='Idioma preferido';
$hesklang['mmdl']='Fazer este meu idioma preferido';
$hesklang['warn']='ATENÇÃO';
$hesklang['dmod']='Modo debug está habilitado. Certifique-se de desligar o modo debug assim que o HESK estiver instalado e funcionando adequadamente.';
$hesklang['kb_spar']='Categoria não pode ser sua própria categoria pai!';
$hesklang['mysql_root']='Sua senha do MySQL está vazia, tem certeza de que deseja entrar com o utilizador root? Este é um risco significante!';
$hesklang['chg']='Mudar';
$hesklang['chpri']='Prioridade mudada';
$hesklang['chpri2']='Prioridade do ticket foi mudada para %s';
$hesklang['selcan']='Selecione a mensagem modelo que deseja editar';
$hesklang['q_wrng']='Resposta anti-SPAM digitada está errada';
$hesklang['cndupl']='Você já tem uma categoria com este nome. Selecione um nome único para cada categoria.';
$hesklang['wsel']='Selecione o campo que deseja procurar';

// Added in version 2.2
$hesklang['eto']='Requisição inválida';
$hesklang['id']='ID';
$hesklang['geco']='Gerar Link Direto';
$hesklang['genl']='Link Direto da Categoria';
$hesklang['genl2']='Use este link para pre-selecionar a categoria no formulário de &quot;Envio de Ticket&quot.';
$hesklang['ask']='Busca:';
$hesklang['exa']='Exemplos';
$hesklang['small']='Caixa pequena';
$hesklang['large']='Caixa larga';
$hesklang['cpri']='Prioridade do Cliente';
$hesklang['owner']='Atendente';
$hesklang['unas']='Não Associado';
$hesklang['assi']='Atribuir';
$hesklang['asst']='Atribuir a';
$hesklang['asst2']='Atribuído ticket a';
$hesklang['asss']='Atribuir a mim';
$hesklang['asss2']='Atribuir este ticket a mim';
$hesklang['can_assign_self']='Pode atribuir tickets a si mesmo';
$hesklang['can_assign_others']='Pode atribuir tickets a outros';
$hesklang['can_run_reports']='pode executar relatórios (próprio)';
$hesklang['can_view_ass_others']='Pode ver tickets atribuídos a outros';
$hesklang['unoa']='O utilizador selecionado não tem acesso a esta categoria';
$hesklang['tasi']='Atendente Atribuído';
$hesklang['tasy']='Esse ticket foi atribuído a você';
$hesklang['taso']='Esse ticket foi atribuído ao utilizador selecionado';
$hesklang['tasy2']='Atribuído a você';
$hesklang['taso2']='Atribuído a outro da equipe';
$hesklang['nose']='Nenhum atendente selecionado';
$hesklang['onasc']='Este atendente não tem acesso a categoria selecionada.';
$hesklang['tunasi']='Ticket Não Atribuído';
$hesklang['tunasi2']='Ticket está sem atendente e pronto para ser atribuído novamente';
$hesklang['note']='Nota';
$hesklang['success']='Sucesso';
$hesklang['nyt']='O ticket está atribuído a';
$hesklang['noch']='Nenhum mudança foi feita';
$hesklang['orch']='A ordem da listagem foi modificada';
$hesklang['rfm']='Informação requerida faltando:';
$hesklang['repl0']='Permissão insuficiente para realizar esta tarefa';
$hesklang['repl1']='Esta postagem não existe';
$hesklang['reports']='Relatórios';
$hesklang['reports_intro']='A secção de relatórios permite executar relatórios e ver estatísticas dos tickets para um determinado período.';
$hesklang['refi']='Limpar os dados do formulário';
$hesklang['dich']='Descartar Mudanças';
$hesklang['dire']='Mostrar Relatório';
$hesklang['m1']='Janeiro';
$hesklang['m2']='Fevereiro';
$hesklang['m3']='Março';
$hesklang['m4']='Abril';
$hesklang['m5']='Maio';
$hesklang['m6']='Junho';
$hesklang['m7']='Julho';
$hesklang['m8']='Agosto';
$hesklang['m9']='Setembro';
$hesklang['m10']='Outubro';
$hesklang['m11']='Novembro';
$hesklang['m12']='Dezembro';
$hesklang['d1']='Segunda';
$hesklang['d2']='Terça';
$hesklang['d3']='Quarta';
$hesklang['d4']='Quinta';
$hesklang['d5']='Sexta';
$hesklang['d6']='Sábado';
$hesklang['d0']='Domingo';
$hesklang['mo']='Se';
$hesklang['tu']='Te';
$hesklang['we']='Qa';
$hesklang['th']='Qi';
$hesklang['fr']='Se';
$hesklang['sa']='Sa';
$hesklang['su']='Do';
$hesklang['from']='De';
$hesklang['cinv']='Data Inválida';
$hesklang['cinv2']='Formato aceito de data é dd-mm-yyyy';
$hesklang['cinm']='Valor inválido para o mês';
$hesklang['cinm2']='Intervalo permitido é';
$hesklang['cind']='Valor de dia do mês inválido';
$hesklang['cind2']='Intervalo permitido para o mês selecionado é';
$hesklang['month']='Mês';
$hesklang['ocal']='Abrir Calendário';
$hesklang['ca01']='Ano Anterior';
$hesklang['ca02']='Mes Anterior';
$hesklang['ca03']='Próximo Mês';
$hesklang['ca04']='Próximo Ano';
$hesklang['ca05']='Fechar Calendário';
$hesklang['cdr']='Escolha o intervalo de data:';
$hesklang['crt']='Tipo de relatório';
$hesklang['r1']='Hoje';
$hesklang['r2']='Ontem';
$hesklang['r3']='Este mês';
$hesklang['r4']='Último mês';
$hesklang['r5']='Últimos 30 dias';
$hesklang['r6']='Esta semana (Seg-Dom)';
$hesklang['r7']='Última semana (Seg-Dom)';
$hesklang['r8']='Esta semana de trabalho (Seg-Sex)';
$hesklang['r9']='Última semana de trabalho (Seg-Sex)';
$hesklang['r10']='Este ano';
$hesklang['r11']='Último ano';
$hesklang['r12']='Todo período';
$hesklang['datetofrom']='&quot;Data de&quot; não pode ser maior que &quot;Data até&quot;. As data foram trocadas.';
$hesklang['t1']='Tickets por dia';
$hesklang['t2']='Tickets por mês';
$hesklang['t3']='Tickets por utilizador';
$hesklang['t4']='Tickets por categoria';
$hesklang['ticass']='Tickets Atribuídos';
$hesklang['ticall']='Tickets Respondidos';
$hesklang['totals']='Totais';
$hesklang['all']='Todos';
$hesklang['atik']='Novos tickets';
$hesklang['kbca']='Você já tem uma categoria da base de conhecimento com este nome.';
$hesklang['menu_msg']='Mail';
$hesklang['menu_can']='Modelo';
$hesklang['m_from']='De:'; // Mail "from" address
$hesklang['m_to']='Para:'; // Mail "to" address
$hesklang['m_sub']='Assunto:'; // Mail subject
$hesklang['m_re']='Re:'; // Mail reply subject prefix, like "Re: Original subject"
$hesklang['m_fwd']='Fwd:'; // Mail forward subject prefix, like "Fwd: Original subject"
$hesklang['m_h']='Mensagens privadas';
$hesklang['m_intro']='Utilize mensagens privadas para comunicar com outros membro da equipa.';
$hesklang['e_udel']='(utilizador eliminado)';
$hesklang['new_mail']='Nova mensagem privada';
$hesklang['m_send']='Enviar mensagem';
$hesklang['m_rec']='Selecione o destinatário da mensagem';
$hesklang['m_inr']='Destinatário da mensagem inválido';
$hesklang['m_esu']='Entre com o assunto da mensagem privada';
$hesklang['m_pms']='Sua mensagem privada foi enviada';
$hesklang['inbox']='INBOX';
$hesklang['outbox']='OUTBOX';
$hesklang['m_new']='NOVA MENSAGEM';
$hesklang['pg']='Mostrar Página';
$hesklang['npm']='Sem mensagens privadas nesta pasta.';
$hesklang['m_ena']='Você não tem permissão para ler esta mensagem.';
$hesklang['mau']='Marcar como não lida';
$hesklang['mo1']='Marcar mensagens selecionadas como lidas';
$hesklang['mo2']='Marcar mensagens selecionadas como não lidas';
$hesklang['mo3']='Deletar mensagens selecionadas';
$hesklang['delm']='Eliminar estar mensagem';
$hesklang['e_tid']='Erro ao gerar um ticked ID único, por favor, tente enviar o formulário novamente mais tarde.';
$hesklang['smmr']='A mensagem selecionada foi marcado como lida';
$hesklang['smmu']='A mensagem selecionada foi marcado como não lida';
$hesklang['smdl']='As mensagens selecionadas foram deletadas';
$hesklang['show']='Mostrar';
$hesklang['s_my']='Atribuídos a mim';
$hesklang['s_ot']='Atribuídos a outros';
$hesklang['s_un']='Tickets não atribuídos';
$hesklang['s_for']='Pesquisar por';
$hesklang['s_in']='Pesquisar em';
$hesklang['s_incl']='Pesquisar incluindo';
$hesklang['find_ticket_by']='Encontrar um ticket';
$hesklang['e_nose']='Sem status de atribuição selecionado, mostrando todos os tickets.';
$hesklang['fsq']='Entre com a sua consulta';
$hesklang['topen']='Aberto';
$hesklang['nms']='Nenhuma mensagem selecionada, nada foi mudado';
$hesklang['tlo']='Trancar ticket';
$hesklang['tul']='Destrancar ticket';
$hesklang['loc']='Trancado';
$hesklang['isloc']='Os clientes não podem responder ou reabrir um ticket trancado. Quando o ticket é trancado, também é marcado como resolvido.';
$hesklang['tlock']='Ticket foi trancado';
$hesklang['tunlock']='Ticket foi destrancado';
$hesklang['tislock']='Esse ticket foi trancado, o cliente não terá como postar uma resposta.';
$hesklang['tislock2']='Esse ticket foi trancado, você não pode postar uma resposta.';
$hesklang['nsfo']='Nenhum artigo relevante foi encontrado.';
$hesklang['thist1']='<li class="smaller"> %s | movido para a categoria %s por %s </li>'; // %s = date, new category, user making change
$hesklang['thist2']='<li class="smaller"> %s | atribuída a %s por %s </li>'; // %s = date, assigned user, user making change
$hesklang['thist3']='<li class="smaller"> %s | fechado por %s </li>'; // %s = date, user making change
$hesklang['thist4']='<li class="smaller"> %s | aberto por %s </li>'; // %s = date, user making change
$hesklang['thist5']='<li class="smaller"> %s | bloqueado por %s </li>'; // %s = date, user making change
$hesklang['thist6']='<li class="smaller"> %s | desbloqueado por %s </li>'; // %s = date, user making change
$hesklang['thist7']='<li class="smaller"> %s | ticket criado por %s </li>'; // %s = date, user making change
$hesklang['elocked']='Esse ticket foi trancado ou eliminado.';
$hesklang['nti2']='Insira um novo ticket';
$hesklang['nti3']='Use este formulário para criar um novo ticket em nome de um cliente. Insira as informações do <i>cliente</i> no formulário! O ticket será criado como se o cliente o tivesse submetido.';
$hesklang['addop']='Opções';
$hesklang['seno']='Enviar notificação por e-mail para o cliente';
$hesklang['otas']='Mostrar o ticket após o envio';
$hesklang['notn']='Notificações';
$hesklang['nomw']='O help desk irá mandar um e-mail de notificação quando:';
$hesklang['nwts']='Um novo ticket é enviado com atendente:';
$hesklang['ncrt']='Cliente responde ao ticket com atendente:';
$hesklang['ntam']='Um ticket foi atribuído a mim';
$hesklang['npms']='Uma mensagem privada foi enviada para mim';
$hesklang['support_remove']='Muito esforço, tempo e dinheiro foram gastos no desenvolvimento do HESK. Ajude o HESK, compre uma licença, assim o link <i>Powered by Help desk software Hesk</i> será removido do seu Help Desk';
$hesklang['ycvtao']='Você não tem permissão para ver tickets atribuídos a outros';
$hesklang['password_not_valid']='Password deve ter pelo menos 5 caracteres';
$hesklang['lkbs']='Carregando sugestões da base de conhecimento...';
$hesklang['auto']='(automaticamente)';

// Added in version 2.3
$hesklang['unknown']='Unknown';
$hesklang['pcer']='Por favor corrija os seguintes erros:';
$hesklang['seqid']='Número do ticket';
$hesklang['close_action']='Marcar como resolvido'; // Close ACTION
$hesklang['archived']='Arquivado';
$hesklang['archived2']='Ticket arquivado';
$hesklang['add_archive']='Arquivar este ticket';
$hesklang['add_archive_quick']='Arquivar tickets selecionados';
$hesklang['remove_archive']='Desarquivar este ticket';
$hesklang['remove_archive_quick']='Desarquivar tickets selecionados';
$hesklang['added_archive']='Adicionar ao arquivo';
$hesklang['removed_archive']='Remover do arquivo';
$hesklang['added2archive']='Ticket foi arquivado';
$hesklang['removedfromarchive']='Ticket foi desarquivado';
$hesklang['num_tickets_tag']='<b>%d</b> tickets foram arquivados';
$hesklang['num_tickets_untag']='<b>%d</b> tickets foram desarquivados';
$hesklang['can_add_archive']='Pode arquivar tickets';
$hesklang['disp_only_archived']='Somente tickets arquivados';
$hesklang['search_only_archived']='Somente tickets arquivados';
$hesklang['critical']=' * Crítico * ';
$hesklang['thist8']='<li class="smaller"> %s | prioridade alterada para %s por %s </li>'; // %s = date,new priority, user making change
$hesklang['thist9']='<li class="smaller"> %s | status alterado para %s por %s </li>'; // %s = date, new status, user making change
$hesklang['thist10']='<li class="smaller"> %s | atribuída automaticamente para %s </li>'; // %s = date, user making change
$hesklang['thist11']='<li class="smaller"> %s | apresentado pela tubulação e-mail </li>'; // %s = date, user making change
// START abbreviatons used in "last updated" column
$hesklang['abbr']['year']='a&ntilde;o';
$hesklang['abbr']['month']='mes';
$hesklang['abbr']['week']='sem';
$hesklang['abbr']['day']='d';
$hesklang['abbr']['hour']='h';
$hesklang['abbr']['minute']='m';
$hesklang['abbr']['second']='s';
// END abberviations
$hesklang['cnsm']='Não foi possível enviar a mensagem para:';
$hesklang['yhbb']='Você foi bloqueado pelo sistema por %s minutos devido a vários erros de login.';
$hesklang['pwdst']='Força da senha';
$hesklang['tid_mail']='Não se preocupe! Insira o seu <b>endereço de email</b>, e será enviado o seu ID de rastreamento de imediato:';
$hesklang['rem_email']='Lembrar-me do endereço de email';
$hesklang['eytid']='Entre com seu ID de rastreamento.';
$hesklang['enmdb']='O endereço de email inserido não corresponde com o existente no base de dados para este ID de ticket.';
$hesklang['confemail']='Confirmar email';
$hesklang['confemail2']='Por favor confirme seu endereço de email';
$hesklang['confemaile']='Os dois endereços de email não são idênticos';
$hesklang['taso3']='Atribuido a:';
$hesklang['sec_enter']='Digite o número que você vê na imagem abaixo.';
$hesklang['reload']='Atualizar imagem';
$hesklang['verify_q']='Prevenção SPAM:'; // For anti-spam question
$hesklang['verify_i']='Prevenção SPAM:'; // For anti-spam image (captcha)
$hesklang['admin_login']='Login de Administrador';
$hesklang['vrfy']='Teste aprovado';
$hesklang['last_update']='Atualizado';
$hesklang['cot']='Não forçar tickets críticos no topo';
$hesklang['def']='Fazer esta exibição a minha padrão';
$hesklang['gbou']='Estes tickets são <b>Não atribuidos</b>:';
$hesklang['gbom']='Tickets atribuidos para <b>mim</b>:';
$hesklang['gboo']='Tickets atribuidos para <b>%s</b>:';
$hesklang['select']=' - - Click para selecionar - - ';
$hesklang['chngstatus']='Alterar estado para';
$hesklang['perat']='%s de todos os tickets'; // Will change to "23% of all tickets"
$hesklang['viewart']='Ver este artigo';
$hesklang['chdp']='Por favor altere a senha padrão no seu perfil <a href="profile.php">Perfil</a> página!';
$hesklang['chdp2']='Altere a sua senha, você está a usar a senha padrão!';
$hesklang['security']='Segurança';
$hesklang['kb_i_art']='Novo artigo';
$hesklang['kb_i_art2']='Inserir um artigo';
$hesklang['kb_i_cat']='Nova categoria';
$hesklang['kb_i_cat2']='Inserir categoria';
$hesklang['gopr']='Ver base de conhecimento';
$hesklang['kbstruct']='Estrutura da base de conhecimento';
$hesklang['cancel']='Cancelar';
$hesklang['sh']='Esconder mensagem';
$hesklang['goodkb']='Como escrever bons artigos na base de conhecimento?';
$hesklang['catset']='Configurações da categoria';
$hesklang['inpr']='Selecionar nova prioridade';
$hesklang['incat']='Selecionar nova prioridade';
$hesklang['instat']='Selecionar novo estado';
$hesklang['tsst']='Estado do ticket alteradoo para %s';
$hesklang['aass']='Auto-atribuição';
$hesklang['aaon']='Auto-atribuição de tickets habilitado (clique para desabilitar)';
$hesklang['aaoff']='Auto-atribuição de tickets desabilitado (clique para habilitar)';
$hesklang['uaaon']='Auto-atribuição foi habilitado para utilizador selecionado';
$hesklang['uaaoff']='Auto-atribuição foi desabilitado para utilizador selecionado';
$hesklang['taasy']='Este ticket foi auto-atribuido a você';
$hesklang['can_view_unassigned']='Pode ver tickets não atribuidos';
$hesklang['ycovtay']='Você pode ver apenas tickets atribuidos a você';
$hesklang['in_progress']='Em progresso';
$hesklang['on_hold']='Em espera';
$hesklang['import_kb']='Importar este ticket em um artigo na base de conhecimento';
$hesklang['import']='Você está a importar um <i>ticket privado</i> para <i>artigo público</i>.<br /><br />Certifique-se que apaga todas as informações privadas ou sensíveis do título e mensagem do artigo!';
$hesklang['tab_1']='Geral';
$hesklang['tab_2']='Help Desk';
$hesklang['tab_3']='Base de conhecimento';
$hesklang['tab_4']='Campos personalizados';
$hesklang['tab_5']='Misc';
$hesklang['disable']='Desativar';
$hesklang['dat']='Data &amp; Tempo';
$hesklang['lgs']='Linguagem';
$hesklang['onc']='ON - Utilizadores';
$hesklang['ons']='ON - Todos';
$hesklang['viewvtic']='Ver tickets';
$hesklang['reqetv']='Obrigatório email para ver o ticket';
$hesklang['banlim']='Limite de tentativa de login';
$hesklang['banmin']='Tempo banido (minutos)';
$hesklang['subnot']='Enviar notícia';
$hesklang['subnot2']='Mostrar aviso aos utilizadores que enviam tickets';
$hesklang['eseqid']='Sequencia de IDs';
$hesklang['sconfe']='Confirmar email';
$hesklang['saass']='Auto-atribuir tickets';
$hesklang['swyse']='Editor WYSIWYG';
$hesklang['hrts']='Avaliação HESK';
$hesklang['hrts2']='Mostrar link do script de avaliação no painel de administração';
$hesklang['emlpipe']='Email piping';
$hesklang['emlsend2']='Enviar emails usando';
$hesklang['phpmail']='PHP mail()';
$hesklang['smtp']='SMTP Server';
$hesklang['smtph']='SMTP Host';
$hesklang['smtpp']='SMTP Port';
$hesklang['smtpu']='SMTP Username';
$hesklang['smtpw']='SMTP Password';
$hesklang['smtpt']='SMTP Timeout';
$hesklang['other']='Outro';
$hesklang['features']='Características';
$hesklang['can_view_online']='Pode ver membros da equipa online';
$hesklang['online']='Online';
$hesklang['offline']='Offline';
$hesklang['onlinep']='Utilizadores Online'; // For display in footer
$hesklang['sonline']='Utilizadores Online'; // For settings page
$hesklang['sonline2']='Mostrar utilizadores online. Limite (minutos):'; // For settings page
$hesklang['gb']='Por grupo';
$hesklang['dg']='Sem grupo';
$hesklang['err_dpi']='Base de dados %s não contém todas as tabelas HESK com prefixo %s, alterações não foram gravadas.';
$hesklang['err_dpi2']='Tabelas não encontradas:';
$hesklang['sme']='Erro no SMTP';
$hesklang['scl']='Log de conexão SMTP';
$hesklang['dnl']='Download';
$hesklang['dela']='Eliminar este anexo';
$hesklang['pda']='Você quer excluir permanentemente este anexo?';
$hesklang['thist12']='<li class="smaller"> %s | anexo %s removido por %s </li>'; // %s = date, deleted attachment, user making change
$hesklang['mopt']='Mais opções';
$hesklang['lopt']='Menos opções';
$hesklang['meml']='Multiplos emails';
$hesklang['meml2']='Permitir que utilizadores entrem em contato com vários emails.';

// Added in version 2.4
$hesklang['catd']='(categoria eliminada)';
$hesklang['noopen']='Não foram encontrados tickets abertos para esse endereço de email.';
$hesklang['maxopen']='Você chegou ao máximo de tickets abertos (%d de %d). Por favor, espere até que seus tickets atuais estejam resolvidos antes da abertura de novos tickets.';
$hesklang['ntnote']='Alguém postou uma nota a um ticket atribuído para mim';
$hesklang['cat_public']='Esta categoria é PÚBLICA (clique para convertê-la em privada)';
$hesklang['cat_private']='Esta categoria é PRIVADA (clique para convertê-la em pública)';
$hesklang['cat_aa']='Auto-atribuir tickets desta categoria.';
$hesklang['cat_type']='Tornar esta categoria privada (apenas pode ser selecionada por Administradores).';
$hesklang['caaon']='Foi habilitado Auto-atribuir para a categoria selecionada';
$hesklang['caaoff']='Foi desabilitado Auto-atribuir para a categoria selecionada';
$hesklang['cpub']='Tipo de categoria trocado para PÚBLICO';
$hesklang['cpriv']='Tipo de categoria trocado para PRIVADO';
$hesklang['cpric']='Os utilizadores não podem selecionar as categorias privadas, apenas Administradores!';
$hesklang['user_aa']='Auto-atribuir tickets para este utilizador.';
$hesklang['attach_size']='Tamanho máximo do arquivo';
$hesklang['B']='B';
$hesklang['kB']='KB';
$hesklang['MB']='MB';
$hesklang['GB']='GB';
$hesklang['bytes']='bytes';
$hesklang['kilobytes']='kilobytes';
$hesklang['megabytes']='megabytes';
$hesklang['gigabytes']='gigabytes';
$hesklang['smtpssl']='Protocolo SSL';
$hesklang['smtptls']='Protocolo TLS';
$hesklang['oo']='Somente Abertos';
$hesklang['ool']='Listar somente os tickets abertos em &quot;Esquecí ID de ticket&quot; por email';
$hesklang['mop']='Tickets máximos abertos';
$hesklang['rord']='Ordenar Respondidos';
$hesklang['newbot']='Os mais novos no fim';
$hesklang['newtop']='Os mais novos no início';
$hesklang['ford']='Formulário de resposta';
$hesklang['formbot']='Mostrar formulário no fim';
$hesklang['formtop']='Mostrar formulário no início';
$hesklang['mysqlv']='Versão MySQL';
$hesklang['phpv']='Versão PHP';
$hesklang['csrt']='Hora atual do Centro de Ajuda:';
$hesklang['listp']='Listar artigos privados';
$hesklang['listd']='Listar os artigos apagados';
$hesklang['artp']='Artigos privados';
$hesklang['artd']='Artigos apagados';
$hesklang['kb_no_part']='Não há artigos privados na base de conhecimento.';
$hesklang['kb_no_dart']='Não há artigos apagados na base de conhecimento.';
$hesklang['attpri']='Você não tem acesso a este arquivo anexo.';
$hesklang['can_merge_tickets']='Combinar tickets';
$hesklang['mer_selected']='Combinar tickets selecionados';
$hesklang['merged']='Os tickets selecionados foram combinados num único.';
$hesklang['merge_err']='Teve um problema ao combinar os tickets:';
$hesklang['merr1']='Selecione ao menos 2 tickets.';
$hesklang['merr2']='Ticket de destino não encontrado.';
$hesklang['merr3']='Ticket numa categoria que não tem acesso.';
$hesklang['tme']='Ticket %s foi combinado com este ticket (%s).';
$hesklang['tme1']='Ticket %s foi combinado com o ticket %s';
$hesklang['tme2']='Para aceder o ticket %s insira o endereço de email associado.';
$hesklang['eyou']='Utilize a página do perfil para editar a configuração.';
$hesklang['npea']='Você não tem permissão para editar este utilizador.';
$hesklang['duplicate_user']='Este nome de utilizador já existe, escolha um diferente.';
$hesklang['kw']='Senhas';
$hesklang['kw1']='(opcional - separado por um espaço, uma vírgula ou uma nova linha)';
$hesklang['type_not_allowed']='Os arquivos que tem a extesão <b>%s</b> não são aceites (%s)'; // %s changed to extension and file name: files ending with .exe are not accepted (test.exe)
$hesklang['unread']='O cliente ainda não leu esta resposta.';
$hesklang['sticky']='Fazer deste artigo &quot;Permanente&quot;';
$hesklang['stickyon']='Mudar este artigo para &quot;Permanente&quot;';
$hesklang['stickyoff']='Mudar este artigo para &quot;Normal&quot;';
$hesklang['ason']='Artigo marcado como &quot;Permanente&quot;';
$hesklang['asoff']='Artigo marcado como &quot;Normal&quot;';
$hesklang['ts']='Tempo Dedicado';
$hesklang['start']='Iniciar / Parar';
$hesklang['reset']='Reinicia';
$hesklang['save']='Guardar';
$hesklang['hh']='Horas';
$hesklang['mm']='Minutos';
$hesklang['ss']='Segundos';
$hesklang['thist']='Histórico do Ticket';
$hesklang['thist13']='<li class="smaller"> %s | fundiu com ticket %s por %s </li>'; // %s = date, merged ticket ID, user making change
$hesklang['thist14']='<li class="smaller"> %s | tempo de trabalho atualizada para %s por %s </li>'; // %s = date, new time worked, user making change
$hesklang['thist15']='<li class="smaller"> %s | apresentado por %s </li>'; // %s = date, user making change
$hesklang['thist16']='<li class="smaller"> %s | apresentado pelo POP3 buscar </li>';
$hesklang['twu']='Tempo dedicado no ticket foi atualizado.';
$hesklang['autoss']='Início automático do temporizador ao abrir um ticket';
$hesklang['ful']='Limite de anexo de arquivos';
$hesklang['ufl']='Pode anexar arquivos que terminam em:';
$hesklang['nat']='Número máximo de arquivos anexos:';
$hesklang['mfs']='Tamanho máximo do arquivo anexo:';
$hesklang['lps']='Sua preferência de idioma foi salvo';
$hesklang['sav']='Mostrar exibições do artigo';
$hesklang['sad']='Mostrar a data do artigo';
$hesklang['emp']='O PHP não tem suporte MySQL enabled (extensão mysqli obrigatório)';
$hesklang['epd']='[HESK] EMAIL PIPING ESTA DESABILITADO NOS AJUSTES';
$hesklang['pfd']='[HESK] POP3 FETCHING ESTA DESABILITADO NOS AJUSTES';
$hesklang['pem']='[Piped email]'; // Default subject of piped tickets without subject
$hesklang['pde']='[Cliente]'; // Default customer name for piped tickets without name
$hesklang['tab_6']='Email';
$hesklang['pop3']='POP3 Fetching';
$hesklang['pop3h']='POP3 Host';
$hesklang['pop3p']='POP3 Porta';
$hesklang['pop3tls']='Protocolo TLS';
$hesklang['pop3u']='POP3 Nome de utilizador';
$hesklang['pop3w']='POP3 Senha';
$hesklang['pop3e']='POP3 error';
$hesklang['pop3log']='POP3 Conexão de registro';
$hesklang['mysqltest']='Teste de conexão MySQL';
$hesklang['smtptest']='Teste de conexão SMTP';
$hesklang['pop3test']='Teste de conexão POP3';
$hesklang['contest']='Testando conexão, isto pode demorar um pouco...';
$hesklang['conok']='Conexão com êxito!';
$hesklang['conokn']='No entanto, se o seu servidor requer utilizador e senha, o email não será enviado!';
$hesklang['saving']='Gravando alterações, aguarde...';
$hesklang['sns']='as alterações foram gravadas, porém algumas funcionalidades foram desabilitadas por falha nos testes.';
$hesklang['looph']='Max Visitas';
$hesklang['loopt']='Intervalo de tempo';
$hesklang['didum']='Quis dizer %s?'; // %s changes to email; did you mean someone@example.com?
$hesklang['yfix']='Sim, trocar';
$hesklang['nole']='Não, deixar assim';
$hesklang['sconfe2']='Mostrar campo &quot;Confirmar email&quot; no formulário do ticket';
$hesklang['oln']='Nome anterior:';
$hesklang['nen']='Nome novo:';
$hesklang['use_form_below']='<i>Utilize este formulário para enviar uma solicitação de suporte. Os campos obrigatórios estão marcados com</i>';
$hesklang['esf']='Não foi possível enviar notificações por email.';
$hesklang['qrr']='(Resposta citada eliminada)';
$hesklang['remqr']='Cortar resposta citada';
$hesklang['remqr2']='Eliminar a resposta citada dos emails dos clientes';
$hesklang['suge']='Detectar erros de digitação';
$hesklang['epro']='Provedores de Email';
$hesklang['email_noreply']='&quot;De:&quot; email';
$hesklang['email_name']='&quot;De:&quot; nome';
$hesklang['vscl']='Limites de configuração do servidor';
$hesklang['fnuscphp']='Falha no envio dos anexos. Por favor, teste com um anexo menor ou sem anexo.';
$hesklang['redv']='restaurar a exibição padrão';
$hesklang['fatte1']='Os ajustes de arquivos anexos &quot;Quantidade por Mensagem&quot; é maior do que o servidor permite!';
$hesklang['fatte2']='Os ajustes de tamanho máximo do arquivo anexo é superior do que o servidor permite!';
$hesklang['fatte3']='O servidor não permite mensagens com esse tamanho. Tente reduzir o número de arquivos anexos ou o tamanho do arquivo permitido!';
$hesklang['embed']='Arquivos incorporados';
$hesklang['embed2']='Gravar ficheiros incorporados como arquivos anexos';
$hesklang['emrem']='(imagem eliminada)';
$hesklang['hdemo']='(OCULTO NA DEMO)';
$hesklang['ddemo']='Lamentamos, mas esta funcionalidade está desativada em modo DEMO!';
$hesklang['sdemo']='Salvo modificações somente se está desativado o modo DEMO!';
$hesklang['hud']='O HESK está utilizando a versão mais atual!';
$hesklang['hnw']='Atualização disponível';
$hesklang['getup']='Atualizar HESK';
$hesklang['updates']='Atualizações';
$hesklang['updates2']='Verificar automaticamente se há atualizações.';

// Added in version 2.5.0
$hesklang['attdel']='Este ficheiro foi excluído do servidor e não está mais disponível para download';
$hesklang['dsen']='Não foi possível enviar uma notificação de e-mail desta resposta para o cliente';
$hesklang['attrem']='* Alguns ficheiros anexados foram removidos *';
$hesklang['attnum']='Número máximo alcançado: %s'; // %s will show attachment name
$hesklang['attsiz']='Ficheiro muito grande: %s'; // %s will show attachment name
$hesklang['atttyp']='Tipo não permitido: %s'; // %s will show attachment name
$hesklang['adf']='pasta Admin';
$hesklang['atf']='pasta Anexos';
$hesklang['err_adf']='A pasta administrador selecionado (%s) não existe!'; // %s will show folder name
$hesklang['err_atf']='A pasta anexos selecionado (%s) não existe!'; // %s will show folder name
$hesklang['err_atr']='A pasta anexos selecionado (%s) não é gravável!'; // %s will show folder name
$hesklang['fatt']='Ficheiros anexados a esta mensagem:';
$hesklang['wrepo']='Por favor, escreva uma resposta após a re-abertura do ticket.';
$hesklang['ktool']='&raquo; FAQ ferramentas';
$hesklang['uac']='Verify and update category article count';
$hesklang['acv']='count artigo foi verificado';
$hesklang['xyz']='número de artigos público, privado e projecto na categoria.';
$hesklang['reports_tab']='Relatórios'; // Tab title
$hesklang['can_run_reports_full']='pode executar relatórios (todos)';
$hesklang['can_export']='pode exportar tickets';
$hesklang['roo']='<i> (apenas tickets atribuídos a você são incluídos no relatório) </ i>';
$hesklang['shu']='links curtas';
$hesklang['export']='Export Tickets'; // Tab title
$hesklang['export_btn']='tickets de exportação'; // Button title
$hesklang['export_intro']='Esta ferramenta permite exportar os tickets em uma planilha XML que pode ser aberto no Excel.';
$hesklang['stte']='Select tickets para exportar';
$hesklang['dtrg']='Período';
$hesklang['sequentially']='Sequencialmente'; // Order tickets: Sequentially
$hesklang['ede']='Não foi possível criar o diretório de exportação, por favor, crie manualmente uma pasta chamada <b> exportação </ b> dentro da sua pasta de anexos e certificar-se de que é escrito pelo PHP (em Linux CHMOD para 777 - rwxrwxrwx) . ';
$hesklang['eef']='Não foi possível criar o ficheiro de exportação, não tem permissão para escrever dentro do diretório de exportação.';
$hesklang['inite']='exportação Inicializar';
$hesklang['gXML']='ficheiro XML Gerando';
$hesklang['nrow']='Número de linhas exportadas: %d'; // %d will show number of rows exported
$hesklang['cZIP']='Compressing file into a Zip archive';
$hesklang['eZIP']='Error creating Zip archive';
$hesklang['fZIP']='Terminado comprimir o ficheiro';
$hesklang['pmem']='o uso de memória de pico: %.2f Mb'; // %.2f will be replaced with number of Mb used
$hesklang['ch2d']='&raquo; Clique aqui para fazer o download do ficheiro de exportação«';
$hesklang['n2ex']='Não há tickets encontradas de acordo com seus critérios, não há nada para exportar';
$hesklang['sp']='SPAM Prevenção'; // For settings page
$hesklang['sit']='-&gt;Tipo de imagem';
$hesklang['sis']='Simples imagem';
$hesklang['rcpb']='Site key (Public key)';
$hesklang['rcpv']='Secret key (Private key)';
$hesklang['pop3keep']='Mantenha uma cópia';
$hesklang['beta']='(versão de teste)';
$hesklang['maxpost']='Você provavelmente tentou enviar mais dados do que este servidor aceita <br /> <br /> Por favor, tente enviar novamente o formulário com anexos menores ou não.';

// --> Text used by ReCaptcha
$hesklang['recaptcha_error']='resposta Prevenção SPAM incorreta, por favor, tente novamente.';

// Added in version 2.6.0
$hesklang['ticket_closed']='[#%%TRACK_ID%%] Pedido encerrado/resolvido';
$hesklang['ms01']='Jan';
$hesklang['ms02']='Fev';
$hesklang['ms03']='Mar';
$hesklang['ms04']='Abr';
$hesklang['ms05']='Mai';
$hesklang['ms06']='Jun';
$hesklang['ms07']='Jul';
$hesklang['ms08']='Ago';
$hesklang['ms09']='Set';
$hesklang['ms10']='Out';
$hesklang['ms11']='Nov';
$hesklang['ms12']='Dez';
$hesklang['sdf']='Formato data submetido';
$hesklang['lcf']='Actualizar formato data';
$hesklang['lcf0']='Descrição curta';
$hesklang['lcf1']='Data e hora';
$hesklang['lcf2']='estilo HESK';
$hesklang['ticket_tpl']='Modelos de ticket';
$hesklang['can_man_ticket_tpl']='Gerir modelos de ticket'; // Permission title
$hesklang['ticket_tpl_man']='Gerir modelos de ticket'; // Page and link title
$hesklang['ticket_tpl_intro']='Criar e editar modelos de ticket para submeter directamente novos tickets a partir do interface de admin.';
$hesklang['no_ticket_tpl']='Não há modelos de ticket';
$hesklang['ticket_tpl_title']='Título';
$hesklang['delete_tpl']='Tem a certeza que deseja eliminar este modelo??';
$hesklang['new_ticket_tpl']='Adicionar ou Eliminar um modelo de ticket';
$hesklang['ticket_tpl_add']='Criar um novo modelo de ticket';
$hesklang['ticket_tpl_edit']='Editar modelo de ticket seleccionado';
$hesklang['save_ticket_tpl']='Guardar modelo de ticket';
$hesklang['ticket_tpl_saved']='O seu modelo de ticket foi guardado para utilização futura';
$hesklang['ticket_tpl_removed']='O modelo de ticket seleccionado foi removido da base de dados';
$hesklang['ticket_tpl_not_found']='Modelo de ticket não encontrado';
$hesklang['sel_ticket_tpl']='Seleccione o modelo de ticket que deseja editar';
$hesklang['ent_ticket_tpl_title']='Introduza o título do modelo';
$hesklang['ent_ticket_tpl_msg']='Introduza a mensagem do modelo';
$hesklang['ticket_tpl_id']='ID do modelo de ticket não encontrado';
$hesklang['select_ticket_tpl']='Seleccione um modelo de ticket';
$hesklang['list_tickets_cat']='Listar todos os tickets desta categoria';
$hesklang['def_msg']='[Não há mensagens]';
$hesklang['emlreqmsg']='Mensagem necessária';
$hesklang['emlreqmsg2']='Ignorar emails filtrados sem mensagem';
$hesklang['relart']='Artigos relacionados'; // Title of related articles box
$hesklang['s_relart']='Artigos relacionados'; // On settings page
$hesklang['tab_7']='Lista de tickets';
$hesklang['fitl']='Campos da lista de tickets';
$hesklang['submitted']='Submetido';
$hesklang['clickemail']='Vista';
$hesklang['set_pri_to']='Alterar prioridade para:'; // Action below the ticket list
$hesklang['pri_set_to']='Prioridade foi definida para:';
$hesklang['cat_pri']='A categoria prioridade será utilizada quando os clientes não estão autorizados a seleccionar a prioridade e um ticket é enviado a partir da interface do cliente.';
$hesklang['cat_pri_info']='Os clientes estão autorizados a seleccionar Prioridade, pelo que esta categoria será ignorada.<br /><br />Para usar categoria Prioridade em vez disso, desligue o seguinte recurso nas configurações HESK:';
$hesklang['def_pri']='Prioridade da categoria';
$hesklang['ch_cat_pri']='Definir prioridade da categoria';
$hesklang['cat_pri_ch']='Prioridade da categoria foi definida para:';
$hesklang['err_dbversion']='Versão muito antiga do MySQL:';
$hesklang['ip_whois']='IP whois';
$hesklang['ednote']='Editar notas da mensagem';
$hesklang['ednote2']='Nota da mensagem guardada';
$hesklang['perm_deny']='Permissão negada';
$hesklang['mis_note']='ID da nota não encontrada';
$hesklang['no_note']='Nota com este ID não encontrada';
$hesklang['sacl']='Guardar e continuar mais tarde';
$hesklang['reply_saved']='Mensagem de resposta guardada para mais tarde.';
$hesklang['submit_as']='Submeter como:';
$hesklang['sasc']='Submeter como resposta de Cliente';
$hesklang['creb']='Resposta do Cliente introduzida por:';
$hesklang['show_select']='Mostrar &quot;Clique para seleccionar&quot; como opção pré-definida';
// Settings
$hesklang['mms']='Modo de Manutenção';
$hesklang['mmd']='Activar Modo de Manutenção';
// Customer notice
$hesklang['mm1']='Manutenção em curso';
$hesklang['mm2']='Devido a manutenção programada o nosso HELPDESK está indisponível temporariamente.';
$hesklang['mm3']='Lamentamos o incómodo, pedindo que volte e tente mais tarde.';
// Staff notice
$hesklang['mma1']='Modo de Manutenção está activo!';
$hesklang['mma2']='Clientes não podem usar o help desk.';
$hesklang['tools']='Ferramentas';
$hesklang['banemail']='Emails Banidos';
$hesklang['banemail_intro']='Prevenir que determinados endereços de email submitam tickets no nosso help desk.';
$hesklang['no_banemails']='<i>Não há emails banidos.</i>';
$hesklang['eperm']='Emails banidos permanentemente:';
$hesklang['bananemail']='Endereços de email para banir';
$hesklang['savebanemail']='Banir este email';
$hesklang['enterbanemail']='Introduza o endereço de email que deseja banir.';
$hesklang['validbanemail']='Introduza um endereço de email válido (<i>nome.apelido@dominio.pt</i>) ou domínio de email (<i>@dominio.pt</i>)';
$hesklang['email_banned']='Este endereço de email <i>%s</i> foi banido e o HESK não aceitará tickets deste endereço.'; // %s will be replaced with email
$hesklang['emailbanexists']='Este endereço de email <i>%s</i> já está banido.'; // %s will be replaced with email
$hesklang['email_unbanned']='Email ban eliminado';
$hesklang['banby']='Banido por';
$hesklang['delban']='Eliminar ban';
$hesklang['delban_confirm']='Eliminar este ban?';
$hesklang['baned_e']='Foi banido de apresentar novos tickets de suporte.';
$hesklang['baned_ip']='Foi banido deste help desk';
$hesklang['can_ban_emails']='Pode banir emails';
$hesklang['can_unban_emails']='Pode remover ban de emails (activa Pode banir emails)';
$hesklang['eisban']='Este endereço de email encontra-se banido.';
$hesklang['click_unban']='Clique aqui para remover o ban.';
$hesklang['banip']='IPs banidos';
$hesklang['banip_intro']='Visitantes de endereços IP banidos não poderão ver ou submeter tickets e fazer login no help desk.';
$hesklang['ipperm']='IPs banidos permanentemente:';
$hesklang['iptemp']='Bans por tentativas de Login falhadas:';
$hesklang['savebanip']='Banir este IP';
$hesklang['no_banips']='<i>Não há IPs banidos.</i>';
$hesklang['bananip']='Endereços IP para banir';
$hesklang['banex']='Exemplos:';
$hesklang['iprange']='Range de IP';
$hesklang['ippermban']='Banir este IP permanentemente';
$hesklang['enterbanip']='Introduza IP ou range que deseja banir.';
$hesklang['validbanip']='Introduza IP ou range válidos';
$hesklang['ip_banned']='O endereço IP <i>%s</i> foi banido e o HESK não aceita novos tickets deste endereço IP.'; // %s will be replaced with IP
$hesklang['ip_rbanned']='A range de IPs <i>%s</i> foi banida e o HESK não aceita novos tickets desta range de IPs.'; // %s will be replaced with IP
$hesklang['ipbanexists']='O endereço IP <i>%s</i> já está banido.'; // %s will be replaced with IP
$hesklang['iprbanexists']='A range IP <i>%s</i> já está banida.'; // %s will be replaced with IP
$hesklang['ip_unbanned']='Eliminado ban de IP';
$hesklang['ip_tempun']='Eliminado ban temporário de IP';
$hesklang['can_ban_ips']='Pode banir IPs';
$hesklang['can_unban_ips']='Pode remover ban de IPs (activa Pode banir IPs)';
$hesklang['ipisban']='O endereço IP está banido.';
$hesklang['m2e']='Expira em (minutos)';
$hesklang['info']='Informação';
$hesklang['sm_title']='Mensagens de Serviço';
$hesklang['sm_intro']='Mostra uma mensagem de serviço na área do Cliente, por exemplo para notificá-lo de problemas conhecidos e noticias importantes.';
$hesklang['can_service_msg']='Editar mensagens de serviço';
$hesklang['new_sm']='Nova mensagem de serviço';
$hesklang['edit_sm']='Editar mensagem de serviço';
$hesklang['ex_sm']='Mensagens de serviço existentes';
$hesklang['sm_author']='Autor';
$hesklang['sm_type']='Tipo';
$hesklang['sm_published']='Publicada';
$hesklang['sm_draft']='Rascunho';
$hesklang['sm_style']='Estilo';
$hesklang['sm_none']='Nenhum';
$hesklang['sm_success']='Sucesso';
$hesklang['sm_info']='Informação';
$hesklang['sm_notice']='Aviso';
$hesklang['sm_error']='Erro';
$hesklang['sm_save']='Guardar mensagem de serviço';
$hesklang['sm_preview']='Previsualizar mensagem de serviço';
$hesklang['sm_mtitle']='Título';
$hesklang['sm_msg']='Mensagem';
$hesklang['sm_e_title']='Introduza título da mensagem de serviço';
$hesklang['sm_e_msg']='Introduza mensagem de serviço';
$hesklang['sm_e_id']='ID da mensagem não encontrada';
$hesklang['sm_added']='Nova mensagem de serviço adicionada';
$hesklang['sm_deleted']='Mensagem de serviço eliminada';
$hesklang['sm_not_found']='Esta mensagem de serviço não existe';
$hesklang['no_sm']='Não há mensagens de serviço';
$hesklang['del_sm']='Eliminar esta mensagem de serviço?';
$hesklang['sm_mdf']='Guardada mensagem de serviço';
$hesklang['sska']='Mostrar artigo sugeridos';
$hesklang['taws']='Os seguintes artigos foram sugeridos:';
$hesklang['defaults']='Pré-definições';
$hesklang['pncn']='Seleccione a opção de notificar o cliente no formulário de novo ticket';
$hesklang['pncr']='Seleccione a opção de notificar o cliente no formulário de resposta do ticket';
$hesklang['pssy']='Mostrar os artigos da Base de Conhecimento que foram sugeridas aos clientes';
$hesklang['ccct']='Resolvido pelo cliente';
$hesklang['custnot']='Comunicar cliente quando';
$hesklang['notnew']='Novo ticket de suporte foi submetido';
$hesklang['notclo']='Ticket de suporte foi marcado como Resolvido';
$hesklang['enn']='Excepções para filtragem de Email piping/POP3 se o assunto conter:';
$hesklang['spamn']='Aviso de SPAM';
$hesklang['spam_inbox']='<span style="color:red"><b>Não tem email de confirmação?</b><br />Enviámos-lhe uma mensagem de confirmação para o seu endereço de email. Se não o recebeu em poucos minutos, verifique se este não foi filtrado para a pasta de SPAM/Caixa de Correio não solicitado. Marque as mensagens como <b>Not SPAM</b> para evitar problemas de comunicação no futuro.</span>';
$hesklang['ekb_n']='<b>NÃO</b>, desactivar Base de Conhecimento';
$hesklang['ekb_y']='<b>SIM</b>, activar Base de Conhecimento';
$hesklang['ekb_o']='<b>SIM</b>, usar HESK só como Base de Conhecimento (<i>desactivar help desk</i>)';
$hesklang['kb_set']='Definições da Base de Conhecimento';
$hesklang['kbo1']='modo só-Base de Conhecimento';
$hesklang['kbo2']='<br /><br />Visitantes não podem criar novos tickets de suporte e serão reencaminhados directamente para a Base de Conhecimento.';
$hesklang['fpass']='Esqueceu a password?';
$hesklang['passr']='Reposição da Password';
$hesklang['passa']='Permite os utilizadores reporem a password pelo email';
$hesklang['passe']='Introduza o seu endereço de email';
$hesklang['passs']='Enviar link para reposição da password';
$hesklang['noace']='Não há conta criada para o email fornecido';
$hesklang['pemls']='Enviámos-lhe um email com instruções sobre como fazer reposição da palavra-passe';
$hesklang['reset_password']='Reposição de password do help desk'; // Email subject
$hesklang['ehash']='Link de reposição expirado ou inválido';
$hesklang['ehaip']='Endereço IP errado. Passwords só podem ser repostas pelo IP que solicitou a sua reposição.';
$hesklang['resim']='<b>Introduza a sua nova password no formulário abaixo!</b>';
$hesklang['permissions']='Permissões';
$hesklang['atype']='Tipo de Conta';
$hesklang['astaff']='Staff';
$hesklang['oon1']='Enviar só tickets abertos';
$hesklang['oon2']='Enviar todos os meus tickets';
$hesklang['anyown']='Qualquer proprietário';
$hesklang['pfr']='Outra tarefa de POP3 continua em execução.';
$hesklang['pjt']='Tarefa ultrapassou o tempo-limite';
$hesklang['pjt2']='minutos após início';
$hesklang['nkba']='Base de Conhecimento precisa de mais artigos para funcionar devidamente.<br /><br />Considere adicionar mais artigos à Base de Conhecimento para melhorar a pesquisa e os resultados de artigos sugeridos.';
$hesklang['saa']='Artigos em modo Sticky estão colocados no topo da lista de artigos';
$hesklang['yhbr']='Você foi bloqueado pelo sistema por %s minutos devido a excesso de respostas a um ticket.';

// Language for Google reCaptcha API version 2
// Supported language codes: https://developers.google.com/recaptcha/docs/language
// If your language is NOT in the supported langauges, leave 'en'
$hesklang['RECAPTCHA']='pt-PT';

// Added in version 2.7.0
$hesklang['imap']='Busca IMAP';
$hesklang['imaph']='Servidor IMAP';
$hesklang['imapp']='Porta IMAP';
$hesklang['enc']='Encriptação';
$hesklang['ssl']='SSL';
$hesklang['tls']='TLS';
$hesklang['none']='Nenhuma';
$hesklang['imapu']='Nome de Utilizador IMAP';
$hesklang['imapw']='Palavra-passe IMAP';
$hesklang['imaptest']='Testar conexão IMAP';
$hesklang['ifd']='[HESK] A BUSCA IMAP ESTÁ DESATIVADA NAS DEFINIÇÕES';
$hesklang['iei']='[HESK] A extensão PHP IMAP não está instalada.';
$hesklang['ifr']='Outra tarefa de busca IMAP ainda está em progresso.';
$hesklang['arp']='Recarregar página automaticamente';
$hesklang['arpp']='Recarregar automaticamente a página com a lista de tickets a cada:';
$hesklang['seconds']='segundos';
$hesklang['minutes']='minutos';
$hesklang['atbr']='Este ticket precisa de ser atribuído antes de poder ser respondido.';
$hesklang['attm']='Atribuir este ticket a mim';
$hesklang['owneed']='Responsável necessário';
$hesklang['taat']='Este ticket já está atribuído a <b>%s</b>.';
$hesklang['scoy']='Tens a certeza de que o queres atribuir a ti?';
$hesklang['scot']='Tens a certeza de que o queres atribuir a %s?';
$hesklang['ycto']='SIM, alterar o responsável';
$hesklang['ncto']='NÃO, manter o responsável atual';
$hesklang['fass']='Exigir responsável';
$hesklang['req_sub']='Exigir assunto';
$hesklang['req_msg']='Exigir mensagem';
$hesklang['req_email']='Exigir email';
$hesklang['default_subject']='Ticket de %s';
$hesklang['off-hide']='Esconder no formulário do cliente';
$hesklang['not_valid_email']='Introduz um endereço de email válido ou deixa este campo em branco';
$hesklang['write_down']='<span style="color:red">Recomendamos que escrevas o teu ID de Ticket para referência futura.</span>';
$hesklang['re_confirm1']='Desativar isto também desativará "Exigir email para visualizar tickets" em "Segurança". Continuar?';
$hesklang['re_confirm2']='Ativar isto também ativará "Exigir email" em "Funcionalidades". Continuar?';
$hesklang['can_email_tpl']='Editar templates de email';
$hesklang['et_title']='Templates de Email';
$hesklang['et_intro']='Modifica os emails que são enviados para a tua equipa e clientes';
$hesklang['file']='Ficheiro';
$hesklang['efile']='A editar ficheiro';
$hesklang['rdesc']='Descrição';
$hesklang['desc_forgot_ticket_id']='(Cliente) Esqueceu-se do ID do ticket';
$hesklang['desc_new_reply_by_staff']='(Cliente) Nova resposta da equipa';
$hesklang['desc_new_ticket']='(Cliente) Ticket recebido';
$hesklang['desc_ticket_closed']='(Cliente) Ticket fechado/resolvido';
$hesklang['desc_category_moved']='(Equipa) Ticket movido para uma nova categoria';
$hesklang['desc_new_reply_by_customer']='(Equipa) Nova resposta do cliente';
$hesklang['desc_new_ticket_staff']='(Equipa) Novo ticket submetido';
$hesklang['desc_ticket_assigned_to_you']='(Equipa) Um ticket foi atribuído a ti';
$hesklang['desc_new_pm']='(Equipa) Nova mensagem privada';
$hesklang['desc_new_note']='(Equipa) Nova nota num ticket atribuído a ti';
$hesklang['desc_reset_password']='(Equipa) Redefine a tua palavra-passe';
$hesklang['etfm']='Um ou mais templates de email estão em falta.<br><br>Certifica-te de que envias todos os ficheiros de templates de email dentro destas duas pastas:<br><br><i>/language/%s/emails</i><br><i>/language/%s/html_emails</i>';
$hesklang['etfw']='Alguns templates de email não têm permissões de escrita.<br><br>
                    Certifica-te de que o PHP tem permissão para escrever em todos os ficheiros dentro destas duas pastas:<br><br>
                    <i>/language/%s/emails</i><br>
                    <i>/language/%s/html_emails</i><br><br>
                    Nos servidores Unix, poderá ser necessário alterar as permissões dos templates de email para 666 (rw-rw-rw-)';
$hesklang['et_e_id']='ID de template em falta';
$hesklang['et_fm']='Este ficheiro de template de email está em falta';
$hesklang['et_fw']='Este ficheiro de template de email não é editável';
$hesklang['et_save']='Guardar alterações';
$hesklang['updated_on']='Atualizado em';
$hesklang['ticket_url']='URL do Ticket';
$hesklang['pm_url']='URL da mensagem privada';
$hesklang['et_num']='Número de tickets';
$hesklang['et_list']='Lista de tickets de suporte';
$hesklang['et_empty']='O template de email não pode estar vazio';
$hesklang['et_saved']='Template de email guardado';
$hesklang['source']='Fonte';
$hesklang['select_category']='Selecionar uma categoria';
$hesklang['select_category_text']='Em que podemos ajudar?';
$hesklang['select_category_staff']='Selecionar categoria do ticket';
$hesklang['scat']='Limite de seleção de categoria';
$hesklang['scat2']='(uma caixa de seleção aparecerá se o número de categorias for superior)';
$hesklang['new_cf']='Novo campo personalizado';
$hesklang['cf_intro']='Usa esta funcionalidade para adicionar campos personalizados ao formulário "Submeter um ticket", de modo a recolher informações adicionais dos clientes.';
$hesklang['cf_public']='Público';
$hesklang['cf_private']='Apenas para a equipa';
$hesklang['cf_cust']='Para clientes';
$hesklang['cf_all']='Todos';
$hesklang['cf_cat']='Selecionado';
$hesklang['cf_ctrl']='Dica: mantém a tecla CTRL pressionada para selecionar várias categorias';
$hesklang['visibility']='Visibilidade';
$hesklang['cf_save']='Guardar campo personalizado';
$hesklang['ex_cf']='Campos personalizados ativos';
$hesklang['no_cf']='Sem campos personalizados ativos';
$hesklang['del_cf']='Eliminar este campo personalizado? Isto também eliminará quaisquer dados de campo personalizado guardados na base de dados!';
$hesklang['cf_e_id']='ID inválido';
$hesklang['edit_cf']='Editar campo personalizado';
$hesklang['cf_deleted']='Campo personalizado eliminado';
$hesklang['cf_not_found']='Este campo personalizado não existe';
$hesklang['cf_added']='Um novo campo personalizado foi adicionado';
$hesklang['cf_nocat']='Seleciona pelo menos uma categoria para este campo personalizado';
$hesklang['cf_mdf']='O campo personalizado foi guardado';
$hesklang['atl1']='Insere pelo menos uma opção.';
$hesklang['sch']='Escondido';
$hesklang['meml3']='Permitir introdução de vários emails';
$hesklang['dmin']='Data mínima aceite';
$hesklang['dmax']='Data máxima aceite';
$hesklang['d_day']='dia(s)';
$hesklang['d_week']='semana(s)';
$hesklang['d_month']='mês(es)';
$hesklang['d_year']='ano(s)';
$hesklang['d_any']='Qualquer data';
$hesklang['d_fixed']='Data fixa';
$hesklang['d_relative']='Data relativa';
$hesklang['d_mm']='A data mínima não pode ser superior à data máxima';
$hesklang['d_emin']='A data mínima para <i>%s</i> é %s';
$hesklang['d_emax']='A data máxima para <i>%s</i> é %s';
$hesklang['d_format']='Formato de exibição da data';
$hesklang['d_custom']='Formato personalizado';
$hesklang['d_ci']='APENAS PARA UTILIZADORES AVANÇADOS: um formato de data PHP válido, ver o manual do PHP.';
$hesklang['cf_noe']='Insere um endereço de email válido em <i>%s</i>';
$hesklang['cf_noem']='Insere um ou mais endereços de email válidos em <i>%s</i>';
$hesklang['can_resolve']='Pode resolver tickets';
$hesklang['can_change_own_cat']='Alterar categoria de ticket (para as permitidas)';
$hesklang['can_submit_any_cat']='Pode submeter tickets para qualquer categoria';
$hesklang['noauth_submit']='Não estás autorizado a submeter tickets para esta categoria!';
$hesklang['noauth_move']='Não estás autorizado a mover tickets para esta categoria!';
$hesklang['noauth_resolve']='Não estás autorizado a resolver tickets!';
$hesklang['force_ssl']='Forçar conexões SSL';
$hesklang['d_ssl']='<i>desativado</i> - abre esta página com https:// para gerir esta opção';
$hesklang['scno']='Este estado não pode ser alterado';
$hesklang['statuses']='Estados';
$hesklang['statuses_intro']='Usa esta ferramenta para adicionar estados de ticket personalizados ao teu sistema de suporte';
$hesklang['color']='Cor';
$hesklang['csscl']='Classe CSS ou cor';
$hesklang['clr_view']='Pré-visualização da cor no texto';
$hesklang['cbc']='Alterável pelos clientes';
$hesklang['ccc']='Os clientes podem alterar este estado?';
$hesklang['del_status']='Eliminar este estado?';
$hesklang['ex_status']='Estados existentes';
$hesklang['status_hesk']='Estados incorporados (não podem ser modificados aqui)';
$hesklang['status_custom']='Estados personalizados';
$hesklang['status_custom_none']='Sem estados personalizados. Podes adicioná-los clicando em "Novo estado personalizado" acima.';
$hesklang['status_save']='Guardar';
$hesklang['list_tkt_status']='Listar todos os tickets com este estado';
$hesklang['new_status']='Novo estado personalizado';
$hesklang['edit_status']='Editar estado personalizado';
$hesklang['err_status']='Insere o nome do estado';
$hesklang['status_added']='Um novo estado personalizado foi adicionado';
$hesklang['status_e_id']='ID inválido';
$hesklang['status_mdf']='O estado personalizado foi guardado';
$hesklang['status_deleted']='Estado personalizado eliminado';
$hesklang['status_not_found']='Este estado personalizado não existe';
$hesklang['status_not_empty']='Este estado não pode ser removido porque existem tickets com este estado';
$hesklang['status_limit']='Tens 100 estados personalizados, não podes criar mais.';
$hesklang['public_link']='Link público';
$hesklang['frames']='Frames';
$hesklang['frames2']='Prevenir o carregamento do HESK em frames de domínios de terceiros';
$hesklang['numsub']='Tickets submetidos';
$hesklang['hidf']='Os campos de entrada ocultos não são visíveis para os clientes no formulário "Submeter um ticket" (o valor ainda será visível na página de detalhes do ticket se estiverem definidos como públicos). Eles comportam-se como campos de texto normais para os membros da equipa.';
$hesklang['rcheck']='Não selecionar uma opção predefinida';
$hesklang['refresh_page']='Recarregar esta página';
$hesklang['del_kba']='Eliminar este artigo';
$hesklang['del_kbaa']='Eliminar permanentemente este artigo';
$hesklang['hni1']='HESK ainda não instalado?';
$hesklang['hni2']='Parece que este sistema de suporte ainda não foi corretamente instalado e configurado.';
$hesklang['hni3']='Para instalar o HESK, segue as <a class="link" href="docs/">Instruções na documentação</a>';
$hesklang['cf']='Pasta de cache';
$hesklang['e_cdir']='O Hesk não será capaz de analisar emails ou armazenar resultados em cache a menos que a pasta de cache exista e seja editável.';
$hesklang['step1']='Passo 1';
$hesklang['step2']='Passo 2';
$hesklang['dffs']='Quando o download estiver concluído, eliminar o ficheiro do servidor';
$hesklang['fd']='Ficheiro de exportação eliminado do servidor';

// Added in version 2.8.0
$hesklang['TZ']='Fuso Horário';
$hesklang['thist17']='<li class="smaller">%s | submetido através da busca IMAP</li>';
$hesklang['sir3']='reCAPTCHA invisível';
$hesklang['invisible']='invisível';
$hesklang['imap_not']='PHP não está compilado com suporte a IMAP';
$hesklang['imap_warning']='o utilizador %1$s tem o mesmo endereço de email que o teu email de busca IMAP: %2$s'; // %1$s = username, %2$s = email address
$hesklang['pop3_warning']='o utilizador %1$s tem o mesmo endereço de email que o teu email de busca POP3: %2$s'; // %1$s = username, %2$s = email address
$hesklang['fetch_warning']='Isto pode resultar num loop de emails, onde novos tickets são criados a partir de notificações por email do utilizador. O teu endereço de email de busca deve ser único e não deve ser usado por mais ninguém.';
$hesklang['can_view_ass_by']='Pode ver tickets que atribuiu a outros';
$hesklang['can_privacy']='Pode anonimizar tickets';
$hesklang['confirm_anony']='Anonimizar este ticket';
$hesklang['anon_selected']='Anonimizar tickets selecionados';
$hesklang['privacy_anon_info']='Remove todos os dados e conteúdos pessoalmente identificáveis dos tickets (nome do cliente, email, mensagem, anexos, IP...), mas mantém os tickets na base de dados para estatísticas (direito ao esquecimento).';
$hesklang['success_anon']='Ticket anonimizado com sucesso';
$hesklang['num_tickets_anon']='Número de tickets anonimizados: <b>%d</b>';
$hesklang['anon_IP']='0.0.0.0'; // IP in anonymized tickets
$hesklang['anon_name']='[Cliente]'; // Customer name in anonymized tickets
$hesklang['anon_email']=''; // Customer email in anonymized tickets
$hesklang['anon_subject']='[Assunto]'; // Ticket subject of anonymized tickets
$hesklang['anon_message']='[Mensagem]'; // Ticket message in anonymized tickets
$hesklang['thist18']='<li class="smaller">%s | anonimizado por %s</li>';
$hesklang['print_selected']='Imprimir tickets selecionados';
$hesklang['with_selected']='Com selecionados:';
$hesklang['assign_selected']='Atribuir selecionados a:';
$hesklang['assign_no']='Nenhum responsável selecionado, nenhuma alteração feita';
$hesklang['assign_1']='Os tickets selecionados foram definidos como Não Atribuídos.';
$hesklang['assign_2']='Ticket ID %1$s definido como Não Atribuído'; // %1$s = ticket numerical ID
$hesklang['assign_3']='%1$s erro: já atribuído a %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_4']='%1$s atribuído a %2$s'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_5']='%1$s erro: %2$s não tem acesso à categoria do ticket'; // %1$s = ticket tracking ID, %2$s = owner name
$hesklang['assign_log']='Resultado da atribuição em massa de tickets:<br /><br />Atribuídos: %1$s<br />Erros: %2$s<br /><br />Registo:<br /><pre>%3$s</pre>'; // %1$s = number of tickets assigned, %2$s = number of errors, %3$s = log
$hesklang['IP_addr']='Endereço IP';
$hesklang['moret']='Mais opções'; // More options button title
$hesklang['btn_more']='Mais'; // More options button text
$hesklang['btn_print']='Imprimir';
$hesklang['btn_edit']='Editar';
$hesklang['btn_lock']='Bloquear ticket';
$hesklang['btn_unlock']='Desbloquear ticket';
$hesklang['btn_tag']='Marcar ticket';
$hesklang['btn_resend']='Reenviar notificação por email';
$hesklang['btn_untag']='Desmarcar ticket';
$hesklang['btn_import_kb']='Importar para a Base de Conhecimento';
$hesklang['btn_anony']='Anonimizar ticket';
$hesklang['btn_delt']='Eliminar ticket';
$hesklang['btn_delr']='Eliminar resposta';
$hesklang['ernf']='Resposta não encontrada';
$hesklang['tns']='As notificações de ticket foram reenviadas';
$hesklang['rns']='As notificações de resposta foram reenviadas';
$hesklang['fname']='Primeiro Nome';
$hesklang['export_selected']='Exportar tickets selecionados';
$hesklang['btn_export']='Exportar para XML para Excel';
$hesklang['recaptcha']='reCAPTCHA';

// Added in version 3.0.0
$hesklang['responses']='Responses';
$hesklang['team']='Equipa';
$hesklang['sm_content']='Conteúdo';
$hesklang['sm_settings']='Definições';
$hesklang['wizard_back']='Voltar'; // Create/Edit sidebar button to go back a step
$hesklang['wizard_next']='Avançar'; // Create/Edit sidebar button to go forward a step
$hesklang['sm_go_to_settings']='Ir para Definições';
$hesklang['sm_return_to_editing']='Voltar à Edição';
$hesklang['email_tpl_title']='Título';
$hesklang['edit_email_template']='Editar modelo de email';
$hesklang['err_no_settings_section']='Não foi fornecida nenhuma secção de definições.';
$hesklang['this_field_is_required']='Este campo é obrigatório';
$hesklang['reset_your_password']='Redefinir a tua senha';
$hesklang['reset_password_instructions']='Por favor, preencha o formulário abaixo. Enviaremos um link para redefinir a tua senha.';
$hesklang['enter_email']='Introduz o email';
$hesklang['password_reset_check_your_email']='Verifica o teu email';
$hesklang['password_reset_link_sent']='Enviámos-te um link para redefinir a tua senha.';
$hesklang['back_to_login']='Voltar ao login';
$hesklang['pager_first']='Primeira';
$hesklang['pager_previous']='Anterior';
$hesklang['pager_next']='Próxima';
$hesklang['pager_last']='Última';
$hesklang['new_team_member']='Novo Membro da Equipa';
$hesklang['role']='Função';
$hesklang['optional']='Opcional';
$hesklang['edit_profile']='Editar Perfil';
$hesklang['assigned_to']='Atribuído a';
$hesklang['contact']='Contacto';
$hesklang['unban_email']='Desbloquear este email';
$hesklang['unban_ip']='Desbloquear este IP';
$hesklang['show_previous_replies']='Mostrar respostas anteriores';
$hesklang['type_your_message']='Escreve a tua mensagem'; // Used when there are no canned responses
$hesklang['close_button_text']='Fechar';
$hesklang['create_new_ticket']='Criar Novo Ticket';
$hesklang['delete_article']='Eliminar artigo';
$hesklang['view_existing_tickets']='Ver tickets existentes';
$hesklang['how_can_we_help']='Olá, como podemos ajudar?';
$hesklang['search_for_articles']='Procurar artigos';
$hesklang['submit_a_support_request']='Enviar um Pedido de Suporte';
$hesklang['verify_header']='Prevenção de SPAM';
$hesklang['ticket_details']='Detalhes do Ticket';
$hesklang['yes_title_case']='Sim';
$hesklang['no_title_case']='Não';
$hesklang['no_results_found']='Nenhum Resultado Encontrado';
$hesklang['site_theme']='Tema do site';
$hesklang['test_theme_folder']='Testar pasta de temas';
$hesklang['test_theme_folder_description']='A testar a pasta de temas para temas válidos. Apenas os temas que passarem todos os testes serão corretamente instalados.';
$hesklang['err_site_theme']='Por favor, selecione o tema Hesk';
$hesklang['confirm']='Confirmar';
$hesklang['confirm_deletion']='Confirmar Eliminação';
$hesklang['confirm_delete_status']='Tens a certeza de que queres eliminar este estado personalizado?';
$hesklang['help_desk']='Só Prestigio Encomendas'; // Displayed on staff sidebar menu

// Added in version 3.1.0
$hesklang['TIMEAGO_LANG_FILE']='jquery.timeago.en.js'; // Name of the proper language file in folder /js/timeago/locales
$hesklang['tdis']='Time display';
$hesklang['tdisd']='Date and time';
$hesklang['tdisa']='Time ago (example: 5 hours ago)';
$hesklang['nav_templates']='Templates'; // Admin panel navigation item
$hesklang['hide_replies']='Hide ticket replies';
$hesklang['hide_replies_no']='Do not hide, always show all replies';
$hesklang['hide_replies_yes']='Hide all replies except the last:';
$hesklang['hide_replies_def']='Show the last staff reply and any subsequent customer replies';
$hesklang['reply_by']='Reply by'; // Reply by NAME
$hesklang['btt']='Back to Top';
$hesklang['lwidth']='Limit ticket width';
$hesklang['lwidtall']='Use the full available width';
$hesklang['lwidtpx']='Maximum width in pixels:';
// 3-letter days of the week
$hesklang['mon']='Mon';
$hesklang['tue']='Tue';
$hesklang['wed']='Wed';
$hesklang['thu']='Thu';
$hesklang['fri']='Fri';
$hesklang['sat']='Sat';
$hesklang['sun']='Sun';
$hesklang['clear']='Clear'; // delete field value
$hesklang['first_day_of_week']='0'; // first day of week; 0 = Sunday, 1 = Monday, 2 = Tuesday, ...
$hesklang['spam_req']='At least one SPAM prevention measure must be enabled!';
$hesklang['modules']='Modules';
$hesklang['modules_demo']='This module is currently available only in %s'; // %s = Hesk cloud link
$hesklang['see_demo']='Try the live demo here: %s'; // %s = Hesk demo link
$hesklang['statistics']['tab']='Statistics';
$hesklang['statistics']['intro']='This report will give you insight into your help desk usage and staff performance.';
$hesklang['statistics']['ntsp']='No tickets in the selected time period.';
$hesklang['statistics']['pie_title_ro']='Open vs Resolved tickets';
$hesklang['statistics']['open']='Open';
$hesklang['statistics']['resolved']='Resolved';
$hesklang['statistics']['pie_title_as']='Open tickets: Assigned vs Unassigned';
$hesklang['statistics']['ass']='Assigned';
$hesklang['statistics']['unas']='Unassigned';
$hesklang['statistics']['pie_title_au']='Open tickets: Answered vs Unanswered';
$hesklang['statistics']['answered']='Answered';
$hesklang['statistics']['unanswered']='Unanswered';
$hesklang['statistics']['pie_title_so']='Status of open tickets';
$hesklang['statistics']['retic']='Tickets:';
$hesklang['statistics']['chart_title_md']='Tickets per day of month';
$hesklang['statistics']['chart_title_wd']='Tickets per weekday';
$hesklang['statistics']['chart_title_hd']='Tickets per day hour';
$hesklang['statistics']['chart_title_tfr']='Time to first staff reply';
$hesklang['statistics']['chart_title_tfrc']='Tickets replied to within a time frame';
$hesklang['statistics']['chart_title_ttr']='Time from submitting to resolving a ticket';
$hesklang['statistics']['chart_title_ttrc']='Tickets resolved within a time frame';
$hesklang['statistics']['chart_title_sr']='Staff replies';
$hesklang['statistics']['chart_title_srt']='Staff replies per ticket';
$hesklang['statistics']['chart_title_srtr']='Staff replies per ticket (resolved tickets only)';
$hesklang['statistics']['chart_title_srt1']='Staff replies per ticket (tickets with at least 1 reply)';
$hesklang['statistics']['ct_30']='30 minutes';
$hesklang['statistics']['ct_1h']='1 hour';
$hesklang['statistics']['ct_2h']='2 hours';
$hesklang['statistics']['ct_4h']='4 hours';
$hesklang['statistics']['ct_1d']='1 day';
$hesklang['statistics']['ct_2d']='2 days';
$hesklang['statistics']['ct_3d']='3 days';
$hesklang['statistics']['ct_1w']='1 week';
$hesklang['statistics']['ct_wp']='> 1 week';
$hesklang['statistics']['ct_1m']='1 month';
$hesklang['statistics']['ct_mp']='> 1 month';
$hesklang['statistics']['axis1']='% of tickets replied';
$hesklang['statistics']['axis2']='% of tickets resolved';
$hesklang['statistics']['axis3']='% of tickets';
$hesklang['statistics']['axis4']='Time to first reply';
$hesklang['statistics']['axis5']='Time to resolved';
$hesklang['statistics']['axis6']='Number of replies';
$hesklang['statistics']['axis7']='Number of tickets';
$hesklang['statistics']['axis8']='Weekday';
$hesklang['statistics']['axis9']='Hour';
$hesklang['statistics']['axis10']='Day of month';
$hesklang['statistics']['tr_0']='No reply';
$hesklang['statistics']['tr_1']='1 reply';
$hesklang['statistics']['tr_2']='2 replies';
$hesklang['statistics']['tr_5']='3-5 replies';
$hesklang['statistics']['tr_10']='6-10 replies';
$hesklang['statistics']['tr_99']='> 10 replies';
$hesklang['statistics']['average']='Average';
$hesklang['statistics']['atfr']='Average hours and minutes to first staff reply:';
$hesklang['statistics']['attr']='Average hours and minutes to resolve a ticket:';
$hesklang['statistics']['about']='about %s'; // approximate time; "about 5 days 3 hous"
$hesklang['statistics']['na']='N/A';
$hesklang['statistics']['trept']='Total tickets staff replied to:';
$hesklang['statistics']['trnr']='Total tickets resolved without a staff reply:';
$hesklang['statistics']['tsr']='Total staff replies:';
$hesklang['statistics']['tsrt']='Average staff replies per ticket:';
$hesklang['statistics']['tsro']='Average staff replies per ticket (tickets with at least 1 staff reply):';
$hesklang['statistics']['tsrc']='Average staff replies required to resolve a ticket:';
$hesklang['statistics']['tsrr']='Average staff replies required to resolve a ticket (tickets with at least 1 staff reply):';
$hesklang['sep_1000']=','; // separator between every group of thousands: 1,000,000
$hesklang['sep_dec']='.'; // separator between full and decimal numbers: 0.99
$hesklang['and_more']='and much more...'; // last item in a list

// Added in version 3.2.0
$hesklang['overdue_ticket']='[#%%TRACK_ID%%] Ticket em atraso';
$hesklang['ticket_escalated']='[#%%TRACK_ID%%] ESCALADO: %%SUBJECT%%';
$hesklang['escalate']['tab']='Escalar'; // Menu link
$hesklang['escalate']['page_title']='Escalar Tickets'; // Page H2 title
$hesklang['escalate']['intro']='Este módulo ajuda a escalar tickets que não são atendidos a tempo.';
$hesklang['escalate']['feat1']='Tickets não atribuídos, sem resposta ou não resolvidos dentro de um prazo';
$hesklang['escalate']['feat2']='tickets próximos do prazo ou em atraso';
$hesklang['escalate']['feat3']='alterar automaticamente a prioridade do ticket, reatribuir o ticket, enviar uma notificação por email';
$hesklang['escalate']['feat4']='aplicar regras com base na categoria, responsável ou estado do ticket';
$hesklang['escalate']['prefix']='Escalado:'; // Email subject prefix, e.g. "Escalated: [XXX-XXX-XXXX] Test ticket"
$hesklang['escalate']['active_rules']='Regras ativas';
$hesklang['escalate']['new']='Nova regra de escalada';
$hesklang['escalate']['no_rules']='Não tens regras de escalada. Cria uma clicando no botão &quot;Nova regra de escalada&quot; acima.';
$hesklang['escalate']['title']='Título da regra';
$hesklang['escalate']['titlet']='Um título descritivo, por exemplo: Reatribuir tickets não respondidos em um dia';
$hesklang['escalate']['default_title']='Regra por %1$s'; // Default rule title; %1$s = user name
$hesklang['escalate']['trigger']='Acionador da regra';
$hesklang['escalate']['trigt']='Define a condição que aciona (executa) esta regra.';
$hesklang['escalate']['hits']='Acionamentos'; // How many times a rule has been triggered
$hesklang['escalate']['step1']='Condição'; // Title of step 1 when creating/editing a rule
$hesklang['escalate']['step2']='Ação'; // Title of step 2 when creating/editing a rule
$hesklang['escalate']['step3']='Aplicar a'; // Title of step 3 when creating/editing a rule
$hesklang['escalate']['delete']='Eliminar esta regra?';
$hesklang['escalate']['edit']='Editar regra de escalada ID %1$s'; // %1$s = rule ID number
$hesklang['escalate']['ifat']='Um ticket de suporte está:'; // If a ticket is not (resolved) within X (minutes) of submitting, then (resend notification)
$hesklang['escalate']['nrep']='sem resposta por parte do staff';
$hesklang['escalate']['nrepc']='sem resposta por parte do cliente';
$hesklang['escalate']['nass']='não atribuído';
$hesklang['escalate']['nres']='não resolvido';
$hesklang['escalate']['ndue']='próximo do prazo';
$hesklang['escalate']['odue']='em atraso';
$hesklang['escalate']['within']='Dentro de:';
$hesklang['escalate']['minutes']='minutos';
$hesklang['escalate']['hours']='horas';
$hesklang['escalate']['days']='dias';
$hesklang['escalate']['weeks']='semanas';
$hesklang['escalate']['months']='meses';
$hesklang['escalate']['years']='anos';
$hesklang['escalate']['ofs']='após ser submetido';
$hesklang['escalate']['resend']='Reenviar notificações por email:';
$hesklang['escalate']['force']='Enviar sempre, ignorar configurações do staff';
$hesklang['escalate']['noforce']='Respeitar as configurações de notificação do staff';
$hesklang['escalate']['setpri']='Definir prioridade para:';
$hesklang['escalate']['setsta']='Definir estado para:';
$hesklang['escalate']['assto']='Atribuir o ticket a:';
$hesklang['escalate']['asm']='Outro membro do staff';
$hesklang['escalate']['notify']='Notificar membros do staff...';
$hesklang['escalate']['ato']='Aplicar a:';
$hesklang['escalate']['tic']='Tickets na categoria:';
$hesklang['escalate']['tat']='Tickets atribuídos a:';
$hesklang['escalate']['tws']='Tickets com estado:';
$hesklang['escalate']['tall']='Aplicar esta regra a tickets existentes e futuros';
$hesklang['escalate']['tfn']='Aplicar esta regra apenas a tickets futuros, ignorar tickets existentes';
$hesklang['escalate']['tfi']='Aplicar esta regra apenas a tickets com ID superior a:';
$hesklang['escalate']['save']='Guardar regra';
$hesklang['escalate']['e_tt']='O tempo deve estar entre 1 e 10000';
$hesklang['escalate']['e_a']='Seleciona pelo menos uma ação para executar nos tickets correspondentes';
$hesklang['escalate']['nocat']='Seleciona pelo menos uma categoria';
$hesklang['escalate']['nouser']='Seleciona pelo menos um utilizador';
$hesklang['escalate']['nostatus']='Seleciona pelo menos um estado';
$hesklang['escalate']['nocata']='%1$s não tem acesso a estas categorias:'; // %1$s = user name
$hesklang['escalate']['rule_added']='Nova regra foi criada';
$hesklang['escalate']['mdf']='As configurações da regra foram guardadas';
$hesklang['escalate']['e_id']='Não foi encontrada nenhuma regra com este ID';
$hesklang['escalate']['deleted']='A regra selecionada foi eliminada';
$hesklang['escalate']['edit_notice']='alterar o acionador da regra não terá efeito em tickets já escalados por esta regra (a menos que a regra seja reiniciada).';
$hesklang['escalate']['reset']='Reiniciar esta regra';
$hesklang['escalate']['reset2']='Tens a certeza de que queres reiniciar esta regra?<br><br>Os acionamentos da regra serão redefinidos para 0 e qualquer ticket que corresponda a esta regra será escalado novamente.';
$hesklang['escalate']['reset3']='A regra selecionada foi reiniciada';
$hesklang['escalate']['log_title']='Regra #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['escalate']['thist1']='<li class="smaller">%1$s | escalado por %2$s:</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['escalate']['thist2']='<li class="smaller">%1$s | - prioridade definida para %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist3']='<li class="smaller">%1$s | - atribuído a %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist4']='<li class="smaller">%1$s | - notificação enviada ao staff</li>';
$hesklang['escalate']['thist5']='<li class="smaller">%1$s | - notificação enviada ao staff (forçada)</li>';
$hesklang['escalate']['thist6']='<li class="smaller">%1$s | - erro: %2$s não tem acesso à categoria do ticket</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist7']='<li class="smaller">%1$s | - erro: %2$s não tem permissão para ver os tickets</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist8']='<li class="smaller">%1$s | - erro: nenhum outro utilizador pode ver este ticket</li>'; // %1$s = date
$hesklang['escalate']['thist9']='<li class="smaller">%1$s | - aviso: prioridade já definida para %2$s</li>'; // %1$s = date, %2$s = priority
$hesklang['escalate']['thist10']='<li class="smaller">%1$s | - aviso: já atribuído a %2$s</li>'; // %1$s = date, %2$s = owner
$hesklang['escalate']['thist11']='<li class="smaller">%1$s | - notificar: %2$s</li>'; // %1$s = date, %2$s = list of users
$hesklang['escalate']['thist12']='<li class="smaller">%1$s | - estado definido para %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['thist13']='<li class="smaller">%1$s | - aviso: estado já definido para %2$s</li>'; // %1$s = date, %2$s = status
$hesklang['escalate']['active']='Ativo'; // Is the rule active (live)?
$hesklang['escalate']['activate']='Ativar esta regra (começar a usá-la)';
$hesklang['escalate']['activated']='A regra selecionada foi ativada'; // %1$s = rule log title
$hesklang['escalate']['deactivate']='Desativar esta regra (parar de a usar)';
$hesklang['escalate']['deactivated']='A regra selecionada foi desativada'; // %1$s = rule log title
$hesklang['escalate']['no_active']='Não há regras de escalada ativas';
$hesklang['escalate']['matched']='Número de tickets correspondentes encontrados: %1$s '; // %1$s = number of tickets
$hesklang['escalate']['tools']='Ferramentas';
$hesklang['escalate']['test']='Simular esta regra';
$hesklang['escalate']['testa']='Simular todas as regras';
$hesklang['escalate']['testaa']='Simular todas as regras ativas';
$hesklang['escalate']['testr']='Resultados da simulação';
$hesklang['escalate']['rsim']='Repetir simulação';
$hesklang['escalate']['tbef']='Antes de uma regra estar ativa, precisas de a ativar clicando na caixa de seleção na coluna &quot;ATIVO&quot;.<br><br>
                               Recomendamos fortemente que <strong>simules</strong> cada regra clicando no ícone %1$s (Simular esta regra) na tabela de regras
                               para ver como ela afetará os tickets existentes antes de a ativar.<br><br>
                               <strong>As regras ativas são processadas a cada %2$s minutos. Um ticket só pode ser escalado uma vez por cada regra</strong>.'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['escalate']['sim']='MODO SIMULAÇÃO, sem alterações na base de dados';
$hesklang['escalate']['sic']='SIMULAÇÃO COMPLETA';
$hesklang['escalate']['r']='[REGRA]';
$hesklang['escalate']['i']='[INFORMAÇÃO]';
$hesklang['multopt']='Dica: mantém a tecla CTRL pressionada para selecionar várias opções';
$hesklang['desc_ticket_escalated']='(Staff) O ticket foi escalado'; // Email description in admin panel
$hesklang['ticket_formatting_staff']='Formatação do ticket (Staff)';
$hesklang['ticket_formatting_plaintext']='Texto Simples';
$hesklang['ticket_formatting_rich_text']='Texto Rico (HTML)';
$hesklang['due_date']='Data de Vencimento';
$hesklang['invalid_due_date']='Foi introduzida uma data de vencimento inválida.';
$hesklang['thist19']='<li class="smaller">%s | data de vencimento atualizada para %s por %s</li>'; // %s = date, new due date, user making change
$hesklang['thist20']='<li class="smaller">%s | data de vencimento removida por %s</li>'; // %s = date, user making change
$hesklang['due_date_updated']='A data de vencimento do ticket foi atualizada.';
$hesklang['menu_kb_manage']='Gerir'; // Left admin menu Knowledgebase "Manage" tab
$hesklang['menu_kb_view']='Ver'; // Left admin menu Knowledgebase "View" tab
$hesklang['a_select']='Selecionar todos';
$hesklang['a_deselect']='Desmarcar todos';
$hesklang['a_toggle']='Alternar todos';
$hesklang['ql_all']='Todos os tickets';
$hesklang['ql_alo']='Todos os tickets abertos';
$hesklang['ql_fit']='Tickets filtrados';
$hesklang['ql_a2m']='Atribuídos a mim';
$hesklang['ql_a2o']='Atribuídos a outros';
$hesklang['ql_una']='Não atribuídos';
$hesklang['ql_due']='A vencer em breve';
$hesklang['ql_ovr']='Em atraso';
$hesklang['set_ds']='Mostrar como &quot;a vencer em breve&quot;'; // Settings page (title of setting)
$hesklang['set_ds2']='dias antes da data de vencimento';
$hesklang['not_aos']='Alguns tickets abertos aos quais tens acesso não são exibidos devido aos teus filtros.';
$hesklang['ntoverdue']='Um ticket está em atraso com o responsável:';
$hesklang['ovdcron']='para que as notificações de tickets em atraso funcionem, o administrador deve ativar um cron job.';
$hesklang['instructions']='Instruções';
$hesklang['desc_overdue_ticket']='(Staff) Ticket em atraso';
$hesklang['overdue_starting']='Iniciando o processo de notificação de tickets em atraso';
$hesklang['overdue_sim']='O envio de emails e a atualização de tickets está desativado no modo de SIMULAÇÃO.';
$hesklang['overdue_ticket_count']='Foram encontrados %s tickets em atraso.'; // %s = Number of tickets
$hesklang['overdue_finished']='Processo de tickets em atraso concluído. %s emails enviados. %s emails falharam o envio.'; // %s = Successful emails, failed emails
$hesklang['admin_css']='CSS do Admin';
$hesklang['admin_css2']='Carregar um ficheiro de estilo personalizado extra para o painel de administração';
$hesklang['noval_cert']='Não validar certificados do servidor';
$hesklang['chg_cat']='Clicar para alterar a categoria do ticket';
$hesklang['tlan']='Idioma do ticket';
$hesklang['uue']='Dois ou mais membros do staff têm o mesmo endereço de email. Recomendamos definir um endereço de email único para cada utilizador.';
$hesklang['flood']='Limite de flood';
$hesklang['e_flood']='Oops, já submeteste uma resposta recentemente. Parámos este pedido para prevenir o envio excessivo de respostas.';
$hesklang['cookies']='Cookies';
$hesklang['ukey']='Chave de Acesso por URL'; // Key required to access certain files (like cron jobs) via an URL
$hesklang['ukeyg']='Gerar uma Chave de Acesso por URL aleatória';
$hesklang['ukeym']='Erro: para executar este ficheiro via HTTP tens de incluir a tua Chave de Acesso por URL no pedido. Exemplo:';
$hesklang['ukeyw']='Erro: chave de acesso por URL incorreta';

// Added in version 3.3.0
$hesklang['new_ticket_by_staff']='[#%%TRACK_ID%%] Pedido recebido: %%SUBJECT%%';
$hesklang['mfa_verification']='%%VERIFICATION_CODE%% é o seu código de verificação';
$hesklang['follow_up_email']='Seja honesto - como nos saímos?';
$hesklang['mfa']='Autenticação Multi-Fator (MFA)';
$hesklang['mfa_short']='MFA';
$hesklang['mfa_enabled_question']='MFA Ativado?';
$hesklang['mfa_required']='Requer Autenticação Multi-Fator';
$hesklang['mfa_manage_profile']='Gerenciar MFA';
$hesklang['mfa_disabled']='Autenticação Multi-Fator está desativada';
$hesklang['mfa_enabled']='Autenticação Multi-Fator está Ativada (%s)'; // %s = MFA type
$hesklang['mfa_method_none']='Nenhum';
$hesklang['mfa_method_none_subtext']='Remover autenticação multi-fator da sua conta.';
$hesklang['mfa_method_email']='Email';
$hesklang['mfa_method_email_subtext']='O sistema enviará um código de login aleatório para <strong>%s</strong> ao fazer login.'; // %s = User's email address
$hesklang['mfa_method_auth_app']='Aplicativo Autenticador';
$hesklang['mfa_method_auth_app_short']='Aplicativo';
$hesklang['mfa_method_auth_app_subtext']='Use um aplicativo de autenticação, como Authy ou Google Authenticator, para gerar um código de login ao fazer login.';
$hesklang['mfa_step_method']='Método';
$hesklang['mfa_step_verification']='Verificação';
$hesklang['mfa_step_complete']='Concluir';
$hesklang['mfa_introduction']='A autenticação multi-fator melhora a segurança da conta exigindo que você verifique seu login usando um método de verificação adicional, como email ou aplicativo autenticador (como Authy ou Google Authenticator).';
$hesklang['mfa_reset_warning']='Você já ativou a autenticação multi-fator. Concluir isso novamente irá redefinir seu dispositivo de autenticação multi-fator (se ativado).';
$hesklang['mfa_select_method_colon']='Selecione um método de autenticação:';
$hesklang['mfa_verification_header']='Verificação - %s'; // %s = MFA type
$hesklang['mfa_verification_email_intro']='Um email foi enviado para <strong>%s</strong> contendo um código de verificação de seis dígitos. Insira o código recebido por email abaixo para continuar.'; // %s = User's email address
$hesklang['mfa_verification_auth_app_intro']='&raquo; Passo 1: Digitalize a imagem abaixo com o aplicativo autenticador em seu dispositivo móvel.';
$hesklang['mfa_verification_auth_app_cant_scan']='Não conseguiu escanear a imagem? Insira manualmente este código no seu dispositivo: <b>%s</b>'; // %s = Secret code
$hesklang['mfa_verification_auth_app_enter_code']='&raquo; Passo 2: Insira o código de 6 dígitos exibido no seu aplicativo para verificar o dispositivo.';
$hesklang['mfa_verify']='Verificar';
$hesklang['mfa_invalid_method']='Método de autenticação multi-fator inválido recebido.';
$hesklang['mfa_invalid_verification_code']='O código inserido está incorreto ou expirado.';
$hesklang['mfa_configured']='A autenticação multi-fator foi ativada para sua conta!';
$hesklang['mfa_removed']='A autenticação multi-fator foi desativada para sua conta!';
$hesklang['mfa_verification_needed']='A autenticação multi-fator está ativada para esta conta.';
$hesklang['mfa_verification_needed_email']='Insira o código de verificação que foi enviado para o seu endereço de email.';
$hesklang['mfa_verification_needed_auth_app']='Insira o código exibido no seu aplicativo autenticador.';
$hesklang['mfa_verification_code']='Código de verificação';
$hesklang['mfa_server_time_issue']='O tempo do servidor parece estar impreciso: %s'; // %s = exception message
$hesklang['mfa_reset_to_default']='Redefinir autenticação multi-fator';
$hesklang['mfa_reset_confirm']='Tem certeza de que deseja redefinir o MFA para este usuário?';
$hesklang['mfa_reset_yes']='Redefinir';
$hesklang['mfa_reset']='A autenticação multi-fator foi redefinida para o usuário';
$hesklang['desc_mfa_verification']='(Equipe) Código de Autenticação Multi-Fator';
$hesklang['mfa_code']='Código:';
$hesklang['mfa_backup_codes_header']='GUARDE OS SEUS CÓDIGOS DE BACKUP!';
$hesklang['mfa_backup_codes_description']='Guarde estes códigos de backup num local seguro, mas acessível. Caso perca o acesso ao seu dispositivo MFA ou email, pode utilizar um dos seguintes códigos de backup para iniciar sessão.<br><br><strong>Certifique-se de tratar estes códigos como palavras-passe. Não poderá visualizá-los novamente!</strong>';
$hesklang['mfa_verify_another_way']='Verifique a sua conta de outra forma'; // %s = masked email address
$hesklang['mfa_verify_another_way_email']='Receba um código de verificação em %s';
$hesklang['mfa_verify_another_way_code']='Insira um dos seus códigos de backup de 8 caracteres';
$hesklang['mfa_verify_another_way_admin']='Contacte o administrador do seu helpdesk para obter ajuda';
$hesklang['mfa_verify_another_way_reset']='Redefina a sua autenticação multi-fator carregando um ficheiro para o servidor';
$hesklang['mfa_send_another_email']='Enviar outro email';
$hesklang['mfa_sent']='Um email com um novo código de verificação foi enviado para o seu endereço de email';
$hesklang['mfa_backup_code']='Código de Backup';
$hesklang['mfa_backup_codes']='Códigos de Backup';
$hesklang['mfa_backup_codes_info']='Códigos de uso único para passar na verificação multi-fator quando não for possível aceder ao seu email ou aplicativo autenticador. Assim que utilizar um código de backup para iniciar sessão, ele tornar-se-á inativo.';
$hesklang['mfa_backup_codes_num']='Pode obter um novo conjunto de 10 códigos de backup sempre que quiser. Quando criar um novo conjunto de códigos, o conjunto antigo será automaticamente desativado.';
$hesklang['mfa_backup_codes_num2']='Número de códigos ativos: %s';
$hesklang['mfa_invalid_backup_code']='O código de backup inserido está incorreto ou já foi utilizado.';
$hesklang['mfa_del_codes']='Eliminar os meus códigos de backup';
$hesklang['mfa_del_codes2']='Todos os seus códigos de backup foram eliminados.';
$hesklang['mfa_new_codes']='Gerar novos códigos de backup';
$hesklang['mfa_new_codes2']='Novos códigos de backup foram gerados';
$hesklang['old_php_version']='Erro: Versão PHP não suportada';
$hesklang['category_default_due_date']='Data de Vencimento Padrão';
$hesklang['category_change_default_due_date']='Definir Data de Vencimento Padrão';
$hesklang['category_leave_blank_for_no_default_due_date']='(deixe em branco para não definir uma data padrão)';
$hesklang['category_default_due_date_updated']='A data de vencimento padrão foi atualizada.';
$hesklang['email_formatting']='Formatação de Email';
$hesklang['email_formatting_html_and_plaintext']='HTML com alternativa em texto simples do modelo de texto simples (padrão)';
$hesklang['email_formatting_html_and_plaintext_auto']='HTML com alternativa em texto simples gerada a partir do modelo HTML';
$hesklang['email_formatting_html']='Apenas HTML';
$hesklang['email_formatting_plaintext']='Apenas texto simples';
$hesklang['email_formatting_note']='A sua seleção em %1$s &gt; %2$s &gt; %3$s está definida como: <i>%4$s</i>'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting, %3$4 = setting description
$hesklang['email_formatting_note0']='Isto significa que o Hesk ignorará os modelos HTML aqui.';
$hesklang['email_formatting_note1']='Isto significa que o Hesk ignorará os modelos de texto simples aqui.';
$hesklang['email_formatting_note2']='Isto significa que o Hesk gerará versões em texto simples dos emails a partir dos seus modelos HTML e ignorará os modelos de texto simples aqui.';
$hesklang['etnu']='Este modelo de email atualmente não é utilizado pelo Hesk com base na sua seleção em %1$s &gt; %2$s &gt; %3$s'; // %1$s = Settings, %2$s = Email, %3$s = Email formatting
$hesklang['edit_category']='Editar Categoria';
$hesklang['create_category']='Criar Categoria';
$hesklang['one_user_included']='1 utilizador incluído';
$hesklang['one_user_excluded']='1 utilizador excluído';
$hesklang['x_users_included']='%s utilizadores incluídos'; // %s = Number of users
$hesklang['x_users_excluded']='%s utilizadores excluídos'; // %s = Number of users
$hesklang['aa_cat']='Atribuir automaticamente tickets nesta categoria';
$hesklang['modify_autoassign_settings']='Modificar definições de atribuição automática';
$hesklang['autoassign_on_all_users']='Sim, para qualquer utilizador com acesso a esta categoria';
$hesklang['autoassign_on_select_users']='Sim, para utilizadores específicos';
$hesklang['autoassign_off']='Não, submeter tickets como não atribuídos';
$hesklang['autoassign_users']='Utilizadores a incluir/excluir na atribuição automática';
$hesklang['autoassign_selected_include']='Os utilizadores selecionados devem ser <strong>incluídos</strong> ao atribuir automaticamente tickets nesta categoria';
$hesklang['autoassign_selected_exclude']='Os utilizadores selecionados devem ser <strong>excluídos</strong> ao atribuir automaticamente tickets nesta categoria';
$hesklang['cat_edited']='A categoria %s foi editada com sucesso';
$hesklang['search_for_user']='Procurar utilizador';
$hesklang['email_sending']='Envio de emails';
$hesklang['email_to_ticket']='Email para ticket';
$hesklang['email_to_ticket_info']='A conversão de emails em tickets requer alguma configuração no servidor. Para detalhes, consulte <a href="%s" target="_blank">este guia de base de conhecimento</a>.'; // %s = link to article
$hesklang['from_warning2']='O Hesk está a usar um servidor SMTP para enviar notificações de email. O seu <strong>%1$s</strong> deve estar configurado como <strong>%2$s</strong>'; // %1$s = "From email" text, %2$s = email address
$hesklang['nofex']='Extensão de ficheiro ausente';
$hesklang['block_ignore']='Email para ticket - Ignorar emails e prevenir loops';
$hesklang['block_noreply']='Não responder';
$hesklang['block_noreply2']='Ignorar emails enviados a partir de endereços de email "não responder"';
$hesklang['block_returned']='Devolvidos';
$hesklang['block_returned2']='Ignorar emails devolvidos, como notificações de estado de entrega e respostas automáticas';
$hesklang['block_duplicate']='Duplicados';
$hesklang['block_duplicate2']='Ignorar emails com a mesma mensagem enviados dentro de "%s" segundos'; // %s = "Timeframe"
$hesklang['loop_info']='emails recebidos do mesmo endereço de email dentro de "%s" segundos';
$hesklang['thist21']='<li class="smaller">%s | notificação de email de atraso enviada</li>'; // %s = date
$hesklang['thist22']='<li class="smaller">%s | email de acompanhamento enviado</li>'; // %s = date
$hesklang['elevator_header']='Entrar numa Área Segura';
$hesklang['elevator_intro']='Está prestes a entrar numa área segura.';
$hesklang['elevator_enter_password']='Por favor, insira a sua palavra-passe para continuar.';
$hesklang['elevator_duration_setting_title']='Duração da área segura';
$hesklang['desc_survey']='(Cliente) Email de acompanhamento (inquérito)'; // Email description
$hesklang['satisfaction']['tab']='Satisfação';
$hesklang['satisfaction']['title']='Inquérito de Satisfação do Cliente';
$hesklang['satisfaction']['intro']='Envie aos seus clientes um inquérito de satisfação de acompanhamento para recolher feedback sobre a experiência com o seu help desk.';
$hesklang['satisfaction']['tab1']='Configurações';
$hesklang['satisfaction']['tab2']='Cancelar Inscrição';
$hesklang['satisfaction']['enable']='Ativar emails de acompanhamento:';
$hesklang['satisfaction']['enabled']='Os inquéritos de satisfação do cliente estão ativados.';
$hesklang['satisfaction']['disabled']='Os inquéritos de satisfação do cliente estão atualmente desativados.';
$hesklang['satisfaction']['url']='Endereço URL do inquérito:';
$hesklang['satisfaction']['send']='Atraso do email de acompanhamento:';
$hesklang['satisfaction']['at_least']='Esperar pelo menos';
$hesklang['satisfaction']['after']='após o ticket ser resolvido antes de enviar o email';
$hesklang['satisfaction']['h1']='Como usar esta ferramenta?';
$hesklang['satisfaction']['h2']='Primeiro, crie um inquérito de satisfação do cliente na sua ferramenta de inquéritos preferida. Se não souber qual ferramenta usar ou quais perguntas fazer, temos um <a href="%s" target="_blank">guia disponível aqui</a>.'; // %s = link to article
$hesklang['satisfaction']['h3']='Quando o seu inquérito estiver pronto, ative os emails de acompanhamento usando o formulário abaixo. O Hesk processará tickets resolvidos com pelo menos uma resposta da equipa uma vez por hora e enviará o link do seu inquérito aos seus clientes.';
$hesklang['satisfaction']['e_url']='Insira um endereço URL de inquérito válido. Este é o URL para onde os seus clientes serão enviados.';
$hesklang['satisfaction']['as']='Insira um endereço URL de inquérito válido. Este é o URL para onde os seus clientes serão enviados.';
$hesklang['satisfaction']['oo1']='Esta página lista os endereços de email para os quais os emails de acompanhamento <b>não</b> serão enviados.';
$hesklang['satisfaction']['oo2']='Os seus clientes podem cancelar a inscrição nos emails de inquérito clicando num link no email. Alternativamente, pode adicionar manualmente endereços de email nesta página.';
$hesklang['satisfaction']['ooe']='Endereço de email para cancelar a inscrição';
$hesklang['satisfaction']['ooe2']='Insira o endereço de email que deseja cancelar a inscrição dos emails de inquérito.';
$hesklang['satisfaction']['ooe3']='Este endereço de email <i>%s</i> já está cancelado dos emails de inquérito.'; // %s will be replaced with email
$hesklang['satisfaction']['btn_oo']='Cancelar este email';
$hesklang['satisfaction']['oob']='Cancelado por';
$hesklang['satisfaction']['no_oo']='Nenhum cliente cancelou a inscrição dos emails de inquérito.';
$hesklang['satisfaction']['oor']='Remover';
$hesklang['satisfaction']['oor2']='Email removido do cancelamento';
$hesklang['satisfaction']['oor3']='Confirmar remoção';
$hesklang['satisfaction']['oor4']='Quando removido do cancelamento, este utilizador voltará a receber emails de acompanhamento.';
$hesklang['satisfaction']['optedout']='O endereço de email <i>%s</i> foi cancelado dos emails de inquérito.'; // %s will be replaced with email
$hesklang['satisfaction']['mit']='ID de inquérito em falta ou inválido';
$hesklang['satisfaction']['starting']='Iniciando o processo de notificação do inquérito de satisfação do cliente';
$hesklang['satisfaction']['tc']='Foram encontrados %s tickets fechados que não tiveram inquérito de satisfação enviado.'; // %s = Number of tickets
$hesklang['satisfaction']['finished']='Inquérito de Satisfação do Cliente concluído. Emails enviados: %1$s. Emails com erro: %2$s. Tickets sem email: %3$s. Tickets com email cancelado: %4$s.'; // %1$s = successful emails, %2$s = failed emails, %3$s = number of tickets without an email, %4$s = number of tickets with opt-out users
$hesklang['satisfaction']['oo']='A ignorar, este cliente não deseja receber emails de inquérito.';
$hesklang['satisfaction']['ne']='A ignorar, este ticket não tem um endereço de email associado';
$hesklang['satisfaction']['feat1']='Crie o seu inquérito usando qualquer ferramenta de terceiros, como o Google Forms';
$hesklang['satisfaction']['feat2']='configure o URL do inquérito, as preferências e as limitações dentro deste módulo';
$hesklang['satisfaction']['feat3']='quando você resolver um ticket, o Hesk enviará o link do inquérito ao seu cliente';
$hesklang['dfor']='Formato de data';
$hesklang['dtfor']='Data e Hora';
$hesklang['cdfor']='Formato de seleção de data';
$hesklang['custom']='Personalizado';
$hesklang['jsc_notice']='A seleção de data não suporta o formato de data estilo PHP. Selecione uma das opções predefinidas ou clique no ícone %s abaixo para ver as opções disponíveis.'; // %s = replaced by icon
$hesklang['lcf3']='Apenas data'; // Display: "Date only"
$hesklang['epdd']='Erro ao analisar o parâmetro due_date:';
$hesklang['edit_pass']='Editar palavra-passe';
$hesklang['save_pass']='Guardar palavra-passe';
$hesklang['cur_pass']='Palavra-passe atual';
$hesklang['cur_pass2']='Precisa fornecer a sua palavra-passe atual para poder alterá-la.';
$hesklang['cur_pass3']='Após atualizar a palavra-passe com sucesso, será redirecionado para a página de login, onde pode iniciar sessão com a nova palavra-passe.';
$hesklang['e_new_pass']='Por favor, insira a sua nova palavra-passe';
$hesklang['pass_len']='A palavra-passe não pode exceder 64 caracteres';
$hesklang['pass_login']='Por favor, inicie sessão novamente após alterar a palavra-passe';
$hesklang['bf_int']='Foi desconectado devido a muitas tentativas de verificação falhadas';
$hesklang['tst_cnt']='Número de emails que o seu servidor de emails enviará para o Hesk: %s'; // %s = number of emails
$hesklang['wrn_imap']='Existem muitos emails não lidos na sua caixa de entrada (%1$s). O Hesk transformará todos esses emails em tickets.<br><br>Recomenda-se marcar os emails existentes como lidos antes de ativar %2$s ou utilizar uma nova conta de email para o Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['wrn_pop3']='Existem muitos emails na sua caixa de entrada (%1$s). O Hesk transformará todos esses emails em tickets.<br><br>Recomenda-se apagar os emails existentes antes de ativar %2$s ou utilizar uma nova conta de email para o Hesk.'; // %1$s = number of emails, %2$s = IMAP or POP3 fetching
$hesklang['search_due_date_specific']='Vencimento em'; // Due on (date)
$hesklang['search_due_date_range']='Vencimento dentro de'; // Due in (X days)
$hesklang['attachment_add_files']='Adicionar ficheiro';
$hesklang['attachment_max_exceeded']='Este ficheiro não será carregado porque já alcançou o número máximo de ficheiros permitidos.';
$hesklang['attachment_viewer_message']='Arraste os ficheiros aqui ou clique no botão "Adicionar Ficheiro" abaixo para selecionar ficheiros para carregar.';
$hesklang['attachment_invalid_type_message']='Desculpe, mas o tipo de ficheiro que tentou carregar não é permitido.';
$hesklang['attachment_upload_error']='Ocorreu um erro ao tentar carregar. Tente novamente mais tarde.';
$hesklang['attachment_too_large']='Este anexo é maior do que o tamanho máximo permitido.';
$hesklang['attachment_cancel']='Cancelar';
$hesklang['attachment_confirm_cancel']='Tem a certeza de que deseja cancelar este carregamento?';
$hesklang['attachment_remove']='Remover anexo';
$hesklang['attachment_too_many_uploads']='Foram carregados demasiados anexos do seu local numa curta janela de tempo. Por favor, tente novamente mais tarde.';
$hesklang['sub_note']='Submeter nota';
$hesklang['can_view_users']='Visualizar todos os utilizadores (mas não gerí-los)';
$hesklang['welcome1']='Olá, parece que é novo por aqui. Bem-vindo!';
$hesklang['welcome2']='Para começar, veja o %s.'; // %s = Hesk online Quick Start Guide (below)
$hesklang['welcome3']='Guia de Início Rápido do Hesk';
$hesklang['tmce1']='Use Ctrl+Clique direito para aceder ao verificador ortográfico';
$hesklang['tmce2']='Mantenha pressionada a tecla Control (Ctrl) e clique com o botão direito do rato sobre a palavra com erro para aceder ao verificador ortográfico.';
$hesklang['desc_new_ticket_by_staff']='(Cliente) Novo ticket submetido pela equipa';
$hesklang['mod_et_h']='Pode modificar os modelos de email em %1$s &gt; %2$s'; // %1$s = Tools, %2$s = Email templates link
$hesklang['set_lang']='Definir idioma para';
$hesklang['ouwa']='Apenas utilizadores com acesso a esta categoria estão listados abaixo. Para adicionar membros da equipa a esta categoria, edite as permissões na página %s'; // %s = Team
$hesklang['previous_tickets']='Tickets anteriores';
$hesklang['no_previous']='Nenhum ticket anterior de %s'; // %s = email address
$hesklang['all_previous']='Listar todos os tickets anteriores';
$hesklang['confirm_delete_ticket']='Tem a certeza de que deseja eliminar este ticket permanentemente?';
$hesklang['confirm_delete_reply']='Tem a certeza de que deseja eliminar esta resposta permanentemente?';
$hesklang['select_new_category']='Número de tickets nesta categoria: %s<br><br>Por favor, selecione uma nova categoria para transferir estes tickets:'; // %s = Number of tickets
$hesklang['deleting_user_with_tickets']='Número de tickets atribuídos a este utilizador: %1$s<br>Número de <b>tickets abertos</b> atribuídos a este utilizador: %2$s<br><br><b>Tickets abertos</b> serão <b>desatribuídos</b> após eliminar este utilizador.'; // %1$s = total tickets, %2$s = open tickets
$hesklang['hlic']='Licença HESK';
$hesklang['hlic_free']='GRATUITO';
$hesklang['hlic_buyl']='Comprar uma Licença';
$hesklang['hlic_paid']='Licenciado';
$hesklang['antdemo']='A submissão de tickets a partir do painel de administração foi desativada no modo de demonstração.<br><br>Por favor, utilize o <a href="%s" target="_blank">lado público</a> para submeter um ticket de teste.';

// Added in version 3.4.0
$hesklang['email_authentication_method']='Método de autenticação';
$hesklang['email_authentication_method_username_password']='Básico (Nome de utilizador / Palavra-passe)';
$hesklang['email_authentication_method_oauth']='OAuth';
$hesklang['email_authentication_method_oauth_disabled']='OAuth - Nenhum fornecedor OAuth verificado configurado.';
$hesklang['email_authentication_method_oauth_link']='Gerir fornecedores OAuth'; // Links to "OAuth Providers" tools page
$hesklang['email_oauth_auth_url']='URL do Endpoint de Autorização';
$hesklang['email_oauth_token_url']='URL do Endpoint do Token';
$hesklang['email_oauth_client_id']='ID do Cliente';
$hesklang['email_oauth_client_secret']='Segredo do Cliente';
$hesklang['email_oauth_scope']='Escopo';
$hesklang['oauth_error_invalid_state']='O estado do OAuth não corresponde ao estado enviado ao fornecedor OAuth.';
$hesklang['oauth_error_unknown']='Ocorreu um erro desconhecido ao tentar guardar os tokens OAuth.';
$hesklang['oauth_error_no_token']='Token de acesso ausente na resposta JSON.';
$hesklang['oauth_error_retrieve']='Não foi possível obter um token de acesso. Por favor, confirme as configurações do fornecedor OAuth e volte a guardá-las para adquirir um novo token.';
$hesklang['email_oauth_provider']='Fornecedor OAuth';
$hesklang['email_oauth_providers']='Fornecedores OAuth';
$hesklang['email_oauth_provider_guide']='Antes de usar OAuth, deve registar um fornecedor OAuth. Para detalhes, consulte <a href="%s" target="_blank">este guia da base de conhecimento</a>.'; // %s = link to article
$hesklang['email_oauth_provider_uri']='O seu URI de Redirecionamento OAuth para o Hesk é:<br><i>%s</i>'; // %s = URL of the oauth_providers.php file
$hesklang['email_oauth_providers_intro']='Use esta ferramenta para adicionar fornecedores OAuth ao seu help desk';
$hesklang['email_oauth_provider_name']='Nome'; // OAuth provider name
$hesklang['email_oauth_new_provider']='Novo Fornecedor';
$hesklang['email_oauth_edit_provider']='Editar Fornecedor';
$hesklang['email_oauth_provider_being_used_for']='A ser usado para';
$hesklang['email_oauth_providers_none']='Nenhum fornecedor OAuth guardado. Pode adicioná-los clicando em "Novo Fornecedor" acima.';
$hesklang['email_oauth_provider_cannot_be_deleted']='Este fornecedor não pode ser removido porque está a ser usado pelo help desk.';
$hesklang['email_oauth_confirm_delete_provider']='Tem a certeza de que deseja eliminar este fornecedor OAuth?';
$hesklang['oauth_provider_saved']='O fornecedor OAuth foi guardado';
$hesklang['oauth_provider_use']='Agora pode selecionar este fornecedor em %s &gt; %s'; // %s = Settings, %s = Email
$hesklang['oauth_provider_err_name']='Insira o nome do fornecedor';
$hesklang['oauth_provider_err_auth_url']='Insira um URL de autorização válido';
$hesklang['oauth_provider_err_token_url']='Insira um URL de token válido';
$hesklang['oauth_provider_err_client_id']='Insira o ID do cliente';
$hesklang['oauth_provider_err_client_secret']='Insira o segredo do cliente';
$hesklang['oauth_provider_err_scope']='Insira o escopo';
$hesklang['oauth_provider_deleted']='Fornecedor OAuth eliminado';
$hesklang['oauth_provider_not_found']='Este fornecedor OAuth não existe';
$hesklang['oauth_provider_verified']='Verificado';
$hesklang['oauth_provider_click_to_verify']='Clique para verificar';
$hesklang['can_due_date']='Pode definir a data de vencimento'; // Permission to set and modify due date
$hesklang['can_due_date_e']='Não tem permissão para definir datas de vencimento';

// Added in version 3.5.0
$hesklang['customer_verify_registration']='Verifique o seu registo';
$hesklang['customer_verify_new_email']='Verifique o seu novo endereço de email';
$hesklang['customer_reset_password']='Redefina a sua palavra-passe do suporte técnico';
$hesklang['customer_approved']='Conta aprovada';
$hesklang['customer_rejected']='Conta rejeitada';
$hesklang['email_rejected']='Conta necessária para enviar pedidos de suporte';
$hesklang['require_curl']='Esta funcionalidade requer o suporte de <strong>cURL</strong> para PHP ativado no seu servidor. Por favor, solicite ao seu provedor de hospedagem que ative o cURL para PHP.';
$hesklang['customer_accounts_heading']='Contas de Clientes';
$hesklang['customer_accounts']='Contas de clientes';
$hesklang['customer_accounts_off']='<strong>Desativado</strong>';
$hesklang['customer_accounts_allowed']='<strong>Ativado - Opcional</strong> (os clientes podem enviar tickets de suporte sem se registarem ou iniciarem sessão)';
$hesklang['customer_accounts_required_to_submit']='<strong>Ativado - Necessário para tickets</strong> (apenas clientes registados podem enviar tickets de suporte)';
$hesklang['customer_accounts_required']='<strong>Ativado - Necessário para acesso</strong> (apenas clientes registados podem aceder ao help desk e à base de conhecimento)';
$hesklang['customer_accounts_reg']='Registo de conta';
$hesklang['customer_accounts_reg_customer']='Os clientes podem registar contas';
$hesklang['customer_accounts_reg_approve']='Os clientes podem registar conta, a equipa deve aprovar novos registos';
$hesklang['customer_accounts_reg_staff']='Apenas a equipa pode registar contas de clientes';
$hesklang['customer_accounts_allow_email_changes']='Permitir que os clientes alterem o seu endereço de email';
$hesklang['customer_accounts_allow_email_resends']='Tempo até que os clientes possam solicitar um novo email de verificação';
$hesklang['customer_login']='Iniciar sessão';
$hesklang['customer_logout']='Terminar sessão';
$hesklang['customer_register']='Registar';
$hesklang['customer_accounts_disabled']='Os logins e registos de clientes estão desativados.';
$hesklang['customer_accounts_registration_disabled']='Os registos de clientes estão desativados.';
$hesklang['customer_forgot_password']='Esqueceu-se da palavra-passe?';
$hesklang['customer_email']='Endereço de email';
$hesklang['customer_accounts_email_banned']='Foi banido de utilizar este help desk.';
$hesklang['customer_registration_successful']='Registo concluído com sucesso!';
$hesklang['customer_registration_email_exists_no_reset_link']='Uma conta com o email %s já existe.'; // %s - Entered email address
$hesklang['customer_registration_email_exists']='Uma conta com o email %s já existe. <a href="login.php">Deseja iniciar sessão em vez disso</a>?'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_email_verification']='Uma conta com o email %s já existe e está pendente de verificação de email.'; // %s - Entered email address
$hesklang['customer_registration_email_exists_pending_approval']='Uma conta com o email %s já existe e está pendente de aprovação da equipa.'; // %s - Entered email address
$hesklang['customer_registration_check_your_email']='Verifique o seu email!';
$hesklang['customer_registration_check_your_email_content']='Deve verificar o seu endereço de email antes de poder iniciar sessão.<br><br>Se não receber dentro de alguns minutos, verifique as pastas de Lixo, Spam ou Correspondência em Massa. Marque a mensagem como <b>Não é SPAM</b> para evitar problemas no recebimento de nossa correspondência no futuro.';
$hesklang['customer_login_not_verified']='Deve verificar o seu endereço de email antes de poder iniciar sessão.';
$hesklang['customer_login_not_verified2']='Se não recebeu o email de verificação, por favor, verifique as pastas de Lixo, Spam ou Correspondência em Massa. Marque a mensagem como <b>Não é SPAM</b> para evitar problemas no recebimento de nossa correspondência no futuro.';
$hesklang['customer_login_resend_verification_email']='Reenviar email de verificação';
$hesklang['customer_login_resend_verification_email_none']='Não há verificações de email pendentes para enviar.';
$hesklang['customer_login_resend_verification_email_too_early']='Não pode solicitar um novo email de verificação neste momento, por favor, tente novamente mais tarde.';
$hesklang['customer_login_not_approved']='Um membro da equipa deve aprovar a sua conta antes de poder iniciar sessão. Assim que for aprovado, será notificado por email.'; // %s - Resend email notification link
$hesklang['customer_registration_verify_header']='Verificar Registo';
$hesklang['customer_registration_verify_success']='O seu email foi verificado e pode agora iniciar sessão utilizando o formulário abaixo.';
$hesklang['customer_registration_verify_approval_needed']='O seu email foi verificado. No entanto, um membro da equipa deve aprovar a sua conta antes de poder iniciar sessão. Assim que for aprovado, será notificado por email.';
$hesklang['customer_registration_verify_failure']='O seu email não pôde ser verificado. O link já foi utilizado ou expirou.';
$hesklang['emails_to_customers']='&raquo; Emails enviados aos clientes';
$hesklang['emails_to_staff']='&raquo; Emails enviados à equipa';
$hesklang['emails_to_everyone']='&raquo; Emails enviados à equipa ou aos clientes';
$hesklang['new_customer_approval']='Existem contas de clientes pendentes de aprovação'; // Email subject
$hesklang['desc_new_customer_approval']='(Equipa) Contas de clientes pendentes de aprovação';
$hesklang['n_cust_app']='Existem aprovações de clientes pendentes'; // Notify me when...
$hesklang['et_num_customers']='Número de aprovações pendentes';
$hesklang['et_link_customers']='Link para a página Gerir clientes';
$hesklang['et_link_verify']='Link de verificação';
$hesklang['et_cust_login']='URL de login do cliente';
$hesklang['submit_ticket_customer_email_exists']='Um cliente com este email já existe. Por favor, <a href="login.php?email=%s">inicie sessão</a> para enviar um ticket.'; // %s - User's email
$hesklang['customer_login_email_required']='Por favor, insira um endereço de email válido.';
$hesklang['customer_login_password_required']='Por favor, insira a sua palavra-passe.';
$hesklang['customer_login_remember_just_email']='Lembrar apenas o meu email';
$hesklang['customer_login_remember_email']='Lembrar o meu email';
$hesklang['customer_wrong_user']='O seu endereço de email %s não está registado connosco.<br><br>Deseja <a href="register.php">criar uma conta</a>?'; // %s - Entered email address
$hesklang['customer_wrong_pass']='O seu endereço de email e palavra-passe não correspondem aos nossos registos.<br><br>Deseja <a href="login.php?submittedForgot=1">redefinir a sua palavra-passe</a>?';
$hesklang['customer_must_be_logged_in_to_view']='Por favor, inicie sessão para continuar.';
$hesklang['customer_register_here']='Se não tem uma conta connosco, pode <a href="register.php">registar-se aqui</a>.';
$hesklang['create_account']='Criar uma conta';
$hesklang['customer_my_tickets_heading']='Os meus tickets';
$hesklang['customer_my_tickets_description']='Veja todos os seus tickets anteriores';
$hesklang['customer_my_tickets_search_for_tickets']='Procurar tickets';
$hesklang['customer_password_reset_successful']='A sua nova palavra-passe foi guardada. Pode agora iniciar sessão.';
$hesklang['customer_profile']='Perfil';
$hesklang['customer_edit_profile']='Editar Perfil';
$hesklang['customer_edit_pass']='Editar Palavra-passe';
$hesklang['customer_edit_pass_same']='A sua nova palavra-passe não deve ser igual à atual.';
$hesklang['customer_change_email']='Alterar Email';
$hesklang['customer_change_email_banned']='O email que inseriu está banido.';
$hesklang['customer_change_email_pending']='Existe um pedido em curso para alterar o seu endereço de email para: <b>%s</b><br><br>Enviámos um email para este endereço. Por favor, clique no link dentro do email para confirmar a alteração.'; // %s - new email
$hesklang['customer_change_resend']='<a href="profile.php?action=email-resend">Reenviar email de confirmação</a>';
$hesklang['customer_change_email_submitted']='Por favor, clique no link de verificação que foi enviado para <b>%s</b> para confirmar o seu novo email.'; // %s - new email
$hesklang['customer_change_email_verify_success']='O seu novo endereço de email foi verificado e o seu perfil atualizado.';
$hesklang['customer_change_email_disabled']='A capacidade de atualizar o seu email está desativada. Entre em contacto connosco se desejar alterar o seu endereço de email.';
$hesklang['customer_profile_saved']='O seu perfil foi guardado.';
$hesklang['customers']='Clientes';
$hesklang['customers_intro']='As contas de clientes permitem aos clientes visualizar todos os seus tickets num local central.';
$hesklang['sure_remove_customer']='Tem a certeza de que deseja remover este cliente?';
$hesklang['sure_remove_customer_additional_note']='A eliminação de um cliente é definitiva. Uma vez eliminado, não poderá ser recuperado!';
$hesklang['new_customer']='Novo Cliente';
$hesklang['new_follower']='Novo Seguidor';
$hesklang['add_customer']='+ Adicionar Cliente'; // Appears on Customer Dropdown, stickied at the bottom
$hesklang['add_follower']='+ Adicionar Seguidor'; // Appears on Followers Dropdown, stickied at the bottom
$hesklang['new_customer_prompt']='O cliente fornecido ainda não existe. Clique em "Guardar" se desejar criar este cliente.';
$hesklang['followers']='Seguidores';
$hesklang['no_customers']='Atualmente não há clientes na base de dados.';
$hesklang['no_customers_disabled']='Começará a ver clientes aqui quando eles submeterem tickets de suporte.';
$hesklang['no_customers_enabled']='Começará a ver clientes aqui quando eles se registarem ou submeterem tickets de suporte.';
$hesklang['no_customers_enabled2']='Alternativamente, os botões acima desta mensagem permitem criar contas de clientes manualmente ou importar clientes existentes para o help desk.';
$hesklang['import_customers']='Importar Clientes';
$hesklang['import_customers_tip']='Use um ficheiro CSV para importar vários clientes de uma só vez.';
$hesklang['customer_not_found']='Cliente não encontrado para o ticket!';
$hesklang['search_by_name_or_email']='Procurar por nome ou email...';
$hesklang['search_by_pattern']='Procurar por padrão...';
$hesklang['is_searchable']='Pesquisável';
$hesklang['custom_is_searchable']='Pesquisável';
$hesklang['yes_via_autocomplete']='SIM (pesquisa via autocompletar)';
$hesklang['customer_required']='Deve selecionar um cliente';
$hesklang['customer_email_exists']='Um cliente com este email já existe.';
$hesklang['customer_name_with_no_email_exists']='Um cliente com este nome e sem email já existe.';
$hesklang['an_error_occurred_validating_email']='Ocorreu um erro ao tentar verificar o endereço de email inserido.';
$hesklang['customer_count_x_more']='+%s mais'; // %s = Number of additional customers
$hesklang['customer_account_registered']='Registado';
$hesklang['customer_account_verified']='Verificado';
$hesklang['customer_account_verified_help']='Os clientes devem verificar sua conta através de um link de ativação enviado para o seu endereço de email antes de poderem acessar sua conta.';
$hesklang['customer_account_setting_password_will_verify_user']='Definir uma palavra-passe para este cliente irá automaticamente verificar a sua conta.';
$hesklang['deleting_customer_with_tickets']='Este cliente tem %1$s ticket(s) <b>(%2$s abertos)</b> que também possuem outros clientes associados.<br>O que deve ser feito com estes tickets?'; // %1$s = total tickets, %2$s = open tickets
$hesklang['customer_resend_verification_email_needed']='Um endereço de email válido é necessário para reenviar um email de verificação.';
$hesklang['customer_resend_verification_email_not_found']='Não existe uma conta com este endereço de email, ou a conta já foi verificada.';
$hesklang['customer_resend_verification_email_sent']='Um email de verificação foi enviado para o seu endereço de email.<br><br>Se não o receber dentro de alguns minutos, por favor, verifique as pastas de Lixo, Spam ou Correspondência em Massa. Marque a mensagem como <b>Não é SPAM</b> para evitar problemas futuros.';
$hesklang['customer_permission_denied']='Não tem permissão para modificar clientes.';
$hesklang['customer_manage_approvals']='Contas de clientes pendentes de aprovação: <b>%s</b>'; // %s = number of customers
$hesklang['customer_manage_approve']='Aprovar cliente';
$hesklang['customer_manage_bulk_approve']='Aprovar clientes selecionados';
$hesklang['customer_manage_bulk_approve_complete']='Clientes aprovados: %s'; // %s = number of customers
$hesklang['customer_manage_reject']='Rejeitar cliente';
$hesklang['customer_manage_bulk_reject']='Rejeitar clientes selecionados';
$hesklang['customer_manage_bulk_reject_complete']='Clientes rejeitados: %s'; // %s = number of customers
$hesklang['customer_manage_delete']='Excluir cliente';
$hesklang['customer_manage_bulk_delete']='Excluir clientes selecionados';
$hesklang['customer_manage_bulk_delete_complete']='Clientes excluídos: %s'; // %s = number of customers
$hesklang['customer_manage_edit']='Editar cliente';
$hesklang['customer_manage_verification_email_sent']='Email de verificação enviado para %s'; // %s = customer's email
$hesklang['can_man_customers']='Gerir clientes';
$hesklang['can_view_customers']='Visualizar todos os clientes (mas não gerenciá-los)';
$hesklang['import_customer_select_file']='Selecionar ficheiro';
$hesklang['import_customer_step1_instructions']='Para importar clientes, prepare um ficheiro CSV (Valores Separados por Vírgulas).';
$hesklang['import_customer_step1_note']='Selecione o seu ficheiro CSV';
$hesklang['import_customer_step1_separator']='As colunas no meu ficheiro CSV estão separadas por';
$hesklang['import_customer_sample']='&raquo; Exemplos de ficheiros CSV';
$hesklang['import_customer_sample_1']='Ficheiro CSV ao estilo dos EUA com colunas separadas por ,';
$hesklang['import_customer_sample_2']='Ficheiro CSV ao estilo da UE com colunas separadas por ;';
$hesklang['import_customer_upload_requirements_1']='O seu ficheiro CSV deve incluir pelo menos uma coluna com nome ou endereço de email. A coluna de palavra-passe é opcional.';
$hesklang['import_customer_upload_requirements_2']='A primeira linha do seu ficheiro deve conter os cabeçalhos das colunas.';
$hesklang['import_customer_upload_requirements_3']='O seu ficheiro deve estar codificado em UTF-8.';
$hesklang['import_customer_select_columns']='Selecionar Colunas';
$hesklang['import_customer_upload_customers']='Carregar Clientes';
$hesklang['import_customer_column_name']='Coluna de Nome';
$hesklang['import_customer_column_email']='Coluna de Email';
$hesklang['import_customer_column_pass']='Coluna de Palavra-passe';
$hesklang['import_customer_step2_note']='Selecione o nome correto da coluna do seu ficheiro CSV nos menus suspensos e clique em "Próximo".';
$hesklang['import_customer_name_or_email_required']='Nome ou email é obrigatório';
$hesklang['import_customer_step3_note']='Os seus clientes estão a ser importados. Não saia desta página!';
$hesklang['import_customer_step3_pending']='Pendente';
$hesklang['import_customer_step3_successful_imports']='Importações Bem-sucedidas';
$hesklang['import_customer_step3_failed_imports']='Importações Falhadas';
$hesklang['import_customer_step3_progress']='Progresso';
$hesklang['import_customer_step3_complete_some_failed']='O processo de importação está concluído, no entanto <b>%s</b> clientes não foram importados. Verifique a tabela abaixo para mais informações.'; // %s == number of failed imports
$hesklang['import_customer_step3_complete']='O processo de importação está concluído!';
$hesklang['import_customer_step3_importing']='A importar';
$hesklang['staff_deleted']='[Equipa Eliminada]';
$hesklang['customer_account_approved']='Registo de cliente aprovado';
$hesklang['customer_account_rejected']='Registo de cliente rejeitado';
$hesklang['customer_account_deleted']='Registo de cliente eliminado';
$hesklang['ticket_followers']='Seguidores do ticket';
$hesklang['ticket_followers2']='Permitir que os tickets tenham múltiplos clientes';
$hesklang['add_cc']='Adicionar Cc';
$hesklang['cc']='Cc';
$hesklang['cc_help']='Separe cada email com uma vírgula.';
$hesklang['search_customers']='Procurar Clientes';
$hesklang['page_size']='Tamanho da Página';
$hesklang['customers_on_pages']='Número de clientes: %d | Número de páginas: %d'; // First %d is replaced with number of customers, second %d with number of pages
$hesklang['desc_customer_reset_password']='(Cliente) Redefinir a sua palavra-passe';
$hesklang['desc_customer_verify_registration']='(Cliente) Verificar o seu registo';
$hesklang['desc_customer_verify_new_email']='(Cliente) Verificar o seu novo email';
$hesklang['desc_customer_approved']='(Cliente) Conta aprovada';
$hesklang['desc_customer_rejected']='(Cliente) Conta rejeitada';
$hesklang['desc_email_rejected_can_self_register']='(Cliente) Ticket via email rejeitado; o cliente pode registar-se sozinho';
$hesklang['desc_email_rejected_cannot_self_register']='(Cliente) Ticket via email rejeitado; o cliente não pode registar-se sozinho';
$hesklang['user_added_success_no_pass']='Novo utilizador %s foi adicionado com sucesso';
$hesklang['email_tag_requester']='Solicitante (De)';
$hesklang['email_tag_requester_name']='Nome do Solicitante (De)';
$hesklang['email_tag_requester_first_name']='Primeiro Nome do Solicitante (De)';
$hesklang['email_tag_requester_email']='Email do Solicitante (De)';
$hesklang['email_tag_followers']='Seguidores (Cc)';
$hesklang['email_tag_follower_names']='Nomes dos Seguidores (Cc)';
$hesklang['email_tag_follower_emails']='Emails dos Seguidores (Cc)';
$hesklang['barcode']='Código de Barras';
$hesklang['barcode_use']='Exibir um código de barras em tickets impressos';
$hesklang['barcode_staff_only']='Ocultar o código de barras dos clientes';
$hesklang['barcode_type']='Tipo de Código de Barras';
$hesklang['barcode_format']='Formato';
$hesklang['barcode_width']='Largura';
$hesklang['barcode_height']='Altura';
$hesklang['barcode_color']='Cor';
$hesklang['barcode_bg']='Fundo';
$hesklang['copy_link']='Copiar link do ticket';
$hesklang['copy_link_title']='Copiar link público para este ticket';
$hesklang['copy_link_exp']='O link copiado é o link direto para o cliente visualizar este ticket';
$hesklang['copy_value']='Copiar este valor';
$hesklang['download_class']='Esta funcionalidade requer a classe ZipArchive. Solicite ao seu anfitrião para compilar o PHP com suporte a zip.';
$hesklang['download_all']='Baixar tudo';
$hesklang['download_prep']='Preparando download...';
$hesklang['download_tma']='Muitos anexos';
$hesklang['download_nva']='Nenhum anexo válido';
$hesklang['download_ntd']='Nada para baixar';
$hesklang['resolved_at']='Resolvido em';
$hesklang['disable_GSSAPI']='Desativar autenticação GSSAPI (solução para erro Kerberos)';
$hesklang['ex_history']='Incluir o histórico de log do ticket na exportação';
$hesklang['sm_location']='Local'; // Location (page) of a service message
$hesklang['loc_sm']='Exibir esta mensagem de serviço em:';
$hesklang['loc_all']='Todas as páginas do cliente';
$hesklang['loc_norec']='(não recomendado)';
$hesklang['loc_home']='Página inicial do help desk';
$hesklang['loc_selected']='Em páginas selecionadas';
$hesklang['loc_selerr']='Selecione pelo menos uma página para exibir a mensagem';
$hesklang['loc_t_cat']='Enviar um ticket - selecionar uma categoria';
$hesklang['loc_t_add']='Enviar um ticket - formulário para enviar um ticket';
$hesklang['loc_t_ok']='Enviar um ticket - confirmação do ticket';
$hesklang['loc_t_view']='Visualizar um ticket';
$hesklang['loc_t_form']='Formulário para visualizar um ticket';
$hesklang['loc_kb_main']='Página inicial da base de conhecimentos';
$hesklang['loc_kb_sub']='Páginas de subcategorias da base de conhecimentos';
$hesklang['loc_kb_art']='Artigos da base de conhecimentos';
$hesklang['loc_login']='Página de login do cliente';
$hesklang['loc_register']='Página de registo do cliente';
$hesklang['loc_register_ok']='Registo do cliente concluído';
$hesklang['loc_acc']='Página "Os meus tickets" do cliente';
$hesklang['loc_profile']='Página "Perfil" do cliente';
$hesklang['sending_show']='Exibir notificação de "A enviar"';
$hesklang['sending_wait']='A enviar, por favor, aguarde...';
$hesklang['e_c_email']='Insira o endereço de email correto para visualizar este ticket';
$hesklang['only_verified_cc']='Seguidores sem uma conta verificada serão ignorados.';
$hesklang['followers_removed']='Os seguintes endereços de email foram removidos do ticket porque não possuem uma conta verificada:';
$hesklang['novace']='Não encontramos nenhuma conta registada e verificada com este endereço de email.';
$hesklang['max_recipients']='Máximo de destinatários';
$hesklang['max_recipients2']='em um único email';
$hesklang['admin_js']='JS do Admin';
$hesklang['admin_js2']='Carregar um ficheiro Javascript personalizado extra para o painel de administração';
$hesklang['cf_limit_all']='Você atingiu o limite de campos personalizados e não pode criar novos.';
$hesklang['remind_assigned']='Lembrar a equipa atribuída';
$hesklang['remind_sent']='Lembrete enviado para o membro da equipa atribuído';
$hesklang['thist23']='<li class="smaller">%s | lembrete enviado para %s por %s</li>';
$hesklang['ql_bookmarks']='Favoritos';
$hesklang['bookmark']='Meu Favorito';
$hesklang['bookmarks_add']='Adicionar aos Favoritos';
$hesklang['bookmarks_added']='Este ticket foi adicionado aos seus Favoritos';
$hesklang['bookmarks_remove']='Remover dos Favoritos';
$hesklang['bookmarks_removed']='Este ticket foi removido dos seus Favoritos';
$hesklang['genl_not_copied']='Erro: Copiar para a área de transferência não é suportado neste dispositivo/navegador.';
$hesklang['profile_duplicate_email']='O utilizador com o email <b>%s</b> já existe.'; // %s: new email
$hesklang['seq_id_numeric']='A pesquisa pelo número do ticket deve conter apenas números';
$hesklang['confirm_new_pass']='Confirmar nova palavra-passe';
$hesklang['piping_notify_rejected_customers1']='Emails de rejeição para clientes';
$hesklang['piping_notify_rejected_customers2']='Enviar um email de rejeição para clientes quando seu ticket é rejeitado';
$hesklang['piping_notify_rejected_customers3']='Intervalo de tempo entre emails de rejeição';
$hesklang['register_url']='URL de Registo';
$hesklang['email_subject']='Assunto do Email';

// Added in version 3.6.0
$hesklang['collaborator_added']='[#%%TRACK_ID%%] Collaborating on ticket: %%SUBJECT%%';
$hesklang['collaborator_staff_reply']='[#%%TRACK_ID%%] Staff replied to: %%SUBJECT%%';
$hesklang['collaborator_note']='[#%%TRACK_ID%%] Note added to: %%SUBJECT%%';
$hesklang['collaborator_overdue']='[#%%TRACK_ID%%] Ticket overdue: %%SUBJECT%%';
$hesklang['collaborator_resolved']='[#%%TRACK_ID%%] Ticket resolved: %%SUBJECT%%';
$hesklang['satisfaction']['ignore']='Data limite para envio de e-mail de seguimento:'; // do not send emails to tickets resolved before cutoff date
$hesklang['satisfaction']['ignore_before']='Não enviar e-mails para pedidos resolvidos há mais de'; // ... more than [X days] ago
$hesklang['satisfaction']['ignore_after']='atrás (deve ser um período mais longo que "%s")'; // ... more than [X days] ago
$hesklang['satisfaction']['wrong_cutoff']='O período da data limite de e-mail deve ser maior do que o atraso do e-mail de seguimento';
$hesklang['available_language']='Idiomas Disponíveis';
$hesklang['click_to_show_available_language']='Clique para mostrar os idiomas disponíveis';
$hesklang['install_lan']='Instalar';
$hesklang['remove_lan']='Remover';
$hesklang['title_lan']='Título';
$hesklang['description_lan']='Descrição';
$hesklang['completed_lan']='Concluído';
$hesklang['no_language_availble']='Nenhum idioma disponível';
$hesklang['success_install_lan_txt']='idioma adicionado com sucesso';
$hesklang['error_install_lan_txt']='não foi possível adicionar o idioma';
$hesklang['success_remove_lan_txt']='idioma removido com sucesso';
$hesklang['error_remove_lan_txt']='não foi possível remover o idioma';
$hesklang['remove_default_language_error']='O idioma predefinido deve permanecer ativo e não pode ser removido';
$hesklang['click_for_manual_step']='Clique para instalação manual';
$hesklang['upgrade_lan']='Atualizar';
$hesklang['success_upgrade_lan_txt']='idioma atualizado com sucesso';
$hesklang['error_upgrade_lan_txt']='não foi possível atualizar o idioma';
$hesklang['please_wait']='Por favor, aguarde...';
$hesklang['add_a_note']='Adicionar uma nota';
$hesklang['add_a_reply']='Adicionar uma resposta';
$hesklang['customer_id']='ID do Cliente';
$hesklang['deleting_customer_tickets']='Pedidos abertos pelo cliente: <b>%1$s</b><br>O que devemos fazer com estes pedidos?'; // %1$s = number of tickets
$hesklang['deleting_customer_follower']='Pedidos onde o cliente está em cópia: <b>%1$s</b><br>Estes deixarão de ter este cliente como seguidor; os pedidos permanecem inalterados.'; // %1$s = number of tickets
$hesklang['deleting_customer_delete_tickets2']='Eliminar pedidos permanentemente';
$hesklang['deleting_customer_anonymize_tickets2']='Anonimizar pedidos (remover mensagens e dados pessoais)';
$hesklang['deleting_customer_retain_tickets2']='Manter pedidos (deixar todos os dados intactos)';
$hesklang['for_staff']='para a equipa de suporte'; // Setting enabled: "for help desk staff"
$hesklang['for_customers']='para os clientes'; // Setting enabled: "for customers"
$hesklang['imap_mailbox_txt']='Caixa de Correio IMAP';
$hesklang['file_attachment_options']='Opções de Anexos em E-mails';
$hesklang['link_to_attachments_in_emails']='Ligar aos anexos nos e-mails';
$hesklang['add_attachments_directly_to_emails']='Adicionar anexos diretamente aos e-mails';
$hesklang['directly_attach_file_smaller_than']='Anexar diretamente apenas ficheiros menores que';
$hesklang['directly_attach_file_of_any_size']='Anexar diretamente ficheiros de qualquer tamanho';
$hesklang['directly_attach_only_first_x_attachments']='Anexar diretamente apenas os primeiros';
$hesklang['directly_attach_all_attachments']='Anexar diretamente todos os anexos';
$hesklang['directly_attach_size']='Tamanho do anexo';
$hesklang['directly_attach_no_of_files']='Número de ficheiros';
$hesklang['notice_about_directly_attach_files']='Anexar muitos ou grandes ficheiros aos e-mails pode causar atrasos ao comunicar com o servidor SMTP';
$hesklang['fatt_2']='Ficheiros adicionais anexados a esta mensagem:';
$hesklang['no_collaborators']='Nenhum';
$hesklang['collaborate']='Colaborar neste pedido';
$hesklang['collaborators']='Colaboradores';
$hesklang['ql_cbm']='Colaborador';
$hesklang['collaborating']='Está agora a colaborar neste pedido';
$hesklang['not_collaborating']='Deixou de colaborar neste pedido';
$hesklang['add_collaborator']='Adicionar colaborador';
$hesklang['user_collaborator_added']='Utilizador adicionado como colaborador neste pedido';
$hesklang['remove_collaborator']='Remover colaborador';
$hesklang['staff_name']='Nome do colaborador';
$hesklang['user_collaborator_removed']='Utilizador removido como colaborador neste pedido';
$hesklang['desc_collaborator_added']='(Equipa) Está a colaborar num novo pedido';
$hesklang['desc_collaborator_staff_reply']='(Equipa) Um membro da equipa respondeu a um pedido colaborado';
$hesklang['desc_collaborator_note']='(Equipa) Nova nota adicionada a um pedido colaborado';
$hesklang['desc_collaborator_resolved']='(Equipa) Um pedido colaborado foi resolvido';
$hesklang['desc_collaborator_overdue']='(Equipa) Um pedido colaborado está em atraso';
$hesklang['notify_collaborator_added']='Fui adicionado como colaborador de um pedido';
$hesklang['notify_collaborator_customer_reply']='Cliente respondeu a um pedido colaborado';
$hesklang['notify_collaborator_staff_reply']='Equipa respondeu a um pedido colaborado';
$hesklang['notify_collaborator_note']='Equipa adicionou uma nota a um pedido colaborado';
$hesklang['notify_collaborator_resolved']='Equipa resolveu um pedido colaborado';
$hesklang['notify_collaborator_overdue']='Pedido colaborado está em atraso';
$hesklang['recurring_tickets']['tab']='Pedidos Recorrentes'; // Menu link
$hesklang['recurring_tickets']['page_title']='Pedidos Recorrentes'; // Page H2 title
$hesklang['recurring_tickets']['intro']='Automatize tarefas repetitivas; deixe o Hesk gerar pedidos rotineiros por si, exatamente quando precisar.';
$hesklang['recurring_tickets']['active_rules']='Regras ativas';
$hesklang['recurring_tickets']['new']='Nova regra de pedido recorrente';
$hesklang['recurring_tickets']['no_rules']='Não tem nenhuma regra de pedido recorrente. Crie uma clicando no botão "Nova regra de pedido recorrente" acima.';
$hesklang['recurring_tickets']['title']='Título da regra';
$hesklang['recurring_tickets']['titlet']='Um título descritivo, por exemplo: Reatribuir pedidos sem resposta em 24h';
$hesklang['recurring_tickets']['default_title']='Regra de %1$s'; // Default rule title; %1$s = user name
$hesklang['recurring_tickets']['trigger']='Acionador da regra';
$hesklang['recurring_tickets']['trigt']='Defina a condição que irá acionar esta regra.';
$hesklang['recurring_tickets']['hits']='Acionamentos'; // How many times a rule has been triggered
$hesklang['recurring_tickets']['step1']='Hora de Criação'; // Title of step 1 when creating/editing a rule
$hesklang['recurring_tickets']['step2']='Definições Gerais'; // Title of step 2 when creating/editing a rule
$hesklang['recurring_tickets']['step3']='Campos Personalizados'; // Title of step 3 when creating/editing a rule
$hesklang['recurring_tickets']['step4']='Conteúdo'; // Title of step 4 when creating/editing a rule
$hesklang['recurring_tickets']['delete']='Eliminar esta regra?';
$hesklang['recurring_tickets']['edit']='A editar a regra de pedido recorrente ID %1$s'; // %1$s = rule ID number
$hesklang['recurring_tickets']['within']='Dentro de:';
$hesklang['recurring_tickets']['minutes']='minutos';
$hesklang['recurring_tickets']['hours']='horas';
$hesklang['recurring_tickets']['days']='dias';
$hesklang['recurring_tickets']['weeks']='semanas';
$hesklang['recurring_tickets']['months']='meses';
$hesklang['recurring_tickets']['years']='anos';
$hesklang['recurring_tickets']['setpri']='Definir prioridade para:';
$hesklang['recurring_tickets']['setsta']='Definir estado para:';
$hesklang['recurring_tickets']['assto']='Atribuir pedido a:';
$hesklang['recurring_tickets']['asm']='Outro membro da equipa';
$hesklang['recurring_tickets']['notify']='Notificar membros da equipa...';
$hesklang['recurring_tickets']['ato']='Aplicar a:';
$hesklang['recurring_tickets']['save']='Guardar regra';
$hesklang['recurring_tickets']['e_tt']='O tempo deve estar entre 1 e 10000';
$hesklang['recurring_tickets']['nocat']='Selecione pelo menos uma categoria';
$hesklang['recurring_tickets']['nouser']='Selecione pelo menos um utilizador';
$hesklang['recurring_tickets']['nostatus']='Selecione pelo menos um estado';
$hesklang['recurring_tickets']['nocata']='%1$s não tem acesso a estas categorias:'; // %1$s = user name
$hesklang['recurring_tickets']['rule_added']='Nova regra criada';
$hesklang['recurring_tickets']['mdf']='As definições da regra foram guardadas';
$hesklang['recurring_tickets']['e_id']='Não foi encontrada nenhuma regra com este ID';
$hesklang['recurring_tickets']['deleted']='A regra selecionada foi eliminada';
$hesklang['recurring_tickets']['log_title']='Regra #%1$s (%2$s)'; // Used in ticket history log. %1$s = rule ID, %2$s = rule title
$hesklang['recurring_tickets']['active']='Ativa'; // Is the rule active (live)?
$hesklang['recurring_tickets']['activate']='Ativar esta regra (começar a usar)';
$hesklang['recurring_tickets']['activated']='A regra selecionada foi ativada'; // %1$s = rule log title
$hesklang['recurring_tickets']['deactivate']='Desativar esta regra (parar de usar)';
$hesklang['recurring_tickets']['deactivated']='A regra selecionada foi desativada'; // %1$s = rule log title
$hesklang['recurring_tickets']['no_active']='Sem regras de pedidos recorrentes ativas';
$hesklang['recurring_tickets']['tools']='Ferramentas';
$hesklang['recurring_tickets']['tbef']='Antes de uma regra estar ativa, precisa de a ativar clicando na caixa na coluna "ATIVA".<br><br><strong>As regras ativas são processadas a cada %2$s minutos.</strong>'; // %1$s = replaced by icon, %2$s = number of minutes, usually 5 or more
$hesklang['recurring_tickets']['r']='[REGRA]';
$hesklang['recurring_tickets']['r2']='[REGRA] Regra #%s';
$hesklang['recurring_tickets']['r3']='Regra #%s';
$hesklang['recurring_tickets']['i']='[INFO]';
$hesklang['recurring_tickets']['matched']='Número de pedidos já criados hoje: %1$s'; // %1$s = number of tickets
$hesklang['recurring_tickets']['reset']='Repor esta regra';
$hesklang['recurring_tickets']['reset2']='Tem a certeza de que deseja repor esta regra?<br><br>Os acionamentos voltarão a 0 e qualquer pedido já gerado hoje poderá ser recriado na próxima execução cron.';
$hesklang['recurring_tickets']['reset3']='A regra selecionada foi reposta';
$hesklang['recurring_tickets']['test']='Simular esta regra';
$hesklang['recurring_tickets']['testa']='Simular todas as regras';
$hesklang['recurring_tickets']['testaa']='Simular todas as regras ativas';
$hesklang['recurring_tickets']['testr']='Resultados da simulação';
$hesklang['recurring_tickets']['rsim']='Repetir simulação';
$hesklang['recurring_tickets']['sim']='MODO SIMULAÇÃO, sem alterações à base de dados';
$hesklang['recurring_tickets']['sic']='SIMULAÇÃO CONCLUÍDA';
$hesklang['recurring_tickets']['rrule_type_required']='Por favor, selecione um acionador de regra válido.';
$hesklang['recurring_tickets']['rrule_string_required']='Por favor, preencha todas as opções obrigatórias do acionador da regra.';
$hesklang['recurring_tickets']['rrule_invalid_interval']='Introduza um intervalo de 1 ou superior para "A cada".';
$hesklang['recurring_tickets']['disable_note']='*Se alguma definição crítica do Hesk for alterada após a criação de uma regra, esta será desativada na próxima tentativa de execução e terá de ser editada para cumprir os novos requisitos.';
$hesklang['recurring_tickets']['thist1']='<li class="smaller">%1$s | submetido pela Regra de Pedido Recorrente "%2$s"</li>'; // Used in ticket history log. %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist2']='<li class="smaller">%1$s | atribuído a %2$s pela Regra "%3$s"</li>'; // %1$s = date,  %2$s = assignee, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist3']='<li class="smaller">%1$s | fechado automaticamente pela Regra "%2$s"</li>'; // %1$s = date, %2$s = rule log title (above)
$hesklang['recurring_tickets']['thist9']='<li class="smaller">%1$s | estado alterado para %2$s pela Regra "%3$s"</li>'; // %1$s = date, %2$s new status, %3$s = rule log title (above)
$hesklang['recurring_tickets']['thist10']='<li class="smaller">%1$s | atribuído automaticamente a %2$s pela Regra "%3$s"</li>'; // %1$s = date, %2$s = new owner, %3$s = rule log title (above)
$hesklang['recurring_tickets']['rule_was_disabled']='A regra foi desativada devido a erros de validação. Verifique abaixo os detalhes.';
$hesklang['recurring_tickets']['errors_title']='Uma ou mais das suas regras produziram erros ao tentar executar e foram desativadas.';
$hesklang['recurring_tickets']['rule_errors']='<hr>Erros da Regra #%s:';
$hesklang['recurring_tickets']['create_customers']='Não existem clientes - crie-os <a href="%s" target="_blank">aqui</a>.';
$hesklang['recurring_tickets']['exec_dates']='Datas de execução da regra';
$hesklang['recurring_tickets']['show_exec_dates']='[Mostrar datas de execução da regra]';
$hesklang['recurring_tickets']['no_exec_dates']='Selecione acionadores de regra válidos para ver as datas de execução.';
$hesklang['recurring_tickets']['invalid_disabled']='definições inválidas - regra desativada.';
$hesklang['recurring_tickets']['next_occ']='Próximas ocorrências da regra %s:';
$hesklang['recurring_tickets']['occ_on']='em %s';
$hesklang['recurring_tickets']['not_firing_today']='não precisa de ser executada hoje.';
$hesklang['recurring_tickets']['rules_fulfilled']='regras recorrentes cumpridas - pedido criado hoje!';
$hesklang['recurring_tickets']['validation_failed']='falha de validação - regra desativada. Detalhes abaixo:';
$hesklang['recurring_tickets']['validation_error']='Erro de validação:';
$hesklang['recurring_tickets']['processed']='processado.';
$hesklang['recurring_tickets']['created_ticket']='pedido criado id: %1$s, id de rastreio: %2$s';
$hesklang['recurring_tickets']['due_date_note']='relativo à data de criação do pedido';
$hesklang['priorities']='Prioridades';
$hesklang['priority_intro']='Use esta ferramenta para gerir as prioridades dos pedidos no seu sistema de suporte';
$hesklang['new_priority']='Nova prioridade';
$hesklang['edit_priority']='Editar prioridade';
$hesklang['priority_title']='Título';
$hesklang['can_customers_select_it']='Os clientes podem selecionar esta prioridade?';
$hesklang['selected_by_customer']='Selecionável pelos clientes';
$hesklang['err_priority']='Introduza o título da prioridade';
$hesklang['priority_added']='Uma nova prioridade foi adicionada';
$hesklang['priority_e_id']='ID de prioridade inválido';
$hesklang['priority_mdf']='Prioridade guardada com sucesso';
$hesklang['priority_deleted']='Prioridade eliminada';
$hesklang['priority_not_found']='Esta prioridade não existe';
$hesklang['priority_not_empty']='Esta prioridade não pode ser eliminada porque existem pedidos com esta prioridade';
$hesklang['click_to_enable_drag_drop']='Clique para ativar o arrastar-e-soltar para a linha, depois arraste-a para reorganizar as prioridades.';
$hesklang['confirm_delete_priority']='Tem a certeza de que deseja eliminar esta prioridade?';
$hesklang['reordered_message']='A nova ordem das prioridades foi guardada.';
$hesklang['list_tkt_priority']='Listar todos os pedidos com esta prioridade';
$hesklang['deletion_priority_restricted']='Esta é uma prioridade especial e não pode ser eliminada';
$hesklang['priority_limit']='Não pode criar mais prioridades';
$hesklang['skip_to_main_content']='Saltar para o conteúdo principal';
$hesklang['opens_dialog']='Abre um diálogo';
$hesklang['create_a_ticket']='Criar um pedido';
$hesklang['toggle_navigation']='Alternar navegação';
$hesklang['add_a_ticket_reply']='Adicionar resposta ao pedido';
$hesklang['linked_tickets']='Pedidos ligados';
$hesklang['no_linked_tickets']='Sem pedidos ligados';
$hesklang['link_ticket']='Ligar pedido';
$hesklang['can_link_tickets_e']='Não tem autorização para ligar/desligar este pedido';
$hesklang['link_ticket_success']='O pedido foi ligado com sucesso';
$hesklang['link_ticket_required_error']='Para ligar um pedido, forneça um ID de rastreio válido';
$hesklang['link_ticket_itself_error']='Um pedido não pode ser ligado a si próprio. Por favor introduza um ID de rastreio diferente';
$hesklang['already_linked_error']='O pedido já está ligado';
$hesklang['unlink_success']='O pedido foi desligado com sucesso';
$hesklang['unlink_error']='Não existe nenhum registo ligado';
$hesklang['link_history']='<li class="smaller">%s | pedido %s ligado por %s</li>';
$hesklang['unlink_history']='<li class="smaller">%s | pedido %s desligado por %s</li>';
$hesklang['can_link_tickets']='Pode ligar pedidos';
$hesklang['link_a_ticket']='Ligar um pedido';
$hesklang['mfa_curl']='Não foi possível gerar uma imagem QR para digitalizar porque o <strong>cURL</strong> não está ativado no seu servidor.';
$hesklang['require_xml']='O PHP-XML tem de estar ativado para mensagens em Rich Text (HTML). Peça ao seu alojamento web para ativar XML para PHP.';
$hesklang['thist24']='<li class="smaller">%1$s | %2$s adicionado como colaborador por %3$s</li>';
$hesklang['thist25']='<li class="smaller">%1$s | %2$s removido como colaborador por %3$s</li>';
$hesklang['recurring_tickets']['intro2']='Perfeito para manutenções preventivas, revisões mensais de acessos, check-ins recorrentes com clientes e muito mais.';
$hesklang['recurring_tickets']['feat1']='<strong>Defina e esqueça os agendamentos.</strong> Diariamente, todas as segundas, todos os marços, no dia 15 de cada mês ou em qualquer data futura';
$hesklang['recurring_tickets']['feat2']='<strong>Chegam pré-preenchidos e atribuídos.</strong> Escolha a categoria, prioridade, agente e até 100 campos personalizados';
$hesklang['recurring_tickets']['feat3']='<strong>Pré-visualize e simule.</strong> Veja cada pedido que o Hesk irá gerar antes de ativar uma regra, sem surpresas.';
$hesklang['unlink_btn']='Desligar';

// DO NOT CHANGE BELOW
if (!defined('IN_SCRIPT')) die('PHP syntax OK!');