/**
 * Artyom.js requires webkitSpeechRecognition and speechSynthesis APIs
 *
 * @license MIT
 * @version 1.0.1
 * @copyright 2016 Our Code World All Rights Reserved.
 * @author Carlos Delgado - www.ourcodeworld.com
 * @param {Object} window
 * @see https://sdkcarlos.github.io/sites/artyom.html
 * @returns {Object} artyom
 */
 !function(a){"use strict";function j(){this.soundex=function(a){var b=a.toLowerCase().split(""),c=b.shift(),d="",e={a:"",e:"",i:"",o:"",u:"",b:1,f:1,p:1,v:1,c:2,g:2,j:2,k:2,q:2,s:2,x:2,z:2,d:3,t:3,l:4,m:5,n:5,r:6};return d=c+b.map(function(a,b,c){return e[a]}).filter(function(a,b,d){return 0===b?a!==e[c]:a!==d[b-1]}).join(""),(d+"000").slice(0,4).toUpperCase()}}function k(){var k={},l=[],m=new j;k.device=i,k.getVoices=function(){return a.speechSynthesis.getVoices()},k.getAvailableCommands=function(){for(var a=[],b=0;b<l.length;b++){var c=l[b],d={};d.indexes=c.indexes,c.smart&&(d.smart=!0),c.description&&(d.description=c.description),a.push(d)}return a},k.initialize=function(a){if("object"!=typeof a)return void console.error("You must give the configuration for start artyom properly.");if(a.hasOwnProperty("lang")){switch(a.lang){case"de":case"de-DE":h=f.german;break;case"en-GB":h=f.englishGB;break;case"pt":case"pt-br":case"pt-PT":h=f.brasilian;break;case"ru":case"ru-RU":h=f.russia;break;case"nl":case"nl-NL":h=f.holand;break;case"es":case"es-CO":case"es-ES":h=f.spanish;break;case"en":case"en-US":h=f.englishUSA;break;case"fr":case"fr-FR":h=f.france;break;case"it":case"it-IT":h=f.italian;break;case"jp":case"ja-JP":h=f.japanese;break;case"id":case"id-ID":h=f.indonesia;break;case"pl":case"pl-PL":h=f.polski;break;case"zh-CN":h=f.mandarinChinese;break;case"zh-HK":h=f.cantoneseChinese;break;case"native":h=f.native;break;default:console.warn("The given language for artyom is not supported yet. English has been set to default")}c.lang=a.lang}return a.hasOwnProperty("continuous")&&(a.continuous?(c.continuous=!0,e.restartRecognition=!0):(c.continuous=!1,e.restartRecognition=!1)),a.hasOwnProperty("speed")&&(c.speed=a.speed),a.hasOwnProperty("soundex")&&(c.soundex=a.soundex),a.hasOwnProperty("executionKeyword")&&(c.executionKeyword=a.executionKeyword),a.hasOwnProperty("obeyKeyword")&&(c.obeyKeyword=a.obeyKeyword),a.hasOwnProperty("volume")&&(c.volume=a.volume),a.hasOwnProperty("listen")&&(c.listen=a.listen),a.hasOwnProperty("debug")?c.debug=a.debug:console.warn("The initialization doesn't provide how the debug mode should be handled. Is recommendable to set this value either to true or false."),a.mode&&(c.mode=a.mode),c.listen===!0&&q(),!0},k.fatality=function(){try{return e.restartRecognition=!1,b.stop(),!0}catch(a){return console.log(a),!1}},k.addCommands=function(a){var b=function(a){a.hasOwnProperty("indexes")?l.push(a):(console.error("The following command doesn't provide any index to execute :"),console.dir(a))};if(a instanceof Array)for(var c=0;c<a.length;c++)b(a[c]);else b(a);return!0},k.removeCommands=function(a){if("string"==typeof a){for(var b=[],c=0;c<l.length;c++){var d=l[c];d.indexes.indexOf(a)&&b.push(c)}for(var e=0;e<b.length;e++)l.splice(e,1)}return b},k.emptyCommands=function(){return l=[]},k.shutUp=function(){if("speechSynthesis"in a)do a.speechSynthesis.cancel();while(a.speechSynthesis.pending===!0);c.speaking=!1,k.clearGarbageCollection()},k.getProperties=function(){return c};var n=function(a,b){var c=new CustomEvent(a,{detail:b});return document.dispatchEvent(c),c};k.when=function(a,b){return document.addEventListener(a,function(a){b(a.detail)},!1)},k.getLanguage=function(){switch(h){case"Google UK English Male":return"en-GB";case"Google español":return"es-CO";case"Google Deutsch":return"de-DE";case"Google français":return"fr-FR";case"Google italiano":return"it-IT";case"Google 日本人":return"ja-JP";case"Google US English":return"en-US";case"Google português do Brasil":return"pt-BR";case"Google русский":return"ru-RU";case"Google Nederlands":return"nl-NL";case"Google polski":return"pl-PL";case"Google Bahasa Indonesia":return"id-ID";case"Google 普通话（中国大陆）":return"zh-CN";case"Google 粤語（香港）":return"zh-HK";case"native":return"native"}};var o=function(b,e,f,i){var j=new SpeechSynthesisUtterance;j.text=b,j.volume=c.volume,j.rate=c.speed,h&&(j.voice=speechSynthesis.getVoices().filter(function(a){return a.name==h})[0]),1==e&&j.addEventListener("start",function(){c.speaking=!0,k.debug("Event reached : "+g.SPEECH_SYNTHESIS_START),n(g.SPEECH_SYNTHESIS_START),i&&"function"==typeof i.onStart&&i.onStart.call(j)}),e>=f&&j.addEventListener("end",function(){c.speaking=!1,k.debug("Event reached : "+g.SPEECH_SYNTHESIS_END),n(g.SPEECH_SYNTHESIS_END),i&&"function"==typeof i.onEnd&&i.onEnd.call(j)}),k.debug(e+" text chunk processed succesfully out of "+f),d.push(j),a.speechSynthesis.speak(j)},p=function(a,b){a=a||"",b=b||100;for(var c=b,d=0,e=[];a[c];)" "==a[c++]&&(e.push(a.substring(d,c)),d=c,c+=b);return e.push(a.substr(d)),e};k.say=function(a,b){var d=115;if(k.speechSupported())if("string"==typeof a)if(a.length>0){var e=[];if(a.length>d){var f=a.split(/,|:|\.|;/);f.forEach(function(a,b){if(a.length>d){var c=p(a,d);e.push.apply(e,c)}else e.push(a)})}else e.push(a);e=e.filter(function(a){return a}),e.forEach(function(a,c){var d=c+1;a&&o(a,d,e.length,b)}),c.helpers.lastSay={text:a,date:new Date}}else console.warn("Artyom expects a string to say ... none given.");else console.warn("Artyom expects a string to say ... "+typeof a+" given.")},k.repeatLastSay=function(a){var b=c.helpers.lastSay;return a?b:void(null!=b&&k.say(b.text))},k.speechSupported=function(){return"speechSynthesis"in a},k.recognizingSupported=function(){return"webkitSpeechRecognition"in a};var q=function(){var a,d;b.continuous=!0,b.interimResults=!0,b.lang=c.lang,b.onstart=function(){k.debug("Event reached : "+g.COMMAND_RECOGNITION_START),n(g.COMMAND_RECOGNITION_START),c.recognizing=!0,d=!0},b.onerror=function(b){n(g.ERROR,{code:b.error}),"audio-capture"==b.error&&(d=!1),"not-allowed"==b.error&&(d=!1,b.timeStamp-a<100?n(g.ERROR,{code:"info-blocked",message:"Artyom needs the permision of the microphone, is blocked."}):n(g.ERROR,{code:"info-denied",message:"Artyom needs the permision of the microphone, is denied"}))},b.onend=function(){e.restartRecognition===!0?(d===!0?(b.start(),k.debug("Continuous mode enabled, restarting","info")):console.error("Verify the microphone and check for the table of errors in sdkcarlos.github.io/sites/artyom.html to solve your problem. If you want to give your user a message when an error appears add an artyom listener"),n(g.COMMAND_RECOGNITION_END,{code:"continuous_mode_enabled",message:"OnEnd event reached with continuous mode"})):n(g.COMMAND_RECOGNITION_END,{code:"continuous_mode_disabled",message:"OnEnd event reached without continuous mode"}),c.recognizing=!1};var f;if("normal"==c.mode&&(f=function(a){if(!l.length)return void k.debug("No commands to process in normal mode.");var d=a.results.length;n(g.TEXT_RECOGNIZED);for(var e=a.resultIndex;e<d;++e){var f=a.results[e][0].transcript;if(a.results[e].isFinal){var h=r(f.trim());if("function"==typeof c.helpers.redirectRecognizedTextOutput&&c.helpers.redirectRecognizedTextOutput(f,!0),h!==!1&&1==c.recognizing){k.debug("<< Executing Matching Recognition in normal mode >>","info"),b.stop(),c.recognizing=!1,h.wildcard?h.objeto.action(h.indice,h.wildcard.item,h.wildcard.full):h.objeto.action(h.indice);break}}else{if("function"==typeof c.helpers.redirectRecognizedTextOutput&&c.helpers.redirectRecognizedTextOutput(f,!1),"string"==typeof c.executionKeyword&&f.indexOf(c.executionKeyword)!=-1){var h=r(f.replace(c.executionKeyword,"").trim());if(h!==!1&&1==c.recognizing){k.debug("<< Executing command ordered by ExecutionKeyword >>","info"),b.stop(),c.recognizing=!1,h.wildcard?h.objeto.action(h.indice,h.wildcard.item,h.wildcard.full):h.objeto.action(h.indice);break}}k.debug("Normal mode : "+f)}}}),"quick"==c.mode&&(f=function(a){if(!l.length)return void k.debug("No commands to process.");var d=a.results.length;n(g.TEXT_RECOGNIZED);for(var e=a.resultIndex;e<d;++e){var f=a.results[e][0].transcript;if(a.results[e].isFinal){var h=r(f.trim());if("function"==typeof c.helpers.redirectRecognizedTextOutput&&c.helpers.redirectRecognizedTextOutput(f,!1),h!==!1&&1==c.recognizing){k.debug("<< Executing Matching Recognition in quick mode >>","info"),b.stop(),c.recognizing=!1,h.wildcard?h.objeto.action(h.indice,h.wildcard.item):h.objeto.action(h.indice);break}}else{var h=r(f.trim());if("function"==typeof c.helpers.redirectRecognizedTextOutput&&c.helpers.redirectRecognizedTextOutput(f,!0),h!==!1&&1==c.recognizing){k.debug("<< Executing Matching Recognition in quick mode >>","info"),b.stop(),c.recognizing=!1,h.wildcard?h.objeto.action(h.indice,h.wildcard.item):h.objeto.action(h.indice);break}}k.debug("Quick mode : "+f)}}),"remote"==c.mode&&(f=function(a){var b=a.results.length;if(n(g.TEXT_RECOGNIZED),"function"!=typeof c.helpers.remoteProcessorHandler)return k.debug("The remoteProcessorService is undefined.","warn");for(var d=a.resultIndex;d<b;++d){var e=a.results[d][0].transcript;c.helpers.remoteProcessorHandler({text:e,isFinal:a.results[d].isFinal})}}),b.onresult=function(a){if(c.obeying)f(a);else{if(!c.obeyKeyword)return;for(var b="",d="",e=0;e<a.results.length;++e)a.results[e].final?b+=a.results[e][0].transcript:d+=a.results[e][0].transcript;k.debug("Artyom is not obeying","warn"),(d.indexOf(c.obeyKeyword)>-1||b.indexOf(c.obeyKeyword)>-1)&&(c.obeying=!0)}},c.recognizing)b.stop(),k.debug("Event reached : "+g.COMMAND_RECOGNITION_END),n(g.COMMAND_RECOGNITION_END);else try{b.start()}catch(a){n(g.ERROR,{code:"recognition_overlap",message:"A webkitSpeechRecognition instance has been started while there's already running. Is recommendable to restart the Browser"})}};k.simulateInstruction=function(a){if(!a||"string"!=typeof a)return console.warn("Cannot execute a non string command"),!1;var b=r(a);return"object"!=typeof b?(console.warn("No command founded trying with "+a),!1):b.objeto?(b.objeto.smart?(k.debug("Smart command matches with simulation, executing","info"),b.objeto.action(b.indice,b.wildcard.item,b.wildcard.full)):(k.debug("Command matches with simulation, executing","info"),b.objeto.action(b.indice)),!0):void 0};var r=function(a){if(!a)return console.warn("Internal error: Execution of empty command"),!1;k.debug(">> "+a);for(var b=0;b<l.length;b++){for(var d=l[b],e=d.indexes,f=-1,h=0;h<e.length;h++){var i=e[h];if(d.smart){if(i.indexOf("*")!=-1){var j=i.split("*");if(j.length>2){console.warn("Artyom found a smart command with "+(j.length-1)+" wildcards. Artyom only support 1 wildcard for each command. Sorry");continue}var o=j[0],p=j[1];if(""==p||" "==p){if(a.indexOf(o)!=-1||a.toLowerCase().indexOf(o.toLowerCase())!=-1){var q=a.replace(o,"");q=q.toLowerCase().replace(o.toLowerCase(),""),f=parseInt(h)}}else if(!(a.indexOf(o)==-1&&a.toLowerCase().indexOf(o.toLowerCase())==-1||a.indexOf(p)==-1&&a.toLowerCase().indexOf(p.toLowerCase())==-1)){var q=a.replace(o,"").replace(p,"");q=q.toLowerCase().replace(o.toLowerCase(),"").replace(p.toLowerCase(),""),q=q.toLowerCase().replace(p.toLowerCase(),""),f=parseInt(h)}}else console.warn("Founded command marked as SMART but have no wildcard in the indexes, remove the SMART for prevent extensive memory consuming or add the wildcard *");if(f>=0){f=parseInt(h);break}}}if(f>=0)return n(g.COMMAND_MATCHED),{indice:f,objeto:d,wildcard:{item:q,full:a}}}for(var b=0;b<l.length;b++){for(var d=l[b],e=d.indexes,f=-1,h=0;h<e.length;h++){var i=e[h];if(!d.smart){if(a===i){k.debug(">> MATCHED FULL EXACT OPTION "+i+" AGAINST "+a+" WITH INDEX "+h+" IN COMMAND ","info"),f=parseInt(h);break}if(a.toLowerCase()===i.toLowerCase()){k.debug(">> MATCHED OPTION CHANGING ALL TO LOWERCASE "+i+" AGAINST "+a+" WITH INDEX "+h+" IN COMMAND ","info"),f=parseInt(h);break}}}if(f>=0)return n(g.COMMAND_MATCHED),{indice:f,objeto:d}}for(var b=0;b<l.length;b++){for(var d=l[b],e=d.indexes,f=-1,h=0;h<e.length;h++)if(!d.smart){var i=e[h];if(a.indexOf(i)>=0){k.debug(">> MATCHED INDEX EXACT OPTION "+i+" AGAINST "+a+" WITH INDEX "+h+" IN COMMAND ","info"),f=parseInt(h);break}if(a.toLowerCase().indexOf(i.toLowerCase())>=0){k.debug(">> MATCHED INDEX OPTION CHANGING ALL TO LOWERCASE "+i+" AGAINST "+a+" WITH INDEX "+h+" IN COMMAND ","info"),f=parseInt(h);break}}if(f>=0)return n(g.COMMAND_MATCHED),{indice:f,objeto:d}}if(c.soundex)for(var b=0;b<l.length;b++)for(var d=l[b],e=d.indexes,f=-1,h=0;h<e.length;h++){var i=e[h];if(!d.smart&&m.soundex(a)==m.soundex(i))return k.debug(">> Matched Soundex command '"+i+"' AGAINST '"+a+"' with index "+h,"info"),f=parseInt(h),n(g.COMMAND_MATCHED),{indice:f,objeto:d}}return!1};return k.debug=function(a,b){if(c.debug===!0)switch(b){case"error":console.log(" %cArtyom.js  "+a,"background: #C12127; color: #FFFFFF");break;case"warn":console.warn(a);break;case"info":console.log(" %cArtyom.js:  "+a,"background: #4285F4; color: #FFFFFF");break;default:console.log(" %cArtyom.js %c  "+a,"background: #005454; color: #BFF8F8","color:black;")}},k.detectErrors=function(){if("file:"==a.location.protocol){var b="Fatal Error Detected : It seems you're running the artyom demo from a local file ! The SpeechRecognitionAPI Needs to be hosted someway (server as http or https). Artyom will NOT work here, Sorry.";return console.error(b),{code:"artyom_error_localfile",message:b}}if(!k.device.isChrome){var b="Fatal Error Detected: You are not running Google Chrome ! SpeechRecognitionAPI and SpeechSynthesisAPI is only available in google chrome ! ";return console.error(b),{code:"artyom_error_browser_unsupported",message:b}}return"https:"!=a.location.protocol&&console.warn("Artyom is not running in HTTPS protocol,running in protocol : "+a.location.protocol+" that means the browser will ask the permission of microphone too often. You need a HTTPS Connection if you want artyom in continuous mode !"),!1},k.redirectRecognizedTextOutput=function(a){return"function"!=typeof a?(console.warn("Expected function to handle the recognized text ..."),!1):(c.helpers.redirectRecognizedTextOutput=a,!0)},k.sayRandom=function(a){if(a instanceof Array){var b=Math.floor(Math.random()*a.length);return k.say(a[b]),{text:a[b],index:b}}return console.error("Random quotes must be in an array !"),null},k.newDictation=function(a){if(!k.recognizingSupported())return console.error("SpeechRecognition is not supported in this browser"),!1;var b=new webkitSpeechRecognition;return b.continuous=!0,b.interimResults=!0,b.lang=c.lang,b.onresult=function(b){for(var c="",d="",e=0;e<b.results.length;++e)b.results[e].final?c+=b.results[e][0].transcript:d+=b.results[e][0].transcript;a.onResult&&a.onResult(d,c)},new function(){var c=b,d=!0,e=!1;this.onError=null,this.start=function(){a.continuous===!0&&(e=!0),c.onstart=function(){"function"==typeof a.onStart&&d===!0&&a.onStart()},c.onend=function(){e===!0?(d=!1,c.start()):(d=!0,"function"==typeof a.onEnd&&a.onEnd())},c.start()},this.stop=function(){e=!1,c.stop()},"function"==typeof a.onError&&(c.onerror=a.onError)}},k.newPrompt=function(a){"object"!=typeof a&&console.error("Expected the prompt configuration.");var b=Object.assign([],l);k.emptyCommands();var c={description:"Setting the artyom commands only for the prompt. The commands will be restored after the prompt finishes",indexes:a.options,action:function(c,d){l=b;var e=a.onMatch(c,d);return"function"!=typeof e?void console.error("onMatch function expects a returning function to be executed"):void e()}};a.smart&&(c.smart=!0),k.addCommands(c),"undefined"!=typeof a.beforePrompt&&a.beforePrompt(),k.say(a.question,{onStart:function(){"undefined"!=typeof a.onStartPrompt&&a.onStartPrompt()},onEnd:function(){"undefined"!=typeof a.onEndPrompt&&a.onEndPrompt()}})},k.extensions=function(){return{}},k.getNativeApi=function(){return b},k.isRecognizing=function(){return c.recognizing},k.isSpeaking=function(){return c.speaking},k.clearGarbageCollection=function(){return d=[]},k.getGarbageCollection=function(){return d},k.setDebug=function(a){return a?c.debug=!0:c.debug=!1},k.dontObey=function(){return c.obeying=!1},k.obey=function(){return c.obeying=!0},k.isObeying=function(){return c.obeying},k.getVersion=function(){return"1.0.1"},k.on=function(a,b){return{then:function(c){var d={indexes:a,action:c};b&&(d.smart=!0),k.addCommands(d)}}},k.remoteProcessorService=function(a){return c.helpers.remoteProcessorHandler=a,!0},k}if(a.hasOwnProperty("speechSynthesis")&&speechSynthesis.getVoices(),a.hasOwnProperty("webkitSpeechRecognition"))var b=new webkitSpeechRecognition;var c={lang:"en-GB",recognizing:!1,continuous:!1,speed:1,volume:1,listen:!1,mode:"normal",debug:!1,helpers:{redirectRecognizedTextOutput:null,remoteProcessorHandler:null,lastSay:null},executionKeyword:null,obeyKeyword:null,speaking:!1,obeying:!0,soundex:!1},d=[],e={restartRecognition:!1},f={german:"Google Deutsch",spanish:"Google español",italian:"Google italiano",japanese:"Google 日本人",englishUSA:"Google US English",englishGB:"Google UK English Male",brasilian:"Google português do Brasil",russia:"Google русский",holand:"Google Nederlands",france:"Google français",polski:"Google polski",indonesia:"Google Bahasa Indonesia",mandarinChinese:"Google 普通话（中国大陆）",cantoneseChinese:"Google 粤語（香港）",native:"native"},g={ERROR:"ERROR",SPEECH_SYNTHESIS_START:"SPEECH_SYNTHESIS_START",SPEECH_SYNTHESIS_END:"SPEECH_SYNTHESIS_END",TEXT_RECOGNIZED:"TEXT_RECOGNIZED",COMMAND_RECOGNITION_START:"COMMAND_RECOGNITION_START",COMMAND_RECOGNITION_END:"COMMAND_RECOGNITION_END",COMMAND_MATCHED:"COMMAND_MATCHED"},h="Google UK English Male",i={isMobile:!1,isChrome:!0};(navigator.userAgent.match(/Android/i)||navigator.userAgent.match(/webOS/i)||navigator.userAgent.match(/iPhone/i)||navigator.userAgent.match(/iPad/i)||navigator.userAgent.match(/iPod/i)||navigator.userAgent.match(/BlackBerry/i)||navigator.userAgent.match(/Windows Phone/i))&&(i.isMobile=!0),navigator.userAgent.indexOf("Chrome")==-1&&(i.isChrome=!1),"undefined"==typeof artyom?a.artyom=Object.preventExtensions(new k):console.info("Artyom has been already defined in the Window")}(window);
