
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `phpbuilder1800`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admins`
--

CREATE TABLE `[[dbprefix]]admins` (
  `profileId` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(40) NOT NULL,
  `password` varchar(120) NOT NULL,
  `email` varchar(120) NOT NULL,
  `firstName` varchar(50) DEFAULT NULL,
  `lastName` varchar(50) DEFAULT NULL,
  `sex` enum('male','female') NOT NULL DEFAULT 'male',
  `lang` varchar(5) NOT NULL DEFAULT 'en_US',
  `timeZone` varchar(6) NOT NULL DEFAULT '-6',
  `joinDate` datetime DEFAULT NULL,
  `lastActivity` datetime DEFAULT NULL,
  `lastEdit` datetime DEFAULT NULL,
  `ban` enum('0','1') DEFAULT '0',
  `ip` varchar(45) NOT NULL DEFAULT '127.0.0.1',
  `isTwoFactorAuth` enum('1','0') DEFAULT '0',
  `twoFactorAuthSecret` varchar(40) DEFAULT NULL,
  `hashValidation` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`profileId`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]admins`
--

INSERT INTO `[[dbprefix]]admins` VALUES
(1, '[[admin_username]]', '[[admin_pass]]', '[[admin_email]]', '[[admin_fname]]', '[[admin_lname]]', 'male', 'en_US', '-6', '[[regtime]]', '[[regtime]]', NULL, '0', '[[clientip]]', '0', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admins_attempts_login`
--

CREATE TABLE `[[dbprefix]]admins_attempts_login` (
  `attemptsId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(45) NOT NULL DEFAULT '',
  `attempts` smallint(5) unsigned NOT NULL,
  `lastLogin` datetime NOT NULL,
  PRIMARY KEY (`attemptsId`),
  UNIQUE KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admins_log_login`
--

CREATE TABLE `[[dbprefix]]admins_log_login` (
  `logId` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) NOT NULL DEFAULT '',
  `username` varchar(64) NOT NULL DEFAULT '',
  `password` varchar(40) DEFAULT NULL,
  `status` varchar(60) NOT NULL DEFAULT '',
  `ip` varchar(45) NOT NULL DEFAULT '',
  `dateTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`logId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]admins_log_sess`
--

CREATE TABLE `[[dbprefix]]admins_log_sess` (
  `sessionId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `profileId` tinyint(3) unsigned NOT NULL,
  `username` varchar(40) DEFAULT NULL,
  `email` varchar(120) DEFAULT NULL,
  `firstName` varchar(50) DEFAULT NULL,
  `lastName` varchar(50) DEFAULT NULL,
  `ip` varchar(45) NOT NULL DEFAULT '127.0.0.1',
  `dateTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`sessionId`),
  KEY `profileId` (`profileId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ads`
--

CREATE TABLE `[[dbprefix]]ads` (
  `adsId` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) DEFAULT NULL,
  `code` text,
  `active` enum('1','0') DEFAULT '1',
  `width` smallint(3) unsigned DEFAULT NULL,
  `height` smallint(3) unsigned DEFAULT NULL,
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `clicks` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`adsId`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]ads`
--

INSERT INTO `[[dbprefix]]ads` VALUES
(1, 'Sponsor pH7Builder 1 (728x90)', '<a href="#0"><img data-src="holder.js/728x90" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 728, 90, 0, 0),
(2, 'Sponsor pH7Builder 2 (728x90)', '<a href="#0"><img data-src="holder.js/728x90" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 728, 90, 0, 0),
(3, 'Sponsor pH7Builder 3 (200x200)', '<a href="#0"><img data-src="holder.js/200x200" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 200, 200, 0, 0),
(4, 'Sponsor pH7Builder 4 (200x200)', '<a href="#0"><img data-src="holder.js/200x200" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 200, 200, 0, 0),
(5, 'Sponsor pH7Builder 5 (250x250)', '<a href="#0"><img data-src="holder.js/250x250" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 250, 250, 0, 0),
(6, 'Sponsor pH7Builder 6 (250x250)', '<a href="#0"><img data-src="holder.js/250x250" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 250, 250, 0, 0),
(7, 'Sponsor pH7Builder 7 (468x60)', '<a href="#0"><img data-src="holder.js/468x60" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 468, 60, 0, 0),
(8, 'Sponsor pH7Builder 8 (468x60)', '<a href="#0"><img data-src="holder.js/468x60" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 468, 60, 0, 0),
(9, 'Sponsor pH7Builder 9 (300x250)', '<a href="#0"><img data-src="holder.js/300x250" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 300, 250, 0, 0),
(10, 'Sponsor pH7Builder 10 (300x250)', '<a href="#0"><img data-src="holder.js/300x250" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 300, 250, 0, 0),
(11, 'Sponsor pH7Builder 11 (336x280)', '<a href="#0"><img data-src="holder.js/336x280" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 336, 280, 0, 0),
(12, 'Sponsor pH7Builder 12 (336x280)', '<a href="#0"><img data-src="holder.js/336x280" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 336, 280, 0, 0),
(13, 'Sponsor pH7Builder 13 (120x600)', '<a href="#0"><img data-src="holder.js/120x600" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 120, 600, 0, 0),
(14, 'Sponsor pH7Builder 14 (120x600)', '<a href="#0"><img data-src="holder.js/120x600" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 120, 600, 0, 0),
(15, 'Sponsor pH7Builder 15 (160x600)', '<a href="#0"><img data-src="holder.js/160x600" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 160, 600, 0, 0),
(16, 'Sponsor pH7Builder 16 (160x600)', '<a href="#0"><img data-src="holder.js/160x600" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 160, 600, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ads_affiliates`
--

CREATE TABLE `[[dbprefix]]ads_affiliates` (
  `adsId` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) DEFAULT NULL,
  `code` text,
  `active` enum('1','0') DEFAULT '1',
  `width` smallint(3) unsigned DEFAULT NULL,
  `height` smallint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`adsId`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]ads_affiliates`
--

INSERT INTO `[[dbprefix]]ads_affiliates` VALUES
(1, 'Affiliate Banner 1 (728x90)', '<a href="%affiliate_url%"><img data-src="holder.js/728x90" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 728, 90),
(2, 'Affiliate Banner 2 (728x90)', '<a href="%affiliate_url%/signup"><img data-src="holder.js/728x90" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 728, 90),
(3, 'Affiliate Banner 3 (200x200)', '<a href="%affiliate_url%"><img data-src="holder.js/200x200" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 200, 200),
(4, 'Affiliate Banner 4 (200x200)', '<a href="%affiliate_url%/signup"><img data-src="holder.js/200x200" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 200, 200),
(5, 'Affiliate Banner 5 (250x250)', '<a href="%affiliate_url%"><img data-src="holder.js/250x250" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 250, 250),
(6, 'Affiliate Banner 6 (250x250)', '<a href="%affiliate_url%/signup"><img data-src="holder.js/250x250" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 250, 250),
(7, 'Affiliate Banner 7 (468x60)', '<a href="%affiliate_url%"><img data-src="holder.js/468x60" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 468, 60),
(8, 'Affiliate Banner 8 (468x60)', '<a href="%affiliate_url%/signup"><img data-src="holder.js/468x60" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 468, 60),
(9, 'Affiliate Banner 9 (300x250)', '<a href="%affiliate_url%"><img data-src="holder.js/300x250" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 300, 250),
(10, 'Affiliate Banner 10 (300x250)', '<a href="%affiliate_url%/signup"><img data-src="holder.js/300x250" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 300, 250),
(11, 'Affiliate Banner 11 (336x280)', '<a href="%affiliate_url%"><img data-src="holder.js/336x280" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 336, 280),
(12, 'Affiliate Banner 12 (336x280)', '<a href="%affiliate_url%/signup"><img data-src="holder.js/336x280" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 336, 280),
(13, 'Affiliate Banner 13 (120x600)', '<a href="%affiliate_url%"><img data-src="holder.js/120x600" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 120, 600),
(14, 'Affiliate Banner 14 (120x600)', '<a href="%affiliate_url%/signup"><img data-src="holder.js/120x600" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 120, 600),
(15, 'Affiliate Banner 15 (160x600)', '<a href="%affiliate_url%"><img data-src="holder.js/160x600" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 160, 600),
(16, 'Affiliate Banner 16 (160x600)', '<a href="%affiliate_url%/signup"><img data-src="holder.js/160x600" alt="%site_name% by %software_name%" title="%site_name% powered by %software_name%" /></a>', '0', 160, 600);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]affiliates`
--

CREATE TABLE `[[dbprefix]]affiliates` (
  `profileId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(40) NOT NULL,
  `firstName` varchar(50) NOT NULL,
  `lastName` varchar(50) NOT NULL,
  `password` varchar(120) NOT NULL,
  `email` varchar(120) NOT NULL,
  `sex` enum('male','female') NOT NULL DEFAULT 'male',
  `birthDate` date DEFAULT NULL,
  `ip` varchar(45) NOT NULL DEFAULT '127.0.0.1',
  `bankAccount` varchar(150) DEFAULT NULL,
  `amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `totalPayment` decimal(8,2) NOT NULL DEFAULT '0.00',
  `lastPayment` decimal(8,2) NOT NULL DEFAULT '0.00',
  `lastPaymentDate` datetime DEFAULT NULL,
  `lang` varchar(5) NOT NULL DEFAULT 'en_US',
  `hashValidation` varchar(40) DEFAULT NULL,
  `isTwoFactorAuth` enum('1','0') DEFAULT '0',
  `twoFactorAuthSecret` varchar(40) DEFAULT NULL,
  `refer` int(10) unsigned DEFAULT '0',
  `joinDate` datetime DEFAULT NULL,
  `lastActivity` datetime DEFAULT NULL,
  `lastEdit` datetime DEFAULT NULL,
  `affiliatedId` int(10) unsigned NOT NULL DEFAULT '0',
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `ban` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`profileId`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `bankAccount` (`bankAccount`),
  KEY `birthDate` (`birthDate`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]affiliates`
--

INSERT INTO `[[dbprefix]]affiliates` VALUES
(1, 'lisa-langosh', 'Elisabeth', 'Barton', '$2y$12$Df10gQ.VZb70urtp2GjG8Opl1mG9rZ4dklUNMCQrOZri7qi.I3N6q', 'arnaldo75@volkman.biz', 'male', '1965-02-18', '30.237.27.99', 'laverne40@little.com', 0.00, 0.00, 0.00, NULL, 'ur_IN', NULL, '0', NULL, 0, '[[regtime]]', '[[regtime]]', NULL, 0, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]affiliates_attempts_login`
--

CREATE TABLE `[[dbprefix]]affiliates_attempts_login` (
  `attemptsId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(45) NOT NULL DEFAULT '',
  `attempts` smallint(5) unsigned NOT NULL,
  `lastLogin` datetime NOT NULL,
  PRIMARY KEY (`attemptsId`),
  UNIQUE KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]affiliates_countries`
--

CREATE TABLE `[[dbprefix]]affiliates_countries` (
  `countryId` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `countryCode` char(2) NOT NULL,
  PRIMARY KEY (`countryId`),
  UNIQUE KEY `countryCode` (`countryCode`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=243 ;

--
-- Dumping data for table `[[dbprefix]]affiliates_countries`
--

INSERT INTO `[[dbprefix]]affiliates_countries` VALUES
(1, 'AD'),
(2, 'AE'),
(3, 'AF'),
(4, 'AG'),
(5, 'AI'),
(6, 'AL'),
(7, 'AM'),
(8, 'AN'),
(9, 'AO'),
(10, 'AQ'),
(11, 'AR'),
(12, 'AS'),
(13, 'AT'),
(14, 'AU'),
(15, 'AW'),
(16, 'AX'),
(17, 'AZ'),
(18, 'BA'),
(19, 'BB'),
(20, 'BD'),
(21, 'BE'),
(22, 'BF'),
(23, 'BG'),
(24, 'BH'),
(25, 'BI'),
(26, 'BJ'),
(27, 'BM'),
(28, 'BN'),
(29, 'BO'),
(30, 'BR'),
(31, 'BS'),
(32, 'BT'),
(33, 'BV'),
(34, 'BW'),
(35, 'BY'),
(36, 'BZ'),
(37, 'CA'),
(38, 'CC'),
(39, 'CD'),
(40, 'CF'),
(41, 'CG'),
(42, 'CH'),
(43, 'CI'),
(44, 'CK'),
(45, 'CL'),
(46, 'CM'),
(47, 'CN'),
(48, 'CO'),
(49, 'CR'),
(50, 'CU'),
(51, 'CV'),
(52, 'CX'),
(53, 'CY'),
(54, 'CZ'),
(55, 'DE'),
(56, 'DJ'),
(57, 'DK'),
(58, 'DM'),
(59, 'DO'),
(60, 'DZ'),
(61, 'EC'),
(62, 'EE'),
(63, 'EG'),
(64, 'EH'),
(65, 'ER'),
(66, 'ES'),
(67, 'ET'),
(68, 'FI'),
(69, 'FJ'),
(70, 'FK'),
(71, 'FM'),
(72, 'FO'),
(73, 'FR'),
(74, 'FX'),
(75, 'GA'),
(76, 'GD'),
(77, 'GE'),
(78, 'GF'),
(79, 'GH'),
(80, 'GI'),
(81, 'GL'),
(82, 'GM'),
(83, 'GN'),
(84, 'GP'),
(85, 'GQ'),
(86, 'GR'),
(87, 'GS'),
(88, 'GT'),
(89, 'GU'),
(90, 'GW'),
(91, 'GY'),
(92, 'HK'),
(93, 'HM'),
(94, 'HN'),
(95, 'HR'),
(96, 'HT'),
(97, 'HU'),
(98, 'ID'),
(99, 'IE'),
(100, 'IL'),
(101, 'IN'),
(102, 'IO'),
(103, 'IQ'),
(104, 'IR'),
(105, 'IS'),
(106, 'IT'),
(107, 'JM'),
(108, 'JO'),
(109, 'JP'),
(110, 'KE'),
(111, 'KG'),
(112, 'KH'),
(113, 'KI'),
(114, 'KM'),
(115, 'KN'),
(116, 'KP'),
(117, 'KR'),
(118, 'KW'),
(119, 'KY'),
(120, 'KZ'),
(121, 'LA'),
(122, 'LB'),
(123, 'LC'),
(124, 'LI'),
(125, 'LK'),
(126, 'LR'),
(127, 'LS'),
(128, 'LT'),
(129, 'LU'),
(130, 'LV'),
(131, 'LY'),
(132, 'MA'),
(133, 'MC'),
(134, 'MD'),
(135, 'ME'),
(136, 'MG'),
(137, 'MH'),
(138, 'MK'),
(139, 'ML'),
(140, 'MM'),
(141, 'MN'),
(142, 'MO'),
(143, 'MP'),
(144, 'MQ'),
(145, 'MR'),
(146, 'MS'),
(147, 'MT'),
(148, 'MU'),
(149, 'MV'),
(150, 'MW'),
(151, 'MX'),
(152, 'MY'),
(153, 'MZ'),
(154, 'NA'),
(155, 'NC'),
(156, 'NE'),
(157, 'NF'),
(158, 'NG'),
(159, 'NI'),
(160, 'NL'),
(161, 'NO'),
(162, 'NP'),
(163, 'NR'),
(164, 'NU'),
(165, 'NZ'),
(166, 'OM'),
(167, 'PA'),
(168, 'PE'),
(169, 'PF'),
(170, 'PG'),
(171, 'PH'),
(172, 'PK'),
(173, 'PL'),
(174, 'PM'),
(175, 'PN'),
(176, 'PR'),
(177, 'PT'),
(178, 'PW'),
(179, 'PY'),
(180, 'QA'),
(181, 'RE'),
(182, 'RO'),
(183, 'RS'),
(184, 'RU'),
(185, 'RW'),
(186, 'SA'),
(187, 'SB'),
(188, 'SC'),
(189, 'SD'),
(190, 'SE'),
(191, 'SG'),
(192, 'SH'),
(193, 'SI'),
(194, 'SJ'),
(195, 'SK'),
(196, 'SL'),
(197, 'SM'),
(198, 'SN'),
(199, 'SO'),
(200, 'SR'),
(201, 'ST'),
(202, 'SV'),
(203, 'SY'),
(204, 'SZ'),
(205, 'TC'),
(206, 'TD'),
(207, 'TF'),
(208, 'TG'),
(209, 'TH'),
(210, 'TJ'),
(211, 'TK'),
(212, 'TM'),
(213, 'TN'),
(214, 'TO'),
(215, 'TP'),
(216, 'TR'),
(217, 'TT'),
(218, 'TV'),
(219, 'TW'),
(220, 'TZ'),
(221, 'UA'),
(222, 'UG'),
(223, 'UK'),
(224, 'UM'),
(225, 'US'),
(226, 'UY'),
(227, 'UZ'),
(228, 'VA'),
(229, 'VC'),
(230, 'VE'),
(231, 'VG'),
(232, 'VI'),
(233, 'VN'),
(234, 'VU'),
(235, 'WF'),
(236, 'WS'),
(237, 'XK'),
(238, 'YE'),
(239, 'YT'),
(240, 'ZA'),
(241, 'ZM'),
(242, 'ZW');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]affiliates_info`
--

CREATE TABLE `[[dbprefix]]affiliates_info` (
  `profileId` int(10) unsigned NOT NULL,
  `middleName` varchar(50) DEFAULT NULL,
  `businessName` varchar(100) DEFAULT NULL,
  `taxId` varchar(40) DEFAULT NULL,
  `address` varchar(191) DEFAULT NULL,
  `country` char(2) DEFAULT NULL,
  `city` varchar(150) DEFAULT NULL,
  `state` varchar(150) DEFAULT NULL,
  `zipCode` varchar(20) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  `description` text,
  `website` varchar(120) DEFAULT NULL,
  PRIMARY KEY (`profileId`),
  KEY `country` (`country`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]affiliates_info`
--

INSERT INTO `[[dbprefix]]affiliates_info` VALUES
(1, '', NULL, NULL, NULL, 'IL', 'South Garett', '', '33760', '863.577.8421', 'Et esse accusantium et cum eligendi. Officia labore sit labore rerum sequi aut.', 'https://pierrehenry.be');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]affiliates_log_login`
--

CREATE TABLE `[[dbprefix]]affiliates_log_login` (
  `logId` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) NOT NULL DEFAULT '',
  `username` varchar(64) NOT NULL DEFAULT '',
  `password` varchar(40) DEFAULT NULL,
  `status` varchar(60) NOT NULL DEFAULT '',
  `ip` varchar(45) NOT NULL DEFAULT '',
  `dateTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`logId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]affiliates_log_sess`
--

CREATE TABLE `[[dbprefix]]affiliates_log_sess` (
  `sessionId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `profileId` int(10) unsigned NOT NULL,
  `username` varchar(40) DEFAULT NULL,
  `email` varchar(120) DEFAULT NULL,
  `firstName` varchar(50) DEFAULT NULL,
  `lastName` varchar(50) DEFAULT NULL,
  `ip` varchar(45) NOT NULL DEFAULT '127.0.0.1',
  `dateTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`sessionId`),
  KEY `profileId` (`profileId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]albums_pictures`
--

CREATE TABLE `[[dbprefix]]albums_pictures` (
  `albumId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `profileId` int(10) unsigned NOT NULL,
  `name` varchar(80) NOT NULL,
  `thumb` char(11) NOT NULL,
  `approved` enum('1','0') DEFAULT '1',
  `votes` int(9) unsigned DEFAULT '0',
  `score` float unsigned DEFAULT '0',
  `views` int(10) unsigned DEFAULT '0',
  `description` varchar(191) DEFAULT NULL,
  `createdDate` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`albumId`),
  KEY `profileId` (`profileId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]albums_videos`
--

CREATE TABLE `[[dbprefix]]albums_videos` (
  `albumId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `profileId` int(10) unsigned NOT NULL,
  `name` varchar(80) NOT NULL,
  `thumb` char(11) NOT NULL,
  `approved` enum('1','0') DEFAULT '1',
  `votes` int(9) unsigned DEFAULT '0',
  `score` float unsigned DEFAULT '0',
  `views` int(10) unsigned DEFAULT '0',
  `description` varchar(191) DEFAULT NULL,
  `createdDate` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`albumId`),
  KEY `profileId` (`profileId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]analytics_api`
--

CREATE TABLE `[[dbprefix]]analytics_api` (
  `analyticsId` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(32) DEFAULT NULL,
  `code` text,
  `active` enum('1','0') DEFAULT '1',
  PRIMARY KEY (`analyticsId`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]analytics_api`
--

INSERT INTO `[[dbprefix]]analytics_api` VALUES
(1, 'Analytics Code', '', '1');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_countries`
--

CREATE TABLE `[[dbprefix]]block_countries` (
  `countryId` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `countryCode` char(2) NOT NULL,
  PRIMARY KEY (`countryId`),
  UNIQUE KEY `countryCode` (`countryCode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]block_ip`
--

CREATE TABLE `[[dbprefix]]block_ip` (
  `ipId` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(45) NOT NULL,
  `expiration` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`ip`),
  KEY `ipId` (`ipId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blogs`
--

CREATE TABLE `[[dbprefix]]blogs` (
  `blogId` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `postId` varchar(60) NOT NULL,
  `langId` char(2) NOT NULL DEFAULT '',
  `title` varchar(100) DEFAULT NULL,
  `content` longtext NOT NULL,
  `pageTitle` varchar(100) NOT NULL,
  `metaDescription` varchar(191) NOT NULL,
  `metaKeywords` varchar(191) NOT NULL,
  `slogan` varchar(191) NOT NULL,
  `metaRobots` varchar(50) NOT NULL,
  `metaAuthor` varchar(50) NOT NULL,
  `metaCopyright` varchar(50) NOT NULL,
  `tags` varchar(191) DEFAULT NULL,
  `votes` int(9) unsigned DEFAULT '0',
  `score` float unsigned DEFAULT '0',
  `views` int(10) unsigned DEFAULT '0',
  `enableComment` enum('1','0') DEFAULT '1',
  `createdDate` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`blogId`),
  UNIQUE KEY `postId` (`postId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blogs_categories`
--

CREATE TABLE `[[dbprefix]]blogs_categories` (
  `categoryId` smallint(4) unsigned NOT NULL,
  `blogId` mediumint(10) unsigned NOT NULL,
  KEY `categoryId` (`categoryId`),
  KEY `blogId` (`blogId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]blogs_data_categories`
--

CREATE TABLE `[[dbprefix]]blogs_data_categories` (
  `categoryId` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`categoryId`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=21 ;

--
-- Dumping data for table `[[dbprefix]]blogs_data_categories`
--

INSERT INTO `[[dbprefix]]blogs_data_categories` VALUES
(1, 'Affiliate'),
(2, 'Business'),
(3, 'Company'),
(4, 'Dating'),
(5, 'Education'),
(6, 'Family'),
(7, 'Food'),
(8, 'Game'),
(9, 'Health'),
(10, 'Hobby'),
(11, 'Movie'),
(12, 'Music'),
(13, 'News'),
(14, 'Programming'),
(15, 'Recreation'),
(16, 'Shopping'),
(17, 'Society'),
(18, 'Sports'),
(19, 'Technology'),
(20, 'Travel');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]bottom_menus`
--

CREATE TABLE `[[dbprefix]]bottom_menus` (
  `menuId` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `vendorName` varchar(40) NOT NULL,
  `moduleName` varchar(40) NOT NULL,
  `controllerName` varchar(40) NOT NULL,
  `actionName` varchar(40) NOT NULL,
  `vars` varchar(60) DEFAULT NULL,
  `parentMenu` smallint(4) unsigned DEFAULT NULL,
  `grandParentMenu` smallint(4) unsigned DEFAULT NULL,
  `active` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`menuId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments_blog`
--

CREATE TABLE `[[dbprefix]]comments_blog` (
  `commentId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sender` int(10) unsigned NOT NULL,
  `recipient` mediumint(10) unsigned NOT NULL,
  `comment` text NOT NULL,
  `createdDate` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  `approved` enum('1','0') NOT NULL DEFAULT '1',
  PRIMARY KEY (`commentId`),
  KEY `recipient` (`recipient`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments_note`
--

CREATE TABLE `[[dbprefix]]comments_note` (
  `commentId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sender` int(10) unsigned NOT NULL,
  `recipient` int(10) unsigned NOT NULL,
  `comment` text NOT NULL,
  `createdDate` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  `approved` enum('1','0') NOT NULL DEFAULT '1',
  PRIMARY KEY (`commentId`),
  KEY `recipient` (`recipient`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments_picture`
--

CREATE TABLE `[[dbprefix]]comments_picture` (
  `commentId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sender` int(10) unsigned NOT NULL,
  `recipient` int(10) unsigned NOT NULL,
  `comment` text NOT NULL,
  `createdDate` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  `approved` enum('1','0') NOT NULL DEFAULT '1',
  PRIMARY KEY (`commentId`),
  KEY `recipient` (`recipient`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments_profile`
--

CREATE TABLE `[[dbprefix]]comments_profile` (
  `commentId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sender` int(10) unsigned NOT NULL,
  `recipient` int(10) unsigned NOT NULL,
  `comment` text NOT NULL,
  `createdDate` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  `approved` enum('1','0') DEFAULT '1',
  PRIMARY KEY (`commentId`),
  KEY `recipient` (`recipient`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]comments_video`
--

CREATE TABLE `[[dbprefix]]comments_video` (
  `commentId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sender` int(10) unsigned NOT NULL,
  `recipient` int(10) unsigned NOT NULL,
  `comment` text NOT NULL,
  `createdDate` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  `approved` enum('1','0') NOT NULL DEFAULT '1',
  PRIMARY KEY (`commentId`),
  KEY `recipient` (`recipient`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]custom_code`
--

CREATE TABLE `[[dbprefix]]custom_code` (
  `code` text,
  `codeType` enum('css','js') NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]custom_code`
--

INSERT INTO `[[dbprefix]]custom_code` VALUES
('/* Your custom CSS code here */\r\n', 'css'),
('/* Your custom JS code here */\r\n', 'js');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forums`
--

CREATE TABLE `[[dbprefix]]forums` (
  `forumId` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL DEFAULT 'New forum',
  `description` varchar(191) NOT NULL,
  `categoryId` smallint(4) unsigned DEFAULT NULL,
  `createdDate` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`forumId`),
  KEY `categoryId` (`categoryId`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]forums`
--

INSERT INTO `[[dbprefix]]forums` VALUES
(1, 'Hello', 'Free dating site', 1, NULL, NULL),
(2, 'Online Dating', 'Discussion about the online dating websites', 2, NULL, NULL),
(3, 'The Best Dating Site', 'The best dating site', 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forums_categories`
--

CREATE TABLE `[[dbprefix]]forums_categories` (
  `categoryId` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`categoryId`),
  UNIQUE KEY `title` (`title`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]forums_categories`
--

INSERT INTO `[[dbprefix]]forums_categories` VALUES
(3, 'Business'),
(2, 'Free Online Dating Site'),
(1, 'General');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forums_messages`
--

CREATE TABLE `[[dbprefix]]forums_messages` (
  `messageId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `topicId` int(10) unsigned NOT NULL,
  `profileId` int(10) unsigned NOT NULL,
  `message` text NOT NULL,
  `approved` enum('1','0') DEFAULT '1',
  `createdDate` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`messageId`),
  KEY `topicId` (`topicId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]forums_topics`
--

CREATE TABLE `[[dbprefix]]forums_topics` (
  `topicId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `forumId` mediumint(10) unsigned DEFAULT NULL,
  `profileId` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `message` text NOT NULL,
  `approved` enum('1','0') DEFAULT '1',
  `createdDate` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  `views` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`topicId`),
  KEY `forumId` (`forumId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]languages_info`
--

CREATE TABLE `[[dbprefix]]languages_info` (
  `langId` varchar(5) NOT NULL,
  `name` varchar(60) NOT NULL,
  `charset` varchar(15) NOT NULL,
  `active` enum('0','1') NOT NULL DEFAULT '0',
  `direction` enum('ltr','rtl') NOT NULL DEFAULT 'ltr',
  `author` varchar(60) NOT NULL,
  `website` varchar(120) DEFAULT NULL,
  `email` varchar(120) DEFAULT NULL,
  PRIMARY KEY (`langId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]languages_info`
--

INSERT INTO `[[dbprefix]]languages_info` VALUES
('en_US', 'English', 'UTF-8', '1', 'ltr', 'Pierre-Henry Soria', 'http://ph7.me', 'hi@ph7.me');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]likes`
--

CREATE TABLE `[[dbprefix]]likes` (
  `keyId` varchar(191) NOT NULL,
  `votes` int(10) unsigned NOT NULL,
  `lastVote` datetime NOT NULL,
  `lastIp` varchar(45) NOT NULL,
  UNIQUE KEY `keyId` (`keyId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]log_error`
--

CREATE TABLE `[[dbprefix]]log_error` (
  `logId` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `logError` longtext,
  PRIMARY KEY (`logId`),
  FULLTEXT KEY `logError` (`logError`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members`
--

CREATE TABLE `[[dbprefix]]members` (
  `profileId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) NOT NULL,
  `username` varchar(40) NOT NULL,
  `password` varchar(120) NOT NULL,
  `firstName` varchar(50) DEFAULT NULL,
  `lastName` varchar(50) DEFAULT NULL,
  `birthDate` date DEFAULT NULL,
  `sex` enum('male','female','couple') NOT NULL DEFAULT 'female',
  `matchSex` set('male','female','couple') NOT NULL DEFAULT 'male',
  `ip` varchar(45) NOT NULL DEFAULT '127.0.0.1',
  `bankAccount` varchar(150) DEFAULT NULL,
  `groupId` tinyint(2) unsigned NOT NULL DEFAULT '2',
  `membershipDate` datetime DEFAULT NULL,
  `userStatus` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `joinDate` datetime DEFAULT NULL,
  `lastActivity` datetime DEFAULT NULL,
  `lastEdit` datetime DEFAULT NULL,
  `avatar` char(5) DEFAULT NULL,
  `approvedAvatar` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `featured` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `lang` varchar(5) NOT NULL DEFAULT 'en_US',
  `hashValidation` varchar(40) DEFAULT NULL,
  `isTwoFactorAuth` enum('1','0') DEFAULT '0',
  `twoFactorAuthSecret` varchar(40) DEFAULT NULL,
  `views` int(11) unsigned NOT NULL DEFAULT '0',
  `reference` varchar(191) DEFAULT NULL,
  `votes` int(11) DEFAULT '0',
  `score` float DEFAULT '0',
  `credits` int(6) unsigned NOT NULL DEFAULT '0',
  `affiliatedId` int(10) unsigned NOT NULL DEFAULT '0',
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `ban` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`profileId`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`),
  KEY `groupId` (`groupId`),
  KEY `birthDate` (`birthDate`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=18 ;

--
-- Dumping data for table `[[dbprefix]]members`
--

INSERT INTO `[[dbprefix]]members` VALUES
(1, 'ghost@ghost', 'ghost', '0cae5a45403de28c272dea01b5b567d990bfd4db', 'Ghost', 'The Ghost', '1001-01-01', 'female', 'male', '00.000.00.00', NULL, 2, NULL, 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'en_US', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 0, 0),
(2, 'arnaldo75@volkman.biz', 'lisa-langosh', '$2y$12$qx30/d6tfAG/J6sYOly3RezDuWa56kAc9JlOpVOXH/mnM6ldxyQhy', 'Elisabeth', 'Barton', '1965-02-18', 'male', 'couple', '30.237.27.99', NULL, 2, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'ur_IN', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 1, 0),
(3, 'rashad48@yahoo.com', 'kadin-mitchell', '$2y$12$WXSuN5uhk1CMLDbg8BkoIuciZAY0mRr33BOarNRvWIed3mDFxsJM6', 'Hoyt', 'McCullough', '2001-11-09', 'female', 'couple', '236.213.13.12', NULL, 2, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'aa_DJ', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 1, 0),
(4, 'toy.rey@toy.biz', 'maximillian10', '$2y$12$LAJlSOikSjKEeoE6Oqtam.R64QfdjYLDfplJKOIU6ToK3aD2HRcA.', 'Augustus', 'Hane', '1983-09-17', 'male', 'couple', '132.59.253.191', NULL, 2, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'hi_IN', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 1, 0),
(5, 'wehner.dixie@gmail.com', 'titus-lindgren', '$2y$12$RJJ2Z4ciNWo/NH..QjAWPudsni5HnKhzJ1mflpHcUh3MMKPGh0rt2', 'Norwood', 'Parker', '1982-05-07', 'male', 'couple', '221.70.100.59', NULL, 2, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'zu_ZA', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 1, 0),
(6, 'irving.damore@gmail.com', 'meta23', '$2y$12$kN/2s/YqEumYbAYZ/2CtguyXy1CturQq3NE7soBtaBYc2IP62ccym', 'Kiel', 'Morar', '1998-02-18', 'female', 'couple', '220.85.62.232', NULL, 2, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'fr_SN', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 1, 0),
(7, 'vkoch@hotmail.com', 'konopelski-rocio', '$2y$12$6dFAW071oLx08Ihyln6uKO3Xd0MuPQNyWS8rr8xamqckzUpYj7qwS', 'Aaron', 'Wilderman', '1995-12-15', 'female', 'female', '132.158.224.93', NULL, 2, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'ar_JO', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 1, 0),
(8, 'wilderman.jakob@dare.net', 'von-elian', '$2y$12$1DT4aO8tU1tEoW7XXYdrYuis2mNhXztZHHUE0fCZjpezOEB7dBo/G', 'Ramon', 'Rippin', '1965-06-28', 'male', 'couple', '129.254.58.127', NULL, 2, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'es_CO', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 1, 0),
(9, 'kiara06@emard.com', 'kris-austyn', '$2y$12$X6XugzXN3OVkiqmivtwArun1p3yhbYxrNGLwFqwivjVuXeNTp.tNC', 'Gwen', 'Senger', '1994-02-12', 'male', 'female', '215.107.6.10', NULL, 2, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'ar_YE', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 1, 0),
(10, 'anissa.batz@hahn.com', 'schumm-lenny', '$2y$12$qhJbMrh/LQWm0TP4rSKisexGBLU8xXJz.V1icJE0PfvgJDicsh6WC', 'Stanton', 'Kertzmann', '1970-06-30', 'male', 'female', '234.170.254.120', NULL, 2, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'en_ZA', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 1, 0),
(11, 'frederic05@gulgowski.com', 'josephine78', '$2y$12$bm7dpGac.q5FA1Bj9v8a.eoaWHV.rRi3yeH50Yj48kI6E4mHhgBIq', 'Norene', 'Collier', '1972-10-11', 'male', 'couple', '114.229.21.42', NULL, 2, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'ig_NG', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 1, 0),
(12, 'vbailey@gmail.com', 'valerie-davis', '$2y$12$vD70Rdti0hfhHGKKAyo33eK01I3lypsZlBATuE8AwuRYkpQebT/WS', 'Providenci', 'Abbott', '1983-08-26', 'male', 'couple', '115.213.16.244', NULL, 2, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'en_US', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 1, 0),
(13, 'julianne74@tillman.com', 'yschamberger', '$2y$12$sfIowQmssUArCalgCkAKUe5ROsoUz9nvgmFH1ETJYKeeDq/DZLVOK', 'Yazmin', 'Dickens', '1973-07-20', 'male', 'male', '239.127.170.104', NULL, 2, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'it_IT', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 1, 0),
(14, 'pearlie.sipes@yahoo.com', 'dusty-veum', '$2y$12$GbMqAoxSDfu0fEqVI/EqHuYMY178FVD7lcCWpRCSuccSdAPLXdGSy', 'Marcel', 'Kunze', '1982-12-08', 'male', 'female', '67.27.170.119', NULL, 2, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'ar_BH', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 1, 0),
(15, 'marvin19@hotmail.com', 'hessel-travis', '$2y$12$Vffpp6SCUZZ09vvf8DePjewZHpQtvwJokI6nlMWD/GaDz.P8ZygKK', 'Mose', 'Hudson', '1966-09-16', 'male', 'female', '240.234.138.107', NULL, 2, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'haw_U', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 1, 0),
(16, 'kari29@gmail.com', 'rtorp', '$2y$12$Rr6uuBbkP4l8Qz2FyFRiqO5cIQoKSEUpvivoJ4fe/QEZ/tpIEQn8m', 'Claudie', 'Emmerich', '1988-04-24', 'female', 'male', '210.19.87.243', NULL, 2, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'mk_MK', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 1, 0),
(17, 'robel.neal@gmail.com', 'loma-romaguera', '$2y$12$W7szSoA7JcXKk.3Y62gJ1.ZxDvvK.AP7MrD1m5tYW/uH1.ZNb6AKa', 'Anibal', 'Harber', '1990-03-30', 'male', 'female', '172.70.50.206', NULL, 2, '[[regtime]]', 1, '[[regtime]]', '[[regtime]]', NULL, NULL, 1, 0, 'es_CO', NULL, '0', NULL, 0, NULL, 0, 0, 0, 0, 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]memberships`
--

CREATE TABLE `[[dbprefix]]memberships` (
  `groupId` tinyint(2) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '',
  `description` varchar(191) NOT NULL,
  `permissions` text NOT NULL,
  `price` decimal(10,2) unsigned NOT NULL,
  `expirationDays` smallint(4) unsigned NOT NULL,
  `enable` enum('1','0') DEFAULT '1',
  PRIMARY KEY (`groupId`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]memberships`
--

INSERT INTO `[[dbprefix]]memberships` VALUES
(1, 'Visitor (not visible)', 'This subscription is offered to all visitors who visit the site.', 'a:21:{s:21:"quick_search_profiles";s:1:"1";s:24:"advanced_search_profiles";s:1:"1";s:10:"read_mails";s:1:"0";s:10:"send_mails";s:1:"0";s:13:"view_pictures";s:1:"1";s:15:"upload_pictures";s:1:"0";s:11:"view_videos";s:1:"1";s:13:"upload_videos";s:1:"0";s:17:"instant_messaging";s:1:"0";s:4:"chat";s:1:"1";s:10:"hot_or_not";s:1:"1";s:15:"love_calculator";s:1:"0";s:10:"read_notes";s:1:"1";s:11:"write_notes";s:1:"0";s:15:"read_blog_posts";s:1:"1";s:13:"view_comments";s:1:"1";s:14:"write_comments";s:1:"0";s:12:"forum_access";s:1:"1";s:19:"create_forum_topics";s:1:"0";s:19:"answer_forum_topics";s:1:"0";s:18:"member_site_access";s:1:"0";}', 0.00, 0, '1'),
(2, 'Regular (Free)', 'Free Membership.', 'a:21:{s:21:"quick_search_profiles";s:1:"1";s:24:"advanced_search_profiles";s:1:"1";s:10:"read_mails";s:1:"1";s:10:"send_mails";s:1:"1";s:13:"view_pictures";s:1:"1";s:15:"upload_pictures";s:1:"1";s:11:"view_videos";s:1:"1";s:13:"upload_videos";s:1:"1";s:17:"instant_messaging";s:1:"1";s:4:"chat";s:1:"1";s:10:"hot_or_not";s:1:"1";s:15:"love_calculator";s:1:"1";s:10:"read_notes";s:1:"1";s:11:"write_notes";s:1:"1";s:15:"read_blog_posts";s:1:"1";s:13:"view_comments";s:1:"1";s:14:"write_comments";s:1:"1";s:12:"forum_access";s:1:"1";s:19:"create_forum_topics";s:1:"1";s:19:"answer_forum_topics";s:1:"1";s:18:"member_site_access";s:1:"1";}', 0.00, 0, '1'),
(4, 'Platinum', 'The membership for the small budget.', 'a:21:{s:21:"quick_search_profiles";s:1:"1";s:24:"advanced_search_profiles";s:1:"1";s:10:"read_mails";s:1:"1";s:10:"send_mails";s:1:"1";s:13:"view_pictures";s:1:"1";s:15:"upload_pictures";s:1:"1";s:11:"view_videos";s:1:"1";s:13:"upload_videos";s:1:"1";s:17:"instant_messaging";s:1:"1";s:4:"chat";s:1:"1";s:10:"hot_or_not";s:1:"1";s:15:"love_calculator";s:1:"1";s:10:"read_notes";s:1:"1";s:11:"write_notes";s:1:"1";s:15:"read_blog_posts";s:1:"1";s:13:"view_comments";s:1:"1";s:14:"write_comments";s:1:"1";s:12:"forum_access";s:1:"1";s:19:"create_forum_topics";s:1:"1";s:19:"answer_forum_topics";s:1:"1";s:18:"member_site_access";s:1:"1";}', 9.99, 5, '1'),
(5, 'Silver', 'The premium membership!', 'a:21:{s:21:"quick_search_profiles";s:1:"1";s:24:"advanced_search_profiles";s:1:"1";s:10:"read_mails";s:1:"1";s:10:"send_mails";s:1:"1";s:13:"view_pictures";s:1:"1";s:15:"upload_pictures";s:1:"1";s:11:"view_videos";s:1:"1";s:13:"upload_videos";s:1:"1";s:17:"instant_messaging";s:1:"1";s:4:"chat";s:1:"1";s:10:"hot_or_not";s:1:"1";s:15:"love_calculator";s:1:"1";s:10:"read_notes";s:1:"1";s:11:"write_notes";s:1:"1";s:15:"read_blog_posts";s:1:"1";s:13:"view_comments";s:1:"1";s:14:"write_comments";s:1:"1";s:12:"forum_access";s:1:"1";s:19:"create_forum_topics";s:1:"1";s:19:"answer_forum_topics";s:1:"1";s:18:"member_site_access";s:1:"1";}', 19.99, 10, '1'),
(6, 'Gold', 'The must membership! The Gold!!!', 'a:21:{s:21:"quick_search_profiles";s:1:"1";s:24:"advanced_search_profiles";s:1:"1";s:10:"read_mails";s:1:"1";s:10:"send_mails";s:1:"1";s:13:"view_pictures";s:1:"1";s:15:"upload_pictures";s:1:"1";s:11:"view_videos";s:1:"1";s:13:"upload_videos";s:1:"1";s:17:"instant_messaging";s:1:"1";s:4:"chat";s:1:"1";s:10:"hot_or_not";s:1:"1";s:15:"love_calculator";s:1:"1";s:10:"read_notes";s:1:"1";s:11:"write_notes";s:1:"1";s:15:"read_blog_posts";s:1:"1";s:13:"view_comments";s:1:"1";s:14:"write_comments";s:1:"1";s:12:"forum_access";s:1:"1";s:19:"create_forum_topics";s:1:"1";s:19:"answer_forum_topics";s:1:"1";s:18:"member_site_access";s:1:"1";}', 29.99, 30, '1'),
(9, 'Pending (not visible)', 'Pending subscription provisional migration to a different subscription.', 'a:21:{s:21:"quick_search_profiles";s:1:"1";s:24:"advanced_search_profiles";s:1:"1";s:10:"read_mails";s:1:"0";s:10:"send_mails";s:1:"0";s:13:"view_pictures";s:1:"1";s:15:"upload_pictures";s:1:"0";s:11:"view_videos";s:1:"1";s:13:"upload_videos";s:1:"0";s:17:"instant_messaging";s:1:"0";s:4:"chat";s:1:"1";s:10:"hot_or_not";s:1:"1";s:15:"love_calculator";s:1:"0";s:10:"read_notes";s:1:"1";s:11:"write_notes";s:1:"0";s:15:"read_blog_posts";s:1:"1";s:13:"view_comments";s:1:"1";s:14:"write_comments";s:1:"0";s:12:"forum_access";s:1:"1";s:19:"create_forum_topics";s:1:"0";s:19:"answer_forum_topics";s:1:"0";s:18:"member_site_access";s:1:"0";}', 0.00, 15, '0');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members_attempts_login`
--

CREATE TABLE `[[dbprefix]]members_attempts_login` (
  `attemptsId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(45) NOT NULL DEFAULT '',
  `attempts` smallint(5) unsigned NOT NULL,
  `lastLogin` datetime NOT NULL,
  PRIMARY KEY (`attemptsId`),
  UNIQUE KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members_background`
--

CREATE TABLE `[[dbprefix]]members_background` (
  `profileId` int(10) unsigned NOT NULL,
  `file` varchar(5) NOT NULL,
  `file_cdn_url` varchar(40) NOT NULL,
  `approved` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`profileId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members_countries`
--

CREATE TABLE `[[dbprefix]]members_countries` (
  `countryId` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `countryCode` char(2) NOT NULL,
  PRIMARY KEY (`countryId`),
  UNIQUE KEY `countryCode` (`countryCode`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=243 ;

--
-- Dumping data for table `[[dbprefix]]members_countries`
--

INSERT INTO `[[dbprefix]]members_countries` VALUES
(1, 'AD'),
(2, 'AE'),
(3, 'AF'),
(4, 'AG'),
(5, 'AI'),
(6, 'AL'),
(7, 'AM'),
(8, 'AN'),
(9, 'AO'),
(10, 'AQ'),
(11, 'AR'),
(12, 'AS'),
(13, 'AT'),
(14, 'AU'),
(15, 'AW'),
(16, 'AX'),
(17, 'AZ'),
(18, 'BA'),
(19, 'BB'),
(20, 'BD'),
(21, 'BE'),
(22, 'BF'),
(23, 'BG'),
(24, 'BH'),
(25, 'BI'),
(26, 'BJ'),
(27, 'BM'),
(28, 'BN'),
(29, 'BO'),
(30, 'BR'),
(31, 'BS'),
(32, 'BT'),
(33, 'BV'),
(34, 'BW'),
(35, 'BY'),
(36, 'BZ'),
(37, 'CA'),
(38, 'CC'),
(39, 'CD'),
(40, 'CF'),
(41, 'CG'),
(42, 'CH'),
(43, 'CI'),
(44, 'CK'),
(45, 'CL'),
(46, 'CM'),
(47, 'CN'),
(48, 'CO'),
(49, 'CR'),
(50, 'CU'),
(51, 'CV'),
(52, 'CX'),
(53, 'CY'),
(54, 'CZ'),
(55, 'DE'),
(56, 'DJ'),
(57, 'DK'),
(58, 'DM'),
(59, 'DO'),
(60, 'DZ'),
(61, 'EC'),
(62, 'EE'),
(63, 'EG'),
(64, 'EH'),
(65, 'ER'),
(66, 'ES'),
(67, 'ET'),
(68, 'FI'),
(69, 'FJ'),
(70, 'FK'),
(71, 'FM'),
(72, 'FO'),
(73, 'FR'),
(74, 'FX'),
(75, 'GA'),
(76, 'GD'),
(77, 'GE'),
(78, 'GF'),
(79, 'GH'),
(80, 'GI'),
(81, 'GL'),
(82, 'GM'),
(83, 'GN'),
(84, 'GP'),
(85, 'GQ'),
(86, 'GR'),
(87, 'GS'),
(88, 'GT'),
(89, 'GU'),
(90, 'GW'),
(91, 'GY'),
(92, 'HK'),
(93, 'HM'),
(94, 'HN'),
(95, 'HR'),
(96, 'HT'),
(97, 'HU'),
(98, 'ID'),
(99, 'IE'),
(100, 'IL'),
(101, 'IN'),
(102, 'IO'),
(103, 'IQ'),
(104, 'IR'),
(105, 'IS'),
(106, 'IT'),
(107, 'JM'),
(108, 'JO'),
(109, 'JP'),
(110, 'KE'),
(111, 'KG'),
(112, 'KH'),
(113, 'KI'),
(114, 'KM'),
(115, 'KN'),
(116, 'KP'),
(117, 'KR'),
(118, 'KW'),
(119, 'KY'),
(120, 'KZ'),
(121, 'LA'),
(122, 'LB'),
(123, 'LC'),
(124, 'LI'),
(125, 'LK'),
(126, 'LR'),
(127, 'LS'),
(128, 'LT'),
(129, 'LU'),
(130, 'LV'),
(131, 'LY'),
(132, 'MA'),
(133, 'MC'),
(134, 'MD'),
(135, 'ME'),
(136, 'MG'),
(137, 'MH'),
(138, 'MK'),
(139, 'ML'),
(140, 'MM'),
(141, 'MN'),
(142, 'MO'),
(143, 'MP'),
(144, 'MQ'),
(145, 'MR'),
(146, 'MS'),
(147, 'MT'),
(148, 'MU'),
(149, 'MV'),
(150, 'MW'),
(151, 'MX'),
(152, 'MY'),
(153, 'MZ'),
(154, 'NA'),
(155, 'NC'),
(156, 'NE'),
(157, 'NF'),
(158, 'NG'),
(159, 'NI'),
(160, 'NL'),
(161, 'NO'),
(162, 'NP'),
(163, 'NR'),
(164, 'NU'),
(165, 'NZ'),
(166, 'OM'),
(167, 'PA'),
(168, 'PE'),
(169, 'PF'),
(170, 'PG'),
(171, 'PH'),
(172, 'PK'),
(173, 'PL'),
(174, 'PM'),
(175, 'PN'),
(176, 'PR'),
(177, 'PT'),
(178, 'PW'),
(179, 'PY'),
(180, 'QA'),
(181, 'RE'),
(182, 'RO'),
(183, 'RS'),
(184, 'RU'),
(185, 'RW'),
(186, 'SA'),
(187, 'SB'),
(188, 'SC'),
(189, 'SD'),
(190, 'SE'),
(191, 'SG'),
(192, 'SH'),
(193, 'SI'),
(194, 'SJ'),
(195, 'SK'),
(196, 'SL'),
(197, 'SM'),
(198, 'SN'),
(199, 'SO'),
(200, 'SR'),
(201, 'ST'),
(202, 'SV'),
(203, 'SY'),
(204, 'SZ'),
(205, 'TC'),
(206, 'TD'),
(207, 'TF'),
(208, 'TG'),
(209, 'TH'),
(210, 'TJ'),
(211, 'TK'),
(212, 'TM'),
(213, 'TN'),
(214, 'TO'),
(215, 'TP'),
(216, 'TR'),
(217, 'TT'),
(218, 'TV'),
(219, 'TW'),
(220, 'TZ'),
(221, 'UA'),
(222, 'UG'),
(223, 'UK'),
(224, 'UM'),
(225, 'US'),
(226, 'UY'),
(227, 'UZ'),
(228, 'VA'),
(229, 'VC'),
(230, 'VE'),
(231, 'VG'),
(232, 'VI'),
(233, 'VN'),
(234, 'VU'),
(235, 'WF'),
(236, 'WS'),
(237, 'XK'),
(238, 'YE'),
(239, 'YT'),
(240, 'ZA'),
(241, 'ZM'),
(242, 'ZW');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members_friends`
--

CREATE TABLE `[[dbprefix]]members_friends` (
  `profileId` int(10) unsigned NOT NULL,
  `friendId` int(10) unsigned NOT NULL,
  `requestDate` datetime DEFAULT NULL,
  `pending` tinyint(1) unsigned NOT NULL DEFAULT '0',
  KEY `profileId` (`profileId`),
  KEY `friendId` (`friendId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members_info`
--

CREATE TABLE `[[dbprefix]]members_info` (
  `profileId` int(10) unsigned NOT NULL,
  `middleName` varchar(50) DEFAULT NULL,
  `description` text,
  `punchline` varchar(191) DEFAULT NULL,
  `address` varchar(191) DEFAULT NULL,
  `city` varchar(150) DEFAULT NULL,
  `state` varchar(150) DEFAULT NULL,
  `zipCode` varchar(20) DEFAULT NULL,
  `country` char(2) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  `website` varchar(120) DEFAULT NULL,
  `socialNetworkSite` varchar(120) DEFAULT NULL,
  `height` tinyint(3) unsigned DEFAULT NULL,
  `weight` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`profileId`),
  KEY `country` (`country`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]members_info`
--

INSERT INTO `[[dbprefix]]members_info` VALUES
(1, NULL, 'This profile doesn''t exist anymore. So I''m the ghost who replaces him/her during this time', NULL, 'The Ghost City', 'Ghost Town', 'Ghost State', '000000', 'US', NULL, NULL, NULL, NULL, NULL),
(2, NULL, 'Et esse accusantium et cum eligendi. Officia labore sit labore rerum sequi aut.', '', NULL, 'South Garett', '', '33760', 'IL', NULL, NULL, NULL, NULL, NULL),
(3, NULL, 'Repudiandae quam et in vel minus. Voluptatum ea expedita nostrum dolorum sed corporis.', '', NULL, 'West Devonte', '', '90931-3226', 'AX', NULL, NULL, NULL, NULL, NULL),
(4, NULL, 'Facilis pariatur quidem commodi neque inventore corporis rem. Ducimus ducimus sint aspernatur laborum.', '', NULL, 'Bergnaumburgh', '', '87058', 'CX', NULL, NULL, NULL, NULL, NULL),
(5, NULL, 'Sunt sequi deleniti quae saepe ab. Nobis quis incidunt sit. Architecto labore consectetur velit.', '', NULL, 'Mertzfort', '', '57738-2045', 'TZ', NULL, NULL, NULL, NULL, NULL),
(6, NULL, 'Aliquam ut repudiandae temporibus temporibus quae et quam consectetur. Iusto consequatur laboriosam laudantium ipsam.', '', NULL, 'Jarrellstad', '', '82720', 'BO', NULL, NULL, NULL, NULL, NULL),
(7, NULL, 'Nisi natus nostrum natus. Quibusdam iste veritatis hic quaerat.', '', NULL, 'West Naomiefurt', '', '14025-0009', 'TM', NULL, NULL, NULL, NULL, NULL),
(8, NULL, 'Reiciendis veniam consequatur soluta sit aut distinctio magni. Ex sit non quas deleniti ut id nobis enim.', '', NULL, 'West Opal', '', '04902-5445', 'HR', NULL, NULL, NULL, NULL, NULL),
(9, NULL, 'Sint dolores nam est dolores architecto fugit. Ut ut fuga qui dolor necessitatibus sed.', '', NULL, 'Runolfsdottirview', '', '66350-3514', 'PK', NULL, NULL, NULL, NULL, NULL),
(10, NULL, 'Praesentium vel culpa qui excepturi quibusdam. Voluptatibus dicta aspernatur suscipit omnis porro sit sequi.', '', NULL, 'Lake Rowan', '', '60627', 'NE', NULL, NULL, NULL, NULL, NULL),
(11, NULL, 'Placeat aut explicabo ut maxime quaerat odio sapiente. Aut quae qui corrupti animi.', '', NULL, 'Ronnymouth', '', '25130', 'IT', NULL, NULL, NULL, NULL, NULL),
(12, NULL, 'Quaerat ut et sit a dolorem qui. Odit id excepturi laboriosam libero.', '', NULL, 'North Jessyca', '', '09386-9649', 'MV', NULL, NULL, NULL, NULL, NULL),
(13, NULL, 'Illo quaerat reiciendis voluptatibus quibusdam cupiditate tenetur aspernatur. Aliquid veniam error quae illo. Pariatur est molestiae rerum quia.', '', NULL, 'Lake Jorditown', '', '65474', 'WS', NULL, NULL, NULL, NULL, NULL),
(14, NULL, 'Aliquid illo nisi voluptas accusamus. Perspiciatis itaque eum nam adipisci.', '', NULL, 'Mayraport', '', '46658', 'SJ', NULL, NULL, NULL, NULL, NULL),
(15, NULL, 'Nostrum repellat id accusantium optio. Veritatis officia excepturi quia facere omnis quas quaerat.', '', NULL, 'Emelyview', '', '97224', 'IO', NULL, NULL, NULL, NULL, NULL),
(16, NULL, 'Dignissimos sit tenetur aut praesentium dolorem. Nihil expedita amet ipsum voluptatem.', '', NULL, 'East Ameliaberg', '', '40123', 'IO', NULL, NULL, NULL, NULL, NULL),
(17, NULL, 'Facilis impedit laudantium totam error atque tenetur. Aspernatur rerum laboriosam aliquam iure ullam quia ut excepturi.', '', NULL, 'Hintzport', '', '37316', 'KP', NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members_log_login`
--

CREATE TABLE `[[dbprefix]]members_log_login` (
  `logId` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) NOT NULL DEFAULT '',
  `username` varchar(64) NOT NULL DEFAULT '',
  `password` varchar(40) DEFAULT NULL,
  `status` varchar(60) NOT NULL DEFAULT '',
  `ip` varchar(45) NOT NULL DEFAULT '',
  `dateTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`logId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members_log_sess`
--

CREATE TABLE `[[dbprefix]]members_log_sess` (
  `sessionId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `profileId` int(10) unsigned NOT NULL,
  `username` varchar(40) DEFAULT NULL,
  `email` varchar(120) DEFAULT NULL,
  `firstName` varchar(50) DEFAULT NULL,
  `lastName` varchar(50) DEFAULT NULL,
  `ip` varchar(45) NOT NULL DEFAULT '127.0.0.1',
  `dateTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`sessionId`),
  KEY `profileId` (`profileId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members_notifications`
--

CREATE TABLE `[[dbprefix]]members_notifications` (
  `profileId` int(10) unsigned NOT NULL,
  `enableNewsletters` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `newMsg` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `friendRequest` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`profileId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]members_notifications`
--

INSERT INTO `[[dbprefix]]members_notifications` VALUES
(1, 0, 0, 0),
(2, 1, 1, 1),
(3, 1, 1, 1),
(4, 1, 1, 1),
(5, 1, 1, 1),
(6, 1, 1, 1),
(7, 1, 1, 1),
(8, 1, 1, 1),
(9, 1, 1, 1),
(10, 1, 1, 1),
(11, 1, 1, 1),
(12, 1, 1, 1),
(13, 1, 1, 1),
(14, 1, 1, 1),
(15, 1, 1, 1),
(16, 1, 1, 1),
(17, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members_privacy`
--

CREATE TABLE `[[dbprefix]]members_privacy` (
  `profileId` int(10) unsigned NOT NULL,
  `privacyProfile` enum('all','only_members','only_me') NOT NULL DEFAULT 'all',
  `searchProfile` enum('yes','no') NOT NULL DEFAULT 'yes',
  `userSaveViews` enum('yes','no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`profileId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]members_privacy`
--

INSERT INTO `[[dbprefix]]members_privacy` VALUES
(1, 'all', 'yes', 'yes'),
(2, 'all', 'yes', 'yes'),
(3, 'all', 'yes', 'yes'),
(4, 'all', 'yes', 'yes'),
(5, 'all', 'yes', 'yes'),
(6, 'all', 'yes', 'yes'),
(7, 'all', 'yes', 'yes'),
(8, 'all', 'yes', 'yes'),
(9, 'all', 'yes', 'yes'),
(10, 'all', 'yes', 'yes'),
(11, 'all', 'yes', 'yes'),
(12, 'all', 'yes', 'yes'),
(13, 'all', 'yes', 'yes'),
(14, 'all', 'yes', 'yes'),
(15, 'all', 'yes', 'yes'),
(16, 'all', 'yes', 'yes'),
(17, 'all', 'yes', 'yes');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members_wall`
--

CREATE TABLE `[[dbprefix]]members_wall` (
  `wallId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `profileId` int(10) unsigned NOT NULL DEFAULT '0',
  `post` text CHARACTER SET armscii8,
  `createdDate` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`wallId`),
  KEY `profileId` (`profileId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]members_who_views`
--

CREATE TABLE `[[dbprefix]]members_who_views` (
  `profileId` int(10) unsigned NOT NULL,
  `visitorId` int(10) unsigned NOT NULL,
  `lastVisit` datetime DEFAULT NULL,
  KEY `profileId` (`profileId`),
  KEY `visitorId` (`visitorId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messages`
--

CREATE TABLE `[[dbprefix]]messages` (
  `messageId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sender` int(10) unsigned NOT NULL DEFAULT '0',
  `recipient` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(30) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `sendDate` datetime DEFAULT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `trash` set('sender','recipient') NOT NULL DEFAULT '',
  `toDelete` set('sender','recipient') NOT NULL DEFAULT '',
  PRIMARY KEY (`messageId`),
  KEY `recipient` (`recipient`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]messenger`
--

CREATE TABLE `[[dbprefix]]messenger` (
  `messengerId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fromUser` varchar(40) NOT NULL DEFAULT '',
  `toUser` varchar(40) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `sent` datetime DEFAULT NULL,
  `recd` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`messengerId`),
  KEY `fromUser` (`fromUser`),
  KEY `toUser` (`toUser`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]meta_main`
--

CREATE TABLE `[[dbprefix]]meta_main` (
  `langId` varchar(5) NOT NULL DEFAULT '',
  `pageTitle` varchar(100) NOT NULL,
  `metaDescription` varchar(191) NOT NULL,
  `metaKeywords` varchar(191) NOT NULL,
  `headline` varchar(50) NOT NULL,
  `slogan` varchar(191) NOT NULL,
  `promoText` text,
  `metaRobots` varchar(50) NOT NULL DEFAULT '',
  `metaAuthor` varchar(50) NOT NULL DEFAULT '',
  `metaCopyright` varchar(55) NOT NULL DEFAULT '',
  `metaRating` varchar(50) NOT NULL DEFAULT '',
  `metaDistribution` varchar(50) NOT NULL DEFAULT '',
  `metaCategory` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`langId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]meta_main`
--

INSERT INTO `[[dbprefix]]meta_main` VALUES
('en_US', 'Home', 'The Best Online Social Dating Service to meet people and keep in touch with your friends', 'meet people, community, single, friends, meet singles, women, men, dating site, dating service, dating website, online dating website', 'Be on the right place!', 'The place to meet lovely people!', 'You''re on the best place for meeting new people nearby! Chat, Flirt, Socialize and have Fun!<br />Create any Social Dating Web Apps or Websites like this one with the #1 <a href="https://ph7builder.com">Dating Web App Builder</a>. It''s Professional, Modern, Open Source, and gives you the Best Way to launch a new Social/Dating Business!', 'index, follow, all', 'Pierre-Henry Soria (pH7Builder.com)', 'Copyright Pierre-Henry Soria. All Rights Reserved.', 'general', 'global', 'dating');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]modules`
--

CREATE TABLE `[[dbprefix]]modules` (
  `moduleId` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `vendorName` varchar(40) NOT NULL,
  `moduleName` varchar(40) NOT NULL,
  `version` varchar(6) NOT NULL,
  `uri` varchar(40) DEFAULT NULL,
  `path` varchar(191) DEFAULT NULL,
  `active` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleId`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]modules`
--

INSERT INTO `[[dbprefix]]modules` VALUES
(1, 'pH7Builder', 'SQL System Schema', '1.6.4', NULL, NULL, '0');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notes`
--

CREATE TABLE `[[dbprefix]]notes` (
  `noteId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `profileId` int(10) unsigned NOT NULL,
  `postId` varchar(60) NOT NULL,
  `langId` char(2) NOT NULL DEFAULT '',
  `title` varchar(100) DEFAULT NULL,
  `content` longtext NOT NULL,
  `pageTitle` varchar(100) NOT NULL,
  `metaDescription` varchar(191) NOT NULL,
  `metaKeywords` varchar(191) NOT NULL,
  `slogan` varchar(191) NOT NULL,
  `metaRobots` varchar(50) NOT NULL,
  `metaAuthor` varchar(50) NOT NULL,
  `metaCopyright` varchar(50) NOT NULL,
  `tags` varchar(191) DEFAULT NULL,
  `thumb` char(24) DEFAULT NULL,
  `votes` int(9) unsigned DEFAULT '0',
  `score` float unsigned DEFAULT '0',
  `views` int(10) unsigned DEFAULT '0',
  `enableComment` enum('1','0') DEFAULT '1',
  `createdDate` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  `approved` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`noteId`),
  UNIQUE KEY `postId` (`postId`),
  KEY `profileId` (`profileId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notes_categories`
--

CREATE TABLE `[[dbprefix]]notes_categories` (
  `categoryId` smallint(4) unsigned NOT NULL,
  `noteId` int(10) unsigned NOT NULL,
  `profileId` int(10) unsigned NOT NULL,
  KEY `categoryId` (`categoryId`),
  KEY `noteId` (`noteId`),
  KEY `profileId` (`profileId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]notes_data_categories`
--

CREATE TABLE `[[dbprefix]]notes_data_categories` (
  `categoryId` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`categoryId`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=21 ;

--
-- Dumping data for table `[[dbprefix]]notes_data_categories`
--

INSERT INTO `[[dbprefix]]notes_data_categories` VALUES
(1, 'Business'),
(2, 'Companies'),
(3, 'Dating'),
(4, 'Education'),
(5, 'Family'),
(6, 'Food'),
(7, 'Game'),
(8, 'Health'),
(9, 'Hobby'),
(10, 'Movie'),
(11, 'Music'),
(12, 'News'),
(13, 'Pets'),
(14, 'Recreation'),
(15, 'Shopping'),
(16, 'Society'),
(17, 'Sports'),
(18, 'Study'),
(19, 'Technology'),
(20, 'Travel');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pictures`
--

CREATE TABLE `[[dbprefix]]pictures` (
  `pictureId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `profileId` int(10) unsigned NOT NULL,
  `albumId` int(10) unsigned NOT NULL,
  `title` varchar(80) NOT NULL,
  `description` varchar(191) DEFAULT NULL,
  `file` varchar(40) NOT NULL,
  `file_cdn_url` varchar(40) NOT NULL,
  `approved` enum('1','0') DEFAULT '1',
  `votes` int(9) unsigned DEFAULT '0',
  `score` float unsigned DEFAULT '0',
  `views` int(10) unsigned DEFAULT '0',
  `createdDate` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`pictureId`),
  KEY `albumId` (`albumId`),
  KEY `profileId` (`profileId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]report`
--

CREATE TABLE `[[dbprefix]]report` (
  `reportId` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `reporterId` int(10) unsigned DEFAULT NULL,
  `spammerId` int(10) unsigned DEFAULT NULL,
  `dateTime` datetime DEFAULT NULL,
  `contentType` enum('user','avatar','mail','comment','picture','video','forum','note') NOT NULL DEFAULT 'user',
  `description` varchar(191) DEFAULT NULL,
  `url` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`reportId`),
  KEY `reporterId` (`reporterId`),
  KEY `spammerId` (`spammerId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `settingName` varchar(64) NOT NULL,
  `settingValue` varchar(150) DEFAULT '',
  `description` varchar(120) DEFAULT '' COMMENT 'Informative desc about the setting',
  `settingGroup` varchar(12) NOT NULL,
  PRIMARY KEY (`settingName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `[[dbprefix]]settings`
--

INSERT INTO `[[dbprefix]]settings` VALUES
('adminEmail', '[[admin_email]]', '', 'email'),
('affActivationType', '1', '1 = no activation, 2 = email activation, 3 = Manual activation by the administrator', 'registration'),
('autoplayVideo', '1', '1 = Autoplay is enabled, 0 = Autoplay is disabled', 'video'),
('avatarManualApproval', '0', '0 to disable or 1 to enable ', 'moderation'),
('backgroundColor', '', 'Override background color. Leave empty to disable', 'design'),
('banWordReplace', '[removed]', '', 'security'),
('bgProfileManualApproval', '0', 'Background Profile Manual Approval. 0 to disable or 1 to enable ', 'moderation'),
('bgSplashVideo', '1', '0 to disable or 1 to enable the background splash video', 'homepage'),
('captchaCaseSensitive', '1', '1 to enable captcha case sensitive | 0 to enable', 'spam'),
('captchaComplexity', '5', 'number of captcha complexity', 'spam'),
('chatApi', 'https://ph7builder.com/addons/chat/?name=%site_name%&url=%site_url%&skin=4', 'Chat Api URL', 'api'),
('cleanComment', '0', 'Delete comments older than X days. 0 = Disable', 'pruning'),
('cleanMessenger', '0', 'Delete IM messages older than X days. 0 = Disable', 'pruning'),
('cleanMsg', '0', 'Delete messages older than X days. 0 = Disable', 'pruning'),
('cookieConsentBar', '0', 'Enable the cookie consent bar to prevent your users that your site uses cookies. 0 = Disable | 1 = Enable', 'general'),
('cronSecurityHash', '[[cronsecurityhash]]', 'The secret word for the URL of the cron', 'automation'),
('DDoS', '0', '0 to disabled or 1 to enabled DDoS attack protection', 'security'),
('defaultLanguage', 'en_US', '', 'language'),
('defaultMembershipGroupId', '2', 'Default Membership Group', 'registration'),
('defaultSysModule', 'user', 'The default module running by default on the index page. Recommended to keep the "user" module', 'general'),
('defaultTemplate', 'base', '', 'design'),
('defaultVideo', 'https://www.youtube.com/watch?v=q-1eHnBOg4A', 'Video by default if no video is found', 'video'),
('disclaimer', '0', 'Enable a disclaimer to enter to the site. This is useful for sites with adult content. 0 = Disable | 1 = Enable', 'general'),
('displayPoweredByLink', '1', 'Show or not the branding link in the footer.', 'general'),
('emailName', '[[site_name]]', '', 'email'),
('feedbackEmail', '[[feedback_email]]', '', 'email'),
('footerLinkColor', '', 'Override footer links color. Leave empty to disable', 'design'),
('googleApiKey', '', 'Google Maps API key https://developers.google.com/maps/documentation/javascript/get-api-key', 'api'),
('heading1Color', '', 'Override H1 color. Leave empty to disable', 'design'),
('heading2Color', '', 'Override H2 color. Leave empty to disable', 'design'),
('heading3Color', '', 'Override H3 color. Leave empty to disable', 'design'),
('ipApi', 'https://whatismyipaddress.com/ip/', 'IP Api URL', 'api'),
('ipLogin', '', '', 'security'),
('isAdminLoginAttempt', '1', 'Enable blocking connection attempts abusive. Enable = 1 or disable = 0', 'security'),
('isAdminSessionIpCheck', '1', 'Enable it to Protect against session hijacking. Disable it if use dynamic IPs', 'security'),
('isAffiliateLoginAttempt', '1', 'Enable blocking connection attempts abusive. Enable = 1 or disable = 0', 'security'),
('isAffiliateSessionIpCheck', '1', 'Enable it to Protect against session hijacking. Disable it if use dynamic IPs', 'security'),
('isCaptchaAffiliateSignup', '0', '0 to disable or 1 to enable', 'spam'),
('isCaptchaComment', '0', '0 to disable or 1 to enable', 'spam'),
('isCaptchaForum', '0', '0 to disable or 1 to enable', 'spam'),
('isCaptchaMail', '0', '0 to disable or 1 to enable', 'spam'),
('isCaptchaNote', '0', '0 to disable or 1 to enable', 'spam'),
('isCaptchaUserSignup', '0', '0 to disable or 1 to enable', 'spam'),
('isSiteValidated', '0', '0 = site not validated | 1 = site validated', 'security'),
('isSoftwareNewsFeed', '1', 'Enable the news feed. 0 = Disable | 1 = Enable', 'general'),
('isUserAgeRangeField', '1', '0 to disable or 1 to enable', 'registration'),
('isUserLoginAttempt', '1', 'Enable blocking connection attempts abusive. Enable = 1 or disable = 0', 'security'),
('isUserSessionIpCheck', '0', 'Enable it to Protect against session hijacking. Disable it if use dynamic IPs', 'security'),
('linkColor', '', 'Override links color. Leave empty to disable', 'design'),
('linkHoverColor', '', 'Override links hover color. Leave empty to disable', 'design'),
('loginAdminAttemptTime', '120', 'Time before a new connection attempt, in minutes!', 'security'),
('loginAffiliateAttemptTime', '60', 'Time before a new connection attempt, in minutes!', 'security'),
('loginUserAttemptTime', '60', 'Time before a new connection attempt, in minutes!', 'security'),
('mailType', 'mail', '', 'email'),
('mapType', 'roadmap', 'Choose between: ''roadmap'', ''hybrid'', ''terrain'', ''satellite''', 'map'),
('maxAdminLoginAttempts', '10', 'Maximum login attempts before blocking', 'security'),
('maxAffiliateLoginAttempts', '15', 'Maximum login attempts before blocking', 'security'),
('maxAgeRegistration', '99', '', 'registration'),
('maxPasswordLength', '60', '', 'security'),
('maxUserLoginAttempts', '20', 'Maximum login attempts before blocking', 'security'),
('maxUsernameLength', '30', '', 'registration'),
('minAgeRegistration', '18', '', 'registration'),
('minPasswordLength', '6', '', 'security'),
('minUsernameLength', '3', '', 'registration'),
('navbarType', 'default', 'Choose between "default" or "dark"', 'design'),
('noteManualApproval', '0', '0 to disable or 1 to enable ', 'moderation'),
('nudityFilter', '0', '1 = enable | 0 = disable', 'moderation'),
('numberProfileSplashPage', '44', 'Number of profiles to display on the splash homepage', 'homepage'),
('pictureManualApproval', '0', '0 to disable or 1 to enable ', 'moderation'),
('profileWithAvatarSet', '0', '1 to display only the profiles with a profile photo.', 'homepage'),
('requireRegistrationAvatar', '0', '', 'registration'),
('returnEmail', '[[noreply_email]]', 'Usually noreply@yoursite.com', 'email'),
('securityToken', '0', '0 to disable or 1 to enable the CSRF security token in the forms', 'security'),
('securityTokenLifetime', '720', 'Time in seconds to the CSRF security token. Default 720 seconds (12 mins)', 'security'),
('sendReportMail', '1', 'Send the Report by eMail (1 = enable, 0 = disable)', 'security'),
('siteName', '[[site_name]]', '', 'general'),
('siteStatus', 'enable', 'enable or maintenance', 'general'),
('sizeWatermarkTextImage', '2', 'Between 0 to 5', 'image'),
('smtpHostName', 'mail.example.com', '', 'email'),
('smtpPassword', '123456', '', 'email'),
('smtpPort', '25', '', 'email'),
('socialMediaWidgets', '0', 'Enable the Social Media Widgets such as Like and Sharing buttons. 0 = Disable | 1 = Enable', 'general'),
('splashPage', '1', 'Use Splash Page | enable = 1 or disable = 0', 'homepage'),
('textColor', '', 'Override text color. Leave empty to disable', 'design'),
('timeDelayAffRegistration', '2880', '2880 minutes = 2 days (in minutes!)', 'spam'),
('timeDelaySendComment', '5', 'Waiting time to send a new comment, in minutes!', 'spam'),
('timeDelaySendForumMsg', '10', 'Waiting time to send a reply message in the same topic, in minutes!', 'spam'),
('timeDelaySendForumTopic', '5', 'Waiting time to send a new topic in the forum, in minutes!', 'spam'),
('timeDelaySendMail', '3', 'Waiting time to send a new message, in minutes!', 'spam'),
('timeDelaySendNote', '20', 'Waiting time to add a new note post, in minutes!', 'spam'),
('timeDelayUserRegistration', '1440', '1440 minutes = 24 hours (in minutes!)', 'spam'),
('userActivationType', '1', '1 = no activation, 2 = email activation, 3 = manual activation by admin, 4 = SMS activation', 'registration'),
('usersBlock', '1', '0 to disable | 1 to enable the profile photos on the homepage', 'homepage'),
('userTimeout', '1', 'User inactivity timeout. The number of minutes that a member becomes inactive (offline)', 'automation'),
('videoManualApproval', '0', '0 to disable or 1 to enable ', 'moderation'),
('watermarkTextImage', '[[site_name]]', 'Watermark text', 'image'),
('wysiwygEditorForum', '0', 'Enable or not the WYSIWYG. 0 = Disable | 1 = Enable', 'general');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]static_files`
--

CREATE TABLE `[[dbprefix]]static_files` (
  `staticId` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `file` varchar(191) NOT NULL,
  `fileType` enum('css','js') NOT NULL,
  `active` enum('1','0') DEFAULT '1',
  PRIMARY KEY (`staticId`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]static_files`
--

INSERT INTO `[[dbprefix]]static_files` VALUES
(1, '//static.addtoany.com/menu/page.js', 'js', '0');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]subscribers`
--

CREATE TABLE `[[dbprefix]]subscribers` (
  `profileId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `email` varchar(120) NOT NULL,
  `joinDate` datetime DEFAULT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '2',
  `ip` varchar(45) NOT NULL DEFAULT '127.0.0.1',
  `hashValidation` varchar(40) DEFAULT NULL,
  `affiliatedId` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`profileId`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]subscribers`
--

INSERT INTO `[[dbprefix]]subscribers` VALUES
(1, 'Marisa Becker', 'arnaldo75@volkman.biz', '2002-02-07 22:25:14', 1, '30.237.27.99', '8eb4a7b544360e535b69cff4d27e649217931b0d', 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sys_mods_enabled`
--

CREATE TABLE `[[dbprefix]]sys_mods_enabled` (
  `moduleId` tinyint(2) unsigned NOT NULL AUTO_INCREMENT,
  `moduleTitle` varchar(50) NOT NULL,
  `folderName` varchar(20) NOT NULL,
  `premiumMod` enum('0','1') NOT NULL DEFAULT '0',
  `enabled` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`moduleId`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=22 ;

--
-- Dumping data for table `[[dbprefix]]sys_mods_enabled`
--

INSERT INTO `[[dbprefix]]sys_mods_enabled` VALUES
(1, 'Affiliate', 'affiliate', '0', '1'),
(2, 'Chat', 'chat', '1', '1'),
(3, 'Photo', 'picture', '0', '1'),
(4, 'Video', 'video', '0', '1'),
(5, 'Hot or Not', 'hotornot', '0', '1'),
(6, 'Discussions Board', 'forum', '0', '1'),
(7, 'Note (community blog)', 'note', '0', '1'),
(8, 'Blog (company blog)', 'blog', '0', '1'),
(9, 'Love Calculator', 'love-calculator', '0', '1'),
(10, 'Mail (private message)', 'mail', '0', '1'),
(11, 'Instant Messaging (IM)', 'im', '0', '1'),
(12, 'Friends', 'friend', '0', '1'),
(13, 'Related Profiles', 'related-profile', '0', '1'),
(14, 'User Dashboard', 'user-dashboard', '0', '1'),
(15, 'Dating-Style Profile Page', 'cool-profile-page', '0', '1'),
(16, 'Birthday: Let''s Celebrate Birthdays', 'birthday', '0', '1'),
(17, 'Google Maps', 'map', '0', '1'),
(18, 'Newsletter', 'newsletter', '0', '1'),
(19, 'Invite Friends', 'invite', '0', '1'),
(20, 'SMS Verification', 'sms-verification', '0', '0'),
(21, 'Progressive Web App (HTTPS required)', 'pwa', '0', '0');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]top_menus`
--

CREATE TABLE `[[dbprefix]]top_menus` (
  `menuId` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `vendorName` varchar(40) NOT NULL,
  `moduleName` varchar(40) NOT NULL,
  `controllerName` varchar(40) NOT NULL,
  `actionName` varchar(40) NOT NULL,
  `vars` varchar(60) DEFAULT NULL,
  `parentMenu` smallint(4) unsigned DEFAULT NULL,
  `grandParentMenu` smallint(4) unsigned DEFAULT NULL,
  `onlyForUsers` enum('0','1') NOT NULL DEFAULT '0',
  `active` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`menuId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]videos`
--

CREATE TABLE `[[dbprefix]]videos` (
  `videoId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `profileId` int(10) unsigned NOT NULL,
  `albumId` int(10) unsigned NOT NULL,
  `title` varchar(80) DEFAULT NULL,
  `description` varchar(191) DEFAULT NULL,
  `file` varchar(191) DEFAULT NULL,
  `thumb` varchar(191) DEFAULT NULL,
  `approved` enum('1','0') NOT NULL DEFAULT '1',
  `votes` int(9) unsigned DEFAULT '0',
  `score` float unsigned DEFAULT '0',
  `views` int(10) unsigned DEFAULT '0',
  `createdDate` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  `duration` int(9) NOT NULL,
  PRIMARY KEY (`videoId`),
  KEY `albumId` (`albumId`),
  KEY `profileId` (`profileId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1 ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]admins_log_sess`
--
ALTER TABLE `[[dbprefix]]admins_log_sess`
  ADD CONSTRAINT `[[dbprefix]]admins_log_sess_ibfk_1` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]admins` (`profileId`);

--
-- Constraints for table `[[dbprefix]]affiliates_info`
--
ALTER TABLE `[[dbprefix]]affiliates_info`
  ADD CONSTRAINT `[[dbprefix]]affiliates_info_ibfk_1` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]affiliates` (`profileId`);

--
-- Constraints for table `[[dbprefix]]affiliates_log_sess`
--
ALTER TABLE `[[dbprefix]]affiliates_log_sess`
  ADD CONSTRAINT `[[dbprefix]]affiliates_log_sess_ibfk_1` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]affiliates` (`profileId`);

--
-- Constraints for table `[[dbprefix]]albums_pictures`
--
ALTER TABLE `[[dbprefix]]albums_pictures`
  ADD CONSTRAINT `[[dbprefix]]albums_pictures_ibfk_1` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]members` (`profileId`);

--
-- Constraints for table `[[dbprefix]]albums_videos`
--
ALTER TABLE `[[dbprefix]]albums_videos`
  ADD CONSTRAINT `[[dbprefix]]albums_videos_ibfk_1` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]members` (`profileId`);

--
-- Constraints for table `[[dbprefix]]blogs_categories`
--
ALTER TABLE `[[dbprefix]]blogs_categories`
  ADD CONSTRAINT `[[dbprefix]]blogs_categories_ibfk_1` FOREIGN KEY (`blogId`) REFERENCES `[[dbprefix]]blogs` (`blogId`);

--
-- Constraints for table `[[dbprefix]]comments_blog`
--
ALTER TABLE `[[dbprefix]]comments_blog`
  ADD CONSTRAINT `[[dbprefix]]comments_blog_ibfk_1` FOREIGN KEY (`recipient`) REFERENCES `[[dbprefix]]blogs` (`blogId`);

--
-- Constraints for table `[[dbprefix]]comments_note`
--
ALTER TABLE `[[dbprefix]]comments_note`
  ADD CONSTRAINT `[[dbprefix]]comments_note_ibfk_1` FOREIGN KEY (`recipient`) REFERENCES `[[dbprefix]]notes` (`noteId`);

--
-- Constraints for table `[[dbprefix]]comments_picture`
--
ALTER TABLE `[[dbprefix]]comments_picture`
  ADD CONSTRAINT `[[dbprefix]]comments_picture_ibfk_1` FOREIGN KEY (`recipient`) REFERENCES `[[dbprefix]]pictures` (`pictureId`);

--
-- Constraints for table `[[dbprefix]]comments_profile`
--
ALTER TABLE `[[dbprefix]]comments_profile`
  ADD CONSTRAINT `[[dbprefix]]comments_profile_ibfk_1` FOREIGN KEY (`recipient`) REFERENCES `[[dbprefix]]members` (`profileId`);

--
-- Constraints for table `[[dbprefix]]comments_video`
--
ALTER TABLE `[[dbprefix]]comments_video`
  ADD CONSTRAINT `[[dbprefix]]comments_video_ibfk_1` FOREIGN KEY (`recipient`) REFERENCES `[[dbprefix]]videos` (`videoId`);

--
-- Constraints for table `[[dbprefix]]forums`
--
ALTER TABLE `[[dbprefix]]forums`
  ADD CONSTRAINT `[[dbprefix]]forums_ibfk_1` FOREIGN KEY (`categoryId`) REFERENCES `[[dbprefix]]forums_categories` (`categoryId`);

--
-- Constraints for table `[[dbprefix]]forums_messages`
--
ALTER TABLE `[[dbprefix]]forums_messages`
  ADD CONSTRAINT `[[dbprefix]]forums_messages_ibfk_1` FOREIGN KEY (`topicId`) REFERENCES `[[dbprefix]]forums_topics` (`topicId`);

--
-- Constraints for table `[[dbprefix]]forums_topics`
--
ALTER TABLE `[[dbprefix]]forums_topics`
  ADD CONSTRAINT `[[dbprefix]]forums_topics_ibfk_1` FOREIGN KEY (`forumId`) REFERENCES `[[dbprefix]]forums` (`forumId`);

--
-- Constraints for table `[[dbprefix]]members`
--
ALTER TABLE `[[dbprefix]]members`
  ADD CONSTRAINT `[[dbprefix]]members_ibfk_1` FOREIGN KEY (`groupId`) REFERENCES `[[dbprefix]]memberships` (`groupId`);

--
-- Constraints for table `[[dbprefix]]members_background`
--
ALTER TABLE `[[dbprefix]]members_background`
  ADD CONSTRAINT `[[dbprefix]]members_background_ibfk_1` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]members` (`profileId`);

--
-- Constraints for table `[[dbprefix]]members_friends`
--
ALTER TABLE `[[dbprefix]]members_friends`
  ADD CONSTRAINT `[[dbprefix]]members_friends_ibfk_1` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]members` (`profileId`),
  ADD CONSTRAINT `[[dbprefix]]members_friends_ibfk_2` FOREIGN KEY (`friendId`) REFERENCES `[[dbprefix]]members` (`profileId`);

--
-- Constraints for table `[[dbprefix]]members_info`
--
ALTER TABLE `[[dbprefix]]members_info`
  ADD CONSTRAINT `[[dbprefix]]members_info_ibfk_1` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]members` (`profileId`);

--
-- Constraints for table `[[dbprefix]]members_log_sess`
--
ALTER TABLE `[[dbprefix]]members_log_sess`
  ADD CONSTRAINT `[[dbprefix]]members_log_sess_ibfk_1` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]members` (`profileId`);

--
-- Constraints for table `[[dbprefix]]members_notifications`
--
ALTER TABLE `[[dbprefix]]members_notifications`
  ADD CONSTRAINT `[[dbprefix]]members_notifications_ibfk_1` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]members` (`profileId`);

--
-- Constraints for table `[[dbprefix]]members_privacy`
--
ALTER TABLE `[[dbprefix]]members_privacy`
  ADD CONSTRAINT `[[dbprefix]]members_privacy_ibfk_1` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]members` (`profileId`);

--
-- Constraints for table `[[dbprefix]]members_wall`
--
ALTER TABLE `[[dbprefix]]members_wall`
  ADD CONSTRAINT `[[dbprefix]]members_wall_ibfk_1` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]members` (`profileId`);

--
-- Constraints for table `[[dbprefix]]members_who_views`
--
ALTER TABLE `[[dbprefix]]members_who_views`
  ADD CONSTRAINT `[[dbprefix]]members_who_views_ibfk_1` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]members` (`profileId`),
  ADD CONSTRAINT `[[dbprefix]]members_who_views_ibfk_2` FOREIGN KEY (`visitorId`) REFERENCES `[[dbprefix]]members` (`profileId`);

--
-- Constraints for table `[[dbprefix]]messages`
--
ALTER TABLE `[[dbprefix]]messages`
  ADD CONSTRAINT `[[dbprefix]]messages_ibfk_1` FOREIGN KEY (`recipient`) REFERENCES `[[dbprefix]]members` (`profileId`);

--
-- Constraints for table `[[dbprefix]]messenger`
--
ALTER TABLE `[[dbprefix]]messenger`
  ADD CONSTRAINT `[[dbprefix]]messenger_ibfk_1` FOREIGN KEY (`fromUser`) REFERENCES `[[dbprefix]]members` (`username`),
  ADD CONSTRAINT `[[dbprefix]]messenger_ibfk_2` FOREIGN KEY (`toUser`) REFERENCES `[[dbprefix]]members` (`username`);

--
-- Constraints for table `[[dbprefix]]notes`
--
ALTER TABLE `[[dbprefix]]notes`
  ADD CONSTRAINT `[[dbprefix]]notes_ibfk_1` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]members` (`profileId`);

--
-- Constraints for table `[[dbprefix]]notes_categories`
--
ALTER TABLE `[[dbprefix]]notes_categories`
  ADD CONSTRAINT `[[dbprefix]]notes_categories_ibfk_1` FOREIGN KEY (`noteId`) REFERENCES `[[dbprefix]]notes` (`noteId`),
  ADD CONSTRAINT `[[dbprefix]]notes_categories_ibfk_2` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]members` (`profileId`);

--
-- Constraints for table `[[dbprefix]]pictures`
--
ALTER TABLE `[[dbprefix]]pictures`
  ADD CONSTRAINT `[[dbprefix]]pictures_ibfk_1` FOREIGN KEY (`albumId`) REFERENCES `[[dbprefix]]albums_pictures` (`albumId`),
  ADD CONSTRAINT `[[dbprefix]]pictures_ibfk_2` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]members` (`profileId`);

--
-- Constraints for table `[[dbprefix]]report`
--
ALTER TABLE `[[dbprefix]]report`
  ADD CONSTRAINT `[[dbprefix]]report_ibfk_1` FOREIGN KEY (`reporterId`) REFERENCES `[[dbprefix]]members` (`profileId`),
  ADD CONSTRAINT `[[dbprefix]]report_ibfk_2` FOREIGN KEY (`spammerId`) REFERENCES `[[dbprefix]]members` (`profileId`);

--
-- Constraints for table `[[dbprefix]]videos`
--
ALTER TABLE `[[dbprefix]]videos`
  ADD CONSTRAINT `[[dbprefix]]videos_ibfk_1` FOREIGN KEY (`albumId`) REFERENCES `[[dbprefix]]albums_videos` (`albumId`),
  ADD CONSTRAINT `[[dbprefix]]videos_ibfk_2` FOREIGN KEY (`profileId`) REFERENCES `[[dbprefix]]members` (`profileId`);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
