[h3]Overview[/h3]

While many features and capabilities of $Projectname are familiar to people who have used social networking sites and blogging software, there are also quite a few new concepts and features that most people have not encountered before. Some of the new ideas are related to the decentralized nature of the grid; others are associated with the advanced permissions system that is necessary to protect your data privacy. The purpose of this guide is to help you understand how to create, configure, and use your nomadic identity.

[h3]Registration[/h3]

Not all $Projectname sites allow open registration. If registration is allowed, you will see a &quot;Register&quot; link immediately below the login prompts on the site home page. Following this link will take you to the site Registration page. On some sites it may redirect you to another site which allow registrations. As all $Projectname sites are linked, it does not matter where your account resides.

[b]Your Email Address[/b]

Please provide a valid email address. Your email address is never published. This address will be used to activate your account, to (optionally) send email notifications for incoming messages or items, [i]and to recover lost passwords[/i].

[b]Password[/b]

Enter a password of your choice, and repeat it in the second box to ensure it was typed correctly. As $Projectname offers a decentralised identity, your account can log you in to many other websites.

[b]Terms Of Service[/b]

Click the link to read the site's [zrl=[baseurl]/help/TermsOfService]Terms of Service[/zrl]. Once you've read them, tick the box in the register form to confirm.

[b]Register[/b]

Once you have provided the necessary details, click the 'Register' button. Some sites may require administrator approval before the registration is processed, and you will be alerted if this is the case. Please watch your email (including spam folders) for your registration approval.



[h3]Channels[/h3]

[h4]What are channels?[/h4]

Channels are simply collections of content stored in one place. A channel can represent anything. It could represent you, a website, a forum, photo albums, anything. For most people, their first channel with be &quot;Me&quot;.

The most important features for a channel that represents &quot;me&quot; are:
[ul]
[*]Secure and private &quot;spam free&quot; communications

[*]Identity and &quot;single-signon&quot; across the entire network

[*]Privacy controls and permissions which extend to the entire network

[*]Directory services (like a phone book)
[/ul]
In short, a channel that represents yourself is &quot;me, on the internet&quot;.



[h3]Channel Permission Roles[/h3]

When you create a new channel, you will be asked to select a permission role based on how you envision using this channel. The most popular permission roles are the Social Networking roles. You have many other choices, providing options which are analagous to Facebook Groups and Pages, collaborative spaces, newsfeeds, and more. These roles automatically configure several different system variables ranging from what permissions are granted to friends, to your default privacy settings and visibility choices. Advanced configurations are available to let you adjust each of these parameters to your needs, but we've found that most people prefer to "set it and forget it". Thew following describes some of the different roles which are currently available and how they impact your privacy and ability to interact.

[h4]Social[/h4]

[b]Federation[/b]

The channel is a very permissive social networking profile which is compatible with other federated social networks. The permission policies are similar to Twitter and mostly compatible with Diaspora and Mastodon. Privacy is a lower priority than ease of access and connecting with others. Anybody in the network can comment on your public posts and send you private mail. By default posts and published items are public, but you can over-ride this when creating the item and restrict it. You are listed in the directory. Your online presence and connections are visible to others. This mode [i]may[/i] increase your exposure to undesired communications and spam. This role is not generally recommended [i]unless[/i] you need to interact regularly with members of other networks.

[b]Mostly Public[/b]

The channel is a typical social networking profile. By default posts and published items are public, but you can over-ride this when creating the item and restrict it. You are listed in the directory. Your online presence and connections are visible to others. Only your immediate connections can comment on your public posts and send you private mail. The permission policies are similar to Facebook.


[b]Restricted[/b]

By default all posts and published items are sent to your 'Friends' privacy group and not made public. New friends are added to this privacy group. You can over-ride this and create a public post or published item if you desire. You are listed in the directory. Your online presence (for chat) and your connections (friends) are visible to your profile viewers.

[b]Private[/b]

By default all posts and published items are sent to your 'Friends' privacy group. New friends are added to this privacy group. You can over-ride this and create a public post or public item if you desire. You are NOT listed in the directory. Only your connections can see your other connections. Your online presence is hidden.


[h4]Forum[/h4]

[b]Mostly Public[/b]

The channel is a typical forum. By default posts and published items are public. Members may post by !mention or wall-to-wall post. Posting photos and other published items is blocked. The channel is visible in the directory. Members are added automatically.


[b]Restricted[/b]

By default all posts and published items are sent to the channel's 'Friends' privacy group. New friends are added to this privacy group. Members may post by !mention or wall-to-wall post, but posts and replies may also be seen by other receipients of the top-level post who are not members. The channel is visible in the directory. Members must be manually added by the forum owner.

[b]Private[/b]

By default all posts and published items are sent to your 'Friends' privacy group. New friends are added to this privacy group. The owner can over-ride this and create a public post or public item if desired. Members cannot. You are NOT listed in the directory. Only your connections can see your other connections. Your online presence is hidden. Members must be manually added by the forum owner. Posting by !mention is disabled. Posts can only be made via wall-to-wall posts, and sent to members of the 'Friends' privacy group. They are not publicly visible.


[h4]Feed[/h4]


[b]Public[/b]

Similiar to Social - Mostly Public, but tailored for RSS feed sources. Items may be freely republished and sourced. Online presence is meaningless, therefore hidden. New connections are automatically approved.


[b]Restricted[/b]

Not listed in directory. Online presence is meaningless, therefore hidden. Feed is published only to members of the 'Friends' privacy group. New connections are automatically added to this privacy group. Members must be manually approved by the channel owner.


[h4]Special[/h4]

[b]Celebrity/Soapbox[/b]

Listed in directory. Communications are by default public. Online presence is hidden. No commenting or feedback of any form is allowed, though connections have the ability to "like" your profile.


[b]Group Repository[/b]

A public forum which allows members to post files/photos/webpages.


[h4]Custom/Expert Mode[/h4]

Set all the privacy and permissions manually to suit your specific needs.


[h3]Creating channels[/h3]


After creating your account, you will be presented with the &quot;Add a channel&quot; screen. Normally, your first channel will be one that represents you - so using your own name (or psuedonym) as the channel name is a good idea. The channel name should be thought of as a title, or brief description of your channel. The &quot;choose a short nickname&quot; box is similar to a &quot;username&quot; field. We will use whatever you enter here to create a channel address, which other people will use to connect to you, and you will use to log in to other sites. This looks like an email address, and takes the form nickname@siteyouregisteredat.xyz

See Also
[zrl=[baseurl]/help/accounts_profiles_channels_basics]The Basics about Identities within $Projectname[/zrl]
[zrl=[baseurl]/help/accounts]Accounts[/zrl]
[zrl=[baseurl]/help/profiles]Profiles[/zrl]
[zrl=[baseurl]/help/permissions]Permissions[/zrl]
[zrl=[baseurl]/help/remove_account]Remove Account[/zrl]


You can create additonal channels from the &quot;Channel Manager&quot; link.

Once you have done this, your channel is ready to use. At [observer=1][observer.url][/observer][observer=0][baseurl]/channel/username[/observer] you will find your channel &quot;stream&quot;. This is where your recent activity will appear, in reverse chronological order. If you post in the box marked &quot;share&quot;, the entry will appear at the top of your stream. You will also find links to all the other communication areas for this channel here. The "hamburger" menu in most themes will provide you with navigation to other system components and apps. The Photos page contain photo albums, and the Events page contains events share by both yourself and your contacts.

[b]Profiles[/b]

$Projectname has unlimited profiles. You may use different profiles to show different &quot;sides of yourself&quot; to different audiences. This is different to having different channels. Different channels allow for completely different sets of information. You may have a channel for yourself, a channel for your sports team, a channel for your website, or whatever else. A profile allows for finely graded &quot;sides&quot; of each channel. For example, your default public profile might say &quot;Hello, I'm Fred, and I like laughing&quot;. You may show your close friends a profile that adds &quot;and I also enjoy dwarf tossing&quot;.

You always have a profile known as your &quot;default&quot; or &quot;public&quot; profile. This profile is always available to the general public and cannot be hidden (there may be rare exceptions on privately run or disconnected sites). You may, and probably should restrict the information you make available on your public profile.

That said, if you want other friends to be able to find you, it helps to have the following information in your public profile...

[ul][*]Your real name or at least a nickname everybody knows
[*]A photo of you
[*]Your location on the planet, at least to a country level.[/ul]

In addition, if you'd like to meet people that share some general interests with you, please take a moment and add some &quot;Keywords&quot; to your profile. Such as &quot;music, linux, photography&quot; or whatever. You can add as many keywords as you like.

To create an alternate profile, first go to [zrl=[baseurl]/settings/features]Settings &gt; Additional Features[/zrl] and enable &quot;Multiple Profiles&quot; there, otherwise you won't have the ability to use more than just your default profile.

Then select &quot;Edit Profiles&quot; from the menu of your $Projectname site. You may edit an existing profile, change the profile photo, add things to a profile or create a new profile. You may also create a &quot;clone&quot; of an existing profile if you only wish to change a few items but don't wish to enter all the information again. To do that, click on the profile you want to clone and choose &quot;Clone this profile&quot; there.

In the list of your profiles, you can also choose the contacts who can see a specific profile. Just click on &quot;Edit visibility&quot; next to the profile in question (only available for the profiles that are not your default profile) and then click on specific connections to add them to or remove them from the group of people who can see this profile.

Once a profile has been selected, when the person views your profile, they will see the private profile you have assigned. If they are not authenticated, they will see your public profile.

There is a setting which allows you to publish your profile to a directory and ensure that it can be found by others. You can change this setting on the &quot;Settings&quot; page.

If you do not wish to be found be people unless you give them your channel address, you may leave your profile unpublished.

[b]Keywords and Directory Search[/b]

On the directory page, you may search for people with published profiles. Currently, only the name field and the keywords are searched.  You may also include such keywords in your default profile - which may be used to search for common interests with other members. Keywords are used in the channel suggestion tool and although they aren't visible in the directory, they are shown if people visit your profile page.

On your Connnections page and in the directory there is a link to &quot;Suggestions&quot; or &quot;Channel Suggestions&quot;, respectively. This will find channels who have matching and/or similar keywords. The more keywords you provide, the more relevant the search results that are returned. These are sorted by relevance.

See Also

[zrl=[baseurl]/help/AdvancedSearch]Advanced Searching[/zrl]


[h4]The grid, permissions and delegation[/h4]

The &quot;Grid&quot; page contains all recent posts from across $Projectname network, again in reverse chronologial order. The exact posts that appear here depend largely on your permissions. At their most permissive, you will receive posts from complete strangers. At the other end of the scale, you may see posts from only your friends - or if you're feeling really anti-social, only your own posts.

As mentioned at the start, many other kinds of channel are possible, however, the creation procedure is the same. The difference between channels lies primarily in the permissions assigned. For example, a channel for sharing documents with colleagues at work would probably want more permissive settings for &quot;Can write to my &quot;public&quot; file storage&quot; than a personal account. For more information, see the [zrl=[baseurl]/help/roles]permissions section[/zrl].

You can also delegate control of your channels' posts and connections, but not its configurations, to another channel. That is done by editing a connection and assigning it the permission to administer your channel's resources.

[h3]Connecting To Channels[/h3]

Connections in $Projectname can take on a great many different meanings. A connection is more accurately defined as a set of permissions that you have granted to somebody else. In traditional social network applications, all connections are granted the same permissions; or at most there two levels (friends and 'followers'). In $Projectname, a range of separate permissions may be set/adjusted depending on the siutation and relationship you have with the other channel. You can allow somebody to view your posts but not your photos. You can also deny them permission to comment on your posts or send private mail to you. But let's keep it simple, you want to be friends with somebody like you are familiar with from social networking. How do you do it?

First, you need to find some channels to connect to. There are two primary ways of doing this. Firstly, setting the &quot;Can send me their channel stream and posts&quot; permission to &quot;Anybody in this network&quot; will bring posts from complete strangers to your matrix. This will give you a lot of public content and should hopefully help you find interesting, entertaing people, forums, and channels.

The next thing you can do is look at the Directory. The directory is available on every $Projectname website which means searching from your own site will bring in results from the entire network. You can search by name, interest, location, and keyword.

If you already know somebody's 'webbie' you can connect with them directly. A webbie looks just like an email address (for instance bob@example.com) but refers to somebody in the open social web. In order to connect they must be using a compatible network protocol. By default, this software supports the 'zot' protocol, however additional protocols may be provided through plugins/addons. See below for more information on connecting to channels on other networks.

To connect with other $Projectname channels:

Visit their profile by clicking their photograph in the directory, matrix, or comments, and it will open their channel home page in the channel viewer. At the left hand side of the screen, you will usually see a link called &quot;connect&quot;. Click it, and you're done. Depending on the settings of the channel you are connecting to, you may need to wait for them to approve your connection, but no further action is needed on your part. Once you've initiated the connection, you will be taken to the connection editor. This allows you to assign specific permissions for this channel if you wish to make any changes.

You may also connect with any channel by visiting the &quot;Connections&quot; page of your site or the Directory and typing their &quot;webbie&quot; into the &quot;Add New Connection&quot; field. Use this method if somebody tells you their webbie and you wish to connect with them. The process is the same as connecting via the &quot;Connect&quot; button - you will then be taken to the connection editor to set permissions.

To connect with channels on other networks:

The process for connecting to channels on other networks (such as GNU-Social, Mastodon, and Diaspora) is similar - type their &quot;webbie&quot; into the &quot;Add New Connections&quot; box on the &quot;Connections&quot; page. Before you do this however, please visit your Settings page (Feature/Addon Settings) and ensure that the relevant protocol (Diaspora, GNU-Social/OStatus, or ActivityPub) is provided on your hub and [b][i]activated[/i] for your channel[/b]. These networks/protocols do not support account migration and location independence so if you move location or clone your channel elsewhere, communications with these connections may fail. For this reason these protocols are not activated by default, but only through your consent. Activating these protocols involves an important decision between communicating with friends on these networks or providing fail-safe account resilience if your server fails.

Some communications offer more than one protocol. If you wish to connect with somebody on Mastodon (for instance) they can use either the 'ostatus' or the 'activitypub' protocol for communication. Generally the 'activitypub' protocol will provide a better experience than 'ostatus', but $Projectname will often choose the first protocol it discovers and this may not be the one you want. You may connect with somebody over a specific protocol by prepending the protocol name in square brackets to their &quot;webbie&quot;. For example

[code]
[activitypub]https://foo.bar/foobar
[ostatus]foobar@foo.bar
[diaspora]foobar@foo.bar
[zot]foobar@foo.bar
[feed]https://foo.bar/foobar
[/code]


To connect with RSS feeds:

Your hub admin may allow connecting to RSS feeds. The process for connecting to an RSS feed is the same, exept type (or paste) the URL of the feed into the &quot;Add New Connection&quot; box. Feeds are only processed once or twice per day and your hub admin may impose limits on how many feeds you may add.

[h4]Block/Ignore/Archive/Hide channels [/h4]

Channels in your address book can have statuses such as [i]blocked[/i], [i]ignored[/i], [i]archived[/i] and [i]hidden[/i]. From your connections page you can see tabs that display the channels with those statuses. From your edit connection pages you can change the statuses of a channel.

Here's their meaning:

[b]Blocked:[/b] the channel can't read your items regardless of permissions, nor can it write to your channel.

[b]Ignored:[/b] the channel can read your items if it has permission, but can't write to your channel.

[b]Hidden:[/b] the channel does not show up in your profile's connections list, noone can see you're connected, but beware they may still show up to your other connections, for example in post replies.

[b]Archived:[/b] if a channel can't be reached for 30 days, it is automatically marked as archived. This keeps all the data but stops polling the channel for new information and removes it from autocomplete. If later you learn the channel has come back online, you may manually unarchive it.

[h4]Premium Channels[/h4]

Some channels are designated &quot;Premium Channels&quot; and may require some action on your part before a connection can be established. The Connect button will for these channels will take you to a page which lists in detail what terms the channel owner has set. If the terms are accepted, the connection will then proceed normally. In some cases, such as with celebrities and world-reknowned publishers, this may involve payment. If you do not agree to the terms, the connection will not proceed, or it may proceed but with reduced permissions allowed on your interactions with that channel.

[h3]Permissions[/h3]
Permissions in $Projectname are more complete than you may be used to. This allows us to define more fine graded relationships than the black and white &quot;this person is my friend, so they can do everything&quot; or &quot;this person is not my friend, so they can't do anything&quot; permissions you may find elsewhere.

[h4]Permission Roles[/h4]

When you create a channel we allow you to select different 'roles' for that channel. These create an entire family of permissions and privacy settings that are appropriate for that role. Typical roles are "Social - mostly public", "Social - mostly private", "Forum - public" and many others. These bring a level of simplicity to managing permissions. Just choose a role and appropriate permissions are automatically applied. You can also choose 'Custom/Expert mode' and change any individual permission setting in any way you desire.


[h4]Default Permission Limits[/h4]

There are a large number of individual permissions. These control everything from the ability to view your stream to the ability to chat with you. Every permission has a limit. The scope of these permissions varies from &quot;Only me&quot; to &quot;Everybody on the internet&quot; - though some scopes may not be available for some permissions. The limit applies to any published thing you create which has no privacy or access control. For example if you publish a photo and didn't select a specific audience with permission to view it, we apply the limit. These limits apply to everything within that permission rule, so you cannot apply a limit to one photo. The limit applies to all your photos. If all your photos are visible to everybody on the internet and you reduce the limit only to friends, [b]all[/b] of your photos will now be visible only to friends.

[h4]Access Control[/h4]

Access Control is the preferred method of managing privacy in [i]most[/i] cases, rather than using permission limits. This creates lists of either connections or privacy groups (or both) and uses the access list to decide if a permission is allowed. An access list is attached to everything you publish. Unlike permission limits, if you change the access control list on a single photo, it doesn't affect any of your other photos. You can use privacy groups and a "default access control list" to create and automate the management of access control lists to provide any level of privacy you desire on anything you publish.

We highly recommend that you use the "typical social network" settings when you create your first channel, as it allows others to communicate with you and help you out if you have difficulty. You will find that these settings allow you as much privacy as you desire - when you desire it; but also allow you to communicate in public if you choose to. You are free to use much more private settings once you have learned your way around.


[dl terms="l"]
[*= The scopes of permissions are:]
[dl terms="i"]
  [*= Nobody Except Yourself ] This is self explanatory. Only you will be allowed access.

  [*= Only those you specifically allow ] By default, people you are not connected to, and all new contacts will   have this permission denied. You will be able to make exceptions for individual channels on their contact edit   screen.

  [*= Anybody in your address book ] Anybody you do not know will have this permission denied, but anybody you   accept as a contact will have this permission approved. This is the way most legacy platforms handle   permissions.

  [*= Anybody On This Hub ] Anybody with a channel on the same hub/website as you will have permission approved. Anybody who is registered at a different hub will have this permission denied.

  [*= Anybody in this network ] Anybody in $Projectname will have this permission approved. Even complete   strangers. However, anybody not logged in/authenticated will have this permission denied.

  [*= Anybody authenticated ] This is similar to "anybody in this network" except that it can include anybody   who can authenticate by any means - and therefore [i]may[/i] include visitors from other networks.

  [*=Guest Access Token] This allows you to share a file, folder, photo, album, or channel with a specific person or group of people. They don't need to be $Projectname members. You can set an expiration for the Access Token.

  [*= Anybody on the internet ] Completely public. This permission will be approved for anybody at all.
[/dl]
[*= The individual permissions are:]
[dl terms="i"]
  [*= Can view my &quot;public&quot; stream and posts. ] This permision determines who can view your channel &quot;stream&quot; that is, the non-private posts that appear on the &quot;home&quot; tab when you're logged in.

  [*= Can view my &quot;public&quot; channel profile. ] This permission determines who can view your channel's profile. This refers to the &quot;about&quot; tab

  [*= Can view my &quot;public&quot; photo albums. ] This permission determines who can view your photo albums. Individual photographs may still be posted to a more private audience.

  [*= Can view my &quot;public&quot; address book. ] This permission determines who can view your contacts. These are the connections displayed in the &quot;View connections&quot; section.

  [*= Can view my &quot;public&quot; file storage. ] This permission determines who can view your public files stored in your cloud.

  [*= Can view my &quot;public&quot; pages. ] This permission determines who can view your public web pages.

  [*= Can send me their channel stream and posts. ] This permission determines whose posts you will view. If your channel is a personal channel (ie, you as a person), you would probably want to set this to &quot;anyone in my address book&quot; at a minimum. A personal notes channel would probably want to choose &quot;nobody except myself&quot;. Setting this to &quot;Anybody in the network&quot; will show you posts from complete strangers, which is a good form of discovery.

  [*= Can post on my channel page (&quot;wall&quot;). ] This permission determines who can write to your wall when clicking through to your channel.

  [*= Can comment on my posts. ] This permission determines who can comment on posts you create. Normally, you would want this to match your &quot;can view my public stream and posts&quot; permission

  [*= Can send me private mail messages. ] This determines who can send you private messages (zotmail).

  [*= Can post photos to my photo albums. ] This determines who can post photographs in your albums. This is very useful for forum-like channels where connections may not be connected to each other.

  [*= Can forward to all my channel contacts via post tags. ] Using @- mentions will reproduce a copy of your post on the profile specified, as though you posted on the channel wall. This determines if people can post to your channel in this way.

  [*= Can chat with me (when available). ] This determines who can join the public chat rooms created by your channel.

  [*= Can write to my &quot;public&quot; file storage. ] This determines who can upload files to your public file storage, or 'cloud'.

  [*= Can edit my &quot;public&quot; pages. ] This determines who can edit your webpages. This is useful for wikis or sites with multiple editors.

  [*= Can administer my channel resources. ] This determines who can have full control of your channel. This should normally be set to &quot;nobody except myself&quot;.
[/dl][/dl]
[i]Note:[/i]
Plugins/addons may provide special permission settings, so you may be offered additional permission settings beyond what is described here.

If you have set any of these permissions to &quot;only those I specifically allow&quot;, you may specify individual permissions on the connnection edit screen.

[h4]Affinity[/h4]

The connection edit screen offers a slider to select a degree of friendship with the connnection (this tool is enabled through the &quot;Extra Features&quot; tab of your Settings page). Think of this as a measure of how much you like or dislike them. 1 is for people you like, whose posts you want to see all the time. 99 is for people you don't care for, and whose posts you might only wish to look at occasionally. Once you've assigned a value here, you can use the affinity tool on the matrix page to filter content based on this number.

The slider on the matrix page has both a minimum and maximum value. Posts will only be shown from people who fall between this range. Affinity has no relation to permissions, and is only useful in conjunction with the affinity tool feature.

[h3]Guest Access Tokens[/h3]
Guest access tokens (sometimes called "Zot access tokens") allow you to share a file, folder, photo, album, or channel with a specific person or group of people who are not $Projectname members. These tokens allow you to share individual items by sending a link that includes the token in the URL; alternatively, people can actually [i]log in[/i] using the token credentials, after which they can seamlessly view whatever content has been shared with that token.

To create and manage guest tokens, open the [zrl=[baseurl]/settings/tokens/]Guest Access Tokens[/zrl] settings page. A random token is generate with each page load, allowing you to create one by inputting an associated login name and optionally specifying an expiration date. Existing tokens are listed below the dialog and can be edited by selecting them or deleted by pressing the trash icon.

Additional permissions may be granted to the guest token by expanding the [b]Individual Permissions[/b] options and selecting privacy settings such as [b]Can view my channel stream and posts[/b] or [b]Can chat with me[/b].

[url=[baseurl]/help/feature/access_tokens]More details can be found here...[/url]

[img][baseurl]/doc/member/assets/zat_dialog.png[/img]


[h3]Markup Languages[/h3]
$Projectname supports several markup languages for advanced formatting of content. The default markup language is a [url=[baseurl]/help/member/bbcode]custom variant of BBcode[/url], tailored for use in $Projectname. [url=[baseurl]/help/member/bbcode]BBcode[/url] is supported for posts, wiki pages, and web page elements. Wiki pages and webpage elements may also be written using standard Markdown.
[table border=0]
[tr][th]Content Type[/th][th]Supported Markup[/th][/tr]
[tr][td]Post[/td][td][url=[baseurl]/help/member/bbcode]BBcode[/url][/td][/tr]
[tr][td]Wiki[/td][td][url=[baseurl]/help/member/bbcode]BBcode[/url], Markdown[/td][/tr]
[tr][td]Webpage element[/td][td][url=[baseurl]/help/member/bbcode]BBcode[/url], Markdown, HTML[/td][/tr]
[/table]

[h3]Tags And Mentions[/h3]

[h4]Mentions[/h4]
You can mention a channel by simply preceding their name with the [code]@[/code] character, like this:

[code]
@Jack
[/code]

If the channel mentioned is in the list of recipients for the post or comment, they will receive a notification, bringing it to their attention. If they're [i]not[/i] among the recipients, the tag will simply work as a link to their profile.

When you begin to mention somebody, it will create an auto-complete box to select from [u]your immediate connections[/u](?). Select one as appropriate.


[h4]Private Mentions[/h4]
If you wish to restrict a post to a single—or only a few—channels you can do this by selecting channels or privacy groups from the privacy tool.

[img=[baseurl]/help/en/member/assets/privacy-tool-3.png]Two views of the permissions dialogue. To the left: Selecing a single privacy group or forum as recipients for the post. To the right: Using the 'Custom selection' view to gain fine grained control over the recipients.[/img]

You can also just tag a channel with a [i]privacy tag[/i].

A privacy tag is a channel name preceded by the two characters [code]@![/code]. This will also change the privacy permissions of the post to only include the tagged channel. You can use more than one privacy tag, for instance [code]@!bob and @!linda[/code] will send the post only to Bob and Linda. This mechanism over-rides the privacy selector.

[h4]Mentioning forums[/h4]

Forums may be mentioned in the same way. [code]@!dogs[/code] will post to the dogs forum privately. The forum will redeliver the post to all the forum members, but your own followers will not see the post unless they are also members of the dogs forum.

[size=small][b]Note:[/b] In previous releases you could mention a forum by prefixing the forum name with the characters [code]!![/code]. This is no longer supported. The correct way to send to a forum is by using the [code]@![/code] tag.[/size]

[h4]Mentioning privacy groups[/h4]

You may also tag privacy groups which are "public".

When you create or edit a privacy group, there is a checkbox to allow the group members to be seen by others. If this box is checked for a group and you tag (for instance) [code]@!Friends[/code] - the post will be restricted to the Friends group. Check that the group is public before doing this - as there is no way to take back a post except to delete it. The group name will appear in the post and will alert members of that group that they are members of it.

Set the privacy group visible to others to make it public:
[img=[baseurl]/help/en/member/assets/privacy-group-tool-public.png]The privacy group tool with 'Members are visible to other channels' set to 'yes'.[/img]

To add or edit privacy groups, you need to have the [url=[baseurl]/group]Privacy Groups app[/url] installed.

[h4]Mentions and Comments[/h4]
The above mechanisms only apply to "top-level" posts you create. Mentioning a channel with any of the above mechanisms has no effect in comments, except that the mentioned channel may receive a notification if they were already included as a recipient in the conversation.

[h4]Topical Tags (also known as Hashtags)[/h4]
Topical tags are indicated by preceding the tag name with the [code]#[/code] character. This will create a link in the post to a generalised site search for the term provided.  For example, #[zrl=[baseurl]/search?tag=cars]cars[/zrl] will provide a search link for all posts tagged with '[code]#cars[/code]' on your site. Topical tags are generally a minimum of three characters in length.  Shorter search terms are not likely to yield any search results, although this depends on the database configuration.

Topical tags are also not normally linked if they are purely numeric, e.g. [code]#1[/code]. If you wish to use a numeric hashtag, please add some descriptive text such as [code]#2012-elections[/code] or enclose the entire tag in double quotes (for example [code]#"2012"[/code]). Doubles quotes are also required if the tag contains spaces ([code]#"My Tag"[/code]) and may be required if the tag contains punctuation characters ([code]#"EndsWithPeriod."[/code] or [code]#"Exciting!!!"[/code]).

[h4]Bookmarks[/h4]
Bookmarks indicate a link which can be saved to your bookmark folder. They use the sequence [code]#^[/code] followed by the link. Often these are generated automatically.

[img=[baseurl]/help/en/member/assets/bookmarker-save-icon.png]Saving a bookmark by clicking the bookmark icon when the 'bookmarker' addon is enabled.[/img]

If the site administrator has enabled the [url=[baseurl]/admin/addons/bookmarker]bookmarker[/url] addon for the site, this sequence will be converted to a bookmark icon when viewing the post or comment online. Clicking the icon will save the bookmark.

Otherwise if the [url=[baseurl]/bookmarks]Bookmarks app[/url] is installed for the channel, the post dropdown menu contains a link for saving the bookmark or bookmarks.

[img=[baseurl]/help/en/member/assets/bookmarks-menu-dropdown.png]A post with a bookmark, showing the dropdown menu.[/img]

[h4]Manual Mentions[/h4]
Where possible please use the auto-complete window to select tag and mention recipients, because it will generate a coded tag which uniquely identifies one channel. Names are sometimes ambiguous. However, you can "manually" tag a channel by matching the channel name or address.

[code]
@billy
[/code]

will tag a connection whose name or network address is 'billy' (exact match). If you have two connections with a name or network address of billy, for instance [code]billy@server1.hubzilla.org[/code] and [code]billy@server2.hubzilla2.org[/code], you will need to supply the complete address or the results will be ambiguous and the wrong person may be tagged.

[code]
@"Robert Johnson"
[/code]

will tag Robert Johnson. The double quotes are required if the tagged name contains space characters.


[h3]Web Pages[/h3]

$Projectname allows members and allowed connections to create static webpages.  To activate this feature, enable the [b]Web Pages[/b] feature in your [b][url=[baseurl]/settings/features/]Additional Features[/url][/b] section.

Once enabled, a new tab will appear on your channel page labeled &quot;Webpages&quot;. Clicking this link will take you to the webpage editor. Pages will be accessible at [b][baseurl]/page/[observer=1][observer.webname][/observer][observer=0]channelname[/observer]/pagelinktitle[/b]

The &quot;page link title&quot; box allows you to specify the &quot;pagelinktitle&quot; of this URL.  If no page link title is set, we will set one for you automatically, using the message ID of the item.

Beneath the page creation box, a list of existing pages will appear with an &quot;edit&quot; link.  Clicking this will take you to an editor, similar to that of the post editor, where you can make changes to your webpages.

[h4]Using Blocks[/h4]

Blocks can be parts of webpages. The basic HTML of a block looks like this
[code]
	<div>
		Block Content
	</div>

[/code]

If a block has text/html content type it can also contain menu elements. Sample content of
[code]
	<p>HTML block content</p>
	[menu]menuname[/menu]

[/code]
will produce HTML like this
[code]
	<div>
		<p>HTML block content</p>
		<div>
			<ul>
				<li><a href="#">Link 1</a></li>
				<li><a href="#">Link 2</a></li>
				<li><a href="#">Link 3</a></li>
			</ul>
		</div>
	</div>

[/code]

Via the $content macro a block can also contain the actual webpage content. For this create a block with only
[code]
	$content

[/code]as content.

To make a block appear in the webpage it must be defined in the page layout inside a region.
[code]
	[region=aside]
		[block]blockname[/block]
	[/region]

[/code]

The block appearance can be manipulated in the page layout.

Custom classes can be assigned
[code]
	[region=aside]
		[block=myclass]blockname[/block]
	[/region]

[/code]
will produce this HTML
[code]
	<div class="myclass">
		Block Content
	</div>

[/code]

Via the wrap variable a block can be stripped off its wrapping <div></div> tag
[code]
	[region=aside]
		[block][var=wrap]none[/var]blockname[/block]
	[/region]

[/code]
will produce this HTML
[code]
	Block Content
[/code]

[h4]Webpage element import tool[/h4]

There are two methods of importing webpage elements: uploading a zip file or referencing a local cloud files folder. Both methods require that the webpage elements are specified using a specific folder structure. The import tool makes it possible to import all the elements necessary to construct an entire website or set of websites. The goal is to accommodate external development of webpages as well as tools to simplify and automate deployment on a hub.

[h5] Folder structure [/h5]
Element definitions must be stored in the repo root under folders called
[code]
	/pages/
	/blocks/
	/layouts/
[/code]

Each element of these types must be defined in an individual subfolder using two files: one JSON-formatted file for the metadata and one plain text file for the element content.

[h5] Page elements [/h5]
Page element metadata is specified in a JSON-formatted file called [code]page.json[/code] with the following properties:
[list]
[*] title
[*] pagelink
[*] mimetype
[*] layout
[*] contentfile
[/list]
[b]Example[/b]

Files:
[code]
	/pages/my-page/page.json
	/pages/my-page/my-page.bbcode
[/code]
Content of [code]page.json[/code]:
[code]
	{
		"title": "My Page",
		"pagelink": "mypage",
		"mimetype": "text/bbcode",
		"layout": "my-layout",
		"contentfile": "my-page.bbcode"
	}
[/code]
[h5] Layout elements [/h5]

Layout element metadata is specified in a JSON-formatted file called [code]layout.json[/code] with the following properties:
[list]
[*] name
[*] description
[*] contentfile
[/list]
[b]Example[/b]

Files:
[code]
	/layouts/my-layout/layout.json
	/layouts/my-layout/my-layout.bbcode
[/code]
Content of [code]layout.json[/code]:
[code]
	{
		"name": "my-layout",
		"description": "Layout for my project page",
		"contentfile": "my-layout.bbcode"
	}
[/code]

[h5] Block elements [/h5]

Block element metadata is specified in a JSON-formatted file called [code]block.json[/code] with the following properties:
[list]
[*] name
[*] title
[*] mimetype
[*] contentfile
[/list]
[b]Example[/b]

Files:
[code]
	/blocks/my-block/block.json
	/blocks/my-block/my-block.html
[/code]
Content of [code]block.json[/code]:

[code]
	{
		"name": "my-block",
		"title": "",
		"mimetype": "text/html",
		"contentfile": "my-block.html"
	}
[/code]

[h3]Comanche Page Description Language[/h3]

Comanche is a markup language similar to [url=[baseurl]/help/member/bbcode]BBcode[/url] with which to create elaborate and complex web pages by assembling them from a series of components - some of which are pre-built and others which can be defined on the fly. Comanche uses a Page Decription Language to create these pages.

Comanche primarily chooses what content will appear in various regions of the page. The various regions have names and these names can change depending on what layout template you choose.

[h4]Page Templates[/h4]
Currently there are five layout templates, unless your site provides additional layouts.

[dl terms="b"]
[*= default]
The default template defines a &quot;nav&quot; region across the top, &quot;aside&quot; as a fixed width sidebar,
&quot;content&quot; for the main content region, and &quot;footer&quot; for a page footer.

[*= full]
The full template defines the same as the default template with the exception that there is no &quot;aside&quot; region.

[*= choklet]
The choklet template provides a number of fluid layout styles which can be specified by flavour:
[list]
[*]	(default flavour) - a two column layout similar to the "default" template, but more fluid
[*]	bannertwo - a two column layout with a banner region, compatible with the "default" template on small displays
[*]	three - three column layout (adds a "right_aside" region to the default template)
[*]	edgestwo - two column layout with fixed side margins
[*]	edgesthree - three column layout with fixed side margins
[*]	full - three column layout with fixed side margins and adds a "header" region beneath the navigation bar
[/list]

[*= redable]
A template for reading longer texts full screen (so without navigation bar). Three columns: aside, content and right_aside.
For maximum readability it is advised to only use the middle content column.

[*= zen]
Gives you the freedom to do everything yourself. Just a blank page with a content region.
[/dl]

To choose a layout template, use the 'template' tag.

[code]
	[template]full[/template]

[/code]

To choose the "choklet" template with the "three" flavour:

[code]
	[template=three]choklet[/template]

[/code]

The default template will be used if no other template is specified. The template can use any names it desires for content regions. You will be using 'region' tags to decide what content to place in the respective regions.

Three &quot;macros&quot; have been defined for your use.
[code]
	$htmlhead - replaced with the site head content.
	$nav - replaced with the site navigation bar content.
	$content - replaced with the main page content.

[/code]

By default, $nav is placed in the &quot;nav&quot; page region and $content is placed in the &quot;content&quot; region. You only need to use these macros if you wish to re-arrange where these items appear, either to change the order or to move them to other regions.


To select a theme for your page, use the 'theme' tag.
[code]
	[theme]suckerberg[/theme]

[/code]
This will select the theme named &quot;suckerberg&quot;. By default your channel's preferred theme will be used.

[code]
	[theme=passion]suckerberg[/theme]

[/code]
This will select the theme named &quot;suckerberg&quot; and select the &quot;passion&quot; schema (theme variant). Alternatively it may be possible to use a condensed theme notation for this.

[code]
	[theme]suckerberg:passion[/theme]

[/code]

The condensed notation isn't part of Comanche itself but is recognised by $Projectname platform as a theme specifier.

[h4]Navbar[/h4]

[code]
	[navbar]tucson[/navbar]
[/code]

Use the 'tucson' navbar template and CSS rules. By default the 'default' navbar template will be used.


[h4]Regions[/h4]
Each region has a name, as noted above. You will specify the region of interest using a 'region' tag, which includes the name. Any content you wish placed in this region should be placed between the opening region tag and the closing tag.

[code]
	[region=htmlhead]....content goes here....[/region]
	[region=aside]....content goes here....[/region]
	[region=nav]....content goes here....[/region]
	[region=content]....content goes here....[/region]

[/code]

[h4]CSS and Javascript[/h4]
We have the possibility to include javascript and css libraries in the htmlhead region. At present we make use of jquery (js), bootstrap (css/js) and foundation (css/js).
This will overwrite the selected themes htmlhead.

[code]
	[region=htmlhead]
		[css]bootstrap[/css]
		[js]jquery[/js]
		[js]bootstrap[/js]
	[/region]

[/code]

[h4]Menus and Blocks[/h4]
Your webpage creation tools allow you to create menus and blocks, in addition to page content. These provide a chunk of existing content to be placed in whatever regions and whatever order you specify. Each of these has a name which you define when the menu or block is created.

[code]
	[menu]mymenu[/menu]

[/code]
This places the menu called &quot;mymenu&quot; at this location on the page, which must be inside a region.

[code]
	[menu=horizontal]mymenu[/menu]

[/code]
This places the menu called &quot;mymenu&quot; at this location on the page, which must be inside a region. Additionally it applies the "horizontal" class to the menu. "horizontal" is defined in the redbasic theme. It may or may not be available in other themes.

[code]
	[menu][var=wrap]none[/var]mymenu[/menu]

[/code]
The variable [var=wrap]none[/var] in a block removes the wrapping div element from the menu.

[code]
	[block]contributors[/block]
[/code]
This places a block named &quot;contributors&quot; in this region.

[code]
	[block=someclass]contributors[/block]

[/code]
This places a block named &quot;contributors&quot; in this region. Additionally it applies the &quot;someclass&quot; class to the block. This replaces the default block classes &quot;bblock widget&quot;.

[code]
	[block][var=wrap]none[/var]contributors[/block]

[/code]
The variable [var=wrap]none[/var] in a block removes the wrapping div element from the block.

[h4]Widgets[/h4]
Widgets are executable apps provided by the system which you can place on your page. Some widgets take arguments which allows you to tailor the widget to your purpose. System widgets are listed [url=help/Widgets]here[/url]. Widgets can also ve created by plugins, themes, or your site administrator to provide additional functionality.


Widgets and arguments are specified with the 'widget' and 'var' tags.
[code]
	[widget=recent_visitors][var=count]24[/var][/widget]

[/code]

This loads the &quot;recent_visitors&quot; widget and supplies it with the argument &quot;count&quot; set to &quot;24&quot;.

[h4]Comments[/h4]
The 'comment' tag is used to delimit comments. These comments will not appear on the rendered page.

[code]
	[comment]This is a comment[/comment]

[/code]

[h4]Conditional Execution[/h4]
You can use an 'if' construct to make decisions. These are currently based on system configuration variable or the current observer.

[code]
	[if $config.system.foo]
		... the configuration variable system.foo evaluates to 'true'.
	[else]
		... the configuration variable system.foo evaluates to 'false'.
 	[/if]

	[if $observer]
		... this content will only be show to authenticated viewers
	[/if]

[/code]

	The 'else' clause is optional.

	Several tests are supported besides boolean evaluation.

[code]
	[if $config.system.foo == bar]
		... the configuration variable system.foo is equal to the string 'bar'
	[/if]
	[if $config.system.foo != bar]
		... the configuration variable system.foo is not equal to the string 'bar'
	[/if]
	[if $config.system.foo {} bar ]
		... the configuration variable system.foo is a simple array containing a value 'bar'
	[/if]
	[if $config.system.foo {*} bar]
		... the configuration variable system.foo is a simple array containing a key named 'bar'
	[/if]
[/code]

[h4]Complex Example[/h4]
[code]
	[comment]use an existing page template which provides a banner region plus 3 columns beneath it[/comment]

	[template]3-column-with-header[/template]

	[comment]Use the &quot;darknight&quot; theme[/comment]

	[theme]darkknight[/theme]

	[comment]Use the existing site navigation menu[/comment]

	[region=nav]$nav[/region]

	[region=side]

		[comment]Use my chosen menu and a couple of widgets[/comment]

		[menu]myfavouritemenu[/menu]

		[widget=recent_visitors]
			[var=count]24[/var]
			[var=names_only]1[/var]
		[/widget]

		[widget=tagcloud][/widget]
		[block]donate[/block]

	[/region]



	[region=middle]

		[comment]Show the normal page content[/comment]

		$content

	[/region]



	[region=right]

		[comment]Show my condensed channel &quot;wall&quot; feed and allow interaction if the observer is allowed to interact[/comment]

		[widget]channel[/widget]

	[/region]

[/code]


[h3]Personal Cloud Storage[/h3]

$Projectname provides an ability to store privately and/or share arbitrary files with friends.

You may either upload files from your computer into your storage area, or copy them directly from the operating system using the WebDAV protocol.

On many public servers there may be limits on disk usage.

[h4]File Attachments[/h4]

The quickest and easiest way to share files is through file attachments. In the row of icons below the status post editor is a tool to upload attachments. Click the tool, select a file and submit. After the file is uploaded, you will see an attachment code placed inside the text region. Do not edit this line or it may break the ability for your friends to see the attachment. You can use the post permissions dialogue box or privacy hashtags to restrict the visibility of the file - which will be set to match the permissions of the post your are sending.

To delete attachments or change the permissions on the stored files, visit [observer=1][baseurl]/cloud/[observer.webname][/observer][observer=0][baseurl]/cloud/username replacing username with the nickname you provided during channel creation[/observer].

[h4]Web Access[/h4]

Your files are visible on the web at the location [observer=1][baseurl]/cloud/[observer.webname][/observer][observer=0][baseurl]/cloud/username[/observer] to anybody who is allowed to view them. If the viewer has sufficient privileges, they may also have the ability to create new files and folders/directories. This should only be used for smaller files and photos (up to a few megabytes) as it uses internal memory. For larger files (videos, music, etc.), please upload using WebDAV. These files may still be retrieved via web access.

[h4]WebDAV access[/h4]

WebDAV provides a way to copy files directly to or from your computer's operating system, where your cloud files appear as a virtual disk drive. This should be used to upload large files such as video and audio; as it is not limited to available memory. See [zrl=help/member/member_guide#Cloud_Desktop_Clients]Cloud Desktop Clients[/zrl] below.

[h4]CalDAV and CardDAV access on Android[/h4]

You can sync you calendar and contacts on Android with your Hub.

The following steps where tested for [url=https://f-droid.org/en/packages/at.bitfire.davdroid/]DAVdroid[/url]
[list]
[*] install DAVdroid
[*] add account
[*] use "URL" and "user name" to login
[list]
[*] base url is [baseurl]/cdav
[*] user name is [observer=1][observer.webname][/observer][observer=0]username[/observer]
[/list]
[/list]

To share your calendar visit [observer.baseurl]/cdav/calendar


[h4]Permissions[/h4]

When using WebDAV, the file is created with your channel's default file permissions and this cannot be changed from within the operating system. It also may not be as restrictive as you would like. What we've found is that the preferred method of making files private is to first create folders or directories; then visit [observer=1][baseurl]/cloud/[observer.webname][/observer][observer=0][baseurl]/cloud/username[/observer] select the directory and change the permissions. Do this before you put anything into the directory. The directory permissions take precedence so you can then put files or other folders into that container and they will be protected from unwanted viewers by the directory permissions. It is common for folks to create a &quot;personal&quot; or &quot;private&quot; folder which is restricted to themselves. You can use this as a personal cloud to store anything from anywhere on the web or any computer and it is protected from others. You might also create folders for &quot;family&quot; and &quot;friends&quot; with permission granted to appropriate privacy groups.

[h3]Cloud Desktop Clients[/h3]


[h4]Cloud Desktop Clients - Windows[/h4]

WebDAV using Windows 7 graphical user interface wizard:
1. Left-click the Start-button to open the start menu.
2. Right-click the My computer icon to access its menu.
3. Left-click Map network drive... to open the connection dialog wizard.
4. Type '[baseurl]/dav/nickname' in the textbox (replace nickname with your channel nickname) and click the Complete button.
5. Type your $Projectname channel nickname. IMPORTANT - NO at-sign or domain name.
6. Type your $Projectname password

[h4]Cloud Desktop Clients - Linux[/h4]

[h5]Mount as a filesystem[/h5]

[b]Mounting As A Filesystem[/b]

To install your cloud directory as a filesystem, you first need davfs2 installed.  99% of the time, this will be included in your distributions repositories.  In Debian

[code]apt-get install davfs2[/code]

If you want to let normal users mount the filesystem

[code] dpkg-reconfigure davfs2[/code]

and select &quot;yes&quot; at the prompt.

Now you need to add any user you want to be able to mount dav to the davfs2 group

[code]usermod -aG davfs2 &lt;DesktopUser&gt;[/code]

[b]Note:[/b] on some systems the user group may be different, i.e. - "network"
on Arch Linux. If in doubt, check the davfs documentation for your
particular OS.

Edit /etc/fstab

[code]nano /etc/fstab[/code]

 to include your cloud directory by adding

[code]
[baseurl]/dav/ /mount/point davfs user,noauto,uid=&lt;DesktopUser&gt;,file_mode=600,dir_mode=700 0 1
[/code]

Where [baseurl] is the URL of your hub, /mount/point is the location you want to mount the cloud, and &lt;DesktopUser&gt; is the user you log in to one your computer.  Note that if you are mounting as a normal user (not root) the mount point must be in your home directory.

For example, if I wanted to mount my cloud to a directory called 'cloud' in my home directory, and my username was bob, my fstab would be

[code][baseurl]/dav/ /home/bob/cloud davfs user,noauto,uid=bob,file_mode=600,dir_mode=700 0 1[/code]

Now, create the mount point.

[code]mkdir /home/bob/cloud[/code]

and also create a directory file to store your credentials

[code]mkdir /home/bob/.davfs2[/code]

Create a file called 'secrets'

[code]nano /home/bob/.davfs2/secrets[/code]

and add your cloud login credentials

[code]
[baseurl]/dav &lt;username&gt; &lt;password&gt;
[/code]

Where &lt;username&gt; and &lt;password&gt; are the username and password [i]for your hub[/i].

Don't let this file be writeable by anyone who doesn't need it with

[code]chmod 600 /home/bob/.davfs2/secrets[/code]

Finally, mount the drive.

[code]mount [baseurl]/dav[/code]

You can now find your cloud at /home/bob/cloud and use it as though it were part of your local filesystem - even if the applications you are using have no dav support themselves.

[b]Troubleshooting[/b]

With some webservers and certain configurations, you may find davfs2 creating files with 0 bytes file size where other clients work just fine.  This is generally caused by cache and locks.  If you are affected by this issue, you need to edit your davfs2 configuration.

[code]nano /etc/davfs2/davfs2.conf[/code]

Your distribution will provide a sample configuration, and this file should already exist, however, most of it will be commented out with a # at the beginning of the line.

First step is to remove locks.

Edit the use_locks line so it reads [code]use_locks 0[/code].

Unmount your file system, remount your file system, and try copying over a file from the command line.  Note you should copy a new file, and not overwrite an old one for this test.  Leave it a minute or two then do [code]ls -l -h[/code] and check the file size of your new file is still greater than 0 bytes.  If it is, stop there, and do nothing else.

If that still doesn't work, disable the cache.  Note that this has a performance impact so should only be done if disabling locks didn't solve your problem.  Edit the cache_size and set it to [code]cache_size 0[/code] and also set file_refresh to [code]file_refresh 0[/code].  Unmount your filesystem, remount your file system, and test it again.

If it [i]still[/i] doesn't work, there is one more thing you can try.  (This one is caused by a bug in older versions of dav2fs itself, so updating to a new version may also help).  Enable weak etag dropping by setting [code]drop_weak_etags 1[/code].  Unmount and remount your filesystem to apply the changes.


[h5]Dolphin[/h5]
Visit webdavs://example.com/dav where &quot;example.com&quot; is the URL of your hub.

When prompted for a username and password, enter your channel name (the first part of your webbie - no @ or domain name) and password for your normal account.

Note, if you are already logged in to the web interface via Konqueror, you will not be prompted for further authentication.

[h5]Konqueror[/h5]

Simply visit webdavs://example.com/dav after logging in to your hub, where &quot;example.com&quot; is the URL of your hub.

No further authentication is required if you are logged in to your hub in the normal manner.

Additionally, if one has authenticated at a different hub during their normal browser session, your identity will be passed to the cloud for these hubs too - meaning you can access any private files on any server, as long as you have permissions to see them, as long as you have visited that site earlier in your session.

This functionality is normally restricted to the web interface, and is not available to any desktop software other than KDE.

[h5]Nautilus[/h5]

1. Open a File browsing window (that's Nautilus)
2. Select File &gt; Connect to server from the menu
3. Type davs://&lt;domain_name&gt;/dav/&lt;your_channelname&gt; and click Connect
4. You will be prompted for your channel name (same as above) and password
5. Your personal DAV directory will be shown in the window

[h5]Nemo[/h5]

For (file browser) Nemo 1.8.2 under Linux Mint 15, Cinnamon 1.8.8. Nemo ist the standard file browser there.

1st way
type &quot;davs://&lt;domain_name&gt;/dav/&lt;your_channelname&gt;&quot; in the address bar.

2nd way
Menu &gt; file &gt; connect to server
Fill the dialog
- Server: hubzilla_domain_name
- Type: Secure WebDAV (https)
- Folder: /dav
- Username: yourchannelname
- Password: yourpassword

Once open you can set a bookmark.

[h5]Server Notes[/h5]

Note: There have been reported issues with clients that use "chunked transfer encoding", which includes Apple iOS services, and also the "AnyClient" and "CyberDuck" tools. These work fine for downloads, but uploads often end up with files of zero size. This is caused by an incorrect implemention of chunked encoding in some current FCGI (fast-cgi) implementations. Apache running with PHP as a module does not have these issues, but when running under FCGI you may need to use alternative clients or use the web uploader. At the time of this writing the issue has been open and no updates provided for at least a year. If you encounter zero size files with other clients, please check the client notes; as there are occasional configuration issues which can also produce these symptoms.

[h3]Saved Searches[/h3]

In order to quickly find information, the 'saved search' widget may be used. This widget may be presented as a sidebar tool on your network page and possibly from your channel page. It is differentiated from the 'navigation bar' search tool in that it does not search the entire site, but only the subset of information available to your channel.

Additionally the search terms you provide may activate a one-time search or be saved in a list for re-use. Saving the search item also invokes the search in addition to adding it to the saved list (which is displayed below the search text entry box). Any item in the list may be discarded if it is no longer needed.

The saved search widget will provide autocompletion of channels (the results are prefixed with '@'), and hashtags (prefixed with '#'). You do not need to enter these tags; although entering the desired tag will reduce the autocomplete results to only hold the relevant information. The behaviour maps as follows:

[list]
[*]@name - search your network stream for posts or comments written by 'name'. This will also change the post editor permissions to include only 'name'; as if this was a privacy group.
[*]#hashtag - search you network stream for posts containing #hashtag.
[*]text - search your network stream for posts containing 'text'.
[/list]


[h3]Remove Channel or Account[/h3]

[h4]Remove Channel[/h4]

Select the 'Remove Channel' link on your channel settings page or visit the URL:

	[baseurl]/removeme

You will need to confirm your password and the channel you are currently logged into will be removed.

[hl][i][b]This is irreversible.[/b][/i][/hl]

If you have identity clones on other hubs this only removes  by default the channel instance which exists on this hub.

[h4]Remove Account[/h4]

Select 'Remove Account' from your account settings page or visit the URL:

	[baseurl]/removeaccount

You will need to confirm your password and the account you are currently logged into will be removed.

[hl][i][b]This is irreversible.[/b][/i][/hl]

All your channels will be deleted. If you have identity clones on other hubs this only removes by default the channels instances which exists on this hub.

