<?php
/*
 * Copyright (c) 2017 Hubzilla
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

namespace Zotlabs\Tests\Unit\includes;

use Zotlabs\Tests\Unit\UnitTestCase;
use Text_LanguageDetect;
//use phpmock\phpunit\PHPMock;

/**
 * @brief Unit Test cases for include/language.php file.
 *
 * @author Klaus Weidenbach
 */
class LanguageTest extends UnitTestCase {

	/**
	 * @covers ::get_language_name
	 * @dataProvider getLanguageNameProvider
	 */
	public function testGetLanguageName($lang, $name, $trans) {
		$this->assertEquals($name, get_language_name($lang));
		foreach ($trans as $k => $v) {
			//echo "$k -> $v";
			$this->assertEquals($v, get_language_name($lang, $k));
		}
	}

	public static function getLanguageNameProvider() {
		return [
				'empty language code' => [
						'',
						'',
						['de' => '']
				],
				'invalid language code' => [
						'zz',
						'zz',
						['de' => 'zz']
				],
				'de' => [
						'de',
						'German',
						[
								'de' => 'Deutsch',
								'nb' => 'tysk'
						]
				],
				'de-de' => [
						'de-de',
						'German',
						[
								'de-de' => 'Deutsch',
								'nb' => 'Deutsch' // should be tysk, seems to be a bug upstream
						]
				],
				'en' => [
						'en',
						'English',
						[
								'de' => 'Englisch',
								'nb' => 'engelsk'
						]
				],
				'en-gb' => [
						'en-gb',
						'British English',
						[
								'de' => 'Englisch (Vereinigtes Königreich)',
								'nb' => 'engelsk (Storbritannia)'
						]
				],
				'en-au' => [
						'en-au',
						'Australian English',
						[
								'de' => 'Englisch (Australien)',
								'nb' => 'engelsk (Australia)'
						]
				],
				'nb' => [
						'nb',
						'Norwegian Bokmål',
						[
								'de' => 'Norwegisch (Bokmål)',
								'nb' => 'norsk bokmål'
						]
				]
		];
	}
}
