<?php

namespace Zotlabs\Widget;

/**
 *   * Name: Activity order
 *   * Description: Order the network stream by posted date, last commented or by date unthreaded
 *   * Requires: network
 */

class Activity_order {

	function widget($arr) {

		if(! local_channel())
			return '';

 		if(! feature_enabled(local_channel(),'order_tab')) {
			set_pconfig(local_channel(), 'mod_network', 'order', 'created');
			return '';
		}

		$commentord_active = '';
		$postord_active = '';
		$unthreaded_active = '';

		if(x($_GET, 'order')) {
			switch($_GET['order']){
				case 'created':
					$postord_active = 'active';
					set_pconfig(local_channel(), 'mod_network', 'order', 'created');
					break;
				case 'commented':
					$commentord_active = 'active';
					set_pconfig(local_channel(), 'mod_network', 'order', 'commented');
					break;
				case 'unthreaded':
					$unthreaded_active = 'active';
					set_pconfig(local_channel(), 'mod_network', 'order', 'unthreaded');
					break;
				default:
					$commentord_active = 'active';
					break;
			}
		}
		else {
			$order = get_pconfig(local_channel(), 'mod_network', 'order', 'created');
			switch($order) {
				case 'commented':
					$commentord_active = 'active';
					break;
				case 'created':
					$postord_active = 'active';
					break;
				case 'unthreaded':
					$unthreaded_active = 'active';
					break;
				default:
					$postord_active = 'active';
			}
		}

		// override order for some filter results
		if(x($_GET,'search') || x($_GET,'file') || (! x($_GET,'pf') && x($_GET,'cid')) || x($_GET,'verb') || x($_GET,'tag') || x($_GET,'cat')  || x($_GET,'conv') || x($_GET,'unseen')) {
			$unthreaded_active = 'active';
			$commentord_active = $postord_active = 'disabled';
		}

		$cmd = \App::$cmd;

		$filter = '';

		if(x($_GET,'cid'))
			$filter .= '&cid=' . $_GET['cid'];

		if(x($_GET,'gid'))
			$filter .= '&gid=' . $_GET['gid'];

		if(x($_GET,'star'))
			$filter .= '&star=' . $_GET['star'];

		if(x($_GET,'conv'))
			$filter .= '&conv=' . $_GET['conv'];

		if(x($_GET,'file'))
			$filter .= '&file=' . $_GET['file'];

		if(x($_GET,'pf'))
			$filter .= '&pf=' . $_GET['pf'];


		// tabs
		$tabs[] = [
			'label' => t('Posted Date'),
			'icon' => '',
			'url'=>z_root() . '/' . $cmd . '?order=created' . $filter,
			'sel'=> $postord_active,
			'title' => t('Order by last posted date'),
		];

		$tabs[] = [
			'label' => t('Commented Date'),
			'icon' => '',
			'url'=>z_root() . '/' . $cmd . '?order=commented' . $filter,
			'sel'=> $commentord_active,
			'title' => t('Order by last commented date'),
		];

		$tabs[] = array(
			'label' => t('Date Unthreaded'),
			'icon' => '',
			'url' => z_root() . '/' . $cmd . '?order=unthreaded' . $filter,
			'sel' => $unthreaded_active,
			'title' => t('Order unthreaded by date'),
		);

		$arr = ['tabs' => $tabs];

		call_hooks('activity_order', $arr);

		$o = '';

		if($arr['tabs']) {
			$content =  replace_macros(get_markup_template('common_pills.tpl'), [
				'$pills' => $arr['tabs'],
			]);

			$o = replace_macros(get_markup_template('common_widget.tpl'), [
				'$title' => t('Stream Order'),
				'$content' => $content,
			]);
		}

		return $o;

	}

}
