## The Hubzilla project 

### Hubzilla Governance  

Governance refers to the management of a project and in particular how this relates to conflict resolution.

#### Community management  

The project is managed and decisions are made by the ‘community’. The governance structure is still under development. Until the structure is finalised, decisions are made in the following order:

1. Lazy consensus
   If a project proposal is made in one of the community governance forums and no serious objections are raised within a ‘reasonable’ period of time from the date of the proposal (we usually give all interested parties 2 to 3 days to comment), no vote is required and the proposal is deemed accepted. Concerns may be raised at this stage, but if these are resolved during the discussion and possible solutions are offered, the proposal is still considered approved. 
2. Veto
   Experienced developers who have already committed to many projects can veto any decision. The decision cannot proceed until the veto is lifted or an alternative proposal is submitted.
3. Community vote
   A decision for which there is no clear mandate or consensus, but which has not been vetoed, can be put to a Community vote. Currently, this is a simple referendum in one of the relevant community forums. At present, the people decide the outcome. This may change in the future if the community adopts a ‘council’ governance model. This document will be updated with the updated governance rules at that time.

Community voting does not always lead to a pleasant outcome and can lead to polarised factions in the community (so other models are also being considered). If the proposal is rejected, there are still various ways to resubmit the proposal with slightly different parameters (turning it into an addon, turning it into an optional feature that is disabled by default, etc.). If there is a lot of interest in the feature and the vote is ‘close’, this can cause a lot of bad feelings for the losing voters. In such close votes, **it** is **strongly recommended** that the requester take steps to address any concerns and resubmit the request.

#### Privacy   

Q: Who can see my content?
A: By default, EVERYONE on the Internet, unless you restrict it. Hubzilla allows you to choose the level of privacy you want. Restricted content is NOT visible to ‘spy networks’ and advertisers. You are protected against eavesdropping by outsiders - as much as possible. Hub administrators with sufficient knowledge and patience may be able to intercept some private communications, but they must make an effort to do so. There are privacy modes within Hubzilla that are tap-proof even for experienced and determined hub administrators.

Q: Can my content be censored?
A: Hubzilla (the network) CANNOT censor your content. Server and hub administrators are subject to local laws and MAY remove objectionable content from their site/hub. Anyone CAN become a hub administrator, including you, and therefore post content that might otherwise be censored. You MAY still be subject to local laws. 

##### Definitions   

**Hubzilla**, also referred to as ‘the network’, is a collection of individual computers/servers (also called **hubs** ) that are connected together to form a larger co-operative network. 

**Hub** 
A single computer or server that is connected to Hubzilla. These are provided by a **hub administrator** and can be public or private, paid or free.

**Hub administrator**
The system operator of a single hub. 

##### **Policies**   

**Public information**

Any information or content you post within Hubzilla MAY be public or visible to anyone on the Internet. Where possible, Hubzilla allows you to protect content and restrict who can see it.
Your profile photo, channel name, and the location (URL or network address) of your channel are visible to anyone on the Internet, and privacy controls do not affect the display of these items. 
You MAY additionally provide other profile information. Any information you provide in your ‘standard’ or **public profile** MAY be transmitted to other hubs in Hubzilla and additionally displayed in the channel directory. You can restrict access to this profile information. You can restrict it to members of your Hub only, to connections (friends) only, or to other limited groups of viewers as you wish. If you want your profile to be restricted, you must make the appropriate privacy settings or simply NOT provide any additional information. 

**Content**

The content you provide (status messages, photos, files, etc.) belongs to you. Hubzilla's default setting is that content is published openly and visible to everyone on the internet (PUBLIC). You CAN control this in your channel settings and restrict the default permissions or you CAN restrict the visibility of each published item separately (PRIVATE). Hubzilla developers ensure that restricted content is ONLY visible to those listed in the restriction list - as best they can. 
Content (especially status messages) that you share with other networks or that you have made visible to everyone on the internet (PUBLIC) cannot simply be taken back after it has been published. They MAY be shared with other networks and made available via RSS/Atom feeds. They can also be syndicated to other Hubzilla sites. They MAY appear on other networks and websites and be visible in web searches. If you do not want this default behaviour, please adjust your channel settings and restrict who can see your content. 

**Comments and forum posts**

Comments on posts created by others and posts labelled as forum posts belong to you as the creator/author, but the distribution of these posts is not under your direct control and you relinquish SOME rights to these elements. These posts/comments MAY be shared with others and MAY be visible to anyone on the Internet. In the case of comments, the creator of the ‘first post’ in the thread (conversation) you are replying to controls the distribution of all comments and replies to that post. He is the ‘owner’ and therefore has certain rights over the entire conversation (including all comments contained therein). You can still edit or delete the comment, but the owner of the conversation also has the right to edit, delete, redistribute and save/restore the entire content of the conversation. 

**Private information**

Hubzilla developers ensure that all content you provide that is labelled PRIVATE is protected against eavesdropping to the best of their ability. Private channel content MAY be seen in the database of any Hub administrator involved, but private messages are obscured in the database. The latter means that it is very difficult, but NOT impossible, for this content to be seen by a hub administrator. Private channel content and private messages are also removed from email notifications. End-to-end encryption is an optional feature that can NOT be seen even by a determined administrator. 

##### **Identity protection**   

Protecting your identity is another aspect. Since you have a decentralised identity in Hubzilla, your privacy extends beyond your home hub. If you want to have complete control over your privacy and security, you should run your own hub on your own server. For many people, this is complicated and can overwhelm their technical skills. So let's list some precautions you can take to protect your privacy as much as possible.
A decentralised identity has many advantages and offers you many interesting features, but you should be aware of the fact that your identity is known to other hubs in the Hubzilla network. One of these benefits is that other channels can offer you customised content and allow you to see private things (such as private photos that others want to share with you). For this reason, these channels need to know who you are. But we understand that sometimes these other channels know more about you than you might want them to. For example, the Visage plug-in, which can tell a channel owner when you last visited their profile. You can easily opt out of this minor and, we think, harmless tracking.

\* You can enable [Do Not Track (DNT)](#)[(http://donottrack.us/)?f=&zid=pepecyb@hub.hubzilla.hu)](http://donottrack.us/)?f=&zid=pepecyb@hub.hubzilla.hu)) in your web browser. We respect this new privacy proposal. All modern browsers support DNT. You can find it in the privacy settings of your browser or you can consult the manual of your web browser. This will not affect the functionality of Hubzilla. This setting is probably sufficient for most people.

*You can [disable](Einstellungen) the publication of your channel in our channel directory. If you want others to find your channel, you should tell them your channel address directly. We think this is a good indication that you prefer extra privacy and will automatically enable ‘Do Not Track’ if this is the case.

\* You can have a blocked hub. This means that all channels and content in this hub are not public and not visible to the outside world. Only your hub administrator can do this. We also respect this and automatically activate ‘Do Not Track’ if it is set.

##### **Censorship**   

Hubzilla is a global network that includes all religions and cultures. This does not mean that every member of the network feels the same way you do about controversial topics, and some people may OBJECT to the content you post. If you want to post something that you know may not be accepted by everyone, it is best to limit the publicity to a small circle of friends using the privacy controls. 

Hubzilla as a network provider cannot censor content. Hub administrators CAN, however, censor content that appears on their hub to comply with local laws or even personal judgement. Their decision is final. If you have issues with a hub administrator, you can move your account and posts to another site that better meets your expectations. Please check your Hub's [Terms of Service](help/TermsOfService) (regularly) to be aware of any rules or guidelines. If your content consists of illegal or problematic material, we STRONGLY recommend that you run your own hub (become a hub administrator). Your content may be blocked on some hubs, but Hubzilla as a network cannot prevent it from being published.

Hubzilla RECOMMENDS that hub administrators allow a 1-2 day grace period between warning an account owner of content to be removed and the physical removal or deactivation of the account. This gives the content owner the opportunity to export their channel metadata and import it to another site. In rare cases, the content may be of such a nature that immediate account cancellation is warranted. This is a Hub decision, not a Hubzilla decision. 

If you typically and regularly post content of a harmful or offensive nature, you are STRONGLY encouraged to flag your account as ‘NSFW’ (Not Safe For Work). This will prevent your profile photo from being displayed in the directory, except to viewers who have disabled ‘safe mode’. If your profile photo is deemed adult or offensive by the directory administrators, the directory administrator MAY flag your profile photo as NSFW. Currently, there is no official mechanism to appeal or reverse this decision. Therefore, you SHOULD flag your own account as NSFW if it may be inappropriate for a general audience. 