[h3]Przegląd[/h3]

Chociaż wiele funkcji i możliwości Hubzilli jest znanych osobom, które korzystały z serwisów społecznościowych i oprogramowania do blogowania, istnieje również sporo nowych koncepcji i funkcji, z którymi większość osób wcześniej się nie zetknęła. Niektóre z nowych pomysłów są związane ze zdecentralizowanym charakterem sieci; inne są związane z zaawansowanym systemem uprawnień, który jest niezbędny do ochrony prywatności danych. Celem tego przewodnika jest pomóc w zrozumieniu, jak tworzyć, konfigurować i używać tożsamość nomadyczną.

[h3]Rejestracja[/h3]

Nie wszystkie serwisy oparte na $Projectname umożliwiają otwartą rejestrację. Jeśli rejestracja jest dozwolona, zobaczysz łącze &quot;Rejestracja&quot; bezpośrednio pod formularzem logowania. Kliknięcie tego linku przeniesie Ciebie do strony rejestracyjnej. W niektórych serwisach, link ten może przekierować do innej witryny, która umożliwia rejestrację. Ponieważ wszystkie serwisy Hubzilla są połączone, nie ma znaczenia, gdzie znajduje się Twoje konto.

[b]Twój ades e-mail[/b]

Trzeba tu wprowadzić poprawny adres e-mail. Twój adres e-mail nigdy nie jest publikowany. Ten adres będzie używany do aktywacji konta, do ewentualnego wysyłania powiadomień o przychodzących wiadomościach lub wpisach oraz do odzyskiwania utraconych haseł.

[b]Hasło[/b]

Wprowadź wybrane hasło i powtórz je w drugim polu, aby upewnić się, że zostało wpisane poprawnie. Ponieważ Hubzilla oferuje zdecentralizowaną tożsamość, Twoje konto może zalogować Cię do wielu innych serwisów internetowych sieci Hubzilla.

[b]Regulamin serwisu[/b]

Kliknij to łącze, aby przeczytać dokument [zrl=[baseurl]/help/TermsOfService]Regulamin serwisu[/zrl]. Po ich przeczytaniu zaznacz pole w formularzu rejestracyjnym, aby to potwierdzić.

[b]Rejestracja[/b]

Po podaniu niezbędnych informacji, kliknij przycisk "Zarejestruj się". Niektóre serwisy mogą wymagać zatwierdzenia rejestracji przez administratora, zanim zostanie ona przetworzona, o czym osoba rejestrująca zostanie powiadomiona. Trzeba więc śledzić swoją pocztę e-mail (w tym folder ze spamem) w celu potwierdzenia rejestracji.

[h3]Kanały[/h3]

[h4][b]Co to są kanały?[/b][/h4]

Kanały to zbiory treści powiązane z profilem. Kanał może mieć różną formę. Może reprezentować Ciebie (kanał osobisty), być witryną internetową, forum, albumem ze zdjęciami, czymkolwiek. Dla większości osób pierwszym kanałem jest kanał osobisty, reprezentujący tą osobę.

Najważniejsze cechy kanału, który reprezentuje &quot;Ciebie&quot;, to:
[ul]
[*]Bezpieczna i prywatna komunikacja &quot;wolna od spamu&quot;

[*]Tożsamość i &quot;pojedyncze logowanie&quot; w całej sieci Hubzilla;

[*]Kotrola prywatności i uprawnienia, które obejmują całą sieć;

[*]Usugi katalogowe (np. Książka telefoniczna).
[/ul]
Krótko mówiąc, kanał, który reprezentuje Ciebie, &quot;opisuje Ciebie w internecie&quot;.

[h4][b]Uprawnienia w kanale oparte na rolach[/b][/h4]

W celu uproszczenia zarządzaniem uprawnieniami w kanałach, w Hubzilla wprowadzono &quot;role uprawnieniowe&quot;. Podczas tworzenia nowego kanału użytkownik jest proszony o wybranie roli jaką ma pełnić kanał. Z każdą z takich ról związany jest zestaw uprawnień. Najpopularniejszą rolą uprawnień jest rola sieci społecznościowej. Ma się wiele innych możliwości, dzięki opcjom, które są analogiczne do grup i stron na Facebooku, przestrzeni współpracy, kanałów aktualności (RSS) i nie tylko. Te role automatycznie konfigurują kilka różnych zmiennych systemowych, od uprawnień przyznanych znajomym, po domyślne ustawienia prywatności i opcje widoczności. Dostępne są zaawansowane konfiguracje, które umożliwiają dostosowanie każdego z tych parametrów do własnych potrzeb. Stwierdziliśmy jednak, że większość ludzi woli &quot;ustawić i zapomnieć&quot;. Dalej opisano niektóre z różnych ról, które są obecnie dostępne oraz ich wpływ na prywatność uzytkownika i zdolność do interakcji.

[h5][b]Kanał społecznościowy[/b][/h5]

[b]- federacyjny[/b]

Kanał tego rodzaju jest bardzo liberalnym profilem społecznościowym, który jest kompatybilny z innymi federacyjnymi sieciami społecznościowymi. Zasady zezwoleń są podobne do Twittera i w większości zgodne z Diasporą i Mastodonem. Prywatność ma niższy priorytet niż łatwość dostępu i łączenia się z innymi. Każdy w sieci Fediverse może komentować Twoje publiczne wpisy i wysyłać Ci prywatną pocztę. Domyślnie wpisy i inne publikowane elementy są publiczne, ale można do nich ograniczyć dostęp przy ich tworzeniu. Jesteś wymieniony w katalogu. Twoja obecność w Internecie i połączenia są widoczne dla innych. Ten tryb może zwiększyć narażenie na niepożądaną komunikację i spam. Rola ta nie jest ogólnie zalecana, chyba że musisz regularnie kontaktować się z członkami innych sieci.

[b]- przeważnie publiczny[/b]

Kanał jest typowym profilem społecznościowym. Twoje wpisy i opublikowane elementy są domyślnie publiczne, ale możesz to zmienić podczas tworzenia elementu i ograniczyć dostęp do niego. Jesteś wymieniony w katalogu. Twoja obecność w Internecie i połączenia są widoczne dla innych. Tylko osoby z bezpośrednich kontaktów mogą komentować Twoje publiczne wpisy i wysyłać Ci prywatną pocztę. Zasady pozwoleń są podobne do Facebooka.

[b]- ograniczony[/b]

Domyślnie wszystkie wpisy i opublikowane elementy są wysyłane do prywatnej grupy prywatności "Znajomi" i nie są upubliczniane. Do tej grupy prywatności są dodawani nowi znajomi. Jeśli chcesz, możesz to zmienić i utworzyć publiczny wpis lub inny publicznie dostępny element. Jesteś wymieniony w katalogu. Twoja obecność online (na czacie) i Twoje kontakty (znajomi) są widoczne dla przeglądających Twój profil.

[b]- prywatny[/b]

Domyślnie wszystkie wpisy i opublikowane elementy są wysyłane do grupy prywatności "Znajomi". Do tej grupy dodawani są Twoi nowi znajomi. Możesz to zmienić i utworzyć publiczny wpis lub inny element publiczny, jeśli chcesz. NIE jesteś wymieniony w katalogu. Tylko osoby z Twoich kontaktów mogą zobaczyć Twoje inne połączenia. Twoja obecność w Internecie jest ukryta.


[h5][b]Forum[/b][/h5]

[b]- przeważnie publiczne[/b]

Kanał typowy dla publicznego forum. Wpisy i publikowane elementy są domyślnie publiczne. Członkowie mogą publikować przez "!wzmiankę" lub wpis pełny. Zablokowane jest publikowanie zdjęć i innych elementów. Kanał jest widoczny w katalogu. Członkowie są dodawani automatycznie.

[b]- ograniczone[/b]

Domyślnie wszystkie wpisy i opublikowane elementy są wysyłane do grupy prywatności "Znajomi" kanału. Do tej grupy dodawani są nowi znajomi. Członkowie mogą publikować przez "!wzmiankę" lub wpis pełny, ale wpisy i odpowiedzi mogą być również widoczne dla innych odbiorców wpisów najwyższego poziomu, którzy nie są członkami. Kanał jest widoczny w katalogu. Członkowie muszą być ręcznie dodani przez właściciela forum.

[b]- prywatne[/b]

Domyślnie wszystkie wpisy i opublikowane elementy są wysyłane do grupy prywatności "Znajomi". Do tej grupy dodawani są nowi znajomi. Właściciel może to zmienić i w razie potrzeby utworzyć publiczny wpis lub element publiczny. Członkowie tego nie mogą. NIE jesteś wymieniony w katalogu. Tylko osoby z Twoich kontaktów mogą zobaczyć Twoje inne połączenia. Twoja obecność w Internecie jest ukryta. Członkowie muszą być dodani ręcznie przez właściciela forum. Wysyłanie przez "!wzmiankę" jest wyłączone. Wpisy można publikować wyłącznie za pośrednictwem wpisów pełnych i wysyłać do członków grupy prywatności "Znajomi". Nie są oni publicznie widoczni.

[h5][b]Kanał RSS[/b][/h5]

[b]- publiczny[/b]

Podobne do kanału społecznościowego - głównie publicznego, ale dostosowany do źródeł kanałów RSS. Elementy mogą być swobodnie publikowane i pozyskiwane. Obecność w Internecie jest bez znaczenia, dlatego jest ukryta. Nowe połączenia są automatycznie zatwierdzane.


[b]- ograniczony[/b]

Kanał nie jest wymieniony w katalogu. Obecność w Internecie jest bez znaczenia, dlatego jest ukryta. Kanał jest publikowany tylko dla członków grupy prywatności "Przyjaciele". Nowe połączenia są automatycznie dodawane do tej grupy prywatności. Członkowie muszą zostać ręcznie zatwierdzeni przez właściciela kanału.


[h5][b]Kanał specjalny[/b][/h5]

[b]- celebrycki lub mównica[/b]

Autorzy są wymienieni w katalogu. Komunikaty są domyślnie publiczne. Obecność w Internecie jest ukryta. Nie wolno komentować ani odpisywać w jakiejkolwiek formie, chociaż odwiedzający mogą "polubić" profil autora.


[b]- repozytorium gupowe[/b]

Forum publiczne, które umożliwia członkom publikowanie plików, zdjęć i stron internetowych.

[h5][b]Tryb niestandardowy i ekspercki[/b][/h5]

Prywatność i uprawnienia ustawia się ręcznie, aby dopasować je do swoich potrzeb.


[h4][b]Tworzenie kanałów[/b][/h4]

Po utworzeniu konta zostanie wyświetlony ekran &quot;Dodaj kanał&quot;. Zwykle pierwszym kanałem będzie ten, który reprezentuje Ciebie, więc użycie własnego imienia i nazwiska (lub pseudonimu) jako nazwy kanału jest dobrym pomysłem. Nazwę kanału należy traktować jako tytuł lub krótki opis kanału. Pole "Wybierz krótki pseudonim" jest podobne do pola "Nazwa użytkownika". Wykorzystamy wszystko, co tu wpiszesz, do utworzenia adresu kanału, którego będą używać inne osoby do łączenia się z Twoim kanałem, a Ty będziesz używać to do logowania się w innych witrynach. Wygląda to jak adres e-mail i ma wpisuć [i]pseudonim@serwis_twojej_rejestracji.xyz[/i].

Możesz tworzyć dodatkowe kanały, korzystając z odnośnika &quot;Menedżer kanałów&quot;.

Gdy to zrobisz, Twój kanał będzie gotowy do użycia. Pod adresem [observer=1][observer.url][/observer][observer=0][baseurl]/channel/username[/observer] znajdziesz &quot;strumień&quot; swojego kanału. Tutaj pojawi się Twoja ostatnia aktywność w odwrotnej kolejności chronologicznej. Jeśli opublikujesz wpis w polu oznaczonym "udostępnij", wpis pojawi się u góry Twojego strumienia. Znajdziesz tu również linki do wszystkich innych obszarów komunikacji tego kanału. Menu z ikoną "hamburger" w większości motywów zapewnia nawigację do innych składników systemu i aplikacji. Strona "Zdjęcia" zawiera albumy ze zdjęciami, a strona "Wydarzenia" zawiera wydarzenia udostępnione przez Ciebie i Twoje kontakty.

[h4][b]Profile[/b][/h4]

W $Projectname użytkownik może mieć wiele profili. Można używać różnych profili, aby pokazać różne "strony siebie" różnym odbiorcom. Różni się to od posiadania różnych kanałów. Różne kanały pozwalają na przesyłanie zupełnie różnych zestawów informacji. Można mieć kanał dla siebie, kanał dla swojej drużyny sportowej, kanał dla swojej witryny internetowej lub cokolwiek innego. Profil pozwala na precyzyjne stopniowanie "aspektów" kanału. Na przykład Twój domyślny profil publiczny może mówić "Cześć, jestem Fred i lubię się śmiać". Możesz pokazać swoim bliskim znajomym profil z dopiskiem "i ja też lubię rzucać krasnoludami".

Zawsze masz profil nazywany profilem "domyślnym" lub "publicznym". Ten profil jest zawsze ogólnodostępny i nie można go ukryć (mogą występować rzadkie wyjątki w witrynach uruchamianych prywatnie lub odłączonych). Można i raczej powinno się ograniczyć informacje, które udostępnia się w swoim profilu publicznym.

Tak więc, jeśli chcesz, aby inni znajomi mogli Cię znaleźć, warto mieć następujące informacje w swoim profilu publicznym:

[ul][*]Twoje prawdziwe imię i nazwisko lub przynajmniej pseudonim, który wszyscy znają;
[*]Twoje zdjęcie;
[*]Twoją lokalizacja, przynajmniej na poziomie kraju.[/ul]

Ponadto, jeśli chcesz poznać osoby, które mają podobne zainteresowania, poświęć chwilę i dodaj do swojego profilu kilka "słów kluczowych". Na przykład "muzyka, linux, fotografia" lub cokolwiek innego. Możesz dodać dowolną liczbę słów kluczowych.

Aby utworzyć alternatywny profil, najpierw przejdź do [zrl=[baseurl]/settings/features]Ustawienia &gt; Dodatkowe funkcje[/zrl] i włącz tam opcję &quot;Wiele profili&quot;, w przeciwnym razie nie będziesz mieć możliwości korzystania z więcej niż tylko profilu domyślnego.

Następnie wybierz "Edytuj profile" z menu swojej witryny Hubzilla. Możesz edytować istniejący profil, zmienić zdjęcie profilowe, dodać rzeczy do profilu lub utworzyć nowy profil. Możesz także utworzyć "klon" istniejącego profilu, jeśli chcesz zmienić tylko kilka elementów, ale nie chcesz ponownie wprowadzać wszystkich informacji. Aby to zrobić, kliknij profil, który chcesz sklonować i wybierz tam "Klonuj ten profil".

Na liście swoich profili możesz również wybrać kontakty, które mogą zobaczyć Twój dodatkowy profil. Wystarczy kliknąć "Edytuj widoczność" obok profilu (dostępne tylko dla profili, które nie są Twoim profilem domyślnym), a następnie kliknąć określone połączenia, aby je dodać lub usunąć z grupy osób, które mogą wyświetlać ten profil.

Po wybraniu profilu osoba przeglądająca Twój profil zobaczy przypisany przez Ciebie profil prywatny. Jeśli nie są oni uwierzytelnieni, zobaczą Twój profil publiczny.

Istnieje ustawienie, które pozwala opublikować swój profil w katalogu i zapewnić, że będzie można go znaleźć innym. Możesz zmienić to ustawienie na stronie "Ustawienia".

Jeśli nie chcesz, aby Cię widziano w internecie, ustaw swój profil jako prywatny.

[h4][b]Słowa kluczowe i wyszukiwanie w katalogu[/b][/h4]

Na stronie katalogu możesz wyszukiwać osoby z opublikowanymi profilami. Obecnie przeszukiwane jest tylko pole nazwy i słowa kluczowe. Możesz również umieścić takie słowa kluczowe w swoim domyślnym profilu - które mogą być używane do wyszukiwania wspólnych zainteresowań z innymi członkami. Słowa kluczowe są używane w narzędziu propozycji kanałów i chociaż nie są widoczne w katalogu, są wyświetlane, gdy ktoś odwiedza stronę Twojego profilu.

Na stronie "Połączenia" oraz w katalogu znajduje się odnośnik, odpowiednio do "Sugestii" lub "Propozycji kanałów". Pozwoli to znaleźć kanały, które mają pasujące lub podobne słowa kluczowe. Im więcej podasz słów kluczowych, tym trafniejsze będą wyniki wyszukiwania. Są one sortowane według trafności.

Przecztaj też:

[zrl=[baseurl]/help/pl/AdvancedSearch]Zaawansowane przeszukiwanie[/zrl]

[h4][b]Sieć, uprawnienia i delegowanie[/b][/h4]

Strona "Sieć" zawiera wszystkie najnowsze wpisy z całej sieci Hubzilla, wykazane w odwrotnej kolejności chronologicznej. Wpisy, które się tutaj pojawiają, zależą w dużej mierze od ustawionych przez siebie preferencji. Na najbardziej liberalnym poziomie uprawnień będziesz otrzymywać wpisy od zupełnie obcych osób. Na drugim końcu skali możesz zobaczyć wpisy tylko od znajomych - lub, jeśli czujesz się naprawdę niezainteresowany społecznością, tylko własne wpisy.

Jak wspomniano na początku, możliwych jest wiele innych rodzajów kanałów, jednak procedura tworzenia jest taka sama. Różnica między kanałami polega przede wszystkim na przypisanych uprawnieniach. Na przykład kanał umożliwiający udostępnianie dokumentów współpracownikom w pracy prawdopodobnie wymagałby bardziej liberalnych ustawień "Może zapisywać w moim" publicznym "magazynie plików" niż na koncie osobistym.

Możesz również przekazać kontrolę nad wpisami i połączeniami swoich kanałów, ale nie nad ich konfiguracjami, innemu kanałowi. Odbywa się to poprzez edycję połączenia i przypisanie mu uprawnień do administrowania zasobami Twojego kanału.

[h3]Przyłączanie się do kanałów[/h3]

Połączenie jest w $Projectname określane jako zestaw uprawnień, które nadało się komuś innemu do dostępu do swoich treści. W tradycyjnych aplikacjach sieci społecznościowych wszystkie połączenia mają takie same uprawnienia lub najwyżej dwa poziomy ("znajomi" i "obserwujący"). W Hubzilla można ustawić (dostosować) szereg oddzielnych uprawnień w zależności od sytuacji i relacji, jakie masz z innym kanałem. Możesz zezwolić komuś na wyświetlanie swoich wpisów, ale nie zdjęć. Możesz również odmówić im pozwolenia na komentowanie swoich wpisów lub wysyłanie prywatnych wiadomości do Ciebie.

Jak przyłączyć się do jakiegoś kanału?

Najpierw musisz znaleźć kanał, z którym chcesz się połączyć. Można to zrobić na dwa sposoby. Po pierwsze, ustaw opcję "Może przesyłać mi swój strumień i wpisy z kanału" na zezwoleniea dla "Wszystkich w tej sieci", co spowoduje dostęp do wpisów od zupełnie obcych osób do Twojej matrycy. Zapewni ci to dużo treści publicznych i miejmy nadzieję, że pomoże Ci znaleźć interesujących, zabawnych ludzi, fora i kanały.

Następną rzeczą, jaką możesz zrobić, jest przejrzenie katalogu. Katalog jest dostępny w każdej witrynie Hubzilli, co oznacza, że wyszukiwanie z poziomu własnej witryny przyniesie wyniki z całej sieci. Możesz wyszukiwać według nazwy, zainteresowania, lokalizacji i słowa kluczowego.

Jeśli znasz już czyjąś "webbie", możesz bezpośrednio się z tą osobą skontaktować. Webbie to identyfikator, który wygląda jak adres e-mail (na przykład bob@example.com), ale odnosi się do kogoś w otwartej sieci społecznościowej. Aby się połączyć, osoby te muszą używać kompatybilnego protokołu sieciowego. Domyślnie, nasze  oprogramowanie obsługuje protokół "Zot", jednak dodatkowe protokoły mogą być dostarczane za pośrednictwem wtyczek (dodatków). Więcej informacji na temat łączenia się z kanałami w innych sieciach znajduje się poniżej.

Aby połączyć się z innymi kanałem $Projectname:

Odwiedź profil tego kanału, klikając jego zdjęcie w katalogu, matrycy lub komentarzach, a otworzy się strona główna kanału w przeglądarce kanału. Po lewej stronie ekranu zwykle jest widoczny link o nazwie "Connect". Kliknij i gotowe. W zależności od ustawień kanału, z którym się łączysz, być może będziesz musiał poczekać, aż właściciel zatwierdzi połączenie, ale nie musisz nic robić. Po zainicjowaniu połączenia zostaniesz przeniesiony do edytora połączeń. Dzięki temu możesz przypisać określone uprawnienia do tego kanału, jeśli chcesz wprowadzić jakiekolwiek zmiany.

Aby połączyć się z kanałami w innych sieciach niż sieć $Projectname:

Proces łączenia się z kanałami w innych sieciach (takich jak GNU-Social, Mastodon czy Diaspora) jest podobny - wpisz odpowiednie "webbie" do pola "Dodaj nowe połączenia" na stronie "Połączenia". Jednak zanim to zrobisz, odwiedź stronę "Ustawienia" ("Ustawienia funkcji i dodatków") i upewnij się, że w Twoim portalu jest dostępny odpowiedni protokół (Diaspora, GNU-Social/OStatus lub ActivityPub) i [b][i]jest aktywowany[/i] dla Twojego kanału[/b]. Te sieci (protokoły) nie obsługują migracji kont i niezależności lokalizacji, więc jeśli przeniesiesz lokalizację lub sklonujesz swój kanał w inne miejsce, komunikacja z tymi połączeniami może się nie udać. Z tego powodu protokoły te nie są domyślnie aktywowane, ale ich aktywacja wymaga Twojej zgodą. Aktywacja tych protokołów wiąże się z podjęciem ważkiego rozstrzygniecia korzyści płynących z kmunikowania się ze znajomymi w tych sieciach a z drugiej strony, zapewnieniem odporności konta na awarie serwera.

Niektóre rodzaje komunikacji oferują więcej niż jeden protokół. Jeśli chcesz połączyć się z kimś na Mastodonie (na przykład), możesz użyć do komunikacji protokołu "Ostatus" lub "AactivityPub". Generalnie, protokół "ActivityPub" zapewnia lepszą obsługę niż "Ostatus", ale Hubzilla często wybiera pierwszy protokół, który odkryje i może to nie być to, czego chcesz. Możesz połączyć się z kimś przez określony protokół, poprzedzając nazwę protokołu w nawiasach kwadratowych na tym "webbie". Na przykład:

[code]
[activitypub]https://foo.bar/foobar
[ostatus]foobar@foo.bar
[diaspora]foobar@foo.bar
[zot]foobar@foo.bar
[feed]https://foo.bar/foobar
[/code]

Aby połączyć zię z kanałami RSS:

Administrator portalu może zezwolić na łączenie się z kanałami RSS. Proces łączenia się z kanałem RSS jest taki sam, z wyjątkiem wpisania (lub wklejenia) adresu URL kanału w polu "Dodaj nowe połączenie". Kanały są przetwarzane tylko raz lub dwa razy dziennie, a administrator portalu może nałożyć ograniczenia na liczbę dodawanych kanałów.

[h4][b]Blokowanie, ignorowanie, archiwizowanie i ukrywanie kanałów[/b][/h4]

Kanały w książce adresowej mogą mieć statusy, takie jak [i]zablokowany[/i], [i]ignorowany[/i], [i]zarchiwizowany[/i] i [i]ukryty[/i]. Na stronie połączeń możesz zobaczyć zakładki, które wyświetlają kanały o tych statusach. Na stronach edycji połączenia możesz zmienić status kanału.

Oto ich znaczenie:

[b]Zablokowany:[/b] w kanale nie moża odczytywać elementów, niezależnie od uprawnień, ani zapisywać cokolwiek.

[b]Ignorowany:[/b] w kanale można odczytywać elementy, jeśli ma się odpowiednie uprawnienia, ale nie można tu nic zapisywać.

[b]Ukryty:[/b] kanał nie pojawia się na liście połączeń profilu, nikt nie może zobaczyć, że jesteś połączony, ale trzeba mieć na uwadze, że treści mogą nadal pojawiać się innych połączeniach, na przykład w odpowiedziach na wpisy.

[b]Archiwizowany:[/b] jeśli kanał nie jest dostępny przez 30 dni, jest automatycznie oznaczany jako "zarchiwizowany". Wszystkie dane zostają zachowane, ale zatrzymane zostaje odpytywanie kanału w poszukiwaniu nowych informacji i usuwa się go z autouzupełniania. Jeśli później dowiesz się, że kanał wrócił do trybu online, możesz ręcznie przywrócić go z archiwum.

[h4][b]Kanały Premium[/b][/h4]

Niektóre kanały są oznaczone jako "kanały premium" i mogą wymagać pewnych działań ze strony odwiedzajacego, zanim będzie on mógł nawiązać połączenie. Przycisk "Połącz" w przypadku tych kanałów przeniesie Cię do strony zawierającej szczegółowe informacje o warunkach, które ustanowił właściciel kanału. Jeśli warunki zostaną zaakceptowane, połączenie będzie kontynuowane normalnie. W niektórych przypadkach, na przykład w przypadku celebrytów i światowej sławy wydawców, może to wymagać zapłaty. Jeśli nie zgadzasz się z warunkami, połączenie nie będzie kontynuowane lub może być kontynuowane, ale z ograniczonymi uprawnieniami dozwolonymi dla twoich interakcji z tym kanałem.

[h3]Uprawnienia[/h3]
Uprawnienia w $Projectname są pełniejsze niż te, do których możesz być przyzwyczajony. To pozwala nam zdefiniować lepiej oceniane relacje niż czarno-białe: "ta osoba jest moim przyjacielem, więc może zrobić wszystko" lub "ta osoba nie jest moim przyjacielem, więc nie może nic zrobić", jak to ma miejsce w innych serwisach społecznościowych.

[h4][b]Role uprawnieniowe[/b][/h4]

Tworząc kanał, można wybrać różne "role" dla tego kanału. Tworzą one całą rodzinę uprawnień i ustawień prywatności, które są odpowiednie dla tej roli. Typowe role to "Społeczne - głównie publiczne", "Społeczne - głównie prywatne", "Forum - publiczne" i wiele innych. Zapewniają one pewien poziom prostoty zarządzania uprawnieniami. Wystarczy wybrać rolę, a odpowiednie uprawnienia zostaną zastosowane automatycznie. Możesz także wybrać "Tryb niestandardowy/ekspercki" i zmienić indywidualne ustawienia uprawnień w dowolny sposób. 

[h4][b]Domyślne ograniczenia uprawnień[/b][/h4]

Istnieje wiele indywidualnych uprawnień. Kontrolują one wszystko, od przeglądania strumienia po możliwość czatowania z Tobą. Każde pozwolenie ma limit. Zakres tych uprawnień waha się od "Tylko ja" do "Wszyscy w Internecie" - chociaż niektóre zakresy mogą nie być dostępne dla niektórych uprawnień. Limit dotyczy każdej opublikowanej rzeczy, którą tworzysz, a która nie ma kontroli prywatności ani kontroli dostępu. Na przykład, jeśli publikujesz zdjęcie i nie wybrałeś określonej grupy odbiorców z pozwoleniem na jego przeglądanie, stosujemy ten limit. Te ograniczenia dotyczą wszystkiego w ramach tej reguły pozwolenia, więc nie możesz zastosować ograniczenia do jednego zdjęcia. Limit dotyczy wszystkich Twoich zdjęć. Jeśli wszystkie Twoje zdjęcia są widoczne dla wszystkich w Internecie i ograniczysz limit tylko do znajomych, wszystkie Twoje zdjęcia będą teraz widoczne tylko dla znajomych.

[h4][b]Kontrola dostępu[/b][/h4]
 
Kontrola dostępu jest preferowaną metodą zarządzania prywatnością w [i]większości[/i] przypadków, zamiast stosowania ograniczania uprawnień. Polega ona na utworzeniu list połączeń lub grup prywatności (lub obu na raz) i na podstawie listy kontroli dostępu (ACL) użytkownik decyduje, czy zezwolenie jest dozwolone. Lista kontroli dostępu jest dołączona do wszystkiego, co się publikuje. W przeciwieństwie do ograniczeń uprawnień, zmiana listy kontroli dostępu na jednym zdjęciu nie ma wpływu na żadne z pozostałych zdjęć. Możesz użyć grup prywatności i "domyślnej listy kontroli dostępu", aby utworzyć i zautomatyzować zarządzanie listami kontroli dostępu, tak aby zapewnić dowolny poziom prywatności dla wszystkiego, co publikujesz.

Zdecydowanie zalecamy skorzystanie z ustawień "typowej sieci społecznościowej" podczas tworzenia pierwszego kanału, ponieważ umożliwia to innym komunikowanie się z Tobą i pomaga w razie trudności. Przekonasz się, że te ustawienia zapewniają tyle prywatności, ile chcesz - kiedy tego chcesz; ale także pozwalają komunikować się publicznie, jeśli zechcesz. Po opanowaniu obsługi możesz swobodnie korzystać z dużo bardziej prywatnych ustawień.

[dl terms="l"]
[*= Zakresy uprawnień to:]
[dl terms="i"]
  [*= Nikt oprócz Ciebie ] To jest oczywiste. Tylko Ty będziesz mieć dostęp.
  
  [*= Tylko ci, którym jawnie zezwalasz ] Domyślnie osoby, z którymi nie jesteś połączony i wszystkie nowe kontakty będą miały odmowę tego uprawnienia. Można robić wyjątki dla poszczególnych kanałów na ich ekranie edycji kontaktów.
  
  [*= Każdy w Twojej książce adresowej ] Każdy, kto nie znajduje się w Twojej książce adresowej ma odmowę dostępu, ale każdy kogo zaakceptujesz jako kontakt, uzyska zezwolenie. Jest to sposób stosowany na większości starszych platform.
  
  [*= Każdy na tym portalu ] Każdy, kto ma kanał w tym samym portalu co Ty, będzie miał pozwolenie. Każdemu, kto jest zarejestrowany na innym portalu, odmawia się dostępu.
  
  [*= Każdy w tej sieci ] Każdy w sieci $Projectname będzie miał zatwierdzone to pozwolenie. Nawet zupełnie obce osoby. Jednak każdemu, kto nie jest zalogowany (uwierzytelniony), tego dostępu się odmiawia.
  
  [*= Każdy uwierzytelniony ] Jest to podobne do uprawnienia "każdy w tej sieci", z tym wyjątkiem, że może obejmować każdego, kto może uwierzytelnić się w jakikolwiek sposób - a zatem może obejmować odwiedzających z innych sieci.
  
  [*= Token dostępu gościa] Umożliwia to udostępnianie pliku, folderu, zdjęcia, albumu lub kanału określonej osobie lub grupie osób. Nie muszą być członkami Hubzilli. Możesz ustawić ważność tokenu dostępu.

  [*= Każdy w Internecie ] Element jest całkowicie publiczny. To pozwolenie umożliwia dostęp każdemu.
[/dl]
[*= Indywidualne uprawnienia, to:]
[dl terms="i"]
  [*= Można wyświetlać mój "publiczny" strumień i wpisy. ] To uprawnienie określa, kto może oglądać "strumień" Twojego kanału, czyli nieprywatne wpisy, które pojawiają się na karcie "Strona główna", gdy jesteś zalogowany.

  [*= Można wyświetlać mój "publiczny" profil kanału. ] To uprawnienie określa, kto może wyświetlać profil Twojego kanału. Dotyczy to zakładki "o mnie".

  [*= Można wyświetlać moje "publiczne" albumy zdjęć. ] To uprawnienie określa, kto może wyświetlać Twoje albumy ze zdjęciami. Poszczególne zdjęcia mogą nadal być publikowane do bardziej prywatnej grupy osób.

  [*= Można wyświetlać moją "publiczną" książkę adresową. ] To uprawnienie określa, kto może wyświetlać Twoje kontakty. Są to połączenia wyświetlane w sekcji "Wyświetl połączenia".

  [*= Można wyświetlać mój "publiczny" magazyn plików. ] To uprawnienie określa, kto może wyświetlać Twoje publiczne pliki przechowywane w "chmurze" serwisu.

  [*= Można wyświetlać moje "publiczne" strony. ] To uprawnienie określa, kto może wyświetlać Twoje publiczne strony internetowe. 

  [*= Można przesyłać mi strumień ich kanału i wpisy. ] To uprawnienie określa, czyje wpisy będą wyświetlane na Twoim kanale. Jeśli Twój kanał jest kanałem osobistym (tj. Ty jako osoba), prawdopodobnie chciałbyś ustawić to przynajmniej tak, że "każdy z mojej książki adresowej". Osobisty kanał notatek prawdopodobnie chciałbyś ustawić na "nikt oprócz mnie". Ustawienie tego na "każdy w sieci” spowoduje wyświetlenie wpisów od zupełnie obcych osób, co jest dobrą formą rozeznania sieci.

  [*= Można publikować na stronie mojego kanału ("ścianie"). ] To uprawnienie określa, kto może umieszczać swoje wpisy na Twojej ścianie po przejściu do Twojego kanału.

  [*= Można komentować moje wpisy. ] To uprawnienie określa, kto może komentować wpisy, które tworzysz. Zwykle chce się, aby pasowało to do uprawnienia "można wyświetlać mój publiczny strumień i wpisy”.

  [*= Można wysyłać mi prywatne wiadomości pocztowe. ] Określa to, kto może wysyłać Ci prywatne wiadomości (zotmail).

  [*= Można publikować zdjęcia w moich albumach ze zdjęciami. ] To określa, kto może publikować zdjęcia w Twoich albumach. Jest to bardzo przydatne w przypadku kanałów przypominających forum, na których połączenia mogą nie być ze sobą połączone.

  [*= Można przekazywać dalej do wszystkich kontaktów z mojego kanału za pomocą tagów "post". ] Użycie wzmianek (@-) spowoduje odtworzenie kopii twojego wpisu na określonym profilu, tak jakbyś opublikował go na ścianie kanału. To ustawienie określa, czy jakieś osoby mogą w ten sposób publikować na Twoim kanale.

  [*= Można ze mną rozmawiać (jeśli jestem dostępny). ] Określa to, kto może dołączyć do publicznych czatów utworzonych na Twoim kanale.

  [*= Można zapisywać w moim "publicznym" magazynie plików. ] To określa, kto może przesyłać pliki do Twojego publicznego magazynu plików.

  [*= Można edytować moje "publiczne" strony. ] Określa to, kto może edytować Twoje strony internetowe. Jest to przydatne w przypadku witryn typu wiki lub witryn z wieloma redaktorami.

  [*= Można zarządzać zasobami mojego kanału. ] To określa, kto może mieć pełną kontrolę nad Twoim kanałem. Zwykle powinno być to ustawione na "nikt oprócz mnie".
[/dl][/dl]
[i]Uwaga:[/i]
Wtyczki (dodatki) mogą zapewniać specjalne ustawienia uprawnień, więc możesz otrzymać dodatkowe ustawienia uprawnień wykraczające poza to, co opisano tutaj.

Jeśli ustawisz którekolwiek z tych uprawnień na "tylko te, na które wyraźnie zezwalam", możesz określać indywidualne uprawnienia na ekranie edycji połączenia.

[h4][b]Zaprzyjaźnienie[/b][/h4]

Ekran edycji połączenia oferuje suwak do wyboru stopnia "zaprzyjaźnienia" z połączeniem (to narzędzie można włączyć na karcie "Dodatkowe funkcje" na stronie "Ustawienia"). Potraktuj to jako miarę tego, jak bardzo ich lubisz lub nie lubisz. Wartość 1 jest dla osób, które lubisz, których wpisy chcesz widzieć cały czas; 99 jest dla osób, na których Ci nie zależy i których wpisy możesz chcieć przeglądać tylko od czasu do czasu. Po przypisaniu tutaj wartości możesz użyć narzędzia zaprzyjażnienia na stronie matrycy do filtrowania treści na podstawie tej liczby.

Suwak na stronie matrycy ma zarówno wartość minimalną, jak i maksymalną. Wpisy będą wyświetlane tylko od osób mieszczących się w tym zakresie. Zaprzyjaźnienie nie ma związku z uprawnieniami i jest przydatna tylko w połączeniu z funkcją narzędzia zaprzyjaźnienia.

[h3]Tokeny dostępu gościa[/h3]
Tokeny dostępu gościa (czasami nazywane "tokenami dostępu Zot") umożliwiają udostępnianie pliku, folderu, zdjęcia, albumu lub kanału określonej osobie lub grupie osób, które nie są członkami portalu Hubzilli. Te tokeny umożliwiają udostępnianie poszczególnych elementów poprzez wysłanie linku zawierającego token w adresie URL; alternatywnie, osoby mogą faktycznie logować się przy użyciu poświadczeń tokena, po czym mogą bezproblemowo przeglądać zawartość udostępnioną temu tokenowi.

W celu utworzenia tokenów dostępu gościa i zarządzać nimi, otwórz stronę ustawień "Tokeny dostępu gościa". Przy każdym załadowaniu strony generowany jest losowy token, który umożliwia utworzenie specjalnego adresu URL zawierającego ten token i opcjonalnie określenie daty wygaśnięcia. Istniejące tokeny są wymienione poniżej okna dialogowego i można je edytować, wybierać lub usuwać.

Tokenowi gościa można przyznać dodatkowe uprawnienia, rozszerzając opcje "Indywidualnych uprawnień" i wybierając ustawienia prywatności, takie jak "Może wyświetlać strumień i wpisy mojego kanału" lub "Może rozmawiać ze mną".

[url=[baseurl]/help/feature/access_tokens]Więcej informacji...[/url]

[img][baseurl]/doc/member/assets/zat_dialog.png[/img]

[h3]Język znaczników[/h3]
$Projectname obsługuje kilka języków znaczników do zaawansowanego formatowania treści. Domyślnym językiem znaczników jest [url=[baseurl]/help/pl/member/bbcode]własny wariant BBcode[/url], dostosowany do użytku w Hubzilli. BBcode jest obsługiwany dla wpisów, stron wiki i elementów stron internetowych. Strony Wiki i elementy stron internetowych można również pisać przy użyciu standardowego języka Markdown.
[table border=0]
[tr][th]Typ treści[/th][th]Obsługiwany język[/th][/tr]
[tr][td]Wpis[/td][td][url=[baseurl]/help/pl/member/bbcode]BBcode[/url][/td][/tr]
[tr][td]Wiki[/td][td][url=[baseurl]/help/pl/member/bbcode]BBcode[/url], Markdown[/td][/tr]
[tr][td]Elementy stron WWW[/td][td][url=[baseurl]/help/pl/member/bbcode]BBcode[/url], Markdown, HTML[/td][/tr]
[/table]

[h3]Tagi i wzmianki[/h3]
Podobnie jak wiele innych platform, $Projectname używa specjalnej notacji wewnątrz wiadomości, aby wskazać "tagi" lub powiązania kontekstowe z innymi podmiotami.

[h4][b]Wzmianki[/b][/h4]
Kanały (profile) są oznaczane przez swoją nazwę poprzedzoną znakiem ed, np. [code]@Jacek[/code]. Jest to wykorzystywane w mechaniźmie wzmianek.

Kiedy zaczniesz zmiankować o kimś w swoim wpisie (wstawiając znak @), mechanizm ten utworzy pole z autouzupełnianiem, aby można było wybrać z Twoich bezpośrednich kontaktów określoną osobę (kanał). Możesz wybrać z listy kanał, który chcesz wzmiankować.

Jeśli wspomniana osoba znajduje się na liście odbiorców wpisu, otrzyma powiadomienie o tym znaczniku.   

[h4][b]Wzmianki dostarczania[/b][/h4]

Znak wykrzyknika ([b]![/b]) oznacza [i]wzmiankę dostarczania[/i] wstawioną na forum lub specjalnym kanale, która umożliwia rozesłanie wisu do wielu odbiorców.

[code]
@Gardening  - wzmiankowanie forum Gardening

!Gardening - wzmiankowanie forum Gardening i równoczesne opublikowanie wpisu w "sieci" Gardening " (np. rozesłanie wpisu do wszystkich członków tej sieci, jeśli ma się na to pozwolenie).
[/code]

Uwaga: w poprzednich wersjach, format wzmianki dostarczania miał wpisuć [code]@forum+[.code] (plus na końcu). Ten mechanizm nie jest już obsługiwany.

[h4][b]Wzmianki prywatności[/b][/h4]
Jeśli chcesz ograniczyć wpis do jednej osoby lub kilku osób, możesz to zrobić, wybierając kanały lub grupy prywatności w narzędziu do ochrony prywatności. Możesz także po prostu oznaczyć je tagiem prywatności. Znacznik prywatności to nazwa poprzedzona znakami [code]@![/code], co zmienia również uprawnienia prywatności wpisu, tak aby zawierały tylko te osoby, którym chcesz dostarczyć wpis. Można wstawić więcej niż jeden tag prywatności, na przykład tagi [code]@!Bob[/code] i [code]@!Linda[/code] sposowdują wysłanie wpisu tylko do Boba i Lindy. Ten mechanizm zastępuje selektor prywatności.

Fora mogą być wzmiankowane w ten sam sposób. Wzmianka [code]!!dogs[/code] będzie powodować publikowanie prywatnie na forum "dogs". Forum ponownie dostarczy wpis do wszystkich członków forum, ale Twoi obserwatorzy nie zobaczą go, chyba że są również członkami forum "dogs".

Można także oznaczyć grupy prywatności, które są "publiczne". Gdy tworzysz lub edytujesz grupę prywatności, jest dostępne pole wyboru, które umożliwia innym osobom zobaczenie członków grupy. Jeśli to pole jest zaznaczone dla grupy i oznaczysz wpis, na przykład tagiem [code]@!Friends[/code] - zostanie on ograniczony do grupy Friends. Zanim to zrobisz, sprawdź, czy grupa jest publiczna, ponieważ nie ma innego sposobu na wycofanie wpisu niz jego usunięcie. Nazwa grupy pojawi się w poście i powiadomi członków tej grupy, że są jej członkami.    

[h4][b]Wzmianki a komentarze[/b][/h4]
Powyższe mechanizmy mają zastosowanie tylko do wpisów "najwyższego poziomu". Wzmianka o kanale z którymkolwiek z powyższych mechanizmów nie ma wpływu na komentarze, poza tym, że wzmiankowany kanał może otrzymać powiadomienie, jeśli był już uwzględniony w rozmowie jako odbiorca. 

[h4][b]Tagi tematyczne (hasztagi)[/b][/h4]
[i]Tagi tematyczne[/i], zwane też [i]hasztagami[/i], mają format terminu poprzedzonego znakiem hash ([b]#[/b]). Powoduje to utworzenie w poście łącza do ogólnoserwisowego wyszukiwania podanego terminu. Na przykład, [code]#cars[/code] zapewni link do wyszukiwania dla wszystkich wpisów zawierających słowo kluczowe [code]cars[/code] w Twoim serwisie. W tagach tematycznych powinno się używać terminów nie krótszych niż trzy znaki. Krótsze terminy wyszukiwania prawdopodobnie nie przyniosą żadnych wyników wyszukiwania, chociaż zależy to od konfiguracji bazy danych. 

Tagi tematyczne zawierające same cyfry nie są zwykle dozwolone, np. [code]#1[/code]. Jeśli chcesz użyć hashtagu numerycznego, dodaj tekst opisowy, np. [code]#2012-wybory[/code] lub umieść cały termin w podwójnych cudzysłowach (na przykład [code]#"2012"[/code]). Podwójne cudzysłowy są również wymagane, jeśli termin zawiera spacje ([code]#"My tag[/code]`) i mogą być wymagane, jeśli tag zawiera znaki interpunkcyjne lub znaki diakrytyczne ([code]#"EndsWithPeriod."[/code], [code]#"Exciting!!!"[/code], [code]#"Ósmy pasażer"[/code] itp.). 

[h4][b]Zakładki[/b][/h4]
Zakładki wskazują link, który można zapisać w folderze zakładek. Używają sekwencji [code]#^[/code], po której następuje link. Często są one generowane automatycznie. Jeśli zainstalowany jest dodatek "bookmarker", sekwencja ta zostanie przekonwertowana na ikonę zakładki podczas przeglądania inline wpisu lub komentarza, a kliknięcie ikony spowoduje zapisanie zakładki. Jeśli dodatek bookmarker nie jest zainstalowany, można wykorzystać rozwijane menu wpisu, które zawiera łącze do zapisania zakładki lub zakładek. 

[h4][b]Ręczne wzmiankowanie[/b][/h4]
Na przykład, tag [code]@billy[/code] oznaczy połączenie, którego nazwa lub adres sieciowy to "billy" (dopasowanie dokładne). Jeśli masz dwa połączenia z nazwą lub adresem sieciowym billy, na przykład [code]billy@server1.hubzilla.org[/code] i [code]billy@server2.hubzilla2.org[/code], będziesz musiał podać pełny adres, inaczej wyniki będą niejednoznaczne i niewłaściwa osoba może zostać oznaczona. 

Tag [code]@"Robert Johnson"[/code] oznaczy Roberta Johnsona. Podwójne cudzysłowy są wymagane, jeśli oznaczona nazwa zawiera spacje.

[h3]Strony internetowe[/h3]

$Projectname umożliwia członkom i dozwolonym połączeniom tworzenie statycznych stron internetowych. Aby aktywować tę funkcję, włącz funkcję [b]Strony internetowe[/b] w sekcji [b][url=[baseurl]/settings/features/]Dodatkowe funkcjonalności[/url][/b].

Po włączeniu, na stronie kanału pojawi się nowa karta zatytułowana "Strony internetowe". Kliknięcie tego linku przeniesie Cię do edytora stron internetowych. Strony będą dostępne pod adresem [b][baseurl]/page/[observer=1][observer.webname][/observer][observer=0]channelname[/observer]/pagelinktitle[/b]

Pole "Tytuł linku do strony" umożliwia określenie tytułu linku do strony tego adresu URL. Jeśli tytuł linku do strony nie jest ustawiony, ustawimy go automatycznie, używając identyfikatora wiadomości elementu.

Pod polem tworzenia strony pojawi się lista istniejących stron z linkiem "Edytuj". Kliknięcie tego przeniesie Cię do edytora podobnego do edytora wpisów, w którym możesz wprowadzać zmiany na swoich stronach internetowych.
	
[h4][b]Używanie bloków[/b][/h4]

Bloki mogą być częściami stron internetowych. Podstawowy kod HTML bloku wygląda następująco:
[code]
	<div>
		Block Content
	</div>

[/code]

Jeśli blok ma zawartość tekstową (html), może również zawierać elementy menu. Na przykład, zawartość:
[code]
	<p>HTML block content</p> 
	[menu]menuname[/menu]

[/code]
wytworzy HTML taki jak ten:
[code]
	<div>
		<p>HTML block content</p>
		<div>
			<ul>
				<li><a href="#">Link 1</a></li>
				<li><a href="#">Link 2</a></li>
				<li><a href="#">Link 3</a></li>
			</ul>
		</div>
	</div>

[/code]

Makro [code]$content[/code] umożliwia osadzenie całej treści strony internetowej. W tym celu wystarczy utwórzyć taki blok:
[code]
	$content

[/code]
jako treść. Aby blok pojawił się na stronie internetowej, musi być zdefiniowany w układzie strony wewnątrz regionu.
[code]
	[region=aside]
		[block]blockname[/block]
	[/region]

[/code]

Wygląd bloku można zmieniać w układzie strony.

W regionie można przypisać własne klasy (css). Ten kod:
[code]
	[region=aside]
		[block=myclass]blockname[/block]
	[/region]

[/code]
wytworzy taki HTML:
[code]
	<div class="myclass">
		Block Content
	</div>

[/code]

Za pomocą zmiennej [code]wrap[/code] z bloku można usunąć otaczające go znaczniki [code]<div> </div>[/code]. Ten kod:
[code]
	[region=aside]
		[block][var=wrap]none[/var]blockname[/block]
	[/region]

[/code]
wytworzy taki HTML:
[code]
	Treść bloku
[/code]

[h4][b]Narzędzie importy elementów strony internetowej[/b][/h4]

Istnieją dwie metody importowania elementów strony internetowej: przesyłanie pliku ZIP lub odwoływanie się do plików we własnym magazynu plików w serwisie. Obie metody wymagają określenia elementów strony sieci internetowej przy użyciu określonej struktury folderów. Narzędzie importu umożliwia zaimportowanie wszystkich elementów niezbędnych do zbudowania całej witryny lub zestawu witryn. Celem jest uwzględnienie zewnętrznego tworzenia stron internetowych, a także narzędzi upraszczających i automatyzujących wdrażanie na portalu.

[h5][b] Struktura folderu [/b][/h5]
Definicje elementów muszą być przechowywane w katalogu głównym repozytorium w folderach o nazwie odpowiadającej typowi elementu: 
[code]
	/pages/
	/blocks/
	/layouts/
[/code]

Każdy element tych typów musi być zdefiniowany w osobnym podfolderze przy użyciu dwóch plików: jednego w formacie JSON dla metadanych i drugiego w zwykłym formacie testowym dla zawartości elementu.

[h5][b] Elementy strony [/b][/h5]
Metadane elementu strony są zdefiniowane w pliku w formacie JSON o nazwie [code]strona.json[/code] z następującymi właściwościami:
[list]
[*] title
[*] pagelink
[*] mimetype
[*] layout
[*] contentfile
[/list]
[b]Przykład[/b] 

Pliki: 
[code]	
	/pages/my-page/page.json
	/pages/my-page/my-page.bbcode
[/code]	
Treść [code]page.json[/code]:
[code]	
	{
		"title": "My Page",
		"pagelink": "mypage",
		"mimetype": "text/bbcode",
		"layout": "my-layout",
		"contentfile": "my-page.bbcode"
	}
[/code]	
[h5][b] Elementy układu [/b][/h5]

Metadane elementu układu są zdefiniowane w pliku w formacie JSON o nazwie [code]layout.json[/code] z następującymi właściwościami:
[list]
[*] name
[*] description
[*] contentfile
[/list]
[b]Przykład[/b] 

Pliki:
[code]
	/layouts/my-layout/layout.json
	/layouts/my-layout/my-layout.bbcode
[/code]	
Treść [code]layout.json[/code]:
[code]
	{
		"name": "my-layout",
		"description": "Layout for my project page",
		"contentfile": "my-layout.bbcode"
	}
[/code]

[h5][b] Elementy bloku [/b][/h5]

Metadane elementu bloku są określone w pliku w formacie JSON o nazwie [code]block.json[/code] z następującymi właściwościami:
[list]
[*] name
[*] title
[*] mimetype
[*] contentfile
[/list]
[b]Przykład[/b] 

Pliki:
[code]	
	/blocks/my-block/block.json
	/blocks/my-block/my-block.html
[/code]
Treść [code]block.json[/code]:	

[code]
	{
		"name": "my-block",
		"title": "",
		"mimetype": "text/html",
		"contentfile": "my-block.html"
	}
[/code]

[h3]Język opisu stron Comanche[/h3]

Comanche to język znaczników podobny do [url=[baseurl]/help/member/bbcode]BBcode[/url], za pomocą którego można tworzyć rozbudowane i złożone strony internetowe, łącząc je z szeregu komponentów - z których niektóre są już wstępnie zbudowane i inne, które można skonstruować w locie. Comanche używa własnego języka opisu strony do tworzenia tych stron.

Comanche przede wszystkim wybiera, jakie treści pojawią się w różnych [b]regionach[/b] strony. Regiony mają swoje nazwy, które mogą się zmieniać w zależności od wybranego szablonu układu.

[h4][b]Szablony strony[/b][/h4]
Obecnie dostępnych jest pięć szablonów układów, ale w serwisie można udostępniać dodatkowe, własne układy.

[dl terms="b"]
[*= default]
Domyślny szablon zawiera definicję regionu "nav" znajdującego się u góry, "aside" jako pasek boczny o stałej szerokości,
"content" dla głównego regionu treści i "footer" dla stopki strony.

[*= full]
Pełny szablon definiuje to samo, co szablon "default", z tą różnicą, że nie ma regionu "aside".

[*= choklet]
Szablon "choklet" zapewnia kilka płynnych układów, które można wybierać według odmiany:
[list]
[*]	(domyślna odmiana) - układ dwukolumnowy, podobny do szaablonu "default", ale jest bardziej płynny
[*]	bannertwo - układ dwukolumnowy z regionem "banner", zgodny z szablonem "default" na małych wyświetlaczach
[*]	three - układ trzykolumnowy (dodany region "right_aside" do szablonu domyślnego)
[*]	edgestwo - układ dwukolumnowy ze stałymi marginesami bocznymi
[*]	edgesthree - układ trzykolumnowy ze stałymi marginesami bocznymi
[*]	full - układ trzykolumnowy ze stałymi marginesami bocznymi i dodanym obszarem "header" poniżej paska nawigacji
[/list]

[*= redable]
Szablon do czytania dłuższych tekstów na pełnym ekranie (czyli bez paska nawigacyjnego). Trzy kolumny: "aside", "content" i "right_aside".
Aby zapewnić maksymalną czytelność, zaleca się używanie tylko środkowej kolumny treści.

[*= zen]
Daje swobodę robienia wszystkiego samemu. Tylko pusta strona z obszarem zawartości.
[/dl]

Aby wybrać szablon układu, trzeba użyć tagu "template".

[code]
	[template]full[/template]

[/code]

Wybranie szablonu "choklet" z odmianą "three":

[code]
	[template=three]choklet[/template]

[/code]

Jeśli nie określono innego szablonu, zostanie użyty szablon domyślny. W szablonie można używać dowolnych nazw dla regionów zawartości. Używa sie też tagów "region", aby zdecydować, jakie treści umieścić w odpowiednich regionach.

Zadefiniowane są też trzy "makra", które można użyć na stronie.
[code]
	$htmlhead - wstawia zawartość nagłówka strony.
	$nav - wstawia zawartość paska nawigacji.
	$content - wstawia główną treść strony.

[/code]

Domyślnie, makro $nav jest umieszczane w regionie "nav" strony a $content w regionie "content". Tych makr potrzebujesz tylko wtedy, gdy chcesz zmienić rozmieszczenie tych elementów, aby zmienić kolejność lub przenieść je do innych regionów.

Aby wybrać motyw dla swojej strony, użyj tagu "theme".
[code]
	[theme]suckerberg[/theme]

[/code]
Spowoduje to wybranie motywu o nazwie "suckerberg". Domyślnie używany jest preferowany motyw Twojego kanału.

[code]
	[theme=passion]suckerberg[/theme]

[/code]
Spowoduje to wybranie motywu o nazwie "suckerberg" oraz wybór schematu "passion" (wariant motywu). Alternatywnie można użyć do tego zwięzłej notacji motywu.

[code]
	[theme]suckerberg:passion[/theme]

[/code]

Notacja zwięzła nie jest częścią samego Comanche, ale jest rozpoznawana przez platformę $Projectname jako specyfikator motywu.

[h4][b]Pasek nawigacji[/b][/h4]

[code]
	[navbar]tucson[/navbar]
[/code]

Kod ten powoduje użycie szablonu paska nawigacyjnego "tucson" i reguł CSS. Domyślnie stosowany jest szablon domyślny szablon paska nawigacyjnego.

[h4][b]Regiony[/b][/h4]
Tak jak wspomniano wyżej, każdy region swoją nazwę. Wybrany eegion określa używając tagu "region", który zawiera nazwę. Wszelkie treści, które chcesz umieścić w tym regionie, powinny być umieszczone między tagiem otwierającego a zamykającym.

[code]
	[region=htmlhead]....tutaj jest treść....[/region]
	[region=aside]....tutaj jest treść....[/region]
	[region=nav]....tutaj jest treść....[/region]
	[region=content]....tutaj jest treść....[/region]

[/code]

[h4][b]CSS i Javascript[/b][/h4]
Jest możliwość włączenia bibliotek JavaScript i CSS w regionie "htmlhead". Obecnie korzystamy z bibliotek jQuery (JS), Bootstrap (CSS i JS) oraz Foundation (CSS i JS).
Ten kod spowoduje nadpisanie regionu htmlhead wybranego motywu.

[code]
	[region=htmlhead]
		[css]bootstrap[/css]
		[js]jquery[/js]
		[js]bootstrap[/js]
	[/region]

[/code]

[h4][b]Elementy menu i bloki[/b][/h4]
Narzędzia do tworzenia stron internetowych umożliwiają również tworzenie eleentów menu i bloków. Dostarczają one fragment kodu, który można umieścić w dowolnych regionach i w dowolnej kolejności. Każdy z takich fragmentów ma nazwę, którą definiuje się podczas tworzenia elementów menu lub bloku.

Ten kod:
[code]
	[menu]mymenu[/menu]

[/code]
spowoduje umieszczenie w tym miejscu menu o nazwie "mymenu”, ale miejsce to musi się ono znajdować wewnątrz regionu. 

Kod:
[code]
	[menu=horizontal]mymenu[/menu]

[/code]
spowoduje umieszczenie w tym miejscu menu o nazwie "mymenu", ale musi się ono znajdować które musi znajdować wewnątrz regionu. Dodatkowo zastosowano tu do menu klasę "horizontal". Klasa "horizontal" jest zdefiniowana w motwie "redbasic". Może być dostępna lub nie w innych motywach. 

W tym bloku:
[code]
	[menu][var=wrap]none[/var]mymenu[/menu]

[/code]
zmienna [code][var=wrap]none[/var][/code] usuwa z menu element [code]div[/code].

Ten kod:
[code]
	[block]contributors[/block]
[/code]
umieszcza blok o nazwie &quot;contributors&quot; w regionie, w którym został wstawiony.

Kod:
[code]
	[block=someclass]contributors[/block]

[/code]
też umieszcza blok o nazwie &quot;contributors&quot; w tym regionie, ale dodatkowo stosuje dla tego bloku klasę &quot;someclass&quot;. Zamienia to domyślną klasę bloku &quot;bblock widget&quot;.

W bloku:
[code]
	[block][var=wrap]none[/var]contributors[/block]

[/code]
zmienna [code][var=wrap]none[/var][/code] usuwa z bloku opakowujący go element [code]div[/code].

[h4][b]Widżety[/b][/h4]
Widżety to wykonywalne aplikacje dostarczane przez system, które można umieścić na swojej stronie. Niektóre widżety przyjmują argumenty, które pozwalają dostosować widżet do własnych potrzeb. Widżety systemowe są wymienione [url=help/Widgets]tutaj[/url]. Widżety mogą być również tworzone w ramach wtyczek, motywów lub przez administratora witryny, aby zapewnić dodatkowe funkcje.

Widżety i ich argumenty są określane za pomocą tagów "widget" i "var".
[code]
	[widget=recent_visitors][var=count]24[/var][/widget]

[/code]

Spowoduje to załadowanie widżetu &bdquo;latest_visitors&rdquo; i dostarcza mu argument "count" ustawiony na „24”.
 
[h4][b]Komentarze[/b][/h4]
Tag "comment" jest używany do wydzielenia komentarzy. Komentarze te nie pojawią się na renderowanej stronie.

[code]
	[comment]This is a comment[/comment]

[/code]

[h4][b]Wykonanie warunkowe[/b][/h4]
Można użyć konstrukcji [code]if[/code] warunkowego wykonania kodu. Jest to obecnie oparte na zmiennej konfiguracji systemu [code]$config.system[/code] lub zmiennej [code]$observer[/code].

[code]
	[if $config.system.foo]
		... zmienna konfiguracyjna system.foo przyjmuje wartość 'true'.
	[else]
		... zmienna konfiguracyjna system.foo przyjmuje wartość 'false'.
 	[/if]

	[if $observer]
		... ta treść będzie pokazywana tylko uwierzytelnionym użytownikom
	[/if]

[/code]

	Klauzula 'else' jest opcjonalna. 

	Oprócz oceny logicznej obsługiwanych jest też kilka testów.

[code]
	[if $config.system.foo == bar]
		... zmienna konfiguracyjne system.foo jest równa łańcuchowi 'bar'
	[/if]
	[if $config.system.foo != bar]
		... zmienna konfiguracyjne system.foo nie jest równa łańcuchowi 'bar'
	[/if]
	[if $config.system.foo {} bar ]
		... zmienna konfiguracyjna system.foo jest prostą tablicą zawierającą zmienną 'bar'
	[/if]
	[if $config.system.foo {*} bar]
		... zmienna konfiguracyjna system.foo jest prostą tablicą zawierającą klucz o nazwie 'bar'
	[/if]
[/code]

[h4][b]Złożony przykład[/b][/h4]
[code]
	[comment]użyj istniejący szablon strony, który zawiera obszar banera oraz 3 kolumny poniżej[/comment]

	[template]3-column-with-header[/template]

	[comment]Użyj motyw &quot;darknight&quot;[/comment]

	[theme]darkknight[/theme]

	[comment]Użyj istniejące menu nawigacyjne strony[/comment]

	[region=nav]$nav[/region]

	[region=side]

		[comment]Użyj wybranego przeze mnie menu i kilku widżetów[/comment]

		[menu]myfavouritemenu[/menu]

		[widget=recent_visitors]
			[var=count]24[/var]
			[var=names_only]1[/var]
		[/widget]

		[widget=tagcloud][/widget]
		[block]donate[/block]

	[/region]



	[region=middle]

		[comment]Pokaż normalną zawartość strony[/comment]

		$content

	[/region]



	[region=right]

		[comment]Pokaż mój skondensowany kanał RSS "wal" i zezwól na interakcję, jeśli obserwator ma możliwość interakcji[/comment]

		[widget]channel[/widget]

	[/region]

[/code]


[h3]Osobisty magazyn plików[/h3]

$Projectname umożliwia prywatne przechowywanie i udostępnianie znajomym dowolnych plików. Możesz przesłać pliki ze swojego komputera do obszaru przechowywania lub skopiować je bezpośrednio z systemu operacyjnego przy użyciu protokołu WebDAV.

Funkcjonuje to podobnie do usług "chmurowych", takich jak [i]Dopbox[/i], [i]Dysk[/i] Google czy [i]One Drive[/i] Microsoftu.

Na wielu serwerach publicznych mogą obowiązywać ograniczenia dotyczące przydzielonej powierzchni dyskowej.

[h4][b]Załączniki plikowe[/b][/h4]

Najszybszym i najłatwiejszym sposobem udostępniania plików są załączniki. W rzędzie ikon poniżej edytora statusu znajduje się narzędzie do przesyłania załączników. Kliknij narzędzie, wybierz plik i prześlij. Po załadowaniu pliku zobaczysz kod załącznika umieszczony w obszarze tekstowym. Nie edytuj tego kodu, ponieważ może to uniemożliwić Ci udostępnienie tego pliku znajomym. Możesz użyć okna dialogowego uprawnień do publikowania lub hasztagów prywatności, aby ograniczyć widoczność pliku - który zostanie ustawiony zgodnie z uprawnieniami wysyłanego wpisu.

Aby usunąć załączniki lub zmienić uprawnienia do przechowywanych plików, odwiedź [observer=1][baseurl]/cloud/[observer.webname][/observer][observer=0][baseurl]/cloud/username,  zastępując [code]username[/code] pseudonimem, jaki podałeś podczas tworzenia kanału[/observer].

[h4][b]Dostęp internetowy[/b][/h4]

Twoje pliki są widoczne w sieci pod adresem [observer=1][baseurl]/cloud/[observer.webname][/observer][observer=0][baseurl]/cloud/username[/observer] dla każdego, kto ma uprawnienia do ich przeglądania. Jeśli przeglądający ma wystarczające uprawnienia, może mieć również możliwość tworzenia nowych plików i folderów (katalogów) w interfejsie przeglądarki. Dostęp internetowy powinnien być używane tylko w przypadku mniejszych plików i zdjęć (do kilku megabajtów), ponieważ wykorzystuje pamięć wewnętrzną. W przypadku większych plików (filmy, muzyka itp.) przesyłaj je za pomocą protokołu WebDAV, cojest omówione w następnym rozdziale. Takie pliki będzie można nadal pobierać za pośrednictwem dostępu internetowego.

[h4][b]Dostęp WebDAV[/b][/h4]

WebDAV umożliwia kopiowanie plików bezpośrednio do lub z systemu operacyjnego komputera, gdzie Twój "magazyn plików" pojawia się jako wirtualny dysk. Dostęp ten powinien być używany do przesyłania dużych plików, takich jak wideo i audio, ponieważ nie jest ograniczony dostępną pamięcią wewnętrzna. Zobacz [zrl=help/member/member_guide#Cloud_Desktop_Clients]Cloud Desktop Clients[/zrl] poniżej.

[h4][b]Dostęp CalDAV i CardDAV na Androidzie[/b][/h4]

Możesz zsynchronizować swój kalendarz i kontakty w systemie Android ze swoim portalem.

Poniższe kroki zostały przetestowane pod kątem zasosowania [url=https://f-droid.org/en/packages/at.bitfire.davdroid/] DAVdroid [/url]:

[list]
[*] zainstaluj DAVdroid
[*] dodaj konto
[*] użyj "URL" i "user name" do zalogowania się
[list]
[*] podstawowy URL to [baseurl]/cdav
[*] Twoja nazwa użytkowka to [observer=1][observer.webname][/observer][observer=0]username[/observer]
[/list]
[/list]

Aby udostępnić kalendarz odwiedź [observer.baseurl]/cdav/calendar

[h4][b]Uprawnienia[/b][/h4]

W przypadku korzystania z protokołu WebDAV plik jest tworzony z domyślnymi uprawnieniami do plików kanału, których nie można zmienić z poziomu systemu operacyjnego. Może też nie być to tak restrykcyjne, jak byś chciał. Najlepiej, utwórz foldery (katalogi), następnie odwiedź swój magazyn plików pod adresem [observer=1][baseurl]/cloud/[observer.webname][/observer][observer=0][baseurl]/cloud/username[/observer], wybierz katalog i zmień uprawnienia. Zrób to zanim umieścisz cokolwiek w katalogu. Uprawnienia do katalogu mają pierwszeństwo, więc możesz następnie umieścić pliki lub inne foldery w tym kontenerze i będą one chronione przed niechcianymi widzami przez ustawienie uprawnienia do katalogu. Często zdarza się, że użytkownicy tworzą folder "osobisty" lub "prywatny", który jest ograniczony do nich samych. Możesz używać tego jako osobistej chmury do przechowywania wszystkiego z dowolnego miejsca w Internecie lub dowolnego komputera i jest to chroniony przed innymi. Możesz także utworzyć foldery dla "rodziny" lub "przyjaciele" za zgodą udzieloną odpowiednim grupom prywatności.

[h3]Klienty desktopowe dla magazynu plikowego[/h3]

[h4][b]Klienty dla Windows[/b][/h4]

W Windows 7 połaczenie WebDAV można nawiązać przy użyciu kreatora z graficznym interfejsem:
1. Kliknij lewym przyciskiem myszy na przycisk "Start", aby otworzyc menu "Start".
2. Kliknij prawym przyciskiem myszy na ikone "Mój komputer", aby uzyskac dostęp do tego menu.
3. Kliknij lewym przysiskiem myszy na link "Mapuj dysk sieciowy...", aby otworzyć okno dialogowe kreatora połączeń.
4. Wpisz '[baseurl]/dav/nickname' w polu tekstowym (zamieniając 'nickname' na pseudonim swojego kanału) i kliknij przycisk "Gotowe".
5. Wpisz pseudonim kanału $Projectname. WAŻNE - bez znaku @ lub nazwy domeny
6. Wpisz swoje hasło $Projectname

[h4][b]Klienty dla Linux[/b][/h4]

[h5][b]Montowanie katalogu w systemie plików[/b][/h5]

Aby zainstalować katalog zdalny jako system plików, musisz najpierw zainstalować davfs2. Dla większości dystrybucji program ten jest dostępny w repozytoriach. Instalacja w Debianie:

[code]sudo apt-get install davfs2[/code]

Następnie skonfiguruj davfs2:

[code]sudo dpkg-reconfigure davfs2[/code]

i wybierz &quot;yes&quot; przy zapytaniu.

Teraz musisz dodać użytkownika, który ma mieć możliwość montowania dav, do grupy davfs2:

[code]sudo usermod -aG davfs2 &lt;DesktopUser&gt;[/code]

[b]Note:[/b] w niektórych systemach grupa użytkowników może być inna,
np. "network" w Arch Linux. W razie wątpliwości sprawdź dokumentację
davfs dla swojego konkretnego systemu operacyjnego.

Edytuj /etc/fstab:

[code]nano /etc/fstab[/code]

aby uwzględnić katalog zdalny, dodając:

[code]
[baseurl]/dav/ /mount/point davfs user,noauto,uid=&lt;DesktopUser&gt;,file_mode=600,dir_mode=700 0 1
[/code]

gdzie [baseurl] jest adresem URL portalu, /mount/point to lokalizacja, w której chcesz zamontować katalog zdalny, a &lt;DesktopUser&gt; to użytkownik, którego logujesz się na swoim komputerze. Miej na uwadze, że jeśli montujesz jako zwykły użytkownik (nie root), punkt montowania musi znajdować się w twoim katalogu domowym.

Przyjmijmy, że chcesz zamontować swój magazyn plików w katalogu o nazwie 'cloud' w swoim katalogu domowym, a Twoja nazwa użytkownika to 'bob'. Zapis w fstab będzie następujący: 

[code][baseurl]/dav/ /home/bob/cloud davfs user,noauto,uid=bob,file_mode=600,dir_mode=700 0 1[/code]

Teraz utówrz punkt montowania:

[code]mkdir /home/bob/cloud[/code]

oraz utwórz plik katalogu do przechowywania danych uwierzytelniania:

[code]mkdir /home/bob/.davfs2[/code]

Utwórz plik o nazwie 'secrets'

[code]nano /home/bob/.davfs2/secrets[/code]

i dodaj tam swoje dane uwierzytelniania w katalogu zdalnym:

[code]
[baseurl]/dav &lt;username&gt; &lt;password&gt;
[/code]

gdzie &lt;username&gt; i &lt;password&gt; to nazwa użytkownika i hasło [i]na Twoim kanale w portalu[/i].

Nie pozwól, aby ten plik mógł być zapisywany przez kogoś nieupoważnionego:

[code]chmod 600 /home/bob/.davfs2/secrets[/code]

Na koniec, zamontuj dysk:

[code]mount [baseurl]/dav[/code]

Możesz teraz znaleźć swój katalog zdalny w /home/bob/cloud i używać go tak, jakby była częścią lokalnego systemu plików - nawet jeśli aplikacje, których używasz, same nie obsługują dav.

[b]Rozwiązywanie problemów[/b]

W przypadku niektórych serwerów WWW i pewnych konfiguracji może się okazać, że davfs2 tworzy pliki o rozmiarze pliku 0 bajtów, podczas gdy inni klienty działają dobrze. Zwykle jest to spowodowane pamięcią podręczną i blokadami. Jeśli występuje ten problem, musisz edytować konfigurację davfs2.

[code]sudo nano /etc/davfs2/davfs2.conf[/code]

Twoja dystrybucja dostarczy przykładową konfigurację i ten plik powinien już istnieć, jednak większość jego treści jest zakomentowana znakiem # na początku wiersza.    

Pierwszym krokiem jest usunięcie blokad.

Edytuj wiersz use_locks, tak aby odczytywał [code]use_locks 0[/code].

Odłącz system plików, podłącz go ponownie i spróbuj skopiować plik z wiersza poleceń. Zauważ, że powinieneś skopiować nowy plik a nie nadpisywać starego. który został utwozony na potrzeby tego testu. Poczekaj minutę lub dwie, a następnie wykonaj polecenie [code]ls -l -h[/code] i sprawdź, czy rozmiar nowego pliku jest nadal większy niż 0 bajtów. Jeśli tak, zatrzymaj się na tym i nie rób nic więcej.

Jeśli to nadal nie zadziała, wyłącz pamięć podręczną. Pamiętaj, że ma to wpływ na wydajność, więc należy to robić tylko wtedy, gdy wyłączenie blokad nie rozwiązało problemu. Edytuj cache_size i ustaw ją na [code]cache_size 0[/code], a także ustaw file_refresh na [code]file_refresh 0[/code]. Odmontuj system plików, ponownie go podłącz i przetestuj ponownie.

Jeśli [i]nadal[/i] to nie działa, jest jeszcze jedna rzecz, której możesz spróbować. (Ten jest spowodowany błędem w starszych wersjach samego dav2fs, więc aktualizacja do nowej wersji może również pomóc). Włącz słabe usuwanie etagów, ustawiając [code]drop_weak_etags 1[]/code. Odmontuj i ponownie podłącz swój system plików, aby zastosować zmiany.

[h5][b]Dolphin[/b][/h5]
Dolphin Browser to przeglądarka internetowa dla Android i iOS. Odwiedź w niej [code]webdavs://example.com/dav[/code], gdzie [code]example.com[/code] to URL do Twojego portalu.

Gdy zostaniesz poproszony o podanie nazwy użytkownika i hasła, wprowadź nazwę swojego kanału (pierwszą część swojej strony internetowej - bez znaku @ i nazwy domeny) i hasło do swojego normalnego konta.

Pamiętaj, że jeśli jesteś już zalogowany do interfejsu WWW przez Konqueror, nie zostaniesz poproszony o dalsze uwierzytelnianie.

[h5][b]Konqueror[/b][/h5]
Konqueror to przeglądarka internetowa, meadżer plików i przeglądarka dokumentów dla środowiska KDE. Wystarczy odwiedzić w niej serwis [code]webdavs://example.com/dav[/code] po zalogowaniu się do swojego portalu, gdzie [code]example.com[/code] to adres URL portalu.

Jeśli jesteś zalogowany do swojego portalu w normalny sposób, nie jest wymagane dalsze uwierzytelnianie.

Ponadto, jeśli ktoś uwierzytelnił się w innym portalu podczas normalnej sesji przeglądarki, Twoja tożsamość zostanie również przekazana do magazynu plików dla tych portali - co oznacza, że możesz uzyskać dostęp do wszelkich prywatnych plików na dowolnym serwerze, o ile masz uprawnienia do ich przeglądania i pod warunkiem, że odwiedziłeś tę witrynę wcześniej podczas sesji.

Ta funkcja jest zwykle ograniczona do interfejsu sieciowego i nie jest dostępna dla żadnego innego środowiska graficznego niż KDE.

[h5][b]Nautilus[/b][/h5]

Nautilus to popularny menadżer plików dla środowiska GNOME. Jeśli sie nią posługujesz:

1. Otwórz okno przeglądarki plików;
2. Wybierz z menu opcję Plik &gt; Połącz z serwerem...;
3. Wpisz davs://&lt;domain_name&gt;/dav/&lt;your_channelname&gt; i kliknij Połącz;
4. Zostaniesz poproszony o podanie nazwy kanału (tak samo jak poprzednio) i hasło;
5. Twój osobisty katalog DAV zostanie udostęþniony w oknie przeglądarki.

[h5][b]Nemo[/b][/h5]

Pierwszy sposób:

wpisz w pasku adresowym &quot;davs://&lt;domain_name&gt;/dav/&lt;your_channelname&gt;&quot;.

Drugi sposób:

1) Menu &gt; Plik &gt; Połącz z serwerem...
2) Wypełnij okna w formatce dialogowej:
- Sewer: hubzilla_domain_name
- Typ: Secure WebDAV (https)
- Folder: /dav
- Nazwa użytkownika: twoja_nazwa_kanału
- Hasło: twoje_hasło

Po otwarciu możesz ustawić zakładkę.

[h5][b]Uwagi dotyczące serwera[/b][/h5]

Zgłoszono problemy z klientami używającymi "chunked transfer encoding", które obejmuje usługi Apple iOS, a także narzędzia "AnyClient" i "CyberDuck". Działają one dobrze w przypadku pobierania, ale przesyłanie często kończy się plikami o zerowym rozmiarze. Jest to spowodowane nieprawidłową implementacją kodowania fragmentarycznego w niektórych obecnych implementacjach FCGI (fast-cgi). Apache działający z PHP jako modułem nie ma tych problemów, ale podczas pracy pod FCGI może być konieczne użycie alternatywnych klientów lub użycie programu do przesyłania internetowego. W chwili pisania tego artykułu problem był otwarty i nie udostępniono żadnych aktualizacji przez co najmniej rok. Jeśli napotkasz pliki o rozmiarze zerowym z innymi klientami, zapoznaj się z uwagami klienta; ponieważ czasami występują problemy z konfiguracją, które również mogą powodować te objawy.    

[h3]Zapisane wyszukiwania[/h3]

W celu szybkiego wyszukania informacji można skorzystać z widżetu "saved search". Ten widżet może być prezentowany jako narzędzie paska bocznego na Twojej stronie internetowej i prawdopodobnie na stronie Twojego kanału. Różni się od narzędzia wyszukiwania "paska nawigacji" tym, że nie przeszukuje całej witryny, a jedynie podzbiór informacji dostępnych na Twoim kanale. 

Ponadto podane przez Ciebie frazy wyszukiwania mogą aktywować jednorazowe wyszukiwanie lub zostać zapisane na liście do ponownego wykorzystania. Zapisanie elementu wyszukiwania wywołuje również przeszukiwanie, oprócz dodania go do zapisanej listy (która jest wyświetlana poniżej pola wprowadzania tekstu wyszukiwania). Każdy element na liście może zostać odrzucony, jeśli nie jest już potrzebny. 

Zapisany widżet wyszukiwania zapewni automatyczne uzupełnianie kanałów (wyniki są poprzedzone znakiem @) i hashtagami (poprzedzonymi znakiem #). Nie trzeba wprowadzać tych tagów; chociaż wprowadzenie żądanego tagu zmniejszy wyniki autouzupełniania, aby zawierały tylko istotne informacje. Zachowanie odwzorowuje się następująco:

[list]
[*]@name - przeszukuje strumienia sieci w poszukiwaniu wpisów lub komentarzy napisanych przez 'name'. Spowoduje to również zmianę uprawnień edytora wpisów, aby zawierały tylko 'name'; jakby to była grupa prywatności.
[*]#hashtag - przeszukauje strumień sieci w poszukiwaniu wpisów zawierających #hashtag.
[*]text - przeszukaj strumień sieci w poszukiwaniu wpisów zawierających 'text'.
[/list]


[h3]Usunięcie kanału lub konta[/h3]

[h4][b]Usuniecie kanału[/b][/h4]

Wybierz link 'Usuń kanał' na stronie ustawień kanału lub odwiedź URL [baseurl]/removeme. 

Będziesz musiał potwierdzić swoje hasło i kanał, na którym jesteś obecnie zalogowany, zostanie usunięty. 

[hl][i][b]To jest nieodwracalne.[/b][/i][/hl]

Jeśli masz klony tożsamości na innych portalach, nie zostaną one usuniete. Operacja ta spowoduje tylko usunięcie tej instancji kanału, która istnieje w portalu, na którym dokonujesz usunięcia kanału.

[h4][b]Usuniecie konta[/b][/h4]

Wybierz link 'Usuń konto' widoczny na stronie ustawień konta lub odwiedź URL: [baseurl]/removeaccount
	
Będziesz musiał potwierdzić swoje hasło i konto, na którym jesteś obecnie zalogowany, zostanie usunięte. 

[hl][i][b]To jest nieodwracalne.[/b][/i][/hl]

Wszystkie Twoje kanały zostaną usunięte. Jeśli masz klony tożsamości na innych portalach - nie zostaną one usuniete. Operacja ta powoduje tylko usunięcie instancji kanałów, które istnieją w portalu, na którym dokonujesz tą operację.

