<?php $confirm_delete = __('Supprimer les fichiers sélectionnés ?'); ?>
<?php if (isset($_POST['action']) && in_array($_POST['action'], ['move_confirm', 'owner_confirm', 'hits_confirm'])) : ?>
<form id="action_selection" action="<?php echo $tpl['current_url']; ?>" method="post">
	<div>
		<p class="field"><?php printf(__('Sélection : %s'), count($_POST['selected'] ?? [])); ?></p>
		<p class="field">
<?php if ($_POST['action'] == 'move_confirm') : ?>
			<label for="list_categories"><?php echo __('Catégorie parente :'); ?></label>
			<select autofocus id="list_categories" name="cat_id">
				<?php foreach ($tpl['categories_move'] as &$i) : ?><?php if ($i['node'] == 'content' && (($i['type'] == 'album' && !$i['current']) || $i['type'] != 'album')) : ?><option value="<?php echo $i['id']; ?>"<?php if ($i['type'] == 'category') : ?> disabled<?php endif; ?>><?php echo str_repeat(' ', $i['level'] * 4); ?><?php echo $i['title']; ?></option><?php endif; ?><?php endforeach; ?>

			</select>
<?php elseif ($_POST['action'] == 'owner_confirm') : ?>
			<label for="list_users"><?php echo __('Nouveau propriétaire :'); ?></label>
			<select autofocus id="list_users" name="user_id">
<?php foreach ($tpl['users'] as &$i) : ?>
				<option value="<?php echo $i['id']; ?>"><?php echo $i['nickname']; ?></option>
<?php endforeach; ?>
			</select>
<?php else : ?>
			<label for="hits"><?php echo __('Nombre de vues :'); ?></label>
			<input autofocus id="hits" type="text" size="12" maxlength="12" name="hits">
<?php endif; ?>
		</p>
<?php if (!empty($_POST['selected'])) : ?>
<?php foreach ($_POST['selected'] as $id => &$value) : ?>
		<input name="selected[<?php echo $id; ?>]" type="hidden" value="<?php echo $value; ?>">
<?php endforeach; ?>
<?php endif; ?>
		<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
		<input name="action" type="hidden" value="<?php echo str_replace('_confirm', '', $_POST['action']); ?>">
		<input name="selection" type="submit" value="<?php echo __('Valider'); ?>">
		<input name="cancel" type="submit" value="<?php echo __('Annuler'); ?>">
	</div>
</form>
<?php elseif (isset($_POST['action']) && $_POST['action'] == 'delete_confirm') : ?>
<?php include('delete_selection.tpl.php'); ?>
<?php else : ?>

<div id="tools_display">
	<div class="tools">
<?php if ($_GET['section'] == 'album' && !isset($_GET['filter'])) : ?>
		<div><span class="icon icon_files_add show_tool<?php if (isset($tpl['files_upload']['fail'])) : ?> autoclick<?php endif; ?>"><a data-id="upload_form" class="js<?php if ($_GET['section_1'] == 'album-upload') : ?> show<?php endif; ?>" href="<?php echo $_GET['section'] == 'album' ? $tpl['link']('album' . (strstr($_GET['section_1'], 'upload') ? '' : '-upload') . '/' . $tpl['category']['id'] . '/page/' . $_GET['page']) : 'javascript:;'; ?>"><?php echo __('Ajouter des fichiers'); ?></a></span></div>
		<span class="sep">-</span>
<?php endif; ?>
		<div><span class="icon icon_search show_tool"><a data-id="search" class="js<?php if (strstr($_GET['section_1'], 'search')) : ?> show<?php endif; ?>" href="<?php echo in_array($_GET['section'], ['album', 'category-items']) ? $tpl['link']($_GET['section'] . (strstr($_GET['section_1'], 'search') ? '' : '-search') . '/' . $tpl['category']['id'] . '/page/' . $_GET['page']) : 'javascript:;'; ?>"><?php echo __('Recherche'); ?></a></span></div>
<?php if ($tpl['options']['display'] == 'list' && $tpl['objects_count']) : ?>
		<span class="sep">-</span>
		<div><span class="icon icon_options show_tool"><a data-id="options" class="js<?php if (strstr($_GET['section_1'], 'display')) : ?> show<?php endif; ?>" href="<?php echo in_array($_GET['section'], ['album', 'category-items']) ? $tpl['link']($_GET['section'] . (strstr($_GET['section_1'], 'display') ? '' : '-display') . '/' . $tpl['category']['id'] . '/page/' . $_GET['page']) : 'javascript:;'; ?>"><?php echo __('Options d\'affichage'); ?></a></span></div>
<?php endif; ?>
	</div>
	<div id="display">
		<a id="display_list" class="display_link<?php if ($tpl['options']['display'] == 'list') : ?> current<?php endif; ?>" href="javascript:;" title="<?php echo __('Liste'); ?>"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/20x20/display-list.png"></a>
		<a id="display_grid" class="display_link<?php if ($tpl['options']['display'] == 'grid') : ?> current<?php endif; ?>" href="javascript:;" title="<?php echo __('Grille'); ?>"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/20x20/display-grid.png"></a>
		<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post">
			<input name="options" type="hidden" value="">
			<input name="display" type="hidden" value="">
			<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
		</form>
	</div>
</div>

<?php if ($_GET['section_1'] == 'album-upload') : ?>
<form enctype="multipart/form-data" action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool" id="upload_form">
	<fieldset>
		<div id="upload">
			<p class="field">
<?php for ($i = 0; $i < 4; $i++) : ?>
				<input name="file_<?php echo $i ?>" size="40" maxlength="2048" type="file" accept="<?php echo implode(',', $tpl['upload']['filetypes']); ?>"><br>
<?php endfor; ?>
			</p>
			<p id="upload_text_limits"><?php echo $tpl['upload']['text_limits']; ?></p>
			<div id="upload_buttons">
				<input name="MAX_FILE_SIZE" value="<?php echo $tpl['upload_maxfilesize'](); ?>" type="hidden">
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input type="reset" value="<?php echo __('Vider la liste'); ?>">
				<input name="upload" type="submit" value="<?php echo __('Envoyer'); ?>" />
				<p class="field checkbox">
					<input checked="checked" id="activate_files" name="activate_files" type="checkbox">
					<label for="activate_files"><?php echo __('Activer les fichiers'); ?></label>
				</p>
			</div>
		</div>
	</fieldset>
</form>
<?php elseif ($_GET['section'] == 'album' && !isset($_GET['filter'])) : ?>
<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool" id="upload_form">
	<fieldset>
		<div id="upload">
			<div id="upload_list">
				<p id="upload_startmsg"><?php echo __('Déposez vos fichiers ici.'); ?></p>
			</div>
			<div id="upload_infos">
				<p id="upload_infos_total">
					<span><?php echo __('Liste :'); ?></span>
					<span id="upload_infos_files"></span>
					-
					<span id="upload_infos_filesize"></span>
				</p>
				<p>
					<span><?php echo __('Envoyé :'); ?></span>
					<span id="upload_infos_progress_pc">0%</span>
				</p>
			</div>
			<p id="upload_text_limits"><?php echo $tpl['upload']['text_limits'] . ' ' . sprintf(__('Modifiez ces valeurs dans la section %s.'), '<a href="' . $tpl['link']('options-gallery') . '#a-upload-files">' . __('Options') . '</a>'); ?></p>
			<div id="upload_buttons">
				<input type="file" id="upload_input_file" multiple accept="<?php echo implode(',', $tpl['upload']['filetypes']); ?>">
				<input type="button" id="upload_add" value="<?php echo __('Sélectionner des fichiers'); ?>">
				<input type="button" id="upload_clear" value="<?php echo __('Vider la liste'); ?>">
				<input type="button" id="upload_start" value="<?php echo __('Envoyer'); ?>">
				<p class="field checkbox">
					<input<?php if ($tpl['category']['activated']) : ?> checked="checked"<?php endif; ?> id="activate_files" name="activate_files" type="checkbox">
					<label for="activate_files"><?php echo __('Activer les fichiers'); ?></label>
				</p>
			</div>
<?php include('upload_options.tpl.php'); ?>

			<input name="temp_dir" type="hidden" value="<?php echo $tpl['upload']['temp_dir']; ?>">
			<input name="upload" type="hidden" value="1">
			<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
		</div>
	</fieldset>
</form>
<?php endif; ?>

<?php include('albums_search.tpl.php'); ?>

<?php if ($tpl['options']['display'] == 'list' && $tpl['objects_count']) : ?>
<form action="<?php echo str_replace('-display', '', $tpl['current_url_pageless']); ?>" method="post" class="tool<?php if (in_array($_GET['section_1'], ['album-display', 'category-items-display'])) : ?> show<?php endif; ?>" id="options">
	<fieldset>
		<p class="field">
			<label for="nb_per_page"><?php echo __('Nombre de fichiers par page :'); ?></label>
			<input<?php if ($_GET['section_1'] == 'album-display') : ?> autofocus<?php endif; ?> required maxlength="3" size="3" value="<?php echo $tpl['options']['nb_per_page']; ?>" name="nb_per_page" id="nb_per_page" type="text" class="focus">
		</p>
		<p class="field">
			<label for="order_by_column"><?php echo __('Trier par :'); ?></label>
			<select name="order_by_column" id="order_by_column">
<?php foreach ($tpl['options']['order_by_column'] as &$i) : ?>
				<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
			</select>
			<select name="order_by_order">
<?php foreach ($tpl['options']['order_by_order'] as &$i) : ?>
				<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
			</select>
		</p>
		<p class="field">
			<label for="thumbs_size"><?php echo __('Taille des vignettes :'); ?></label>
			<select name="thumbs_size" id="thumbs_size">
<?php foreach ($tpl['options']['thumbs_size'] as &$i) : ?>
				<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
			</select>
		</p>
		<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
		<input name="options" type="submit" value="<?php echo __('Valider'); ?>">
	</fieldset>
</form>
<?php endif; ?>

<?php if ($tpl['upload']['errors'] || $tpl['upload']['warnings']) : ?>
<div class="report_classic">
<?php if ($tpl['upload']['errors']) : ?>
	<div class="report_msg report_error">
<?php foreach ($tpl['upload']['errors'] as &$e) : ?>
		<p><?php echo $e; ?></p>
<?php endforeach; ?>
	</div>
<?php endif; ?>
<?php if ($tpl['upload']['warnings']) : ?>
	<div class="report_msg report_warning">
<?php foreach ($tpl['upload']['warnings'] as &$w) : ?>
		<p><?php echo $w; ?></p>
<?php endforeach; ?>
	</div>
<?php endif; ?>
</div>
<?php endif; ?>

<?php if ($tpl['objects_count'] > 0) : ?>
<?php include('album_' . $tpl['options']['display'] . '.tpl.php'); ?>

<?php else : ?>
<br>
<div class="report_classic">
	<div class="report_msg report_info">
		<p><?php echo (isset($_GET['filter'])) ? __('Aucun fichier trouvé.') : ($tpl['category']['type'] == 'album' ? __('L\'album ne contient aucun fichier.') : __('La catégorie ne contient aucun fichier.')); ?></p>
	</div>
</div>
<br><br>
<?php endif; ?>

<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
<?php foreach ($tpl['tags'] as &$tag) { $tag = "'" . $tag . "'"; } ?>
var tags = [<?php echo implode(', ', $tpl['tags']); ?>];
var tags_flip = [];
var l10n_list_tags_empty = "<?php echo $tpl['php2js'](__('La galerie ne contient aucun tag.')); ?>";
</script>

<?php endif; ?>
