<?php $confirm_delete = __('Supprimer les entrées sélectionnées ?'); ?>
<div id="page_table" class="page_content">
	<div>
		<div id="browse" class="browse js_box">
			<span id="browse_link" class="icon icon_browse js_box_link"><a class="js" href="javascript:;"><?php echo __('Parcourir'); ?></a></span>
			<div id="browse_content" class="js_box_inner">
				<div id="browse_arrow"></div>
				<div id="browse_inner">
					<p id="browse_search" class="field"><input name="search" type="text"></p>
					<div>
						<ul tabindex="-1">
<?php foreach ($tpl['users'] as &$i) : ?>
							<li id="<?php if (in_array($i['id'], [0, 2])) : ?>!<?php endif; ?>v<?php if ($i['current']) : ?>c<?php endif; ?>{<?php echo $i['id']; ?>}"><a href="javascript:;"><b><?php echo $i['name']; ?></b><i><?php echo $i['count']; ?></i></a></li>
<?php endforeach; ?>
						</ul>
					</div>
				</div>
			</div>
		</div>

		<nav id="section_nav">
<?php include('breadcrumb.tpl.php'); ?>
		</nav>

<?php if (isset($_POST['action']) && $_POST['action'] == 'delete_confirm') : ?>
<?php include('delete_selection.tpl.php'); ?>
<?php else : ?>

		<div class="tools">
			<div><span class="icon icon_search show_tool"><a data-id="search" class="js<?php if (strstr($_GET['section_1'], 'search')) : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('logs' . (strstr($_GET['section_1'], 'search') ? '' : '-search') . '/page/' . $_GET['page']); ?>"><?php echo __('Recherche'); ?></a></span></div>
			<span class="sep">-</span>
			<div><span class="icon icon_options show_tool"><a data-id="options" class="js<?php if (strstr($_GET['section_1'], 'display')) : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('logs' . (strstr($_GET['section_1'], 'display') ? '' : '-display') . '/page/' . $_GET['page']); ?>"><?php echo __('Options d\'affichage'); ?></a></span></div>
		</div>

		<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool<?php if (strstr($_GET['section_1'], 'search')) : ?> show<?php endif; ?>" id="search">
			<fieldset>
				<p class="field">
					<label for="search_query"><?php echo __('Rechercher :'); ?></label>
					<input<?php if (strstr($_GET['section_1'], 'search')) : ?> autofocus<?php endif; ?> required data-help-icon="search" value="<?php echo $tpl['search']['query']; ?>" class="focus" type="text" name="search_query" id="search_query" maxlength="255" size="50" data-reset="">
				</p>
				<p class="field">
					<input<?php echo $tpl['search']['all_words'] ? ' checked' : ''; ?> type="checkbox" name="search_options[all_words]" id="search_all_words" data-reset="1">
					<label for="search_all_words"><?php echo __('Rechercher tous les mots'); ?></label>
				</p>
				<p class="field">
					<span class="icon icon_search_options showhide" rel="#adv_search"><a class="js" href="<?php echo $tpl['link']('logs-' . (strstr($_GET['section_1'], 'advanced') ? 'search' : 'search-advanced') . '/page/' . $_GET['page']); ?>"><?php echo __('Options de recherche'); ?></a></span>
				</p>
				<div id="adv_search" class="adv_search_col<?php if (strstr($_GET['section_1'], 'advanced')) : ?> show<?php endif; ?>">
					<div>
						<p class="field">
							<?php echo __('Rechercher dans les champs suivants :'); ?>
						</p>
						<div class="field_sublvl">
							<p class="field">
								<input<?php echo $tpl['search']['columns']['log_ip'] ? ' checked' : ''; ?> type="checkbox" name="search_options[columns][]" value="log_ip" id="search_log_ip" data-reset="1">
								<label for="search_log_ip"><?php echo __('IP'); ?></label>
							</p>
						</div>
						<p class="field">
							<label for="search_action"><?php echo __('Rechercher par action :'); ?></label>
							<select name="search_options[action]" id="search_action" data-reset="*">
<?php foreach ($tpl['search']['actions'] as &$i) : ?>
								<option<?php echo $i['selected'] ? ' selected' : ''; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
							</select>
						</p>
						<p class="field">
							<label for="search_result"><?php echo __('Rechercher par résultat :'); ?></label>
							<select name="search_options[result]" id="search_result" data-reset="*">
<?php foreach ($tpl['search']['result'] as &$i) : ?>
								<option<?php echo $i['selected'] ? ' selected' : ''; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
							</select>
						</p>
					</div>
					<div>
						<p class="field">
							<input<?php echo $tpl['search']['date'] ? ' checked' : ''; ?> id="search_date" type="checkbox" name="search_options[date]" data-reset="0">
							<label for="search_date"><?php echo __('Rechercher par date :'); ?></label>
						</p>
						<div class="field_sublvl">
							<input type="hidden" name="search_options[date_column]" value="log_date">
<?php include('search_date.tpl.php'); ?>
						</div>
					</div>
				</div>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input name="search" type="submit" value="<?php echo __('Chercher'); ?>">
				<input class="button reset_js" type="reset" value="<?php echo __('Réinitialiser'); ?>">
			</fieldset>
		</form>

		<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool<?php if ($_GET['section_1'] == 'logs-display') : ?> show<?php endif; ?>" id="options">
			<fieldset>
				<p class="field">
					<label for="nb_per_page"><?php echo __('Nombre d\'entrées par page :'); ?></label>
					<input<?php if ($_GET['section_1'] == 'logs-display') : ?> autofocus<?php endif; ?> required maxlength="3" size="3" value="<?php echo $tpl['options']['nb_per_page']; ?>" name="nb_per_page" id="nb_per_page" type="text" class="focus">
				</p>
				<p class="field">
					<label for="order_by_column"><?php echo __('Trier par :'); ?></label>
					<select name="order_by_column" id="order_by_column">
<?php foreach ($tpl['options']['order_by_column'] as &$i) : ?>
						<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
					</select>
					<select name="order_by_order">
<?php foreach ($tpl['options']['order_by_order'] as &$i) : ?>
						<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
					</select>
				</p>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input name="options" type="submit" value="<?php echo __('Valider'); ?>">
			</fieldset>
		</form>

<?php if ($tpl['objects_count'] > 0) : ?>

<?php include('pagination.tpl.php'); ?>

		<div class="table_form_container">
			<form class="table_form" id="logs_form" action="<?php echo $tpl['current_url']; ?>" method="post">

				<div id="obj_links_js">
					<div>
						<a class="js show_all" href="javascript:;"><?php echo __('Tout montrer'); ?></a>
						<span class="sep">-</span>
						<a class="js hide_all" href="javascript:;"><?php echo __('Tout cacher'); ?></a>
					</div>
<?php include('object_select.tpl.php'); ?>
				</div>

				<table class="default page">
					<tr>
						<th class="user"><?php echo __('Utilisateur'); ?></th>
						<th class="action"><?php echo __('Action'); ?></th>
						<th class="date"><?php echo __('Date'); ?></th>
						<th class="ip"><?php echo __('IP'); ?></th>
						<th class="result"><?php echo __('Résultat'); ?></th>
						<th class="details null"></th>
						<th class="null"></th>
					</tr>
<?php $n = 1; foreach ($tpl['logs'] as &$i) : ?>
					<tr class="selectable_class<?php if (is_integer($n / 2)) : ?> even<?php endif; ?>">
						<td class="filter user"><div><?php if ($i['user_link']) : ?><a class="avatar_link" href="<?php echo $i['user_link']; ?>"><img class="avatar" src="<?php echo $i['user_avatar_thumb_src']; ?>"></a><span class="user_name"><a href="<?php echo $i['user_link']; ?>"><?php echo $i['user_name']; ?></a></span><?php else : ?><img class="avatar" src="<?php echo $i['user_avatar_thumb_src']; ?>"><span class="user_name"><?php echo $i['user_name']; ?></span><?php endif; ?><a title="<?php echo __('Afficher toutes les actions de cet utilisateur'); ?>" class="filter_link" href="<?php echo $i['filter_user_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a></div></td>
						<td class="filter action"><div><span class="icon icon_<?php echo $i['icon']; ?>"><?php echo $i['action_text']; ?></span><a title="<?php echo __('Afficher toutes les entrées correspondantes à cette action'); ?>" class="filter_link" href="<?php echo $i['filter_action_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a></div></td>
						<td class="filter date"><div><?php echo L10N::dt(__('%A %d %B %Y'), $i['date']); ?><br><?php echo L10N::dt(__('%H:%M:%S'), $i['date']); ?><a title="<?php echo __('Afficher toutes les actions effectuées à cette date'); ?>" class="filter_link" href="<?php echo $i['filter_date_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a></div></td>
						<td class="filter ip"><div><?php echo $i['ip']; ?><a title="<?php echo __('Afficher toutes les actions en provenance de cette IP'); ?>" class="filter_link" href="<?php echo $i['filter_ip_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a></div></td>
						<td class="filter result"><div><?php if ($i['result'] == 'rejected') : ?><span class="icon icon_reject"><?php echo __('Rejeté'); ?></span><a title="<?php echo __('Afficher toutes les actions rejetées'); ?>" class="filter_link" href="<?php echo $i['filter_result_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a><?php else : ?><span class="icon icon_accept"><?php echo __('Accepté'); ?></span><a title="<?php echo __('Afficher toutes les actions acceptées'); ?>" class="filter_link" href="<?php echo $i['filter_result_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a><?php endif; ?></div></td>
						<td class="details"><span class="show_parts"><a title="<?php echo __('Détails'); ?>" data-id="details_<?php echo $i['id']; ?>" href="javascript:;"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/report-plus.png"></a></span></td>
						<td class="selectable_zone"><input class="selectable" name="selected[<?php echo $i['id']; ?>]" type="checkbox"></td>
					</tr>
					<tr class="log_details obj_fold" id="details_<?php echo $i['id']; ?>">
						<td colspan="5"><div><?php if ($i['rejected_cause']) : ?><div><?php echo __('Cause du rejet :'); ?><?php echo $i['rejected_cause']; ?><?php if ($i['rejected_match']) : ?>[<span class="log_match"><?php echo $i['rejected_match']; ?></span>]<?php endif; ?></div><?php endif; ?><div><?php echo __('Page :'); ?><?php if ($i['page_link']) : ?><a href="<?php echo $i['page_link']; ?>"><?php echo $i['page']; ?></a><?php else : ?><?php echo mb_strtolower($i['page']); ?><?php endif; ?></div><?php if ($i['params']) : ?><div><table class="light"><tr><th class="title"><?php echo __('Paramètre'); ?></th><th class="title"><?php echo __('Valeur'); ?></th></tr><?php foreach ($i['params'] as $p => $v) : ?><tr><td><?php echo $p; ?></td><td><?php echo $v; ?></td></tr><?php endforeach; ?></table></div><?php endif; ?></div></td>
					</tr>
<?php $n++; endforeach; ?>
				</table>

				<div id="submit" class="submit_actions submit_table<?php if ($tpl['nb_pages'] > 1) : ?> submit_pages<?php endif; ?>">
					<div>
						<p id="form_actions">
							<label for="selection_action"><?php printf(__('Action sur la sélection (%s) :'), '<span id="select_num">0</span>'); ?></label>
							<select id="selection_action" name="action">
								<optgroup label="<?php echo __('Suppression'); ?>">
									<option value="delete_confirm"><?php echo __('Supprimer'); ?></option>
								</optgroup>
								<optgroup label="<?php echo __('Bannissements (invités)'); ?>">
									<option value="ban_ip"><?php echo __('Bannir l\'IP'); ?></option>
								</optgroup>
							</select>
							<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
							<input name="selection" type="submit" value="<?php echo __('Valider'); ?>">
						</p>
					</div>
				</div>
			</form>
		</div>

		<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
		var confirm_delete = "<?php echo $tpl['php2js']($confirm_delete); ?>";
		</script>

<?php include('pagination.tpl.php'); ?>

<?php else : ?>
		<br>
		<div class="report_classic">
			<div class="report_msg report_info">
				<p><?php echo isset($_GET['search']) ? __('Aucune entrée trouvée.') : __('Aucune entrée.'); ?></p>
			</div>
		</div>
<?php endif; ?>

<?php endif; ?>

	</div>
</div>