<?php
declare(strict_types = 1);

/**
 * Traitement des requêtes Ajax.
 *
 * @license http://www.gnu.org/licenses/gpl.html
 * @link http://www.igalerie.org/
 */
require_once(__DIR__ . '/includes/prepend.php');
require_once(__DIR__ . '/includes/Ajax.class.php');

$data = json_decode(file_get_contents('php://input'), TRUE);
if ($data)
{
	$_POST = $data;
}

switch ($_POST['section'] ?? '')
{
	// Édition d'une catégorie.
	case 'cat-edit' :
		Ajax::init();
		require_once(__DIR__ . '/includes/gallery/classes/AjaxGallery.class.php');
		AjaxGallery::editCategory();
		break;

	// Mot de passe de catégorie.
	case 'cat-password' :
		Ajax::init(FALSE, FALSE);
		require_once(__DIR__ . '/includes/gallery/classes/AjaxGallery.class.php');
		AjaxGallery::checkCatPassword();
		break;

	// Suppression d'un commentaire.
	case 'comment-delete' :
		Ajax::init();
		require_once(__DIR__ . '/includes/gallery/classes/AjaxGallery.class.php');
		AjaxGallery::deleteComment();
		break;

	// Édition d'un commentaire.
	case 'comment-edit' :
		Ajax::init();
		require_once(__DIR__ . '/includes/gallery/classes/AjaxGallery.class.php');
		AjaxGallery::editComment();
		break;

	// Enregistrements de données dans le cookie des préférences.
	case 'cookie-prefs-write' :
		Ajax::init(FALSE, FALSE);
		require_once(__DIR__ . '/includes/gallery/classes/AjaxGallery.class.php');
		AjaxGallery::cookiePrefsWrite();
		break;

	// Gestion du diaporama.
	case 'diaporama' :
		Ajax::init(FALSE, FALSE);
		require_once(__DIR__ . '/includes/gallery/classes/AjaxDiaporama.class.php');
		AjaxDiaporama::getData();
		break;

	// Gestion du mode d'affichage en grille.
	case 'grid-get-categories' :
	case 'grid-get-items' :
	case 'grid-get-items-pending' :
	case 'grid-get-tags-items' :
	case 'grid-update-categories' :
	case 'grid-update-group-categories' :
	case 'grid-update-group-items' :
	case 'grid-update-group-items-pending' :
	case 'grid-update-items' :
		Ajax::init(TRUE);
		require_once(__DIR__ . '/includes/admin/classes/AjaxGrid.class.php');
		$method = str_replace('grid-', '', $_POST['section']);
		$method = ucwords(str_replace('-', ' ', $method));
		$method = str_replace(' ', '', $method);
		AjaxGrid::{$method}();
		break;

	// Gestion des favoris.
	case 'favorites-add' :
	case 'favorites-remove' :
		Ajax::init();
		require_once(__DIR__ . '/includes/gallery/classes/AjaxGallery.class.php');
		AjaxGallery::favorites(substr($_POST['section'], 10));
		break;

	// Gestion des favoris : suppression de plusieurs fichiers des favoris.
	case 'favorites-remove-all' :
		Ajax::init();
		require_once(__DIR__ . '/includes/gallery/classes/AjaxGallery.class.php');
		AjaxGallery::favoritesRemoveAll();
		break;

	// Suppression d'un fichier.
	case 'item-delete' :
		Ajax::init();
		require_once(__DIR__ . '/includes/gallery/classes/AjaxGallery.class.php');
		AjaxGallery::deleteItem();
		break;

	// Édition d'un fichier.
	case 'item-edit' :
		Ajax::init();
		require_once(__DIR__ . '/includes/gallery/classes/AjaxGallery.class.php');
		AjaxGallery::editItem();
		break;

	// Connexion utilisateur.
	case 'login' :
		Ajax::init(FALSE, FALSE);
		require_once(__DIR__ . '/includes/gallery/classes/AjaxGallery.class.php');
		AjaxGallery::login();
		break;

	// Déconnexion.
	case 'logout' :
		Ajax::init((bool) $_POST['from_admin'], FALSE);
		Ajax::logout();
		break;

	// Mode sélection.
	case 'selection' :
		Ajax::init(FALSE, FALSE);
		require_once(__DIR__ . '/includes/gallery/classes/AjaxGallery.class.php');
		AjaxGallery::selection();
		break;

	// Récupération de fichiers utilisés par le thème.
	case 'theme-files' :
		Ajax::init();
		require_once(__DIR__ . '/includes/gallery/classes/AjaxGallery.class.php');
		AjaxGallery::themeFiles();
		break;

	// Paramètres de thème.
	case 'theme-params' :
		Ajax::init();
		require_once(__DIR__ . '/includes/gallery/classes/AjaxGallery.class.php');
		AjaxGallery::themeParams();
		break;

	// Récupération de l'URL de vignettes de catégories.
	case 'thumbs-cat-source' :
		Ajax::init();
		require_once(__DIR__ . '/includes/gallery/classes/AjaxGallery.class.php');
		AjaxGallery::thumbsCatSource();
		break;

	// Récupération de l'URL de vignettes de fichiers.
	case 'thumbs-items-source' :
		Ajax::init();
		require_once(__DIR__ . '/includes/gallery/classes/AjaxGallery.class.php');
		AjaxGallery::thumbsItemsSource();
		break;

	// Envoi de fichiers.
	case 'upload' :
		Ajax::init((bool) $_POST['from_admin']);
		Ajax::uploadFile();
		break;

	// Ajoute une note.
	case 'vote-add' :
		Ajax::init(FALSE, FALSE);
		require_once(__DIR__ . '/includes/gallery/classes/AjaxVote.class.php');
		AjaxVote::add();
		break;

	// Supprime une note.
	case 'vote-remove' :
		Ajax::init(FALSE, FALSE);
		require_once(__DIR__ . '/includes/gallery/classes/AjaxVote.class.php');
		AjaxVote::remove();
		break;
}
?>