<?php
declare(strict_types = 1);

class_exists('DB') || die;

require_once(__DIR__ . '/classes/GalleryUsers.class.php');

// Permission "Création d'albums".
if (!Auth::$groupPerms['create_albums'])
{
	Gallery::notFound();
	return;
}

Template::set('template',
[
	'content' => 'user_new_cat.tpl.php',
	'file' => 'user.tpl.php'
]);

$r = GalleryUsers::createCategory();
if ($r < 0)
{
	Gallery::error();
	return;
}
if ($r < 1)
{
	Gallery::notFound();
	return;
}

$r = GalleryUsers::getInfos();
if ($r < 0)
{
	Gallery::error();
	return;
}
if ($r < 1)
{
	Gallery::notFound();
	return;
}

Template::set('categories_list', GalleryUsers::getCatList('categories')['v']);
?>