<?php
declare(strict_types = 1);

class_exists('DB') || die;

require_once(__DIR__ . '/classes/GalleryUsers.class.php');

// Permission "Ajout de fichiers".
if (!Auth::$groupPerms['upload'])
{
	Gallery::notFound();
	return;
}

Template::set('template',
[
	'content' => 'user_upload.tpl.php',
	'file' => 'user.tpl.php'
]);

$upload_type = substr(Auth::$groupPerms['upload_type'], 0, -1);
$types = Item::getTypesSupported($upload_type);
$text_limits = sprintf(__('Formats acceptés : %s.'), implode(', ', $types['text']));
$text_limits .= ' ' . sprintf(
	__('Poids maximum des fichiers : %s.'),
	L10N::formatFilesize(Config::$params['upload_maxfilesize'] * 1024 * 1024)
);
if ($upload_type != 'video')
{
	$text_limits .= ' ' . sprintf(
		__('Dimensions maximum des images : %s x %s pixels.'),
		Config::$params['upload_maxwidth'], Config::$params['upload_maxheight']
	);
}
Template::set('upload',
[
	'fileexts' => $types['ext'],
	'filetypes' => $types['mime'],
	'temp_dir' => Security::keyHMAC(),
	'text_limits' => $text_limits,
	'text_types' => $upload_type == 'image' ? __('images')
		: ($upload_type == 'video' ? __('vidéos') : __('images et vidéos')),
	'validation' => (int) !Auth::$groupPerms['upload_mode']
]);

$r = GalleryUsers::upload();
if ($r < 0)
{
	Gallery::error();
	return;
}
if ($r < 1)
{
	Gallery::notFound();
	return;
}

$r = GalleryUsers::getInfos();
if ($r < 0)
{
	Gallery::error();
	return;
}
if ($r < 1)
{
	Gallery::notFound();
	return;
}

Template::set('upload', ['albums_list' => GalleryUsers::getCatList('albums')]);
?>