<?php
declare(strict_types = 1);

class_exists('DB') || die;

// Paramètres par défaut.
define('THEME_PARAMS_DEFAULT',
[
	'style' => 'clear',
	'style_change' => '0',
	'color' =>
	[
		'clear' => '#3B5EB5',
		'dark' => '#D54949'
	],
	'banner' =>
	[
		'clear' =>
		[
			'type' => 'texture',
			'texture' => 'diamond-upholstery.png',
			'file' => '',
			'height' => '120px'
		],
		'dark' =>
		[
			'type' => 'texture',
			'texture' => 'diamond-upholstery.png',
			'file' => '',
			'height' => '120px'
		]
	],
	'background' =>
	[
		'clear' =>
		[
			'type' => 'border',
			'fixed' => '1',
			'texture' => 'swirl-pattern.png',
			'file' => ''
		],
		'dark' =>
		[
			'type' => 'border',
			'fixed' => '1',
			'texture' => 'stardust.png',
			'file' => '',
			'internal_hatches' => '0'
		]
	],
	'buttons' =>
	[
		'clear' => ['style' => '1'],
		'dark' => ['style' => '1']
	],
	'css' =>
	[
		'clear' => '',
		'dark' => ''
	],
	'gallery' =>
	[
		'size' => 'small'
	],
	'menu' =>
	[
		'width' => '100'
	],
	'text' =>
	[
		'desc_width_limit' => '1',
		'size' => '100'
	],
	'thumbs_cat' =>
	[
		'layout' => 'landscape',
		'size' => 'small'
	],
	'thumbs_items' =>
	[
		'layout' => 'standard',
		'size' => 'small'
	],
	'display' =>
	[
		'item_pagination_bottom' => '1',
		'item_pagination_top' => '0',
		'item_prev_next' => '1',
		'item_properties' => '1',
		'item_stats' => '1',
		'item_title' => '1',
		'item_user' => '1',
		'menu' => '1',
		'menu_home' => '1'
	]
]);

// Paramètres en base de données.
$params = Template::$data['theme']['params'];

// Mise à jour des paramètres.
$update = function(string $section, array &$values, array &$params) use (&$update): void
{
	foreach ($values as $name => &$v)
	{
		if (!array_key_exists($name, $params[$section]))
		{
			$params[$section][$name] = $v;
		}
		else if (is_array($v))
		{
			$update($name, $v, $params[$section]);
		}
	}
};
foreach (THEME_PARAMS_DEFAULT as $section => &$values)
{
	if (!array_key_exists($section, $params))
	{
		$params[$section] = $values;
	}
	else if (is_array($values))
	{
		$update($section, $values, $params);
	}
}

// Version 3.0.9.
$params['color']['clear'] = '#' . str_replace('#', '', (string) $params['color']['clear']);
$params['color']['dark'] = '#' . str_replace('#', '', (string) $params['color']['dark']);

// Style.
$theme_edit = $tpl['user']['admin'] || $params['style_change'];
Template::set('theme', ['style' => $style = $params['style']]);
Template::set('theme', ['user_style' => $style]);
Template::set('theme', ['user_style_change' => $style_change = (int) $params['style_change']]);

// Style utilisateur.
if ($params['style_change'] && is_object(Auth::$prefs))
{
	$user_style = (string) Auth::$prefs->read('theme_default_user_style');
	if (in_array($user_style, ['clear', 'dark']))
	{
		Template::set('theme', ['user_style' => $style = $params['style'] = $user_style]);
	}
}

// Liste des textures disponibles.
$textures =
[
	'banner' =>
	[
		'clear' =>
		[
			'cubes.png' => '',
			'diamond-upholstery.png' => '',
			'dimension.png' => '',

			'foggy-birds.png' => '',
			'food.png' => '',
			'green-gobbler.png' => '',

			'light-wool.png' => '',
			'starring.png' => '',
			'tiny-grid.png' => ''
		],
		'dark' =>
		[
			'brushed-alum.png' => '#111',
			'climpek.png' => '#4c4c4c',
			'cubes.png' => '#4c4c4c',

			'diamond-upholstery.png' => '#3c3c3c',
			'dimension.png' => '#4c4c4c',
			'escheresque.png' => '#111',

			'foggy-birds.png' => '#4c4c4c',
			'light-wool.png' => '#4c4c4c',
			'subtle-stripes.png' => '#4c4c4c'
		]
	],
	'background' =>
	[
		'clear' =>
		[
			'arches.png' => '#fff',
			'batthern.png' => '#fff',
			'climpek.png' => '#fff',

			'dimension.png' => '#fff',
			'food.png' => '#fff',
			'hatches.png' => '#fff',

			'memphis-colorful.png' => '#fff',
			'swirl-pattern.png' => '#fff',
			'washi.png' => '#fff',

			'squares-2.png' => '#fff',
			'squares-15.png' => '#fff',
			'squares-30.png' => '#fff'
		],
		'dark' =>
		[
			'black-mamba.png' => '#111',
			'simple-dashed.png' => '#111',
			'stardust.png' => '#111'
		]
	]
];

// Répertoires.
$banners_dir = CONF_GALLERY_PATH . '/images/banners/';
$background_dir = CONF_GALLERY_PATH . '/images/background/';
$textures_dir = CONF_GALLERY_PATH . '/images/textures/';

// Données de template des options du thème.
if ($theme_edit)
{
	// Palette et textures.
	if ($tpl['user']['admin'])
	{
		Template::set('theme', ['palette' =>
		[
			'#575757', '#966B3C', '#877240', '#888040', '#7F8840', '#61893D', '#3D8946',
			'#828282', '#977857', '#877B5A', '#9D933F', '#8F9D3F', '#76A64B', '#5FA567',
			'#3A8E67', '#369291', '#328296', '#3B7AB5', '#3B5EB5', '#584EB5', '#873D9F',
			'#37A575', '#2DAEB5', '#159DC4', '#6492D8', '#738DE0', '#7E6EB8', '#B577DD',
			'#9D3DA6', '#B52262', '#E85392', '#D22828', '#D85C18', '#CD842D', '#C89418',
			'#D15CD9', '#D575BB', '#DE6CAC', '#D54949', '#D55949', '#D47149', '#C47E2C'
		]]);
	}
	Template::set('theme', ['textures_dir' => $textures_dir]);
	Template::set('theme', ['textures_json' => Utility::jsonEncode($textures)]);

	// Bannières et fonds.
	foreach (['banners', 'background'] as $name)
	{
		if ($tpl['user']['admin'])
		{
			$files = [];
			foreach (scandir(GALLERY_ROOT . '/images/' . $name) as $f)
			{
				if (preg_match('`^[a-z0-9_-]{1,250}\.(gif|jpe?g|png|webp)$`i', $f))
				{
					$files[] = $f;
				}
			}
			Template::set('theme', [$name => $files]);
		}
		Template::set('theme', [$name . '_dir' => ${$name . '_dir'}]);
	}
}

// Paramètres du thème au format JSON.
Template::set('theme', ['params_json' => Utility::jsonEncode($params)]);

// Classes pour <body> et variables CSS.
$body_class = [];
$variables = [];

// Style sombre.
$style_dark =  '<link rel="stylesheet" id="style_dark" type="text/css" media="screen" '
	. 'title="style" href="' . $tpl['gallery']['template']['path']()
	. '/style/dark.css?' . $tpl['version_key'] . '">';
if ($params['style'] == 'dark')
{
	echo "\t" . $style_dark . "\n";
}

// Couleur du thème.
$color = substr($params['color'][$params['style']], 1);
$variables['--color'] = '#' . $color;

// Boutons de formulaires.
if ($params['style'] == 'clear' && $params['buttons']['clear']['style'] == '2')
{
	$body_class[] = 'btn_2_clear';
}
if ($params['style'] == 'dark' && $params['buttons']['dark']['style'] == '2')
{
	$body_class[] = 'btn_2_dark';
}

// Bannière.
$variables['--header-height'] = $params['banner'][$params['style']]['height'];
switch ($params['banner'][$params['style']]['type'])
{
	case 'file' :
	case 'texture' :
		$header_class = 'banner';
		break;

	case 'color' :
		$header_class = 'color';
		break;

	default :
		$header_class = 'none';
}

if ($params['banner'][$params['style']]['type'] == 'texture')
{
	$file = $params['banner'][$params['style']]['texture'];
	$color = $textures['banner'][$params['style']][$file] ?? '';
	$variables['--banner-color'] = $color
		? $color
		: ($params['style'] == 'clear' ? $variables['--color'] : '#4c4c4c');
	$variables['--banner-image'] = 'url(' . $textures_dir . $file . ')';
}

if ($params['banner'][$params['style']]['type'] == 'file')
{
	$file = $params['banner'][$params['style']]['file'] ?? '';
	$variables['--banner-color'] = 'transparent';
	$variables['--banner-image'] = 'url(' . $banners_dir . $file . ')';
	$variables['--banner-size'] = 'cover';
	$variables['--banner-position'] = 'center';
	$variables['--banner-repeat'] = 'no-repeat';
}

// Fond.
if ($params['background'][$params['style']]['type'] != 'none')
{
	$body_class[] = 'bg';
}
if ($params['style'] == 'dark' && $params['background']['dark']['internal_hatches'])
{
	$body_class[] = 'hatches';
}

$variables['--background-color'] = $params['style'] == 'dark' ? '#111' : 'none';
$variables['--background-attachment'] = $params['background'][$params['style']]['fixed'] == 1
	? 'fixed'
	: 'scroll';

if ($params['background'][$params['style']]['type'] == 'texture')
{
	$file = $params['background'][$params['style']]['texture'];
	$variables['--background-color'] = $textures['background'][$params['style']][$file];
	$variables['--background-image'] = 'url(' . $textures_dir . $file . ')';
}

if ($params['background'][$params['style']]['type'] == 'file')
{
	$file = $background_dir . $params['background'][$params['style']]['file'];
	$variables['--background-image'] = 'url(' . $file . ')';
}

// Largeur du menu.
$variables['--menu-max-width'] = $params['menu']['width'] . '%';

// Largeur des descriptions.
$variables['--desc-max-width'] = $params['text']['desc_width_limit'] ? 'min(80%, 900px)' : 'none';

// Taille du texte.
$variables['--text-size'] = $params['text']['size'] . '%';

// Variables CSS.
$root = [];
foreach ($variables as $var => &$value)
{
	$root[] = "\t\t$var: $value;";
}
printf(
	"\t<style nonce=\"%s\" type=\"text/css\">\n\t:root\n\t{\n%s\n\t}\n\t</style>\n",
	CSP_NONCE, implode("\n", $root)
);

// Code CSS personnalisé.
if ($tpl['user']['admin'] || !empty($params['css'][$params['style']]))
{
	$tags = ['#color', '#gallery_path'];
	$tags_replace = ["#$color", $tpl['gallery']['path']];
	$css = preg_replace_callback(
		'`(\{(?:[\s\S](?![{}]))*?)(' . implode('|', $tags) . ')((?:[\s\S](?![{]))*?\})`i',
		function($m) use ($color, $tags, $tags_replace)
		{
			return str_ireplace($tags, $tags_replace, $m[0]);
		},
		$params['css'][$params['style']]
	);
	$css = str_replace(['&#039;', '&quot;', '&gt;'], ["'", '"', '>'], $css);
	printf(
		"\t<style nonce=\"%s\" type=\"text/css\" id=\"style_custom\">\n%s\n\t</style>\n",
		CSP_NONCE, $css
	);
}

// Taille et type d'affichage des vignettes.
$thumbs_cat_size = $params['thumbs_cat']['size'];
$thumbs_items_size = $params['thumbs_items']['size'];
$thumbs_cat_layout = implode(' ', [$params['thumbs_cat']['layout'], $thumbs_cat_size]);
$thumbs_items_layout = implode(' ', [$params['thumbs_items']['layout'], $thumbs_items_size]);

// Taille de la galerie.
$gallery_size = in_array($params['gallery']['size'], ['small', 'large', 'superlarge'])
	? $params['gallery']['size']
	: 'small';

// Format des vignettes.
switch ($params['thumbs_items']['layout'])
{
	case 'landscape' :
		$thumbs_items_size = $thumbs_items_size == 'superlarge'
			? '378x252'
			: ($thumbs_items_size == 'large' ? '248x165' : '161x107');
		break;
	case 'portrait' :
		$thumbs_items_size = $thumbs_items_size == 'superlarge'
			? '378x566'
			: ($thumbs_items_size == 'large' ? '248x371' : '161x241');
		break;
	case 'square' :
		$thumbs_items_size = $thumbs_items_size == 'superlarge'
			? '378x378'
			: ($thumbs_items_size == 'large' ? '248x248' : '161x161');
		break;
	default :
		$thumbs_items_size = $thumbs_items_size == 'superlarge'
			? '368'
			: ($thumbs_items_size == 'large' ? '238' : '151');
		break;
}
switch ($params['thumbs_cat']['layout'])
{
	case 'portrait' :
		$thumbs_cat_size = $thumbs_cat_size == 'large' ? '363x544' : '232x348';
		break;
	case 'square' :
		$thumbs_cat_size = $thumbs_cat_size == 'large' ? '363x363' : '232x232';
		break;
	default :
		$thumbs_cat_size = $thumbs_cat_size == 'large' ? '363x262' : '232x167';
		break;
}

// Éléments à afficher.
foreach ($params['display'] as $k => $v)
{
	${'display_' . $k} = (bool) $params['display'][$k];
}
?>