<form id="search_page" class="standard<?php if ($tpl['search_advanced']) : ?> adv<?php endif; ?>" action="<?php echo $tpl['current_url_pageless']; ?>" method="post">
	<h2><?php echo __('Recherche'); ?></h2>
	<p class="field" id="search_query_container">
		<span>
			<label for="search_query"><?php echo __('Rechercher :'); ?></label>
			<a data-id="search_infos" class="infos_icon" href="javascript:;" title="<?php echo __('Obtenir de l\'aide sur cette fonction'); ?>">&#xea0c;</a>
		</span>
		<input required autofocus name="search_query" id="search_query" maxlength="68" size="40" type="text" class="large">
	</p>
	<p class="field infos_container" id="search_infos">
		<span><?php echo __('Utilisez les jokers (?) ou (*) pour remplacer respectivement n\'importe quel caractère ou n\'importe quelle suite de caractères.'); ?></span>
		<span><?php echo __('Entourez une expression avec les guillemets double (") pour rechercher cette expression exacte.'); ?></span>
		<span><?php echo __('Préfixez un terme avec le signe moins (-) afin d\'exclure de la recherche tous les fichiers contenant ce terme dans l\'un des champs sélectionnés.'); ?></span>
	</p>
<?php if ($tpl['search_advanced']) : ?>
	<p class="field">
		<input name="search_options[all_words]" id="search_all_words" type="checkbox">
		<label for="search_all_words"><?php echo __('Rechercher tous les mots'); ?></label>
	</p>
<?php if ($tpl['search_options']['favorites']) : ?>
	<p class="field">
		<input name="search_options[favorites]" id="search_favorites" type="checkbox">
		<label for="search_favorites"><?php echo __('Rechercher uniquement dans mes favoris'); ?></label>
	</p>
<?php endif; ?>
<?php if ($_GET['section'] != 'search-advanced') : ?>
	<p class="field">
		<span id="search_options_link"><a href="javascript:;"><span>&#xf067;</span> <?php echo __('Options'); ?></a></span>
	</p>
<?php endif; ?>
	<div id="search_options">
		<div>
			<fieldset>
				<legend><?php echo __('Champs'); ?></legend>
				<p class="field">
					<input checked name="search_options[columns][]" value="name" id="search_name" type="checkbox">
					<label for="search_name"><?php echo __('Titre'); ?></label>

					<input checked name="search_options[columns][]" value="filename" id="search_filename" type="checkbox">
					<label for="search_filename"><?php echo __('Nom de fichier'); ?></label>

					<input checked name="search_options[columns][]" value="desc" id="search_description" type="checkbox">
					<label for="search_description"><?php echo __('Description'); ?></label>
				</p>
<?php if ($tpl['search_options']['comments'] || $tpl['search_options']['tags']) : ?>
				<p class="field">
<?php if ($tpl['search_options']['tags']) : ?>
					<input checked name="search_options[columns][]" value="tags" id="search_tags" type="checkbox">
					<label for="search_tags"><?php echo __('Tags'); ?></label>
<?php endif; ?>
<?php if ($tpl['search_options']['comments']) : ?>
					<input name="search_options[columns][]" value="comments" id="search_comments" type="checkbox">
					<label for="search_comments"><?php echo __('Commentaires'); ?></label>
<?php endif; ?>
				</p>
<?php endif; ?>
			</fieldset>
<?php if ($tpl['search_options']['type']) : ?>
			<fieldset>
				<legend><?php echo __('Types de fichiers'); ?></legend>
				<p class="field">
					<input checked value="all" id="search_type_all" type="radio" name="search_options[type]">
					<label for="search_type_all"><?php echo __('Tous'); ?></label>

					<input value="image" id="search_type_images" type="radio" name="search_options[type]">
					<label for="search_type_images"><?php echo __('Images'); ?></label>

					<input value="video" id="search_type_videos" type="radio" name="search_options[type]">
					<label for="search_type_videos"><?php echo __('Vidéos'); ?></label>
				</p>
			</fieldset>
<?php endif; ?>
			<fieldset>
				<legend><?php echo __('Format d\'image'); ?></legend>
				<p class="field">
					<input checked value="all" id="search_format_all" type="radio" name="search_options[format]">
					<label for="search_format_all"><?php echo __('Tous'); ?></label>

					<input value="square" id="search_format_square" type="radio" name="search_options[format]">
					<label for="search_format_square"><?php echo __('Carré'); ?></label>

					<input value="portrait" id="search_format_portrait" type="radio" name="search_options[format]">
					<label for="search_format_portrait"><?php echo __('Portrait'); ?></label>
				</p>
				<p class="field">
					<input value="landscape" id="search_format_landscape" type="radio" name="search_options[format]">
					<label for="search_format_landscape"><?php echo __('Paysage'); ?></label>

					<input value="panorama" id="search_format_panorama" type="radio" name="search_options[format]">
					<label for="search_format_panorama"><?php echo __('Panorama'); ?></label>
				</p>
			</fieldset>
			<fieldset>
				<legend><?php echo __('Date'); ?></legend>
				<p class="field">
					<input id="search_date" type="checkbox" name="search_options[date]">
					<label for="search_date"><?php echo __('Rechercher par date :'); ?></label>
				</p>
				<div class="field_sublvl">
					<p class="field">
						<input checked id="search_date_column_pubdt" type="radio" name="search_options[date_column]" value="pubdt">
						<label for="search_date_column_pubdt"><?php echo __('Date de publication'); ?></label>

						<input id="search_date_column_crtdt" type="radio" name="search_options[date_column]" value="crtdt">
						<label for="search_date_column_crtdt"><?php echo __('Date de création'); ?></label>
					</p>
					<p class="field" id="search_date_start">
						<label for="date_start_year"><?php echo __('du'); ?></label>
						&nbsp;
						<input id="date_start_year" name="search_options[date_start_year]" class="dt_year" type="number" min="1900" max="3000" placeholder="<?php echo __('Année'); ?>" value="">
						<span>-</span>
						<input name="search_options[date_start_month]" class="dt_month" type="number" min="1" max="12" placeholder="<?php echo __('Mois'); ?>" value="">
						<span>-</span>
						<input name="search_options[date_start_day]" class="dt_day" type="number" min="1" max="31" placeholder="<?php echo __('Jour'); ?>" value="">
						<a href="javascript:;" class="dt_now" title="<?php echo __('Insérer la date d\'aujourd\'hui'); ?>">&#xe954;</a>
					</p>
					<p class="field" id="search_date_end">
						<label for="date_end_year"><?php echo __('au'); ?></label>
						&nbsp;
						<input id="date_end_year" name="search_options[date_end_year]" class="dt_year" type="number" min="1900" max="3000" placeholder="<?php echo __('Année'); ?>" value="">
						<span>-</span>
						<input name="search_options[date_end_month]" class="dt_month" type="number" min="1" max="12" placeholder="<?php echo __('Mois'); ?>" value="">
						<span>-</span>
						<input name="search_options[date_end_day]" class="dt_day" type="number" min="1" max="31" placeholder="<?php echo __('Jour'); ?>" value="">
						<a href="javascript:;" class="dt_now" title="<?php echo __('Insérer la date d\'aujourd\'hui'); ?>">&#xe954;</a>
					</p>
				</div>
			</fieldset>
		</div>
		<div>
			<fieldset>
				<legend><?php echo __('Poids'); ?></legend>
				<p class="field">
					<input id="search_filesize" type="checkbox" name="search_options[filesize]">
					<label for="search_filesize"><?php echo __('Rechercher par poids :'); ?></label>
				</p>
				<div class="field_sublvl">
					<p class="field">
						<label for="search_filesize_start"><?php echo __('Entre'); ?></label>
						&nbsp;
						<input id="search_filesize_start" name="search_options[filesize_start]" type="text" size="6" maxlength="6">
						&nbsp;
						<label for="search_filesize_end"><?php echo __('et'); ?></label>
						&nbsp;
						<input id="search_filesize_end" name="search_options[filesize_end]" type="text" size="6" maxlength="6">
						&nbsp;
						<select name="search_options[filesize_unit]">
<?php foreach ($tpl['search_options']['filesize_unit'] as $i) : ?>
							<option<?php echo $i['selected'] ? ' selected' : ''; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
						</select>
					</p>
				</div>
			</fieldset>
			<fieldset>
				<legend><?php echo __('Dimensions'); ?></legend>
				<p class="field">
					<input id="search_size" type="checkbox" name="search_options[size]">
					<label for="search_size"><?php echo __('Rechercher par dimensions :'); ?></label>
				</p>
				<div class="field_sublvl">
					<p class="field">
						<?php echo __('Largeur :'); ?>
						<br>
						<label for="search_width_start"><?php echo __('Entre'); ?></label>
						&nbsp;
						<input id="search_width_start" name="search_options[size_width_start]" type="text" size="5" maxlength="5">
						&nbsp;
						<label for="search_width_end"><?php echo __('et'); ?></label>
						&nbsp;
						<input id="search_width_end" name="search_options[size_width_end]" type="text" size="5" maxlength="5">
						&nbsp;
						<?php echo __('pixels'); ?>
					</p>
					<p class="field">
						<?php echo __('Hauteur :'); ?>
						<br>
						<label for="search_height_start"><?php echo __('Entre'); ?></label>
						&nbsp;
						<input id="search_height_start" name="search_options[size_height_start]" type="text" size="5" maxlength="5">
						&nbsp;
						<label for="search_height_end"><?php echo __('et'); ?></label>
						&nbsp;
						<input id="search_height_end" name="search_options[size_height_end]" type="text" size="5" maxlength="5">
						&nbsp;
						<?php echo __('pixels'); ?>
					</p>
				</div>
			</fieldset>
		</div>
	</div>
<?php if ($_GET['section'] != 'search-advanced') : ?>
	<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
	document.getElementById('search_options').style = 'display:none';
	</script>
<?php endif; ?>
<?php endif; ?>
	<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
	<input class="button" name="search" type="submit" value="<?php echo __('Chercher'); ?>">
	<input class="button" type="reset" value="<?php echo __('Réinitialiser'); ?>">
</form>