<h3 class="icon"><?php echo __('Changer d\'avatar'); ?></h3>

<?php include(__DIR__ . '/report.tpl.php'); ?>

<div id="member_page_edit_avatar">
	<img src="<?php echo $tpl['member']['avatar']['url']; ?>" alt="<?php echo sprintf(__('Avatar de %s'), $tpl['member']['nickname']); ?>">

	<form id="member_page_edit" action="<?php echo $tpl['current_url']; ?>" method="post" enctype="multipart/form-data">
		<h4><?php echo __('Nouvel avatar'); ?></h4>
		<p class="field">
			<input autofocus required data-maxsize="<?php echo $tpl['upload']['maxfilesize']; ?>" id="file" name="change" size="35" maxlength="2048" type="file"
				accept="<?php echo implode(',', $tpl['upload']['filetypes']); ?>">
			<label for="file" class="button_file"><?php echo __('Sélectionner un fichier.'); ?></label>
		</p>
		<p class="field">
			<?php echo nl2br($tpl['upload']['text_limits']); ?>
		</p>
		<input name="MAX_FILE_SIZE" value="<?php echo $tpl['upload']['maxfilesize']; ?>" type="hidden">
		<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
		<input name="action" value="change" type="hidden">
		<input class="button" type="submit" value="<?php echo __('Envoyer'); ?>">
		<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
		var maxsize_text = "<?php echo $tpl['php2js'](__('Poids du fichier trop grand.')); ?>";
		</script>
	</form>

<?php if ($tpl['member']['avatar']['status']) : ?>
	<form data-confirm-delete="1" action="<?php echo $tpl['current_url_pageless']; ?>" method="post">
		<h4><?php echo __('Suppression'); ?></h4>
		<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
		var confirm_delete = "<?php echo $tpl['php2js'](__('Supprimer l\'avatar ?')); ?>";
		</script>
		<p class="field">
			<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
			<input name="action" value="delete" type="hidden">
			<input class="button" type="submit" value="<?php echo __('Supprimer l\'avatar'); ?>">
		</p>
	</form>
<?php endif; ?>

</div>