<form id="upload_form" action="<?php echo $tpl['current_url_pageless']; ?>" method="post">
	<h3 class="icon"><?php echo __('Ajouter des fichiers'); ?></h3>

<?php include(__DIR__ . '/report.tpl.php'); ?>

	<p id="list_categories_msg">
		<label for="list_categories_1"><?php echo __('Choisissez l\'album dans lequel vous souhaitez envoyer des fichiers :'); ?></label>
	</p>
	<div id="list_categories"></div>
	<p class="message_info" id="select_path"><?php echo __('Aucun album sélectionné.'); ?></p>

	<div id="upload">
		<div id="upload_list">
			<p id="upload_startmsg"><?php echo __('Déposez vos fichiers ici.'); ?></p>
		</div>
		<div id="upload_infos">
			<p id="upload_infos_total">
				<span><?php echo __('Liste :'); ?></span>
				<span id="upload_infos_files"></span>
				-
				<span id="upload_infos_filesize"></span>
			</p>
			<p>
				<span><?php echo __('Envoyé :'); ?></span>
				<span id="upload_infos_progress_pc">0%</span>
			</p>
		</div>
		<p class="upload_limits"><?php printf(__('Types de fichiers acceptés : %s.'), $tpl['upload']['text_types']); ?></p>
		<p class="upload_limits"><?php echo $tpl['upload']['text_limits']; ?></p>
<?php if ($tpl['upload']['validation']) : ?>
		<p class="message_info"><?php echo __('Vos fichiers n\'apparaîtront dans la galerie qu\'après validation par un administrateur.'); ?></p>
<?php endif; ?>
		<div id="upload_buttons">
			<input type="file" id="upload_input_file" multiple accept="<?php echo implode(',', $tpl['upload']['filetypes']); ?>">
			<input disabled type="button" class="button" id="upload_add" value="<?php echo __('Sélectionner des fichiers'); ?>">
			<input disabled type="button" class="button" id="upload_clear" value="<?php echo __('Vider la liste'); ?>">
			<input disabled type="button" class="button" id="upload_start" value="<?php echo __('Envoyer'); ?>">
		</div>
		<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
		var cat_list = <?php echo json_encode($tpl['upload']['albums_list']); ?>;
		var cat_separator = ' / ';
		var cat_text =
		{
			none: "<?php echo $tpl['php2js'](__('Aucun album sélectionné.')); ?>",
			select: "<?php echo $tpl['php2js'](__('Sélectionnez un album')); ?>",
		};
		var upload_options =
		{
			ajaxData:
			{
				anticsrf: '<?php echo $tpl['anticsrf'](); ?>',
				from_admin: 0,
				section: 'upload',
				temp_dir: '<?php echo $tpl['upload']['temp_dir']; ?>'
			},
			ajaxScript: '<?php echo $tpl['gallery']['path']; ?>/ajax.php',
			fileExts: <?php echo $tpl['php2js']($tpl['upload']['fileexts']); ?>,
			fileTypes: <?php echo $tpl['php2js']($tpl['upload']['filetypes']); ?>,
			maxFileSize: <?php echo $tpl['config']('upload_maxfilesize') * 1024 * 1024; ?>,
			maxHeight: <?php echo $tpl['config']('upload_maxheight'); ?>,
			maxTotalFiles: <?php echo $tpl['config']('upload_maxtotalfiles'); ?>,
			maxTotalSize: <?php echo $tpl['upload_totalsize'](); ?>,
			maxWidth: <?php echo $tpl['config']('upload_maxwidth'); ?>,
			sliceSize: <?php echo $tpl['upload_slicesize'](); ?>,
			text:
			{
				decimalSeparator: "<?php echo $tpl['php2js'](__(',')); ?>",
				failed: "<?php echo $tpl['php2js'](__('Échec de l\'envoi du fichier.')); ?>",
				files: "<?php echo $tpl['php2js'](__('%s fichiers')); ?>",
				sizeUnits: [
					"<?php echo $tpl['php2js'](__('%s octets')); ?>",
					"<?php echo $tpl['php2js'](__('%s Ko')); ?>",
					"<?php echo $tpl['php2js'](__('%s Mo')); ?>",
					"<?php echo $tpl['php2js'](__('%s Go')); ?>"
				],
				success: "<?php echo $tpl['php2js'](__('Envoi effectué.')); ?>",
				warning:
				{
					filename: "<?php echo $tpl['php2js'](__('Nom de fichier incorrect.')); ?>",
					fileread: "<?php echo $tpl['php2js'](__('Impossible de lire le fichier.')); ?>",
					filesize: "<?php echo $tpl['php2js'](__('Poids du fichier trop grand.')); ?>",
					filetype: "<?php echo $tpl['php2js'](__('Type de fichier non valide.')); ?>",
					imagesize: "<?php echo $tpl['php2js'](__('Dimensions trop grandes.')); ?>",
					imagevalid: "<?php echo $tpl['php2js'](__('Image non valide.')); ?>",
					totalfiles: "<?php echo $tpl['php2js'](__('Nombre maximum de fichiers atteint.')); ?>",
					totalsize: "<?php echo $tpl['php2js'](__('Poids maximum atteint.')); ?>"
				}
			}
		};
		</script>
		<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
		<input name="cat_id" type="hidden" value="<?php echo $_GET['album_id'] ?? 1; ?>">
		<input name="temp_dir" type="hidden" value="<?php echo $tpl['upload']['temp_dir']; ?>">
		<input name="upload" type="hidden" value="1">
	</div>
</form>