<div id="obj_grid" data-section="categories">
<?php include('grid_container.tpl.php'); ?>

	<div id="obj_panel">
		<div>
			<ul id="obj_panel_menu">
				<li data-select="1" class="current"><a href="javascript:;"><?php echo __('Informations'); ?></a></li>
				<li data-select="1"><a href="javascript:;"><?php echo __('Modifications'); ?></a></li>
				<li data-select="2"><a href="javascript:;"><?php echo __('Sélection'); ?><span>(0)</span></a></li>
			</ul>
			<a id="obj_panel_extend" data-l10n-extend="<?php echo __('Agrandir'); ?>" data-l10n-reduce="<?php echo __('Réduire'); ?>" title="<?php echo __('Agrandir'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/extend.png"></a>
			<div id="obj_panel_infos">
				<ul class="obj_panel_submenu">
					<li class="current"><a title="<?php echo __('Statistiques'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/stats.png"></a></li>
					<li id="obj_panel_submenu_password"><a title="<?php echo __('Mot de passe'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/key.png"></a></li>
				</ul>
				<div class="obj_panel_content" id="obj_panel_stats">
					<h4><?php echo __('Statistiques'); ?></h4>
					<div>
						<p id="obj_panel_stats_type"><?php echo __('Type :'); ?> <span></span></p>
						<p id="obj_panel_stats_files"><?php echo __('Nombre de fichiers :'); ?> <span></span></p>
						<p id="obj_panel_stats_subcats"><?php echo __('Nombre de sous-catégories :'); ?> <span></span></p>
						<br>
						<table class="light">
							<tr><th></th><th class="title"><?php echo __('Activé'); ?></th><th class="title"><?php echo __('Désactivé'); ?></th><th class="title"><?php echo __('Total'); ?></th></tr>
							<tr><td><?php echo __('Poids'); ?></td><td class="num a_filesize"></td><td class="num d_filesize"></td><td class="num t_filesize"></td></tr>
							<tr><td><?php echo __('Albums'); ?></td><td class="num a_albums"></td><td class="num d_albums"></td><td class="num t_albums"></td></tr>
							<tr><td><?php echo __('Photos'); ?></td><td class="num a_images"></td><td class="num d_images"></td><td class="num t_images"></td></tr>
							<tr><td><?php echo __('Vidéos'); ?></td><td class="num a_videos"></td><td class="num d_videos"></td><td class="num t_videos"></td></tr>
							<tr><td><?php echo __('Vues'); ?></td><td class="num a_hits"></td><td class="num d_hits"></td><td class="num t_hits"></td></tr>
							<tr><td><?php echo __('Favoris'); ?></td><td class="num a_favorites"></td><td class="num d_favorites"></td><td class="num t_favorites"></td></tr>
							<tr><td><?php echo __('Commentaires'); ?></td><td class="num a_comments"></td><td class="num d_comments"></td><td class="num t_comments"></td></tr>
							<tr><td><?php echo __('Votes'); ?></td><td class="num a_votes"></td><td class="num d_votes"></td><td class="num t_votes"></td></tr>
							<tr><td><?php echo __('Note moyenne'); ?></td><td class="num a_rating"></td><td class="num d_rating"></td><td class="num t_rating"></td></tr>
						</table>
						<br>
						<p id="obj_panel_stats_crtdt"><?php echo __('Date de création :'); ?> <span></span></p>
						<p id="obj_panel_stats_user"><?php echo __('Propriétaire :'); ?> <span></span></p>
					</div>
				</div>
				<div class="obj_panel_content" id="obj_panel_infos_password">
					<h4><?php echo __('Mot de passe'); ?></h4>
					<p></p>
				</div>
			</div>
			<div id="obj_panel_one">
				<ul class="obj_panel_submenu">
					<li class="current"><a title="<?php echo __('Général'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/document.png"></a></li>
					<li><a title="<?php echo __('Édition'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/edit.png"></a></li>
					<li><a title="<?php echo __('Mot de passe'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/key.png"></a></li>
					<li><a title="<?php echo __('Réglages'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/settings.png"></a></li>
					<li><a title="<?php echo __('Vignette'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/thumb.png"></a></li>
					<li><a title="<?php echo __('Géolocalisation'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/marker.png"></a></li>
					<li><a title="<?php echo __('Suppression'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/delete.png"></a></li>
				</ul>
				<div class="obj_panel_content" id="obj_panel_general">
					<h4><?php echo __('Général'); ?></h4>
					<form method="post">
						<p class="field">
							<label for="edit_status"><?php echo __('État :'); ?></label><br>
							<select id="edit_status" class="focus">
								<option value="1"><?php echo __('Activé'); ?></option>
								<option value="0"><?php echo __('Désactivé'); ?></option>
							</select>
						</p>
						<p class="field">
							<input id="edit_reset_item_pubdt" type="checkbox">
							<label for="edit_reset_item_pubdt"><?php echo __('Réinitialiser la date de publication des fichiers'); ?></label>
						</p>
						<p class="field">
							<label for="edit_category_parent"><?php echo __('Catégorie parente :'); ?></label><br>
							<select id="edit_category_parent"></select>
							<a data-box-title="<?php echo __('Déplacer vers...'); ?>" data-box-list="categories" href="javascript:;" title="<?php echo __('Liste des catégories'); ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a>
						</p>
						<p class="field">
							<label for="edit_owner"><?php echo __('Propriétaire :'); ?></label><br>
							<select id="edit_owner" data-help-icon="category_owner">
<?php foreach ($tpl['users'] as &$i) : ?>
								<option value="<?php echo $i['id']; ?>"><?php echo $i['nickname']; ?></option>
<?php endforeach; ?>
							</select>
						</p>
						<p class="field">
							<?php echo __('Vues :'); ?><br>
							<input id="edit_reset_hits" type="checkbox">
							<label for="edit_reset_hits"><?php echo __('Nombre de vues à zéro pour tous les fichiers'); ?></span>
						</p>
						<input type="submit" value="<?php echo __('Enregistrer'); ?>">
					</form>
				</div>
				<div class="obj_panel_content" id="obj_panel_edit">
					<h4><?php echo __('Édition'); ?></h4>
					<form method="post">
						<p class="field">
							<label for="edit_title"><?php echo __('Titre :'); ?></label>
							<input required class="large focus" size="40" maxlength="255" id="edit_title" type="text">
						</p>
						<p class="field">
							<label for="edit_urlname"><?php echo __('URL :'); ?></label>
							<input required class="large" size="40" maxlength="255" id="edit_urlname" type="text">
						</p>
						<p class="field">
							<label for="edit_dirname"><?php echo __('Nom de répertoire :'); ?></label>
							<input required class="large" size="40" maxlength="255" id="edit_dirname" type="text">
						</p>
						<p class="field">
							<label for="edit_desc"><?php echo __('Description :'); ?></label>
							<span class="html_outer">
								<span class="html_inner">
									<textarea class="large" rows="6" cols="50" id="edit_desc"></textarea>
									<span>HTML</span>
								</span>
							</span>
						</p>
						<input type="submit" value="<?php echo __('Enregistrer'); ?>">
					</form>
				</div>
				<div class="obj_panel_content" id="obj_panel_password">
					<h4><?php echo __('Mot de passe'); ?></h4>
					<form method="post">
						<p class="field">
							<label for="edit_password"><?php echo __('Mot de passe :'); ?></label>
							<input size="40" maxlength="1024" id="edit_password" type="password" class="large focus">
						</p>
						<input type="submit" value="<?php echo __('Enregistrer'); ?>">
					</form>
				</div>
				<div class="obj_panel_content" id="obj_panel_settings">
					<h4><?php echo __('Réglages'); ?></h4>
					<form method="post">
						<p class="field"><?php echo __('Permissions :'); ?></p>
						<p class="field">
							<input class="focus" id="edit_allow_comments" type="checkbox">
							<label for="edit_allow_comments"><?php echo __('Autoriser les commentaires'); ?></span>
						</p>
						<p class="field">
							<input id="edit_allow_votes" type="checkbox">
							<label for="edit_allow_votes"><?php echo __('Autoriser les votes'); ?></span>
						</p>
						<p class="field">
							<input id="edit_allow_download" type="checkbox">
							<label for="edit_allow_download"><?php echo __('Autoriser le téléchargement des fichiers'); ?></span>
						</p>
						<p class="field">
							<input id="edit_allow_upload" type="checkbox">
							<label for="edit_allow_upload"><?php echo __('Autoriser l\'ajout de fichiers'); ?></span>
						</p>
						<p class="field">
							<input id="edit_allow_create" type="checkbox">
							<label for="edit_allow_create"><?php echo __('Autoriser la création d\'albums'); ?></span>
						</p>
						<div id="edit_sort_album">
							<p class="field">
								<label><?php echo __('Ordre d\'affichage des fichiers :'); ?></label>
							</p>
<?php for ($n = 1; $n <= 3; $n++) : ?>
							<p class="field">
								<label for="edit_album_sortby_<?php echo $n; ?>"><?php printf(__('Critère n°%s :'), $n); ?></label>
								<select id="edit_album_sortby_<?php echo $n; ?>">
<?php foreach ($tpl['sortby_album'] as &$s) : ?>
<?php if ($s['value'] == 'default' && $n > 1) continue; ?>
									<option value="<?php echo $s['value']; ?>"><?php echo $s['text']; ?></option>
<?php endforeach; ?>
								</select>
								<select id="edit_album_orderby_<?php echo $n; ?>">
<?php foreach ($tpl['orderby'] as &$o) : ?>
									<option value="<?php echo $o['value']; ?>"><?php echo $o['text']; ?></option>
<?php endforeach; ?>
								</select>
							</p>
<?php endfor; ?>
						</div>
						<div id="edit_sort_category">
							<p class="field">
								<label><?php echo __('Ordre d\'affichage des catégories :'); ?></label>
							</p>
<?php for ($n = 1; $n <= 3; $n++) : ?>
							<p class="field">
								<label for="edit_category_sortby_<?php echo $n; ?>"><?php printf(__('Critère n°%s :'), $n); ?></label>
								<select id="edit_category_sortby_<?php echo $n; ?>" >
<?php foreach ($tpl['sortby_category'] as &$s) : ?>
<?php if ($s['value'] == 'default' && $n > 1) continue; ?>
									<option value="<?php echo $s['value']; ?>"><?php echo $s['text']; ?></option>
<?php endforeach; ?>
								</select>
								<select id="edit_category_orderby_<?php echo $n; ?>">
<?php foreach ($tpl['orderby'] as &$o) : ?>
									<option value="<?php echo $o['value']; ?>"><?php echo $o['text']; ?></option>
<?php endforeach; ?>
								</select>
							</p>
<?php endfor; ?>
						</div>
						<input type="submit" value="<?php echo __('Enregistrer'); ?>">
					</form>
				</div>
				<div class="obj_panel_content" id="obj_panel_thumb">
					<h4><?php echo __('Vignette'); ?></h4>
					<form method="post">
						<p class="field">
							<label for="edit_thumb_new"><?php echo __('Choisir une nouvelle vignette :'); ?></label><br>
							<select id="edit_thumb_new" class="focus">
								<option value="random"><?php echo __('Au hasard'); ?></option>
								<option value="last"><?php echo __('Dernier fichier ajouté'); ?></option>
								<option value="first"><?php echo __('Premier fichier ajouté'); ?></option>
							</select>
						</p>
						<p class="field">
							<input id="edit_thumb_new_subcats" type="checkbox">
							<label for="edit_thumb_new_subcats"><?php echo __('Aussi pour les sous-catégories'); ?></span>
						</p>
						<input type="submit" value="<?php echo __('Enregistrer'); ?>">
					</form>
				</div>
				<div class="obj_panel_content" id="obj_panel_map">
					<h4><?php echo __('Géolocalisation'); ?></h4>
					<form method="post" id="geolocation_form">
						<div id="geolocation_worldmap"
							data-layer="<?php echo $tpl['geolocation']['layer']; ?>"
							data-lat="<?php echo $tpl['geolocation']['lat']; ?>"
							data-long="<?php echo $tpl['geolocation']['long']; ?>"
							data-marker="0"
							data-zoom="<?php echo $tpl['geolocation']['zoom']; ?>">
						</div>
						<span id="geolocation_marker" class="icon icon_marker_add"><a class="js" href="javascript:;"><?php echo __('Ajouter le marqueur'); ?></a></span>
						<span id="geolocation_reload" class="icon icon_map"><a class="js" href="javascript:;"><?php echo __('Recharger la carte'); ?></a></span>
						<p class="field">
							<label for="geolocation_cat_coords"><?php echo __('Utiliser les coordonnées de cette catégorie :'); ?></label><br>
							<select id="geolocation_cat_coords" name="category">
								<option value="0" data-lat="" data-long="">---</option>
							</select>
						</p>
						<p class="field">
							<label for="geolocation_latitude"><?php echo __('Latitude :'); ?></label>
							<input class="large focus" size="30" maxlength="99" id="geolocation_latitude" type="text">
						</p>
						<p class="field">
							<label for="geolocation_longitude"><?php echo __('Longitude :'); ?></label>
							<input class="large" size="30" maxlength="99" id="geolocation_longitude" type="text">
						</p>
						<input type="submit" value="<?php echo __('Enregistrer'); ?>">
					</form>
				</div>
				<div class="obj_panel_content" id="obj_panel_delete">
					<h4><?php echo __('Suppression'); ?></h4>
					<form method="post">
						<div class="report_classic">
							<div class="report_msg report_info"><p><?php echo __('Cette action supprimera de façon définitive l\'album ou la catégorie, toutes les sous-catégories et tous les fichiers qui s\'y trouvent, ainsi que tous les commentaires et votes liés à ces fichiers.'); ?></p></div>
						</div>
						<input class="focus" type="submit" value="<?php echo __('Supprimer la catégorie'); ?>">
					</form>
				</div>
			</div>
			<div id="obj_panel_group">
				<ul class="obj_panel_submenu">
					<li class="current"><a title="<?php echo __('État'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/status.png"></a></li>
					<li><a title="<?php echo __('Déplacement'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/move.png"></a></li>
					<li><a title="<?php echo __('Propriétaire'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/user.png"></a></li>
					<li><a title="<?php echo __('Vues'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/eye.png"></a></li>
					<li><a title="<?php echo __('Vignette'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/thumb.png"></a></li>
					<li><a title="<?php echo __('Édition'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/edit.png"></a></li>
					<li><a title="<?php echo __('Géolocalisation'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/marker.png"></a></li>
					<li><a title="<?php echo __('Suppression'); ?>" href="javascript:;"><img src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/delete.png"></a></li>
				</ul>
				<div class="obj_panel_content" id="obj_panel_group_status">
					<h4><?php echo __('État'); ?></h4>
					<form method="post">
						<p class="field">
							<label for="group_status"><?php echo __('Changer d\'état :'); ?></label><br>
							<select id="group_status" class="focus">
								<option value="1"><?php echo __('Activer'); ?></option>
								<option value="2"><?php echo __('Activer et réinitialiser la date de publication des fichiers'); ?></option>
								<option value="0"><?php echo __('Désactiver'); ?></option>
							</select>
						</p>
						<input type="submit" value="<?php echo __('Enregistrer'); ?>">
					</form>
				</div>
				<div class="obj_panel_content" id="obj_panel_group_move">
					<h4><?php echo __('Déplacement'); ?></h4>
					<form method="post">
						<p class="field">
							<label for="group_move"><?php echo __('Déplacer vers :'); ?></label><br>
							<select id="group_move" class="focus">
<?php if (isset($_GET['filter'])) : ?>
								<?php foreach ($tpl['categories_move'] as &$i) : ?><?php if ($i['node'] == 'content' && $i['type'] == 'category') : ?><option id="o<?php echo $i['level'] > 1 ? '' : 'v'; echo ($i['subcats'] || $i['id'] == 1) ? 's' : ''; echo $i['password'] ? 'p' : ''; ?>:<?php echo $i['level']; ?>{<?php echo $i['id']; ?>}<?php echo $i['parents']; ?>" value="<?php echo $i['id']; ?>"><?php echo str_repeat(' ', $i['level'] * 4); ?><?php echo $i['title']; ?></option><?php endif; ?><?php endforeach; ?>
<?php endif; ?>
							</select>
							<a data-box-title="<?php echo __('Déplacer vers...'); ?>" data-box-list="categories" href="javascript:;" title="<?php echo __('Liste des catégories'); ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a>
						</p>
						<input type="submit" value="<?php echo __('Enregistrer'); ?>">
					</form>
				</div>
				<div class="obj_panel_content" id="obj_panel_group_owner">
					<div class="obj_panel_help_icon"><p data-help-icon="category_owner"></p></div>
					<h4><?php echo __('Propriétaire'); ?></h4>
					<form method="post">
						<p class="field">
							<label for="group_owner"><?php echo __('Nouveau propriétaire :'); ?></label><br>
							<select id="group_owner" class="focus">
<?php foreach ($tpl['users'] as &$i) : ?>
								<option value="<?php echo $i['id']; ?>"><?php echo $i['nickname']; ?></option>
<?php endforeach; ?>
							</select>
						</p>
						<input type="submit" value="<?php echo __('Enregistrer'); ?>">
					</form>
				</div>
				<div class="obj_panel_content" id="obj_panel_group_views">
					<h4><?php echo __('Vues'); ?></h4>
					<form method="post">
						<p class="field">
							<input id="group_reset_hits" type="checkbox">
							<label for="group_reset_hits"><?php echo __('Nombre de vues à zéro pour tous les fichiers'); ?></span>
						</p>
						<input type="submit" value="<?php echo __('Enregistrer'); ?>">
					</form>
				</div>
				<div class="obj_panel_content" id="obj_panel_group_thumb">
					<h4><?php echo __('Vignette'); ?></h4>
					<form method="post">
						<p class="field">
							<label for="group_thumb_new"><?php echo __('Choisir une nouvelle vignette :'); ?></label><br>
							<select id="group_thumb_new" class="focus">
								<option value="random"><?php echo __('Au hasard'); ?></option>
								<option value="last"><?php echo __('Dernier fichier ajouté'); ?></option>
								<option value="first"><?php echo __('Premier fichier ajouté'); ?></option>
							</select>
						</p>
						<p class="field">
							<input id="group_thumb_new_subcats" type="checkbox">
							<label for="group_thumb_new_subcats"><?php echo __('Aussi pour les sous-catégories'); ?></span>
						</p>
						<input type="submit" value="<?php echo __('Enregistrer'); ?>">
					</form>
				</div>
				<div class="obj_panel_content" id="obj_panel_group_edit">
					<div class="obj_panel_help_icon"><p data-help-icon="mass_edit"></p></div>
					<h4><?php echo __('Édition en masse'); ?></h4>
					<form method="post">
						<p class="field">
							<label for="group_edit_title"><?php echo __('Titre :'); ?></label>
							<input class="large focus" size="40" maxlength="255" id="group_edit_title" type="text" value="{TITLE}">
						</p>
						<p class="field">
							<label for="group_edit_urlname"><?php echo __('URL :'); ?></label>
							<input class="large" size="40" maxlength="255" id="group_edit_urlname" type="text" value="{URL}">
						</p>
						<p class="field">
							<label for="group_edit_dirname"><?php echo __('Nom de répertoire :'); ?></label>
							<input class="large" size="40" maxlength="255" id="group_edit_dirname" type="text" value="{DIRNAME}">
						</p>
						<p class="field">
							<label for="group_edit_desc"><?php echo __('Description :'); ?></label>
							<span class="html_outer">
								<span class="html_inner">
									<textarea class="large" rows="6" cols="50" id="group_edit_desc">{DESCRIPTION}</textarea>
									<span>HTML</span>
								</span>
							</span>
						</p>
						<input type="submit" value="<?php echo __('Enregistrer'); ?>">
						<input type="reset" value="<?php echo __('Réinitialiser'); ?>">
					</form>
				</div>
				<div class="obj_panel_content" id="obj_panel_group_map">
					<h4><?php echo __('Géolocalisation'); ?></h4>
					<form method="post" id="group_geolocation_form">
						<div id="group_geolocation_worldmap"
							data-layer="<?php echo $tpl['geolocation']['layer']; ?>"
							data-lat="<?php echo $tpl['geolocation']['lat']; ?>"
							data-long="<?php echo $tpl['geolocation']['long']; ?>"
							data-marker="0"
							data-zoom="<?php echo $tpl['geolocation']['zoom']; ?>">
						</div>
						<span id="group_geolocation_marker" class="icon icon_marker_add"><a class="js" href="javascript:;"><?php echo __('Ajouter le marqueur'); ?></a></span>
						<span id="group_geolocation_reload" class="icon icon_map"><a class="js" href="javascript:;"><?php echo __('Recharger la carte'); ?></a></span>
						<p class="field">
							<label for="group_geolocation_cat_coords"><?php echo __('Utiliser les coordonnées de cette catégorie :'); ?></label><br>
							<select id="group_geolocation_cat_coords" name="category">
								<option value="0" data-lat="" data-long="">---</option>
							</select>
						</p>
						<p class="field">
							<label for="group_geolocation_latitude"><?php echo __('Latitude :'); ?></label>
							<input class="large focus" size="30" maxlength="99" id="group_geolocation_latitude" type="text">
						</p>
						<p class="field">
							<label for="group_geolocation_longitude"><?php echo __('Longitude :'); ?></label>
							<input class="large" size="30" maxlength="99" id="group_geolocation_longitude" type="text">
						</p>
						<input type="submit" value="<?php echo __('Enregistrer'); ?>">
					</form>
				</div>
				<div class="obj_panel_content" id="obj_panel_group_delete">
					<h4><?php echo __('Suppression'); ?></h4>
					<form method="post">
						<div class="report_classic">
							<div class="report_msg report_info"><p><?php echo __('Cette action supprimera de façon définitive les albums ou catégories sélectionnés, toutes leurs sous-catégories et tous les fichiers qui s\'y trouvent, ainsi que tous les commentaires et votes liés à ces fichiers.'); ?></p></div>
						</div>
						<input class="focus" type="submit" value="<?php echo __('Supprimer les catégories'); ?>">
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
<div id="obj_grid_noresult">
	<br>
	<div class="report_classic">
		<div class="report_msg report_info">
			<p><?php echo __('Aucune catégorie trouvée.'); ?></p>
		</div>
	</div>
</div>
<div id="obj_grid_noitem">
	<br>
	<div class="report_classic">
		<div class="report_msg report_info">
			<p><?php echo __('La catégorie ne contient aucun élément.'); ?></p>
		</div>
	</div>
</div>
<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
var category_empty_thumb = "<?php echo $tpl['admin']['style']['path']; ?>/cat-empty.png";
var l10n_confirm_delete_album = "<?php echo $tpl['php2js'](__('Supprimer l\'album et tous les fichiers qu\'il contient ?')); ?>";
var l10n_confirm_delete_category = "<?php echo $tpl['php2js'](__('Supprimer la catégorie et tous les fichiers qu\'elle contient ?')); ?>";
var l10n_confirm_group_delete = "<?php echo $tpl['php2js'](__('Supprimer les albums ou catégories sélectionnés et tous les fichiers qui s\'y trouvent ?')); ?>";
var l10n_delete_album = "<?php echo $tpl['php2js'](__('Supprimer l\'album')); ?>";
var l10n_delete_category = "<?php echo $tpl['php2js'](__('Supprimer la catégorie')); ?>";
var l10n_gallery_link = "<?php echo $tpl['php2js'](__('Voir dans la galerie')); ?>";
var l10n_password = "<?php echo $tpl['php2js'](__('Mot de passe :')); ?>";
var l10n_password_album = "<?php echo $tpl['php2js'](__('L\'accès à cet album est protégé par un mot de passe.')); ?>";
var l10n_password_category = "<?php echo $tpl['php2js'](__('L\'accès à cette catégorie est protégé par un mot de passe.')); ?>";
var l10n_password_required = "<?php echo $tpl['php2js'](__('Mot de passe (obligatoire) :')); ?>";
var l10n_password_parent_album = "<?php echo $tpl['php2js'](__('L\'accès à cet album est protégé par un mot de passe qui a été placé sur la catégorie %s.')); ?>";
var l10n_password_parent_category = "<?php echo $tpl['php2js'](__('L\'accès à cette catégorie est protégé par un mot de passe qui a été placé sur la catégorie %s.')); ?>";
</script>