<?php
declare(strict_types = 1);

class_exists('DB') || die;

require_once(__DIR__ . '/classes/AdminItems.class.php');

template:
{
	AdminItems::tplSection('item_replace');
}

update:
{
	Admin::displayOptions('album');

	AdminItems::replace();
}

get_data:
{
	AdminItems::getInfos();

	AdminItems::getBrowseItems();

	$text_limits = $text_limits_classic = sprintf(
		__('Formats acceptés : %s.'),
		strtoupper(explode('/', Template::$data['item']['type_mime'])[1])
	);
	$text_limits .= ' ' . sprintf(
		__('Poids maximum : %s.'),
		L10N::formatFilesize(Config::$params['upload_maxfilesize'] * 1024 * 1024)
	);
	$text_limits_classic .= ' ' . sprintf(
		__('Poids maximum : %s.'),
		L10N::formatFilesize(Utility::getUploadMaxFilesize())
	);
	if (Template::$data['item']['type'] == 'image')
	{
		$text_limits .= ' ' . sprintf(
			__('Dimensions maximum : %s x %s pixels.'),
			Config::$params['upload_maxwidth'],
			Config::$params['upload_maxheight']
		);
	}
	Template::set('upload',
	[
		'album_id' => Template::$data['item']['cat_id'],
		'fileexts' => Item::MIME_EXT[Template::$data['item']['type_mime']],
		'filetypes' => [Template::$data['item']['type_mime']],
		'max_total_files' => 1,
		'temp_dir' => Security::keyHMAC(),
		'text_limits' => $text_limits,
		'text_limits_classic' => $text_limits_classic
	]);
}
?>