<?php
$features =
[
	'albums_download', 'browse', 'categories_stats', 'comments', 'diaporama',
	'exif', 'geolocation', 'iptc', 'items_recent', 'links', 'random_item', 'rss',
	'search', 'search_advanced', 'selection', 'tags', 'users', 'votes', 'xmp'
];
$not_available = FALSE;
foreach ($features as &$f)
{
	if (!in_array($f, THEME_FEATURES))
	{
		$not_available = TRUE;
		break;
	}
}
?>
<?php if ($not_available) : ?>
<div class="report_classic">
	<div class="report_msg report_info">
		<p><?php echo __('Certaines fonctionnalités ne sont pas disponibles avec le thème actuel.'); ?></p>
	</div>
</div>
<?php endif; ?>
<form id="features" action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="page">
	<div id="features_inner">
		<div<?php if ($tpl['config']['comments']) : ?> class="activated"<?php endif; ?> id="a-comments">
			<fieldset>
				<legend><?php echo __('Commentaires'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="comments">
					<input<?php if (!in_array('comments', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['comments']) : ?> checked<?php endif; ?> id="feature_comments" name="config[comments]" type="checkbox">
					<label for="feature_comments"><?php echo __('Activer les commentaires'); ?></label>
				</p>
				<p class="field field_sublvl">
					<a href="<?php echo $tpl['link']('comments-options'); ?>"><?php echo __('Options des commentaires'); ?></a>
				</p>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['diaporama']) : ?> class="activated"<?php endif; ?> id="a-diaporama">
			<fieldset>
				<legend><?php echo __('Diaporama'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="diaporama">
					<input<?php if (!in_array('diaporama', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['diaporama']) : ?> checked<?php endif; ?> id="feature_diaporama" name="config[diaporama]" type="checkbox">
					<label for="feature_diaporama"><?php echo __('Activer le diaporama'); ?></label>
				</p>
				<p class="field field_sublvl">
					<a href="<?php echo $tpl['link']('diaporama'); ?>"><?php echo __('Options du diaporama'); ?></a>
				</p>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['users']) : ?> class="activated"<?php endif; ?> id="a-users">
			<fieldset>
				<legend><?php echo __('Espace membres'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="users">
					<input<?php if (!in_array('users', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['users']) : ?> checked<?php endif; ?> id="feature_users" name="config[users]" type="checkbox">
					<label for="feature_users"><?php echo __('Activer l\'espace membres'); ?></label>
				</p>
				<p class="field field_sublvl">
					<a href="<?php echo $tpl['link']('users-options'); ?>"><?php echo __('Options des utilisateurs'); ?></a>
				</p>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['geolocation']) : ?> class="activated"<?php endif; ?> id="a-geolocation">
			<fieldset>
				<legend><?php echo __('Géolocalisation'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="geolocation">
					<input<?php if (!in_array('geolocation', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['geolocation']) : ?> checked<?php endif; ?> id="feature_geolocation" name="config[geolocation]" type="checkbox">
					<label for="feature_geolocation"><?php echo __('Activer la géolocalisation (avec OpenStreetMap)'); ?></label>
				</p>
				<div class="field_sublvl">
					<p class="field<?php if (!in_array('geolocation', THEME_FEATURES)) : ?> disabled<?php endif; ?>">
						<label for="feature_geolocation_default_layer"><?php echo __('Type de carte par défaut :'); ?></label>
						<select<?php if (!in_array('geolocation', THEME_FEATURES)) : ?> disabled<?php endif; ?> name="config[geolocation_default_layer]" id="feature_geolocation_default_layer">
							<option<?php if ($tpl['config']['geolocation_default_layer'] == 'map') : ?> selected<?php endif; ?> value="map"><?php echo __('Plan'); ?></option>
							<option<?php if ($tpl['config']['geolocation_default_layer'] == 'satellite') : ?> selected<?php endif; ?> value="satellite"><?php echo __('Satellite'); ?></option>
						</select>
					</p>
				</div>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['random_item']) : ?> class="activated"<?php endif; ?> id="a-random-item">
			<fieldset>
				<legend><?php echo __('Photo ou vidéo au hasard'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="random_item">
					<input<?php if (!in_array('random_item', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['random_item']) : ?> checked<?php endif; ?> id="feature_random_item" name="config[random_item]" type="checkbox">
					<label for="feature_random_item"><?php echo __('Afficher une vignette de photo ou de vidéo au hasard'); ?></label>
				</p>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['links']) : ?> class="activated"<?php endif; ?> id="a-links">
			<fieldset>
				<legend><?php echo __('Liens externes'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="links">
					<input<?php if (!in_array('links', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['links']) : ?> checked<?php endif; ?> id="feature_links" name="config[links]" type="checkbox">
					<label for="feature_links"><?php echo __('Afficher les liens'); ?></label>
				</p>
				<p class="field field_sublvl">
					<a href="<?php echo $tpl['link']('links'); ?>"><?php echo __('Paramètres des liens'); ?></a>
				</p>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['exif']) : ?> class="activated"<?php endif; ?> id="a-exif">
			<fieldset>
				<legend><?php echo __('Métadonnées EXIF'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="exif">
					<input<?php if (!in_array('exif', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['exif']) : ?> checked<?php endif; ?> id="feature_exif" name="config[exif]" type="checkbox">
					<label for="feature_exif"><?php echo __('Afficher les informations EXIF disponibles'); ?></label>
				</p>
				<div class="field_sublvl">
					<p class="field">
						<a href="<?php echo $tpl['link']('exif'); ?>"><?php echo __('Choix des informations à afficher'); ?></a>
					</p>
				</div>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['iptc']) : ?> class="activated"<?php endif; ?> id="a-iptc">
			<fieldset>
				<legend><?php echo __('Métadonnées IPTC'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="iptc">
					<input<?php if (!in_array('iptc', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['iptc']) : ?> checked<?php endif; ?> id="feature_iptc" name="config[iptc]" type="checkbox">
					<label for="feature_iptc"><?php echo __('Afficher les informations IPTC disponibles'); ?></label>
				</p>
				<div class="field_sublvl">
					<p class="field">
						<a href="<?php echo $tpl['link']('iptc'); ?>"><?php echo __('Choix des informations à afficher'); ?></a>
					</p>
				</div>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="iptc_get_data">
					<input<?php if ($tpl['config']['iptc_get_data']) : ?> checked<?php endif; ?> id="feature_iptc_get_data" name="config[iptc_get_data]" type="checkbox">
					<label for="feature_iptc_get_data"><?php echo __('Lors de l\'ajout de fichiers, récupérer les informations IPTC suivantes : titre, description et mots-clés'); ?></label>
				</p>
				<div class="field_sublvl">
					<p class="field">
						<label for="iptc_title_tag"><?php echo __('Tag à utiliser pour le titre :'); ?></label>
						<select name="config[iptc_title_tag]" id="iptc_title_tag">
							<option<?php if ($tpl['config']['iptc_title_tag'] == 'Headline') : ?> selected<?php endif; ?> value="Headline">Headline</option>
							<option<?php if ($tpl['config']['iptc_title_tag'] == 'ObjectName') : ?> selected<?php endif; ?> value="ObjectName">ObjectName</option>
						</select>
					</p>
				</div>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['xmp']) : ?> class="activated"<?php endif; ?> id="a-xmp">
			<fieldset>
				<legend><?php echo __('Métadonnées XMP'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="xmp">
					<input<?php if (!in_array('xmp', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['xmp']) : ?> checked<?php endif; ?> id="feature_xmp" name="config[xmp]" type="checkbox">
					<label for="feature_xmp"><?php echo __('Afficher les informations XMP disponibles'); ?></label>
				</p>
				<div class="field_sublvl">
					<p class="field">
						<a href="<?php echo $tpl['link']('xmp'); ?>"><?php echo __('Choix des informations à afficher'); ?></a>
					</p>
				</div>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="xmp_get_data">
					<input<?php if ($tpl['config']['xmp_get_data']) : ?> checked<?php endif; ?> id="feature_xmp_get_data" name="config[xmp_get_data]" type="checkbox">
					<label for="feature_xmp_get_data"><?php echo __('Lors de l\'ajout de fichiers, récupérer les informations XMP suivantes : titre, description, mots-clés et date de création'); ?></label>
				</p>
				<div class="field_sublvl">
					<p class="field">
						<input name="config[_checkboxes][]" type="hidden" value="xmp_priority">
						<input<?php if ($tpl['config']['xmp_priority']) : ?> checked<?php endif; ?> id="feature_xmp_priority" name="config[xmp_priority]" type="checkbox">
						<label for="feature_xmp_priority"><?php echo __('XMP est prioritaire sur IPTC'); ?></label>
					</p>
				</div>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['rss']) : ?> class="activated"<?php endif; ?> id="a-rss">
			<fieldset>
				<legend><?php echo __('RSS'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="rss">
					<input<?php if (!in_array('rss', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['rss']) : ?> checked<?php endif; ?> id="feature_rss" name="config[rss]" type="checkbox">
					<label for="feature_rss"><?php echo __('Activer les flux RSS'); ?></label>
				</p>
				<div class="field_sublvl">
					<p class="field<?php if (!in_array('rss', THEME_FEATURES)) : ?> disabled<?php endif; ?>">
						<label for="feature_rss_max_items"><?php echo __('Nombre maximum d\'objets dans les flux :'); ?></label>
						<input<?php if (!in_array('rss', THEME_FEATURES)) : ?> disabled<?php endif; ?> required value="<?php echo $tpl['config']['rss_max_items']; ?>" id="feature_rss_max_items" name="config[rss_max_items]" type="text" maxlength="3" size="3">
					</p>
				</div>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['browse']) : ?> class="activated"<?php endif; ?> id="a-browse">
			<fieldset>
				<legend><?php echo __('Liste des albums'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="browse">
					<input<?php if (!in_array('browse', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['browse']) : ?> checked<?php endif; ?> id="config_browse" name="config[browse]" type="checkbox">
					<label for="config_browse"><?php echo __('Afficher la liste de tous les albums'); ?></label>
				</p>
				<div class="field_sublvl">
					<p class="field">
						<input name="config[_checkboxes][]" type="hidden" value="browse_items_count">
						<input<?php if (!in_array('browse', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['browse_items_count']) : ?> checked<?php endif; ?> id="config_browse_items_count" name="config[browse_items_count]" type="checkbox">
						<label for="config_browse_items_count"><?php echo __('Afficher le nombre de fichiers'); ?></label>
					</p>
					<p class="field<?php if (!in_array('browse', THEME_FEATURES)) : ?> disabled<?php endif; ?>">
						<label for="config_browse_sortby"><?php echo __('Ordre d\'affichage :'); ?></label>
						<br>
						<select<?php if (!in_array('browse', THEME_FEATURES)) : ?> disabled<?php endif; ?> id="config_browse_sortby" class="block" name="config[browse_sortby]">
<?php foreach ($tpl['browse_sort_by_params'] as $col => $text) : ?>
							<option value="<?php echo $col; ?>"<?php if ($col == $tpl['browse_sort_by'][0][0]) : ?> selected<?php endif; ?>><?php echo $text; ?></option>
<?php endforeach; ?>
						</select>
						<select<?php if (!in_array('browse', THEME_FEATURES)) : ?> disabled<?php endif; ?> class="block" name="config[browse_orderby]">
<?php foreach ($tpl['order_by_params'] as $ascdesc => $text) : ?>
							<option value="<?php echo $ascdesc; ?>"<?php if ($ascdesc == $tpl['browse_sort_by'][0][1]) : ?> selected<?php endif; ?>><?php echo $text; ?></option>
<?php endforeach; ?>
						</select>
					</p>
				</div>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['items_recent']) : ?> class="activated"<?php endif; ?> id="a-items-recent">
			<fieldset>
				<legend><?php echo __('Photos et vidéos récentes'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="items_recent">
					<input<?php if (!in_array('items_recent', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['items_recent']) : ?> checked<?php endif; ?> id="items_recent" name="config[items_recent]" type="checkbox">
					<label for="items_recent"><?php echo __('Mettre en évidence les photos et vidéos récentes'); ?></label>
				</p>
				<div class="field_sublvl">
					<p class="field<?php if (!in_array('items_recent', THEME_FEATURES)) : ?> disabled<?php endif; ?>">
						<label for="items_recent_days"><?php echo __('Durée de nouveauté :'); ?></label>
						<input<?php if (!in_array('items_recent', THEME_FEATURES)) : ?> disabled<?php endif; ?> required value="<?php echo $tpl['config']['items_recent_days']; ?>" id="items_recent_days" name="config[items_recent_days]" type="text" maxlength="4" size="5">
						<?php echo __('jours'); ?>
					</p>
				</div>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['search']) : ?> class="activated"<?php endif; ?> id="a-search">
			<fieldset>
				<legend><?php echo __('Moteur de recherche'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="search">
					<input<?php if (!in_array('search', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['search']) : ?> checked<?php endif; ?> id="feature_search" name="config[search]" type="checkbox">
					<label for="feature_search"><?php echo __('Activer le moteur de recherche'); ?></label>
				</p>
				<div class="field_sublvl">
					<p class="field">
						<input name="config[_checkboxes][]" type="hidden" value="search_advanced">
						<input<?php if (!in_array('search_advanced', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['search_advanced']) : ?> checked<?php endif; ?> id="feature_search_advanced" name="config[search_advanced]" type="checkbox">
						<label for="feature_search_advanced"><?php echo __('Activer la recherche avancée'); ?></label>
					</p>
				</div>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['selection']) : ?> class="activated"<?php endif; ?> id="a-selection">
			<fieldset>
				<legend><?php echo __('Mode sélection'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="selection">
					<input<?php if (!in_array('selection', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['selection']) : ?> checked<?php endif; ?> id="feature_selection" name="config[selection]" type="checkbox">
					<label for="feature_selection"><?php echo __('Activer le mode sélection'); ?></label>
				</p>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['categories_stats']) : ?> class="activated"<?php endif; ?> id="a-categories-stats">
			<fieldset>
				<legend><?php echo __('Statistiques des catégories'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="categories_stats">
					<input<?php if (!in_array('categories_stats', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['categories_stats']) : ?> checked<?php endif; ?> id="feature_categories_stats" name="config[categories_stats]" type="checkbox">
					<label for="feature_categories_stats"><?php echo __('Afficher les statistiques des catégories'); ?></label>
				</p>
				<p class="field field_sublvl">
					<a href="<?php echo $tpl['link']('categories-stats'); ?>"><?php echo __('Choix des informations à afficher'); ?></a>
				</p>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['tags']) : ?> class="activated"<?php endif; ?> id="a-tags">
			<fieldset>
				<legend><?php echo __('Tags'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="tags">
					<input<?php if (!in_array('tags', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['tags']) : ?> checked<?php endif; ?> id="feature_tags" name="config[tags]" type="checkbox">
					<label for="feature_tags"><?php echo __('Activer les tags'); ?></label>
				</p>
				<div class="field_sublvl">
					<p class="field<?php if (!in_array('tags', THEME_FEATURES)) : ?> disabled<?php endif; ?>">
						<label for="feature_tags_max"><?php echo __('Nombre maximum de tags sur la page des catégories :'); ?></label>
						<input<?php if (!in_array('tags', THEME_FEATURES)) : ?> disabled<?php endif; ?> required value="<?php echo $tpl['config']['tags_max']; ?>" id="feature_tags_max" name="config[tags_max]" type="text" maxlength="3" size="3">
					</p>
				</div>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['albums_download']) : ?> class="activated"<?php endif; ?> id="a-albums-download">
			<fieldset>
				<legend><?php echo __('Téléchargement des albums'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="albums_download">
					<input<?php if (!in_array('albums_download', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['albums_download']) : ?> checked<?php endif; ?> id="feature_albums_download" name="config[albums_download]" type="checkbox">
					<label for="feature_albums_download"><?php echo __('Activer le téléchargement des albums (archives Zip)'); ?></label>
				</p>
			</fieldset>
		</div>

		<div<?php if ($tpl['config']['votes']) : ?> class="activated"<?php endif; ?> id="a-votes">
			<fieldset>
				<legend><?php echo __('Votes'); ?></legend>
				<p class="field">
					<input name="config[_checkboxes][]" type="hidden" value="votes">
					<input<?php if (!in_array('votes', THEME_FEATURES)) : ?> disabled<?php endif; ?><?php if ($tpl['config']['votes']) : ?> checked<?php endif; ?> id="feature_votes" name="config[votes]" type="checkbox">
					<label for="feature_votes"><?php echo __('Activer les votes'); ?></label>
				</p>
			</fieldset>
		</div>
	</div>
	<div id="submit" class="submit_actions">
		<div>
			<p id="form_save">
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input type="submit" value="<?php echo __('Enregistrer'); ?>">
			</p>
		</div>
	</div>
</form>