<form action="<?php echo $tpl['current_url']; ?>" method="post" enctype="multipart/form-data" id="upload_form">
	<fieldset>
		<legend><?php echo $tpl['item']['type'] == 'video' ? __('Vidéo actuelle') : __('Image actuelle'); ?></legend>
		<p id="item_current" class="field">
<?php $size = $tpl['item']['thumb_size'](400, 400); ?>
<?php if ($tpl['item']['type'] == 'video') : ?>
			<video data-video-id="<?php echo $tpl['item']['id']; ?>" controls
				poster="<?php echo $tpl['item']['thumb_src']('400'); ?>"
				width="<?php echo $size['w']; ?>" height="<?php echo $size['h']; ?>">
				<source src="<?php echo $tpl['item']['file']; ?>" type="<?php echo $tpl['item']['type_mime']; ?>">
			</video>
<?php else : ?>
			<a href="<?php echo $tpl['item']['file']; ?>" class="viewer">
				<img width="<?php echo $size['w']; ?>" height="<?php echo $size['h']; ?>"
					src="<?php echo $tpl['item']['thumb_src']('400'); ?>">
			</a>
<?php endif; ?>
		</p>
	</fieldset>
	<fieldset>
		<legend><?php echo $tpl['item']['type'] == 'video' ? __('Nouvelle vidéo') : __('Nouvelle image'); ?></legend>
		<div id="upload_classic">
			<p class="field">
				<input required id="file" name="replace" size="35" maxlength="2048" type="file"
					data-maxsize="<?php echo $tpl['upload_maxfilesize'](); ?>"
					accept="<?php echo implode(',', $tpl['upload']['filetypes']); ?>">
				<br>
				<span class="text"><?php echo nl2br($tpl['upload']['text_limits_classic']); ?></span>
			</p>
			<p class="field">
				<input name="MAX_FILE_SIZE" value="<?php echo $tpl['upload_maxfilesize'](); ?>" type="hidden">
				<input type="submit" value="<?php echo __('Envoyer'); ?>">
			</p>
		</div>
		<div id="upload" class="replace">
			<div id="upload_list">
				<p id="upload_startmsg"><?php echo __('Déposez votre fichier ici.'); ?></p>
			</div>
			<div id="upload_infos">
				<p>
					<span><?php echo __('Envoyé :'); ?></span>
					<span id="upload_infos_progress_pc">0%</span>
				</p>
			</div>
			<p id="upload_text_limits"><?php echo $tpl['upload']['text_limits'] . ' ' . sprintf(__('Modifiez ces valeurs dans la section %s.'), '<a href="' . $tpl['link']('options-gallery') . '#a-upload-files">' . __('Options') . '</a>'); ?></p>
			<div id="upload_buttons">
				<input type="file" id="upload_input_file" accept="<?php echo implode(',', $tpl['upload']['filetypes']); ?>">
				<input type="button" id="upload_add" value="<?php echo __('Sélectionner un fichier'); ?>">
				<input type="button" id="upload_clear" value="<?php echo __('Supprimer'); ?>">
				<input type="button" id="upload_start" value="<?php echo __('Envoyer'); ?>">
			</div>
<?php include('upload_options.tpl.php'); ?>

			<input name="temp_dir" type="hidden" value="<?php echo $tpl['upload']['temp_dir']; ?>">
			<input name="upload" type="hidden" value="1">
			<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
		</div>
<?php if ($tpl['upload']['errors'] || $tpl['upload']['warnings']) : ?>
		<br>
		<div class="report_classic">
<?php if ($tpl['upload']['errors']) : ?>
			<div class="report_msg report_error">
<?php foreach ($tpl['upload']['errors'] as &$e) : ?>
				<p><?php echo $e; ?></p>
<?php endforeach; ?>
			</div>
<?php endif; ?>
<?php if ($tpl['upload']['warnings']) : ?>
			<div class="report_msg report_warning">
<?php foreach ($tpl['upload']['warnings'] as &$w) : ?>
				<p><?php echo $w; ?></p>
<?php endforeach; ?>
			</div>
<?php endif; ?>
		</div>
<?php endif; ?>
	</fieldset>
</form>