<?php include('options_menu.tpl.php'); ?>

<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="page">
	<fieldset>
		<legend><?php echo __('Général'); ?></legend>
		<p class="field">
			<label for="gallery_title"><?php echo __('Titre de la galerie :'); ?></label>
			<input value="<?php echo $tpl['config']['gallery_title']; ?>" id="gallery_title" name="config[gallery_title]" type="text" maxlength="255" size="50" class="large">
		</p>
		<p class="field">
			<label for="gallery_description"><?php echo __('Description de la galerie :'); ?></label>
			<span class="html_outer">
				<span class="html_inner">
					<textarea rows="8" cols="50" id="gallery_description" name="config[gallery_description]"><?php echo $tpl['config']['gallery_description']; ?></textarea>
					<span>HTML</span>
				</span>
			</span>
		</p>
		<p class="field">
			<label for="gallery_footer_text"><?php echo __('Texte de pied de page :'); ?></label>
			<span class="html_outer">
				<span class="html_inner">
					<textarea rows="8" cols="50" id="gallery_footer_text" name="config[gallery_footer_text]"><?php echo $tpl['config']['gallery_footer_text']; ?></textarea>
					<span>HTML</span>
				</span>
			</span>
		</p>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="admin_link">
			<input<?php if ($tpl['config']['admin_link']) : ?> checked<?php endif; ?> id="admin_link" name="config[admin_link]" type="checkbox">
			<label for="admin_link"><?php echo __('Afficher le lien vers l\'interface d\'administration'); ?></label>
		</p>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="gallery_closed">
			<input<?php if ($tpl['config']['gallery_closed']) : ?> checked<?php endif; ?> id="gallery_closed" name="config[gallery_closed]" type="checkbox">
			<label for="gallery_closed"><?php echo __('Fermer la galerie'); ?></label>
		</p>
		<p class="field field_sublvl">
			<label for="gallery_closed_text"><?php echo __('Message de fermeture :'); ?></label>
			<span class="html_outer">
				<span class="html_inner">
					<textarea rows="8" cols="50" id="gallery_closed_text" name="config[gallery_closed_text]"><?php echo $tpl['config']['gallery_closed_text']; ?></textarea>
					<span>HTML</span>
				</span>
			</span>
		</p>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Vues'); ?></legend>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="views_admin">
			<input<?php if ($tpl['config']['views_admin']) : ?> checked<?php endif; ?> id="views_admin" name="config[views_admin]" type="checkbox">
			<label for="views_admin"><?php echo __('Ne pas comptabiliser les vues des administrateurs'); ?></label>
		</p>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="views_ip">
			<input<?php if ($tpl['config']['views_ip']) : ?> checked<?php endif; ?> id="views_ip" name="config[views_ip]" type="checkbox">
			<label for="views_ip"><?php echo __('Ne pas comptabiliser les vues des utilisateurs dont l\'IP se trouve dans cette liste :'); ?></label>
		</p>
		<p class="field field_sublvl">
			<textarea rows="6" cols="50" name="config[views_ip_list]"><?php echo $tpl['config']['views_ip_list']; ?></textarea>
		</p>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="views_useragent">
			<input<?php if ($tpl['config']['views_useragent']) : ?> checked<?php endif; ?> id="views_useragent" name="config[views_useragent]" type="checkbox">
			<label for="views_useragent"><?php echo __('Ne pas comptabiliser les vues des utilisateurs dont l\'User-Agent se trouve dans cette liste :'); ?></label>
		</p>
		<p class="field field_sublvl">
			<textarea rows="6" cols="50" name="config[views_useragent_list]"><?php echo $tpl['config']['views_useragent_list']; ?></textarea>
		</p>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Langue et fuseau horaire'); ?></legend>
		<p class="field">
			<label for="tz_default"><?php echo __('Fuseau horaire par défaut :'); ?></label>
			<select class="block" name="config[tz_default]" id="tz_default">
<?php foreach ($tpl['tz_identifiers'] as $region => $list) : ?>
				<optgroup label="<?php echo $region; ?>">
<?php foreach ($list as &$i) : ?>
					<option<?php if ($i == $tpl['config']['tz_default']) : ?> selected<?php endif; ?> value="<?php echo $i; ?>"><?php echo str_replace('_', ' ', $i); ?></option>
<?php endforeach; ?>
				</optgroup>
<?php endforeach; ?>
			</select>
		</p>
		<p class="field">
			<label for="lang_default"><?php echo __('Langue par défaut :'); ?></label>
			<select class="block" name="config[lang_default]" id="lang_default">
<?php foreach ($tpl['langs'] as &$i) : ?>
				<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['code']; ?>"><?php echo $i['code']; ?> - <?php echo $i['name']; ?></option>
<?php endforeach; ?>
			</select>
		</p>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="lang_detect">
			<input<?php if ($tpl['config']['lang_detect']) : ?> checked<?php endif; ?> id="lang_detect" name="config[lang_detect]" type="checkbox">
			<label for="lang_detect"><?php echo __('Utiliser la langue du navigateur (si disponible)'); ?></label>
		</p>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="lang_switch">
			<input<?php if ($tpl['config']['lang_switch']) : ?> checked<?php endif; ?> id="lang_switch" name="config[lang_switch]" type="checkbox">
			<label for="lang_switch"><?php echo __('Activer le menu des langues (uniquement pour utilisateurs non enregistrés)'); ?></label>
		</p>
	</fieldset>
	<div class="browse_anchor" id="a-upload-files"></div>
	<fieldset>
		<legend><?php echo __('Envoi de fichiers par le navigateur'); ?></legend>
		<p class="field">
			<label for="upload_maxtotalfiles"><?php echo __('Nombre maximum de fichiers :'); ?></label>
			<input required value="<?php echo $tpl['config']['upload_maxtotalfiles']; ?>" id="upload_maxtotalfiles" name="config[upload_maxtotalfiles]" type="text" maxlength="4" size="4">
		</p>
		<p class="field">
			<label for="upload_maxfilesize"><?php echo __('Poids maximum des fichiers :'); ?></label>
			<input required value="<?php echo $tpl['config']['upload_maxfilesize']; ?>" id="upload_maxfilesize" name="config[upload_maxfilesize]" type="text" maxlength="5" size="5"> <?php echo __('Mo'); ?>
		</p>
		<p class="field">
			<label for="upload_maxwidth"><?php echo __('Dimensions maximum des photos :'); ?></label>
			<span class="block">
				<input required value="<?php echo $tpl['config']['upload_maxwidth']; ?>" id="upload_maxwidth" name="config[upload_maxwidth]" type="text" maxlength="5" size="6">
				x
				<input required value="<?php echo $tpl['config']['upload_maxheight']; ?>" id="upload_maxheight" name="config[upload_maxheight]" type="text" maxlength="5" size="6"> <?php echo __('pixels'); ?>
			</span>
		</p>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="upload_resize">
			<input<?php if ($tpl['config']['upload_resize']) : ?> checked<?php endif; ?> id="upload_resize" name="config[upload_resize]" type="checkbox">
			<label for="upload_resize"><?php echo __('Redimensionner les photos'); ?></label>
		</p>
		<div class="field_sublvl">
			<p class="field">
				<label for="upload_resize_maxwidth"><?php echo __('Dimensions maximum des photos :'); ?></label>
				<span class="block">
					<input required value="<?php echo $tpl['config']['upload_resize_maxwidth']; ?>" id="upload_resize_maxwidth" name="config[upload_resize_maxwidth]" type="text" maxlength="5" size="6">
					x
					<input required value="<?php echo $tpl['config']['upload_resize_maxheight']; ?>" id="upload_resize_maxheight" name="config[upload_resize_maxheight]" type="text" maxlength="5" size="6"> <?php echo __('pixels'); ?>
				</span>
			</p>
			<p class="field">
				<label for="upload_resize_quality"><?php echo __('Qualité (entre 0 et 100) :'); ?></label>
				<input required value="<?php echo $tpl['config']['upload_resize_quality']; ?>" id="upload_resize_quality" name="config[upload_resize_quality]" maxlength="3" type="text" size="3">
			</p>
		</div>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Vignettes'); ?></legend>
		<p class="field">
			<label for="thumbs_type"><?php echo __('Format :'); ?></label>
			<select class="block" name="config[thumbs_type]" id="thumbs_type">
<?php foreach ($tpl['file_types'] as $value => $name) : ?>
				<option<?php if ($tpl['config']['thumbs_type'] == $value) : ?> selected<?php endif; ?> value="<?php echo $value; ?>"><?php echo $name; ?></option>
<?php endforeach; ?>
			</select>
		</p>
		<p class="field">
			<label for="thumbs_quality"><?php echo __('Qualité (entre 0 et 100) :'); ?></label>
			<input required value="<?php echo $tpl['config']['thumbs_quality']; ?>" id="thumbs_quality" name="config[thumbs_quality]" maxlength="3" type="text" size="3">
		</p>
	</fieldset>
	<fieldset>
		<legend><?php echo __('Statistiques'); ?></legend>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="stats_short_numbers">
			<input<?php if ($tpl['config']['stats_short_numbers']) : ?> checked<?php endif; ?> id="stats_short_numbers" name="config[stats_short_numbers]" type="checkbox">
			<label for="stats_short_numbers"><?php echo __('Utiliser la notation courte (ex. : 6 k au lieu de 6 000)'); ?></label>
		</p>
	</fieldset>
	<fieldset>
		<legend>URL rewriting</legend>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="CONF_URL_REWRITE">
			<input<?php if ($tpl['config']['CONF_URL_REWRITE']) : ?> checked<?php endif; ?> id="config_url_rewriting" name="config[CONF_URL_REWRITE]" type="checkbox">
			<label data-help-icon="url_rewriting" for="config_url_rewriting"><?php echo __('Utiliser l\'URL rewriting'); ?></label>
		</p>
	</fieldset>
	<fieldset<?php if (!$tpl['new_version_check']) : ?> disabled<?php endif; ?>>
		<legend><?php echo __('Mises à jour'); ?></legend>
		<p class="field">
			<input name="config[_checkboxes][]" type="hidden" value="new_version_check">
			<input<?php if ($tpl['config']['new_version_check']) : ?> checked<?php endif; ?> id="new_version_check" name="config[new_version_check]" type="checkbox">
			<label<?php if ($tpl['new_version_check']) : ?> data-help-icon="new_version_check"<?php endif; ?> for="new_version_check"><?php echo __('Activer la recherche automatique des mises à jour'); ?></label>
		</p>
	</fieldset>
	<div id="submit">
		<div>
			<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
			<input type="submit" value="<?php echo __('Enregistrer'); ?>">
		</div>
	</div>
</form>