<?php $confirm_delete = __('Supprimer les votes sélectionnés ?'); ?>
<div id="page_table" class="page_content">
	<div>
<?php include('category_browse.tpl.php'); ?>

		<nav id="section_nav">
<?php include('breadcrumb.tpl.php'); ?>
		</nav>

<?php if (isset($_POST['action']) && $_POST['action'] == 'delete_confirm') : ?>
<?php include('delete_selection.tpl.php'); ?>
<?php else : ?>

		<div class="tools">
			<div><span class="icon icon_search show_tool"><a data-id="search" class="js<?php if (strstr($_GET['section_1'], 'search')) : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('votes' . (strstr($_GET['section_1'], 'search') ? '' : '-search') . '/page/' . $_GET['page']); ?>"><?php echo __('Recherche'); ?></a></span></div>
			<span class="sep">-</span>
			<div><span class="icon icon_options show_tool"><a data-id="options" class="js<?php if (strstr($_GET['section_1'], 'display')) : ?> show<?php endif; ?>" href="<?php echo $tpl['link']('votes' . (strstr($_GET['section_1'], 'display') ? '' : '-display') . '/page/' . $_GET['page']); ?>"><?php echo __('Options d\'affichage'); ?></a></span></div>
		</div>

		<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool<?php if (strstr($_GET['section_1'], 'search')) : ?> show<?php endif; ?>" id="search">
			<fieldset>
				<p class="field">
					<label for="search_query"><?php echo __('Rechercher :'); ?></label>
					<input<?php if (strstr($_GET['section_1'], 'search')) : ?> autofocus<?php endif; ?> required data-help-icon="search" value="<?php echo $tpl['search']['query']; ?>" class="focus" type="text" name="search_query" id="search_query" maxlength="255" size="50" data-reset="">
				</p>
				<p class="field">
					<input<?php echo $tpl['search']['all_words'] ? ' checked' : ''; ?> type="checkbox" name="search_options[all_words]" id="search_all_words" data-reset="1">
					<label for="search_all_words"><?php echo __('Rechercher tous les mots'); ?></label>
				</p>
				<p class="field">
					<span class="icon icon_search_options showhide" rel="#adv_search"><a class="js" href="<?php echo $tpl['link']('votes-' . (strstr($_GET['section_1'], 'advanced') ? 'search' : 'search-advanced') . '/page/' . $_GET['page']); ?>"><?php echo __('Options de recherche'); ?></a></span>
				</p>
				<div id="adv_search" class="adv_search_col<?php if (strstr($_GET['section_1'], 'advanced')) : ?> show<?php endif; ?>">
					<div>
						<p class="field">
							<?php echo __('Rechercher dans les champs suivants :'); ?>
						</p>
						<div class="field_sublvl">
							<p class="field">
								<input<?php echo $tpl['search']['columns']['vote_ip'] ? ' checked' : ''; ?> type="checkbox" name="search_options[columns][]" value="vote_ip" id="search_vote_ip" data-reset="1">
								<label for="search_vote_ip"><?php echo __('IP'); ?></label>
							</p>
						</div>
					</div>
					<div>
						<p class="field">
							<input<?php echo $tpl['search']['date'] ? ' checked' : ''; ?> id="search_date" type="checkbox" name="search_options[date]" data-reset="0">
							<label for="search_date"><?php echo __('Rechercher par date :'); ?></label>
						</p>
						<div class="field_sublvl">
							<input type="hidden" name="search_options[date_column]" value="vote_date">
<?php include('search_date.tpl.php'); ?>
						</div>
					</div>
				</div>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input name="search" type="submit" value="<?php echo __('Chercher'); ?>">
				<input class="button reset_js" type="reset" value="<?php echo __('Réinitialiser'); ?>">
			</fieldset>
		</form>

		<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post" class="tool<?php if ($_GET['section_1'] == 'votes-display') : ?> show<?php endif; ?>" id="options">
			<fieldset>
				<p class="field">
					<label for="nb_per_page"><?php echo __('Nombre de votes par page :'); ?></label>
					<input<?php if ($_GET['section_1'] == 'votes-display') : ?> autofocus<?php endif; ?> required maxlength="3" size="3" value="<?php echo $tpl['options']['nb_per_page']; ?>" name="nb_per_page" id="nb_per_page" type="text" class="focus">
				</p>
				<p class="field">
					<label for="order_by_column"><?php echo __('Trier par :'); ?></label>
					<select name="order_by_column" id="order_by_column">
<?php foreach ($tpl['options']['order_by_column'] as &$i) : ?>
						<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
					</select>
					<select name="order_by_order">
<?php foreach ($tpl['options']['order_by_order'] as &$i) : ?>
						<option<?php if ($i['selected']) : ?> selected<?php endif; ?> value="<?php echo $i['value']; ?>"><?php echo $i['text']; ?></option>
<?php endforeach; ?>
					</select>
				</p>
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input name="options" type="submit" value="<?php echo __('Valider'); ?>">
			</fieldset>
		</form>

<?php if ($tpl['objects_count'] > 0) : ?>

<?php include('pagination.tpl.php'); ?>

		<div class="table_form_container">
			<form class="table_form" id="votes_form" action="<?php echo $tpl['current_url']; ?>" method="post">

				<div id="obj_links_js">
<?php include('object_select.tpl.php'); ?>
				</div>

				<table class="default page">
					<tr>
						<th><?php echo __('Fichier'); ?></th>
						<th class="album"><?php echo __('Album'); ?></th>
						<th class="date"><?php echo __('Date'); ?></th>
						<th class="user"><?php echo __('Utilisateur'); ?></th>
						<th class="ip"><?php echo __('IP'); ?></th>
						<th><?php echo __('Note'); ?></th>
						<th class="null"></th>
					</tr>
<?php foreach ($tpl['votes'] as &$i) : ?>
					<tr class="selectable_class">
						<td class="filter thumb">
							<div>
								<a href="<?php echo $i['item_link']; ?>">
<?php if ($i['item_type'] == 'video') : ?>					
									<span class="duration" id="videoduration_<?php echo $i['id']; ?>"><?php echo $i['item_duration_text']; ?></span>
<?php endif; ?>
									<img
										alt="<?php echo $i['item_name']; ?>"
<?php if ($i['item_type'] == 'video') : ?>
										data-video-id="<?php echo $i['item_id']; ?>"
<?php endif; ?>
										src="<?php echo $i['item_thumb_src'](); ?>">
								</a>
								<a title="<?php echo __('Afficher tous les votes de ce fichier'); ?>" class="filter_link" href="<?php echo $i['filter_item_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a>
							</div>
						</td>
						<td class="filter album">
							<div>
								<a href="<?php echo $i['album_link']; ?>"><?php echo $i['album_name']; ?></a>
								<a title="<?php echo __('Afficher tous les votes de cet album'); ?>" class="filter_link" href="<?php echo $i['filter_album_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a>
							</div>
						</td>
						<td class="filter date">
							<div>
								<?php echo $i['date_created']; ?>
								<br>
								<?php echo $i['time_created']; ?>
								<a title="<?php echo __('Afficher tous les votes à cette date'); ?>" class="filter_link" href="<?php echo $i['filter_date_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a>
							</div>
						</td>
						<td class="filter user">
							<div>
<?php if ($i['user_link']) : ?>
								<a href="<?php echo $i['user_link']; ?>"><?php echo $i['user_name']; ?></a>
<?php else : ?>
								<?php echo $i['user_name']; ?>
<?php endif; ?>
<?php if ($i['user_id'] != 2) : ?>
								<a title="<?php echo __('Afficher tous les votes de cet utilisateur'); ?>" class="filter_link" href="<?php echo $i['filter_user_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a>
<?php endif; ?>
							</div>
						</td>
						<td class="filter ip">
							<div>
								<?php echo $i['user_ip']; ?>
								<a title="<?php echo __('Afficher tous les votes en provenance de cette IP'); ?>" class="filter_link" href="<?php echo $i['filter_ip_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a>
							</div>
						</td>
						<td class="filter rating">
							<div>
								<span><?php foreach ($i['rating_array'] as $k => $v) : ?><?php if ($v == 1) : ?><img width="12" height="12" src="<?php echo $tpl['admin']['style']['path']; ?>/star-full-small.png"><?php else : ?><img width="12" height="12" src="<?php echo $tpl['admin']['style']['path']; ?>/star-empty-small.png"><?php endif; ?><?php endforeach; ?></span>
								<span><?php echo $i['rating']; ?></span>
								<a title="<?php echo __('Afficher tous les votes correspondant à cette note'); ?>" class="filter_link" href="<?php echo $i['filter_note_link']; ?>"><img width="16" height="16" src="<?php echo $tpl['admin']['style']['path']; ?>/icons/16x16/search.png"></a>
							</div>
						</td>
						<td class="selectable_zone"><input class="selectable" name="selected[<?php echo $i['id']; ?>]" type="checkbox"></td>
					</tr>
<?php endforeach; ?>
				</table>

				<div id="submit" class="submit_actions submit_table<?php if ($tpl['nb_pages'] > 1) : ?> submit_pages<?php endif; ?>">
					<div>
						<p id="form_actions">
							<label for="selection_action"><?php printf(__('Action sur la sélection (%s) :'), '<span id="select_num">0</span>'); ?></label>
							<select id="selection_action" name="action">
								<optgroup label="<?php echo __('Suppression'); ?>">
									<option value="delete_confirm"><?php echo __('Supprimer'); ?></option>
								</optgroup>
							</select>
							<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
							<input name="selection" type="submit" value="<?php echo __('Valider'); ?>">
						</p>
					</div>
				</div>
			</form>
		</div>

		<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
		var confirm_delete = "<?php echo $tpl['php2js']($confirm_delete); ?>";
		</script>

<?php include('pagination.tpl.php'); ?>

<?php else : ?>
		<br>
		<div class="report_classic">
			<div class="report_msg report_info">
				<p><?php echo isset($_GET['search']) ? __('Aucun vote trouvé.') : __('Aucun vote.'); ?></p>
			</div>
		</div>
<?php endif; ?>

<?php endif; ?>

	</div>
</div>