<?php
declare(strict_types = 1);

/**
 * Télécharge un fichier, des favoris ou un album.
 *
 * @license http://www.gnu.org/licenses/gpl.html
 * @link http://www.igalerie.org/
 */

if (isset($_GET['file']))
{
	$download = TRUE;
	require_once(__DIR__ . '/file.php');
	die;
}

if (isset($_GET['cat']))
{
	$gets = ['cat', 'favorites', 'key'];
	require_once(__DIR__ . '/includes/prepend.php');

	// Vérification du format des paramètres.
	if (!isset($_GET['cat'])  || !preg_match('`^\d{1,12}$`i', $_GET['cat'])
	 || !isset($_GET['key'])  || !preg_match('`^[a-f0-9]{32}$`', $_GET['key']))
	{
		die(App::httpResponse(400));
	}

	// Vérification de la clé de sécurité.
	if (!Security::fileKeyVerify([$_GET['cat']], $_GET['key']))
	{
		die(App::httpResponse(403));
	}

	// Connexion à la base de données.
	if (!DB::connect())
	{
		die(App::httpResponse(500));
	}

	// Récupération de la configuration.
	Config::getDBParams();

	// Authentification utilisateur.
	if (Config::$params['users'])
	{
		Auth::cookie();
	}

	// Vérification des permissions de téléchargement des favoris.
	if (isset($_GET['favorites']))
	{
		if (!Config::$params['users'] || !Config::$params['favorites']
		|| !Config::$params['favorites_download'] || !Auth::$connected)
		{
			die(App::httpResponse(403));
		}
	}

	// Vérification des permissions de téléchargement d'un album.
	else
	{
		// Fonctionnalité activée ?
		if (!Config::$params['albums_download'])
		{
			die(App::httpResponse(403));
		}

		// Permission de groupe ?
		if (Config::$params['users'] && !Auth::$groupPerms['albums_download'])
		{
			die(App::httpResponse(403));
		}
	}

	// Vérification des permissions d'accès à l'album.
	$sql = 'SELECT cat_path,
				   cat_name
			  FROM {categories} AS cat
			 WHERE cat_id = :cat_id
			   AND ' . SQL::catPerms() . '
			   AND ' . SQL::catPassword() . '
			   AND cat_status = "1"';
	$sql .= isset($_GET['favorites'])
		? ''
		: ' AND cat_filemtime IS NOT NULL AND cat_downloadable = "1"';
	DB::params(['cat_id' => $_GET['cat']]);
	if (!DB::execute($sql))
	{
		die(App::httpResponse(500));
	}
	if (!$category = DB::fetchRow())
	{
		die(App::httpResponse(403));
	}

	// Récupération des informations utiles des fichiers.
	if (isset($_GET['favorites']))
	{
		$sql = 'SELECT item_path
				  FROM {items} AS i,
					   {categories} AS cat,
					   {favorites} AS fav
				 WHERE item_path LIKE :item_path
				   AND i.item_id = fav.item_id
				   AND i.cat_id = cat.cat_id
				   AND fav.user_id = :user_id
				   AND ' . SQL::catPerms() . '
				   AND ' . SQL::catPassword() . '
				   AND item_status = "1"';
		DB::params([
			'user_id' => Auth::$id,
			'item_path' => $_GET['cat'] > 1 ? DB::likeEscape($category['cat_path']) . '/%' : '%'
		]);
		if (!DB::execute($sql))
		{
			die(App::httpResponse(500));
		}
		if (!$items = DB::fetchAll())
		{
			die(App::httpResponse(403));
		}
		$archive_name = __('Mes favoris');
		if ($_GET['cat'] > 1)
		{
			$archive_name .= ' - ' . $category['cat_name'];
		}
	}
	else
	{
		$sql = 'SELECT item_path FROM {items} WHERE cat_id = ? AND item_status = "1"';
		if (!DB::execute($sql, $_GET['cat']))
		{
			die(App::httpResponse(500));
		}
		if (!$items = DB::fetchAll())
		{
			die(App::httpResponse(403));
		}
		$archive_name = $category['cat_name'];
	}

	// Fermeture de la connexion à la base de données.
	DB::disconnect();

	// Fichiers à placer dans l'archive.
	$files = [];
	foreach ($items as &$i)
	{
		$files[] = CONF_ALBUMS_PATH . '/' . $i['item_path'];
	}

	// Envoi de l'archive.
	$items = NULL;
	Zip::archive($archive_name . '.zip', $files);
	die;
}

require_once(__DIR__ . '/includes/prepend.php');
die(App::httpResponse(400));
?>