<?php
declare(strict_types = 1);

require_once(__DIR__ . '/Admin.class.php');

/**
 * Informations système.
 *
 * @license http://www.gnu.org/licenses/gpl.html
 * @link http://www.igalerie.org/
 */
class AdminSystem extends Admin
{
	/**
	 * Récupération des informations système.
	 *
	 * @return void
	 */
	public static function getInfos(): void
	{
		// Nombre d'incidents.
		$nb_errors = 0;
		foreach (glob(GALLERY_ROOT . '/errors/*.xml') as &$f)
		{
			$nb_errors++;
		}

		// Application.
		$history = Config::$params['app_history'];
		foreach ($history as &$i)
		{
			$i['version'] = sprintf(__('Version %s'), $i['version']);
		}
		Template::set('application',
		[
			'name' => System::APP_NAME,
			'version' => Config::$params['app_version'],
			'website' => System::APP_WEBSITE,
			'history' => $history,
			'errors' => $nb_errors
		]);

		// Serveur.
		Template::set('server',
		[
			'type' => System::getServerType(),
			'os' => System::getOSInfos('srm'),
			'time' => System::getServerTime()
		]);

		// PHP.
		Template::set('php',
		[
			'version' => System::getPHPVersion(),
			'interface' => System::getPHPSAPI()
		]);

		// GD.
		Template::set('gd_infos', System::getGDInfos());

		// Directives PHP.
		Template::set('php_directives', System::getPHPDirectives());

		// Extensions PHP.
		Template::set('php_extensions', System::getPHPExtensions());

		// Fonctions PHP.
		Template::set('php_functions', System::getPHPFunctions());

		// Base de données.
		Template::set('database',
		[
			'type' => DB::NAME,
			'version' => DB::$version,
			'version_ok' => (int) version_compare(DB::$version, DB::VERSION_MIN, '>='),
			'details' => DB::getDetails()
		]);
	}
}
?>