<?php
declare(strict_types = 1);

/**
 * Gestion des appareils photos.
 *
 * @license http://www.gnu.org/licenses/gpl.html
 * @link http://www.igalerie.org/
 */
class Cameras
{
	/**
	 * Supprime des marques ou modèles d'appareils photos.
	 *
	 * @param string $type
	 *   Type accepté : 'brand' ou 'model'.
	 * @param mixed $cameras_id
	 *   Identifiant des marques ou modèles.
	 *
	 * @return int
	 *   Retourne le nombre de lignes affectées,
	 *   ou -1 en cas d'erreur.
	 */
	public static function delete(string $type, $cameras_id): int
	{
		if (!is_array($cameras_id))
		{
			$cameras_id = [$cameras_id];
		}
		if (!$cameras_id)
		{
			return 0;
		}

		$sql = "DELETE
				  FROM {cameras_{$type}s}
				 WHERE camera_{$type}_id IN (" . DB::inInt($cameras_id) . ")";
		if (!DB::execute($sql))
		{
			return -1;
		}

		return DB::rowCount();
	}
}
?>