'use strict';

/*
 * Captures vidéo.
 *
 * @license http://www.gnu.org/licenses/gpl.html
 * @link http://www.igalerie.org/
 *
 * @param array captures
 *
 * @return void
 */
function videocaptures(captures)
{
	if (!captures.length)
	{
		return;
	}

	var isIE = /*@cc_on!@*/false || !!document.documentMode;
	var isEdge = !isIE && !!window.StyleMedia;

	var duration, width, height,
		video, video_id;

	// Insertion de la vidéo.
	function insert_video(i, div)
	{
		$(video_id).remove();

		if (captures[i] === undefined)
		{
			return;
		}

		var path = captures[i].path.replace(/&amp;/g, '&');
		var rand = Math.random().toString().replace('.', '');
		var html = '<video muted width="0" height="0" id="videocapture_' + rand
			+ '"><source src="' + path + '&rand=' + rand + '" type="video/mp4"></video>';
		$(html).appendTo('body');

		video_id = '#videocapture_' + rand;
		video = $(video_id)[0];

		console.log('Video: ' + path);

		$(video_id).hide();

		// Si une erreur survient, on passe à la vidéo suivante.
		$(video_id).on('error', function(e)
		{
			console.log('Error: ' + (e.currentTarget.error.message === undefined
				? 'unknown'
				: e.currentTarget.error.message));
			$(video_id).off();
			insert_video(i + 1, 2);
		});
		$(video_id).attr('src', path + '&rand=' + rand);

		$(video_id).on('canplaythrough', function()
		{
			duration = Math.round(video.duration);
			width = video.videoWidth;
			height = video.videoHeight;

			// Si la vidéo n'est pas valide, on passe à la suivante.
			if (height < 1 || width < 1)
			{
				console.log('Invalid size');
				$(video_id).off();
				insert_video(i + 1, 2);
				return;
			}

			set_position(i, div);
		});
	}

	// Extrait une image de la vidéo, puis l'envoi au serveur.
	function get_frame(i, div)
	{
		var canvas = document.createElement('canvas');
		var maxsize = 1920;
		canvas.width = width;
		canvas.height = height;

		if (width > maxsize || height > maxsize)
		{
			if (width < height)
			{
				canvas.width = Math.round((maxsize / height) * width);
				canvas.height = maxsize;
			}
			else
			{
				canvas.height = Math.round((maxsize / width) * height);
				canvas.width = maxsize;
			}
		}
		canvas.getContext('2d').drawImage(video, 0, 0, canvas.width, canvas.height);

		var canvas_data = canvas.toDataURL('image/jpeg');
		canvas_data = canvas_data.replace(/^data:image\/jpeg;base64,/, '');

		// Si l'image extraite est peu volumineuse,
		// c'est qu'il y a de fortes chances qu'elle soit trop uniforme
		// (trop sombre ou trop claire).
		// On tente donc d'extraire une image à un autre endroit de la vidéo
		// de manière à ce qu'elle soit plus représentative.
		if (canvas_data.length < (maxsize * 33))
		{
			if (div < 3)
			{
				set_position(i, 3);
				return;
			}
			else if (div < 4)
			{
				set_position(i, 4);
				return;
			}
		}

		console.log('Size: ' + width + ' x ' + height + '; Duration: ' + duration);

		// Envoi de l'image au serveur.
		$.post(
			gallery_path + '/capture.php',
			{
				anticsrf: anticsrf,
				hash: captures[i].hash,
				data: canvas_data,
				duration: duration,
				height: height,
				id: captures[i].id,
				key: captures[i].key,
				width: width
			},
			function(r)
			{
				// Si l'envoi a réussi, on passe à la vidéo suivante.
				if (r.success)
				{
					console.log('Ajax: success');
					update_thumb(i, width, height, duration);
					insert_video(i + 1, 2);
				}
			},
			'json'
		);
	}

	// Définit la position de lecture,
	// puis déclenche la capture d'image.
	function set_position(i, div)
	{
		$(video_id).off();

		video.currentTime = duration / div;

		if (isIE || isEdge)
		{
			$(video_id).on('seeked', function()
			{
				$(video_id)[0].pause();
				get_frame(i, div);
			})
			$(video_id)[0].play();
		}
		else
		{
			$(video_id).on('canplay', function()
			{
				get_frame(i, div);
			});
		}
	}

	// Met à jour les informations de la vidéo
	// si elle est présente sur la page.
	function update_thumb(i, w, h, d)
	{
		var id = captures[i].id;

		if ($('body').attr('id') == 'section_items_pending')
		{
			id = id.replace(/p/, '');
		}

		var img = 'img[data-video-id="' + id + '"]';
		if ($(img).length && $(img).attr('src').match(/video-no-thumb\.png\#/))
		{
			// Vignette.
			var thumb_src = $(img).attr('src').replace(/.+video-no-thumb\.png\#(.+)$/, '$1');
			$(img).attr('src', thumb_src);

			// Durée.
			if (d > 0)
			{
				var c = function(d) { return Math.round(d).toString().padStart(2, '0'); };
				var duration = c(d/3600) + ':' + c(d/60%60) + ':' + c(d%60);
				var duration_short = c(d/60%60) + ':' + c(d%60);
				$('#videoduration_' + id).text(d >= 3600 ? duration : duration_short);
			}

			// Attributs de la vidéo (preview).
			var preview_maxsize = 400;
			var preview_w = w, preview_h = h;
			if (w > preview_maxsize || h > preview_maxsize)
			{
				if (w < h)
				{
					preview_w = Math.round((preview_maxsize / h) * w);
					preview_h = preview_maxsize;
				}
				else
				{
					preview_h = Math.round((preview_maxsize / w) * h);
					preview_w = preview_maxsize;
				}
			}
			$('video[data-video-id="' + id + '"]')
				.attr('poster', thumb_src)
				.attr('width', preview_w).attr('height', preview_h);

			// Grid.
			if ($('#obj_grid_container').length)
			{
				// Dimensions.
				if (w > 0 && h > 0)
				{
					$('#obj_grid_container ' + img)
						.attr('data-width', w)
						.attr('data-height', h)
						.attr('data-preview-width', preview_w)
						.attr('data-preview-height', preview_h);
					$('#obj_panel_infos[data-id="' + id + '"] #obj_panel_stats_size span')
						.text(w + ' x ' + h + ' ' + l10n_pixels);
				}

				// Durée.
				if (d > 0)
				{
					$('#obj_panel_infos[data-id="' + id + '"] #obj_panel_stats_duration span')
						.text(duration);
				}
			}
		}
	}

	insert_video(0, 2);
};