<!DOCTYPE html>
<html lang="<?php echo $tpl['lang']; ?>" class="nojs"<?php if ($tpl['user']['admin']) : ?> id="is_admin"<?php endif; ?>>

<head>
	<title><?php echo $tpl['page_title'](); ?></title>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width">
<?php if (!empty($tpl['meta_description'])) : ?>
	<meta name="description" content="<?php echo $tpl['meta_description']; ?>">
<?php endif; ?>
<?php if (!empty($tpl['canonical'])) : ?>
	<link rel="canonical" href="<?php echo $tpl['canonical']; ?>">
<?php endif; ?>
	<link rel="stylesheet" id="style_clear" type="text/css" media="screen" title="style" href="<?php echo $tpl['gallery']['template']['path'](); ?>/style/style.css?<?php echo $tpl['version_key']; ?>">
<?php if (!empty($tpl['diaporama'])) : ?>
	<link rel="stylesheet" type="text/css" media="screen" title="style" href="<?php echo $tpl['gallery']['template']['path'](); ?>/style/diaporama.css?<?php echo $tpl['version_key']; ?>">
<?php endif; ?>
<?php include_once(__DIR__ . '/php/custom.php'); ?>
<?php if (!empty($tpl['rss']['items'])) : ?>
	<link rel="alternate" type="application/rss+xml" title="<?php echo $tpl['rss']['items']['title']; ?>" href="<?php echo $tpl['rss']['items']['link']; ?>">
<?php endif; ?>
<?php if (!empty($tpl['rss']['comments'])) : ?>
	<link rel="alternate" type="application/rss+xml" title="<?php echo $tpl['rss']['comments']['title']; ?>" href="<?php echo $tpl['rss']['comments']['link']; ?>">
<?php endif; ?>
<?php if ($tpl['geolocation']) : ?>
	<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin="">
	<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=" crossorigin=""></script>
<?php endif; ?>
	<script type="text/javascript" src="<?php echo $tpl['gallery']['path']; ?>/js/jquery/jquery.js?<?php echo $tpl['version_key']; ?>"></script>
<?php if ($tpl['user']['admin']) : ?>
	<script type="text/javascript" src="<?php echo $tpl['gallery']['path']; ?>/js/iro.js?<?php echo $tpl['version_key']; ?>"></script>
<?php endif; ?>
<?php if (!empty($tpl['video_captures'])) : ?>
	<script type="text/javascript" src="<?php echo $tpl['gallery']['path']; ?>/js/videocaptures.js?<?php echo $tpl['version_key']; ?>"></script>
<?php endif; ?>
<?php if (!empty($tpl['diaporama'])) : ?>
	<script type="text/javascript" src="<?php echo $tpl['gallery']['path']; ?>/js/diaporama.js?<?php echo $tpl['version_key']; ?>"></script>
<?php endif; ?>
<?php if ($_GET['section'] == 'user-upload') : ?>
	<script type="text/javascript" src="<?php echo $tpl['gallery']['path']; ?>/js/upload.js?<?php echo $tpl['version_key']; ?>"></script>
<?php endif; ?>
<?php if ($tpl['theme']['user_style_change'] || $tpl['user']['admin']) : ?>
	<script type="text/javascript" src="<?php echo $tpl['gallery']['template']['path'](); ?>/js/theme.js?<?php echo $tpl['version_key']; ?>"></script>
<?php endif; ?>
	<script type="text/javascript" src="<?php echo $tpl['gallery']['template']['path'](); ?>/js/gallery.js?<?php echo $tpl['version_key']; ?>"></script>
	<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
	var anticsrf = "<?php echo $tpl['anticsrf'](); ?>";
<?php if (!empty($tpl['video_captures'])) : ?>
	var captures = [];
<?php foreach ($tpl['video_captures'] as $i) : ?>
	captures.push({
		hash: '<?php echo $i['hash']; ?>',
		key: '<?php echo $i['key']; ?>',
		id: '<?php echo $i['id']; ?>',
		path: '<?php echo $i['path']; ?>'
	});
<?php endforeach; ?>
<?php endif; ?>
	var gallery_path = '<?php echo $tpl['gallery']['path']; ?>';
	var page = <?php echo (int) $_GET['page']; ?>;
	var q = "<?php echo $_GET['q']; ?>";
	var q_pageless = '<?php echo $_GET['q_pageless']; ?>';
	var style_dark = '<?php echo $style_dark; ?>';
<?php if ($tpl['theme']['user_style_change'] || $tpl['user']['admin']) : ?>
	var theme_banners_dir = '<?php echo $tpl['theme']['banners_dir']; ?>';
	var theme_background_dir = '<?php echo $tpl['theme']['background_dir']; ?>';
	var theme_style = '<?php echo $tpl['theme']['style']; ?>';
	var theme_textures_dir = '<?php echo $tpl['theme']['textures_dir']; ?>';
	var theme_textures_json = <?php echo $tpl['theme']['textures_json']; ?>;
<?php endif; ?>
	var user_style = '<?php echo $tpl['theme']['user_style']; ?>';
	var user_style_change = <?php echo (int) $tpl['theme']['user_style_change']; ?>;
	var user_style_params_json = <?php echo $tpl['theme']['user_style_change'] ? $tpl['theme']['params_json'] : '{}'; ?>;
<?php if (!empty($tpl['diaporama'])) : ?>
	var diaporama;
	var diaporama_item_id = 0;
	var diaporama_options = <?php echo json_encode($tpl['diaporama_options']); ?>;
	var diaporama_position = <?php echo $tpl['diaporama_position']; ?>;
	var diaporama_query = "<?php echo $tpl['diaporama_query']; ?>";
	var diaporama_thumb_size = "<?php echo $diaporama_thumb_size = $tpl['diaporama_carousel_thumbs_ratio'] == 'square' ? '161x161' : '151'; ?>";
	var diaporama_key = ["<?php echo $tpl['diaporama_key']($diaporama_thumb_size); ?>"];
<?php endif; ?>
	</script>

<?php $head = __DIR__ . '/custom/head.tpl.php'; if (file_exists($head)) : ?><?php include_once($head); ?><?php endif; ?>
</head>

<body id="section_<?php echo str_replace('-', '_', $_GET['section']); ?>" <?php if ($body_class) : ?>class="<?php echo implode(' ', $body_class); ?>"<?php endif; ?>>

<div id="gallery" data-auth="<?php echo (int) $tpl['user']['auth']; ?>" class="<?php echo $gallery_size; ?>">
<div id="gallery_inner">
	<header class="<?php echo $header_class; ?><?php if ($tpl['users']) : ?> user<?php endif; ?>">
		<div id="header_top">
<?php if (($display_menu || $tpl['user']['admin']) && (($tpl['user']['auth'] && $tpl['config']('users_only_members')) || !$tpl['config']('users_only_members'))) : ?>
			<a data-option-display="menu" id="menu_link" href="javascript:;"<?php if ($display_menu) : ?> class="show"<?php endif; ?>>&#xe966;</a>
<?php endif; ?>
			<div id="title">
<?php if ($title = $tpl['gallery']['title']()) : ?>
				<h1><a href="<?php echo $tpl['link'](); ?>"><?php echo $title; ?></a></h1>
<?php endif; ?>
			</div>
<?php if ($tpl['users']) : ?>
			<div id="user_links">
<?php if ($tpl['user']['auth']) : ?>
				<a class="box_arrow_link box_arrow_custom" data-box="user_menu" href="<?php echo $tpl['link']('user/' . $tpl['user']['id']); ?>"><img alt="<?php echo __('Avatar'); ?>" src="<?php echo $tpl['user']['avatar_source']; ?>"></a>
				<ul class="box_arrow box_arrow_small_screen" id="user_menu">
					<li id="user_login"><a href="<?php echo $tpl['link']('user/' . $tpl['user']['id']); ?>"><?php echo $tpl['user']['nickname']; ?></a></li>
					<li id="user_avatar"><a tabindex="-1" href="<?php echo $tpl['link']('user/' . $tpl['user']['id']); ?>"><img alt="<?php echo __('Avatar'); ?>" src="<?php echo $tpl['user']['avatar_source']; ?>"></a></li>
					<li id="user_logout"><a href="<?php echo $tpl['link']('logout'); ?>"><?php echo __('Déconnexion'); ?></a></li>
				</ul>
<?php else : ?>
				<a class="box_arrow_link box_arrow_custom" data-box="user_menu" href="javascript:;"><img alt="<?php echo __('Avatar'); ?>" src="<?php echo $tpl['user']['avatar_source']; ?>"></a>
				<ul class="box_arrow box_arrow_small_screen" id="user_menu">
<?php if ($tpl['config']('users_registration')) : ?>
					<li id="user_register"><a href="<?php echo $tpl['link']('register'); ?>"><?php echo __('Créer un compte'); ?></a></li>
<?php endif; ?>
					<li id="user_avatar"><a data-box-name="box_login" href="<?php echo $tpl['link']('login'); ?>"><img alt="<?php echo __('Avatar'); ?>" src="<?php echo $tpl['user']['avatar_source']; ?>"></a></li>
					<li id="user_connection"><a data-box-name="box_login" href="<?php echo $tpl['link']('login'); ?>"><?php echo __('Connexion'); ?></a></li>
				</ul>
<?php endif; ?>
			</div>
<?php endif; ?>
<?php if ($tpl['theme']['user_style_change'] || $tpl['user']['admin']) : ?>
			<div <?php if ($tpl['theme']['user_style_change']) : ?>class="active" <?php endif; ?>data-style="<?php if ($tpl['theme']['user_style'] == 'dark') : ?>clear<?php else : ?>dark<?php endif; ?>" id="user_style_large"><a href="javascript:;"><?php if ($tpl['theme']['user_style'] == 'dark') : ?>&#xe902;<?php else : ?>&#xe908;<?php endif; ?></a></div>
<?php endif; ?>
		</div>
<?php if (($display_menu || $tpl['user']['admin']) && (($tpl['user']['auth'] && $tpl['config']('users_only_members')) || !$tpl['config']('users_only_members'))) : ?>
		<div id="menu" data-option-display="menu"<?php if ($display_menu) : ?> class="show"<?php endif; ?>>
			<nav>
				<ul>
<?php if ($display_menu_home || $tpl['user']['admin']) : ?>
					<li data-option-display="menu_home" id="menu_home_icon" class="icon<?php if ($display_menu_home) : ?> show<?php endif; ?>"><a title="<?php echo __('Accueil'); ?>" href="<?php echo $tpl['link'](); ?>"><span>&#xe906;</span></a></li>
<?php endif; ?>
					<li id="menu_gallery" class="<?php if (!empty($tpl['categories_browse'])) : ?>browse<?php endif; ?><?php echo (in_array($_GET['section'], ['album', 'category', 'item'])) ? ' current' : ''; ?>"><a<?php if (!empty($tpl['categories_browse'])) : ?> class="box_arrow_link" data-box="browse"<?php endif; ?> href="<?php echo $tpl['gallery']['path']; ?>/"><?php echo __('Galerie'); ?></a></li>
<?php foreach ($tpl['menu_pages'] as &$i) : ?>
					<li id="menu_<?php echo $i['name']; ?>"<?php echo ($i['current']) ? ' class="current"' : ''; ?>><a href="<?php echo $i['link']; ?>"><?php echo $i['title']; ?></a></li>
<?php endforeach; ?>
<?php if ($tpl['config']('search')) : ?>
					<li id="menu_search"<?php echo (substr($_GET['section'], 0, 6) == 'search') ? ' class="current"' : ''; ?>><a href="<?php echo $tpl['link']('search'); ?>"><?php echo __('Recherche'); ?></a></li>
					<li id="menu_search_icon" class="icon<?php echo (substr($_GET['section'], 0, 6) == 'search') ? ' current' : ''; ?>"><a title="<?php echo __('Recherche'); ?>" class="box_arrow_link" data-box="search" href="<?php echo $tpl['link']('search'); ?>"><span>&#xe986;</span></a></li>
<?php endif; ?>
				</ul>
			</nav>
		</div>
<?php endif; ?>
	</header>
	<div id="content">

		<main>
<?php include($tpl['template']['file']); ?>
		</main>

<?php if (!empty($tpl['category']['stats']) || !empty($tpl['category']['tags'])
	   || !empty($tpl['links']) || !empty($tpl['users_online']) || !empty($tpl['random_item'])) : ?>
<?php include('bottom.tpl.php'); ?>
<?php endif; ?>

<?php if (!empty($tpl['categories_browse'])) : ?>
		<div id="browse" class="box_arrow" data-levels="<?php echo $tpl['categories_browse_levels']; ?>" data-subcats="<?php echo $tpl['categories_browse_subcats']; ?>">
			<div id="browse_inner">
				<p id="browse_search" class="field"><input name="search" type="text"></p>
				<ul tabindex="-1">
					<?php foreach ($tpl['categories_browse'] as &$i) : ?><?php if ($i['node'] == 'content') : $class = $i['level'] > 1 ? [] : ['v']; foreach (['current', 'locked', 'unlocked'] as &$c) { if ($i[$c]) { $class[] = $c[0]; } }; ?><li id="<?php echo implode('', $class); ?>:<?php echo $i['level']; ?>{<?php echo $i['id']; ?>}<?php echo $i['parents']; ?>"><?php if ($i['subcats'] || $i['id'] == 1) : ?><i>+</i><?php endif; ?><a href="<?php echo isset($_GET['filter']) ? $i['link'] : $i['link_urlname']; ?>"<?php if ($i['locked']) : ?> data-box-name="box_password"<?php endif; ?>><b><?php echo $i['title']; ?></b><?php if ($tpl['categories_browse_count'] && $i['count']) : ?><i><?php echo L10N::formatNumber($i['count']); ?></i><?php endif; ?></a></li><?php endif; ?><?php endforeach; ?>

				</ul>
<?php if ($tpl['categories_browse_levels'] > 1) : ?>
				<p id="browse_path"><span>&nbsp;</span></p>
<?php endif; ?>
			</div>
		</div>
<?php endif; ?>

<?php if ($tpl['search']) : ?>
		<div id="search" class="box_arrow">
			<form action="<?php echo $tpl['current_url_pageless']; ?>" method="post">
				<input required name="search_query" maxlength="68" type="text" value="<?php echo $tpl['search']['query'] ?? ''; ?>">
				<input name="anticsrf" type="hidden" value="<?php echo $tpl['anticsrf'](); ?>">
				<input class="button" type="submit" value="<?php echo __('Chercher'); ?>">
			</form>
<?php if ($tpl['search_advanced']) : ?>
			<a href="<?php echo $tpl['link']('search-advanced'); ?>"><?php echo __('Recherche avancée'); ?></a>
<?php endif; ?>
		</div>
<?php endif; ?>

	</div>
</div>
<footer>
<?php if ($tpl['lang_switch']) : ?>
	<p id="footer_lang">
		<a href="<?php echo $tpl['link']('language'); ?>"><span>&#xe900;</span><?php echo $tpl['lang_switch'][$tpl['lang']]['name']; ?></a>
	</p>
	<div id="lang_switch">
		<ul>
<?php foreach ($tpl['lang_switch'] as $i) : ?>
			<li<?php if ($i['code'] == $tpl['lang']) : ?> class="current"<?php endif; ?>>
				<a href="javascript:;" data-code="<?php echo $i['code']; ?>">
					<span>[<?php echo $i['code']; ?>]</span>
					<?php echo $i['name']; ?>
				</a>
			</li>
<?php endforeach; ?>
		</ul>
	</div>
<?php endif; ?>
<?php if ($tpl['footer_text']) : ?>
	<p id="footer_text"><?php echo nl2br(HTML::decode($tpl['footer_text'])); ?></p>
<?php endif; ?>
<?php if (CONF_EXEC_TIME) : ?>
	<p id="footer_time"><?php echo $tpl['time'](); ?></p>
<?php endif; ?>
	<p id="footer_system">
		<?php printf(__('Propulsé par %s'), '<a class="ex" href="' . $tpl['app']['website'] . '">' . $tpl['app']['name'] . '</a>'); ?><?php if ($tpl['admin']['link']) : ?> - <a href="<?php echo $tpl['admin']['path']; ?>/">admin</a><?php endif; ?>
	</p>
</footer>

<?php if ($tpl['selection']) : ?><?php include_once(__DIR__ . '/selection.tpl.php'); ?><?php endif; ?>

<?php if ($tpl['user']['admin']) : ?><?php include_once(__DIR__ . '/theme_options.tpl.php'); ?><?php endif; ?>

<div id="debug">
<?php $tpl['print']('logs'); ?>
<?php $tpl['print']('errors'); ?>
<?php $tpl['print']('sql'); ?>
</div>
</div>

<?php if ($tpl['users'] && !$tpl['user']['auth']) : ?>
<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
document.getElementById('content').insertAdjacentHTML('afterend',
'<div id="box_login" class="box_outer" data-box-large-screen="1">\
	<div class="box_inner">\
		<div class="box box_center">\
			<ul class="box_menu">\
				<li class="current"><a data-box-page-id="box_login_page" href="javascript:;"><span>&#xe971;<\/span><?php echo $tpl['php2js'](__('Connexion')); ?><\/a><\/li>\
			<\/ul>\
			<div id="box_login_page" class="box_page">\
				<form>\
					<div class="box_content">\
						<p class="field">\
							<label for="login_username"><?php echo $tpl['php2js'](__('Nom d\'utilisateur :')); ?><\/label>\
							<input required id="login_username" name="login" type="text" maxlength="<?php echo User::COLUMNS_LENGTH_MAX['login']; ?>" class="focus">\
						<\/p>\
						<p class="field">\
							<label for="login_password"><?php echo $tpl['php2js'](__('Mot de passe :')); ?><\/label>\
							<input required data-password-view="1" id="login_password" name="password" type="password" maxlength="<?php echo User::COLUMNS_LENGTH_MAX['password']; ?>">\
						<\/p>\
						<p class="field checkbox">\
							<input<?php if ($tpl['remember']) : ?> checked<?php endif; ?> id="login_remember" name="remember" type="checkbox">\
							<label for="login_remember"><?php echo $tpl['php2js'](__('Rester connecté')); ?><\/label>\
						<\/p>\
						<p id="connection_forgot" class="field">\
							<a href="<?php echo $tpl['link']('forgot-password'); ?>"><?php echo $tpl['php2js'](__('Mot de passe oublié')); ?><\/a>\
						<\/p>\
					<\/div>\
					<div class="box_buttons">\
						<input class="button" name="submit" value="<?php echo $tpl['php2js'](__('Valider')); ?>" type="submit">\
						<input data-box-close="1" class="button" name="cancel" value="<?php echo $tpl['php2js'](__('Annuler')); ?>" type="button">\
					<\/div>\
				<\/form>\
			<\/div>\
		<\/div>\
	<\/div>\
<\/div>');
</script>
<?php endif; ?>

<script nonce="<?php echo CSP_NONCE; ?>" type="text/javascript">
document.getElementById('content').insertAdjacentHTML('afterend',
'<div id="box_password" class="box_outer" data-box-large-screen="1">\
	<div class="box_inner">\
		<div class="box box_center">\
			<ul class="box_menu">\
				<li class="current"><a data-box-page-id="box_password_page" href="javascript:;"><span>&#xe98d;<\/span><?php echo $tpl['php2js'](__('Mot de passe')); ?><\/a><\/li>\
			<\/ul>\
			<div id="box_password_page" class="box_page">\
				<form>\
					<div class="box_content">\
						<p class="field">\
							<label for="cat_password"><?php echo $tpl['php2js'](__('Veuillez entrer le mot de passe pour accéder à cette partie de la galerie :')); ?><\/label>\
							<input required data-password-view="1" size="40" maxlength="128" type="password" id="cat_password" name="password" class="focus">\
						<\/p>\
						<p class="field checkbox">\
							<input<?php if ($tpl['remember']) : ?> checked<?php endif; ?> id="cat_remember" name="remember" type="checkbox">\
							<label for="cat_remember"><?php echo $tpl['php2js'](__('Se souvenir de moi ?')); ?><\/label>\
						<\/p>\
					<\/div>\
					<div class="box_buttons">\
						<input class="button" name="submit" value="<?php echo $tpl['php2js'](__('Valider')); ?>" type="submit">\
						<input data-box-close="1" class="button" name="cancel" value="<?php echo $tpl['php2js'](__('Annuler')); ?>" type="button">\
					<\/div>\
				<\/form>\
			<\/div>\
		<\/div>\
	<\/div>\
<\/div>');
</script>

<div id="small_screen"></div>

</body>

</html>