'use strict';

/**
 * @license http://www.gnu.org/licenses/gpl.html
 * @link http://www.igalerie.org/
 */



/**
 * Force un rechargement du diaporama.
 *
 */
function diaporama_reload()
{
	if (typeof diaporama == 'object' && diaporama_item_id == item_id)
	{
		diaporama = null;
	}
}

/**
 * Rechargement de la page.
 *
 */
function page_reload()
{
	document.location = document.location.href.replace(document.location.hash, '');
}

/**
 * Décode les entités HTML.
 *
 */
function htmldecode(str)
{
	return new DOMParser().parseFromString(str, 'text/html').documentElement.textContent;
}

/**
 * Modifie le nom d'URL d'un objet dans l'URL complète.
 *
 */
function change_urlname(url, object_url)
{
	return url.replace(/(.+\/\d+\-)[^/#]+(\#.+)?/, '$1' + object_url + '$2');
}



/**
 * Général.
 *
 */
jQuery(function($)
{
	var ajax = false;

	// Ancre.
	var hash = $(location).attr('hash');
	if (hash)
	{
		window.location = hash;
	}

	// Vidéos.
	$('video').prop('volume', 0.5);

	// Lien pour montrer / cacher un élément.
	$('body').on('click', '.showhide', function()
	{
		var sel = $(this).attr('rel');
		if ($(sel).is(':hidden'))
		{
			$(sel).show();
		}
		else
		{
			$(sel).hide();
		}
		return false;
	});

	// Indique que Javascript est activé.
	$('html.nojs').removeClass('nojs').addClass('js');

	// Réinitialisation des formulaires.
	$('form').trigger('reset');

	// Changement de page.
	$('.pages form').submit(function()
	{
		var page = $(this).find('input[name="page"]').val();
		if (page.match(/^\d{1,12}$/) && !page.match(/^0/)
		&& parseInt(page) <= parseInt($(this).find('.count').text()))
		{
			window.location.href = gallery_path + '/'
				+ q_pageless + '/page/' + page + '#top';
		}
		return false;
	});

	// Boutons de sélection de fichier.
	$('input[type="file"]').change(function(e)
	{
		if (e.target.value)
		{
			var filename = e.target.value.replace(/^.*?([^/\\]+)$/, '$1');
			var id = $(this).attr('id');
			$('#' + id + ' + label').text(filename);
		}
	});

	// Édition des dates.
	$('.dt_now').click(function()
	{
		var dt = new Date();
		$(this).parents('p').find('.dt_year').val(dt.getFullYear());
		$(this).parents('p').find('.dt_month').val(('0' + (dt.getMonth()+1)).slice(-2));
		$(this).parents('p').find('.dt_day').val(('0' + dt.getDate()).slice(-2));
		$(this).parents('p').find('.dt_hour').val(('0' + dt.getHours()).slice(-2));
		$(this).parents('p').find('.dt_minute').val(('0' + dt.getMinutes()).slice(-2));
		$(this).parents('p').find('.dt_second').val(('0' + dt.getSeconds()).slice(-2));
		return false;
	});
	$('.dt_reset').click(function()
	{
		$(this).parents('p').find('input').val('');
		return false;
	});

	// Confirmation de suppression.
	$('form').submit(function()
	{
		if ($(this).attr('data-confirm-delete'))
		{
			return confirm(htmldecode(confirm_delete));
		}
	});

	// Ajout d'un bouton permettant de visionner les mots de passe en clair.
	$('input[data-password-view]').each(function()
	{
		$(this).wrapAll('<span class="password_container">');
		$(this).after('<span class="password_view"><a href="javascript:;">&#xe9ce;</a></span>');
		if ($(this).attr('autofocus'))
		{
			$(this).focus();
		}
	});
	$('body').on('click', '.password_view', function()
	{
		var e = $(this).parents('.password_container').find('input');
		if (e.attr('type') == 'text')
		{
			e.attr('type', 'password');
			$(this).find('a').html('&#xe9ce;');
		}
		else
		{
			e.attr('type', 'text');
			$(this).find('a').html('&#xe9d1;');
		}
		e.focus();

		return false;
	});

	// Déconnexion.
	$('#user_logout a,#link_logout a').click(function()
	{
		$.post(
			gallery_path + '/ajax.php',
			{
				anticsrf: anticsrf,
				section: 'logout',
				id: $(this).attr('data-id') || 0,
				from_admin: 0
			},
			function(r)
			{
				if (typeof r != 'object' || r === null)
				{
					return;
				}
				switch (r.status)
				{
					case 'error' :
						alert('error: ' + r.message);
						break;

					case 'success' :
						window.location = r.redirect;
						break;
				}
			},
			'json'
		);

		return false;
	});

	// Favoris.
	if (typeof item_id !== 'undefined' && $('#link_favorites').length)
	{
		favorites_update = function(action, r)
		{
			if (action == 'add')
			{
				$('#item').addClass('favorite');
				$('#link_favorites').removeClass('add').addClass('remove');
				$('#link_favorites a').attr('title', favorites_remove_text);
			}
			if (action == 'remove')
			{
				$('#item').removeClass('favorite');
				$('#link_favorites').removeClass('remove').addClass('add');
				$('#link_favorites a').attr('title', favorites_add_text);
			}
			$('#item_favorites span:first').text(r.favorites_short);
		};
		$('#link_favorites a').click(function()
		{
			if (ajax)
			{
				return false;
			}
			ajax = true;

			var action = $('#item').hasClass('favorite') ? 'remove' : 'add';

			$.post(gallery_path + '/ajax.php',
			{
				anticsrf: anticsrf,
				section: 'favorites-' + action,
				item_id: item_id
			},
			function(r)
			{
				if (typeof r != 'object' || r === null)
				{
					return;
				}
				switch (r.status)
				{
					case 'error' :
						console.log('error: ' + r.message);
						break;

					case 'success' :
						favorites_update(action, r);
						if (q_pageless.match(/\/(user-)?favorites(\/\d+){1,2}$/)
						&& action == 'remove')
						{
							window.location = item_link;
						}
						diaporama_reload();
						break;
				}
				setTimeout(function(){ ajax = false; }, 500);
			}, 'json');

			return false;
		});
	}

	// Sélection.
	if ($('#item').length && $('#link_selection').length)
	{
		selection_update = function(action, r)
		{
			if (action == 'add')
			{
				$('#item').addClass('selection');
				$('#link_selection').removeClass('add').addClass('remove');
				$('#link_selection a').attr('title', selection_remove_text);
			}
			if (action == 'remove')
			{
				$('#item').removeClass('selection');
				$('#link_selection').removeClass('remove').addClass('add');
				$('#link_selection a').attr('title', selection_add_text);
			}
		};
		$('#link_selection a').click(function()
		{
			if (ajax)
			{
				return false;
			}
			ajax = true;

			var action = $('#item').hasClass('selection') ? 'remove' : 'add';

			var id = [];
			id.push(item_id);

			$.post(gallery_path + '/ajax.php',
			{
				anticsrf: anticsrf,
				section: 'selection',
				action: 'selection-' + action,
				id: id
			},
			function(r)
			{
				if (typeof r != 'object' || r === null)
				{
					return;
				}
				switch (r.status)
				{
					case 'error' :
						console.log('error: ' + r.message);
						break;

					case 'success' :
						selection_update(action, r);
						if (q_pageless.match(/\/selection(\/\d+)$/) && action == 'remove')
						{
							window.location = item_link;
						}
						diaporama_reload();
						break;
				}
				setTimeout(function(){ ajax = false; }, 500);
			}, 'json');

			return false;
		});
	}

	// Menu des langues.
	if ($('#lang_switch').is('div'))
	{
		var langs_box_open = false;
		var close_langs = function()
		{
			$('#lang_switch').css('display', 'none');
			langs_box_open = false;
		};
		$('#footer_lang a').click(function()
		{
			$('#lang_switch').css('display', 'flex');
			langs_box_open = true;
			return false;
		});
		$('#lang_switch').click(function()
		{
			close_langs();
		});
		$('#lang_switch ul').click(function(e)
		{
			e.stopPropagation();
		});
		$('#lang_switch li a').click(function()
		{
			$('main').append('<form id="form_lang" method="post">'
				+ '<input type="hidden" name="lang" value="' + $(this).attr('data-code') + '">'
				+ '<input type="hidden" name="anticsrf" value="' + anticsrf + '">'
				+ '</form>');
			$('#form_lang').submit();
			return false;
		});
		$(window).keyup(function(e)
		{
			if (langs_box_open && e.keyCode == 27)
			{
				close_langs();
			}
		});
	}

	// Gestion de l'aperçu.
	$('body').on('click', '.viewer', function()
	{
		var source = $(this).find('a').attr('href') || $(this).find('img').attr('src');
		if (!source || $('#viewer').length)
		{
			return false;
		}

		if ($(this).hasClass('large'))
		{
			$(this).removeClass('large');
			window.location = document.location.href.replace(document.location.hash, '') + '#top';
			$('#item_link').focus();
			return false;
		}
		var current_image_height = $(this).find('img').height();
		$(this).addClass('large');
		if ($(this).find('img').height() > (current_image_height + 85))
		{
			$(this).addClass('large');
			return false;
		}
		$(this).removeClass('large');

		var close = function()
		{
			$('#viewer').remove();
			window.location = document.location.href.replace(document.location.hash, '') + '#top';
			$('#item_link').focus();
		};

		var resize = function()
		{
			var margin = parseInt($('#viewer').css('paddingLeft')) * 2;
			$('#viewer').css({
				'width': ($(window).width() - margin) + 'px',
				'height': ($(window).height() - margin) + 'px'
			});
		};

		source += source.search(/\?/, source) == -1 ? '?' : '&';
		var html = '<div id="viewer"><img data-type="'
			+ $(this).find('img').attr('data-type') + '"'
			+ ' src="' + source + Math.random() + '"></div>';
		$('main').append(html);

		resize();

		$(window).resize(function()
		{
			if ($('#viewer').length)
			{
				resize();
			}
		});
		$(window).keyup(function(e)
		{
			if ($('#viewer').length && e.keyCode == 27)
			{
				close();
			}
		});

		$('body').on('click', '#viewer', close);

		if (!$(this).attr('href'))
		{
			$('#viewer img').bind('contextmenu', function()
			{
				return false;
			});
		}

		return false;
	});

	// Options de la recherche avancée.
	$('#search_options_link a').click(function()
	{
		var options = $('#search_options');
		if (options.is(':visible'))
		{
			options.hide();
			$('#search_options_link span').html('&#xf067;');
		}
		else
		{
			options.show();
			$('#search_options_link span').html('&#xf068;');
		}
		return false;
	});

	// Informations (aide contextuelle).
	$('.infos_icon').click(function()
	{
		var id = '#' + $(this).attr('data-id');
		if ($(id).is(':visible'))
		{
			$(id).hide();
		}
		else
		{
			$(id).show();
		}
		return false;
	});

	// On désactive le menu contextuel des vidéos
	// s'il y a interdiction de télécharger la vidéo.
	$('#item video').bind('contextmenu', function()
	{
		if ($(this).attr('controlsList') == 'nodownload')
		{
			return false;
		}
	});

	// Diaporama.
	$('#link_diaporama a').click(function()
	{
		if (!diaporama)
		{
			diaporama = new Diaporama(diaporama_query, $(this));
		}
		diaporama.start(diaporama_position, diaporama_options);

		return false;
	});

	// Démarrage automatique du diaporama au chargement de la page.
    if (new URL(window.location).hash == '#diapo')
    {
        $('#link_diaporama a').click();
    }

	// Captures vidéos.
	if (typeof captures !== 'undefined')
	{
		videocaptures(captures);
	}

	// Tri des tableaux.
	if ($('table.sorter').length)
	{
		let cellval = (tr, i) => tr.children[i].innerText;

		let compare = (i, asc) => (a, b) => ((v1, v2) => v1 !== '' && v2 !== ''
			&& !isNaN(v1) && !isNaN(v2) ? v1 - v2 : v1.toString().localeCompare(v2))
			(cellval(asc ? a : b, i), cellval(asc ? b : a, i));

		$('table.sorter th')
			.css('cursor', 'pointer')
			.click(function()
			{
				let table = $(this).parents('table');
				Array.from(table.find('tr:nth-child(n+2)'))
					.sort(compare($(this)[0].cellIndex, this.asc = !this.asc))
					.forEach(tr => table.append(tr));
			});
	}

	// Gestion du thème.
	if ($('#theme_template').length || user_style_change)
	{
		Theme();
	}
});



/**
 * Boîtes flottantes.
 *
 */
jQuery(function($)
{
	if (!$('*[data-box-name]').length)
	{
		return;
	}

	var box, box_ajax, box_button, box_cat_id, box_comment,
	    box_comment_id, box_name, box_page, box_report_timeout;
	var box_close = function(delay, setfocus, callback)
	{
		box_loading_stop();
		clearTimeout(box_report_timeout);
		box.hide('fade', delay, function()
		{
			$('#box_report').remove();
			if (setfocus)
			{
				box_button.focus();
			}
			box = undefined;
			if (typeof callback == 'function')
			{
				callback();
			}
		});
	};

	var box_comment_open = function()
	{
		var fields = '#edit_comment_author,#edit_comment_email,#edit_comment_website';
		if ($('div[data-comment-id="' + box_comment_id + '"]').attr('data-user-id') != 2)
		{
			$(fields).parent().hide();
		}
		else
		{
			$('#edit_comment_author').val(
				$('<input>').html(comments_edit[box_comment_id].user_name).text()
			);
			$('#edit_comment_email').val(
				$('<input>').html(comments_edit[box_comment_id].user_email).text()
			);
			$('#edit_comment_website').val(
				$('<input>').html(comments_edit[box_comment_id].user_website).text()
			);
			$(fields).parent().show();
		}
		$('#edit_comment_message').val(
			$('<input>').html(comments_edit[box_comment_id].message).text()
		);
	};

	$('*[data-box-name]').click(function()
	{
		box_button = $(this);
		box_name = $(this).attr('data-box-name');
		box = $('#' + box_name);
		if ((box.attr('data-box-large-screen') && $('#small_screen').is(':hidden'))
		 || !box.attr('data-box-large-screen'))
		{
			if (box.is(':visible'))
			{
				box_close(250, true);
			}
			else
			{
				/* Mot de passe de catégorie. */
				if (box_name == 'box_password')
				{
					box_cat_id = $(this).attr('data-id')
						?? $(this).parents('li').attr('id').split(/[\{\}]/)[1];
				}

				/* Édition des commentaires. */
				if (box_name == 'box_comment')
				{
					box_comment_id = $(this).parents('.comment').attr('data-comment-id');
					box_comment_open();
				}

				$('.box_outer').hide();

				box.show('fade', 250);
				box_page = box.find('.box_page:visible');
				if (box_page.find('.focus').length)
				{
					box_page.find('.focus').focus();
				}
				else
				{
					$('.box_menu a[data-box-page-id="' + box_page.attr('id') + '"]').focus();
				}
			}
			return false;
		}
	});

	$('body').on('click', '*[data-box-close]', function()
	{
		box_close(250, true);
		return false;
	});

	$('body').on('click', '*[data-box-page-id]', function()
	{
		if (box_page.attr('id') != $(this).attr('data-box-page-id'))
		{
			if (box_ajax)
			{
				return false;
			}

			clearTimeout(box_report_timeout);
			$('#box_report').remove();
			box_loading_stop();
		}
		box_page = $('#' + $(this).attr('data-box-page-id'));
		box.find('*[data-box-page-id]').parent().removeClass('current');
		$(this).parent().addClass('current');
		box.find('.box_page').hide();
		box_page.show().find('.focus').focus();

		return false;
	});

	$(window).keyup(function(e)
	{
		if (box && e.keyCode == 27)
		{
			box_page.find('*[data-box-close]').click();
		}
	});

	/* Requête ajax. */
	function box_ajax_request(params, callback)
	{
		if (box_ajax)
		{
			return;
		}
		box_loading_start();
		box_ajax = $.post(gallery_path + '/ajax.php', params, function(r)
		{
			if (r === null)
			{
				box_show_message('error', 'Null error.');
				return;
			}
			switch (r.status)
			{
				case 'error' :
				case 'info' :
				case 'success' :
					if (r.message)
					{
						box_show_message(r.status, r.message);
					}
					if (typeof callback == 'function')
					{
						callback(r);
					}
					break;

				default :
					box_show_message('error', 'Unknown error.');
					break;
			}
		}, 'json')
		.fail(function(r)
		{
			box_show_message('error', 'PHP error.');
			console.log(r.responseText);
		})
		.always(function()
		{
			box_ajax = false;
		});
	}

	/* Icône de chargement. */
	function box_loading_start()
	{
		if (!$('#box_loading').length)
		{
			box_page.find('.box_buttons input[type="submit"]').prop('disabled', true);
			box_page.find('.box_buttons').append('<span id="box_loading"></span>');
		}
	}
	function box_loading_stop()
	{
		box_page.find('.box_buttons input[type="submit"]:not(.disabled)')
			.prop('disabled', false);
		$('#box_loading').remove();
		if (box_ajax)
		{
			box_ajax.abort();
			box_ajax = false;
		}
	}

	/* Messages de rapport. */
	function box_report_remove()
	{
		$('#box_report').animate({'opacity': 0}, 250, function()
		{
			$('#box_report').remove();
			box_loading_stop();
		});
	}
	function box_show_message(type, text)
	{
		$('#box_loading').remove();
		box_page.find('.box_buttons').append('<div id="box_report"><span class="message_'
			+ type + '">' + text + '</span></div>');
		$('#box_report').css({'display': 'flex', 'opacity': 0});
		$('#box_report').animate({'opacity': 1}, 250);
		if (type != 'error')
		{
			box_report_timeout = setTimeout(box_report_remove, 2000);
		}
	}
	$('body').on('click', '#box_report', function()
	{
		clearTimeout(box_report_timeout);
		box_report_remove();
	});

	/* Édition de la catégorie : informations. */
	$('body').on('click', '#box_category_infos input[name="save"]', function()
	{
		if ($('#edit_category_title').val().trim() == '')
		{
			$('#edit_category_title').focus();
			return false;
		}

		var after = function(r)
		{
			if (r.title !== undefined)
			{
				if (category_id == 1)
				{
					$('#edit_category_title').val($('<input>').html(r.title).text());
					$('title, h1 a').html(r.title);
				}
				else
				{
					$('#edit_category_title').val($('<input>').html(r.title).text());
					$('#browse_inner .current a span,#breadcrumb .current').html(r.title);
					$('title').html(r.page_title);

					$('#breadcrumb a.current').attr('href',
						change_urlname($('#breadcrumb a.current').attr('href'), r.urlname));
					var url = new URL(window.location);
					window.history.pushState({}, '', change_urlname(url.href, r.urlname));
				}
			}
			if (r.description !== undefined)
			{
				$('#edit_category_desc').val($('<input>').html(r.description).text());
				if (page == 1)
				{
					$('#cat_desc').remove();
					if (r.description !== null)
					{
						var id = $('#pages_top').length
							? '#pages_top'
							: ($('#page_thumbs').length ? '#page_thumbs' : '#thumbs_cat');
						$(id).before('<div id="cat_desc" class="object_desc">'
							+ r.description_formated + '</div>');
					}
				}
			}
		};

		box_ajax_request({
			section: 'cat-edit',
			anticsrf: anticsrf,
			cat_id: category_id,
			title: $('#edit_category_title').val(),
			description: $('#edit_category_desc').val()
		}, after);

		return false;
	});

	/* Édition du fichier : mise à jour des informations sur la page */
	if ($('#box_item').length)
	{
		var box_item_filename = $('#edit_item_filename').val();
		item_update = function(r, diapo)
		{
			if (r.status == 'success' && !diapo)
			{
				diaporama_reload();
			}
			if (r.title !== undefined)
			{
				$('#edit_item_title').val($('<input>').html(r.title).text());
				$('#item_title').html(r.title);
				$('title').html(r.page_title);
				if ($('#item_title').length)
				{
					var url = new URL(window.location);
					window.history.pushState({}, '', change_urlname(url.href, r.urlname));
				}
			}
			if (r.filename !== undefined && box_item_filename != r.filename)
			{
				$('#edit_item_filename').val($('<input>').html(r.filename).text());
				if ($('#link_download a').length)
				{
					$('#link_download a').attr('href', r.download);
				}
				if ($('#item_link').hasClass('viewer'))
				{
					$('#item_link').attr('href', r.source);
				}
				if (r.is_video)
				{
					$('#item video').each(function()
					{
						this.pause();
						$(this).find('source').attr('src', r.source);
						this.load();
					});
				}
				else
				{
					$('#item img').attr('src', r.source);
				}
				box_item_filename = r.filename;
			}
			if (r.description !== undefined)
			{
				$('#edit_item_desc').val($('<input>').html(r.description).text());
				$('#item_description').remove();
				if (r.description !== null)
				{
					$('#item_columns').before('<div id="item_description" class="object_desc">'
						+ r.description_formated + '</div>');
				}
			}
			if (r.tags_list !== undefined)
			{
				$('#edit_item_tags').val(r.tags_list.join(', '));
			}
			if (r.tags !== undefined)
			{
				$('#item_tags').remove();
				if (r.tags.length)
				{
					var html = '<div id="item_tags"><h3 class="icon"><span>&#xf02c;</span> '
						+ item_text_tags + '</h3><ul>';
					for (var i in r.tags)
					{
						html += '<li><a href="' + r.tags[i].link + '">'
							+ r.tags[i].name + '</a></li>';
					}
					html += '</ul></div>';
					$('#item_left_inner').append(html);
				}
			}
		};
	}

	/* Édition du fichier : informations. */
	$('body').on('click', '#box_item_infos input[name="save"]', function()
	{
		if ($('#edit_item_title').val().trim() == '')
		{
			$('#edit_item_title').focus();
			return false;
		}
		if ($('#edit_item_filename').val().trim() == '')
		{
			$('#edit_item_filename').focus();
			return false;
		}

		box_ajax_request({
			section: 'item-edit',
			anticsrf: anticsrf,
			item_id: item_id,
			title: $('#edit_item_title').val(),
			filename: $('#edit_item_filename').val(),
			description: $('#edit_item_desc').val()
		}, item_update);

		return false;
	});

	/* Édition du fichier : tags. */
	$('body').on('click', '#box_item_tags input[name="save"]', function()
	{
		box_ajax_request({
			section: 'item-edit',
			anticsrf: anticsrf,
			item_id: item_id,
			tags: $('#edit_item_tags').val()
		}, item_update);

		return false;
	});

	/* Suppression du fichier. */
	$('body').on('click', '#box_item_delete input[name="delete"]', function()
	{
		if (confirm(htmldecode(item_text_confirm_delete)))
		{
			var after = function(r)
			{
				if (r.status == 'success')
				{
					alert(r.message);
					window.location = r.redirect;
				}
			};

			box_ajax_request({
				section: 'item-delete',
				anticsrf: anticsrf,
				item_id: item_id
			}, after);
		}

		return false;
	});

	/* Édition du commentaire : informations. */
	$('body').on('click', '#box_comment_infos input[name="save"]', function()
	{
		var member = $('div[data-comment-id="' + box_comment_id + '"] .comment_name a').length;

		if ($('#edit_comment_message').val().trim() == '')
		{
			$('#edit_comment_message').focus();
			return false;
		}

		if (!member)
		{
			if ($('#edit_comment_author').val().trim() == '')
			{
				$('#edit_comment_author').focus();
				return false;
			}
		}

		var after = function(r)
		{
			if (!member)
			{
				if (r.com_author !== undefined)
				{
					comments_edit[box_comment_id].user_name = r.com_author;
					$('#edit_comment_author').val($('<input>').html(r.com_author).text());
					$('div[data-comment-id="' + box_comment_id + '"] .comment_name')
						.html(r.com_author);
				}
				if (r.com_email !== undefined)
				{
					comments_edit[box_comment_id].user_email = r.com_email;
					$('#edit_comment_email').val($('<input>').html(r.com_email).text());
				}
				if (r.com_website !== undefined)
				{
					comments_edit[box_comment_id].user_website = r.com_website;
					$('#edit_comment_website').val($('<input>').html(r.com_website).text());
					$('div[data-comment-id="' + box_comment_id + '"] .comment_website')
						.remove();
					if (r.com_website)
					{
						var html = '<span class="comment_website">(<a href="'
							+ r.com_website + '">' + comment_text_website + '</a>)</span>';
						$('div[data-comment-id="' + box_comment_id + '"] .comment_author')
							.append(html);
					}
				}
			}
			if (r.com_message !== undefined)
			{
				comments_edit[box_comment_id].message = r.com_message;
				$('#edit_comment_message').val($('<input>').html(r.com_message).text());
				$('div[data-comment-id="' + box_comment_id + '"] .comment_message')
					.html(r.com_message_formated);
			}
		};

		if (member)
		{
			box_ajax_request({
				section: 'comment-edit',
				anticsrf: anticsrf,
				com_id: box_comment_id,
				com_message: $('#edit_comment_message').val()
			}, after);
		}
		else
		{
			box_ajax_request({
				section: 'comment-edit',
				anticsrf: anticsrf,
				com_id: box_comment_id,
				com_message: $('#edit_comment_message').val(),
				com_author: $('#edit_comment_author').val(),
				com_email: $('#edit_comment_email').val(),
				com_website: $('#edit_comment_website').val()
			}, after);
		}

		return false;
	});

	/* Suppression du commentaire. */
	$('body').on('click', '#box_comment_delete input[name="delete"]', function()
	{
		if (confirm(htmldecode(comment_text_confirm_delete)))
		{
			var after = function(r)
			{
				if (r.status == 'success')
				{
					alert(r.message);
					page_reload();
				}
			};

			box_ajax_request({
				section: 'comment-delete',
				anticsrf: anticsrf,
				com_id: box_comment_id
			}, after);
		}

		return false;
	});

	/* Suppression des favoris. */
	$('body').on('click', '#box_favorites_delete input[name="delete"]', function()
	{
		if (confirm(htmldecode(favorites_confirm_delete)))
		{
			var after = function(r)
			{
				if (typeof r != 'object' || r === null)
				{
					return;
				}
				if (r.message)
				{
					alert(r.message);
				}
				if (r.status == 'success')
				{
					window.location = r.redirect;
				}
			};

			box_ajax_request({
				section: 'favorites-remove-all',
				anticsrf: anticsrf,
				cat_id: category_id
			}, after);
		}

		return false;
	});

	/* Mot de passe de catégorie. */
	$('body').on('click', '#box_password input[name="submit"]', function()
	{
		if ($('#cat_password').val() == '')
		{
			$('#cat_password').focus();
			return false;
		}

		var after = function(r)
		{
			if (r.status == 'success')
			{
				window.location = r.url;
			}
			else
			{
				$('#cat_password').focus();
				box_report_timeout = setTimeout(box_report_remove, 4000);
			}
		};

		box_ajax_request({
			section: 'cat-password',
			anticsrf: anticsrf,
			password: $('#cat_password').val(),
			remember: $('#cat_remember').prop('checked') ? 1 : 0,
			cat_id: box_cat_id
		}, after);

		return false;
	});
	$('body').on('click', '#box_password *[data-box-close]', function()
	{
		$('#cat_password').val('');

		return false;
	});

	/* Connexion. */
	$('body').on('click', '#box_login input[name="submit"]', function()
	{
		if ($('#login_username').val() == '')
		{
			$('#login_username').focus();
			return false;
		}
		if ($('#login_password').val() == '')
		{
			$('#login_password').focus();
			return false;
		}

		var after = function(r)
		{
			if (r.status == 'success')
			{
				if ($('#section_new_password').length
				 || $('#section_register').length
				 || $('#section_validation').length)
				{
					document.location.href = gallery_path;
				}
				else
				{
					page_reload();
				}
			}
			else
			{
				$('#login_username').focus();
				box_report_timeout = setTimeout(box_report_remove, 4000);
			}
		};

		box_ajax_request({
			section: 'login',
			anticsrf: anticsrf,
			login: $('#login_username').val(),
			password: $('#login_password').val(),
			remember: $('#login_remember').prop('checked') ? 1 : 0
		}, after);

		return false;
	});
	$('body').on('click', '#box_login *[data-box-close]', function()
	{
		$('#login_username').val('');
		$('#login_password').val('');

		return false;
	});

	/* Émojis. */
	if ($('#box_emoji').length)
	{
		emojis.forEach(function(tabs)
		{
			var current = (tabs[0] == 'smileys_emotion') ? ' class="current"' : '';
			var menu = '<li' + current + '><a data-box-page-id="box_emoji_' + tabs[0]
				+ '" href="javascript:;" title="' + tabs[1] + '"><span class="emoji">'
				+ tabs[2] + '</span></a></li>';
			var tab = '<div id="box_emoji_' + tabs[0] + '" class="box_page">'
				+ '<form><div class="box_content">';
			tabs[3].forEach(function(code)
			{
				tab += '<a href="javascript:;" class="emoji">' + code + '</a>';
			});
			tab += '</div><div class="box_buttons"><input data-box-close="1" '
				+ 'class="button" name="cancel" value="'
				+ emojis_cancel_text + '" type="button"></div></form>';
			$('#box_emoji .box_menu').append(menu);
			$('#box_emoji .box').append(tab);
		});
		$('body').on('click', '#box_emoji .box_content .emoji', function()
		{
			var position = $('#message').prop('selectionStart');
			var msg = $('#message').val();
			var before = msg.substring(0, position);
			var after  = msg.substring(position, msg.length);

			$('#message').val(before + $(this).text() + after);
			$('#message').focus().prop('selectionEnd', position + 2);

			box_close(1, false);

			return false;
		});
	}

	/* Mode sélection. */
	if ($('#box_selection').length)
	{
		// Démarrer / arrêter le mode sélection.
		$('body').on('click', '#box_selection_button', function()
		{
			box_close(250, true, function()
			{
				if (selection_start)
				{
					selection_start = 0;
					$('#box_selection_button').attr('name', 'start').val(selection_start_text);
					$('.thumbs_items').removeClass('selectable');
				}
				else
				{
					selection_start = 1;
					$('#box_selection_button').attr('name', 'stop').val(selection_stop_text);
					$('.thumbs_items').addClass('selectable');
				}
				$.post(
					gallery_path + '/ajax.php',
					{
						anticsrf: anticsrf,
						section: 'cookie-prefs-write',
						param: 'selection_start',
						value: selection_start
					},
					function(){}, 'json'
				);
			});

			return false;
		});

		// Suppression de la sélection.
		$('body').on('click', '#box_selection_options input[name="delete"]', function()
		{
			$.post(
				gallery_path + '/ajax.php',
				{
					anticsrf: anticsrf,
					section: 'selection',
					action: 'selection-delete'
				},
				function(r)
				{
					if (r === null)
					{
						return;
					}
					switch (r.status)
					{
						case 'success' :
							$('.thumbs_items dl').removeClass('selected')
								.find('.selection_icon').html('&#xea53;');
							selection_update(r.stats);
							if (typeof diaporama == 'object')
							{
								diaporama = null;
							}
							break;

						case 'error' :
							alert('error: ' + r.message);
							break;
					}
				}, 'json'
			);
			return false;
		});

		// Télécharger.
		$('body').on('click', '#box_selection_download input[name="download"]', function()
		{
			if (selection_stats.count < 1)
			{
				return false;
			}
			$.ajax({
				type: 'POST',
				url: gallery_path + '/ajax.php',
				data:
				{
					anticsrf: anticsrf,
					section: 'selection',
					action: 'download'
				},
				xhrFields:
				{
					responseType: 'blob'
				},
				success: function(blob, status, xhr)
				{
					var filename = '';
					var disposition = xhr.getResponseHeader('Content-Disposition');
					if (disposition && disposition.indexOf('attachment') !== -1)
					{
						var matches = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/.exec(disposition);
						if (matches != null && matches[1])
						{
							filename = matches[1].replace(/['"]/g, '');
						}
					}
					if (typeof window.navigator.msSaveBlob !== 'undefined')
					{
						window.navigator.msSaveBlob(blob, filename);
					}
					else
					{
						var URL = window.URL || window.webkitURL;
						var download_url = URL.createObjectURL(blob);
						if (filename)
						{
							var a = document.createElement('a');
							if (typeof a.download === 'undefined')
							{
								window.location.href = download_url;
							}
							else
							{
								a.href = download_url;
								a.download = filename;
								document.body.appendChild(a);
								a.click();
							}
						}
						else
						{
							window.location.href = download_url;
						}
						setTimeout(function () { URL.revokeObjectURL(download_url); }, 100);
					}
				}
			});

			return false;
		});

		// Ajouter aux / retirer des favoris.
		$('body').on('click', '#box_selection_favorites input[name="save"]', function()
		{
			box_ajax_request({
				anticsrf: anticsrf,
				section: 'selection',
				action: 'favorites-'
					+ ($(this).parents('form').find('#selection_favorites_add').prop('checked')
					? 'add' : 'remove')
			},
			function(r)
			{
				if (r.status == 'success' && typeof diaporama == 'object')
				{
					diaporama = null;
				}
			});

			return false;
		});

		// Ajouter / supprimer des tags.
		$('body').on('change', '#selection_delete_all_tags', function()
		{
			if ($(this).is(':checked'))
			{
				$('#selection_delete_tags').parent().addClass('disabled');
				$('#selection_delete_tags').prop('disabled', true);
			}
			else
			{
				$('#selection_delete_tags').parent().removeClass('disabled');
				$('#selection_delete_tags').prop('disabled', false);
			}
		});
		$('body').on('click', '#box_selection_tags input[name="save"]', function()
		{
			var delete_all = $('#selection_delete_all_tags').prop('checked') ? 1 : 0;

			if (delete_all && !confirm(selection_all_tags_delete_text))
			{
				return false;
			}

			box_ajax_request({
				anticsrf: anticsrf,
				section: 'selection',
				action: 'tags',
				add: $('#selection_add_tags').val(),
				delete: $('#selection_delete_tags').val(),
				delete_all: delete_all
			},
			function(r)
			{
				if (r.status == 'success' && typeof diaporama == 'object')
				{
					diaporama = null;
				}
			});

			return false;
		});

		// Déplacer les fichiers.
		$('body').on('click', '#box_selection_move input[name="move"]', function()
		{
			box_ajax_request({
				anticsrf: anticsrf,
				section: 'selection',
				action: 'move',
				album_id: category_id
			},
			function(r)
			{
				if (r.status == 'success' && typeof diaporama == 'object')
				{
					diaporama = null;
				}
			});

			return false;
		});

		// Supprimer les fichiers.
		$('body').on('click', '#box_selection_delete input[name="delete"]', function()
		{
			if (!confirm(selection_items_delete_text))
			{
				return false;
			}
			box_ajax_request({
				anticsrf: anticsrf,
				section: 'selection',
				action: 'delete'
			},
			function(r)
			{
				selection_update(r.stats);
				if (r.status == 'success' && typeof diaporama == 'object')
				{
					diaporama = null;
				}
			});

			return false;
		});

		// Tout (dé)sélectionner.
		$('.box_selection_select_tool a').click(function()
		{
			var action = $(this).attr('class');
			var id = [];
			if (action == 'add')
			{
				$('#page_thumbs dl').each(function()
				{
					if (!$(this).hasClass('selected'))
					{
						$(this).addClass('selected').find('.selection_icon').html('&#xea52;');
						id.push(parseInt($(this).attr('data-id')));
					}
				});
			}
			else
			{
				$('#page_thumbs dl').each(function()
				{
					if ($(this).hasClass('selected'))
					{
						$(this).removeClass('selected').find('.selection_icon').html('&#xea53;');
						id.push(parseInt($(this).attr('data-id')));
					}
				});
			}
			if (!id.length)
			{
				return false;
			}
			$.post(
				gallery_path + '/ajax.php',
				{
					anticsrf: anticsrf,
					section: 'selection',
					action: 'selection-' + action,
					id: id
				},
				function(r)
				{
					if (r === null)
					{
						return;
					}
					switch (r.status)
					{
						case 'success' :
							selection_update(r.stats);
							if (typeof diaporama == 'object')
							{
								diaporama = null;
							}
							break;

						case 'error' :
							alert('error: ' + r.message);
							break;
					}
				}, 'json'
			);

			return false;
		});
	}
});



/**
 * Boîtes flottantes avec flèche.
 *
 */
jQuery(function($)
{
	// Gestion de l'affichage des box.
	var anim_speed = 150;
	var box_id, button;
	var box_open = false, menu_open = false;
	var timeout_box = [];
	var browse_height_margin = 100;
	var browse_resize = function()
	{
		if (box_id != 'browse')
		{
			return;
		}
		var available_height = $(window).height();
		var top = Math.round($('#menu_gallery')[0].getBoundingClientRect().bottom);
		var max_height = available_height - top - browse_height_margin;
		max_height = max_height > 600 ? 600 : max_height;
		$('#browse ul').css('maxHeight', max_height + 'px');
	};
	var clear_box = function()
	{
		if (box_open)
		{
			clearTimeout(timeout_box[box_id]);
		}
	};
	var close_box = function()
	{
		if ($('#small_screen').is(':hidden')
		 && $('#' + box_id).hasClass('box_arrow_small_screen'))
		{
			return;
		}
		if (box_id == 'browse')
		{
			$('#menu_gallery').removeClass('open');
		}
		$('#' + box_id).fadeOut(anim_speed);
		if (!$('.box_outer').is(':visible'))
		{
			button.focus();
		}

		box_open = false;
	};
	var hide_box = function()
	{
		if (!box_open || $('#' + box_id + ' input:first').is(':focus'))
		{
			return;
		}
		clear_box();
		timeout_box[box_id] = setTimeout(function(){ close_box(); }, 500);
	};
	var position_box = function()
	{
		if ($('.box_arrow_link[data-box="' + box_id + '"]').hasClass('box_arrow_custom'))
		{
			return;
		}

		var margin = 15;
		var box_width = $('#' + box_id).outerWidth();
		var top = button.offset().top + button.outerHeight() + 2;
		var left = (button.offset().left + (button.outerWidth() / 2)) - (box_width / 2);
		var previous_left = left;
		var arrow_width = $('#' + box_id + ' .arrow_top').outerWidth();
		var arrow_left = ((box_width / 2) - (arrow_width / 2));
		var gallery_left = $('#gallery').offset().left + margin;
		var gallery_right = gallery_left + $('#gallery').outerWidth() - (margin * 2);

		// Correction de la position si nécessaire.
		if (left < gallery_left)
		{
			left = gallery_left;
		}
		else if (left + box_width > gallery_right)
		{
			left = gallery_right - box_width;
		}
		arrow_left -= left - previous_left;

		$('#' + box_id + ' div[class^="arrow"]').css({left: arrow_left + 'px'});
		$('#' + box_id).css({
			top: (top + 17) + 'px',
			left: left + 'px',
			zIndex: 100
		});
	};
	$('.box_arrow_link').click(function()
	{
		box_open = false;
		if (box_id == 'browse')
		{
			$('#menu_gallery').removeClass('open');
		}
		box_id = $(this).attr('data-box');
		button = $(this);
		if (menu_open && box_id == 'browse' && !$('#small_screen').is(':hidden'))
		{
			return true;
		}
		for (var bi in timeout_box)
		{
			clearTimeout(timeout_box[bi]);
		}
		if ($('#' + box_id).is(':hidden'))
		{
			// Fermeture de toutes les boîtes.
			$('.box_arrow').hide();

			// Si le menu est ouvert, on le ferme.
			if (!$('#menu nav').is(':hidden'))
			{
				close_menu();
			}

			if (!$(this).hasClass('box_arrow_custom'))
			{
				// Flèche.
				if (!$('#' + box_id + ' .arrow_top').is('div'))
				{
					$('#' + box_id).prepend(
						'<div class="arrow_top_border"></div><div class="arrow_top"></div>'
					);
				}

				// Positionnement de la boîte.
				position_box();
			}

			// Ouverture de la boîte.
			$('#' + box_id).css({'opacity':0}).show();
			browse_resize();
			if (box_id == 'browse')
			{
				$('#menu_gallery').addClass('open');
				if ($('#browse_inner li[id*="c"]').length)
				{
					$('#browse_inner ul').scrollTop(0);
					var top = $('#browse_inner li[id*="c"]').offset().top;
					var height_current = $('#browse_inner li[id*="c"]').outerHeight();
					var height_list = $('#browse_inner ul').outerHeight();
					var n = Math.floor((height_list / height_current) / 3);
					$('#browse_inner ul').scrollTop(
						top - $('#browse_inner ul').offset().top - (n * height_current)
					);
				}
			}
			$('#' + box_id).animate({'opacity':1}, anim_speed, function()
			{
				$('#' + box_id + ' input:first').focus();
				box_open = true;
			});
		}
		else
		{
			close_box();
		}

		if ($('#' + box_id).length)
		{
			return false;
		}
	});
	$('.box_arrow,.box_arrow_link')
		.bind('mouseenter', function(){ clear_box(); })
		.bind('mouseleave', function(){ hide_box(); });
	$('.box_arrow').click(function(e)
	{
		if (box_open)
		{
			e.stopPropagation();
		}
	});
	$(window).click(function(e)
	{
		if (box_open)
		{
			close_box();
		}
	});
	$(window).keyup(function(e)
	{
		if (box_open && e.keyCode == 27)
		{
			close_box();
		}
	});
	$(window).resize(function()
	{
		if (!box_open)
		{
			return;
		}
		if (!$('#small_screen').is(':hidden'))
		{
			$('#' + box_id).hide();
			return;
		}
		position_box();
		browse_resize();
	});

	// Liste des catégories.
	if ($('#browse').is('div'))
	{
		// Barre de recherche.
		var escape = function(str)
		{
			str = str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
			str = str.replace(/\s+/g, '\\s+');
			str = str.replace(/[aäâàáåã]/gi, "[aäâàáåã]");
			str = str.replace(/[cç]/gi, "[cç]");
			str = str.replace(/[eéèêë]/gi, "[eéèêë]");
			str = str.replace(/[iïîìí]/gi, "[iïîìí]");
			str = str.replace(/[nñ]/gi, "[nñ]");
			str = str.replace(/[oöôóòõ]/gi, "[oöôóòõ]");
			str = str.replace(/[uüûùú]/gi, "[uüûùú]");
			str = str.replace(/[yÿý]/gi, "[yÿý]");
			return str;
		};
		var get_infos = function(e)
		{
			var i = e.attr('id').split(/[\{\}]/);
			return { level: i[0].replace(/\D+/, ''), id: i[1], parents: i[2] };
		};
		$('#browse_search input').val('');
		$('#browse_search').on('input', function()
		{
			var val = $(this).children('input').val();
			var regexp = new RegExp(escape(val), 'i');
			$('#browse li').hide();
			$('#browse li:not(:first-child)').each(function()
			{
				if (regexp.test($(this).find('b').text()))
				{
					$(this).css('display', 'flex');
				}
			});
			if (val === '')
			{
				$('#browse').removeClass('search');
				$('#browse li[id*="v"]').css('display', 'flex');
				$('#browse li:not([id*="v"])').css('display', 'none');
			}
			else
			{
				$('#browse').addClass('search');
			}
			if ($('#browse[data-subcats="1"]').length)
			{
				if (val === '')
				{
					$('#browse_path').hide();
					browse_height_margin = 100;
					browse_resize();
				}
				else
				{
					$('#browse_path').show();
					if ($('#browse_path').length)
					{
						browse_height_margin = 200;
					}
					browse_resize();
				}
			}
		});

		// Catégorie courante.
		if ($('#browse li[id*="c"]').length)
		{
			var cat_infos = get_infos($('#browse li[id*="c"]'));
			if (cat_infos.id > 1 && cat_infos.parents)
			{
				var id, parents = cat_infos.parents + '.' + cat_infos.id;
				while (parents.match(/\./))
				{
					parents = parents.replace(/\.\d+$/, '');
					id = parents.replace(/^.*\.(\d+)$/, '$1');
					$('#browse li[id$="}' + parents + '"]')
						.each(function()
						{
							$(this).attr('id', 'v' + $(this).attr('id').replace('v', ''));
						})
						.css('display', 'flex');
					if ((id == 1 && cat_infos.level > 1) || id != 1)
					{
						$('#browse li[id*="{' + id + '}"] > i').text('-');
					}
				}
			}
		}

		// Gestion des "+" et des "-".
		$('#browse li > i').click(function()
		{
			var i = get_infos($(this).parents('li'));
			var parents = i.parents + '.' + i.id;
			if (i.id == '1')
			{
				if ($(this).text() == '-')
				{
					$('#browse li:not([id*=":0{"]):not([id*=":1{"])')
						.each(function()
						{
							$(this).attr('id', $(this).attr('id').replace('v', ''));
						})
						.css('display', 'none');
					$('#browse li > i').text('+');
					$(this).text('+');
				}
				else
				{
					$('#browse li:not([id*=":0{"]):not([id*=":1{"])')
						.each(function()
						{
							$(this).attr('id', 'v' + $(this).attr('id').replace('v', ''));
						})
						.css('display', 'flex');
					$('#browse li > i').text('-');
					$(this).text('-');
				}
			}
			else
			{
				if ($(this).text() == '-')
				{
					$('#browse li[id*="}' + parents + '"]')
						.each(function()
						{
							$(this).attr('id', $(this).attr('id').replace('v', ''));
						})
						.css('display', 'none');
					$('#browse li[id*="}' + parents + '"] > i').text('+');
					$(this).text('+');
					if ($('#browse li:not([id*="{1}"]) > i:contains("-")').length < 1)
					{
						$('#browse li[id*="{1}"] > i').text('+');
					}
				}
				else
				{
					$('#browse li[id$="}' + parents + '"]')
						.each(function()
						{
							$(this).attr('id', 'v' + $(this).attr('id').replace('v', ''));
						})
						.css('display', 'flex');
					$(this).text('-');
					$('#browse li[id*="{1}"] > i').text('-');
				}
			}
			$('#browse_search input').focus();
		});

		// Chemin complet de la catégorie.
		$('#browse li').mouseenter(function()
		{
			var i = get_infos($(this));
			var path = [];
			if (i.id > 1)
			{
				i.parents.split('.').forEach(function(id)
				{
					path.push($('#browse li[id*="{' + id + '}"] b').text());
				});
			}
			path.push($(this).find('b').text());
			$('#browse_path span').text(path.join(' / '));
		});
		$('#browse li').mouseleave(function()
		{
			$('#browse_path').html('<span>&nbsp;</span>');
		});

		// Liens.
		$('#browse a').click(function()
		{
			$(this).attr('href', $(this).attr('href') + '#menu');
		});
	}

	// Gestion de l'affichage du menu principal.
	var close_menu = function()
	{
		if ($('#small_screen').is(':hidden'))
		{
			return;
		}
		menu_open = false;
		$('#menu nav').slideUp(anim_speed, function()
		{
			$('#menu_link').html('&#xe966;');
			$('main').removeClass('dark');
		});
		
	};
	$('#menu_link').click(function(e)
	{
		menu_open = false;
		if ($('#menu nav').is(':hidden'))
		{
			$('.box_arrow').hide();
			box_open = false;
			$('#menu nav').slideDown(anim_speed, function()
			{
				$('#menu_link').html('&#xe916;');
				$('main').addClass('dark');
				menu_open = true;
			});
		}
		else
		{
			close_menu();
		}

		e.stopPropagation();
		return false;
	});
	$('#menu nav').click(function(e)
	{
		if (menu_open)
		{
			e.stopPropagation();
		}
	});
	$(window).keyup(function(e)
	{
		if (!menu_open || $('#small_screen').is(':hidden'))
		{
			return;
		}
		if (e.keyCode == 27)
		{
			close_menu();
		}
	});
	$(window).click(function()
	{
		if (!menu_open || $('#small_screen').is(':hidden'))
		{
			return;
		}
		close_menu();
	});
});



/**
 * Mode sélection.
 *
 */
jQuery(function($)
{
	if (!$('#box_selection').length)
	{
		return;
	}

	if (!$('#item').length)
	{
		selection_update = function(stats)
		{
			var max = selection_max_items > 0
				? ' / <span>' + selection_max_items + '</span>'
				: '';
			$('#box_selection .selection_title > *').remove();
			$('#box_selection .selection_title').append(stats.count > 0
				? '<span class="selection_count"><a href="' + selection_link + '">'
					+ stats.count + '</a>' + max + '</span>'
				: '<span class="selection_count"><span>0</span>' + max + '</span>'
			);
			$('#selection_filesize').text(
				selection_filesize_text.replace('%s', stats.filesize_formated)
			);
			if (stats.count < 1)
			{
				$('#box_selection input.action').addClass('disabled').prop('disabled', true);
			}
			else
			{
				$('#box_selection input.action').removeClass('disabled').prop('disabled', false);
			}
			if (selection_max_items > 0 && stats.count >= selection_max_items)
			{
				$('.thumbs_items').addClass('selection_max');
			}
			else
			{
				$('.thumbs_items').removeClass('selection_max');
			}
			selection_stats = stats;
		};

		selection_update(selection_stats);
	}

	var selection_click = function(item_id)
	{
		var action;
		var id = [];
		var dl = $('dl[data-id="' + item_id + '"]');
		var selected = dl.hasClass('selected');
		id.push(item_id);

		if (!selected && selection_max_items > 0
		&& selection_stats.count >= selection_max_items)
		{
			return;
		}

		if (selected)
		{
			dl.removeClass('selected');
			dl.find('.selection_icon').html('&#xea53;');
			action = 'remove';
		}
		else
		{
			dl.addClass('selected');
			dl.find('.selection_icon').html('&#xea52;');
			action = 'add';
		}

		$.post(
			gallery_path + '/ajax.php',
			{
				anticsrf: anticsrf,
				section: 'selection',
				action: 'selection-' + action,
				id: id
			},
			function(r)
			{
				if (r === null)
				{
					return;
				}
				switch (r.status)
				{
					case 'success' :
						selection_update(r.stats);
						if (typeof diaporama == 'object' && diaporama_item_id == item_id)
						{
							diaporama = null;
						}
						break;

					case 'error' :
						alert('error: ' + r.message);
						break;
				}
			}, 'json'
		);
	};

	$('.thumbs_items dl:not(.selected) dt')
		.append('<span class="selection_icon">&#xea53;</span>');
	$('.thumbs_items dl.selected dt')
		.append('<span class="selection_icon">&#xea52;</span>');

	$('body').on('click', '.thumbs_items dt a', function()
	{
		if (selection_start && !$('#small_screen').is(':hidden'))
		{
			selection_click($(this).parents('dl').attr('data-id'));
			return false;
		}
		return true;
	});

	$('body').on('click', '.thumbs_items dt .selection_icon', function()
	{
		selection_click($(this).parents('dl').attr('data-id'));
		return false;
	});
});



/**
 * Carte du monde.
 *
 */
jQuery(function($)
{
	if (!$('#worldmap').length)
	{
		return;
	}

	var layer = $('#worldmap').attr('data-layer');
	var lat = $('#worldmap').attr('data-lat');
	var lng = $('#worldmap').attr('data-long');

	// Initialisation de la carte.
	var map = L.map('worldmap',
	{
		center: [lat, lng],
		zoom: $('#worldmap').attr('data-zoom')
	});
	var url = $('html').attr('lang') == 'fr'
		? 'https://{s}.tile.openstreetmap.fr/osmfr/{z}/{x}/{y}.png'
		: 'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png';
	var osm = L.tileLayer(url,
	{
		attribution: '<a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a>'
	});
	var esri = L.tileLayer('https://server.arcgisonline.com/ArcGIS/rest/'
		+ 'services/World_Imagery/MapServer/tile/{z}/{y}/{x}',
	{
		attribution: '<a href="https://www.esri.com/">Esri</a>'
	});
	if (layer == 'satellite')
	{
		esri.addTo(map);
	}
	else
	{
		osm.addTo(map);
	}
	var layers = {};
	layers[worldmap_map_text] = osm;
	layers[worldmap_satellite_text] = esri;
	L.control.layers(layers, {}, {position: 'bottomleft'}).addTo(map);

	// Marqueurs.
	var marker_cat = L.icon(
	{
		iconUrl: gallery_path + '/images/markers/marker-category.png',
		iconSize: [20, 34],
		iconAnchor: [10, 34],
		popupAnchor: [0, -39],
		shadowUrl: gallery_path + '/images/markers/marker-shadow.png',
		shadowSize: [54, 34],
		shadowAnchor: [27, 34]
	});
	var marker_item = L.icon(
	{
		iconUrl: gallery_path + '/images/markers/marker-item.png',
		iconSize: [20, 34],
		iconAnchor: [10, 34],
		popupAnchor: [0, -39],
		shadowUrl: gallery_path + '/images/markers/marker-shadow.png',
		shadowSize: [54, 34],
		shadowAnchor: [27, 34]
	});

	// Page des fichiers.
	if ($('#item_geolocation').length)
	{
		var marker = L.marker([lat, lng], {icon: marker_item}).addTo(map);
	}

	// Page "carte du monde".
	else
	{
		for (var i in markers)
		{
			// Fichiers.
			var items_count = Object.keys(markers[i].items).length;
			if (items_count)
			{
				var marker = L.marker(
					[markers[i].lat, markers[i].lng], {icon: marker_item}
				).addTo(map);
				var html_thumbs = '';
				var html_pagination = '';
				if (items_count > 1)
				{
					html_pagination = thumbs_pagination.replace(/\{count\}/g, items_count);
				}
				var num = 1;
				for (var n in markers[i].items)
				{
					html_thumbs += (markers[i].items[n].type == 'video'
						? thumbs_video : thumbs_image)
						.replace(/\{num\}/g, num++)
						.replace(/\{id\}/g, markers[i].items[n].id)
						.replace(/\{duration\}/g, markers[i].items[n].duration)
						.replace(/\{link\}/g, markers[i].items[n].link)
						.replace(/\{place\}/g, markers[i].items[n].place)
						.replace(/\{source\}/g, markers[i].items[n].source)
						.replace(/\{title\}/g, markers[i].items[n].title);
				}
				marker.bindPopup(thumbs_items
					.replace(/\{pagination\}/g, html_pagination)
					.replace(/\{thumbs\}/g, html_thumbs)
				);
			}

			// Catégories.
			var cat_count = Object.keys(markers[i].categories).length;
			if (cat_count)
			{
				var marker = L.marker(
					[markers[i].lat, markers[i].lng], {icon: marker_cat}
				).addTo(map);
				var html_thumbs = '';
				var html_pagination = '';
				if (cat_count > 1)
				{
					html_pagination = thumbs_pagination.replace(/\{count\}/g, cat_count);
				}
				var num = 1;
				for (var n in markers[i].categories)
				{
					html_thumbs += thumbs_image
						.replace(/\{num\}/g, num++)
						.replace(/\{id\}/g, markers[i].categories[n].id)
						.replace(/\{link\}/g, markers[i].categories[n].link)
						.replace(/\{source\}/g, markers[i].categories[n].source)
						.replace(/\{title\}/g, markers[i].categories[n].title);
				}
				var html = thumbs_categories
					.replace(/\{pagination\}/g, html_pagination)
					.replace(/\{thumbs\}/g, html_thumbs);
				marker.bindPopup(html);
			}
		}
		$('body').on('click', '#thumbs_pagination a', function()
		{
			var button = $(this).attr('id').replace('thumbs_pagination_', '');
			var text = $('#thumbs_pagination span').text().split('/');
			var current = parseInt(text[0]);
			var count = parseInt(text[1]);
			var item = current + (button == 'prev' ? -1 : 1);

			$('#popup_' + current).hide();
			$('#popup_' + item).show();

			$('#thumbs_pagination_' + (button == 'prev' ? 'next' : 'prev'))
				.css('visibility', 'visible');
			if ((button == 'prev' && item == 1) || (button == 'next' && item == count))
			{
				$('#thumbs_pagination_' + button).css('visibility', 'hidden');
			}

			$('#thumbs_pagination span').text(item + '/' + count);

			return false;
		});
	}
});



/**
 * Votes.
 *
 */
jQuery(function($)
{
	if (!$('#item_user_note').length)
	{
		return;
	}

	var empty = $('#item_rating').attr('data-rating-empty');
	var half = $('#item_rating').attr('data-rating-half');
	var full = $('#item_rating').attr('data-rating-full');
	var current_rating_text = [];
	var click = false;

	function current()
	{
		current_rating_text = [];
		$('#item_user_note .rating').each(function()
		{
			current_rating_text.push($(this).text());
		});
	}

	function update(r)
	{
		for (var i = 0; i < r.rating_array.length; i++)
		{
			$('#item_note span[data-rating="' + (i + 1) + '"]').text(
				r.rating_array[i] == 1 ? full : (r.rating_array[i] == 0 ? empty : half)
			);
		}
		$('#item_rating_votes').text(r.votes_short);
		$('#item_note_formated').text(r.rating);
		current();
		diaporama_reload();
	}

	function vote_click()
	{
		if (click || $('#item_user_note').attr('data-rating') == $(this).attr('data-rating'))
		{
			return false;
		}
		var rating = $(this).attr('data-rating');
		click = true;
		$.post(gallery_path + '/ajax.php', {
			section: 'vote-add',
			anticsrf: anticsrf,
			rating: rating,
			item_id: item_id
		},
		function(r)
		{
			if (r === null)
			{
				return;
			}
			switch (r.status)
			{
				case 'success' :
					$('#item_user_note_delete').removeClass('hidden');

					var n = 1;
					$('#item_user_note .rating').each(function()
					{
						$(this).text(n > rating ? empty : full);
						n++;
					});

					update(r);
					$('#item_user_note').attr('data-rating', rating);

					// Si on se trouve dans la section des fichiers les mieux
					// notés, on recharge la page car le fichier ne se trouve
					// plus forcément à la même position dans cette section,
					// ce qui ne chargerait pas la bonne image au lancement
					// du diaporama si on ne le faisait pas.
					if (q_pageless.match(/\/votes\/\d+$/))
					{
						page_reload();
					}
					break;

				case 'error' :
					alert('error: ' + r.message);
					break;
			}
			click = false;
		}, 'json');

		return false;
	}

	function vote_delete()
	{
		if (click)
		{
			return false;
		}
		click = true;
		$.post(gallery_path + '/ajax.php', {
			section: 'vote-remove',
			anticsrf: anticsrf,
			item_id: item_id
		},
		function(r)
		{
			if (r === null)
			{
				return;
			}
			switch (r.status)
			{
				case 'success' :
					$('#item_user_note .rating').text(empty);
					$('#item_user_note_delete').addClass('hidden');

					update(r);
					$('#item_user_note').attr('data-rating', 0);
					$('#item_user_note > span a[data-rating="1"]').focus();

					if (q_pageless.match(/\/votes\/\d+$/))
					{
						page_reload();
					}
					break;

				case 'error' :
					alert('error: ' + r.message);
					break;
			}
			click = false;
		}, 'json');

		return false;
	}

	function vote_in()
	{
		if (!click)
		{
			var rating = $(this).attr('data-rating');
			var n = 1;
			$('#item_user_note .rating').each(function()
			{
				$(this).text(n > rating ? empty : full);
				n++;
			});
		}
	}

	function vote_out()
	{
		if (!click)
		{
			var i = 0;
			$('#item_user_note .rating').each(function()
			{
				$(this).text(current_rating_text[i]);
				i++;
			});
		}
	}

	current();
	$('#item_user_note .rating').on('mouseenter', vote_in).on('click', vote_click);
	$('#item_user_note > span').on('mouseleave', vote_out);
	$('#item_user_note_delete').on('click', vote_delete);
});



/**
 * Ajout de fichiers.
 *
 */
jQuery(function($)
{
	if ($('body').attr('id') != 'section_user_upload' || !$('#upload').length)
	{
		return;
	}

	// Envoi de fichiers.
	var upload = new Upload('upload_', upload_options);

	// Gestion des listes d'albums.
	var select_cat_change = function()
	{
		$('#list_categories select').change(function()
		{
			var id = parseInt($(this).children('option:selected').val());
			var key = cat_list.k.indexOf(id);

			// Supprime toutes les listes enfants à partir de la liste courante.
			var i = parseInt($(this).attr('id').replace(/list_categories_/, ''));
			var n = i + 1;
			while ($('#list_categories_' + n).is('select'))
			{
				$('#list_categories_' + n).remove();
				$('#upload_sep_' + n).remove();
				n++;
			}

			// Crée la nouvelle liste enfant si c'est une catégorie.
			if (cat_list.k.includes(id) && cat_list.v[key].type == 1)
			{
				select_cat_create(id, i + 1);
			}

			// Album sélectionné.
			var n = 1;
			while ($('#list_categories_' + n).is('select'))
			{
				n++;
			}
			n--;
			var id = $('#list_categories_' + n + ' option:selected').val();
			if (key > 0 && cat_list.v[key].type == 0)
			{
				upload.options.ajaxData.album_id = id;
				var title = function(key)
				{
					var t = cat_list.v[key].title;
					var b = $(`#browse li[id*="{${cat_list.v[key].id}}"] a`);
					if (b.length)
					{
						return `<a href="${b.attr('href')}">${t}</a>`;
					}
					return t;
				};
				var html = title(key);
				var parent_id = cat_list.v[key].parent;
				var parent_key = cat_list.k.indexOf(parent_id);
				while (cat_list.k.includes(parent_id) && parent_id > 1)
				{
					html = title(parent_key) + '<span>' + cat_separator + '</span>' + html;
					parent_id = cat_list.v[parent_key].parent;
					parent_key = cat_list.k.indexOf(parent_id);
				}
				$('#select_path').removeClass().addClass('message_success').html(html);
				upload.options.albumSelected = true;
				if (!$('#upload_clear').is(':disabled'))
				{
					$('#upload_start').prop('disabled', false);
				}
				var action = $('#upload_form').attr('action');
				$('#upload_form').attr('action', action.match(/user-upload$/)
					? action + '/album/' + id
					: action.replace(/(user-upload\/album\/)\d+$/, '$1' + id));
			}
			else
			{
				upload.options.ajaxData.album_id = null;
				$('#select_path').removeClass().addClass('message_info').html(cat_text.none);
				upload.options.albumSelected = false;
				$('#upload_start').prop('disabled', true);
			}
			$('input[name="cat_id"]').val(upload.options.ajaxData.album_id);
		});
	};
	var select_cat_create = function(cat_id, i)
	{
		var list = '<select id="list_categories_' + i + '"><option>['
			+ cat_text.select + ']</option>';
		var sep = (i > 1) ? '<span id="upload_sep_' + i + '">' + cat_separator + '</span>' : '';
		for (var key in cat_list.k)
		{
			if (cat_list.v[key].parent == cat_id)
			{
				list += '<option value="' + cat_list.k[key] + '">'
					+ cat_list.v[key].title + '</option>';
			}
		}
		list += '</select>';
		$('#list_categories').append(sep + list);
		select_cat_change();
	};

	// Initialisation.
	select_cat_create(1, 1);
	$('#list_categories_1').focus();

	// Album auto-sélectionné.
	var autoselect = parseInt($('input[name="cat_id"]').val());
	if (cat_list.k.includes(autoselect))
	{
		var key = cat_list.k.indexOf(autoselect);
		var parent_id = cat_list.v[key].parent;
		var parents = [];
		while (cat_list.k.includes(parent_id) && parent_id > 1)
		{
			parents.push(parent_id);
			key = cat_list.k.indexOf(parent_id);
			parent_id = cat_list.v[key].parent;
		}
		var n = 2;
		for (var i = parents.length - 1; i > -1; i--)
		{
			select_cat_create(parents[i], n);
			$('#list_categories_' + (n - 1) + ' option[value="' + parents[i] + '"]')
				.prop('selected', true);
			n++;
		}
		$('#list_categories_' + (n-1) + ' option[value="' + autoselect + '"]')
			.prop('selected', true);
		$('#list_categories_' + (n-1)).change();
	}
});



/**
 * Page de gestion de l'avatar.
 *
 */
jQuery(function($)
{
	if (!$('#member_page_edit_avatar').length)
	{
		return;
	}

	// Vérification du poids du fichier.
	$('#avatar_change').submit(function()
	{
		var ok = true;
		$(this).find('input[type="file"]').each(function()
		{
			if ($(this).attr('data-maxsize'))
			{
				if (this.files[0].size > parseInt($(this).attr('data-maxsize')))
				{
					alert(htmldecode(maxsize_text));
					ok = false;
				}
			}
		});
		return ok;
	});
});
