<?php

declare(strict_types=1);

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

namespace ILIAS\MediaObjects;

use ILIAS\MediaObjects\ImageMap\ImageMapEditSessionRepository;
use ILIAS\MediaObjects\Usage\UsageDBRepository;

/**
 * Repository internal repo service
 * @author Alexander Killing <killing@leifos.de>
 */
class InternalRepoService
{
    protected InternalDataService $data;
    protected \ilDBInterface $db;

    public function __construct(InternalDataService $data, \ilDBInterface $db)
    {
        $this->data = $data;
        $this->db = $db;
    }

    /*
    public function ...() : ...\RepoService
    {
        return new ...\RepoService(
            $this->data,
            $this->db
        );
    }*/

    public function imageMap(): ImageMapEditSessionRepository
    {
        return new ImageMapEditSessionRepository();
    }

    public function usage(): UsageDBRepository
    {
        return new UsageDBRepository($this->db);
    }
}
