<?php

/**
 * This file is part of ILIAS, a powerful learning management system
 * published by ILIAS open source e-Learning e.V.
 *
 * ILIAS is licensed with the GPL-3.0,
 * see https://www.gnu.org/licenses/gpl-3.0.en.html
 * You should have received a copy of said license along with the
 * source code, too.
 *
 * If this is not the case or you just want to try ILIAS, you'll find
 * us at:
 * https://www.ilias.de
 * https://github.com/ILIAS-eLearning
 *
 *********************************************************************/

declare(strict_types=1);

use ILIAS\Setup;
use ILIAS\Setup\Config;

class ilMDSetupAgent extends Setup\Agent\NullAgent
{
    public function getUpdateObjective(Setup\Config $config = null): Setup\Objective
    {
        return new Setup\ObjectiveCollection(
            'MetaData',
            false,
            new ilDatabaseUpdateStepsExecutedObjective(new ilMDLOMUpdateSteps()),
            new ilDatabaseUpdateStepsExecutedObjective(new ilMDCopyrightUpdateSteps())
        );
    }

    public function getStatusObjective(Setup\Metrics\Storage $storage): Setup\Objective
    {
        return new Setup\ObjectiveCollection(
            'Component MetaData',
            true,
            new ilDatabaseUpdateStepsMetricsCollectedObjective($storage, new ilMDCopyrightUpdateSteps()),
            new ilDatabaseUpdateStepsMetricsCollectedObjective($storage, new ilMDLOMUpdateSteps())
        );
    }

    public function getMigrations(): array
    {
        return [new ilMDCopyrightMigration(), new ilMDLOMConformanceMigration()];
    }
}
