# Development

A general overview on our processes can be found in the [development guide](https://docu.ilias.de/goto_docu_pg_211_42.html) and the [community FAQs](https://docu.ilias.de/goto_docu_wiki_wpage_4276_5307.html).

## Contributing

- [Contributing](contributing.md): How to contribute to ILIAS with pull requests, bug reports, features requests, testing and more
- [Documentation](docs-guidelines.md): How to provide documentation like guidelines, how-tos, APIs, tutorials or examples

## Maintenance

- [Maintenance](maintenance.md): How the source code is maintained
- [Coordinators](maintenance-coordinator.md): Detailed information on the coordinator model which is being used for some important libraries and services
- [Supported Versions](supported-versions.md): When new versions of ILIAS are released and how long they are supported

## Coding

- [Git introduction](https://docu.ilias.de/goto_docu_pg_15604_42.html)
- [Git Hooks](git-hooks.md)
- [Accessibility Guidelines](accessibility.md): Foster an accessible user interface
- [Accessibility Process](accessibility-process.md): Describes, who is involved, which tools the community uses and
  how different activities are incorporated to achieve better accessibility in our release cycle.
- About [Refactorings](refactorings.md)

### Server Side (PHP)

- [PHP Coding Guidelines](coding-style.md): PSR-2 based coding style guidelines for PHP
- [Namespaces](namespaces.md): Guidelines for using namespaces.
- [Basic Architecture](https://docu.ilias.de/goto_docu_pg_199_42.html): Slightly outdated, but still relevant. Additionally code is going into our core libraries in the [src directory](../../src/README.md).
- [PHP Unit Tests](../../tests/README.md): How to write PHP unit tests
- [Dependency Management](../../libs/README.md): Managing dependencies to third party PHP and JS libs.
- [Input Processing](input-processing.md): Securely process user input
- [API overview](api-overview.md): Overview on APIs and services

### Client Side (Javascript)

- [Javascript Coding Guidelines](js-coding-style.md): Airbnb based coding style guidelines for Javascript
- [Javascript Unit Tests](js/js-unit-test.md): How to write Javascript unit tests
- [Javascript Modules](js/js-modules.md): How to modularise your Javascript code
- [Javascript Bundling](js/js-bundling.md): How to bundle your Javascript code files
- [Javascript Third-Party Libs](js-libraries.md): Managing Javascript third-party libs or frameworks
